// CheckStyle: start generated
package com.oracle.truffle.js.nodes.unary;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.CompilerDirectives.CompilationFinal;
import com.oracle.truffle.api.dsl.GeneratedBy;
import com.oracle.truffle.api.dsl.Introspection;
import com.oracle.truffle.api.dsl.UnsupportedSpecializationException;
import com.oracle.truffle.api.dsl.Introspection.Provider;
import com.oracle.truffle.api.interop.InteropLibrary;
import com.oracle.truffle.api.library.LibraryFactory;
import com.oracle.truffle.api.nodes.ExplodeLoop;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.nodes.NodeCost;
import com.oracle.truffle.api.object.DynamicObject;
import com.oracle.truffle.api.object.Shape;
import com.oracle.truffle.js.nodes.JSGuards;
import com.oracle.truffle.js.nodes.JSTypes;
import com.oracle.truffle.js.nodes.unary.JSIsArrayNode;
import com.oracle.truffle.js.runtime.builtins.JSClass;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.concurrent.locks.Lock;

@GeneratedBy(JSIsArrayNode.class)
public final class JSIsArrayNodeGen extends JSIsArrayNode implements Provider {

    private static final LibraryFactory<InteropLibrary> INTEROP_LIBRARY_ = LibraryFactory.resolve(InteropLibrary.class);

    @CompilationFinal private int state_;
    @CompilationFinal private int exclude_;
    @CompilationFinal private IsArrayShapeData isArrayShape_cache;
    @CompilationFinal private IsArrayJSClassData isArrayJSClass_cache;
    @Child private InteropLibrary foreign_interop_;

    private JSIsArrayNodeGen(boolean jsType) {
        super(jsType);
    }

    @ExplodeLoop
    @Override
    public boolean execute(Object arg0Value) {
        int state = state_;
        if ((state & 0b11111) != 0 /* is-active doIsArrayShape(DynamicObject, Shape, boolean, boolean, boolean) || doIsArrayJSClass(DynamicObject, JSClass, boolean, boolean) || doJSArray(DynamicObject) || doJSProxy(DynamicObject) || doJSObject(DynamicObject) */ && JSTypes.isDynamicObject(arg0Value)) {
            DynamicObject arg0Value_ = (DynamicObject) arg0Value;
            if ((state & 0b1) != 0 /* is-active doIsArrayShape(DynamicObject, Shape, boolean, boolean, boolean) */) {
                IsArrayShapeData s1_ = this.isArrayShape_cache;
                while (s1_ != null) {
                    assert (s1_.cachedIsJSObject_);
                    assert (!(s1_.cachedIsProxy_));
                    if ((s1_.cachedShape_.check(arg0Value_))) {
                        return JSIsArrayNode.doIsArrayShape(arg0Value_, s1_.cachedShape_, s1_.cachedIsJSObject_, s1_.cachedIsArray_, s1_.cachedIsProxy_);
                    }
                    s1_ = s1_.next_;
                }
            }
            if ((state & 0b10) != 0 /* is-active doIsArrayJSClass(DynamicObject, JSClass, boolean, boolean) */) {
                IsArrayJSClassData s2_ = this.isArrayJSClass_cache;
                while (s2_ != null) {
                    assert (!(s2_.cachedIsProxy_));
                    assert (s2_.cachedClass_ != null);
                    if ((s2_.cachedClass_.isInstance(arg0Value_))) {
                        return JSIsArrayNode.doIsArrayJSClass(arg0Value_, s2_.cachedClass_, s2_.cachedIsArray_, s2_.cachedIsProxy_);
                    }
                    s2_ = s2_.next_;
                }
            }
            if ((state & 0b100) != 0 /* is-active doJSArray(DynamicObject) */) {
                if ((JSGuards.isJSArray(arg0Value_))) {
                    return doJSArray(arg0Value_);
                }
            }
            if ((state & 0b1000) != 0 /* is-active doJSProxy(DynamicObject) */) {
                if ((JSGuards.isJSProxy(arg0Value_))) {
                    return doJSProxy(arg0Value_);
                }
            }
            if ((state & 0b10000) != 0 /* is-active doJSObject(DynamicObject) */) {
                if ((JSGuards.isJSType(arg0Value_)) && (!(JSGuards.isJSArray(arg0Value_))) && (!(JSGuards.isJSProxy(arg0Value_)))) {
                    return doJSObject(arg0Value_);
                }
            }
        }
        if ((state & 0b1100000) != 0 /* is-active doNotObject(Object) || doForeign(Object, InteropLibrary) */) {
            if ((state & 0b100000) != 0 /* is-active doNotObject(Object) */) {
                if ((!(JSGuards.isJSType(arg0Value)))) {
                    assert (jsType);
                    return doNotObject(arg0Value);
                }
            }
            if ((state & 0b1000000) != 0 /* is-active doForeign(Object, InteropLibrary) */) {
                if ((!(JSGuards.isJSType(arg0Value)))) {
                    assert (!(jsType));
                    return doForeign(arg0Value, this.foreign_interop_);
                }
            }
        }
        CompilerDirectives.transferToInterpreterAndInvalidate();
        return executeAndSpecialize(arg0Value);
    }

    private boolean executeAndSpecialize(Object arg0Value) {
        Lock lock = getLock();
        boolean hasLock = true;
        lock.lock();
        int state = state_;
        int exclude = exclude_;
        try {
            if (JSTypes.isDynamicObject(arg0Value)) {
                DynamicObject arg0Value_ = (DynamicObject) arg0Value;
                if (((exclude & 0b1)) == 0 /* is-not-excluded doIsArrayShape(DynamicObject, Shape, boolean, boolean, boolean) */) {
                    int count1_ = 0;
                    IsArrayShapeData s1_ = this.isArrayShape_cache;
                    if ((state & 0b1) != 0 /* is-active doIsArrayShape(DynamicObject, Shape, boolean, boolean, boolean) */) {
                        while (s1_ != null) {
                            assert (s1_.cachedIsJSObject_);
                            assert (!(s1_.cachedIsProxy_));
                            if ((s1_.cachedShape_.check(arg0Value_))) {
                                break;
                            }
                            s1_ = s1_.next_;
                            count1_++;
                        }
                    }
                    if (s1_ == null) {
                        {
                            boolean cachedIsJSObject__ = (JSGuards.isJSObject(arg0Value_));
                            if ((cachedIsJSObject__)) {
                                boolean cachedIsProxy__ = (JSGuards.isJSProxy(arg0Value_));
                                if ((!(cachedIsProxy__))) {
                                    Shape cachedShape__ = (arg0Value_.getShape());
                                    if ((cachedShape__.check(arg0Value_)) && count1_ < (JSIsArrayNode.MAX_SHAPE_COUNT)) {
                                        s1_ = new IsArrayShapeData(isArrayShape_cache);
                                        s1_.cachedShape_ = cachedShape__;
                                        s1_.cachedIsJSObject_ = cachedIsJSObject__;
                                        s1_.cachedIsArray_ = (JSGuards.isJSArray(arg0Value_));
                                        s1_.cachedIsProxy_ = cachedIsProxy__;
                                        this.isArrayShape_cache = s1_;
                                        this.state_ = state = state | 0b1 /* add-active doIsArrayShape(DynamicObject, Shape, boolean, boolean, boolean) */;
                                    }
                                }
                            }
                        }
                    }
                    if (s1_ != null) {
                        lock.unlock();
                        hasLock = false;
                        return JSIsArrayNode.doIsArrayShape(arg0Value_, s1_.cachedShape_, s1_.cachedIsJSObject_, s1_.cachedIsArray_, s1_.cachedIsProxy_);
                    }
                }
                if (((exclude & 0b10)) == 0 /* is-not-excluded doIsArrayJSClass(DynamicObject, JSClass, boolean, boolean) */) {
                    int count2_ = 0;
                    IsArrayJSClassData s2_ = this.isArrayJSClass_cache;
                    if ((state & 0b10) != 0 /* is-active doIsArrayJSClass(DynamicObject, JSClass, boolean, boolean) */) {
                        while (s2_ != null) {
                            assert (!(s2_.cachedIsProxy_));
                            assert (s2_.cachedClass_ != null);
                            if ((s2_.cachedClass_.isInstance(arg0Value_))) {
                                break;
                            }
                            s2_ = s2_.next_;
                            count2_++;
                        }
                    }
                    if (s2_ == null) {
                        {
                            boolean cachedIsProxy__ = (JSGuards.isJSProxy(arg0Value_));
                            if ((!(cachedIsProxy__))) {
                                JSClass cachedClass__ = (JSGuards.getJSClassChecked(arg0Value_));
                                if ((cachedClass__ != null) && (cachedClass__.isInstance(arg0Value_)) && count2_ < (JSIsArrayNode.MAX_JSCLASS_COUNT)) {
                                    s2_ = new IsArrayJSClassData(isArrayJSClass_cache);
                                    s2_.cachedClass_ = cachedClass__;
                                    s2_.cachedIsArray_ = (JSGuards.isJSArray(arg0Value_));
                                    s2_.cachedIsProxy_ = cachedIsProxy__;
                                    this.isArrayJSClass_cache = s2_;
                                    this.exclude_ = exclude = exclude | 0b1 /* add-excluded doIsArrayShape(DynamicObject, Shape, boolean, boolean, boolean) */;
                                    this.isArrayShape_cache = null;
                                    state = state & 0xfffffffe /* remove-active doIsArrayShape(DynamicObject, Shape, boolean, boolean, boolean) */;
                                    this.state_ = state = state | 0b10 /* add-active doIsArrayJSClass(DynamicObject, JSClass, boolean, boolean) */;
                                }
                            }
                        }
                    }
                    if (s2_ != null) {
                        lock.unlock();
                        hasLock = false;
                        return JSIsArrayNode.doIsArrayJSClass(arg0Value_, s2_.cachedClass_, s2_.cachedIsArray_, s2_.cachedIsProxy_);
                    }
                }
                if ((JSGuards.isJSArray(arg0Value_))) {
                    this.exclude_ = exclude = exclude | 0b11 /* add-excluded doIsArrayShape(DynamicObject, Shape, boolean, boolean, boolean), doIsArrayJSClass(DynamicObject, JSClass, boolean, boolean) */;
                    this.isArrayShape_cache = null;
                    this.isArrayJSClass_cache = null;
                    state = state & 0xfffffffc /* remove-active doIsArrayShape(DynamicObject, Shape, boolean, boolean, boolean), doIsArrayJSClass(DynamicObject, JSClass, boolean, boolean) */;
                    this.state_ = state = state | 0b100 /* add-active doJSArray(DynamicObject) */;
                    lock.unlock();
                    hasLock = false;
                    return doJSArray(arg0Value_);
                }
                if ((JSGuards.isJSProxy(arg0Value_))) {
                    this.state_ = state = state | 0b1000 /* add-active doJSProxy(DynamicObject) */;
                    lock.unlock();
                    hasLock = false;
                    return doJSProxy(arg0Value_);
                }
                if ((JSGuards.isJSType(arg0Value_)) && (!(JSGuards.isJSArray(arg0Value_))) && (!(JSGuards.isJSProxy(arg0Value_)))) {
                    this.exclude_ = exclude = exclude | 0b11 /* add-excluded doIsArrayShape(DynamicObject, Shape, boolean, boolean, boolean), doIsArrayJSClass(DynamicObject, JSClass, boolean, boolean) */;
                    this.isArrayShape_cache = null;
                    this.isArrayJSClass_cache = null;
                    state = state & 0xfffffffc /* remove-active doIsArrayShape(DynamicObject, Shape, boolean, boolean, boolean), doIsArrayJSClass(DynamicObject, JSClass, boolean, boolean) */;
                    this.state_ = state = state | 0b10000 /* add-active doJSObject(DynamicObject) */;
                    lock.unlock();
                    hasLock = false;
                    return doJSObject(arg0Value_);
                }
            }
            if ((!(JSGuards.isJSType(arg0Value))) && (jsType)) {
                this.state_ = state = state | 0b100000 /* add-active doNotObject(Object) */;
                lock.unlock();
                hasLock = false;
                return doNotObject(arg0Value);
            }
            if ((!(JSGuards.isJSType(arg0Value))) && (!(jsType))) {
                this.foreign_interop_ = super.insert((INTEROP_LIBRARY_.createDispatched(3)));
                this.state_ = state = state | 0b1000000 /* add-active doForeign(Object, InteropLibrary) */;
                lock.unlock();
                hasLock = false;
                return doForeign(arg0Value, this.foreign_interop_);
            }
            throw new UnsupportedSpecializationException(this, new Node[] {null}, arg0Value);
        } finally {
            if (hasLock) {
                lock.unlock();
            }
        }
    }

    @Override
    public NodeCost getCost() {
        int state = state_;
        if (state == 0b0) {
            return NodeCost.UNINITIALIZED;
        } else if ((state & (state - 1)) == 0 /* is-single-active  */) {
            IsArrayShapeData s1_ = this.isArrayShape_cache;
            IsArrayJSClassData s2_ = this.isArrayJSClass_cache;
            if ((s1_ == null || s1_.next_ == null) && (s2_ == null || s2_.next_ == null)) {
                return NodeCost.MONOMORPHIC;
            }
        }
        return NodeCost.POLYMORPHIC;
    }

    @Override
    public Introspection getIntrospectionData() {
        Object[] data = new Object[8];
        Object[] s;
        data[0] = 0;
        int state = state_;
        int exclude = exclude_;
        s = new Object[3];
        s[0] = "doIsArrayShape";
        if ((state & 0b1) != 0 /* is-active doIsArrayShape(DynamicObject, Shape, boolean, boolean, boolean) */) {
            s[1] = (byte)0b01 /* active */;
            ArrayList<Object> cached = new ArrayList<>();
            IsArrayShapeData s1_ = this.isArrayShape_cache;
            while (s1_ != null) {
                cached.add(Arrays.asList(s1_.cachedShape_, s1_.cachedIsJSObject_, s1_.cachedIsArray_, s1_.cachedIsProxy_));
                s1_ = s1_.next_;
            }
            s[2] = cached;
        } else if ((exclude & 0b1) != 0 /* is-excluded doIsArrayShape(DynamicObject, Shape, boolean, boolean, boolean) */) {
            s[1] = (byte)0b10 /* excluded */;
        } else {
            s[1] = (byte)0b00 /* inactive */;
        }
        data[1] = s;
        s = new Object[3];
        s[0] = "doIsArrayJSClass";
        if ((state & 0b10) != 0 /* is-active doIsArrayJSClass(DynamicObject, JSClass, boolean, boolean) */) {
            s[1] = (byte)0b01 /* active */;
            ArrayList<Object> cached = new ArrayList<>();
            IsArrayJSClassData s2_ = this.isArrayJSClass_cache;
            while (s2_ != null) {
                cached.add(Arrays.asList(s2_.cachedClass_, s2_.cachedIsArray_, s2_.cachedIsProxy_));
                s2_ = s2_.next_;
            }
            s[2] = cached;
        } else if ((exclude & 0b10) != 0 /* is-excluded doIsArrayJSClass(DynamicObject, JSClass, boolean, boolean) */) {
            s[1] = (byte)0b10 /* excluded */;
        } else {
            s[1] = (byte)0b00 /* inactive */;
        }
        data[2] = s;
        s = new Object[3];
        s[0] = "doJSArray";
        if ((state & 0b100) != 0 /* is-active doJSArray(DynamicObject) */) {
            s[1] = (byte)0b01 /* active */;
        } else {
            s[1] = (byte)0b00 /* inactive */;
        }
        data[3] = s;
        s = new Object[3];
        s[0] = "doJSProxy";
        if ((state & 0b1000) != 0 /* is-active doJSProxy(DynamicObject) */) {
            s[1] = (byte)0b01 /* active */;
        } else {
            s[1] = (byte)0b00 /* inactive */;
        }
        data[4] = s;
        s = new Object[3];
        s[0] = "doJSObject";
        if ((state & 0b10000) != 0 /* is-active doJSObject(DynamicObject) */) {
            s[1] = (byte)0b01 /* active */;
        } else {
            s[1] = (byte)0b00 /* inactive */;
        }
        data[5] = s;
        s = new Object[3];
        s[0] = "doNotObject";
        if ((state & 0b100000) != 0 /* is-active doNotObject(Object) */) {
            s[1] = (byte)0b01 /* active */;
        } else {
            s[1] = (byte)0b00 /* inactive */;
        }
        data[6] = s;
        s = new Object[3];
        s[0] = "doForeign";
        if ((state & 0b1000000) != 0 /* is-active doForeign(Object, InteropLibrary) */) {
            s[1] = (byte)0b01 /* active */;
            ArrayList<Object> cached = new ArrayList<>();
            cached.add(Arrays.asList(this.foreign_interop_));
            s[2] = cached;
        } else {
            s[1] = (byte)0b00 /* inactive */;
        }
        data[7] = s;
        return Provider.create(data);
    }

    public static JSIsArrayNode create(boolean jsType) {
        return new JSIsArrayNodeGen(jsType);
    }

    @GeneratedBy(JSIsArrayNode.class)
    private static final class IsArrayShapeData {

        @CompilationFinal IsArrayShapeData next_;
        @CompilationFinal Shape cachedShape_;
        @CompilationFinal boolean cachedIsJSObject_;
        @CompilationFinal boolean cachedIsArray_;
        @CompilationFinal boolean cachedIsProxy_;

        IsArrayShapeData(IsArrayShapeData next_) {
            this.next_ = next_;
        }

    }
    @GeneratedBy(JSIsArrayNode.class)
    private static final class IsArrayJSClassData {

        @CompilationFinal IsArrayJSClassData next_;
        @CompilationFinal JSClass cachedClass_;
        @CompilationFinal boolean cachedIsArray_;
        @CompilationFinal boolean cachedIsProxy_;

        IsArrayJSClassData(IsArrayJSClassData next_) {
            this.next_ = next_;
        }

    }
}
