// CheckStyle: start generated
package com.oracle.truffle.js.nodes.function;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.CompilerDirectives.CompilationFinal;
import com.oracle.truffle.api.dsl.GeneratedBy;
import com.oracle.truffle.api.dsl.Introspection;
import com.oracle.truffle.api.dsl.UnsupportedSpecializationException;
import com.oracle.truffle.api.dsl.Introspection.Provider;
import com.oracle.truffle.api.nodes.ExplodeLoop;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.nodes.NodeCost;
import com.oracle.truffle.api.object.DynamicObject;
import com.oracle.truffle.api.object.Shape;
import com.oracle.truffle.api.profiles.BranchProfile;
import com.oracle.truffle.js.nodes.JSGuards;
import com.oracle.truffle.js.nodes.JSTypes;
import com.oracle.truffle.js.nodes.function.SpecializedNewObjectNode;
import com.oracle.truffle.js.runtime.JSContext;
import com.oracle.truffle.js.runtime.JSTruffleOptions;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.concurrent.locks.Lock;

@GeneratedBy(SpecializedNewObjectNode.class)
public final class SpecializedNewObjectNodeGen extends SpecializedNewObjectNode implements Provider {

    @CompilationFinal private int state_;
    @CompilationFinal private int exclude_;
    @CompilationFinal private CachedProtoData cachedProto_cache;
    @CompilationFinal private BranchProfile uncachedProto_slowBranch_;

    private SpecializedNewObjectNodeGen(JSContext context, boolean isBuiltin, boolean isConstructor, boolean isGenerator, boolean isAsyncGenerator) {
        super(context, isBuiltin, isConstructor, isGenerator, isAsyncGenerator);
    }

    @ExplodeLoop
    @Override
    protected DynamicObject execute(DynamicObject arg0Value, Object arg1Value) {
        int state = state_;
        if (state != 0 /* is-active doCachedProto(DynamicObject, DynamicObject, DynamicObject, Shape) || doUncachedProto(DynamicObject, DynamicObject, BranchProfile) || createWithProto(DynamicObject, DynamicObject) || createDefaultProto(DynamicObject, Object) || builtinConstructor(DynamicObject, Object) || throwNotConstructorFunctionTypeError(DynamicObject, Object) */) {
            if ((state & 0b111) != 0 /* is-active doCachedProto(DynamicObject, DynamicObject, DynamicObject, Shape) || doUncachedProto(DynamicObject, DynamicObject, BranchProfile) || createWithProto(DynamicObject, DynamicObject) */ && JSTypes.isDynamicObject(arg1Value)) {
                DynamicObject arg1Value_ = (DynamicObject) arg1Value;
                if ((state & 0b1) != 0 /* is-active doCachedProto(DynamicObject, DynamicObject, DynamicObject, Shape) */) {
                    assert (!(isBuiltin));
                    assert (isConstructor);
                    assert (!(context.isMultiContext()));
                    CachedProtoData s1_ = this.cachedProto_cache;
                    while (s1_ != null) {
                        assert (JSGuards.isJSObject(s1_.cachedPrototype_));
                        if ((arg1Value_ == s1_.cachedPrototype_)) {
                            return doCachedProto(arg0Value, arg1Value_, s1_.cachedPrototype_, s1_.shape_);
                        }
                        s1_ = s1_.next_;
                    }
                }
                if ((state & 0b10) != 0 /* is-active doUncachedProto(DynamicObject, DynamicObject, BranchProfile) */) {
                    assert (!(isBuiltin));
                    assert (isConstructor);
                    assert (!(context.isMultiContext()));
                    if ((JSGuards.isJSObject(arg1Value_))) {
                        return doUncachedProto(arg0Value, arg1Value_, this.uncachedProto_slowBranch_);
                    }
                }
                if ((state & 0b100) != 0 /* is-active createWithProto(DynamicObject, DynamicObject) */) {
                    assert (!(isBuiltin));
                    assert (isConstructor);
                    assert (context.isMultiContext());
                    if ((JSGuards.isJSObject(arg1Value_))) {
                        return createWithProto(arg0Value, arg1Value_);
                    }
                }
            }
            if ((state & 0b111000) != 0 /* is-active createDefaultProto(DynamicObject, Object) || builtinConstructor(DynamicObject, Object) || throwNotConstructorFunctionTypeError(DynamicObject, Object) */) {
                if ((state & 0b1000) != 0 /* is-active createDefaultProto(DynamicObject, Object) */) {
                    assert (!(isBuiltin));
                    assert (isConstructor);
                    if ((!(JSGuards.isJSObject(arg1Value)))) {
                        return createDefaultProto(arg0Value, arg1Value);
                    }
                }
                if ((state & 0b10000) != 0 /* is-active builtinConstructor(DynamicObject, Object) */) {
                    assert (isBuiltin);
                    assert (isConstructor);
                    return SpecializedNewObjectNode.builtinConstructor(arg0Value, arg1Value);
                }
                if ((state & 0b100000) != 0 /* is-active throwNotConstructorFunctionTypeError(DynamicObject, Object) */) {
                    assert (!(isConstructor));
                    return throwNotConstructorFunctionTypeError(arg0Value, arg1Value);
                }
            }
        }
        CompilerDirectives.transferToInterpreterAndInvalidate();
        return executeAndSpecialize(arg0Value, arg1Value);
    }

    private DynamicObject executeAndSpecialize(DynamicObject arg0Value, Object arg1Value) {
        Lock lock = getLock();
        boolean hasLock = true;
        lock.lock();
        int state = state_;
        int exclude = exclude_;
        int oldState = state;
        int oldExclude = exclude;
        int oldCacheCount = state == 0 ? 0 : countCaches();
        try {
            if (JSTypes.isDynamicObject(arg1Value)) {
                DynamicObject arg1Value_ = (DynamicObject) arg1Value;
                if ((exclude) == 0 /* is-not-excluded doCachedProto(DynamicObject, DynamicObject, DynamicObject, Shape) */ && (!(isBuiltin)) && (isConstructor) && (!(context.isMultiContext()))) {
                    int count1_ = 0;
                    CachedProtoData s1_ = this.cachedProto_cache;
                    if ((state & 0b1) != 0 /* is-active doCachedProto(DynamicObject, DynamicObject, DynamicObject, Shape) */) {
                        while (s1_ != null) {
                            assert (JSGuards.isJSObject(s1_.cachedPrototype_));
                            if ((arg1Value_ == s1_.cachedPrototype_)) {
                                break;
                            }
                            s1_ = s1_.next_;
                            count1_++;
                        }
                    }
                    if (s1_ == null) {
                        {
                            DynamicObject cachedPrototype__ = (arg1Value_);
                            if ((JSGuards.isJSObject(cachedPrototype__))) {
                                // assert (arg1Value_ == cachedPrototype__);
                                if (count1_ < (JSTruffleOptions.PropertyCacheLimit)) {
                                    s1_ = new CachedProtoData(cachedProto_cache);
                                    s1_.cachedPrototype_ = cachedPrototype__;
                                    s1_.shape_ = (getProtoChildShape(arg1Value_));
                                    this.cachedProto_cache = s1_;
                                    this.state_ = state = state | 0b1 /* add-active doCachedProto(DynamicObject, DynamicObject, DynamicObject, Shape) */;
                                }
                            }
                        }
                    }
                    if (s1_ != null) {
                        lock.unlock();
                        hasLock = false;
                        return doCachedProto(arg0Value, arg1Value_, s1_.cachedPrototype_, s1_.shape_);
                    }
                }
                if ((!(isBuiltin)) && (isConstructor) && (!(context.isMultiContext())) && (JSGuards.isJSObject(arg1Value_))) {
                    this.uncachedProto_slowBranch_ = (BranchProfile.create());
                    this.exclude_ = exclude = exclude | 0b1 /* add-excluded doCachedProto(DynamicObject, DynamicObject, DynamicObject, Shape) */;
                    this.cachedProto_cache = null;
                    state = state & 0xfffffffe /* remove-active doCachedProto(DynamicObject, DynamicObject, DynamicObject, Shape) */;
                    this.state_ = state = state | 0b10 /* add-active doUncachedProto(DynamicObject, DynamicObject, BranchProfile) */;
                    lock.unlock();
                    hasLock = false;
                    return doUncachedProto(arg0Value, arg1Value_, this.uncachedProto_slowBranch_);
                }
                if ((!(isBuiltin)) && (isConstructor) && (context.isMultiContext()) && (JSGuards.isJSObject(arg1Value_))) {
                    this.state_ = state = state | 0b100 /* add-active createWithProto(DynamicObject, DynamicObject) */;
                    lock.unlock();
                    hasLock = false;
                    return createWithProto(arg0Value, arg1Value_);
                }
            }
            if ((!(isBuiltin)) && (isConstructor) && (!(JSGuards.isJSObject(arg1Value)))) {
                this.state_ = state = state | 0b1000 /* add-active createDefaultProto(DynamicObject, Object) */;
                lock.unlock();
                hasLock = false;
                return createDefaultProto(arg0Value, arg1Value);
            }
            if ((isBuiltin) && (isConstructor)) {
                this.state_ = state = state | 0b10000 /* add-active builtinConstructor(DynamicObject, Object) */;
                lock.unlock();
                hasLock = false;
                return SpecializedNewObjectNode.builtinConstructor(arg0Value, arg1Value);
            }
            if ((!(isConstructor))) {
                this.state_ = state = state | 0b100000 /* add-active throwNotConstructorFunctionTypeError(DynamicObject, Object) */;
                lock.unlock();
                hasLock = false;
                return throwNotConstructorFunctionTypeError(arg0Value, arg1Value);
            }
            throw new UnsupportedSpecializationException(this, new Node[] {null, null}, arg0Value, arg1Value);
        } finally {
            if (oldState != 0 || oldExclude != 0) {
                checkForPolymorphicSpecialize(oldState, oldExclude, oldCacheCount);
            }
            if (hasLock) {
                lock.unlock();
            }
        }
    }

    private void checkForPolymorphicSpecialize(int oldState, int oldExclude, int oldCacheCount) {
        int newState = this.state_;
        int newExclude = this.exclude_;
        if ((oldState ^ newState) != 0 || (oldExclude ^ newExclude) != 0 || oldCacheCount < countCaches()) {
            this.reportPolymorphicSpecialize();
        }
    }

    private int countCaches() {
        int cacheCount = 0;
        CachedProtoData s1_ = this.cachedProto_cache;
        while (s1_ != null) {
            cacheCount++;
            s1_= s1_.next_;
        }
        return cacheCount;
    }

    @Override
    public NodeCost getCost() {
        int state = state_;
        if (state == 0b0) {
            return NodeCost.UNINITIALIZED;
        } else if ((state & (state - 1)) == 0 /* is-single-active  */) {
            CachedProtoData s1_ = this.cachedProto_cache;
            if ((s1_ == null || s1_.next_ == null)) {
                return NodeCost.MONOMORPHIC;
            }
        }
        return NodeCost.POLYMORPHIC;
    }

    @Override
    public Introspection getIntrospectionData() {
        Object[] data = new Object[7];
        Object[] s;
        data[0] = 0;
        int state = state_;
        int exclude = exclude_;
        s = new Object[3];
        s[0] = "doCachedProto";
        if ((state & 0b1) != 0 /* is-active doCachedProto(DynamicObject, DynamicObject, DynamicObject, Shape) */) {
            s[1] = (byte)0b01 /* active */;
            ArrayList<Object> cached = new ArrayList<>();
            CachedProtoData s1_ = this.cachedProto_cache;
            while (s1_ != null) {
                cached.add(Arrays.asList(s1_.cachedPrototype_, s1_.shape_));
                s1_ = s1_.next_;
            }
            s[2] = cached;
        } else if (exclude != 0 /* is-excluded doCachedProto(DynamicObject, DynamicObject, DynamicObject, Shape) */) {
            s[1] = (byte)0b10 /* excluded */;
        } else {
            s[1] = (byte)0b00 /* inactive */;
        }
        data[1] = s;
        s = new Object[3];
        s[0] = "doUncachedProto";
        if ((state & 0b10) != 0 /* is-active doUncachedProto(DynamicObject, DynamicObject, BranchProfile) */) {
            s[1] = (byte)0b01 /* active */;
            ArrayList<Object> cached = new ArrayList<>();
            cached.add(Arrays.asList(this.uncachedProto_slowBranch_));
            s[2] = cached;
        } else {
            s[1] = (byte)0b00 /* inactive */;
        }
        data[2] = s;
        s = new Object[3];
        s[0] = "createWithProto";
        if ((state & 0b100) != 0 /* is-active createWithProto(DynamicObject, DynamicObject) */) {
            s[1] = (byte)0b01 /* active */;
        } else {
            s[1] = (byte)0b00 /* inactive */;
        }
        data[3] = s;
        s = new Object[3];
        s[0] = "createDefaultProto";
        if ((state & 0b1000) != 0 /* is-active createDefaultProto(DynamicObject, Object) */) {
            s[1] = (byte)0b01 /* active */;
        } else {
            s[1] = (byte)0b00 /* inactive */;
        }
        data[4] = s;
        s = new Object[3];
        s[0] = "builtinConstructor";
        if ((state & 0b10000) != 0 /* is-active builtinConstructor(DynamicObject, Object) */) {
            s[1] = (byte)0b01 /* active */;
        } else {
            s[1] = (byte)0b00 /* inactive */;
        }
        data[5] = s;
        s = new Object[3];
        s[0] = "throwNotConstructorFunctionTypeError";
        if ((state & 0b100000) != 0 /* is-active throwNotConstructorFunctionTypeError(DynamicObject, Object) */) {
            s[1] = (byte)0b01 /* active */;
        } else {
            s[1] = (byte)0b00 /* inactive */;
        }
        data[6] = s;
        return Provider.create(data);
    }

    public static SpecializedNewObjectNode create(JSContext context, boolean isBuiltin, boolean isConstructor, boolean isGenerator, boolean isAsyncGenerator) {
        return new SpecializedNewObjectNodeGen(context, isBuiltin, isConstructor, isGenerator, isAsyncGenerator);
    }

    @GeneratedBy(SpecializedNewObjectNode.class)
    private static final class CachedProtoData {

        @CompilationFinal CachedProtoData next_;
        @CompilationFinal DynamicObject cachedPrototype_;
        @CompilationFinal Shape shape_;

        CachedProtoData(CachedProtoData next_) {
            this.next_ = next_;
        }

    }
}
