// CheckStyle: start generated
package com.oracle.truffle.js.nodes.cast;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.CompilerDirectives.CompilationFinal;
import com.oracle.truffle.api.dsl.GeneratedBy;
import com.oracle.truffle.api.dsl.Introspection;
import com.oracle.truffle.api.dsl.UnsupportedSpecializationException;
import com.oracle.truffle.api.dsl.Introspection.Provider;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.nodes.ExplodeLoop;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.nodes.NodeCost;
import com.oracle.truffle.api.object.DynamicObject;
import com.oracle.truffle.api.object.Shape;
import com.oracle.truffle.js.nodes.JSGuards;
import com.oracle.truffle.js.nodes.JSTypes;
import com.oracle.truffle.js.nodes.JSTypesGen;
import com.oracle.truffle.js.nodes.JavaScriptNode;
import com.oracle.truffle.js.nodes.cast.JSToObjectNode;
import com.oracle.truffle.js.runtime.BigInt;
import com.oracle.truffle.js.runtime.JSContext;
import com.oracle.truffle.js.runtime.Symbol;
import com.oracle.truffle.js.runtime.builtins.JSClass;
import com.oracle.truffle.js.runtime.objects.JSLazyString;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.concurrent.locks.Lock;

@GeneratedBy(JSToObjectNode.class)
public final class JSToObjectNodeGen extends JSToObjectNode implements Provider {

    @CompilationFinal private int state_;
    @CompilationFinal private int exclude_;
    @CompilationFinal private JSObjectNoCheckShapeData jSObjectNoCheckShape_cache;
    @CompilationFinal private JSObjectCheckShapeData jSObjectCheckShape_cache;
    @CompilationFinal private JSClass jSObjectCheckJSClass_cachedClass_;

    private JSToObjectNodeGen(JSContext context, boolean checkForNullOrUndefined, boolean fromWith, boolean allowForeign) {
        super(context, checkForNullOrUndefined, fromWith, allowForeign);
    }

    @ExplodeLoop
    @Override
    public Object execute(Object arg0Value) {
        int state = state_;
        if ((state & 0b1) != 0 /* is-active doBoolean(boolean) */ && arg0Value instanceof Boolean) {
            boolean arg0Value_ = (boolean) arg0Value;
            return doBoolean(arg0Value_);
        }
        if ((state & 0b10) != 0 /* is-active doJSLazyString(JSLazyString) */ && arg0Value instanceof JSLazyString) {
            JSLazyString arg0Value_ = (JSLazyString) arg0Value;
            return doJSLazyString(arg0Value_);
        }
        if ((state & 0b100) != 0 /* is-active doString(String) */ && JSTypesGen.isImplicitString((state & 0xf0000) >>> 16 /* extract-implicit-active 0:String */, arg0Value)) {
            String arg0Value_ = JSTypesGen.asImplicitString((state & 0xf0000) >>> 16 /* extract-implicit-active 0:String */, arg0Value);
            return doString(arg0Value_);
        }
        if ((state & 0b1000) != 0 /* is-active doInt(int) */ && arg0Value instanceof Integer) {
            int arg0Value_ = (int) arg0Value;
            return doInt(arg0Value_);
        }
        if ((state & 0b10000) != 0 /* is-active doDouble(double) */ && JSTypesGen.isImplicitDouble((state & 0xf00000) >>> 20 /* extract-implicit-active 0:double */, arg0Value)) {
            double arg0Value_ = JSTypesGen.asImplicitDouble((state & 0xf00000) >>> 20 /* extract-implicit-active 0:double */, arg0Value);
            return doDouble(arg0Value_);
        }
        if ((state & 0b100000) != 0 /* is-active doBigInt(BigInt) */ && arg0Value instanceof BigInt) {
            BigInt arg0Value_ = (BigInt) arg0Value;
            return doBigInt(arg0Value_);
        }
        if ((state & 0b1000000) != 0 /* is-active doNumber(Object) */) {
            if ((JSGuards.isJavaNumber(arg0Value))) {
                return doNumber(arg0Value);
            }
        }
        if ((state & 0b10000000) != 0 /* is-active doSymbol(Symbol) */ && arg0Value instanceof Symbol) {
            Symbol arg0Value_ = (Symbol) arg0Value;
            return doSymbol(arg0Value_);
        }
        if ((state & 0b11111100000000) != 0 /* is-active doJSObjectNoCheckShape(DynamicObject, Shape) || doJSObjectNoCheck(DynamicObject) || doJSObjectCheckShape(DynamicObject, Shape) || doJSObjectCheckJSClass(DynamicObject, JSClass) || doJSObjectCheck(DynamicObject) || doNullOrUndefined(DynamicObject) */ && JSTypes.isDynamicObject(arg0Value)) {
            DynamicObject arg0Value_ = (DynamicObject) arg0Value;
            if ((state & 0b100000000) != 0 /* is-active doJSObjectNoCheckShape(DynamicObject, Shape) */) {
                JSObjectNoCheckShapeData s9_ = this.jSObjectNoCheckShape_cache;
                while (s9_ != null) {
                    if ((s9_.shape_.check(arg0Value_))) {
                        assert (JSGuards.isJSObjectShape(s9_.shape_));
                        assert (!(isCheckForNullOrUndefined()));
                        return doJSObjectNoCheckShape(arg0Value_, s9_.shape_);
                    }
                    s9_ = s9_.next_;
                }
            }
            if ((state & 0b1000000000) != 0 /* is-active doJSObjectNoCheck(DynamicObject) */) {
                if ((JSGuards.isJSType(arg0Value_))) {
                    assert (!(isCheckForNullOrUndefined()));
                    return doJSObjectNoCheck(arg0Value_);
                }
            }
            if ((state & 0b10000000000) != 0 /* is-active doJSObjectCheckShape(DynamicObject, Shape) */) {
                JSObjectCheckShapeData s11_ = this.jSObjectCheckShape_cache;
                while (s11_ != null) {
                    if ((s11_.shape_.check(arg0Value_))) {
                        assert (JSGuards.isJSObjectShape(s11_.shape_));
                        assert (JSToObjectNode.isNotNullOrUndefined(s11_.shape_));
                        assert (isCheckForNullOrUndefined());
                        return doJSObjectCheckShape(arg0Value_, s11_.shape_);
                    }
                    s11_ = s11_.next_;
                }
            }
            if ((state & 0b100000000000) != 0 /* is-active doJSObjectCheckJSClass(DynamicObject, JSClass) */) {
                assert (isCheckForNullOrUndefined());
                assert (this.jSObjectCheckJSClass_cachedClass_ != null);
                if ((this.jSObjectCheckJSClass_cachedClass_.isInstance(arg0Value_))) {
                    return doJSObjectCheckJSClass(arg0Value_, this.jSObjectCheckJSClass_cachedClass_);
                }
            }
            if ((state & 0b1000000000000) != 0 /* is-active doJSObjectCheck(DynamicObject) */) {
                if ((JSGuards.isJSObject(arg0Value_))) {
                    assert (isCheckForNullOrUndefined());
                    return doJSObjectCheck(arg0Value_);
                }
            }
            if ((state & 0b10000000000000) != 0 /* is-active doNullOrUndefined(DynamicObject) */) {
                if ((JSGuards.isNullOrUndefined(arg0Value_))) {
                    assert (isCheckForNullOrUndefined());
                    return doNullOrUndefined(arg0Value_);
                }
            }
        }
        if ((state & 0b1100000000000000) != 0 /* is-active doForeignTruffleObject(Object) || doJavaGeneric(Object) */) {
            if ((state & 0b100000000000000) != 0 /* is-active doForeignTruffleObject(Object) */) {
                if ((JSGuards.isForeignObject(arg0Value))) {
                    return doForeignTruffleObject(arg0Value);
                }
            }
            if ((state & 0b1000000000000000) != 0 /* is-active doJavaGeneric(Object) */) {
                if ((!(JSGuards.isBoolean(arg0Value))) && (!(JSGuards.isNumber(arg0Value))) && (!(JSGuards.isString(arg0Value))) && (!(JSGuards.isSymbol(arg0Value))) && (!(JSGuards.isJSObject(arg0Value))) && (!(JSGuards.isForeignObject(arg0Value)))) {
                    return doJavaGeneric(arg0Value);
                }
            }
        }
        CompilerDirectives.transferToInterpreterAndInvalidate();
        return executeAndSpecialize(arg0Value);
    }

    private Object executeAndSpecialize(Object arg0Value) {
        Lock lock = getLock();
        boolean hasLock = true;
        lock.lock();
        int state = state_;
        int exclude = exclude_;
        try {
            if (arg0Value instanceof Boolean) {
                boolean arg0Value_ = (boolean) arg0Value;
                this.state_ = state = state | 0b1 /* add-active doBoolean(boolean) */;
                lock.unlock();
                hasLock = false;
                return doBoolean(arg0Value_);
            }
            if (arg0Value instanceof JSLazyString) {
                JSLazyString arg0Value_ = (JSLazyString) arg0Value;
                this.state_ = state = state | 0b10 /* add-active doJSLazyString(JSLazyString) */;
                lock.unlock();
                hasLock = false;
                return doJSLazyString(arg0Value_);
            }
            {
                int stringCast0;
                if ((stringCast0 = JSTypesGen.specializeImplicitString(arg0Value)) != 0) {
                    String arg0Value_ = JSTypesGen.asImplicitString(stringCast0, arg0Value);
                    state = (state | (stringCast0 << 16) /* set-implicit-active 0:String */);
                    this.state_ = state = state | 0b100 /* add-active doString(String) */;
                    lock.unlock();
                    hasLock = false;
                    return doString(arg0Value_);
                }
            }
            if (arg0Value instanceof Integer) {
                int arg0Value_ = (int) arg0Value;
                this.state_ = state = state | 0b1000 /* add-active doInt(int) */;
                lock.unlock();
                hasLock = false;
                return doInt(arg0Value_);
            }
            {
                int doubleCast0;
                if ((doubleCast0 = JSTypesGen.specializeImplicitDouble(arg0Value)) != 0) {
                    double arg0Value_ = JSTypesGen.asImplicitDouble(doubleCast0, arg0Value);
                    state = (state | (doubleCast0 << 20) /* set-implicit-active 0:double */);
                    this.state_ = state = state | 0b10000 /* add-active doDouble(double) */;
                    lock.unlock();
                    hasLock = false;
                    return doDouble(arg0Value_);
                }
            }
            if (arg0Value instanceof BigInt) {
                BigInt arg0Value_ = (BigInt) arg0Value;
                this.state_ = state = state | 0b100000 /* add-active doBigInt(BigInt) */;
                lock.unlock();
                hasLock = false;
                return doBigInt(arg0Value_);
            }
            if ((JSGuards.isJavaNumber(arg0Value))) {
                this.state_ = state = state | 0b1000000 /* add-active doNumber(Object) */;
                lock.unlock();
                hasLock = false;
                return doNumber(arg0Value);
            }
            if (arg0Value instanceof Symbol) {
                Symbol arg0Value_ = (Symbol) arg0Value;
                this.state_ = state = state | 0b10000000 /* add-active doSymbol(Symbol) */;
                lock.unlock();
                hasLock = false;
                return doSymbol(arg0Value_);
            }
            if (JSTypes.isDynamicObject(arg0Value)) {
                DynamicObject arg0Value_ = (DynamicObject) arg0Value;
                if (((exclude & 0b1)) == 0 /* is-not-excluded doJSObjectNoCheckShape(DynamicObject, Shape) */) {
                    int count9_ = 0;
                    JSObjectNoCheckShapeData s9_ = this.jSObjectNoCheckShape_cache;
                    if ((state & 0b100000000) != 0 /* is-active doJSObjectNoCheckShape(DynamicObject, Shape) */) {
                        while (s9_ != null) {
                            if ((s9_.shape_.check(arg0Value_))) {
                                assert (JSGuards.isJSObjectShape(s9_.shape_));
                                assert (!(isCheckForNullOrUndefined()));
                                break;
                            }
                            s9_ = s9_.next_;
                            count9_++;
                        }
                    }
                    if (s9_ == null) {
                        {
                            Shape shape__ = (arg0Value_.getShape());
                            if ((shape__.check(arg0Value_)) && (JSGuards.isJSObjectShape(shape__)) && (!(isCheckForNullOrUndefined())) && count9_ < (JSToObjectNode.MAX_SHAPE_COUNT)) {
                                s9_ = new JSObjectNoCheckShapeData(jSObjectNoCheckShape_cache);
                                s9_.shape_ = shape__;
                                this.jSObjectNoCheckShape_cache = s9_;
                                this.state_ = state = state | 0b100000000 /* add-active doJSObjectNoCheckShape(DynamicObject, Shape) */;
                            }
                        }
                    }
                    if (s9_ != null) {
                        lock.unlock();
                        hasLock = false;
                        return doJSObjectNoCheckShape(arg0Value_, s9_.shape_);
                    }
                }
                if ((JSGuards.isJSType(arg0Value_)) && (!(isCheckForNullOrUndefined()))) {
                    this.exclude_ = exclude = exclude | 0b1 /* add-excluded doJSObjectNoCheckShape(DynamicObject, Shape) */;
                    this.jSObjectNoCheckShape_cache = null;
                    state = state & 0xfffffeff /* remove-active doJSObjectNoCheckShape(DynamicObject, Shape) */;
                    this.state_ = state = state | 0b1000000000 /* add-active doJSObjectNoCheck(DynamicObject) */;
                    lock.unlock();
                    hasLock = false;
                    return doJSObjectNoCheck(arg0Value_);
                }
                if (((exclude & 0b10)) == 0 /* is-not-excluded doJSObjectCheckShape(DynamicObject, Shape) */) {
                    int count11_ = 0;
                    JSObjectCheckShapeData s11_ = this.jSObjectCheckShape_cache;
                    if ((state & 0b10000000000) != 0 /* is-active doJSObjectCheckShape(DynamicObject, Shape) */) {
                        while (s11_ != null) {
                            if ((s11_.shape_.check(arg0Value_))) {
                                assert (JSGuards.isJSObjectShape(s11_.shape_));
                                assert (JSToObjectNode.isNotNullOrUndefined(s11_.shape_));
                                assert (isCheckForNullOrUndefined());
                                break;
                            }
                            s11_ = s11_.next_;
                            count11_++;
                        }
                    }
                    if (s11_ == null) {
                        {
                            Shape shape__ = (arg0Value_.getShape());
                            if ((shape__.check(arg0Value_)) && (JSGuards.isJSObjectShape(shape__)) && (JSToObjectNode.isNotNullOrUndefined(shape__)) && (isCheckForNullOrUndefined()) && count11_ < (JSToObjectNode.MAX_SHAPE_COUNT)) {
                                s11_ = new JSObjectCheckShapeData(jSObjectCheckShape_cache);
                                s11_.shape_ = shape__;
                                this.jSObjectCheckShape_cache = s11_;
                                this.state_ = state = state | 0b10000000000 /* add-active doJSObjectCheckShape(DynamicObject, Shape) */;
                            }
                        }
                    }
                    if (s11_ != null) {
                        lock.unlock();
                        hasLock = false;
                        return doJSObjectCheckShape(arg0Value_, s11_.shape_);
                    }
                }
                if (((exclude & 0b100)) == 0 /* is-not-excluded doJSObjectCheckJSClass(DynamicObject, JSClass) */) {
                    boolean JSObjectCheckJSClass_duplicateFound_ = false;
                    if ((state & 0b100000000000) != 0 /* is-active doJSObjectCheckJSClass(DynamicObject, JSClass) */) {
                        assert (isCheckForNullOrUndefined());
                        assert (this.jSObjectCheckJSClass_cachedClass_ != null);
                        if ((this.jSObjectCheckJSClass_cachedClass_.isInstance(arg0Value_))) {
                            JSObjectCheckJSClass_duplicateFound_ = true;
                        }
                    }
                    if (!JSObjectCheckJSClass_duplicateFound_) {
                        if ((isCheckForNullOrUndefined())) {
                            JSClass jSObjectCheckJSClass_cachedClass__ = (JSGuards.getJSClassIfObject(arg0Value_));
                            if ((jSObjectCheckJSClass_cachedClass__ != null) && (jSObjectCheckJSClass_cachedClass__.isInstance(arg0Value_)) && ((state & 0b100000000000)) == 0 /* is-not-active doJSObjectCheckJSClass(DynamicObject, JSClass) */) {
                                this.jSObjectCheckJSClass_cachedClass_ = jSObjectCheckJSClass_cachedClass__;
                                this.exclude_ = exclude = exclude | 0b10 /* add-excluded doJSObjectCheckShape(DynamicObject, Shape) */;
                                this.jSObjectCheckShape_cache = null;
                                state = state & 0xfffffbff /* remove-active doJSObjectCheckShape(DynamicObject, Shape) */;
                                this.state_ = state = state | 0b100000000000 /* add-active doJSObjectCheckJSClass(DynamicObject, JSClass) */;
                                JSObjectCheckJSClass_duplicateFound_ = true;
                            }
                        }
                    }
                    if (JSObjectCheckJSClass_duplicateFound_) {
                        lock.unlock();
                        hasLock = false;
                        return doJSObjectCheckJSClass(arg0Value_, this.jSObjectCheckJSClass_cachedClass_);
                    }
                }
                if ((JSGuards.isJSObject(arg0Value_)) && (isCheckForNullOrUndefined())) {
                    this.exclude_ = exclude = exclude | 0b110 /* add-excluded doJSObjectCheckShape(DynamicObject, Shape), doJSObjectCheckJSClass(DynamicObject, JSClass) */;
                    this.jSObjectCheckShape_cache = null;
                    state = state & 0xfffff3ff /* remove-active doJSObjectCheckShape(DynamicObject, Shape), doJSObjectCheckJSClass(DynamicObject, JSClass) */;
                    this.state_ = state = state | 0b1000000000000 /* add-active doJSObjectCheck(DynamicObject) */;
                    lock.unlock();
                    hasLock = false;
                    return doJSObjectCheck(arg0Value_);
                }
                if ((JSGuards.isNullOrUndefined(arg0Value_)) && (isCheckForNullOrUndefined())) {
                    this.state_ = state = state | 0b10000000000000 /* add-active doNullOrUndefined(DynamicObject) */;
                    lock.unlock();
                    hasLock = false;
                    return doNullOrUndefined(arg0Value_);
                }
            }
            if ((JSGuards.isForeignObject(arg0Value))) {
                this.state_ = state = state | 0b100000000000000 /* add-active doForeignTruffleObject(Object) */;
                lock.unlock();
                hasLock = false;
                return doForeignTruffleObject(arg0Value);
            }
            if ((!(JSGuards.isBoolean(arg0Value))) && (!(JSGuards.isNumber(arg0Value))) && (!(JSGuards.isString(arg0Value))) && (!(JSGuards.isSymbol(arg0Value))) && (!(JSGuards.isJSObject(arg0Value))) && (!(JSGuards.isForeignObject(arg0Value)))) {
                this.state_ = state = state | 0b1000000000000000 /* add-active doJavaGeneric(Object) */;
                lock.unlock();
                hasLock = false;
                return doJavaGeneric(arg0Value);
            }
            throw new UnsupportedSpecializationException(this, new Node[] {null}, arg0Value);
        } finally {
            if (hasLock) {
                lock.unlock();
            }
        }
    }

    @Override
    public NodeCost getCost() {
        int state = state_;
        if ((state & 0b1111111111111111) == 0b0) {
            return NodeCost.UNINITIALIZED;
        } else if (((state & 0b1111111111111111) & ((state & 0b1111111111111111) - 1)) == 0 /* is-single-active  */) {
            JSObjectNoCheckShapeData s9_ = this.jSObjectNoCheckShape_cache;
            JSObjectCheckShapeData s11_ = this.jSObjectCheckShape_cache;
            if ((s9_ == null || s9_.next_ == null) && (s11_ == null || s11_.next_ == null)) {
                return NodeCost.MONOMORPHIC;
            }
        }
        return NodeCost.POLYMORPHIC;
    }

    @Override
    public Introspection getIntrospectionData() {
        Object[] data = new Object[17];
        Object[] s;
        data[0] = 0;
        int state = state_;
        int exclude = exclude_;
        s = new Object[3];
        s[0] = "doBoolean";
        if ((state & 0b1) != 0 /* is-active doBoolean(boolean) */) {
            s[1] = (byte)0b01 /* active */;
        } else {
            s[1] = (byte)0b00 /* inactive */;
        }
        data[1] = s;
        s = new Object[3];
        s[0] = "doJSLazyString";
        if ((state & 0b10) != 0 /* is-active doJSLazyString(JSLazyString) */) {
            s[1] = (byte)0b01 /* active */;
        } else {
            s[1] = (byte)0b00 /* inactive */;
        }
        data[2] = s;
        s = new Object[3];
        s[0] = "doString";
        if ((state & 0b100) != 0 /* is-active doString(String) */) {
            s[1] = (byte)0b01 /* active */;
        } else {
            s[1] = (byte)0b00 /* inactive */;
        }
        data[3] = s;
        s = new Object[3];
        s[0] = "doInt";
        if ((state & 0b1000) != 0 /* is-active doInt(int) */) {
            s[1] = (byte)0b01 /* active */;
        } else {
            s[1] = (byte)0b00 /* inactive */;
        }
        data[4] = s;
        s = new Object[3];
        s[0] = "doDouble";
        if ((state & 0b10000) != 0 /* is-active doDouble(double) */) {
            s[1] = (byte)0b01 /* active */;
        } else {
            s[1] = (byte)0b00 /* inactive */;
        }
        data[5] = s;
        s = new Object[3];
        s[0] = "doBigInt";
        if ((state & 0b100000) != 0 /* is-active doBigInt(BigInt) */) {
            s[1] = (byte)0b01 /* active */;
        } else {
            s[1] = (byte)0b00 /* inactive */;
        }
        data[6] = s;
        s = new Object[3];
        s[0] = "doNumber";
        if ((state & 0b1000000) != 0 /* is-active doNumber(Object) */) {
            s[1] = (byte)0b01 /* active */;
        } else {
            s[1] = (byte)0b00 /* inactive */;
        }
        data[7] = s;
        s = new Object[3];
        s[0] = "doSymbol";
        if ((state & 0b10000000) != 0 /* is-active doSymbol(Symbol) */) {
            s[1] = (byte)0b01 /* active */;
        } else {
            s[1] = (byte)0b00 /* inactive */;
        }
        data[8] = s;
        s = new Object[3];
        s[0] = "doJSObjectNoCheckShape";
        if ((state & 0b100000000) != 0 /* is-active doJSObjectNoCheckShape(DynamicObject, Shape) */) {
            s[1] = (byte)0b01 /* active */;
            ArrayList<Object> cached = new ArrayList<>();
            JSObjectNoCheckShapeData s9_ = this.jSObjectNoCheckShape_cache;
            while (s9_ != null) {
                cached.add(Arrays.asList(s9_.shape_));
                s9_ = s9_.next_;
            }
            s[2] = cached;
        } else if ((exclude & 0b1) != 0 /* is-excluded doJSObjectNoCheckShape(DynamicObject, Shape) */) {
            s[1] = (byte)0b10 /* excluded */;
        } else {
            s[1] = (byte)0b00 /* inactive */;
        }
        data[9] = s;
        s = new Object[3];
        s[0] = "doJSObjectNoCheck";
        if ((state & 0b1000000000) != 0 /* is-active doJSObjectNoCheck(DynamicObject) */) {
            s[1] = (byte)0b01 /* active */;
        } else {
            s[1] = (byte)0b00 /* inactive */;
        }
        data[10] = s;
        s = new Object[3];
        s[0] = "doJSObjectCheckShape";
        if ((state & 0b10000000000) != 0 /* is-active doJSObjectCheckShape(DynamicObject, Shape) */) {
            s[1] = (byte)0b01 /* active */;
            ArrayList<Object> cached = new ArrayList<>();
            JSObjectCheckShapeData s11_ = this.jSObjectCheckShape_cache;
            while (s11_ != null) {
                cached.add(Arrays.asList(s11_.shape_));
                s11_ = s11_.next_;
            }
            s[2] = cached;
        } else if ((exclude & 0b10) != 0 /* is-excluded doJSObjectCheckShape(DynamicObject, Shape) */) {
            s[1] = (byte)0b10 /* excluded */;
        } else {
            s[1] = (byte)0b00 /* inactive */;
        }
        data[11] = s;
        s = new Object[3];
        s[0] = "doJSObjectCheckJSClass";
        if ((state & 0b100000000000) != 0 /* is-active doJSObjectCheckJSClass(DynamicObject, JSClass) */) {
            s[1] = (byte)0b01 /* active */;
            ArrayList<Object> cached = new ArrayList<>();
            cached.add(Arrays.asList(this.jSObjectCheckJSClass_cachedClass_));
            s[2] = cached;
        } else if ((exclude & 0b100) != 0 /* is-excluded doJSObjectCheckJSClass(DynamicObject, JSClass) */) {
            s[1] = (byte)0b10 /* excluded */;
        } else {
            s[1] = (byte)0b00 /* inactive */;
        }
        data[12] = s;
        s = new Object[3];
        s[0] = "doJSObjectCheck";
        if ((state & 0b1000000000000) != 0 /* is-active doJSObjectCheck(DynamicObject) */) {
            s[1] = (byte)0b01 /* active */;
        } else {
            s[1] = (byte)0b00 /* inactive */;
        }
        data[13] = s;
        s = new Object[3];
        s[0] = "doNullOrUndefined";
        if ((state & 0b10000000000000) != 0 /* is-active doNullOrUndefined(DynamicObject) */) {
            s[1] = (byte)0b01 /* active */;
        } else {
            s[1] = (byte)0b00 /* inactive */;
        }
        data[14] = s;
        s = new Object[3];
        s[0] = "doForeignTruffleObject";
        if ((state & 0b100000000000000) != 0 /* is-active doForeignTruffleObject(Object) */) {
            s[1] = (byte)0b01 /* active */;
        } else {
            s[1] = (byte)0b00 /* inactive */;
        }
        data[15] = s;
        s = new Object[3];
        s[0] = "doJavaGeneric";
        if ((state & 0b1000000000000000) != 0 /* is-active doJavaGeneric(Object) */) {
            s[1] = (byte)0b01 /* active */;
        } else {
            s[1] = (byte)0b00 /* inactive */;
        }
        data[16] = s;
        return Provider.create(data);
    }

    public static JSToObjectNode create(JSContext context, boolean checkForNullOrUndefined, boolean fromWith, boolean allowForeign) {
        return new JSToObjectNodeGen(context, checkForNullOrUndefined, fromWith, allowForeign);
    }

    @GeneratedBy(JSToObjectNode.class)
    private static final class JSObjectNoCheckShapeData {

        @CompilationFinal JSObjectNoCheckShapeData next_;
        @CompilationFinal Shape shape_;

        JSObjectNoCheckShapeData(JSObjectNoCheckShapeData next_) {
            this.next_ = next_;
        }

    }
    @GeneratedBy(JSToObjectNode.class)
    private static final class JSObjectCheckShapeData {

        @CompilationFinal JSObjectCheckShapeData next_;
        @CompilationFinal Shape shape_;

        JSObjectCheckShapeData(JSObjectCheckShapeData next_) {
            this.next_ = next_;
        }

    }
    @GeneratedBy(JSToObjectWrapperNode.class)
    public static final class JSToObjectWrapperNodeGen extends JSToObjectWrapperNode implements Provider {

        private JSToObjectWrapperNodeGen(JavaScriptNode operand, JSToObjectNode toObjectNode) {
            super(operand, toObjectNode);
        }

        @Override
        public Object execute(VirtualFrame frameValue, Object operandNodeValue) {
            return doDefault(operandNodeValue);
        }

        @Override
        public Object execute(VirtualFrame frameValue) {
            Object operandNodeValue_ = super.operandNode.execute(frameValue);
            return doDefault(operandNodeValue_);
        }

        @Override
        public DynamicObject executeDynamicObject(Object operandNodeValue) {
            return (DynamicObject) execute(null, operandNodeValue);
        }

        @Override
        public void executeVoid(VirtualFrame frameValue) {
            execute(frameValue);
            return;
        }

        @Override
        public NodeCost getCost() {
            return NodeCost.MONOMORPHIC;
        }

        @Override
        public Introspection getIntrospectionData() {
            Object[] data = new Object[2];
            Object[] s;
            data[0] = 0;
            s = new Object[3];
            s[0] = "doDefault";
            s[1] = (byte)0b01 /* active */;
            data[1] = s;
            return Provider.create(data);
        }

        public static JSToObjectWrapperNode create(JavaScriptNode operand, JSToObjectNode toObjectNode) {
            return new JSToObjectWrapperNodeGen(operand, toObjectNode);
        }

    }
}
