// CheckStyle: start generated
package com.oracle.truffle.js.nodes.cast;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.CompilerDirectives.CompilationFinal;
import com.oracle.truffle.api.dsl.GeneratedBy;
import com.oracle.truffle.api.dsl.Introspection;
import com.oracle.truffle.api.dsl.Introspection.Provider;
import com.oracle.truffle.api.nodes.NodeCost;
import com.oracle.truffle.api.object.DynamicObject;
import com.oracle.truffle.api.profiles.BranchProfile;
import com.oracle.truffle.js.nodes.JSGuards;
import com.oracle.truffle.js.nodes.JSTypes;
import com.oracle.truffle.js.nodes.JSTypesGen;
import com.oracle.truffle.js.nodes.cast.JSToLengthNode;
import com.oracle.truffle.js.nodes.cast.JSToNumberNode;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.concurrent.locks.Lock;

@GeneratedBy(JSToLengthNode.class)
public final class JSToLengthNodeGen extends JSToLengthNode implements Provider {

    @CompilationFinal private int state_;
    @CompilationFinal private DoubleData double_cache;
    @Child private JSToNumberNode object_toNumberNode_;
    @CompilationFinal private BranchProfile object_needSafeBranch_;

    private JSToLengthNodeGen() {
    }

    @Override
    public long executeLong(Object arg0Value) {
        int state = state_;
        if ((state & 0b1) != 0 /* is-active doInt(int) */ && arg0Value instanceof Integer) {
            int arg0Value_ = (int) arg0Value;
            return doInt(arg0Value_);
        }
        if ((state & 0b10) != 0 /* is-active doDouble(double, BranchProfile, BranchProfile, BranchProfile) */ && JSTypesGen.isImplicitDouble((state & 0b11110000) >>> 4 /* extract-implicit-active 0:double */, arg0Value)) {
            double arg0Value_ = JSTypesGen.asImplicitDouble((state & 0b11110000) >>> 4 /* extract-implicit-active 0:double */, arg0Value);
            DoubleData s2_ = this.double_cache;
            if (s2_ != null) {
                return doDouble(arg0Value_, s2_.needPositiveInfinityBranch_, s2_.needNaNBranch_, s2_.needSafeBranch_);
            }
        }
        if ((state & 0b100) != 0 /* is-active doUndefined(DynamicObject) */ && JSTypes.isDynamicObject(arg0Value)) {
            DynamicObject arg0Value_ = (DynamicObject) arg0Value;
            if ((JSGuards.isUndefined(arg0Value_))) {
                return doUndefined(arg0Value_);
            }
        }
        if ((state & 0b1000) != 0 /* is-active doObject(Object, JSToNumberNode, BranchProfile) */) {
            return doObject(arg0Value, this.object_toNumberNode_, this.object_needSafeBranch_);
        }
        CompilerDirectives.transferToInterpreterAndInvalidate();
        return executeAndSpecialize(arg0Value);
    }

    private long executeAndSpecialize(Object arg0Value) {
        Lock lock = getLock();
        boolean hasLock = true;
        lock.lock();
        int state = state_;
        try {
            if (arg0Value instanceof Integer) {
                int arg0Value_ = (int) arg0Value;
                this.state_ = state = state | 0b1 /* add-active doInt(int) */;
                lock.unlock();
                hasLock = false;
                return doInt(arg0Value_);
            }
            {
                int doubleCast0;
                if ((doubleCast0 = JSTypesGen.specializeImplicitDouble(arg0Value)) != 0) {
                    double arg0Value_ = JSTypesGen.asImplicitDouble(doubleCast0, arg0Value);
                    DoubleData s2_ = new DoubleData();
                    s2_.needPositiveInfinityBranch_ = (BranchProfile.create());
                    s2_.needNaNBranch_ = (BranchProfile.create());
                    s2_.needSafeBranch_ = (BranchProfile.create());
                    this.double_cache = s2_;
                    state = (state | (doubleCast0 << 4) /* set-implicit-active 0:double */);
                    this.state_ = state = state | 0b10 /* add-active doDouble(double, BranchProfile, BranchProfile, BranchProfile) */;
                    lock.unlock();
                    hasLock = false;
                    return doDouble(arg0Value_, s2_.needPositiveInfinityBranch_, s2_.needNaNBranch_, s2_.needSafeBranch_);
                }
            }
            if (JSTypes.isDynamicObject(arg0Value)) {
                DynamicObject arg0Value_ = (DynamicObject) arg0Value;
                if ((JSGuards.isUndefined(arg0Value_))) {
                    this.state_ = state = state | 0b100 /* add-active doUndefined(DynamicObject) */;
                    lock.unlock();
                    hasLock = false;
                    return doUndefined(arg0Value_);
                }
            }
            this.object_toNumberNode_ = super.insert((JSToNumberNode.create()));
            this.object_needSafeBranch_ = (BranchProfile.create());
            this.state_ = state = state | 0b1000 /* add-active doObject(Object, JSToNumberNode, BranchProfile) */;
            lock.unlock();
            hasLock = false;
            return doObject(arg0Value, this.object_toNumberNode_, this.object_needSafeBranch_);
        } finally {
            if (hasLock) {
                lock.unlock();
            }
        }
    }

    @Override
    public NodeCost getCost() {
        int state = state_;
        if ((state & 0b1111) == 0b0) {
            return NodeCost.UNINITIALIZED;
        } else if (((state & 0b1111) & ((state & 0b1111) - 1)) == 0 /* is-single-active  */) {
            return NodeCost.MONOMORPHIC;
        }
        return NodeCost.POLYMORPHIC;
    }

    @Override
    public Introspection getIntrospectionData() {
        Object[] data = new Object[5];
        Object[] s;
        data[0] = 0;
        int state = state_;
        s = new Object[3];
        s[0] = "doInt";
        if ((state & 0b1) != 0 /* is-active doInt(int) */) {
            s[1] = (byte)0b01 /* active */;
        } else {
            s[1] = (byte)0b00 /* inactive */;
        }
        data[1] = s;
        s = new Object[3];
        s[0] = "doDouble";
        if ((state & 0b10) != 0 /* is-active doDouble(double, BranchProfile, BranchProfile, BranchProfile) */) {
            s[1] = (byte)0b01 /* active */;
            ArrayList<Object> cached = new ArrayList<>();
            DoubleData s2_ = this.double_cache;
            if (s2_ != null) {
                cached.add(Arrays.asList(s2_.needPositiveInfinityBranch_, s2_.needNaNBranch_, s2_.needSafeBranch_));
            }
            s[2] = cached;
        } else {
            s[1] = (byte)0b00 /* inactive */;
        }
        data[2] = s;
        s = new Object[3];
        s[0] = "doUndefined";
        if ((state & 0b100) != 0 /* is-active doUndefined(DynamicObject) */) {
            s[1] = (byte)0b01 /* active */;
        } else {
            s[1] = (byte)0b00 /* inactive */;
        }
        data[3] = s;
        s = new Object[3];
        s[0] = "doObject";
        if ((state & 0b1000) != 0 /* is-active doObject(Object, JSToNumberNode, BranchProfile) */) {
            s[1] = (byte)0b01 /* active */;
            ArrayList<Object> cached = new ArrayList<>();
            cached.add(Arrays.asList(this.object_toNumberNode_, this.object_needSafeBranch_));
            s[2] = cached;
        } else {
            s[1] = (byte)0b00 /* inactive */;
        }
        data[4] = s;
        return Provider.create(data);
    }

    public static JSToLengthNode create() {
        return new JSToLengthNodeGen();
    }

    @GeneratedBy(JSToLengthNode.class)
    private static final class DoubleData {

        @CompilationFinal BranchProfile needPositiveInfinityBranch_;
        @CompilationFinal BranchProfile needNaNBranch_;
        @CompilationFinal BranchProfile needSafeBranch_;

        DoubleData() {
        }

    }
}
