// CheckStyle: start generated
package com.oracle.truffle.js.nodes.cast;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.CompilerDirectives.CompilationFinal;
import com.oracle.truffle.api.dsl.GeneratedBy;
import com.oracle.truffle.api.dsl.Introspection;
import com.oracle.truffle.api.dsl.UnsupportedSpecializationException;
import com.oracle.truffle.api.dsl.Introspection.Provider;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.nodes.NodeCost;
import com.oracle.truffle.api.nodes.UnexpectedResultException;
import com.oracle.truffle.api.object.DynamicObject;
import com.oracle.truffle.js.nodes.JSGuards;
import com.oracle.truffle.js.nodes.JSTypes;
import com.oracle.truffle.js.nodes.JSTypesGen;
import com.oracle.truffle.js.nodes.JavaScriptNode;
import com.oracle.truffle.js.nodes.cast.JSPrepareThisNode;
import com.oracle.truffle.js.runtime.BigInt;
import com.oracle.truffle.js.runtime.JSContext;
import com.oracle.truffle.js.runtime.Symbol;
import com.oracle.truffle.js.runtime.builtins.JSClass;
import com.oracle.truffle.js.runtime.objects.JSLazyString;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.concurrent.locks.Lock;

@GeneratedBy(JSPrepareThisNode.class)
public final class JSPrepareThisNodeGen extends JSPrepareThisNode implements Provider {

    @CompilationFinal private int state_;
    @CompilationFinal private int exclude_;
    @CompilationFinal private JSClass jSObjectCached_cachedClass_;

    private JSPrepareThisNodeGen(JSContext context, JavaScriptNode child) {
        super(context, child);
    }

    @Override
    public Object execute(VirtualFrame frameValue, Object operandNodeValue) {
        int state = state_;
        if ((state & 0b1) != 0 /* is-active doJSObject(Object) */) {
            if ((JSGuards.isNullOrUndefined(operandNodeValue))) {
                return doJSObject(operandNodeValue);
            }
        }
        if ((state & 0b110) != 0 /* is-active doJSObjectCached(DynamicObject, JSClass) || doJSObject(DynamicObject) */ && JSTypes.isDynamicObject(operandNodeValue)) {
            DynamicObject operandNodeValue_ = (DynamicObject) operandNodeValue;
            if ((state & 0b10) != 0 /* is-active doJSObjectCached(DynamicObject, JSClass) */) {
                assert (this.jSObjectCached_cachedClass_ != null);
                if ((this.jSObjectCached_cachedClass_.isInstance(operandNodeValue_))) {
                    return doJSObjectCached(operandNodeValue_, this.jSObjectCached_cachedClass_);
                }
            }
            if ((state & 0b100) != 0 /* is-active doJSObject(DynamicObject) */) {
                if ((JSGuards.isJSObject(operandNodeValue_))) {
                    return doJSObject(operandNodeValue_);
                }
            }
        }
        if ((state & 0b1000) != 0 /* is-active doBoolean(boolean) */ && operandNodeValue instanceof Boolean) {
            boolean operandNodeValue_ = (boolean) operandNodeValue;
            return doBoolean(operandNodeValue_);
        }
        if ((state & 0b10000) != 0 /* is-active doJSLazyString(JSLazyString) */ && operandNodeValue instanceof JSLazyString) {
            JSLazyString operandNodeValue_ = (JSLazyString) operandNodeValue;
            return doJSLazyString(operandNodeValue_);
        }
        if ((state & 0b100000) != 0 /* is-active doString(String) */ && JSTypesGen.isImplicitString((state & 0b1111000000000000) >>> 12 /* extract-implicit-active 0:String */, operandNodeValue)) {
            String operandNodeValue_ = JSTypesGen.asImplicitString((state & 0b1111000000000000) >>> 12 /* extract-implicit-active 0:String */, operandNodeValue);
            return doString(operandNodeValue_);
        }
        if ((state & 0b1000000) != 0 /* is-active doInt(int) */ && operandNodeValue instanceof Integer) {
            int operandNodeValue_ = (int) operandNodeValue;
            return doInt(operandNodeValue_);
        }
        if ((state & 0b10000000) != 0 /* is-active doDouble(double) */ && JSTypesGen.isImplicitDouble((state & 0xf0000) >>> 16 /* extract-implicit-active 0:double */, operandNodeValue)) {
            double operandNodeValue_ = JSTypesGen.asImplicitDouble((state & 0xf0000) >>> 16 /* extract-implicit-active 0:double */, operandNodeValue);
            return doDouble(operandNodeValue_);
        }
        if ((state & 0b100000000) != 0 /* is-active doBigInt(BigInt) */ && operandNodeValue instanceof BigInt) {
            BigInt operandNodeValue_ = (BigInt) operandNodeValue;
            return doBigInt(operandNodeValue_);
        }
        if ((state & 0b1000000000) != 0 /* is-active doNumber(Object) */) {
            if ((JSGuards.isJavaNumber(operandNodeValue))) {
                return doNumber(operandNodeValue);
            }
        }
        if ((state & 0b10000000000) != 0 /* is-active doSymbol(Symbol) */ && operandNodeValue instanceof Symbol) {
            Symbol operandNodeValue_ = (Symbol) operandNodeValue;
            return doSymbol(operandNodeValue_);
        }
        if ((state & 0b100000000000) != 0 /* is-active doForeignObject(Object) */) {
            if ((JSGuards.isForeignObject(operandNodeValue))) {
                return doForeignObject(operandNodeValue);
            }
        }
        CompilerDirectives.transferToInterpreterAndInvalidate();
        return executeAndSpecialize(operandNodeValue);
    }

    @Override
    public Object execute(VirtualFrame frameValue) {
        int state = state_;
        if ((state & 0b111111110111) == 0 /* only-active doBoolean(boolean) */ && (state & 0b111111111111) != 0  /* is-not doJSObject(Object) && doJSObjectCached(DynamicObject, JSClass) && doJSObject(DynamicObject) && doBoolean(boolean) && doJSLazyString(JSLazyString) && doString(String) && doInt(int) && doDouble(double) && doBigInt(BigInt) && doNumber(Object) && doSymbol(Symbol) && doForeignObject(Object) */) {
            return execute_boolean0(frameValue, state);
        } else if ((state & 0b111110111111) == 0 /* only-active doInt(int) */ && (state & 0b111111111111) != 0  /* is-not doJSObject(Object) && doJSObjectCached(DynamicObject, JSClass) && doJSObject(DynamicObject) && doBoolean(boolean) && doJSLazyString(JSLazyString) && doString(String) && doInt(int) && doDouble(double) && doBigInt(BigInt) && doNumber(Object) && doSymbol(Symbol) && doForeignObject(Object) */) {
            return execute_int1(frameValue, state);
        } else if ((state & 0b111101111111) == 0 /* only-active doDouble(double) */ && (state & 0b111111111111) != 0  /* is-not doJSObject(Object) && doJSObjectCached(DynamicObject, JSClass) && doJSObject(DynamicObject) && doBoolean(boolean) && doJSLazyString(JSLazyString) && doString(String) && doInt(int) && doDouble(double) && doBigInt(BigInt) && doNumber(Object) && doSymbol(Symbol) && doForeignObject(Object) */) {
            return execute_double2(frameValue, state);
        } else {
            return execute_generic3(frameValue, state);
        }
    }

    private Object execute_boolean0(VirtualFrame frameValue, int state) {
        boolean operandNodeValue_;
        try {
            operandNodeValue_ = super.operandNode.executeBoolean(frameValue);
        } catch (UnexpectedResultException ex) {
            return executeAndSpecialize(ex.getResult());
        }
        assert (state & 0b1000) != 0 /* is-active doBoolean(boolean) */;
        return doBoolean(operandNodeValue_);
    }

    private Object execute_int1(VirtualFrame frameValue, int state) {
        int operandNodeValue_;
        try {
            operandNodeValue_ = super.operandNode.executeInt(frameValue);
        } catch (UnexpectedResultException ex) {
            return executeAndSpecialize(ex.getResult());
        }
        assert (state & 0b1000000) != 0 /* is-active doInt(int) */;
        return doInt(operandNodeValue_);
    }

    private Object execute_double2(VirtualFrame frameValue, int state) {
        int operandNodeValue_int = 0;
        long operandNodeValue_long = 0L;
        double operandNodeValue_;
        try {
            if ((state & 0xe0000) == 0 /* only-active 0:double */ && (state & 0b111111111111) != 0  /* is-not doJSObject(Object) && doJSObjectCached(DynamicObject, JSClass) && doJSObject(DynamicObject) && doBoolean(boolean) && doJSLazyString(JSLazyString) && doString(String) && doInt(int) && doDouble(double) && doBigInt(BigInt) && doNumber(Object) && doSymbol(Symbol) && doForeignObject(Object) */) {
                operandNodeValue_long = super.operandNode.executeLong(frameValue);
                operandNodeValue_ = JSTypes.longToDouble(operandNodeValue_long);
            } else if ((state & 0xd0000) == 0 /* only-active 0:double */ && (state & 0b111111111111) != 0  /* is-not doJSObject(Object) && doJSObjectCached(DynamicObject, JSClass) && doJSObject(DynamicObject) && doBoolean(boolean) && doJSLazyString(JSLazyString) && doString(String) && doInt(int) && doDouble(double) && doBigInt(BigInt) && doNumber(Object) && doSymbol(Symbol) && doForeignObject(Object) */) {
                operandNodeValue_int = super.operandNode.executeInt(frameValue);
                operandNodeValue_ = JSTypes.intToDouble(operandNodeValue_int);
            } else if ((state & 0xb0000) == 0 /* only-active 0:double */ && (state & 0b111111111111) != 0  /* is-not doJSObject(Object) && doJSObjectCached(DynamicObject, JSClass) && doJSObject(DynamicObject) && doBoolean(boolean) && doJSLazyString(JSLazyString) && doString(String) && doInt(int) && doDouble(double) && doBigInt(BigInt) && doNumber(Object) && doSymbol(Symbol) && doForeignObject(Object) */) {
                operandNodeValue_ = super.operandNode.executeDouble(frameValue);
            } else {
                Object operandNodeValue__ = super.operandNode.execute(frameValue);
                operandNodeValue_ = JSTypesGen.expectImplicitDouble((state & 0xf0000) >>> 16 /* extract-implicit-active 0:double */, operandNodeValue__);
            }
        } catch (UnexpectedResultException ex) {
            return executeAndSpecialize(ex.getResult());
        }
        assert (state & 0b10000000) != 0 /* is-active doDouble(double) */;
        return doDouble(operandNodeValue_);
    }

    private Object execute_generic3(VirtualFrame frameValue, int state) {
        Object operandNodeValue_ = super.operandNode.execute(frameValue);
        if ((state & 0b1) != 0 /* is-active doJSObject(Object) */) {
            if ((JSGuards.isNullOrUndefined(operandNodeValue_))) {
                return doJSObject(operandNodeValue_);
            }
        }
        if ((state & 0b110) != 0 /* is-active doJSObjectCached(DynamicObject, JSClass) || doJSObject(DynamicObject) */ && JSTypes.isDynamicObject(operandNodeValue_)) {
            DynamicObject operandNodeValue__ = (DynamicObject) operandNodeValue_;
            if ((state & 0b10) != 0 /* is-active doJSObjectCached(DynamicObject, JSClass) */) {
                assert (this.jSObjectCached_cachedClass_ != null);
                if ((this.jSObjectCached_cachedClass_.isInstance(operandNodeValue__))) {
                    return doJSObjectCached(operandNodeValue__, this.jSObjectCached_cachedClass_);
                }
            }
            if ((state & 0b100) != 0 /* is-active doJSObject(DynamicObject) */) {
                if ((JSGuards.isJSObject(operandNodeValue__))) {
                    return doJSObject(operandNodeValue__);
                }
            }
        }
        if ((state & 0b1000) != 0 /* is-active doBoolean(boolean) */ && operandNodeValue_ instanceof Boolean) {
            boolean operandNodeValue__ = (boolean) operandNodeValue_;
            return doBoolean(operandNodeValue__);
        }
        if ((state & 0b10000) != 0 /* is-active doJSLazyString(JSLazyString) */ && operandNodeValue_ instanceof JSLazyString) {
            JSLazyString operandNodeValue__ = (JSLazyString) operandNodeValue_;
            return doJSLazyString(operandNodeValue__);
        }
        if ((state & 0b100000) != 0 /* is-active doString(String) */ && JSTypesGen.isImplicitString((state & 0b1111000000000000) >>> 12 /* extract-implicit-active 0:String */, operandNodeValue_)) {
            String operandNodeValue__ = JSTypesGen.asImplicitString((state & 0b1111000000000000) >>> 12 /* extract-implicit-active 0:String */, operandNodeValue_);
            return doString(operandNodeValue__);
        }
        if ((state & 0b1000000) != 0 /* is-active doInt(int) */ && operandNodeValue_ instanceof Integer) {
            int operandNodeValue__ = (int) operandNodeValue_;
            return doInt(operandNodeValue__);
        }
        if ((state & 0b10000000) != 0 /* is-active doDouble(double) */ && JSTypesGen.isImplicitDouble((state & 0xf0000) >>> 16 /* extract-implicit-active 0:double */, operandNodeValue_)) {
            double operandNodeValue__ = JSTypesGen.asImplicitDouble((state & 0xf0000) >>> 16 /* extract-implicit-active 0:double */, operandNodeValue_);
            return doDouble(operandNodeValue__);
        }
        if ((state & 0b100000000) != 0 /* is-active doBigInt(BigInt) */ && operandNodeValue_ instanceof BigInt) {
            BigInt operandNodeValue__ = (BigInt) operandNodeValue_;
            return doBigInt(operandNodeValue__);
        }
        if ((state & 0b1000000000) != 0 /* is-active doNumber(Object) */) {
            if ((JSGuards.isJavaNumber(operandNodeValue_))) {
                return doNumber(operandNodeValue_);
            }
        }
        if ((state & 0b10000000000) != 0 /* is-active doSymbol(Symbol) */ && operandNodeValue_ instanceof Symbol) {
            Symbol operandNodeValue__ = (Symbol) operandNodeValue_;
            return doSymbol(operandNodeValue__);
        }
        if ((state & 0b100000000000) != 0 /* is-active doForeignObject(Object) */) {
            if ((JSGuards.isForeignObject(operandNodeValue_))) {
                return doForeignObject(operandNodeValue_);
            }
        }
        CompilerDirectives.transferToInterpreterAndInvalidate();
        return executeAndSpecialize(operandNodeValue_);
    }

    @Override
    public void executeVoid(VirtualFrame frameValue) {
        execute(frameValue);
        return;
    }

    private Object executeAndSpecialize(Object operandNodeValue) {
        Lock lock = getLock();
        boolean hasLock = true;
        lock.lock();
        int state = state_;
        int exclude = exclude_;
        try {
            if ((JSGuards.isNullOrUndefined(operandNodeValue))) {
                this.state_ = state = state | 0b1 /* add-active doJSObject(Object) */;
                lock.unlock();
                hasLock = false;
                return doJSObject(operandNodeValue);
            }
            if (JSTypes.isDynamicObject(operandNodeValue)) {
                DynamicObject operandNodeValue_ = (DynamicObject) operandNodeValue;
                if ((exclude) == 0 /* is-not-excluded doJSObjectCached(DynamicObject, JSClass) */) {
                    boolean JSObjectCached_duplicateFound_ = false;
                    if ((state & 0b10) != 0 /* is-active doJSObjectCached(DynamicObject, JSClass) */) {
                        assert (this.jSObjectCached_cachedClass_ != null);
                        if ((this.jSObjectCached_cachedClass_.isInstance(operandNodeValue_))) {
                            JSObjectCached_duplicateFound_ = true;
                        }
                    }
                    if (!JSObjectCached_duplicateFound_) {
                        {
                            JSClass jSObjectCached_cachedClass__ = (JSGuards.getJSClassIfObject(operandNodeValue_));
                            if ((jSObjectCached_cachedClass__ != null) && (jSObjectCached_cachedClass__.isInstance(operandNodeValue_)) && ((state & 0b10)) == 0 /* is-not-active doJSObjectCached(DynamicObject, JSClass) */) {
                                this.jSObjectCached_cachedClass_ = jSObjectCached_cachedClass__;
                                this.state_ = state = state | 0b10 /* add-active doJSObjectCached(DynamicObject, JSClass) */;
                                JSObjectCached_duplicateFound_ = true;
                            }
                        }
                    }
                    if (JSObjectCached_duplicateFound_) {
                        lock.unlock();
                        hasLock = false;
                        return doJSObjectCached(operandNodeValue_, this.jSObjectCached_cachedClass_);
                    }
                }
                if ((JSGuards.isJSObject(operandNodeValue_))) {
                    this.exclude_ = exclude = exclude | 0b1 /* add-excluded doJSObjectCached(DynamicObject, JSClass) */;
                    state = state & 0xfffffffd /* remove-active doJSObjectCached(DynamicObject, JSClass) */;
                    this.state_ = state = state | 0b100 /* add-active doJSObject(DynamicObject) */;
                    lock.unlock();
                    hasLock = false;
                    return doJSObject(operandNodeValue_);
                }
            }
            if (operandNodeValue instanceof Boolean) {
                boolean operandNodeValue_ = (boolean) operandNodeValue;
                this.state_ = state = state | 0b1000 /* add-active doBoolean(boolean) */;
                lock.unlock();
                hasLock = false;
                return doBoolean(operandNodeValue_);
            }
            if (operandNodeValue instanceof JSLazyString) {
                JSLazyString operandNodeValue_ = (JSLazyString) operandNodeValue;
                this.state_ = state = state | 0b10000 /* add-active doJSLazyString(JSLazyString) */;
                lock.unlock();
                hasLock = false;
                return doJSLazyString(operandNodeValue_);
            }
            {
                int stringCast0;
                if ((stringCast0 = JSTypesGen.specializeImplicitString(operandNodeValue)) != 0) {
                    String operandNodeValue_ = JSTypesGen.asImplicitString(stringCast0, operandNodeValue);
                    state = (state | (stringCast0 << 12) /* set-implicit-active 0:String */);
                    this.state_ = state = state | 0b100000 /* add-active doString(String) */;
                    lock.unlock();
                    hasLock = false;
                    return doString(operandNodeValue_);
                }
            }
            if (operandNodeValue instanceof Integer) {
                int operandNodeValue_ = (int) operandNodeValue;
                this.state_ = state = state | 0b1000000 /* add-active doInt(int) */;
                lock.unlock();
                hasLock = false;
                return doInt(operandNodeValue_);
            }
            {
                int doubleCast0;
                if ((doubleCast0 = JSTypesGen.specializeImplicitDouble(operandNodeValue)) != 0) {
                    double operandNodeValue_ = JSTypesGen.asImplicitDouble(doubleCast0, operandNodeValue);
                    state = (state | (doubleCast0 << 16) /* set-implicit-active 0:double */);
                    this.state_ = state = state | 0b10000000 /* add-active doDouble(double) */;
                    lock.unlock();
                    hasLock = false;
                    return doDouble(operandNodeValue_);
                }
            }
            if (operandNodeValue instanceof BigInt) {
                BigInt operandNodeValue_ = (BigInt) operandNodeValue;
                this.state_ = state = state | 0b100000000 /* add-active doBigInt(BigInt) */;
                lock.unlock();
                hasLock = false;
                return doBigInt(operandNodeValue_);
            }
            if ((JSGuards.isJavaNumber(operandNodeValue))) {
                this.state_ = state = state | 0b1000000000 /* add-active doNumber(Object) */;
                lock.unlock();
                hasLock = false;
                return doNumber(operandNodeValue);
            }
            if (operandNodeValue instanceof Symbol) {
                Symbol operandNodeValue_ = (Symbol) operandNodeValue;
                this.state_ = state = state | 0b10000000000 /* add-active doSymbol(Symbol) */;
                lock.unlock();
                hasLock = false;
                return doSymbol(operandNodeValue_);
            }
            if ((JSGuards.isForeignObject(operandNodeValue))) {
                this.state_ = state = state | 0b100000000000 /* add-active doForeignObject(Object) */;
                lock.unlock();
                hasLock = false;
                return doForeignObject(operandNodeValue);
            }
            throw new UnsupportedSpecializationException(this, new Node[] {super.operandNode}, operandNodeValue);
        } finally {
            if (hasLock) {
                lock.unlock();
            }
        }
    }

    @Override
    public NodeCost getCost() {
        int state = state_;
        if ((state & 0b111111111111) == 0b0) {
            return NodeCost.UNINITIALIZED;
        } else if (((state & 0b111111111111) & ((state & 0b111111111111) - 1)) == 0 /* is-single-active  */) {
            return NodeCost.MONOMORPHIC;
        }
        return NodeCost.POLYMORPHIC;
    }

    @Override
    public Introspection getIntrospectionData() {
        Object[] data = new Object[13];
        Object[] s;
        data[0] = 0;
        int state = state_;
        int exclude = exclude_;
        s = new Object[3];
        s[0] = "doJSObject";
        if ((state & 0b1) != 0 /* is-active doJSObject(Object) */) {
            s[1] = (byte)0b01 /* active */;
        } else {
            s[1] = (byte)0b00 /* inactive */;
        }
        data[1] = s;
        s = new Object[3];
        s[0] = "doJSObjectCached";
        if ((state & 0b10) != 0 /* is-active doJSObjectCached(DynamicObject, JSClass) */) {
            s[1] = (byte)0b01 /* active */;
            ArrayList<Object> cached = new ArrayList<>();
            cached.add(Arrays.asList(this.jSObjectCached_cachedClass_));
            s[2] = cached;
        } else if (exclude != 0 /* is-excluded doJSObjectCached(DynamicObject, JSClass) */) {
            s[1] = (byte)0b10 /* excluded */;
        } else {
            s[1] = (byte)0b00 /* inactive */;
        }
        data[2] = s;
        s = new Object[3];
        s[0] = "doJSObject";
        if ((state & 0b100) != 0 /* is-active doJSObject(DynamicObject) */) {
            s[1] = (byte)0b01 /* active */;
        } else {
            s[1] = (byte)0b00 /* inactive */;
        }
        data[3] = s;
        s = new Object[3];
        s[0] = "doBoolean";
        if ((state & 0b1000) != 0 /* is-active doBoolean(boolean) */) {
            s[1] = (byte)0b01 /* active */;
        } else {
            s[1] = (byte)0b00 /* inactive */;
        }
        data[4] = s;
        s = new Object[3];
        s[0] = "doJSLazyString";
        if ((state & 0b10000) != 0 /* is-active doJSLazyString(JSLazyString) */) {
            s[1] = (byte)0b01 /* active */;
        } else {
            s[1] = (byte)0b00 /* inactive */;
        }
        data[5] = s;
        s = new Object[3];
        s[0] = "doString";
        if ((state & 0b100000) != 0 /* is-active doString(String) */) {
            s[1] = (byte)0b01 /* active */;
        } else {
            s[1] = (byte)0b00 /* inactive */;
        }
        data[6] = s;
        s = new Object[3];
        s[0] = "doInt";
        if ((state & 0b1000000) != 0 /* is-active doInt(int) */) {
            s[1] = (byte)0b01 /* active */;
        } else {
            s[1] = (byte)0b00 /* inactive */;
        }
        data[7] = s;
        s = new Object[3];
        s[0] = "doDouble";
        if ((state & 0b10000000) != 0 /* is-active doDouble(double) */) {
            s[1] = (byte)0b01 /* active */;
        } else {
            s[1] = (byte)0b00 /* inactive */;
        }
        data[8] = s;
        s = new Object[3];
        s[0] = "doBigInt";
        if ((state & 0b100000000) != 0 /* is-active doBigInt(BigInt) */) {
            s[1] = (byte)0b01 /* active */;
        } else {
            s[1] = (byte)0b00 /* inactive */;
        }
        data[9] = s;
        s = new Object[3];
        s[0] = "doNumber";
        if ((state & 0b1000000000) != 0 /* is-active doNumber(Object) */) {
            s[1] = (byte)0b01 /* active */;
        } else {
            s[1] = (byte)0b00 /* inactive */;
        }
        data[10] = s;
        s = new Object[3];
        s[0] = "doSymbol";
        if ((state & 0b10000000000) != 0 /* is-active doSymbol(Symbol) */) {
            s[1] = (byte)0b01 /* active */;
        } else {
            s[1] = (byte)0b00 /* inactive */;
        }
        data[11] = s;
        s = new Object[3];
        s[0] = "doForeignObject";
        if ((state & 0b100000000000) != 0 /* is-active doForeignObject(Object) */) {
            s[1] = (byte)0b01 /* active */;
        } else {
            s[1] = (byte)0b00 /* inactive */;
        }
        data[12] = s;
        return Provider.create(data);
    }

    public static JSPrepareThisNode create(JSContext context, JavaScriptNode child) {
        return new JSPrepareThisNodeGen(context, child);
    }

}
