// CheckStyle: start generated
package com.oracle.truffle.js.nodes.binary;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.CompilerDirectives.CompilationFinal;
import com.oracle.truffle.api.dsl.GeneratedBy;
import com.oracle.truffle.api.dsl.Introspection;
import com.oracle.truffle.api.dsl.Introspection.Provider;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.interop.TruffleObject;
import com.oracle.truffle.api.nodes.ExplodeLoop;
import com.oracle.truffle.api.nodes.NodeCost;
import com.oracle.truffle.api.nodes.UnexpectedResultException;
import com.oracle.truffle.api.object.DynamicObject;
import com.oracle.truffle.api.profiles.ConditionProfile;
import com.oracle.truffle.js.nodes.JSGuards;
import com.oracle.truffle.js.nodes.JSTypes;
import com.oracle.truffle.js.nodes.JSTypesGen;
import com.oracle.truffle.js.nodes.JavaScriptNode;
import com.oracle.truffle.js.nodes.binary.JSIdenticalNode;
import com.oracle.truffle.js.runtime.BigInt;
import com.oracle.truffle.js.runtime.JSRuntime;
import com.oracle.truffle.js.runtime.Symbol;
import com.oracle.truffle.js.runtime.objects.JSLazyString;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.concurrent.locks.Lock;

@GeneratedBy(JSIdenticalNode.class)
public final class JSIdenticalNodeGen extends JSIdenticalNode implements Provider {

    @CompilationFinal private long state_;
    @CompilationFinal private int exclude_;
    @CompilationFinal private LazyStringData lazyString_cache;
    @CompilationFinal private ConditionProfile lazyStringLeft_flatten_;
    @CompilationFinal private ConditionProfile lazyStringLeft_len_;
    @CompilationFinal private ConditionProfile lazyStringRight_flatten_;
    @CompilationFinal private ConditionProfile lazyStringRight_len_;
    @CompilationFinal private DifferentTypesCachedData differentTypesCached_cache;
    @CompilationFinal private NumberCachedData numberCached_cache;

    private JSIdenticalNodeGen(JavaScriptNode left, JavaScriptNode right, int type) {
        super(left, right, type);
    }

    @ExplodeLoop
    @Override
    public boolean executeBoolean(Object leftNodeValue, Object rightNodeValue) {
        long state = state_;
        if ((state & 0b1) != 0 /* is-active doInt(int, int) */ && leftNodeValue instanceof Integer) {
            int leftNodeValue_ = (int) leftNodeValue;
            if (rightNodeValue instanceof Integer) {
                int rightNodeValue_ = (int) rightNodeValue;
                return JSIdenticalNode.doInt(leftNodeValue_, rightNodeValue_);
            }
        }
        if ((state & 0b10) != 0 /* is-active doDouble(double, double) */ && JSTypesGen.isImplicitDouble((int)((state & 0x1e000000L) >>> 25) /* extract-implicit-active 0:double */, leftNodeValue)) {
            double leftNodeValue_ = JSTypesGen.asImplicitDouble((int)((state & 0x1e000000L) >>> 25) /* extract-implicit-active 0:double */, leftNodeValue);
            if (JSTypesGen.isImplicitDouble((int)((state & 0x1e0000000L) >>> 29) /* extract-implicit-active 1:double */, rightNodeValue)) {
                double rightNodeValue_ = JSTypesGen.asImplicitDouble((int)((state & 0x1e0000000L) >>> 29) /* extract-implicit-active 1:double */, rightNodeValue);
                return doDouble(leftNodeValue_, rightNodeValue_);
            }
        }
        if ((state & 0b100) != 0 /* is-active doBoolean(boolean, boolean) */ && leftNodeValue instanceof Boolean) {
            boolean leftNodeValue_ = (boolean) leftNodeValue;
            if (rightNodeValue instanceof Boolean) {
                boolean rightNodeValue_ = (boolean) rightNodeValue;
                return JSIdenticalNode.doBoolean(leftNodeValue_, rightNodeValue_);
            }
        }
        if ((state & 0b11000) != 0 /* is-active doBigInt(BigInt, BigInt) || doBigIntDouble(BigInt, double) */ && leftNodeValue instanceof BigInt) {
            BigInt leftNodeValue_ = (BigInt) leftNodeValue;
            if ((state & 0b1000) != 0 /* is-active doBigInt(BigInt, BigInt) */ && rightNodeValue instanceof BigInt) {
                BigInt rightNodeValue_ = (BigInt) rightNodeValue;
                return JSIdenticalNode.doBigInt(leftNodeValue_, rightNodeValue_);
            }
            if ((state & 0b10000) != 0 /* is-active doBigIntDouble(BigInt, double) */ && JSTypesGen.isImplicitDouble((int)((state & 0x1e0000000L) >>> 29) /* extract-implicit-active 1:double */, rightNodeValue)) {
                double rightNodeValue_ = JSTypesGen.asImplicitDouble((int)((state & 0x1e0000000L) >>> 29) /* extract-implicit-active 1:double */, rightNodeValue);
                return JSIdenticalNode.doBigIntDouble(leftNodeValue_, rightNodeValue_);
            }
        }
        if ((state & 0b100000) != 0 /* is-active doDoubleBigInt(double, BigInt) */ && JSTypesGen.isImplicitDouble((int)((state & 0x1e000000L) >>> 25) /* extract-implicit-active 0:double */, leftNodeValue)) {
            double leftNodeValue_ = JSTypesGen.asImplicitDouble((int)((state & 0x1e000000L) >>> 25) /* extract-implicit-active 0:double */, leftNodeValue);
            if (rightNodeValue instanceof BigInt) {
                BigInt rightNodeValue_ = (BigInt) rightNodeValue;
                return JSIdenticalNode.doDoubleBigInt(leftNodeValue_, rightNodeValue_);
            }
        }
        if ((state & 0b1000000) != 0 /* is-active doObject(DynamicObject, DynamicObject) */ && JSTypes.isDynamicObject(leftNodeValue)) {
            DynamicObject leftNodeValue_ = (DynamicObject) leftNodeValue;
            if (JSTypes.isDynamicObject(rightNodeValue)) {
                DynamicObject rightNodeValue_ = (DynamicObject) rightNodeValue;
                return JSIdenticalNode.doObject(leftNodeValue_, rightNodeValue_);
            }
        }
        if ((state & 0b1110000000) != 0 /* is-active doLazyStringReference(JSLazyString, JSLazyString) || doLazyString(JSLazyString, JSLazyString, ConditionProfile, ConditionProfile, ConditionProfile) || doLazyStringLeft(String, JSLazyString, ConditionProfile, ConditionProfile) */ && rightNodeValue instanceof JSLazyString) {
            JSLazyString rightNodeValue_ = (JSLazyString) rightNodeValue;
            if ((state & 0b110000000) != 0 /* is-active doLazyStringReference(JSLazyString, JSLazyString) || doLazyString(JSLazyString, JSLazyString, ConditionProfile, ConditionProfile, ConditionProfile) */ && leftNodeValue instanceof JSLazyString) {
                JSLazyString leftNodeValue_ = (JSLazyString) leftNodeValue;
                if ((state & 0b10000000) != 0 /* is-active doLazyStringReference(JSLazyString, JSLazyString) */) {
                    if ((JSGuards.isReferenceEquals(leftNodeValue_, rightNodeValue_))) {
                        return JSIdenticalNode.doLazyStringReference(leftNodeValue_, rightNodeValue_);
                    }
                }
                if ((state & 0b100000000) != 0 /* is-active doLazyString(JSLazyString, JSLazyString, ConditionProfile, ConditionProfile, ConditionProfile) */) {
                    LazyStringData s9_ = this.lazyString_cache;
                    if (s9_ != null) {
                        return JSIdenticalNode.doLazyString(leftNodeValue_, rightNodeValue_, s9_.flattenA_, s9_.flattenB_, s9_.len_);
                    }
                }
            }
            if ((state & 0b1000000000) != 0 /* is-active doLazyStringLeft(String, JSLazyString, ConditionProfile, ConditionProfile) */ && JSTypesGen.isImplicitString((int)((state & 0x1e00000000L) >>> 33) /* extract-implicit-active 0:String */, leftNodeValue)) {
                String leftNodeValue_ = JSTypesGen.asImplicitString((int)((state & 0x1e00000000L) >>> 33) /* extract-implicit-active 0:String */, leftNodeValue);
                return JSIdenticalNode.doLazyStringLeft(leftNodeValue_, rightNodeValue_, this.lazyStringLeft_flatten_, this.lazyStringLeft_len_);
            }
        }
        if ((state & 0b1110000000000) != 0 /* is-active doLazyStringRight(JSLazyString, String, ConditionProfile, ConditionProfile) || doStringIdentity(String, String) || doString(String, String) */ && JSTypesGen.isImplicitString((int)((state & 0x1e000000000L) >>> 37) /* extract-implicit-active 1:String */, rightNodeValue)) {
            String rightNodeValue_ = JSTypesGen.asImplicitString((int)((state & 0x1e000000000L) >>> 37) /* extract-implicit-active 1:String */, rightNodeValue);
            if ((state & 0b10000000000) != 0 /* is-active doLazyStringRight(JSLazyString, String, ConditionProfile, ConditionProfile) */ && leftNodeValue instanceof JSLazyString) {
                JSLazyString leftNodeValue_ = (JSLazyString) leftNodeValue;
                return JSIdenticalNode.doLazyStringRight(leftNodeValue_, rightNodeValue_, this.lazyStringRight_flatten_, this.lazyStringRight_len_);
            }
            if ((state & 0b1100000000000) != 0 /* is-active doStringIdentity(String, String) || doString(String, String) */ && JSTypesGen.isImplicitString((int)((state & 0x1e00000000L) >>> 33) /* extract-implicit-active 0:String */, leftNodeValue)) {
                String leftNodeValue_ = JSTypesGen.asImplicitString((int)((state & 0x1e00000000L) >>> 33) /* extract-implicit-active 0:String */, leftNodeValue);
                if ((state & 0b100000000000) != 0 /* is-active doStringIdentity(String, String) */) {
                    if ((JSGuards.isReferenceEquals(leftNodeValue_, rightNodeValue_))) {
                        return JSIdenticalNode.doStringIdentity(leftNodeValue_, rightNodeValue_);
                    }
                }
                if ((state & 0b1000000000000) != 0 /* is-active doString(String, String) */) {
                    return JSIdenticalNode.doString(leftNodeValue_, rightNodeValue_);
                }
            }
        }
        if ((state & 0b10000000000000) != 0 /* is-active doSymbol(Symbol, Symbol) */ && leftNodeValue instanceof Symbol) {
            Symbol leftNodeValue_ = (Symbol) leftNodeValue;
            if (rightNodeValue instanceof Symbol) {
                Symbol rightNodeValue_ = (Symbol) rightNodeValue;
                return JSIdenticalNode.doSymbol(leftNodeValue_, rightNodeValue_);
            }
        }
        if ((state & 0x3fc000L) != 0 /* is-active doBooleanNotBoolean(Object, Object) || doSymbolNotSymbol(Object, Object) || doNullNotNull(Object, Object) || doUndefinedNotUndefined(Object, Object) || doDifferentTypesCached(Object, Object, Class<>, Class<>) || doNumberNotNumber(Object, Object) || doStringNotString(Object, Object) || doNumberCached(Object, Object, Class<>, Class<>) */) {
            if ((state & 0b100000000000000) != 0 /* is-active doBooleanNotBoolean(Object, Object) */) {
                if ((JSGuards.isBoolean(leftNodeValue) != JSGuards.isBoolean(rightNodeValue))) {
                    return JSIdenticalNode.doBooleanNotBoolean(leftNodeValue, rightNodeValue);
                }
            }
            if ((state & 0b1000000000000000) != 0 /* is-active doSymbolNotSymbol(Object, Object) */) {
                if ((JSGuards.isSymbol(leftNodeValue) != JSGuards.isSymbol(rightNodeValue))) {
                    return JSIdenticalNode.doSymbolNotSymbol(leftNodeValue, rightNodeValue);
                }
            }
            if ((state & 0x10000L) != 0 /* is-active doNullNotNull(Object, Object) */) {
                if ((JSGuards.isJSNull(leftNodeValue) != JSGuards.isJSNull(rightNodeValue))) {
                    return JSIdenticalNode.doNullNotNull(leftNodeValue, rightNodeValue);
                }
            }
            if ((state & 0x20000L) != 0 /* is-active doUndefinedNotUndefined(Object, Object) */) {
                if ((JSGuards.isUndefined(leftNodeValue) != JSGuards.isUndefined(rightNodeValue))) {
                    return JSIdenticalNode.doUndefinedNotUndefined(leftNodeValue, rightNodeValue);
                }
            }
            if ((state & 0x40000L) != 0 /* is-active doDifferentTypesCached(Object, Object, Class<>, Class<>) */) {
                DifferentTypesCachedData s19_ = this.differentTypesCached_cache;
                while (s19_ != null) {
                    if ((leftNodeValue.getClass() == s19_.cachedClassA_) && (rightNodeValue.getClass() == s19_.cachedClassB_)) {
                        assert (JSIdenticalNode.isNonObjectType(s19_.cachedClassA_) || JSIdenticalNode.isNonObjectType(s19_.cachedClassB_));
                        assert (JSIdenticalNode.differentNonObjectTypes(s19_.cachedClassA_, s19_.cachedClassB_));
                        return JSIdenticalNode.doDifferentTypesCached(leftNodeValue, rightNodeValue, s19_.cachedClassA_, s19_.cachedClassB_);
                    }
                    s19_ = s19_.next_;
                }
            }
            if ((state & 0x80000L) != 0 /* is-active doNumberNotNumber(Object, Object) */) {
                if ((JSRuntime.isJavaNumber(leftNodeValue) != JSRuntime.isJavaNumber(rightNodeValue))) {
                    return JSIdenticalNode.doNumberNotNumber(leftNodeValue, rightNodeValue);
                }
            }
            if ((state & 0x100000L) != 0 /* is-active doStringNotString(Object, Object) */) {
                if ((JSRuntime.isString(leftNodeValue) != JSRuntime.isString(rightNodeValue))) {
                    return JSIdenticalNode.doStringNotString(leftNodeValue, rightNodeValue);
                }
            }
            if ((state & 0x200000L) != 0 /* is-active doNumberCached(Object, Object, Class<>, Class<>) */) {
                NumberCachedData s22_ = this.numberCached_cache;
                while (s22_ != null) {
                    assert (s22_.cachedClassA_ != null);
                    assert (s22_.cachedClassB_ != null);
                    if ((leftNodeValue.getClass() == s22_.cachedClassA_) && (rightNodeValue.getClass() == s22_.cachedClassB_)) {
                        return doNumberCached(leftNodeValue, rightNodeValue, s22_.cachedClassA_, s22_.cachedClassB_);
                    }
                    s22_ = s22_.next_;
                }
            }
        }
        if ((state & 0x400000L) != 0 /* is-active doNumber(Number, Number) */ && leftNodeValue instanceof Number) {
            Number leftNodeValue_ = (Number) leftNodeValue;
            if (rightNodeValue instanceof Number) {
                Number rightNodeValue_ = (Number) rightNodeValue;
                if ((JSRuntime.isJavaNumber(leftNodeValue_)) && (JSRuntime.isJavaNumber(rightNodeValue_))) {
                    return doNumber(leftNodeValue_, rightNodeValue_);
                }
            }
        }
        if ((state & 0x800000L) != 0 /* is-active doTruffleJavaObjects(TruffleObject, TruffleObject) */ && leftNodeValue instanceof TruffleObject) {
            TruffleObject leftNodeValue_ = (TruffleObject) leftNodeValue;
            if (rightNodeValue instanceof TruffleObject) {
                TruffleObject rightNodeValue_ = (TruffleObject) rightNodeValue;
                if ((JSGuards.isTruffleJavaObject(leftNodeValue_)) && (JSGuards.isTruffleJavaObject(rightNodeValue_))) {
                    return JSIdenticalNode.doTruffleJavaObjects(leftNodeValue_, rightNodeValue_);
                }
            }
        }
        if ((state & 0x1000000L) != 0 /* is-active doFallback(Object, Object) */) {
            if (fallbackGuard_(state, leftNodeValue, rightNodeValue)) {
                return JSIdenticalNode.doFallback(leftNodeValue, rightNodeValue);
            }
        }
        CompilerDirectives.transferToInterpreterAndInvalidate();
        return executeAndSpecialize(leftNodeValue, rightNodeValue);
    }

    @Override
    public boolean executeBoolean(VirtualFrame frameValue) {
        long state = state_;
        if ((state & 0x1fffffeL) == 0 /* only-active doInt(int, int) */ && (state & 0x1ffffffL) != 0  /* is-not doInt(int, int) && doDouble(double, double) && doBoolean(boolean, boolean) && doBigInt(BigInt, BigInt) && doBigIntDouble(BigInt, double) && doDoubleBigInt(double, BigInt) && doObject(DynamicObject, DynamicObject) && doLazyStringReference(JSLazyString, JSLazyString) && doLazyString(JSLazyString, JSLazyString, ConditionProfile, ConditionProfile, ConditionProfile) && doLazyStringLeft(String, JSLazyString, ConditionProfile, ConditionProfile) && doLazyStringRight(JSLazyString, String, ConditionProfile, ConditionProfile) && doStringIdentity(String, String) && doString(String, String) && doSymbol(Symbol, Symbol) && doBooleanNotBoolean(Object, Object) && doSymbolNotSymbol(Object, Object) && doNullNotNull(Object, Object) && doUndefinedNotUndefined(Object, Object) && doDifferentTypesCached(Object, Object, Class<>, Class<>) && doNumberNotNumber(Object, Object) && doStringNotString(Object, Object) && doNumberCached(Object, Object, Class<>, Class<>) && doNumber(Number, Number) && doTruffleJavaObjects(TruffleObject, TruffleObject) && doFallback(Object, Object) */) {
            return executeBoolean_int_int0(frameValue, state);
        } else if ((state & 0x1fffffdL) == 0 /* only-active doDouble(double, double) */ && (state & 0x1ffffffL) != 0  /* is-not doInt(int, int) && doDouble(double, double) && doBoolean(boolean, boolean) && doBigInt(BigInt, BigInt) && doBigIntDouble(BigInt, double) && doDoubleBigInt(double, BigInt) && doObject(DynamicObject, DynamicObject) && doLazyStringReference(JSLazyString, JSLazyString) && doLazyString(JSLazyString, JSLazyString, ConditionProfile, ConditionProfile, ConditionProfile) && doLazyStringLeft(String, JSLazyString, ConditionProfile, ConditionProfile) && doLazyStringRight(JSLazyString, String, ConditionProfile, ConditionProfile) && doStringIdentity(String, String) && doString(String, String) && doSymbol(Symbol, Symbol) && doBooleanNotBoolean(Object, Object) && doSymbolNotSymbol(Object, Object) && doNullNotNull(Object, Object) && doUndefinedNotUndefined(Object, Object) && doDifferentTypesCached(Object, Object, Class<>, Class<>) && doNumberNotNumber(Object, Object) && doStringNotString(Object, Object) && doNumberCached(Object, Object, Class<>, Class<>) && doNumber(Number, Number) && doTruffleJavaObjects(TruffleObject, TruffleObject) && doFallback(Object, Object) */) {
            return executeBoolean_double_double1(frameValue, state);
        } else if ((state & 0x1fffffbL) == 0 /* only-active doBoolean(boolean, boolean) */ && (state & 0x1ffffffL) != 0  /* is-not doInt(int, int) && doDouble(double, double) && doBoolean(boolean, boolean) && doBigInt(BigInt, BigInt) && doBigIntDouble(BigInt, double) && doDoubleBigInt(double, BigInt) && doObject(DynamicObject, DynamicObject) && doLazyStringReference(JSLazyString, JSLazyString) && doLazyString(JSLazyString, JSLazyString, ConditionProfile, ConditionProfile, ConditionProfile) && doLazyStringLeft(String, JSLazyString, ConditionProfile, ConditionProfile) && doLazyStringRight(JSLazyString, String, ConditionProfile, ConditionProfile) && doStringIdentity(String, String) && doString(String, String) && doSymbol(Symbol, Symbol) && doBooleanNotBoolean(Object, Object) && doSymbolNotSymbol(Object, Object) && doNullNotNull(Object, Object) && doUndefinedNotUndefined(Object, Object) && doDifferentTypesCached(Object, Object, Class<>, Class<>) && doNumberNotNumber(Object, Object) && doStringNotString(Object, Object) && doNumberCached(Object, Object, Class<>, Class<>) && doNumber(Number, Number) && doTruffleJavaObjects(TruffleObject, TruffleObject) && doFallback(Object, Object) */) {
            return executeBoolean_boolean_boolean2(frameValue, state);
        } else if ((state & 0x1ffffefL) == 0 /* only-active doBigIntDouble(BigInt, double) */ && (state & 0x1ffffffL) != 0  /* is-not doInt(int, int) && doDouble(double, double) && doBoolean(boolean, boolean) && doBigInt(BigInt, BigInt) && doBigIntDouble(BigInt, double) && doDoubleBigInt(double, BigInt) && doObject(DynamicObject, DynamicObject) && doLazyStringReference(JSLazyString, JSLazyString) && doLazyString(JSLazyString, JSLazyString, ConditionProfile, ConditionProfile, ConditionProfile) && doLazyStringLeft(String, JSLazyString, ConditionProfile, ConditionProfile) && doLazyStringRight(JSLazyString, String, ConditionProfile, ConditionProfile) && doStringIdentity(String, String) && doString(String, String) && doSymbol(Symbol, Symbol) && doBooleanNotBoolean(Object, Object) && doSymbolNotSymbol(Object, Object) && doNullNotNull(Object, Object) && doUndefinedNotUndefined(Object, Object) && doDifferentTypesCached(Object, Object, Class<>, Class<>) && doNumberNotNumber(Object, Object) && doStringNotString(Object, Object) && doNumberCached(Object, Object, Class<>, Class<>) && doNumber(Number, Number) && doTruffleJavaObjects(TruffleObject, TruffleObject) && doFallback(Object, Object) */) {
            return executeBoolean_double3(frameValue, state);
        } else if ((state & 0x1ffffdfL) == 0 /* only-active doDoubleBigInt(double, BigInt) */ && (state & 0x1ffffffL) != 0  /* is-not doInt(int, int) && doDouble(double, double) && doBoolean(boolean, boolean) && doBigInt(BigInt, BigInt) && doBigIntDouble(BigInt, double) && doDoubleBigInt(double, BigInt) && doObject(DynamicObject, DynamicObject) && doLazyStringReference(JSLazyString, JSLazyString) && doLazyString(JSLazyString, JSLazyString, ConditionProfile, ConditionProfile, ConditionProfile) && doLazyStringLeft(String, JSLazyString, ConditionProfile, ConditionProfile) && doLazyStringRight(JSLazyString, String, ConditionProfile, ConditionProfile) && doStringIdentity(String, String) && doString(String, String) && doSymbol(Symbol, Symbol) && doBooleanNotBoolean(Object, Object) && doSymbolNotSymbol(Object, Object) && doNullNotNull(Object, Object) && doUndefinedNotUndefined(Object, Object) && doDifferentTypesCached(Object, Object, Class<>, Class<>) && doNumberNotNumber(Object, Object) && doStringNotString(Object, Object) && doNumberCached(Object, Object, Class<>, Class<>) && doNumber(Number, Number) && doTruffleJavaObjects(TruffleObject, TruffleObject) && doFallback(Object, Object) */) {
            return executeBoolean_double4(frameValue, state);
        } else {
            return executeBoolean_generic5(frameValue, state);
        }
    }

    private boolean executeBoolean_int_int0(VirtualFrame frameValue, long state) {
        int leftNodeValue_;
        try {
            leftNodeValue_ = super.leftNode.executeInt(frameValue);
        } catch (UnexpectedResultException ex) {
            Object rightNodeValue = super.rightNode.execute(frameValue);
            return executeAndSpecialize(ex.getResult(), rightNodeValue);
        }
        int rightNodeValue_;
        try {
            rightNodeValue_ = super.rightNode.executeInt(frameValue);
        } catch (UnexpectedResultException ex) {
            return executeAndSpecialize(leftNodeValue_, ex.getResult());
        }
        assert (state & 0b1) != 0 /* is-active doInt(int, int) */;
        return JSIdenticalNode.doInt(leftNodeValue_, rightNodeValue_);
    }

    private boolean executeBoolean_double_double1(VirtualFrame frameValue, long state) {
        int leftNodeValue_int = 0;
        long leftNodeValue_long = 0L;
        double leftNodeValue_;
        try {
            if ((state & 0x1c000000L) == 0 /* only-active 0:double */ && (state & 0x1ffffffL) != 0  /* is-not doInt(int, int) && doDouble(double, double) && doBoolean(boolean, boolean) && doBigInt(BigInt, BigInt) && doBigIntDouble(BigInt, double) && doDoubleBigInt(double, BigInt) && doObject(DynamicObject, DynamicObject) && doLazyStringReference(JSLazyString, JSLazyString) && doLazyString(JSLazyString, JSLazyString, ConditionProfile, ConditionProfile, ConditionProfile) && doLazyStringLeft(String, JSLazyString, ConditionProfile, ConditionProfile) && doLazyStringRight(JSLazyString, String, ConditionProfile, ConditionProfile) && doStringIdentity(String, String) && doString(String, String) && doSymbol(Symbol, Symbol) && doBooleanNotBoolean(Object, Object) && doSymbolNotSymbol(Object, Object) && doNullNotNull(Object, Object) && doUndefinedNotUndefined(Object, Object) && doDifferentTypesCached(Object, Object, Class<>, Class<>) && doNumberNotNumber(Object, Object) && doStringNotString(Object, Object) && doNumberCached(Object, Object, Class<>, Class<>) && doNumber(Number, Number) && doTruffleJavaObjects(TruffleObject, TruffleObject) && doFallback(Object, Object) */) {
                leftNodeValue_long = super.leftNode.executeLong(frameValue);
                leftNodeValue_ = JSTypes.longToDouble(leftNodeValue_long);
            } else if ((state & 0x1a000000L) == 0 /* only-active 0:double */ && (state & 0x1ffffffL) != 0  /* is-not doInt(int, int) && doDouble(double, double) && doBoolean(boolean, boolean) && doBigInt(BigInt, BigInt) && doBigIntDouble(BigInt, double) && doDoubleBigInt(double, BigInt) && doObject(DynamicObject, DynamicObject) && doLazyStringReference(JSLazyString, JSLazyString) && doLazyString(JSLazyString, JSLazyString, ConditionProfile, ConditionProfile, ConditionProfile) && doLazyStringLeft(String, JSLazyString, ConditionProfile, ConditionProfile) && doLazyStringRight(JSLazyString, String, ConditionProfile, ConditionProfile) && doStringIdentity(String, String) && doString(String, String) && doSymbol(Symbol, Symbol) && doBooleanNotBoolean(Object, Object) && doSymbolNotSymbol(Object, Object) && doNullNotNull(Object, Object) && doUndefinedNotUndefined(Object, Object) && doDifferentTypesCached(Object, Object, Class<>, Class<>) && doNumberNotNumber(Object, Object) && doStringNotString(Object, Object) && doNumberCached(Object, Object, Class<>, Class<>) && doNumber(Number, Number) && doTruffleJavaObjects(TruffleObject, TruffleObject) && doFallback(Object, Object) */) {
                leftNodeValue_int = super.leftNode.executeInt(frameValue);
                leftNodeValue_ = JSTypes.intToDouble(leftNodeValue_int);
            } else if ((state & 0x16000000L) == 0 /* only-active 0:double */ && (state & 0x1ffffffL) != 0  /* is-not doInt(int, int) && doDouble(double, double) && doBoolean(boolean, boolean) && doBigInt(BigInt, BigInt) && doBigIntDouble(BigInt, double) && doDoubleBigInt(double, BigInt) && doObject(DynamicObject, DynamicObject) && doLazyStringReference(JSLazyString, JSLazyString) && doLazyString(JSLazyString, JSLazyString, ConditionProfile, ConditionProfile, ConditionProfile) && doLazyStringLeft(String, JSLazyString, ConditionProfile, ConditionProfile) && doLazyStringRight(JSLazyString, String, ConditionProfile, ConditionProfile) && doStringIdentity(String, String) && doString(String, String) && doSymbol(Symbol, Symbol) && doBooleanNotBoolean(Object, Object) && doSymbolNotSymbol(Object, Object) && doNullNotNull(Object, Object) && doUndefinedNotUndefined(Object, Object) && doDifferentTypesCached(Object, Object, Class<>, Class<>) && doNumberNotNumber(Object, Object) && doStringNotString(Object, Object) && doNumberCached(Object, Object, Class<>, Class<>) && doNumber(Number, Number) && doTruffleJavaObjects(TruffleObject, TruffleObject) && doFallback(Object, Object) */) {
                leftNodeValue_ = super.leftNode.executeDouble(frameValue);
            } else {
                Object leftNodeValue__ = super.leftNode.execute(frameValue);
                leftNodeValue_ = JSTypesGen.expectImplicitDouble((int)((state & 0x1e000000L) >>> 25) /* extract-implicit-active 0:double */, leftNodeValue__);
            }
        } catch (UnexpectedResultException ex) {
            Object rightNodeValue = super.rightNode.execute(frameValue);
            return executeAndSpecialize(ex.getResult(), rightNodeValue);
        }
        int rightNodeValue_int = 0;
        long rightNodeValue_long = 0L;
        double rightNodeValue_;
        try {
            if ((state & 0x1c0000000L) == 0 /* only-active 1:double */ && (state & 0x1ffffffL) != 0  /* is-not doInt(int, int) && doDouble(double, double) && doBoolean(boolean, boolean) && doBigInt(BigInt, BigInt) && doBigIntDouble(BigInt, double) && doDoubleBigInt(double, BigInt) && doObject(DynamicObject, DynamicObject) && doLazyStringReference(JSLazyString, JSLazyString) && doLazyString(JSLazyString, JSLazyString, ConditionProfile, ConditionProfile, ConditionProfile) && doLazyStringLeft(String, JSLazyString, ConditionProfile, ConditionProfile) && doLazyStringRight(JSLazyString, String, ConditionProfile, ConditionProfile) && doStringIdentity(String, String) && doString(String, String) && doSymbol(Symbol, Symbol) && doBooleanNotBoolean(Object, Object) && doSymbolNotSymbol(Object, Object) && doNullNotNull(Object, Object) && doUndefinedNotUndefined(Object, Object) && doDifferentTypesCached(Object, Object, Class<>, Class<>) && doNumberNotNumber(Object, Object) && doStringNotString(Object, Object) && doNumberCached(Object, Object, Class<>, Class<>) && doNumber(Number, Number) && doTruffleJavaObjects(TruffleObject, TruffleObject) && doFallback(Object, Object) */) {
                rightNodeValue_long = super.rightNode.executeLong(frameValue);
                rightNodeValue_ = JSTypes.longToDouble(rightNodeValue_long);
            } else if ((state & 0x1a0000000L) == 0 /* only-active 1:double */ && (state & 0x1ffffffL) != 0  /* is-not doInt(int, int) && doDouble(double, double) && doBoolean(boolean, boolean) && doBigInt(BigInt, BigInt) && doBigIntDouble(BigInt, double) && doDoubleBigInt(double, BigInt) && doObject(DynamicObject, DynamicObject) && doLazyStringReference(JSLazyString, JSLazyString) && doLazyString(JSLazyString, JSLazyString, ConditionProfile, ConditionProfile, ConditionProfile) && doLazyStringLeft(String, JSLazyString, ConditionProfile, ConditionProfile) && doLazyStringRight(JSLazyString, String, ConditionProfile, ConditionProfile) && doStringIdentity(String, String) && doString(String, String) && doSymbol(Symbol, Symbol) && doBooleanNotBoolean(Object, Object) && doSymbolNotSymbol(Object, Object) && doNullNotNull(Object, Object) && doUndefinedNotUndefined(Object, Object) && doDifferentTypesCached(Object, Object, Class<>, Class<>) && doNumberNotNumber(Object, Object) && doStringNotString(Object, Object) && doNumberCached(Object, Object, Class<>, Class<>) && doNumber(Number, Number) && doTruffleJavaObjects(TruffleObject, TruffleObject) && doFallback(Object, Object) */) {
                rightNodeValue_int = super.rightNode.executeInt(frameValue);
                rightNodeValue_ = JSTypes.intToDouble(rightNodeValue_int);
            } else if ((state & 0x160000000L) == 0 /* only-active 1:double */ && (state & 0x1ffffffL) != 0  /* is-not doInt(int, int) && doDouble(double, double) && doBoolean(boolean, boolean) && doBigInt(BigInt, BigInt) && doBigIntDouble(BigInt, double) && doDoubleBigInt(double, BigInt) && doObject(DynamicObject, DynamicObject) && doLazyStringReference(JSLazyString, JSLazyString) && doLazyString(JSLazyString, JSLazyString, ConditionProfile, ConditionProfile, ConditionProfile) && doLazyStringLeft(String, JSLazyString, ConditionProfile, ConditionProfile) && doLazyStringRight(JSLazyString, String, ConditionProfile, ConditionProfile) && doStringIdentity(String, String) && doString(String, String) && doSymbol(Symbol, Symbol) && doBooleanNotBoolean(Object, Object) && doSymbolNotSymbol(Object, Object) && doNullNotNull(Object, Object) && doUndefinedNotUndefined(Object, Object) && doDifferentTypesCached(Object, Object, Class<>, Class<>) && doNumberNotNumber(Object, Object) && doStringNotString(Object, Object) && doNumberCached(Object, Object, Class<>, Class<>) && doNumber(Number, Number) && doTruffleJavaObjects(TruffleObject, TruffleObject) && doFallback(Object, Object) */) {
                rightNodeValue_ = super.rightNode.executeDouble(frameValue);
            } else {
                Object rightNodeValue__ = super.rightNode.execute(frameValue);
                rightNodeValue_ = JSTypesGen.expectImplicitDouble((int)((state & 0x1e0000000L) >>> 29) /* extract-implicit-active 1:double */, rightNodeValue__);
            }
        } catch (UnexpectedResultException ex) {
            return executeAndSpecialize(((state & 0x1c000000L) == 0 /* only-active 0:double */ && (state & 0x1ffffffL) != 0  /* is-not doInt(int, int) && doDouble(double, double) && doBoolean(boolean, boolean) && doBigInt(BigInt, BigInt) && doBigIntDouble(BigInt, double) && doDoubleBigInt(double, BigInt) && doObject(DynamicObject, DynamicObject) && doLazyStringReference(JSLazyString, JSLazyString) && doLazyString(JSLazyString, JSLazyString, ConditionProfile, ConditionProfile, ConditionProfile) && doLazyStringLeft(String, JSLazyString, ConditionProfile, ConditionProfile) && doLazyStringRight(JSLazyString, String, ConditionProfile, ConditionProfile) && doStringIdentity(String, String) && doString(String, String) && doSymbol(Symbol, Symbol) && doBooleanNotBoolean(Object, Object) && doSymbolNotSymbol(Object, Object) && doNullNotNull(Object, Object) && doUndefinedNotUndefined(Object, Object) && doDifferentTypesCached(Object, Object, Class<>, Class<>) && doNumberNotNumber(Object, Object) && doStringNotString(Object, Object) && doNumberCached(Object, Object, Class<>, Class<>) && doNumber(Number, Number) && doTruffleJavaObjects(TruffleObject, TruffleObject) && doFallback(Object, Object) */ ? (Object) leftNodeValue_long : ((state & 0x1a000000L) == 0 /* only-active 0:double */ && (state & 0x1ffffffL) != 0  /* is-not doInt(int, int) && doDouble(double, double) && doBoolean(boolean, boolean) && doBigInt(BigInt, BigInt) && doBigIntDouble(BigInt, double) && doDoubleBigInt(double, BigInt) && doObject(DynamicObject, DynamicObject) && doLazyStringReference(JSLazyString, JSLazyString) && doLazyString(JSLazyString, JSLazyString, ConditionProfile, ConditionProfile, ConditionProfile) && doLazyStringLeft(String, JSLazyString, ConditionProfile, ConditionProfile) && doLazyStringRight(JSLazyString, String, ConditionProfile, ConditionProfile) && doStringIdentity(String, String) && doString(String, String) && doSymbol(Symbol, Symbol) && doBooleanNotBoolean(Object, Object) && doSymbolNotSymbol(Object, Object) && doNullNotNull(Object, Object) && doUndefinedNotUndefined(Object, Object) && doDifferentTypesCached(Object, Object, Class<>, Class<>) && doNumberNotNumber(Object, Object) && doStringNotString(Object, Object) && doNumberCached(Object, Object, Class<>, Class<>) && doNumber(Number, Number) && doTruffleJavaObjects(TruffleObject, TruffleObject) && doFallback(Object, Object) */ ? (Object) leftNodeValue_int : (Object) leftNodeValue_)), ex.getResult());
        }
        assert (state & 0b10) != 0 /* is-active doDouble(double, double) */;
        return doDouble(leftNodeValue_, rightNodeValue_);
    }

    private boolean executeBoolean_boolean_boolean2(VirtualFrame frameValue, long state) {
        boolean leftNodeValue_;
        try {
            leftNodeValue_ = super.leftNode.executeBoolean(frameValue);
        } catch (UnexpectedResultException ex) {
            Object rightNodeValue = super.rightNode.execute(frameValue);
            return executeAndSpecialize(ex.getResult(), rightNodeValue);
        }
        boolean rightNodeValue_;
        try {
            rightNodeValue_ = super.rightNode.executeBoolean(frameValue);
        } catch (UnexpectedResultException ex) {
            return executeAndSpecialize(leftNodeValue_, ex.getResult());
        }
        assert (state & 0b100) != 0 /* is-active doBoolean(boolean, boolean) */;
        return JSIdenticalNode.doBoolean(leftNodeValue_, rightNodeValue_);
    }

    private boolean executeBoolean_double3(VirtualFrame frameValue, long state) {
        Object leftNodeValue_ = super.leftNode.execute(frameValue);
        int rightNodeValue_int = 0;
        long rightNodeValue_long = 0L;
        double rightNodeValue_;
        try {
            if ((state & 0x1c0000000L) == 0 /* only-active 1:double */ && (state & 0x1ffffffL) != 0  /* is-not doInt(int, int) && doDouble(double, double) && doBoolean(boolean, boolean) && doBigInt(BigInt, BigInt) && doBigIntDouble(BigInt, double) && doDoubleBigInt(double, BigInt) && doObject(DynamicObject, DynamicObject) && doLazyStringReference(JSLazyString, JSLazyString) && doLazyString(JSLazyString, JSLazyString, ConditionProfile, ConditionProfile, ConditionProfile) && doLazyStringLeft(String, JSLazyString, ConditionProfile, ConditionProfile) && doLazyStringRight(JSLazyString, String, ConditionProfile, ConditionProfile) && doStringIdentity(String, String) && doString(String, String) && doSymbol(Symbol, Symbol) && doBooleanNotBoolean(Object, Object) && doSymbolNotSymbol(Object, Object) && doNullNotNull(Object, Object) && doUndefinedNotUndefined(Object, Object) && doDifferentTypesCached(Object, Object, Class<>, Class<>) && doNumberNotNumber(Object, Object) && doStringNotString(Object, Object) && doNumberCached(Object, Object, Class<>, Class<>) && doNumber(Number, Number) && doTruffleJavaObjects(TruffleObject, TruffleObject) && doFallback(Object, Object) */) {
                rightNodeValue_long = super.rightNode.executeLong(frameValue);
                rightNodeValue_ = JSTypes.longToDouble(rightNodeValue_long);
            } else if ((state & 0x1a0000000L) == 0 /* only-active 1:double */ && (state & 0x1ffffffL) != 0  /* is-not doInt(int, int) && doDouble(double, double) && doBoolean(boolean, boolean) && doBigInt(BigInt, BigInt) && doBigIntDouble(BigInt, double) && doDoubleBigInt(double, BigInt) && doObject(DynamicObject, DynamicObject) && doLazyStringReference(JSLazyString, JSLazyString) && doLazyString(JSLazyString, JSLazyString, ConditionProfile, ConditionProfile, ConditionProfile) && doLazyStringLeft(String, JSLazyString, ConditionProfile, ConditionProfile) && doLazyStringRight(JSLazyString, String, ConditionProfile, ConditionProfile) && doStringIdentity(String, String) && doString(String, String) && doSymbol(Symbol, Symbol) && doBooleanNotBoolean(Object, Object) && doSymbolNotSymbol(Object, Object) && doNullNotNull(Object, Object) && doUndefinedNotUndefined(Object, Object) && doDifferentTypesCached(Object, Object, Class<>, Class<>) && doNumberNotNumber(Object, Object) && doStringNotString(Object, Object) && doNumberCached(Object, Object, Class<>, Class<>) && doNumber(Number, Number) && doTruffleJavaObjects(TruffleObject, TruffleObject) && doFallback(Object, Object) */) {
                rightNodeValue_int = super.rightNode.executeInt(frameValue);
                rightNodeValue_ = JSTypes.intToDouble(rightNodeValue_int);
            } else if ((state & 0x160000000L) == 0 /* only-active 1:double */ && (state & 0x1ffffffL) != 0  /* is-not doInt(int, int) && doDouble(double, double) && doBoolean(boolean, boolean) && doBigInt(BigInt, BigInt) && doBigIntDouble(BigInt, double) && doDoubleBigInt(double, BigInt) && doObject(DynamicObject, DynamicObject) && doLazyStringReference(JSLazyString, JSLazyString) && doLazyString(JSLazyString, JSLazyString, ConditionProfile, ConditionProfile, ConditionProfile) && doLazyStringLeft(String, JSLazyString, ConditionProfile, ConditionProfile) && doLazyStringRight(JSLazyString, String, ConditionProfile, ConditionProfile) && doStringIdentity(String, String) && doString(String, String) && doSymbol(Symbol, Symbol) && doBooleanNotBoolean(Object, Object) && doSymbolNotSymbol(Object, Object) && doNullNotNull(Object, Object) && doUndefinedNotUndefined(Object, Object) && doDifferentTypesCached(Object, Object, Class<>, Class<>) && doNumberNotNumber(Object, Object) && doStringNotString(Object, Object) && doNumberCached(Object, Object, Class<>, Class<>) && doNumber(Number, Number) && doTruffleJavaObjects(TruffleObject, TruffleObject) && doFallback(Object, Object) */) {
                rightNodeValue_ = super.rightNode.executeDouble(frameValue);
            } else {
                Object rightNodeValue__ = super.rightNode.execute(frameValue);
                rightNodeValue_ = JSTypesGen.expectImplicitDouble((int)((state & 0x1e0000000L) >>> 29) /* extract-implicit-active 1:double */, rightNodeValue__);
            }
        } catch (UnexpectedResultException ex) {
            return executeAndSpecialize(leftNodeValue_, ex.getResult());
        }
        assert (state & 0b10000) != 0 /* is-active doBigIntDouble(BigInt, double) */;
        if (leftNodeValue_ instanceof BigInt) {
            BigInt leftNodeValue__ = (BigInt) leftNodeValue_;
            return JSIdenticalNode.doBigIntDouble(leftNodeValue__, rightNodeValue_);
        }
        CompilerDirectives.transferToInterpreterAndInvalidate();
        return executeAndSpecialize(leftNodeValue_, ((state & 0x1c0000000L) == 0 /* only-active 1:double */ && (state & 0x1ffffffL) != 0  /* is-not doInt(int, int) && doDouble(double, double) && doBoolean(boolean, boolean) && doBigInt(BigInt, BigInt) && doBigIntDouble(BigInt, double) && doDoubleBigInt(double, BigInt) && doObject(DynamicObject, DynamicObject) && doLazyStringReference(JSLazyString, JSLazyString) && doLazyString(JSLazyString, JSLazyString, ConditionProfile, ConditionProfile, ConditionProfile) && doLazyStringLeft(String, JSLazyString, ConditionProfile, ConditionProfile) && doLazyStringRight(JSLazyString, String, ConditionProfile, ConditionProfile) && doStringIdentity(String, String) && doString(String, String) && doSymbol(Symbol, Symbol) && doBooleanNotBoolean(Object, Object) && doSymbolNotSymbol(Object, Object) && doNullNotNull(Object, Object) && doUndefinedNotUndefined(Object, Object) && doDifferentTypesCached(Object, Object, Class<>, Class<>) && doNumberNotNumber(Object, Object) && doStringNotString(Object, Object) && doNumberCached(Object, Object, Class<>, Class<>) && doNumber(Number, Number) && doTruffleJavaObjects(TruffleObject, TruffleObject) && doFallback(Object, Object) */ ? (Object) rightNodeValue_long : ((state & 0x1a0000000L) == 0 /* only-active 1:double */ && (state & 0x1ffffffL) != 0  /* is-not doInt(int, int) && doDouble(double, double) && doBoolean(boolean, boolean) && doBigInt(BigInt, BigInt) && doBigIntDouble(BigInt, double) && doDoubleBigInt(double, BigInt) && doObject(DynamicObject, DynamicObject) && doLazyStringReference(JSLazyString, JSLazyString) && doLazyString(JSLazyString, JSLazyString, ConditionProfile, ConditionProfile, ConditionProfile) && doLazyStringLeft(String, JSLazyString, ConditionProfile, ConditionProfile) && doLazyStringRight(JSLazyString, String, ConditionProfile, ConditionProfile) && doStringIdentity(String, String) && doString(String, String) && doSymbol(Symbol, Symbol) && doBooleanNotBoolean(Object, Object) && doSymbolNotSymbol(Object, Object) && doNullNotNull(Object, Object) && doUndefinedNotUndefined(Object, Object) && doDifferentTypesCached(Object, Object, Class<>, Class<>) && doNumberNotNumber(Object, Object) && doStringNotString(Object, Object) && doNumberCached(Object, Object, Class<>, Class<>) && doNumber(Number, Number) && doTruffleJavaObjects(TruffleObject, TruffleObject) && doFallback(Object, Object) */ ? (Object) rightNodeValue_int : (Object) rightNodeValue_)));
    }

    private boolean executeBoolean_double4(VirtualFrame frameValue, long state) {
        int leftNodeValue_int = 0;
        long leftNodeValue_long = 0L;
        double leftNodeValue_;
        try {
            if ((state & 0x1c000000L) == 0 /* only-active 0:double */ && (state & 0x1ffffffL) != 0  /* is-not doInt(int, int) && doDouble(double, double) && doBoolean(boolean, boolean) && doBigInt(BigInt, BigInt) && doBigIntDouble(BigInt, double) && doDoubleBigInt(double, BigInt) && doObject(DynamicObject, DynamicObject) && doLazyStringReference(JSLazyString, JSLazyString) && doLazyString(JSLazyString, JSLazyString, ConditionProfile, ConditionProfile, ConditionProfile) && doLazyStringLeft(String, JSLazyString, ConditionProfile, ConditionProfile) && doLazyStringRight(JSLazyString, String, ConditionProfile, ConditionProfile) && doStringIdentity(String, String) && doString(String, String) && doSymbol(Symbol, Symbol) && doBooleanNotBoolean(Object, Object) && doSymbolNotSymbol(Object, Object) && doNullNotNull(Object, Object) && doUndefinedNotUndefined(Object, Object) && doDifferentTypesCached(Object, Object, Class<>, Class<>) && doNumberNotNumber(Object, Object) && doStringNotString(Object, Object) && doNumberCached(Object, Object, Class<>, Class<>) && doNumber(Number, Number) && doTruffleJavaObjects(TruffleObject, TruffleObject) && doFallback(Object, Object) */) {
                leftNodeValue_long = super.leftNode.executeLong(frameValue);
                leftNodeValue_ = JSTypes.longToDouble(leftNodeValue_long);
            } else if ((state & 0x1a000000L) == 0 /* only-active 0:double */ && (state & 0x1ffffffL) != 0  /* is-not doInt(int, int) && doDouble(double, double) && doBoolean(boolean, boolean) && doBigInt(BigInt, BigInt) && doBigIntDouble(BigInt, double) && doDoubleBigInt(double, BigInt) && doObject(DynamicObject, DynamicObject) && doLazyStringReference(JSLazyString, JSLazyString) && doLazyString(JSLazyString, JSLazyString, ConditionProfile, ConditionProfile, ConditionProfile) && doLazyStringLeft(String, JSLazyString, ConditionProfile, ConditionProfile) && doLazyStringRight(JSLazyString, String, ConditionProfile, ConditionProfile) && doStringIdentity(String, String) && doString(String, String) && doSymbol(Symbol, Symbol) && doBooleanNotBoolean(Object, Object) && doSymbolNotSymbol(Object, Object) && doNullNotNull(Object, Object) && doUndefinedNotUndefined(Object, Object) && doDifferentTypesCached(Object, Object, Class<>, Class<>) && doNumberNotNumber(Object, Object) && doStringNotString(Object, Object) && doNumberCached(Object, Object, Class<>, Class<>) && doNumber(Number, Number) && doTruffleJavaObjects(TruffleObject, TruffleObject) && doFallback(Object, Object) */) {
                leftNodeValue_int = super.leftNode.executeInt(frameValue);
                leftNodeValue_ = JSTypes.intToDouble(leftNodeValue_int);
            } else if ((state & 0x16000000L) == 0 /* only-active 0:double */ && (state & 0x1ffffffL) != 0  /* is-not doInt(int, int) && doDouble(double, double) && doBoolean(boolean, boolean) && doBigInt(BigInt, BigInt) && doBigIntDouble(BigInt, double) && doDoubleBigInt(double, BigInt) && doObject(DynamicObject, DynamicObject) && doLazyStringReference(JSLazyString, JSLazyString) && doLazyString(JSLazyString, JSLazyString, ConditionProfile, ConditionProfile, ConditionProfile) && doLazyStringLeft(String, JSLazyString, ConditionProfile, ConditionProfile) && doLazyStringRight(JSLazyString, String, ConditionProfile, ConditionProfile) && doStringIdentity(String, String) && doString(String, String) && doSymbol(Symbol, Symbol) && doBooleanNotBoolean(Object, Object) && doSymbolNotSymbol(Object, Object) && doNullNotNull(Object, Object) && doUndefinedNotUndefined(Object, Object) && doDifferentTypesCached(Object, Object, Class<>, Class<>) && doNumberNotNumber(Object, Object) && doStringNotString(Object, Object) && doNumberCached(Object, Object, Class<>, Class<>) && doNumber(Number, Number) && doTruffleJavaObjects(TruffleObject, TruffleObject) && doFallback(Object, Object) */) {
                leftNodeValue_ = super.leftNode.executeDouble(frameValue);
            } else {
                Object leftNodeValue__ = super.leftNode.execute(frameValue);
                leftNodeValue_ = JSTypesGen.expectImplicitDouble((int)((state & 0x1e000000L) >>> 25) /* extract-implicit-active 0:double */, leftNodeValue__);
            }
        } catch (UnexpectedResultException ex) {
            Object rightNodeValue = super.rightNode.execute(frameValue);
            return executeAndSpecialize(ex.getResult(), rightNodeValue);
        }
        Object rightNodeValue_ = super.rightNode.execute(frameValue);
        assert (state & 0b100000) != 0 /* is-active doDoubleBigInt(double, BigInt) */;
        if (rightNodeValue_ instanceof BigInt) {
            BigInt rightNodeValue__ = (BigInt) rightNodeValue_;
            return JSIdenticalNode.doDoubleBigInt(leftNodeValue_, rightNodeValue__);
        }
        CompilerDirectives.transferToInterpreterAndInvalidate();
        return executeAndSpecialize(((state & 0x1c000000L) == 0 /* only-active 0:double */ && (state & 0x1ffffffL) != 0  /* is-not doInt(int, int) && doDouble(double, double) && doBoolean(boolean, boolean) && doBigInt(BigInt, BigInt) && doBigIntDouble(BigInt, double) && doDoubleBigInt(double, BigInt) && doObject(DynamicObject, DynamicObject) && doLazyStringReference(JSLazyString, JSLazyString) && doLazyString(JSLazyString, JSLazyString, ConditionProfile, ConditionProfile, ConditionProfile) && doLazyStringLeft(String, JSLazyString, ConditionProfile, ConditionProfile) && doLazyStringRight(JSLazyString, String, ConditionProfile, ConditionProfile) && doStringIdentity(String, String) && doString(String, String) && doSymbol(Symbol, Symbol) && doBooleanNotBoolean(Object, Object) && doSymbolNotSymbol(Object, Object) && doNullNotNull(Object, Object) && doUndefinedNotUndefined(Object, Object) && doDifferentTypesCached(Object, Object, Class<>, Class<>) && doNumberNotNumber(Object, Object) && doStringNotString(Object, Object) && doNumberCached(Object, Object, Class<>, Class<>) && doNumber(Number, Number) && doTruffleJavaObjects(TruffleObject, TruffleObject) && doFallback(Object, Object) */ ? (Object) leftNodeValue_long : ((state & 0x1a000000L) == 0 /* only-active 0:double */ && (state & 0x1ffffffL) != 0  /* is-not doInt(int, int) && doDouble(double, double) && doBoolean(boolean, boolean) && doBigInt(BigInt, BigInt) && doBigIntDouble(BigInt, double) && doDoubleBigInt(double, BigInt) && doObject(DynamicObject, DynamicObject) && doLazyStringReference(JSLazyString, JSLazyString) && doLazyString(JSLazyString, JSLazyString, ConditionProfile, ConditionProfile, ConditionProfile) && doLazyStringLeft(String, JSLazyString, ConditionProfile, ConditionProfile) && doLazyStringRight(JSLazyString, String, ConditionProfile, ConditionProfile) && doStringIdentity(String, String) && doString(String, String) && doSymbol(Symbol, Symbol) && doBooleanNotBoolean(Object, Object) && doSymbolNotSymbol(Object, Object) && doNullNotNull(Object, Object) && doUndefinedNotUndefined(Object, Object) && doDifferentTypesCached(Object, Object, Class<>, Class<>) && doNumberNotNumber(Object, Object) && doStringNotString(Object, Object) && doNumberCached(Object, Object, Class<>, Class<>) && doNumber(Number, Number) && doTruffleJavaObjects(TruffleObject, TruffleObject) && doFallback(Object, Object) */ ? (Object) leftNodeValue_int : (Object) leftNodeValue_)), rightNodeValue_);
    }

    @ExplodeLoop
    private boolean executeBoolean_generic5(VirtualFrame frameValue, long state) {
        Object leftNodeValue_ = super.leftNode.execute(frameValue);
        Object rightNodeValue_ = super.rightNode.execute(frameValue);
        if ((state & 0b1) != 0 /* is-active doInt(int, int) */ && leftNodeValue_ instanceof Integer) {
            int leftNodeValue__ = (int) leftNodeValue_;
            if (rightNodeValue_ instanceof Integer) {
                int rightNodeValue__ = (int) rightNodeValue_;
                return JSIdenticalNode.doInt(leftNodeValue__, rightNodeValue__);
            }
        }
        if ((state & 0b10) != 0 /* is-active doDouble(double, double) */ && JSTypesGen.isImplicitDouble((int)((state & 0x1e000000L) >>> 25) /* extract-implicit-active 0:double */, leftNodeValue_)) {
            double leftNodeValue__ = JSTypesGen.asImplicitDouble((int)((state & 0x1e000000L) >>> 25) /* extract-implicit-active 0:double */, leftNodeValue_);
            if (JSTypesGen.isImplicitDouble((int)((state & 0x1e0000000L) >>> 29) /* extract-implicit-active 1:double */, rightNodeValue_)) {
                double rightNodeValue__ = JSTypesGen.asImplicitDouble((int)((state & 0x1e0000000L) >>> 29) /* extract-implicit-active 1:double */, rightNodeValue_);
                return doDouble(leftNodeValue__, rightNodeValue__);
            }
        }
        if ((state & 0b100) != 0 /* is-active doBoolean(boolean, boolean) */ && leftNodeValue_ instanceof Boolean) {
            boolean leftNodeValue__ = (boolean) leftNodeValue_;
            if (rightNodeValue_ instanceof Boolean) {
                boolean rightNodeValue__ = (boolean) rightNodeValue_;
                return JSIdenticalNode.doBoolean(leftNodeValue__, rightNodeValue__);
            }
        }
        if ((state & 0b11000) != 0 /* is-active doBigInt(BigInt, BigInt) || doBigIntDouble(BigInt, double) */ && leftNodeValue_ instanceof BigInt) {
            BigInt leftNodeValue__ = (BigInt) leftNodeValue_;
            if ((state & 0b1000) != 0 /* is-active doBigInt(BigInt, BigInt) */ && rightNodeValue_ instanceof BigInt) {
                BigInt rightNodeValue__ = (BigInt) rightNodeValue_;
                return JSIdenticalNode.doBigInt(leftNodeValue__, rightNodeValue__);
            }
            if ((state & 0b10000) != 0 /* is-active doBigIntDouble(BigInt, double) */ && JSTypesGen.isImplicitDouble((int)((state & 0x1e0000000L) >>> 29) /* extract-implicit-active 1:double */, rightNodeValue_)) {
                double rightNodeValue__ = JSTypesGen.asImplicitDouble((int)((state & 0x1e0000000L) >>> 29) /* extract-implicit-active 1:double */, rightNodeValue_);
                return JSIdenticalNode.doBigIntDouble(leftNodeValue__, rightNodeValue__);
            }
        }
        if ((state & 0b100000) != 0 /* is-active doDoubleBigInt(double, BigInt) */ && JSTypesGen.isImplicitDouble((int)((state & 0x1e000000L) >>> 25) /* extract-implicit-active 0:double */, leftNodeValue_)) {
            double leftNodeValue__ = JSTypesGen.asImplicitDouble((int)((state & 0x1e000000L) >>> 25) /* extract-implicit-active 0:double */, leftNodeValue_);
            if (rightNodeValue_ instanceof BigInt) {
                BigInt rightNodeValue__ = (BigInt) rightNodeValue_;
                return JSIdenticalNode.doDoubleBigInt(leftNodeValue__, rightNodeValue__);
            }
        }
        if ((state & 0b1000000) != 0 /* is-active doObject(DynamicObject, DynamicObject) */ && JSTypes.isDynamicObject(leftNodeValue_)) {
            DynamicObject leftNodeValue__ = (DynamicObject) leftNodeValue_;
            if (JSTypes.isDynamicObject(rightNodeValue_)) {
                DynamicObject rightNodeValue__ = (DynamicObject) rightNodeValue_;
                return JSIdenticalNode.doObject(leftNodeValue__, rightNodeValue__);
            }
        }
        if ((state & 0b1110000000) != 0 /* is-active doLazyStringReference(JSLazyString, JSLazyString) || doLazyString(JSLazyString, JSLazyString, ConditionProfile, ConditionProfile, ConditionProfile) || doLazyStringLeft(String, JSLazyString, ConditionProfile, ConditionProfile) */ && rightNodeValue_ instanceof JSLazyString) {
            JSLazyString rightNodeValue__ = (JSLazyString) rightNodeValue_;
            if ((state & 0b110000000) != 0 /* is-active doLazyStringReference(JSLazyString, JSLazyString) || doLazyString(JSLazyString, JSLazyString, ConditionProfile, ConditionProfile, ConditionProfile) */ && leftNodeValue_ instanceof JSLazyString) {
                JSLazyString leftNodeValue__ = (JSLazyString) leftNodeValue_;
                if ((state & 0b10000000) != 0 /* is-active doLazyStringReference(JSLazyString, JSLazyString) */) {
                    if ((JSGuards.isReferenceEquals(leftNodeValue__, rightNodeValue__))) {
                        return JSIdenticalNode.doLazyStringReference(leftNodeValue__, rightNodeValue__);
                    }
                }
                if ((state & 0b100000000) != 0 /* is-active doLazyString(JSLazyString, JSLazyString, ConditionProfile, ConditionProfile, ConditionProfile) */) {
                    LazyStringData s9_ = this.lazyString_cache;
                    if (s9_ != null) {
                        return JSIdenticalNode.doLazyString(leftNodeValue__, rightNodeValue__, s9_.flattenA_, s9_.flattenB_, s9_.len_);
                    }
                }
            }
            if ((state & 0b1000000000) != 0 /* is-active doLazyStringLeft(String, JSLazyString, ConditionProfile, ConditionProfile) */ && JSTypesGen.isImplicitString((int)((state & 0x1e00000000L) >>> 33) /* extract-implicit-active 0:String */, leftNodeValue_)) {
                String leftNodeValue__ = JSTypesGen.asImplicitString((int)((state & 0x1e00000000L) >>> 33) /* extract-implicit-active 0:String */, leftNodeValue_);
                return JSIdenticalNode.doLazyStringLeft(leftNodeValue__, rightNodeValue__, this.lazyStringLeft_flatten_, this.lazyStringLeft_len_);
            }
        }
        if ((state & 0b1110000000000) != 0 /* is-active doLazyStringRight(JSLazyString, String, ConditionProfile, ConditionProfile) || doStringIdentity(String, String) || doString(String, String) */ && JSTypesGen.isImplicitString((int)((state & 0x1e000000000L) >>> 37) /* extract-implicit-active 1:String */, rightNodeValue_)) {
            String rightNodeValue__ = JSTypesGen.asImplicitString((int)((state & 0x1e000000000L) >>> 37) /* extract-implicit-active 1:String */, rightNodeValue_);
            if ((state & 0b10000000000) != 0 /* is-active doLazyStringRight(JSLazyString, String, ConditionProfile, ConditionProfile) */ && leftNodeValue_ instanceof JSLazyString) {
                JSLazyString leftNodeValue__ = (JSLazyString) leftNodeValue_;
                return JSIdenticalNode.doLazyStringRight(leftNodeValue__, rightNodeValue__, this.lazyStringRight_flatten_, this.lazyStringRight_len_);
            }
            if ((state & 0b1100000000000) != 0 /* is-active doStringIdentity(String, String) || doString(String, String) */ && JSTypesGen.isImplicitString((int)((state & 0x1e00000000L) >>> 33) /* extract-implicit-active 0:String */, leftNodeValue_)) {
                String leftNodeValue__ = JSTypesGen.asImplicitString((int)((state & 0x1e00000000L) >>> 33) /* extract-implicit-active 0:String */, leftNodeValue_);
                if ((state & 0b100000000000) != 0 /* is-active doStringIdentity(String, String) */) {
                    if ((JSGuards.isReferenceEquals(leftNodeValue__, rightNodeValue__))) {
                        return JSIdenticalNode.doStringIdentity(leftNodeValue__, rightNodeValue__);
                    }
                }
                if ((state & 0b1000000000000) != 0 /* is-active doString(String, String) */) {
                    return JSIdenticalNode.doString(leftNodeValue__, rightNodeValue__);
                }
            }
        }
        if ((state & 0b10000000000000) != 0 /* is-active doSymbol(Symbol, Symbol) */ && leftNodeValue_ instanceof Symbol) {
            Symbol leftNodeValue__ = (Symbol) leftNodeValue_;
            if (rightNodeValue_ instanceof Symbol) {
                Symbol rightNodeValue__ = (Symbol) rightNodeValue_;
                return JSIdenticalNode.doSymbol(leftNodeValue__, rightNodeValue__);
            }
        }
        if ((state & 0x3fc000L) != 0 /* is-active doBooleanNotBoolean(Object, Object) || doSymbolNotSymbol(Object, Object) || doNullNotNull(Object, Object) || doUndefinedNotUndefined(Object, Object) || doDifferentTypesCached(Object, Object, Class<>, Class<>) || doNumberNotNumber(Object, Object) || doStringNotString(Object, Object) || doNumberCached(Object, Object, Class<>, Class<>) */) {
            if ((state & 0b100000000000000) != 0 /* is-active doBooleanNotBoolean(Object, Object) */) {
                if ((JSGuards.isBoolean(leftNodeValue_) != JSGuards.isBoolean(rightNodeValue_))) {
                    return JSIdenticalNode.doBooleanNotBoolean(leftNodeValue_, rightNodeValue_);
                }
            }
            if ((state & 0b1000000000000000) != 0 /* is-active doSymbolNotSymbol(Object, Object) */) {
                if ((JSGuards.isSymbol(leftNodeValue_) != JSGuards.isSymbol(rightNodeValue_))) {
                    return JSIdenticalNode.doSymbolNotSymbol(leftNodeValue_, rightNodeValue_);
                }
            }
            if ((state & 0x10000L) != 0 /* is-active doNullNotNull(Object, Object) */) {
                if ((JSGuards.isJSNull(leftNodeValue_) != JSGuards.isJSNull(rightNodeValue_))) {
                    return JSIdenticalNode.doNullNotNull(leftNodeValue_, rightNodeValue_);
                }
            }
            if ((state & 0x20000L) != 0 /* is-active doUndefinedNotUndefined(Object, Object) */) {
                if ((JSGuards.isUndefined(leftNodeValue_) != JSGuards.isUndefined(rightNodeValue_))) {
                    return JSIdenticalNode.doUndefinedNotUndefined(leftNodeValue_, rightNodeValue_);
                }
            }
            if ((state & 0x40000L) != 0 /* is-active doDifferentTypesCached(Object, Object, Class<>, Class<>) */) {
                DifferentTypesCachedData s19_ = this.differentTypesCached_cache;
                while (s19_ != null) {
                    if ((leftNodeValue_.getClass() == s19_.cachedClassA_) && (rightNodeValue_.getClass() == s19_.cachedClassB_)) {
                        assert (JSIdenticalNode.isNonObjectType(s19_.cachedClassA_) || JSIdenticalNode.isNonObjectType(s19_.cachedClassB_));
                        assert (JSIdenticalNode.differentNonObjectTypes(s19_.cachedClassA_, s19_.cachedClassB_));
                        return JSIdenticalNode.doDifferentTypesCached(leftNodeValue_, rightNodeValue_, s19_.cachedClassA_, s19_.cachedClassB_);
                    }
                    s19_ = s19_.next_;
                }
            }
            if ((state & 0x80000L) != 0 /* is-active doNumberNotNumber(Object, Object) */) {
                if ((JSRuntime.isJavaNumber(leftNodeValue_) != JSRuntime.isJavaNumber(rightNodeValue_))) {
                    return JSIdenticalNode.doNumberNotNumber(leftNodeValue_, rightNodeValue_);
                }
            }
            if ((state & 0x100000L) != 0 /* is-active doStringNotString(Object, Object) */) {
                if ((JSRuntime.isString(leftNodeValue_) != JSRuntime.isString(rightNodeValue_))) {
                    return JSIdenticalNode.doStringNotString(leftNodeValue_, rightNodeValue_);
                }
            }
            if ((state & 0x200000L) != 0 /* is-active doNumberCached(Object, Object, Class<>, Class<>) */) {
                NumberCachedData s22_ = this.numberCached_cache;
                while (s22_ != null) {
                    assert (s22_.cachedClassA_ != null);
                    assert (s22_.cachedClassB_ != null);
                    if ((leftNodeValue_.getClass() == s22_.cachedClassA_) && (rightNodeValue_.getClass() == s22_.cachedClassB_)) {
                        return doNumberCached(leftNodeValue_, rightNodeValue_, s22_.cachedClassA_, s22_.cachedClassB_);
                    }
                    s22_ = s22_.next_;
                }
            }
        }
        if ((state & 0x400000L) != 0 /* is-active doNumber(Number, Number) */ && leftNodeValue_ instanceof Number) {
            Number leftNodeValue__ = (Number) leftNodeValue_;
            if (rightNodeValue_ instanceof Number) {
                Number rightNodeValue__ = (Number) rightNodeValue_;
                if ((JSRuntime.isJavaNumber(leftNodeValue__)) && (JSRuntime.isJavaNumber(rightNodeValue__))) {
                    return doNumber(leftNodeValue__, rightNodeValue__);
                }
            }
        }
        if ((state & 0x800000L) != 0 /* is-active doTruffleJavaObjects(TruffleObject, TruffleObject) */ && leftNodeValue_ instanceof TruffleObject) {
            TruffleObject leftNodeValue__ = (TruffleObject) leftNodeValue_;
            if (rightNodeValue_ instanceof TruffleObject) {
                TruffleObject rightNodeValue__ = (TruffleObject) rightNodeValue_;
                if ((JSGuards.isTruffleJavaObject(leftNodeValue__)) && (JSGuards.isTruffleJavaObject(rightNodeValue__))) {
                    return JSIdenticalNode.doTruffleJavaObjects(leftNodeValue__, rightNodeValue__);
                }
            }
        }
        if ((state & 0x1000000L) != 0 /* is-active doFallback(Object, Object) */) {
            if (fallbackGuard_(state, leftNodeValue_, rightNodeValue_)) {
                return JSIdenticalNode.doFallback(leftNodeValue_, rightNodeValue_);
            }
        }
        CompilerDirectives.transferToInterpreterAndInvalidate();
        return executeAndSpecialize(leftNodeValue_, rightNodeValue_);
    }

    @Override
    public void executeVoid(VirtualFrame frameValue) {
        executeBoolean(frameValue);
        return;
    }

    private boolean executeAndSpecialize(Object leftNodeValue, Object rightNodeValue) {
        Lock lock = getLock();
        boolean hasLock = true;
        lock.lock();
        long state = state_;
        int exclude = exclude_;
        long oldState = (state & 0x1ffffffL);
        int oldExclude = exclude;
        int oldCacheCount = state == 0 ? 0 : countCaches();
        try {
            if (leftNodeValue instanceof Integer) {
                int leftNodeValue_ = (int) leftNodeValue;
                if (rightNodeValue instanceof Integer) {
                    int rightNodeValue_ = (int) rightNodeValue;
                    this.state_ = state = state | 0b1 /* add-active doInt(int, int) */;
                    lock.unlock();
                    hasLock = false;
                    return JSIdenticalNode.doInt(leftNodeValue_, rightNodeValue_);
                }
            }
            {
                int doubleCast0;
                if ((doubleCast0 = JSTypesGen.specializeImplicitDouble(leftNodeValue)) != 0) {
                    double leftNodeValue_ = JSTypesGen.asImplicitDouble(doubleCast0, leftNodeValue);
                    int doubleCast1;
                    if ((doubleCast1 = JSTypesGen.specializeImplicitDouble(rightNodeValue)) != 0) {
                        double rightNodeValue_ = JSTypesGen.asImplicitDouble(doubleCast1, rightNodeValue);
                        state = (state | ((long) doubleCast0 << 25) /* set-implicit-active 0:double */);
                        state = (state | ((long) doubleCast1 << 29) /* set-implicit-active 1:double */);
                        this.state_ = state = state | 0b10 /* add-active doDouble(double, double) */;
                        lock.unlock();
                        hasLock = false;
                        return doDouble(leftNodeValue_, rightNodeValue_);
                    }
                }
            }
            if (leftNodeValue instanceof Boolean) {
                boolean leftNodeValue_ = (boolean) leftNodeValue;
                if (rightNodeValue instanceof Boolean) {
                    boolean rightNodeValue_ = (boolean) rightNodeValue;
                    this.state_ = state = state | 0b100 /* add-active doBoolean(boolean, boolean) */;
                    lock.unlock();
                    hasLock = false;
                    return JSIdenticalNode.doBoolean(leftNodeValue_, rightNodeValue_);
                }
            }
            if (leftNodeValue instanceof BigInt) {
                BigInt leftNodeValue_ = (BigInt) leftNodeValue;
                if (rightNodeValue instanceof BigInt) {
                    BigInt rightNodeValue_ = (BigInt) rightNodeValue;
                    this.state_ = state = state | 0b1000 /* add-active doBigInt(BigInt, BigInt) */;
                    lock.unlock();
                    hasLock = false;
                    return JSIdenticalNode.doBigInt(leftNodeValue_, rightNodeValue_);
                }
                {
                    int doubleCast1;
                    if ((doubleCast1 = JSTypesGen.specializeImplicitDouble(rightNodeValue)) != 0) {
                        double rightNodeValue_ = JSTypesGen.asImplicitDouble(doubleCast1, rightNodeValue);
                        state = (state | ((long) doubleCast1 << 29) /* set-implicit-active 1:double */);
                        this.state_ = state = state | 0b10000 /* add-active doBigIntDouble(BigInt, double) */;
                        lock.unlock();
                        hasLock = false;
                        return JSIdenticalNode.doBigIntDouble(leftNodeValue_, rightNodeValue_);
                    }
                }
            }
            {
                int doubleCast0;
                if ((doubleCast0 = JSTypesGen.specializeImplicitDouble(leftNodeValue)) != 0) {
                    double leftNodeValue_ = JSTypesGen.asImplicitDouble(doubleCast0, leftNodeValue);
                    if (rightNodeValue instanceof BigInt) {
                        BigInt rightNodeValue_ = (BigInt) rightNodeValue;
                        state = (state | ((long) doubleCast0 << 25) /* set-implicit-active 0:double */);
                        this.state_ = state = state | 0b100000 /* add-active doDoubleBigInt(double, BigInt) */;
                        lock.unlock();
                        hasLock = false;
                        return JSIdenticalNode.doDoubleBigInt(leftNodeValue_, rightNodeValue_);
                    }
                }
            }
            if (JSTypes.isDynamicObject(leftNodeValue)) {
                DynamicObject leftNodeValue_ = (DynamicObject) leftNodeValue;
                if (JSTypes.isDynamicObject(rightNodeValue)) {
                    DynamicObject rightNodeValue_ = (DynamicObject) rightNodeValue;
                    this.state_ = state = state | 0b1000000 /* add-active doObject(DynamicObject, DynamicObject) */;
                    lock.unlock();
                    hasLock = false;
                    return JSIdenticalNode.doObject(leftNodeValue_, rightNodeValue_);
                }
            }
            if (rightNodeValue instanceof JSLazyString) {
                JSLazyString rightNodeValue_ = (JSLazyString) rightNodeValue;
                if (leftNodeValue instanceof JSLazyString) {
                    JSLazyString leftNodeValue_ = (JSLazyString) leftNodeValue;
                    if (((exclude & 0b1)) == 0 /* is-not-excluded doLazyStringReference(JSLazyString, JSLazyString) */) {
                        if ((JSGuards.isReferenceEquals(leftNodeValue_, rightNodeValue_))) {
                            this.state_ = state = state | 0b10000000 /* add-active doLazyStringReference(JSLazyString, JSLazyString) */;
                            lock.unlock();
                            hasLock = false;
                            return JSIdenticalNode.doLazyStringReference(leftNodeValue_, rightNodeValue_);
                        }
                    }
                    LazyStringData s9_ = new LazyStringData();
                    s9_.flattenA_ = (ConditionProfile.createBinaryProfile());
                    s9_.flattenB_ = (ConditionProfile.createBinaryProfile());
                    s9_.len_ = (ConditionProfile.createBinaryProfile());
                    this.lazyString_cache = s9_;
                    this.exclude_ = exclude = exclude | 0b1 /* add-excluded doLazyStringReference(JSLazyString, JSLazyString) */;
                    state = state & 0xffffffffffffff7fL /* remove-active doLazyStringReference(JSLazyString, JSLazyString) */;
                    this.state_ = state = state | 0b100000000 /* add-active doLazyString(JSLazyString, JSLazyString, ConditionProfile, ConditionProfile, ConditionProfile) */;
                    lock.unlock();
                    hasLock = false;
                    return JSIdenticalNode.doLazyString(leftNodeValue_, rightNodeValue_, s9_.flattenA_, s9_.flattenB_, s9_.len_);
                }
                {
                    int stringCast0;
                    if ((stringCast0 = JSTypesGen.specializeImplicitString(leftNodeValue)) != 0) {
                        String leftNodeValue_ = JSTypesGen.asImplicitString(stringCast0, leftNodeValue);
                        this.lazyStringLeft_flatten_ = (ConditionProfile.createBinaryProfile());
                        this.lazyStringLeft_len_ = (ConditionProfile.createBinaryProfile());
                        state = (state | ((long) stringCast0 << 33) /* set-implicit-active 0:String */);
                        this.state_ = state = state | 0b1000000000 /* add-active doLazyStringLeft(String, JSLazyString, ConditionProfile, ConditionProfile) */;
                        lock.unlock();
                        hasLock = false;
                        return JSIdenticalNode.doLazyStringLeft(leftNodeValue_, rightNodeValue_, this.lazyStringLeft_flatten_, this.lazyStringLeft_len_);
                    }
                }
            }
            {
                int stringCast1;
                if ((stringCast1 = JSTypesGen.specializeImplicitString(rightNodeValue)) != 0) {
                    String rightNodeValue_ = JSTypesGen.asImplicitString(stringCast1, rightNodeValue);
                    if (leftNodeValue instanceof JSLazyString) {
                        JSLazyString leftNodeValue_ = (JSLazyString) leftNodeValue;
                        this.lazyStringRight_flatten_ = (ConditionProfile.createBinaryProfile());
                        this.lazyStringRight_len_ = (ConditionProfile.createBinaryProfile());
                        state = (state | ((long) stringCast1 << 37) /* set-implicit-active 1:String */);
                        this.state_ = state = state | 0b10000000000 /* add-active doLazyStringRight(JSLazyString, String, ConditionProfile, ConditionProfile) */;
                        lock.unlock();
                        hasLock = false;
                        return JSIdenticalNode.doLazyStringRight(leftNodeValue_, rightNodeValue_, this.lazyStringRight_flatten_, this.lazyStringRight_len_);
                    }
                    {
                        int stringCast0;
                        if ((stringCast0 = JSTypesGen.specializeImplicitString(leftNodeValue)) != 0) {
                            String leftNodeValue_ = JSTypesGen.asImplicitString(stringCast0, leftNodeValue);
                            if (((exclude & 0b10)) == 0 /* is-not-excluded doStringIdentity(String, String) */) {
                                if ((JSGuards.isReferenceEquals(leftNodeValue_, rightNodeValue_))) {
                                    state = (state | ((long) stringCast0 << 33) /* set-implicit-active 0:String */);
                                    state = (state | ((long) stringCast1 << 37) /* set-implicit-active 1:String */);
                                    this.state_ = state = state | 0b100000000000 /* add-active doStringIdentity(String, String) */;
                                    lock.unlock();
                                    hasLock = false;
                                    return JSIdenticalNode.doStringIdentity(leftNodeValue_, rightNodeValue_);
                                }
                            }
                            this.exclude_ = exclude = exclude | 0b10 /* add-excluded doStringIdentity(String, String) */;
                            state = state & 0xfffffffffffff7ffL /* remove-active doStringIdentity(String, String) */;
                            state = (state | ((long) stringCast0 << 33) /* set-implicit-active 0:String */);
                            state = (state | ((long) stringCast1 << 37) /* set-implicit-active 1:String */);
                            this.state_ = state = state | 0b1000000000000 /* add-active doString(String, String) */;
                            lock.unlock();
                            hasLock = false;
                            return JSIdenticalNode.doString(leftNodeValue_, rightNodeValue_);
                        }
                    }
                }
            }
            if (leftNodeValue instanceof Symbol) {
                Symbol leftNodeValue_ = (Symbol) leftNodeValue;
                if (rightNodeValue instanceof Symbol) {
                    Symbol rightNodeValue_ = (Symbol) rightNodeValue;
                    this.state_ = state = state | 0b10000000000000 /* add-active doSymbol(Symbol, Symbol) */;
                    lock.unlock();
                    hasLock = false;
                    return JSIdenticalNode.doSymbol(leftNodeValue_, rightNodeValue_);
                }
            }
            if ((JSGuards.isBoolean(leftNodeValue) != JSGuards.isBoolean(rightNodeValue))) {
                this.state_ = state = state | 0b100000000000000 /* add-active doBooleanNotBoolean(Object, Object) */;
                lock.unlock();
                hasLock = false;
                return JSIdenticalNode.doBooleanNotBoolean(leftNodeValue, rightNodeValue);
            }
            if ((JSGuards.isSymbol(leftNodeValue) != JSGuards.isSymbol(rightNodeValue))) {
                this.state_ = state = state | 0b1000000000000000 /* add-active doSymbolNotSymbol(Object, Object) */;
                lock.unlock();
                hasLock = false;
                return JSIdenticalNode.doSymbolNotSymbol(leftNodeValue, rightNodeValue);
            }
            if ((JSGuards.isJSNull(leftNodeValue) != JSGuards.isJSNull(rightNodeValue))) {
                this.state_ = state = state | 0x10000L /* add-active doNullNotNull(Object, Object) */;
                lock.unlock();
                hasLock = false;
                return JSIdenticalNode.doNullNotNull(leftNodeValue, rightNodeValue);
            }
            if ((JSGuards.isUndefined(leftNodeValue) != JSGuards.isUndefined(rightNodeValue))) {
                this.state_ = state = state | 0x20000L /* add-active doUndefinedNotUndefined(Object, Object) */;
                lock.unlock();
                hasLock = false;
                return JSIdenticalNode.doUndefinedNotUndefined(leftNodeValue, rightNodeValue);
            }
            if (((exclude & 0b100)) == 0 /* is-not-excluded doDifferentTypesCached(Object, Object, Class<>, Class<>) */) {
                int count19_ = 0;
                DifferentTypesCachedData s19_ = this.differentTypesCached_cache;
                if ((state & 0x40000L) != 0 /* is-active doDifferentTypesCached(Object, Object, Class<>, Class<>) */) {
                    while (s19_ != null) {
                        if ((leftNodeValue.getClass() == s19_.cachedClassA_) && (rightNodeValue.getClass() == s19_.cachedClassB_)) {
                            assert (JSIdenticalNode.isNonObjectType(s19_.cachedClassA_) || JSIdenticalNode.isNonObjectType(s19_.cachedClassB_));
                            assert (JSIdenticalNode.differentNonObjectTypes(s19_.cachedClassA_, s19_.cachedClassB_));
                            break;
                        }
                        s19_ = s19_.next_;
                        count19_++;
                    }
                }
                if (s19_ == null) {
                    {
                        Class<?> cachedClassA__ = (leftNodeValue.getClass());
                        if ((leftNodeValue.getClass() == cachedClassA__)) {
                            Class<?> cachedClassB__ = (rightNodeValue.getClass());
                            if ((rightNodeValue.getClass() == cachedClassB__) && (JSIdenticalNode.isNonObjectType(cachedClassA__) || JSIdenticalNode.isNonObjectType(cachedClassB__)) && (JSIdenticalNode.differentNonObjectTypes(cachedClassA__, cachedClassB__)) && count19_ < (JSIdenticalNode.MAX_CLASSES)) {
                                s19_ = new DifferentTypesCachedData(differentTypesCached_cache);
                                s19_.cachedClassA_ = cachedClassA__;
                                s19_.cachedClassB_ = cachedClassB__;
                                this.differentTypesCached_cache = s19_;
                                this.state_ = state = state | 0x40000L /* add-active doDifferentTypesCached(Object, Object, Class<>, Class<>) */;
                            }
                        }
                    }
                }
                if (s19_ != null) {
                    lock.unlock();
                    hasLock = false;
                    return JSIdenticalNode.doDifferentTypesCached(leftNodeValue, rightNodeValue, s19_.cachedClassA_, s19_.cachedClassB_);
                }
            }
            if ((JSRuntime.isJavaNumber(leftNodeValue) != JSRuntime.isJavaNumber(rightNodeValue))) {
                this.exclude_ = exclude = exclude | 0b100 /* add-excluded doDifferentTypesCached(Object, Object, Class<>, Class<>) */;
                this.differentTypesCached_cache = null;
                state = state & 0xfffffffffffbffffL /* remove-active doDifferentTypesCached(Object, Object, Class<>, Class<>) */;
                this.state_ = state = state | 0x80000L /* add-active doNumberNotNumber(Object, Object) */;
                lock.unlock();
                hasLock = false;
                return JSIdenticalNode.doNumberNotNumber(leftNodeValue, rightNodeValue);
            }
            if ((JSRuntime.isString(leftNodeValue) != JSRuntime.isString(rightNodeValue))) {
                this.exclude_ = exclude = exclude | 0b100 /* add-excluded doDifferentTypesCached(Object, Object, Class<>, Class<>) */;
                this.differentTypesCached_cache = null;
                state = state & 0xfffffffffffbffffL /* remove-active doDifferentTypesCached(Object, Object, Class<>, Class<>) */;
                this.state_ = state = state | 0x100000L /* add-active doStringNotString(Object, Object) */;
                lock.unlock();
                hasLock = false;
                return JSIdenticalNode.doStringNotString(leftNodeValue, rightNodeValue);
            }
            if (((exclude & 0b1000)) == 0 /* is-not-excluded doNumberCached(Object, Object, Class<>, Class<>) */) {
                int count22_ = 0;
                NumberCachedData s22_ = this.numberCached_cache;
                if ((state & 0x200000L) != 0 /* is-active doNumberCached(Object, Object, Class<>, Class<>) */) {
                    while (s22_ != null) {
                        assert (s22_.cachedClassA_ != null);
                        assert (s22_.cachedClassB_ != null);
                        if ((leftNodeValue.getClass() == s22_.cachedClassA_) && (rightNodeValue.getClass() == s22_.cachedClassB_)) {
                            break;
                        }
                        s22_ = s22_.next_;
                        count22_++;
                    }
                }
                if (s22_ == null) {
                    {
                        Class<?> cachedClassA__ = (JSGuards.getJavaNumberClass(leftNodeValue));
                        if ((cachedClassA__ != null)) {
                            Class<?> cachedClassB__ = (JSGuards.getJavaNumberClass(rightNodeValue));
                            if ((cachedClassB__ != null) && (leftNodeValue.getClass() == cachedClassA__) && (rightNodeValue.getClass() == cachedClassB__) && count22_ < (JSIdenticalNode.MAX_CLASSES)) {
                                s22_ = new NumberCachedData(numberCached_cache);
                                s22_.cachedClassA_ = cachedClassA__;
                                s22_.cachedClassB_ = cachedClassB__;
                                this.numberCached_cache = s22_;
                                this.state_ = state = state | 0x200000L /* add-active doNumberCached(Object, Object, Class<>, Class<>) */;
                            }
                        }
                    }
                }
                if (s22_ != null) {
                    lock.unlock();
                    hasLock = false;
                    return doNumberCached(leftNodeValue, rightNodeValue, s22_.cachedClassA_, s22_.cachedClassB_);
                }
            }
            if (leftNodeValue instanceof Number) {
                Number leftNodeValue_ = (Number) leftNodeValue;
                if (rightNodeValue instanceof Number) {
                    Number rightNodeValue_ = (Number) rightNodeValue;
                    if ((JSRuntime.isJavaNumber(leftNodeValue_)) && (JSRuntime.isJavaNumber(rightNodeValue_))) {
                        this.exclude_ = exclude = exclude | 0b1000 /* add-excluded doNumberCached(Object, Object, Class<>, Class<>) */;
                        this.numberCached_cache = null;
                        state = state & 0xffffffffffdfffffL /* remove-active doNumberCached(Object, Object, Class<>, Class<>) */;
                        this.state_ = state = state | 0x400000L /* add-active doNumber(Number, Number) */;
                        lock.unlock();
                        hasLock = false;
                        return doNumber(leftNodeValue_, rightNodeValue_);
                    }
                }
            }
            if (leftNodeValue instanceof TruffleObject) {
                TruffleObject leftNodeValue_ = (TruffleObject) leftNodeValue;
                if (rightNodeValue instanceof TruffleObject) {
                    TruffleObject rightNodeValue_ = (TruffleObject) rightNodeValue;
                    if ((JSGuards.isTruffleJavaObject(leftNodeValue_)) && (JSGuards.isTruffleJavaObject(rightNodeValue_))) {
                        this.state_ = state = state | 0x800000L /* add-active doTruffleJavaObjects(TruffleObject, TruffleObject) */;
                        lock.unlock();
                        hasLock = false;
                        return JSIdenticalNode.doTruffleJavaObjects(leftNodeValue_, rightNodeValue_);
                    }
                }
            }
            this.state_ = state = state | 0x1000000L /* add-active doFallback(Object, Object) */;
            lock.unlock();
            hasLock = false;
            return JSIdenticalNode.doFallback(leftNodeValue, rightNodeValue);
        } finally {
            if (oldState != 0 || oldExclude != 0) {
                checkForPolymorphicSpecialize(oldState, oldExclude, oldCacheCount);
            }
            if (hasLock) {
                lock.unlock();
            }
        }
    }

    private void checkForPolymorphicSpecialize(long oldState, int oldExclude, int oldCacheCount) {
        long newState = (this.state_ & 0x1ffffffL);
        int newExclude = this.exclude_;
        if ((oldState ^ newState) != 0 || (oldExclude ^ newExclude) != 0 || oldCacheCount < countCaches()) {
            this.reportPolymorphicSpecialize();
        }
    }

    private int countCaches() {
        int cacheCount = 0;
        DifferentTypesCachedData s19_ = this.differentTypesCached_cache;
        while (s19_ != null) {
            cacheCount++;
            s19_= s19_.next_;
        }
        NumberCachedData s22_ = this.numberCached_cache;
        while (s22_ != null) {
            cacheCount++;
            s22_= s22_.next_;
        }
        return cacheCount;
    }

    @Override
    public NodeCost getCost() {
        long state = state_;
        if ((state & 0x1ffffffL) == 0b0) {
            return NodeCost.UNINITIALIZED;
        } else if (((state & 0x1ffffffL) & ((state & 0x1ffffffL) - 1)) == 0 /* is-single-active  */) {
            DifferentTypesCachedData s19_ = this.differentTypesCached_cache;
            NumberCachedData s22_ = this.numberCached_cache;
            if ((s19_ == null || s19_.next_ == null) && (s22_ == null || s22_.next_ == null)) {
                return NodeCost.MONOMORPHIC;
            }
        }
        return NodeCost.POLYMORPHIC;
    }

    @Override
    public Introspection getIntrospectionData() {
        Object[] data = new Object[26];
        Object[] s;
        data[0] = 0;
        long state = state_;
        int exclude = exclude_;
        s = new Object[3];
        s[0] = "doInt";
        if ((state & 0b1) != 0 /* is-active doInt(int, int) */) {
            s[1] = (byte)0b01 /* active */;
        } else {
            s[1] = (byte)0b00 /* inactive */;
        }
        data[1] = s;
        s = new Object[3];
        s[0] = "doDouble";
        if ((state & 0b10) != 0 /* is-active doDouble(double, double) */) {
            s[1] = (byte)0b01 /* active */;
        } else {
            s[1] = (byte)0b00 /* inactive */;
        }
        data[2] = s;
        s = new Object[3];
        s[0] = "doBoolean";
        if ((state & 0b100) != 0 /* is-active doBoolean(boolean, boolean) */) {
            s[1] = (byte)0b01 /* active */;
        } else {
            s[1] = (byte)0b00 /* inactive */;
        }
        data[3] = s;
        s = new Object[3];
        s[0] = "doBigInt";
        if ((state & 0b1000) != 0 /* is-active doBigInt(BigInt, BigInt) */) {
            s[1] = (byte)0b01 /* active */;
        } else {
            s[1] = (byte)0b00 /* inactive */;
        }
        data[4] = s;
        s = new Object[3];
        s[0] = "doBigIntDouble";
        if ((state & 0b10000) != 0 /* is-active doBigIntDouble(BigInt, double) */) {
            s[1] = (byte)0b01 /* active */;
        } else {
            s[1] = (byte)0b00 /* inactive */;
        }
        data[5] = s;
        s = new Object[3];
        s[0] = "doDoubleBigInt";
        if ((state & 0b100000) != 0 /* is-active doDoubleBigInt(double, BigInt) */) {
            s[1] = (byte)0b01 /* active */;
        } else {
            s[1] = (byte)0b00 /* inactive */;
        }
        data[6] = s;
        s = new Object[3];
        s[0] = "doObject";
        if ((state & 0b1000000) != 0 /* is-active doObject(DynamicObject, DynamicObject) */) {
            s[1] = (byte)0b01 /* active */;
        } else {
            s[1] = (byte)0b00 /* inactive */;
        }
        data[7] = s;
        s = new Object[3];
        s[0] = "doLazyStringReference";
        if ((state & 0b10000000) != 0 /* is-active doLazyStringReference(JSLazyString, JSLazyString) */) {
            s[1] = (byte)0b01 /* active */;
        } else if ((exclude & 0b1) != 0 /* is-excluded doLazyStringReference(JSLazyString, JSLazyString) */) {
            s[1] = (byte)0b10 /* excluded */;
        } else {
            s[1] = (byte)0b00 /* inactive */;
        }
        data[8] = s;
        s = new Object[3];
        s[0] = "doLazyString";
        if ((state & 0b100000000) != 0 /* is-active doLazyString(JSLazyString, JSLazyString, ConditionProfile, ConditionProfile, ConditionProfile) */) {
            s[1] = (byte)0b01 /* active */;
            ArrayList<Object> cached = new ArrayList<>();
            LazyStringData s9_ = this.lazyString_cache;
            if (s9_ != null) {
                cached.add(Arrays.asList(s9_.flattenA_, s9_.flattenB_, s9_.len_));
            }
            s[2] = cached;
        } else {
            s[1] = (byte)0b00 /* inactive */;
        }
        data[9] = s;
        s = new Object[3];
        s[0] = "doLazyStringLeft";
        if ((state & 0b1000000000) != 0 /* is-active doLazyStringLeft(String, JSLazyString, ConditionProfile, ConditionProfile) */) {
            s[1] = (byte)0b01 /* active */;
            ArrayList<Object> cached = new ArrayList<>();
            cached.add(Arrays.asList(this.lazyStringLeft_flatten_, this.lazyStringLeft_len_));
            s[2] = cached;
        } else {
            s[1] = (byte)0b00 /* inactive */;
        }
        data[10] = s;
        s = new Object[3];
        s[0] = "doLazyStringRight";
        if ((state & 0b10000000000) != 0 /* is-active doLazyStringRight(JSLazyString, String, ConditionProfile, ConditionProfile) */) {
            s[1] = (byte)0b01 /* active */;
            ArrayList<Object> cached = new ArrayList<>();
            cached.add(Arrays.asList(this.lazyStringRight_flatten_, this.lazyStringRight_len_));
            s[2] = cached;
        } else {
            s[1] = (byte)0b00 /* inactive */;
        }
        data[11] = s;
        s = new Object[3];
        s[0] = "doStringIdentity";
        if ((state & 0b100000000000) != 0 /* is-active doStringIdentity(String, String) */) {
            s[1] = (byte)0b01 /* active */;
        } else if ((exclude & 0b10) != 0 /* is-excluded doStringIdentity(String, String) */) {
            s[1] = (byte)0b10 /* excluded */;
        } else {
            s[1] = (byte)0b00 /* inactive */;
        }
        data[12] = s;
        s = new Object[3];
        s[0] = "doString";
        if ((state & 0b1000000000000) != 0 /* is-active doString(String, String) */) {
            s[1] = (byte)0b01 /* active */;
        } else {
            s[1] = (byte)0b00 /* inactive */;
        }
        data[13] = s;
        s = new Object[3];
        s[0] = "doSymbol";
        if ((state & 0b10000000000000) != 0 /* is-active doSymbol(Symbol, Symbol) */) {
            s[1] = (byte)0b01 /* active */;
        } else {
            s[1] = (byte)0b00 /* inactive */;
        }
        data[14] = s;
        s = new Object[3];
        s[0] = "doBooleanNotBoolean";
        if ((state & 0b100000000000000) != 0 /* is-active doBooleanNotBoolean(Object, Object) */) {
            s[1] = (byte)0b01 /* active */;
        } else {
            s[1] = (byte)0b00 /* inactive */;
        }
        data[15] = s;
        s = new Object[3];
        s[0] = "doSymbolNotSymbol";
        if ((state & 0b1000000000000000) != 0 /* is-active doSymbolNotSymbol(Object, Object) */) {
            s[1] = (byte)0b01 /* active */;
        } else {
            s[1] = (byte)0b00 /* inactive */;
        }
        data[16] = s;
        s = new Object[3];
        s[0] = "doNullNotNull";
        if ((state & 0x10000L) != 0 /* is-active doNullNotNull(Object, Object) */) {
            s[1] = (byte)0b01 /* active */;
        } else {
            s[1] = (byte)0b00 /* inactive */;
        }
        data[17] = s;
        s = new Object[3];
        s[0] = "doUndefinedNotUndefined";
        if ((state & 0x20000L) != 0 /* is-active doUndefinedNotUndefined(Object, Object) */) {
            s[1] = (byte)0b01 /* active */;
        } else {
            s[1] = (byte)0b00 /* inactive */;
        }
        data[18] = s;
        s = new Object[3];
        s[0] = "doDifferentTypesCached";
        if ((state & 0x40000L) != 0 /* is-active doDifferentTypesCached(Object, Object, Class<>, Class<>) */) {
            s[1] = (byte)0b01 /* active */;
            ArrayList<Object> cached = new ArrayList<>();
            DifferentTypesCachedData s19_ = this.differentTypesCached_cache;
            while (s19_ != null) {
                cached.add(Arrays.asList(s19_.cachedClassA_, s19_.cachedClassB_));
                s19_ = s19_.next_;
            }
            s[2] = cached;
        } else if ((exclude & 0b100) != 0 /* is-excluded doDifferentTypesCached(Object, Object, Class<>, Class<>) */) {
            s[1] = (byte)0b10 /* excluded */;
        } else {
            s[1] = (byte)0b00 /* inactive */;
        }
        data[19] = s;
        s = new Object[3];
        s[0] = "doNumberNotNumber";
        if ((state & 0x80000L) != 0 /* is-active doNumberNotNumber(Object, Object) */) {
            s[1] = (byte)0b01 /* active */;
        } else {
            s[1] = (byte)0b00 /* inactive */;
        }
        data[20] = s;
        s = new Object[3];
        s[0] = "doStringNotString";
        if ((state & 0x100000L) != 0 /* is-active doStringNotString(Object, Object) */) {
            s[1] = (byte)0b01 /* active */;
        } else {
            s[1] = (byte)0b00 /* inactive */;
        }
        data[21] = s;
        s = new Object[3];
        s[0] = "doNumberCached";
        if ((state & 0x200000L) != 0 /* is-active doNumberCached(Object, Object, Class<>, Class<>) */) {
            s[1] = (byte)0b01 /* active */;
            ArrayList<Object> cached = new ArrayList<>();
            NumberCachedData s22_ = this.numberCached_cache;
            while (s22_ != null) {
                cached.add(Arrays.asList(s22_.cachedClassA_, s22_.cachedClassB_));
                s22_ = s22_.next_;
            }
            s[2] = cached;
        } else if ((exclude & 0b1000) != 0 /* is-excluded doNumberCached(Object, Object, Class<>, Class<>) */) {
            s[1] = (byte)0b10 /* excluded */;
        } else {
            s[1] = (byte)0b00 /* inactive */;
        }
        data[22] = s;
        s = new Object[3];
        s[0] = "doNumber";
        if ((state & 0x400000L) != 0 /* is-active doNumber(Number, Number) */) {
            s[1] = (byte)0b01 /* active */;
        } else {
            s[1] = (byte)0b00 /* inactive */;
        }
        data[23] = s;
        s = new Object[3];
        s[0] = "doTruffleJavaObjects";
        if ((state & 0x800000L) != 0 /* is-active doTruffleJavaObjects(TruffleObject, TruffleObject) */) {
            s[1] = (byte)0b01 /* active */;
        } else {
            s[1] = (byte)0b00 /* inactive */;
        }
        data[24] = s;
        s = new Object[3];
        s[0] = "doFallback";
        if ((state & 0x1000000L) != 0 /* is-active doFallback(Object, Object) */) {
            s[1] = (byte)0b01 /* active */;
        } else {
            s[1] = (byte)0b00 /* inactive */;
        }
        data[25] = s;
        return Provider.create(data);
    }

    private static boolean fallbackGuard_(long state, Object leftNodeValue, Object rightNodeValue) {
        if (JSTypesGen.isImplicitDouble(leftNodeValue) && JSTypesGen.isImplicitDouble(rightNodeValue)) {
            return false;
        }
        if (((state & 0b100)) == 0 /* is-not-active doBoolean(boolean, boolean) */ && leftNodeValue instanceof Boolean && rightNodeValue instanceof Boolean) {
            return false;
        }
        if (leftNodeValue instanceof BigInt) {
            if (((state & 0b1000)) == 0 /* is-not-active doBigInt(BigInt, BigInt) */ && rightNodeValue instanceof BigInt) {
                return false;
            }
            if (JSTypesGen.isImplicitDouble(rightNodeValue)) {
                return false;
            }
        }
        if (JSTypesGen.isImplicitDouble(leftNodeValue) && rightNodeValue instanceof BigInt) {
            return false;
        }
        if (((state & 0b1000000)) == 0 /* is-not-active doObject(DynamicObject, DynamicObject) */ && JSTypes.isDynamicObject(leftNodeValue) && JSTypes.isDynamicObject(rightNodeValue)) {
            return false;
        }
        if (JSTypesGen.isImplicitString(leftNodeValue) && JSTypesGen.isImplicitString(rightNodeValue)) {
            return false;
        }
        if (((state & 0b10000000000000)) == 0 /* is-not-active doSymbol(Symbol, Symbol) */ && leftNodeValue instanceof Symbol && rightNodeValue instanceof Symbol) {
            return false;
        }
        if (((state & 0b100000000000000)) == 0 /* is-not-active doBooleanNotBoolean(Object, Object) */ && (JSGuards.isBoolean(leftNodeValue) != JSGuards.isBoolean(rightNodeValue))) {
            return false;
        }
        if (((state & 0b1000000000000000)) == 0 /* is-not-active doSymbolNotSymbol(Object, Object) */ && (JSGuards.isSymbol(leftNodeValue) != JSGuards.isSymbol(rightNodeValue))) {
            return false;
        }
        if (((state & 0x10000L)) == 0 /* is-not-active doNullNotNull(Object, Object) */ && (JSGuards.isJSNull(leftNodeValue) != JSGuards.isJSNull(rightNodeValue))) {
            return false;
        }
        if (((state & 0x20000L)) == 0 /* is-not-active doUndefinedNotUndefined(Object, Object) */ && (JSGuards.isUndefined(leftNodeValue) != JSGuards.isUndefined(rightNodeValue))) {
            return false;
        }
        if (((state & 0x80000L)) == 0 /* is-not-active doNumberNotNumber(Object, Object) */ && (JSRuntime.isJavaNumber(leftNodeValue) != JSRuntime.isJavaNumber(rightNodeValue))) {
            return false;
        }
        if (((state & 0x100000L)) == 0 /* is-not-active doStringNotString(Object, Object) */ && (JSRuntime.isString(leftNodeValue) != JSRuntime.isString(rightNodeValue))) {
            return false;
        }
        if (leftNodeValue instanceof Number && rightNodeValue instanceof Number) {
            Number leftNodeValue_ = (Number) leftNodeValue;
            if ((JSRuntime.isJavaNumber(leftNodeValue_))) {
                Number rightNodeValue_ = (Number) rightNodeValue;
                if ((JSRuntime.isJavaNumber(rightNodeValue_))) {
                    return false;
                }
            }
        }
        if (leftNodeValue instanceof TruffleObject && rightNodeValue instanceof TruffleObject) {
            TruffleObject leftNodeValue_ = (TruffleObject) leftNodeValue;
            if ((JSGuards.isTruffleJavaObject(leftNodeValue_))) {
                TruffleObject rightNodeValue_ = (TruffleObject) rightNodeValue;
                if ((JSGuards.isTruffleJavaObject(rightNodeValue_))) {
                    return false;
                }
            }
        }
        return true;
    }

    public static JSIdenticalNode create(JavaScriptNode left, JavaScriptNode right, int type) {
        return new JSIdenticalNodeGen(left, right, type);
    }

    @GeneratedBy(JSIdenticalNode.class)
    private static final class LazyStringData {

        @CompilationFinal ConditionProfile flattenA_;
        @CompilationFinal ConditionProfile flattenB_;
        @CompilationFinal ConditionProfile len_;

        LazyStringData() {
        }

    }
    @GeneratedBy(JSIdenticalNode.class)
    private static final class DifferentTypesCachedData {

        @CompilationFinal DifferentTypesCachedData next_;
        @CompilationFinal Class<?> cachedClassA_;
        @CompilationFinal Class<?> cachedClassB_;

        DifferentTypesCachedData(DifferentTypesCachedData next_) {
            this.next_ = next_;
        }

    }
    @GeneratedBy(JSIdenticalNode.class)
    private static final class NumberCachedData {

        @CompilationFinal NumberCachedData next_;
        @CompilationFinal Class<?> cachedClassA_;
        @CompilationFinal Class<?> cachedClassB_;

        NumberCachedData(NumberCachedData next_) {
            this.next_ = next_;
        }

    }
}
