// CheckStyle: start generated
package com.oracle.truffle.js.nodes.binary;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.CompilerDirectives.CompilationFinal;
import com.oracle.truffle.api.dsl.GeneratedBy;
import com.oracle.truffle.api.dsl.Introspection;
import com.oracle.truffle.api.dsl.Introspection.Provider;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.nodes.NodeCost;
import com.oracle.truffle.api.nodes.UnexpectedResultException;
import com.oracle.truffle.api.profiles.BranchProfile;
import com.oracle.truffle.api.profiles.ConditionProfile;
import com.oracle.truffle.js.nodes.JSGuards;
import com.oracle.truffle.js.nodes.JSTypes;
import com.oracle.truffle.js.nodes.JSTypesGen;
import com.oracle.truffle.js.nodes.JavaScriptNode;
import com.oracle.truffle.js.nodes.binary.JSAddNode;
import com.oracle.truffle.js.nodes.binary.JSConcatStringsNode;
import com.oracle.truffle.js.nodes.cast.JSDoubleToStringNode;
import com.oracle.truffle.js.nodes.cast.JSToNumericNode;
import com.oracle.truffle.js.nodes.cast.JSToPrimitiveNode;
import com.oracle.truffle.js.nodes.cast.JSToStringNode;
import com.oracle.truffle.js.runtime.BigInt;
import com.oracle.truffle.js.runtime.LargeInteger;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.concurrent.locks.Lock;

@GeneratedBy(JSAddNode.class)
public final class JSAddNodeGen extends JSAddNode implements Provider {

    @CompilationFinal private long state_;
    @CompilationFinal private int exclude_;
    @Child private JSConcatStringsNode concatStringsNode;
    @Child private JSDoubleToStringNode doubleToStringNode;
    @Child private PrimitiveConversionData primitiveConversion_cache;

    private JSAddNodeGen(boolean truncate, JavaScriptNode left, JavaScriptNode right) {
        super(truncate, left, right);
    }

    @Override
    public Object execute(Object leftNodeValue, Object rightNodeValue) {
        long state = state_;
        if ((state & 0b1111) != 0 /* is-active doIntTruncate(int, int) || doInt(int, int) || doIntOverflow(int, int) || doIntLargeIntegerTruncate(int, LargeInteger) */ && leftNodeValue instanceof Integer) {
            int leftNodeValue_ = (int) leftNodeValue;
            if ((state & 0b111) != 0 /* is-active doIntTruncate(int, int) || doInt(int, int) || doIntOverflow(int, int) */ && rightNodeValue instanceof Integer) {
                int rightNodeValue_ = (int) rightNodeValue;
                if ((state & 0b1) != 0 /* is-active doIntTruncate(int, int) */) {
                    assert (truncate);
                    return JSAddNode.doIntTruncate(leftNodeValue_, rightNodeValue_);
                }
                if ((state & 0b10) != 0 /* is-active doInt(int, int) */) {
                    assert (!(truncate));
                    try {
                        return JSAddNode.doInt(leftNodeValue_, rightNodeValue_);
                    } catch (ArithmeticException ex) {
                        // implicit transferToInterpreterAndInvalidate()
                        Lock lock = getLock();
                        lock.lock();
                        try {
                            this.exclude_ = this.exclude_ | 0b10 /* add-excluded doInt(int, int) */;
                            this.state_ = this.state_ & 0xfffffffffffffffdL /* remove-active doInt(int, int) */;
                        } finally {
                            lock.unlock();
                        }
                        return executeAndSpecialize(leftNodeValue_, rightNodeValue_);
                    }
                }
                if ((state & 0b100) != 0 /* is-active doIntOverflow(int, int) */) {
                    assert (!(truncate));
                    try {
                        return JSAddNode.doIntOverflow(leftNodeValue_, rightNodeValue_);
                    } catch (ArithmeticException ex) {
                        // implicit transferToInterpreterAndInvalidate()
                        Lock lock = getLock();
                        lock.lock();
                        try {
                            this.exclude_ = this.exclude_ | 0b100 /* add-excluded doIntOverflow(int, int) */;
                            this.state_ = this.state_ & 0xfffffffffffffffbL /* remove-active doIntOverflow(int, int) */;
                        } finally {
                            lock.unlock();
                        }
                        return executeAndSpecialize(leftNodeValue_, rightNodeValue_);
                    }
                }
            }
            if ((state & 0b1000) != 0 /* is-active doIntLargeIntegerTruncate(int, LargeInteger) */ && rightNodeValue instanceof LargeInteger) {
                LargeInteger rightNodeValue_ = (LargeInteger) rightNodeValue;
                assert (truncate);
                return JSAddNode.doIntLargeIntegerTruncate(leftNodeValue_, rightNodeValue_);
            }
        }
        if ((state & 0b110000) != 0 /* is-active doLargeIntegerIntTruncate(LargeInteger, int) || doLargeIntegerTruncate(LargeInteger, LargeInteger) */ && leftNodeValue instanceof LargeInteger) {
            LargeInteger leftNodeValue_ = (LargeInteger) leftNodeValue;
            if ((state & 0b10000) != 0 /* is-active doLargeIntegerIntTruncate(LargeInteger, int) */ && rightNodeValue instanceof Integer) {
                int rightNodeValue_ = (int) rightNodeValue;
                assert (truncate);
                return JSAddNode.doLargeIntegerIntTruncate(leftNodeValue_, rightNodeValue_);
            }
            if ((state & 0b100000) != 0 /* is-active doLargeIntegerTruncate(LargeInteger, LargeInteger) */ && rightNodeValue instanceof LargeInteger) {
                LargeInteger rightNodeValue_ = (LargeInteger) rightNodeValue;
                assert (truncate);
                return JSAddNode.doLargeIntegerTruncate(leftNodeValue_, rightNodeValue_);
            }
        }
        if ((state & 0b1000000) != 0 /* is-active doIntLargeInteger(int, LargeInteger) */ && leftNodeValue instanceof Integer) {
            int leftNodeValue_ = (int) leftNodeValue;
            if (rightNodeValue instanceof LargeInteger) {
                LargeInteger rightNodeValue_ = (LargeInteger) rightNodeValue;
                assert (!(truncate));
                try {
                    return JSAddNode.doIntLargeInteger(leftNodeValue_, rightNodeValue_);
                } catch (ArithmeticException ex) {
                    // implicit transferToInterpreterAndInvalidate()
                    Lock lock = getLock();
                    lock.lock();
                    try {
                        this.exclude_ = this.exclude_ | 0b1000000 /* add-excluded doIntLargeInteger(int, LargeInteger) */;
                        this.state_ = this.state_ & 0xffffffffffffffbfL /* remove-active doIntLargeInteger(int, LargeInteger) */;
                    } finally {
                        lock.unlock();
                    }
                    return executeAndSpecialize(leftNodeValue_, rightNodeValue_);
                }
            }
        }
        if ((state & 0b110000000) != 0 /* is-active doLargeIntegerInt(LargeInteger, int) || doLargeInteger(LargeInteger, LargeInteger) */ && leftNodeValue instanceof LargeInteger) {
            LargeInteger leftNodeValue_ = (LargeInteger) leftNodeValue;
            if ((state & 0b10000000) != 0 /* is-active doLargeIntegerInt(LargeInteger, int) */ && rightNodeValue instanceof Integer) {
                int rightNodeValue_ = (int) rightNodeValue;
                assert (!(truncate));
                try {
                    return JSAddNode.doLargeIntegerInt(leftNodeValue_, rightNodeValue_);
                } catch (ArithmeticException ex) {
                    // implicit transferToInterpreterAndInvalidate()
                    Lock lock = getLock();
                    lock.lock();
                    try {
                        this.exclude_ = this.exclude_ | 0b10000000 /* add-excluded doLargeIntegerInt(LargeInteger, int) */;
                        this.state_ = this.state_ & 0xffffffffffffff7fL /* remove-active doLargeIntegerInt(LargeInteger, int) */;
                    } finally {
                        lock.unlock();
                    }
                    return executeAndSpecialize(leftNodeValue_, rightNodeValue_);
                }
            }
            if ((state & 0b100000000) != 0 /* is-active doLargeInteger(LargeInteger, LargeInteger) */ && rightNodeValue instanceof LargeInteger) {
                LargeInteger rightNodeValue_ = (LargeInteger) rightNodeValue;
                assert (!(truncate));
                try {
                    return JSAddNode.doLargeInteger(leftNodeValue_, rightNodeValue_);
                } catch (ArithmeticException ex) {
                    // implicit transferToInterpreterAndInvalidate()
                    Lock lock = getLock();
                    lock.lock();
                    try {
                        this.exclude_ = this.exclude_ | 0b100000000 /* add-excluded doLargeInteger(LargeInteger, LargeInteger) */;
                        this.state_ = this.state_ & 0xfffffffffffffeffL /* remove-active doLargeInteger(LargeInteger, LargeInteger) */;
                    } finally {
                        lock.unlock();
                    }
                    return executeAndSpecialize(leftNodeValue_, rightNodeValue_);
                }
            }
        }
        if ((state & 0b1000000000) != 0 /* is-active doDouble(double, double) */ && JSTypesGen.isImplicitDouble((int)((state & 0x1e0000L) >>> 17) /* extract-implicit-active 0:double */, leftNodeValue)) {
            double leftNodeValue_ = JSTypesGen.asImplicitDouble((int)((state & 0x1e0000L) >>> 17) /* extract-implicit-active 0:double */, leftNodeValue);
            if (JSTypesGen.isImplicitDouble((int)((state & 0x1e00000L) >>> 21) /* extract-implicit-active 1:double */, rightNodeValue)) {
                double rightNodeValue_ = JSTypesGen.asImplicitDouble((int)((state & 0x1e00000L) >>> 21) /* extract-implicit-active 1:double */, rightNodeValue);
                return JSAddNode.doDouble(leftNodeValue_, rightNodeValue_);
            }
        }
        if ((state & 0b10000000000) != 0 /* is-active doBigInt(BigInt, BigInt) */ && leftNodeValue instanceof BigInt) {
            BigInt leftNodeValue_ = (BigInt) leftNodeValue;
            if (rightNodeValue instanceof BigInt) {
                BigInt rightNodeValue_ = (BigInt) rightNodeValue;
                return doBigInt(leftNodeValue_, rightNodeValue_);
            }
        }
        if ((state & 0b1100000000000) != 0 /* is-active doString(CharSequence, CharSequence, JSConcatStringsNode) || doStringInt(CharSequence, int) */ && JSTypesGen.isImplicitCharSequence((int)((state & 0x1e000000L) >>> 25) /* extract-implicit-active 0:CharSequence */, leftNodeValue)) {
            CharSequence leftNodeValue_ = JSTypesGen.asImplicitCharSequence((int)((state & 0x1e000000L) >>> 25) /* extract-implicit-active 0:CharSequence */, leftNodeValue);
            if ((state & 0b100000000000) != 0 /* is-active doString(CharSequence, CharSequence, JSConcatStringsNode) */ && JSTypesGen.isImplicitCharSequence((int)((state & 0x1e0000000L) >>> 29) /* extract-implicit-active 1:CharSequence */, rightNodeValue)) {
                CharSequence rightNodeValue_ = JSTypesGen.asImplicitCharSequence((int)((state & 0x1e0000000L) >>> 29) /* extract-implicit-active 1:CharSequence */, rightNodeValue);
                return doString(leftNodeValue_, rightNodeValue_, this.concatStringsNode);
            }
            if ((state & 0b1000000000000) != 0 /* is-active doStringInt(CharSequence, int) */ && rightNodeValue instanceof Integer) {
                int rightNodeValue_ = (int) rightNodeValue;
                return doStringInt(leftNodeValue_, rightNodeValue_);
            }
        }
        if ((state & 0b10000000000000) != 0 /* is-active doIntString(int, CharSequence) */ && leftNodeValue instanceof Integer) {
            int leftNodeValue_ = (int) leftNodeValue;
            if (JSTypesGen.isImplicitCharSequence((int)((state & 0x1e0000000L) >>> 29) /* extract-implicit-active 1:CharSequence */, rightNodeValue)) {
                CharSequence rightNodeValue_ = JSTypesGen.asImplicitCharSequence((int)((state & 0x1e0000000L) >>> 29) /* extract-implicit-active 1:CharSequence */, rightNodeValue);
                return doIntString(leftNodeValue_, rightNodeValue_);
            }
        }
        if ((state & 0b100000000000000) != 0 /* is-active doStringNumber(CharSequence, Object, JSConcatStringsNode, JSDoubleToStringNode) */ && JSTypesGen.isImplicitCharSequence((int)((state & 0x1e000000L) >>> 25) /* extract-implicit-active 0:CharSequence */, leftNodeValue)) {
            CharSequence leftNodeValue_ = JSTypesGen.asImplicitCharSequence((int)((state & 0x1e000000L) >>> 25) /* extract-implicit-active 0:CharSequence */, leftNodeValue);
            if ((JSGuards.isNumber(rightNodeValue))) {
                return doStringNumber(leftNodeValue_, rightNodeValue, this.concatStringsNode, this.doubleToStringNode);
            }
        }
        if ((state & 0x18000L) != 0 /* is-active doNumberString(Object, CharSequence, JSConcatStringsNode, JSDoubleToStringNode) || doPrimitiveConversion(Object, Object, JSToPrimitiveNode, JSToPrimitiveNode, JSToNumericNode, JSToNumericNode, JSToStringNode, JSToStringNode, ConditionProfile, ConditionProfile, JSAddNode, BranchProfile) */) {
            if ((state & 0b1000000000000000) != 0 /* is-active doNumberString(Object, CharSequence, JSConcatStringsNode, JSDoubleToStringNode) */ && JSTypesGen.isImplicitCharSequence((int)((state & 0x1e0000000L) >>> 29) /* extract-implicit-active 1:CharSequence */, rightNodeValue)) {
                CharSequence rightNodeValue_ = JSTypesGen.asImplicitCharSequence((int)((state & 0x1e0000000L) >>> 29) /* extract-implicit-active 1:CharSequence */, rightNodeValue);
                if ((JSGuards.isNumber(leftNodeValue))) {
                    return doNumberString(leftNodeValue, rightNodeValue_, this.concatStringsNode, this.doubleToStringNode);
                }
            }
            if ((state & 0x10000L) != 0 /* is-active doPrimitiveConversion(Object, Object, JSToPrimitiveNode, JSToPrimitiveNode, JSToNumericNode, JSToNumericNode, JSToStringNode, JSToStringNode, ConditionProfile, ConditionProfile, JSAddNode, BranchProfile) */) {
                PrimitiveConversionData s17_ = this.primitiveConversion_cache;
                if (s17_ != null) {
                    return doPrimitiveConversion(leftNodeValue, rightNodeValue, s17_.toPrimitiveA_, s17_.toPrimitiveB_, s17_.toNumericA_, s17_.toNumericB_, s17_.toStringA_, s17_.toStringB_, s17_.profileA_, s17_.profileB_, s17_.add_, s17_.mixedNumericTypes_);
                }
            }
        }
        CompilerDirectives.transferToInterpreterAndInvalidate();
        return executeAndSpecialize(leftNodeValue, rightNodeValue);
    }

    @Override
    public Object execute(VirtualFrame frameValue) {
        long state = state_;
        if ((state & 0x1fff8L) == 0 /* only-active doIntTruncate(int, int) && doInt(int, int) && doIntOverflow(int, int) */ && (state & 0x1ffffL) != 0  /* is-not doIntTruncate(int, int) && doInt(int, int) && doIntOverflow(int, int) && doIntLargeIntegerTruncate(int, LargeInteger) && doLargeIntegerIntTruncate(LargeInteger, int) && doLargeIntegerTruncate(LargeInteger, LargeInteger) && doIntLargeInteger(int, LargeInteger) && doLargeIntegerInt(LargeInteger, int) && doLargeInteger(LargeInteger, LargeInteger) && doDouble(double, double) && doBigInt(BigInt, BigInt) && doString(CharSequence, CharSequence, JSConcatStringsNode) && doStringInt(CharSequence, int) && doIntString(int, CharSequence) && doStringNumber(CharSequence, Object, JSConcatStringsNode, JSDoubleToStringNode) && doNumberString(Object, CharSequence, JSConcatStringsNode, JSDoubleToStringNode) && doPrimitiveConversion(Object, Object, JSToPrimitiveNode, JSToPrimitiveNode, JSToNumericNode, JSToNumericNode, JSToStringNode, JSToStringNode, ConditionProfile, ConditionProfile, JSAddNode, BranchProfile) */) {
            return execute_int_int0(frameValue, state);
        } else if ((state & 0x1fdffL) == 0 /* only-active doDouble(double, double) */ && (state & 0x1ffffL) != 0  /* is-not doIntTruncate(int, int) && doInt(int, int) && doIntOverflow(int, int) && doIntLargeIntegerTruncate(int, LargeInteger) && doLargeIntegerIntTruncate(LargeInteger, int) && doLargeIntegerTruncate(LargeInteger, LargeInteger) && doIntLargeInteger(int, LargeInteger) && doLargeIntegerInt(LargeInteger, int) && doLargeInteger(LargeInteger, LargeInteger) && doDouble(double, double) && doBigInt(BigInt, BigInt) && doString(CharSequence, CharSequence, JSConcatStringsNode) && doStringInt(CharSequence, int) && doIntString(int, CharSequence) && doStringNumber(CharSequence, Object, JSConcatStringsNode, JSDoubleToStringNode) && doNumberString(Object, CharSequence, JSConcatStringsNode, JSDoubleToStringNode) && doPrimitiveConversion(Object, Object, JSToPrimitiveNode, JSToPrimitiveNode, JSToNumericNode, JSToNumericNode, JSToStringNode, JSToStringNode, ConditionProfile, ConditionProfile, JSAddNode, BranchProfile) */) {
            return execute_double_double1(frameValue, state);
        } else if ((state & 0x1dfb7L) == 0 /* only-active doIntLargeIntegerTruncate(int, LargeInteger) && doIntLargeInteger(int, LargeInteger) && doIntString(int, CharSequence) */ && (state & 0x1ffffL) != 0  /* is-not doIntTruncate(int, int) && doInt(int, int) && doIntOverflow(int, int) && doIntLargeIntegerTruncate(int, LargeInteger) && doLargeIntegerIntTruncate(LargeInteger, int) && doLargeIntegerTruncate(LargeInteger, LargeInteger) && doIntLargeInteger(int, LargeInteger) && doLargeIntegerInt(LargeInteger, int) && doLargeInteger(LargeInteger, LargeInteger) && doDouble(double, double) && doBigInt(BigInt, BigInt) && doString(CharSequence, CharSequence, JSConcatStringsNode) && doStringInt(CharSequence, int) && doIntString(int, CharSequence) && doStringNumber(CharSequence, Object, JSConcatStringsNode, JSDoubleToStringNode) && doNumberString(Object, CharSequence, JSConcatStringsNode, JSDoubleToStringNode) && doPrimitiveConversion(Object, Object, JSToPrimitiveNode, JSToPrimitiveNode, JSToNumericNode, JSToNumericNode, JSToStringNode, JSToStringNode, ConditionProfile, ConditionProfile, JSAddNode, BranchProfile) */) {
            return execute_int2(frameValue, state);
        } else if ((state & 0x1ef6fL) == 0 /* only-active doLargeIntegerIntTruncate(LargeInteger, int) && doLargeIntegerInt(LargeInteger, int) && doStringInt(CharSequence, int) */ && (state & 0x1ffffL) != 0  /* is-not doIntTruncate(int, int) && doInt(int, int) && doIntOverflow(int, int) && doIntLargeIntegerTruncate(int, LargeInteger) && doLargeIntegerIntTruncate(LargeInteger, int) && doLargeIntegerTruncate(LargeInteger, LargeInteger) && doIntLargeInteger(int, LargeInteger) && doLargeIntegerInt(LargeInteger, int) && doLargeInteger(LargeInteger, LargeInteger) && doDouble(double, double) && doBigInt(BigInt, BigInt) && doString(CharSequence, CharSequence, JSConcatStringsNode) && doStringInt(CharSequence, int) && doIntString(int, CharSequence) && doStringNumber(CharSequence, Object, JSConcatStringsNode, JSDoubleToStringNode) && doNumberString(Object, CharSequence, JSConcatStringsNode, JSDoubleToStringNode) && doPrimitiveConversion(Object, Object, JSToPrimitiveNode, JSToPrimitiveNode, JSToNumericNode, JSToNumericNode, JSToStringNode, JSToStringNode, ConditionProfile, ConditionProfile, JSAddNode, BranchProfile) */) {
            return execute_int3(frameValue, state);
        } else {
            return execute_generic4(frameValue, state);
        }
    }

    private Object execute_int_int0(VirtualFrame frameValue, long state) {
        int leftNodeValue_;
        try {
            leftNodeValue_ = super.leftNode.executeInt(frameValue);
        } catch (UnexpectedResultException ex) {
            Object rightNodeValue = super.rightNode.execute(frameValue);
            return executeAndSpecialize(ex.getResult(), rightNodeValue);
        }
        int rightNodeValue_;
        try {
            rightNodeValue_ = super.rightNode.executeInt(frameValue);
        } catch (UnexpectedResultException ex) {
            return executeAndSpecialize(leftNodeValue_, ex.getResult());
        }
        if ((state & 0b1) != 0 /* is-active doIntTruncate(int, int) */) {
            assert (truncate);
            return JSAddNode.doIntTruncate(leftNodeValue_, rightNodeValue_);
        }
        if ((state & 0b10) != 0 /* is-active doInt(int, int) */) {
            assert (!(truncate));
            try {
                return JSAddNode.doInt(leftNodeValue_, rightNodeValue_);
            } catch (ArithmeticException ex) {
                // implicit transferToInterpreterAndInvalidate()
                Lock lock = getLock();
                lock.lock();
                try {
                    this.exclude_ = this.exclude_ | 0b10 /* add-excluded doInt(int, int) */;
                    this.state_ = this.state_ & 0xfffffffffffffffdL /* remove-active doInt(int, int) */;
                } finally {
                    lock.unlock();
                }
                return executeAndSpecialize(leftNodeValue_, rightNodeValue_);
            }
        }
        if ((state & 0b100) != 0 /* is-active doIntOverflow(int, int) */) {
            assert (!(truncate));
            try {
                return JSAddNode.doIntOverflow(leftNodeValue_, rightNodeValue_);
            } catch (ArithmeticException ex) {
                // implicit transferToInterpreterAndInvalidate()
                Lock lock = getLock();
                lock.lock();
                try {
                    this.exclude_ = this.exclude_ | 0b100 /* add-excluded doIntOverflow(int, int) */;
                    this.state_ = this.state_ & 0xfffffffffffffffbL /* remove-active doIntOverflow(int, int) */;
                } finally {
                    lock.unlock();
                }
                return executeAndSpecialize(leftNodeValue_, rightNodeValue_);
            }
        }
        CompilerDirectives.transferToInterpreterAndInvalidate();
        return executeAndSpecialize(leftNodeValue_, rightNodeValue_);
    }

    private Object execute_double_double1(VirtualFrame frameValue, long state) {
        int leftNodeValue_int = 0;
        long leftNodeValue_long = 0L;
        double leftNodeValue_;
        try {
            if ((state & 0x1c0000L) == 0 /* only-active 0:double */ && (state & 0x1ffffL) != 0  /* is-not doIntTruncate(int, int) && doInt(int, int) && doIntOverflow(int, int) && doIntLargeIntegerTruncate(int, LargeInteger) && doLargeIntegerIntTruncate(LargeInteger, int) && doLargeIntegerTruncate(LargeInteger, LargeInteger) && doIntLargeInteger(int, LargeInteger) && doLargeIntegerInt(LargeInteger, int) && doLargeInteger(LargeInteger, LargeInteger) && doDouble(double, double) && doBigInt(BigInt, BigInt) && doString(CharSequence, CharSequence, JSConcatStringsNode) && doStringInt(CharSequence, int) && doIntString(int, CharSequence) && doStringNumber(CharSequence, Object, JSConcatStringsNode, JSDoubleToStringNode) && doNumberString(Object, CharSequence, JSConcatStringsNode, JSDoubleToStringNode) && doPrimitiveConversion(Object, Object, JSToPrimitiveNode, JSToPrimitiveNode, JSToNumericNode, JSToNumericNode, JSToStringNode, JSToStringNode, ConditionProfile, ConditionProfile, JSAddNode, BranchProfile) */) {
                leftNodeValue_long = super.leftNode.executeLong(frameValue);
                leftNodeValue_ = JSTypes.longToDouble(leftNodeValue_long);
            } else if ((state & 0x1a0000L) == 0 /* only-active 0:double */ && (state & 0x1ffffL) != 0  /* is-not doIntTruncate(int, int) && doInt(int, int) && doIntOverflow(int, int) && doIntLargeIntegerTruncate(int, LargeInteger) && doLargeIntegerIntTruncate(LargeInteger, int) && doLargeIntegerTruncate(LargeInteger, LargeInteger) && doIntLargeInteger(int, LargeInteger) && doLargeIntegerInt(LargeInteger, int) && doLargeInteger(LargeInteger, LargeInteger) && doDouble(double, double) && doBigInt(BigInt, BigInt) && doString(CharSequence, CharSequence, JSConcatStringsNode) && doStringInt(CharSequence, int) && doIntString(int, CharSequence) && doStringNumber(CharSequence, Object, JSConcatStringsNode, JSDoubleToStringNode) && doNumberString(Object, CharSequence, JSConcatStringsNode, JSDoubleToStringNode) && doPrimitiveConversion(Object, Object, JSToPrimitiveNode, JSToPrimitiveNode, JSToNumericNode, JSToNumericNode, JSToStringNode, JSToStringNode, ConditionProfile, ConditionProfile, JSAddNode, BranchProfile) */) {
                leftNodeValue_int = super.leftNode.executeInt(frameValue);
                leftNodeValue_ = JSTypes.intToDouble(leftNodeValue_int);
            } else if ((state & 0x160000L) == 0 /* only-active 0:double */ && (state & 0x1ffffL) != 0  /* is-not doIntTruncate(int, int) && doInt(int, int) && doIntOverflow(int, int) && doIntLargeIntegerTruncate(int, LargeInteger) && doLargeIntegerIntTruncate(LargeInteger, int) && doLargeIntegerTruncate(LargeInteger, LargeInteger) && doIntLargeInteger(int, LargeInteger) && doLargeIntegerInt(LargeInteger, int) && doLargeInteger(LargeInteger, LargeInteger) && doDouble(double, double) && doBigInt(BigInt, BigInt) && doString(CharSequence, CharSequence, JSConcatStringsNode) && doStringInt(CharSequence, int) && doIntString(int, CharSequence) && doStringNumber(CharSequence, Object, JSConcatStringsNode, JSDoubleToStringNode) && doNumberString(Object, CharSequence, JSConcatStringsNode, JSDoubleToStringNode) && doPrimitiveConversion(Object, Object, JSToPrimitiveNode, JSToPrimitiveNode, JSToNumericNode, JSToNumericNode, JSToStringNode, JSToStringNode, ConditionProfile, ConditionProfile, JSAddNode, BranchProfile) */) {
                leftNodeValue_ = super.leftNode.executeDouble(frameValue);
            } else {
                Object leftNodeValue__ = super.leftNode.execute(frameValue);
                leftNodeValue_ = JSTypesGen.expectImplicitDouble((int)((state & 0x1e0000L) >>> 17) /* extract-implicit-active 0:double */, leftNodeValue__);
            }
        } catch (UnexpectedResultException ex) {
            Object rightNodeValue = super.rightNode.execute(frameValue);
            return executeAndSpecialize(ex.getResult(), rightNodeValue);
        }
        int rightNodeValue_int = 0;
        long rightNodeValue_long = 0L;
        double rightNodeValue_;
        try {
            if ((state & 0x1c00000L) == 0 /* only-active 1:double */ && (state & 0x1ffffL) != 0  /* is-not doIntTruncate(int, int) && doInt(int, int) && doIntOverflow(int, int) && doIntLargeIntegerTruncate(int, LargeInteger) && doLargeIntegerIntTruncate(LargeInteger, int) && doLargeIntegerTruncate(LargeInteger, LargeInteger) && doIntLargeInteger(int, LargeInteger) && doLargeIntegerInt(LargeInteger, int) && doLargeInteger(LargeInteger, LargeInteger) && doDouble(double, double) && doBigInt(BigInt, BigInt) && doString(CharSequence, CharSequence, JSConcatStringsNode) && doStringInt(CharSequence, int) && doIntString(int, CharSequence) && doStringNumber(CharSequence, Object, JSConcatStringsNode, JSDoubleToStringNode) && doNumberString(Object, CharSequence, JSConcatStringsNode, JSDoubleToStringNode) && doPrimitiveConversion(Object, Object, JSToPrimitiveNode, JSToPrimitiveNode, JSToNumericNode, JSToNumericNode, JSToStringNode, JSToStringNode, ConditionProfile, ConditionProfile, JSAddNode, BranchProfile) */) {
                rightNodeValue_long = super.rightNode.executeLong(frameValue);
                rightNodeValue_ = JSTypes.longToDouble(rightNodeValue_long);
            } else if ((state & 0x1a00000L) == 0 /* only-active 1:double */ && (state & 0x1ffffL) != 0  /* is-not doIntTruncate(int, int) && doInt(int, int) && doIntOverflow(int, int) && doIntLargeIntegerTruncate(int, LargeInteger) && doLargeIntegerIntTruncate(LargeInteger, int) && doLargeIntegerTruncate(LargeInteger, LargeInteger) && doIntLargeInteger(int, LargeInteger) && doLargeIntegerInt(LargeInteger, int) && doLargeInteger(LargeInteger, LargeInteger) && doDouble(double, double) && doBigInt(BigInt, BigInt) && doString(CharSequence, CharSequence, JSConcatStringsNode) && doStringInt(CharSequence, int) && doIntString(int, CharSequence) && doStringNumber(CharSequence, Object, JSConcatStringsNode, JSDoubleToStringNode) && doNumberString(Object, CharSequence, JSConcatStringsNode, JSDoubleToStringNode) && doPrimitiveConversion(Object, Object, JSToPrimitiveNode, JSToPrimitiveNode, JSToNumericNode, JSToNumericNode, JSToStringNode, JSToStringNode, ConditionProfile, ConditionProfile, JSAddNode, BranchProfile) */) {
                rightNodeValue_int = super.rightNode.executeInt(frameValue);
                rightNodeValue_ = JSTypes.intToDouble(rightNodeValue_int);
            } else if ((state & 0x1600000L) == 0 /* only-active 1:double */ && (state & 0x1ffffL) != 0  /* is-not doIntTruncate(int, int) && doInt(int, int) && doIntOverflow(int, int) && doIntLargeIntegerTruncate(int, LargeInteger) && doLargeIntegerIntTruncate(LargeInteger, int) && doLargeIntegerTruncate(LargeInteger, LargeInteger) && doIntLargeInteger(int, LargeInteger) && doLargeIntegerInt(LargeInteger, int) && doLargeInteger(LargeInteger, LargeInteger) && doDouble(double, double) && doBigInt(BigInt, BigInt) && doString(CharSequence, CharSequence, JSConcatStringsNode) && doStringInt(CharSequence, int) && doIntString(int, CharSequence) && doStringNumber(CharSequence, Object, JSConcatStringsNode, JSDoubleToStringNode) && doNumberString(Object, CharSequence, JSConcatStringsNode, JSDoubleToStringNode) && doPrimitiveConversion(Object, Object, JSToPrimitiveNode, JSToPrimitiveNode, JSToNumericNode, JSToNumericNode, JSToStringNode, JSToStringNode, ConditionProfile, ConditionProfile, JSAddNode, BranchProfile) */) {
                rightNodeValue_ = super.rightNode.executeDouble(frameValue);
            } else {
                Object rightNodeValue__ = super.rightNode.execute(frameValue);
                rightNodeValue_ = JSTypesGen.expectImplicitDouble((int)((state & 0x1e00000L) >>> 21) /* extract-implicit-active 1:double */, rightNodeValue__);
            }
        } catch (UnexpectedResultException ex) {
            return executeAndSpecialize(((state & 0x1c0000L) == 0 /* only-active 0:double */ && (state & 0x1ffffL) != 0  /* is-not doIntTruncate(int, int) && doInt(int, int) && doIntOverflow(int, int) && doIntLargeIntegerTruncate(int, LargeInteger) && doLargeIntegerIntTruncate(LargeInteger, int) && doLargeIntegerTruncate(LargeInteger, LargeInteger) && doIntLargeInteger(int, LargeInteger) && doLargeIntegerInt(LargeInteger, int) && doLargeInteger(LargeInteger, LargeInteger) && doDouble(double, double) && doBigInt(BigInt, BigInt) && doString(CharSequence, CharSequence, JSConcatStringsNode) && doStringInt(CharSequence, int) && doIntString(int, CharSequence) && doStringNumber(CharSequence, Object, JSConcatStringsNode, JSDoubleToStringNode) && doNumberString(Object, CharSequence, JSConcatStringsNode, JSDoubleToStringNode) && doPrimitiveConversion(Object, Object, JSToPrimitiveNode, JSToPrimitiveNode, JSToNumericNode, JSToNumericNode, JSToStringNode, JSToStringNode, ConditionProfile, ConditionProfile, JSAddNode, BranchProfile) */ ? (Object) leftNodeValue_long : ((state & 0x1a0000L) == 0 /* only-active 0:double */ && (state & 0x1ffffL) != 0  /* is-not doIntTruncate(int, int) && doInt(int, int) && doIntOverflow(int, int) && doIntLargeIntegerTruncate(int, LargeInteger) && doLargeIntegerIntTruncate(LargeInteger, int) && doLargeIntegerTruncate(LargeInteger, LargeInteger) && doIntLargeInteger(int, LargeInteger) && doLargeIntegerInt(LargeInteger, int) && doLargeInteger(LargeInteger, LargeInteger) && doDouble(double, double) && doBigInt(BigInt, BigInt) && doString(CharSequence, CharSequence, JSConcatStringsNode) && doStringInt(CharSequence, int) && doIntString(int, CharSequence) && doStringNumber(CharSequence, Object, JSConcatStringsNode, JSDoubleToStringNode) && doNumberString(Object, CharSequence, JSConcatStringsNode, JSDoubleToStringNode) && doPrimitiveConversion(Object, Object, JSToPrimitiveNode, JSToPrimitiveNode, JSToNumericNode, JSToNumericNode, JSToStringNode, JSToStringNode, ConditionProfile, ConditionProfile, JSAddNode, BranchProfile) */ ? (Object) leftNodeValue_int : (Object) leftNodeValue_)), ex.getResult());
        }
        assert (state & 0b1000000000) != 0 /* is-active doDouble(double, double) */;
        return JSAddNode.doDouble(leftNodeValue_, rightNodeValue_);
    }

    private Object execute_int2(VirtualFrame frameValue, long state) {
        int leftNodeValue_;
        try {
            leftNodeValue_ = super.leftNode.executeInt(frameValue);
        } catch (UnexpectedResultException ex) {
            Object rightNodeValue = super.rightNode.execute(frameValue);
            return executeAndSpecialize(ex.getResult(), rightNodeValue);
        }
        Object rightNodeValue_ = super.rightNode.execute(frameValue);
        if ((state & 0b1001000) != 0 /* is-active doIntLargeIntegerTruncate(int, LargeInteger) || doIntLargeInteger(int, LargeInteger) */ && rightNodeValue_ instanceof LargeInteger) {
            LargeInteger rightNodeValue__ = (LargeInteger) rightNodeValue_;
            if ((state & 0b1000) != 0 /* is-active doIntLargeIntegerTruncate(int, LargeInteger) */) {
                assert (truncate);
                return JSAddNode.doIntLargeIntegerTruncate(leftNodeValue_, rightNodeValue__);
            }
            if ((state & 0b1000000) != 0 /* is-active doIntLargeInteger(int, LargeInteger) */) {
                assert (!(truncate));
                try {
                    return JSAddNode.doIntLargeInteger(leftNodeValue_, rightNodeValue__);
                } catch (ArithmeticException ex) {
                    // implicit transferToInterpreterAndInvalidate()
                    Lock lock = getLock();
                    lock.lock();
                    try {
                        this.exclude_ = this.exclude_ | 0b1000000 /* add-excluded doIntLargeInteger(int, LargeInteger) */;
                        this.state_ = this.state_ & 0xffffffffffffffbfL /* remove-active doIntLargeInteger(int, LargeInteger) */;
                    } finally {
                        lock.unlock();
                    }
                    return executeAndSpecialize(leftNodeValue_, rightNodeValue__);
                }
            }
        }
        if ((state & 0b10000000000000) != 0 /* is-active doIntString(int, CharSequence) */ && JSTypesGen.isImplicitCharSequence((int)((state & 0x1e0000000L) >>> 29) /* extract-implicit-active 1:CharSequence */, rightNodeValue_)) {
            CharSequence rightNodeValue__ = JSTypesGen.asImplicitCharSequence((int)((state & 0x1e0000000L) >>> 29) /* extract-implicit-active 1:CharSequence */, rightNodeValue_);
            return doIntString(leftNodeValue_, rightNodeValue__);
        }
        CompilerDirectives.transferToInterpreterAndInvalidate();
        return executeAndSpecialize(leftNodeValue_, rightNodeValue_);
    }

    private Object execute_int3(VirtualFrame frameValue, long state) {
        Object leftNodeValue_ = super.leftNode.execute(frameValue);
        int rightNodeValue_;
        try {
            rightNodeValue_ = super.rightNode.executeInt(frameValue);
        } catch (UnexpectedResultException ex) {
            return executeAndSpecialize(leftNodeValue_, ex.getResult());
        }
        if ((state & 0b10010000) != 0 /* is-active doLargeIntegerIntTruncate(LargeInteger, int) || doLargeIntegerInt(LargeInteger, int) */ && leftNodeValue_ instanceof LargeInteger) {
            LargeInteger leftNodeValue__ = (LargeInteger) leftNodeValue_;
            if ((state & 0b10000) != 0 /* is-active doLargeIntegerIntTruncate(LargeInteger, int) */) {
                assert (truncate);
                return JSAddNode.doLargeIntegerIntTruncate(leftNodeValue__, rightNodeValue_);
            }
            if ((state & 0b10000000) != 0 /* is-active doLargeIntegerInt(LargeInteger, int) */) {
                assert (!(truncate));
                try {
                    return JSAddNode.doLargeIntegerInt(leftNodeValue__, rightNodeValue_);
                } catch (ArithmeticException ex) {
                    // implicit transferToInterpreterAndInvalidate()
                    Lock lock = getLock();
                    lock.lock();
                    try {
                        this.exclude_ = this.exclude_ | 0b10000000 /* add-excluded doLargeIntegerInt(LargeInteger, int) */;
                        this.state_ = this.state_ & 0xffffffffffffff7fL /* remove-active doLargeIntegerInt(LargeInteger, int) */;
                    } finally {
                        lock.unlock();
                    }
                    return executeAndSpecialize(leftNodeValue__, rightNodeValue_);
                }
            }
        }
        if ((state & 0b1000000000000) != 0 /* is-active doStringInt(CharSequence, int) */ && JSTypesGen.isImplicitCharSequence((int)((state & 0x1e000000L) >>> 25) /* extract-implicit-active 0:CharSequence */, leftNodeValue_)) {
            CharSequence leftNodeValue__ = JSTypesGen.asImplicitCharSequence((int)((state & 0x1e000000L) >>> 25) /* extract-implicit-active 0:CharSequence */, leftNodeValue_);
            return doStringInt(leftNodeValue__, rightNodeValue_);
        }
        CompilerDirectives.transferToInterpreterAndInvalidate();
        return executeAndSpecialize(leftNodeValue_, rightNodeValue_);
    }

    private Object execute_generic4(VirtualFrame frameValue, long state) {
        Object leftNodeValue_ = super.leftNode.execute(frameValue);
        Object rightNodeValue_ = super.rightNode.execute(frameValue);
        if ((state & 0b1111) != 0 /* is-active doIntTruncate(int, int) || doInt(int, int) || doIntOverflow(int, int) || doIntLargeIntegerTruncate(int, LargeInteger) */ && leftNodeValue_ instanceof Integer) {
            int leftNodeValue__ = (int) leftNodeValue_;
            if ((state & 0b111) != 0 /* is-active doIntTruncate(int, int) || doInt(int, int) || doIntOverflow(int, int) */ && rightNodeValue_ instanceof Integer) {
                int rightNodeValue__ = (int) rightNodeValue_;
                if ((state & 0b1) != 0 /* is-active doIntTruncate(int, int) */) {
                    assert (truncate);
                    return JSAddNode.doIntTruncate(leftNodeValue__, rightNodeValue__);
                }
                if ((state & 0b10) != 0 /* is-active doInt(int, int) */) {
                    assert (!(truncate));
                    try {
                        return JSAddNode.doInt(leftNodeValue__, rightNodeValue__);
                    } catch (ArithmeticException ex) {
                        // implicit transferToInterpreterAndInvalidate()
                        Lock lock = getLock();
                        lock.lock();
                        try {
                            this.exclude_ = this.exclude_ | 0b10 /* add-excluded doInt(int, int) */;
                            this.state_ = this.state_ & 0xfffffffffffffffdL /* remove-active doInt(int, int) */;
                        } finally {
                            lock.unlock();
                        }
                        return executeAndSpecialize(leftNodeValue__, rightNodeValue__);
                    }
                }
                if ((state & 0b100) != 0 /* is-active doIntOverflow(int, int) */) {
                    assert (!(truncate));
                    try {
                        return JSAddNode.doIntOverflow(leftNodeValue__, rightNodeValue__);
                    } catch (ArithmeticException ex) {
                        // implicit transferToInterpreterAndInvalidate()
                        Lock lock = getLock();
                        lock.lock();
                        try {
                            this.exclude_ = this.exclude_ | 0b100 /* add-excluded doIntOverflow(int, int) */;
                            this.state_ = this.state_ & 0xfffffffffffffffbL /* remove-active doIntOverflow(int, int) */;
                        } finally {
                            lock.unlock();
                        }
                        return executeAndSpecialize(leftNodeValue__, rightNodeValue__);
                    }
                }
            }
            if ((state & 0b1000) != 0 /* is-active doIntLargeIntegerTruncate(int, LargeInteger) */ && rightNodeValue_ instanceof LargeInteger) {
                LargeInteger rightNodeValue__ = (LargeInteger) rightNodeValue_;
                assert (truncate);
                return JSAddNode.doIntLargeIntegerTruncate(leftNodeValue__, rightNodeValue__);
            }
        }
        if ((state & 0b110000) != 0 /* is-active doLargeIntegerIntTruncate(LargeInteger, int) || doLargeIntegerTruncate(LargeInteger, LargeInteger) */ && leftNodeValue_ instanceof LargeInteger) {
            LargeInteger leftNodeValue__ = (LargeInteger) leftNodeValue_;
            if ((state & 0b10000) != 0 /* is-active doLargeIntegerIntTruncate(LargeInteger, int) */ && rightNodeValue_ instanceof Integer) {
                int rightNodeValue__ = (int) rightNodeValue_;
                assert (truncate);
                return JSAddNode.doLargeIntegerIntTruncate(leftNodeValue__, rightNodeValue__);
            }
            if ((state & 0b100000) != 0 /* is-active doLargeIntegerTruncate(LargeInteger, LargeInteger) */ && rightNodeValue_ instanceof LargeInteger) {
                LargeInteger rightNodeValue__ = (LargeInteger) rightNodeValue_;
                assert (truncate);
                return JSAddNode.doLargeIntegerTruncate(leftNodeValue__, rightNodeValue__);
            }
        }
        if ((state & 0b1000000) != 0 /* is-active doIntLargeInteger(int, LargeInteger) */ && leftNodeValue_ instanceof Integer) {
            int leftNodeValue__ = (int) leftNodeValue_;
            if (rightNodeValue_ instanceof LargeInteger) {
                LargeInteger rightNodeValue__ = (LargeInteger) rightNodeValue_;
                assert (!(truncate));
                try {
                    return JSAddNode.doIntLargeInteger(leftNodeValue__, rightNodeValue__);
                } catch (ArithmeticException ex) {
                    // implicit transferToInterpreterAndInvalidate()
                    Lock lock = getLock();
                    lock.lock();
                    try {
                        this.exclude_ = this.exclude_ | 0b1000000 /* add-excluded doIntLargeInteger(int, LargeInteger) */;
                        this.state_ = this.state_ & 0xffffffffffffffbfL /* remove-active doIntLargeInteger(int, LargeInteger) */;
                    } finally {
                        lock.unlock();
                    }
                    return executeAndSpecialize(leftNodeValue__, rightNodeValue__);
                }
            }
        }
        if ((state & 0b110000000) != 0 /* is-active doLargeIntegerInt(LargeInteger, int) || doLargeInteger(LargeInteger, LargeInteger) */ && leftNodeValue_ instanceof LargeInteger) {
            LargeInteger leftNodeValue__ = (LargeInteger) leftNodeValue_;
            if ((state & 0b10000000) != 0 /* is-active doLargeIntegerInt(LargeInteger, int) */ && rightNodeValue_ instanceof Integer) {
                int rightNodeValue__ = (int) rightNodeValue_;
                assert (!(truncate));
                try {
                    return JSAddNode.doLargeIntegerInt(leftNodeValue__, rightNodeValue__);
                } catch (ArithmeticException ex) {
                    // implicit transferToInterpreterAndInvalidate()
                    Lock lock = getLock();
                    lock.lock();
                    try {
                        this.exclude_ = this.exclude_ | 0b10000000 /* add-excluded doLargeIntegerInt(LargeInteger, int) */;
                        this.state_ = this.state_ & 0xffffffffffffff7fL /* remove-active doLargeIntegerInt(LargeInteger, int) */;
                    } finally {
                        lock.unlock();
                    }
                    return executeAndSpecialize(leftNodeValue__, rightNodeValue__);
                }
            }
            if ((state & 0b100000000) != 0 /* is-active doLargeInteger(LargeInteger, LargeInteger) */ && rightNodeValue_ instanceof LargeInteger) {
                LargeInteger rightNodeValue__ = (LargeInteger) rightNodeValue_;
                assert (!(truncate));
                try {
                    return JSAddNode.doLargeInteger(leftNodeValue__, rightNodeValue__);
                } catch (ArithmeticException ex) {
                    // implicit transferToInterpreterAndInvalidate()
                    Lock lock = getLock();
                    lock.lock();
                    try {
                        this.exclude_ = this.exclude_ | 0b100000000 /* add-excluded doLargeInteger(LargeInteger, LargeInteger) */;
                        this.state_ = this.state_ & 0xfffffffffffffeffL /* remove-active doLargeInteger(LargeInteger, LargeInteger) */;
                    } finally {
                        lock.unlock();
                    }
                    return executeAndSpecialize(leftNodeValue__, rightNodeValue__);
                }
            }
        }
        if ((state & 0b1000000000) != 0 /* is-active doDouble(double, double) */ && JSTypesGen.isImplicitDouble((int)((state & 0x1e0000L) >>> 17) /* extract-implicit-active 0:double */, leftNodeValue_)) {
            double leftNodeValue__ = JSTypesGen.asImplicitDouble((int)((state & 0x1e0000L) >>> 17) /* extract-implicit-active 0:double */, leftNodeValue_);
            if (JSTypesGen.isImplicitDouble((int)((state & 0x1e00000L) >>> 21) /* extract-implicit-active 1:double */, rightNodeValue_)) {
                double rightNodeValue__ = JSTypesGen.asImplicitDouble((int)((state & 0x1e00000L) >>> 21) /* extract-implicit-active 1:double */, rightNodeValue_);
                return JSAddNode.doDouble(leftNodeValue__, rightNodeValue__);
            }
        }
        if ((state & 0b10000000000) != 0 /* is-active doBigInt(BigInt, BigInt) */ && leftNodeValue_ instanceof BigInt) {
            BigInt leftNodeValue__ = (BigInt) leftNodeValue_;
            if (rightNodeValue_ instanceof BigInt) {
                BigInt rightNodeValue__ = (BigInt) rightNodeValue_;
                return doBigInt(leftNodeValue__, rightNodeValue__);
            }
        }
        if ((state & 0b1100000000000) != 0 /* is-active doString(CharSequence, CharSequence, JSConcatStringsNode) || doStringInt(CharSequence, int) */ && JSTypesGen.isImplicitCharSequence((int)((state & 0x1e000000L) >>> 25) /* extract-implicit-active 0:CharSequence */, leftNodeValue_)) {
            CharSequence leftNodeValue__ = JSTypesGen.asImplicitCharSequence((int)((state & 0x1e000000L) >>> 25) /* extract-implicit-active 0:CharSequence */, leftNodeValue_);
            if ((state & 0b100000000000) != 0 /* is-active doString(CharSequence, CharSequence, JSConcatStringsNode) */ && JSTypesGen.isImplicitCharSequence((int)((state & 0x1e0000000L) >>> 29) /* extract-implicit-active 1:CharSequence */, rightNodeValue_)) {
                CharSequence rightNodeValue__ = JSTypesGen.asImplicitCharSequence((int)((state & 0x1e0000000L) >>> 29) /* extract-implicit-active 1:CharSequence */, rightNodeValue_);
                return doString(leftNodeValue__, rightNodeValue__, this.concatStringsNode);
            }
            if ((state & 0b1000000000000) != 0 /* is-active doStringInt(CharSequence, int) */ && rightNodeValue_ instanceof Integer) {
                int rightNodeValue__ = (int) rightNodeValue_;
                return doStringInt(leftNodeValue__, rightNodeValue__);
            }
        }
        if ((state & 0b10000000000000) != 0 /* is-active doIntString(int, CharSequence) */ && leftNodeValue_ instanceof Integer) {
            int leftNodeValue__ = (int) leftNodeValue_;
            if (JSTypesGen.isImplicitCharSequence((int)((state & 0x1e0000000L) >>> 29) /* extract-implicit-active 1:CharSequence */, rightNodeValue_)) {
                CharSequence rightNodeValue__ = JSTypesGen.asImplicitCharSequence((int)((state & 0x1e0000000L) >>> 29) /* extract-implicit-active 1:CharSequence */, rightNodeValue_);
                return doIntString(leftNodeValue__, rightNodeValue__);
            }
        }
        if ((state & 0b100000000000000) != 0 /* is-active doStringNumber(CharSequence, Object, JSConcatStringsNode, JSDoubleToStringNode) */ && JSTypesGen.isImplicitCharSequence((int)((state & 0x1e000000L) >>> 25) /* extract-implicit-active 0:CharSequence */, leftNodeValue_)) {
            CharSequence leftNodeValue__ = JSTypesGen.asImplicitCharSequence((int)((state & 0x1e000000L) >>> 25) /* extract-implicit-active 0:CharSequence */, leftNodeValue_);
            if ((JSGuards.isNumber(rightNodeValue_))) {
                return doStringNumber(leftNodeValue__, rightNodeValue_, this.concatStringsNode, this.doubleToStringNode);
            }
        }
        if ((state & 0x18000L) != 0 /* is-active doNumberString(Object, CharSequence, JSConcatStringsNode, JSDoubleToStringNode) || doPrimitiveConversion(Object, Object, JSToPrimitiveNode, JSToPrimitiveNode, JSToNumericNode, JSToNumericNode, JSToStringNode, JSToStringNode, ConditionProfile, ConditionProfile, JSAddNode, BranchProfile) */) {
            if ((state & 0b1000000000000000) != 0 /* is-active doNumberString(Object, CharSequence, JSConcatStringsNode, JSDoubleToStringNode) */ && JSTypesGen.isImplicitCharSequence((int)((state & 0x1e0000000L) >>> 29) /* extract-implicit-active 1:CharSequence */, rightNodeValue_)) {
                CharSequence rightNodeValue__ = JSTypesGen.asImplicitCharSequence((int)((state & 0x1e0000000L) >>> 29) /* extract-implicit-active 1:CharSequence */, rightNodeValue_);
                if ((JSGuards.isNumber(leftNodeValue_))) {
                    return doNumberString(leftNodeValue_, rightNodeValue__, this.concatStringsNode, this.doubleToStringNode);
                }
            }
            if ((state & 0x10000L) != 0 /* is-active doPrimitiveConversion(Object, Object, JSToPrimitiveNode, JSToPrimitiveNode, JSToNumericNode, JSToNumericNode, JSToStringNode, JSToStringNode, ConditionProfile, ConditionProfile, JSAddNode, BranchProfile) */) {
                PrimitiveConversionData s17_ = this.primitiveConversion_cache;
                if (s17_ != null) {
                    return doPrimitiveConversion(leftNodeValue_, rightNodeValue_, s17_.toPrimitiveA_, s17_.toPrimitiveB_, s17_.toNumericA_, s17_.toNumericB_, s17_.toStringA_, s17_.toStringB_, s17_.profileA_, s17_.profileB_, s17_.add_, s17_.mixedNumericTypes_);
                }
            }
        }
        CompilerDirectives.transferToInterpreterAndInvalidate();
        return executeAndSpecialize(leftNodeValue_, rightNodeValue_);
    }

    @Override
    public double executeDouble(VirtualFrame frameValue) throws UnexpectedResultException {
        long state = state_;
        if ((state & 0x10004L) != 0 /* is-active doIntOverflow(int, int) || doPrimitiveConversion(Object, Object, JSToPrimitiveNode, JSToPrimitiveNode, JSToNumericNode, JSToNumericNode, JSToStringNode, JSToStringNode, ConditionProfile, ConditionProfile, JSAddNode, BranchProfile) */) {
            return JSTypesGen.expectDouble(execute(frameValue));
        }
        int leftNodeValue_int = 0;
        long leftNodeValue_long = 0L;
        double leftNodeValue_;
        try {
            if ((state & 0x1c0000L) == 0 /* only-active 0:double */ && (state & 0x1ffffL) != 0  /* is-not doIntTruncate(int, int) && doInt(int, int) && doIntOverflow(int, int) && doIntLargeIntegerTruncate(int, LargeInteger) && doLargeIntegerIntTruncate(LargeInteger, int) && doLargeIntegerTruncate(LargeInteger, LargeInteger) && doIntLargeInteger(int, LargeInteger) && doLargeIntegerInt(LargeInteger, int) && doLargeInteger(LargeInteger, LargeInteger) && doDouble(double, double) && doBigInt(BigInt, BigInt) && doString(CharSequence, CharSequence, JSConcatStringsNode) && doStringInt(CharSequence, int) && doIntString(int, CharSequence) && doStringNumber(CharSequence, Object, JSConcatStringsNode, JSDoubleToStringNode) && doNumberString(Object, CharSequence, JSConcatStringsNode, JSDoubleToStringNode) && doPrimitiveConversion(Object, Object, JSToPrimitiveNode, JSToPrimitiveNode, JSToNumericNode, JSToNumericNode, JSToStringNode, JSToStringNode, ConditionProfile, ConditionProfile, JSAddNode, BranchProfile) */) {
                leftNodeValue_long = super.leftNode.executeLong(frameValue);
                leftNodeValue_ = JSTypes.longToDouble(leftNodeValue_long);
            } else if ((state & 0x1a0000L) == 0 /* only-active 0:double */ && (state & 0x1ffffL) != 0  /* is-not doIntTruncate(int, int) && doInt(int, int) && doIntOverflow(int, int) && doIntLargeIntegerTruncate(int, LargeInteger) && doLargeIntegerIntTruncate(LargeInteger, int) && doLargeIntegerTruncate(LargeInteger, LargeInteger) && doIntLargeInteger(int, LargeInteger) && doLargeIntegerInt(LargeInteger, int) && doLargeInteger(LargeInteger, LargeInteger) && doDouble(double, double) && doBigInt(BigInt, BigInt) && doString(CharSequence, CharSequence, JSConcatStringsNode) && doStringInt(CharSequence, int) && doIntString(int, CharSequence) && doStringNumber(CharSequence, Object, JSConcatStringsNode, JSDoubleToStringNode) && doNumberString(Object, CharSequence, JSConcatStringsNode, JSDoubleToStringNode) && doPrimitiveConversion(Object, Object, JSToPrimitiveNode, JSToPrimitiveNode, JSToNumericNode, JSToNumericNode, JSToStringNode, JSToStringNode, ConditionProfile, ConditionProfile, JSAddNode, BranchProfile) */) {
                leftNodeValue_int = super.leftNode.executeInt(frameValue);
                leftNodeValue_ = JSTypes.intToDouble(leftNodeValue_int);
            } else if ((state & 0x160000L) == 0 /* only-active 0:double */ && (state & 0x1ffffL) != 0  /* is-not doIntTruncate(int, int) && doInt(int, int) && doIntOverflow(int, int) && doIntLargeIntegerTruncate(int, LargeInteger) && doLargeIntegerIntTruncate(LargeInteger, int) && doLargeIntegerTruncate(LargeInteger, LargeInteger) && doIntLargeInteger(int, LargeInteger) && doLargeIntegerInt(LargeInteger, int) && doLargeInteger(LargeInteger, LargeInteger) && doDouble(double, double) && doBigInt(BigInt, BigInt) && doString(CharSequence, CharSequence, JSConcatStringsNode) && doStringInt(CharSequence, int) && doIntString(int, CharSequence) && doStringNumber(CharSequence, Object, JSConcatStringsNode, JSDoubleToStringNode) && doNumberString(Object, CharSequence, JSConcatStringsNode, JSDoubleToStringNode) && doPrimitiveConversion(Object, Object, JSToPrimitiveNode, JSToPrimitiveNode, JSToNumericNode, JSToNumericNode, JSToStringNode, JSToStringNode, ConditionProfile, ConditionProfile, JSAddNode, BranchProfile) */) {
                leftNodeValue_ = super.leftNode.executeDouble(frameValue);
            } else {
                Object leftNodeValue__ = super.leftNode.execute(frameValue);
                leftNodeValue_ = JSTypesGen.expectImplicitDouble((int)((state & 0x1e0000L) >>> 17) /* extract-implicit-active 0:double */, leftNodeValue__);
            }
        } catch (UnexpectedResultException ex) {
            Object rightNodeValue = super.rightNode.execute(frameValue);
            return JSTypesGen.expectDouble(executeAndSpecialize(ex.getResult(), rightNodeValue));
        }
        int rightNodeValue_int = 0;
        long rightNodeValue_long = 0L;
        double rightNodeValue_;
        try {
            if ((state & 0x1c00000L) == 0 /* only-active 1:double */ && (state & 0x1ffffL) != 0  /* is-not doIntTruncate(int, int) && doInt(int, int) && doIntOverflow(int, int) && doIntLargeIntegerTruncate(int, LargeInteger) && doLargeIntegerIntTruncate(LargeInteger, int) && doLargeIntegerTruncate(LargeInteger, LargeInteger) && doIntLargeInteger(int, LargeInteger) && doLargeIntegerInt(LargeInteger, int) && doLargeInteger(LargeInteger, LargeInteger) && doDouble(double, double) && doBigInt(BigInt, BigInt) && doString(CharSequence, CharSequence, JSConcatStringsNode) && doStringInt(CharSequence, int) && doIntString(int, CharSequence) && doStringNumber(CharSequence, Object, JSConcatStringsNode, JSDoubleToStringNode) && doNumberString(Object, CharSequence, JSConcatStringsNode, JSDoubleToStringNode) && doPrimitiveConversion(Object, Object, JSToPrimitiveNode, JSToPrimitiveNode, JSToNumericNode, JSToNumericNode, JSToStringNode, JSToStringNode, ConditionProfile, ConditionProfile, JSAddNode, BranchProfile) */) {
                rightNodeValue_long = super.rightNode.executeLong(frameValue);
                rightNodeValue_ = JSTypes.longToDouble(rightNodeValue_long);
            } else if ((state & 0x1a00000L) == 0 /* only-active 1:double */ && (state & 0x1ffffL) != 0  /* is-not doIntTruncate(int, int) && doInt(int, int) && doIntOverflow(int, int) && doIntLargeIntegerTruncate(int, LargeInteger) && doLargeIntegerIntTruncate(LargeInteger, int) && doLargeIntegerTruncate(LargeInteger, LargeInteger) && doIntLargeInteger(int, LargeInteger) && doLargeIntegerInt(LargeInteger, int) && doLargeInteger(LargeInteger, LargeInteger) && doDouble(double, double) && doBigInt(BigInt, BigInt) && doString(CharSequence, CharSequence, JSConcatStringsNode) && doStringInt(CharSequence, int) && doIntString(int, CharSequence) && doStringNumber(CharSequence, Object, JSConcatStringsNode, JSDoubleToStringNode) && doNumberString(Object, CharSequence, JSConcatStringsNode, JSDoubleToStringNode) && doPrimitiveConversion(Object, Object, JSToPrimitiveNode, JSToPrimitiveNode, JSToNumericNode, JSToNumericNode, JSToStringNode, JSToStringNode, ConditionProfile, ConditionProfile, JSAddNode, BranchProfile) */) {
                rightNodeValue_int = super.rightNode.executeInt(frameValue);
                rightNodeValue_ = JSTypes.intToDouble(rightNodeValue_int);
            } else if ((state & 0x1600000L) == 0 /* only-active 1:double */ && (state & 0x1ffffL) != 0  /* is-not doIntTruncate(int, int) && doInt(int, int) && doIntOverflow(int, int) && doIntLargeIntegerTruncate(int, LargeInteger) && doLargeIntegerIntTruncate(LargeInteger, int) && doLargeIntegerTruncate(LargeInteger, LargeInteger) && doIntLargeInteger(int, LargeInteger) && doLargeIntegerInt(LargeInteger, int) && doLargeInteger(LargeInteger, LargeInteger) && doDouble(double, double) && doBigInt(BigInt, BigInt) && doString(CharSequence, CharSequence, JSConcatStringsNode) && doStringInt(CharSequence, int) && doIntString(int, CharSequence) && doStringNumber(CharSequence, Object, JSConcatStringsNode, JSDoubleToStringNode) && doNumberString(Object, CharSequence, JSConcatStringsNode, JSDoubleToStringNode) && doPrimitiveConversion(Object, Object, JSToPrimitiveNode, JSToPrimitiveNode, JSToNumericNode, JSToNumericNode, JSToStringNode, JSToStringNode, ConditionProfile, ConditionProfile, JSAddNode, BranchProfile) */) {
                rightNodeValue_ = super.rightNode.executeDouble(frameValue);
            } else {
                Object rightNodeValue__ = super.rightNode.execute(frameValue);
                rightNodeValue_ = JSTypesGen.expectImplicitDouble((int)((state & 0x1e00000L) >>> 21) /* extract-implicit-active 1:double */, rightNodeValue__);
            }
        } catch (UnexpectedResultException ex) {
            return JSTypesGen.expectDouble(executeAndSpecialize(((state & 0x1c0000L) == 0 /* only-active 0:double */ && (state & 0x1ffffL) != 0  /* is-not doIntTruncate(int, int) && doInt(int, int) && doIntOverflow(int, int) && doIntLargeIntegerTruncate(int, LargeInteger) && doLargeIntegerIntTruncate(LargeInteger, int) && doLargeIntegerTruncate(LargeInteger, LargeInteger) && doIntLargeInteger(int, LargeInteger) && doLargeIntegerInt(LargeInteger, int) && doLargeInteger(LargeInteger, LargeInteger) && doDouble(double, double) && doBigInt(BigInt, BigInt) && doString(CharSequence, CharSequence, JSConcatStringsNode) && doStringInt(CharSequence, int) && doIntString(int, CharSequence) && doStringNumber(CharSequence, Object, JSConcatStringsNode, JSDoubleToStringNode) && doNumberString(Object, CharSequence, JSConcatStringsNode, JSDoubleToStringNode) && doPrimitiveConversion(Object, Object, JSToPrimitiveNode, JSToPrimitiveNode, JSToNumericNode, JSToNumericNode, JSToStringNode, JSToStringNode, ConditionProfile, ConditionProfile, JSAddNode, BranchProfile) */ ? (Object) leftNodeValue_long : ((state & 0x1a0000L) == 0 /* only-active 0:double */ && (state & 0x1ffffL) != 0  /* is-not doIntTruncate(int, int) && doInt(int, int) && doIntOverflow(int, int) && doIntLargeIntegerTruncate(int, LargeInteger) && doLargeIntegerIntTruncate(LargeInteger, int) && doLargeIntegerTruncate(LargeInteger, LargeInteger) && doIntLargeInteger(int, LargeInteger) && doLargeIntegerInt(LargeInteger, int) && doLargeInteger(LargeInteger, LargeInteger) && doDouble(double, double) && doBigInt(BigInt, BigInt) && doString(CharSequence, CharSequence, JSConcatStringsNode) && doStringInt(CharSequence, int) && doIntString(int, CharSequence) && doStringNumber(CharSequence, Object, JSConcatStringsNode, JSDoubleToStringNode) && doNumberString(Object, CharSequence, JSConcatStringsNode, JSDoubleToStringNode) && doPrimitiveConversion(Object, Object, JSToPrimitiveNode, JSToPrimitiveNode, JSToNumericNode, JSToNumericNode, JSToStringNode, JSToStringNode, ConditionProfile, ConditionProfile, JSAddNode, BranchProfile) */ ? (Object) leftNodeValue_int : (Object) leftNodeValue_)), ex.getResult()));
        }
        if ((state & 0b1000000000) != 0 /* is-active doDouble(double, double) */) {
            return JSAddNode.doDouble(leftNodeValue_, rightNodeValue_);
        }
        CompilerDirectives.transferToInterpreterAndInvalidate();
        return JSTypesGen.expectDouble(executeAndSpecialize(((state & 0x1c0000L) == 0 /* only-active 0:double */ && (state & 0x1ffffL) != 0  /* is-not doIntTruncate(int, int) && doInt(int, int) && doIntOverflow(int, int) && doIntLargeIntegerTruncate(int, LargeInteger) && doLargeIntegerIntTruncate(LargeInteger, int) && doLargeIntegerTruncate(LargeInteger, LargeInteger) && doIntLargeInteger(int, LargeInteger) && doLargeIntegerInt(LargeInteger, int) && doLargeInteger(LargeInteger, LargeInteger) && doDouble(double, double) && doBigInt(BigInt, BigInt) && doString(CharSequence, CharSequence, JSConcatStringsNode) && doStringInt(CharSequence, int) && doIntString(int, CharSequence) && doStringNumber(CharSequence, Object, JSConcatStringsNode, JSDoubleToStringNode) && doNumberString(Object, CharSequence, JSConcatStringsNode, JSDoubleToStringNode) && doPrimitiveConversion(Object, Object, JSToPrimitiveNode, JSToPrimitiveNode, JSToNumericNode, JSToNumericNode, JSToStringNode, JSToStringNode, ConditionProfile, ConditionProfile, JSAddNode, BranchProfile) */ ? (Object) leftNodeValue_long : ((state & 0x1a0000L) == 0 /* only-active 0:double */ && (state & 0x1ffffL) != 0  /* is-not doIntTruncate(int, int) && doInt(int, int) && doIntOverflow(int, int) && doIntLargeIntegerTruncate(int, LargeInteger) && doLargeIntegerIntTruncate(LargeInteger, int) && doLargeIntegerTruncate(LargeInteger, LargeInteger) && doIntLargeInteger(int, LargeInteger) && doLargeIntegerInt(LargeInteger, int) && doLargeInteger(LargeInteger, LargeInteger) && doDouble(double, double) && doBigInt(BigInt, BigInt) && doString(CharSequence, CharSequence, JSConcatStringsNode) && doStringInt(CharSequence, int) && doIntString(int, CharSequence) && doStringNumber(CharSequence, Object, JSConcatStringsNode, JSDoubleToStringNode) && doNumberString(Object, CharSequence, JSConcatStringsNode, JSDoubleToStringNode) && doPrimitiveConversion(Object, Object, JSToPrimitiveNode, JSToPrimitiveNode, JSToNumericNode, JSToNumericNode, JSToStringNode, JSToStringNode, ConditionProfile, ConditionProfile, JSAddNode, BranchProfile) */ ? (Object) leftNodeValue_int : (Object) leftNodeValue_)), ((state & 0x1c00000L) == 0 /* only-active 1:double */ && (state & 0x1ffffL) != 0  /* is-not doIntTruncate(int, int) && doInt(int, int) && doIntOverflow(int, int) && doIntLargeIntegerTruncate(int, LargeInteger) && doLargeIntegerIntTruncate(LargeInteger, int) && doLargeIntegerTruncate(LargeInteger, LargeInteger) && doIntLargeInteger(int, LargeInteger) && doLargeIntegerInt(LargeInteger, int) && doLargeInteger(LargeInteger, LargeInteger) && doDouble(double, double) && doBigInt(BigInt, BigInt) && doString(CharSequence, CharSequence, JSConcatStringsNode) && doStringInt(CharSequence, int) && doIntString(int, CharSequence) && doStringNumber(CharSequence, Object, JSConcatStringsNode, JSDoubleToStringNode) && doNumberString(Object, CharSequence, JSConcatStringsNode, JSDoubleToStringNode) && doPrimitiveConversion(Object, Object, JSToPrimitiveNode, JSToPrimitiveNode, JSToNumericNode, JSToNumericNode, JSToStringNode, JSToStringNode, ConditionProfile, ConditionProfile, JSAddNode, BranchProfile) */ ? (Object) rightNodeValue_long : ((state & 0x1a00000L) == 0 /* only-active 1:double */ && (state & 0x1ffffL) != 0  /* is-not doIntTruncate(int, int) && doInt(int, int) && doIntOverflow(int, int) && doIntLargeIntegerTruncate(int, LargeInteger) && doLargeIntegerIntTruncate(LargeInteger, int) && doLargeIntegerTruncate(LargeInteger, LargeInteger) && doIntLargeInteger(int, LargeInteger) && doLargeIntegerInt(LargeInteger, int) && doLargeInteger(LargeInteger, LargeInteger) && doDouble(double, double) && doBigInt(BigInt, BigInt) && doString(CharSequence, CharSequence, JSConcatStringsNode) && doStringInt(CharSequence, int) && doIntString(int, CharSequence) && doStringNumber(CharSequence, Object, JSConcatStringsNode, JSDoubleToStringNode) && doNumberString(Object, CharSequence, JSConcatStringsNode, JSDoubleToStringNode) && doPrimitiveConversion(Object, Object, JSToPrimitiveNode, JSToPrimitiveNode, JSToNumericNode, JSToNumericNode, JSToStringNode, JSToStringNode, ConditionProfile, ConditionProfile, JSAddNode, BranchProfile) */ ? (Object) rightNodeValue_int : (Object) rightNodeValue_))));
    }

    @Override
    public int executeInt(VirtualFrame frameValue) throws UnexpectedResultException {
        long state = state_;
        if ((state & 0x10004L) != 0 /* is-active doIntOverflow(int, int) || doPrimitiveConversion(Object, Object, JSToPrimitiveNode, JSToPrimitiveNode, JSToNumericNode, JSToNumericNode, JSToStringNode, JSToStringNode, ConditionProfile, ConditionProfile, JSAddNode, BranchProfile) */) {
            return JSTypesGen.expectInteger(execute(frameValue));
        }
        if ((state & 0b111000) == 0 /* only-active doIntTruncate(int, int) && doInt(int, int) */ && (state & 0b111011) != 0  /* is-not doIntTruncate(int, int) && doInt(int, int) && doIntLargeIntegerTruncate(int, LargeInteger) && doLargeIntegerIntTruncate(LargeInteger, int) && doLargeIntegerTruncate(LargeInteger, LargeInteger) */) {
            return executeInt_int_int5(frameValue, state);
        } else if ((state & 0b110011) == 0 /* only-active doIntLargeIntegerTruncate(int, LargeInteger) */ && (state & 0b111011) != 0  /* is-not doIntTruncate(int, int) && doInt(int, int) && doIntLargeIntegerTruncate(int, LargeInteger) && doLargeIntegerIntTruncate(LargeInteger, int) && doLargeIntegerTruncate(LargeInteger, LargeInteger) */) {
            return executeInt_int6(frameValue, state);
        } else if ((state & 0b101011) == 0 /* only-active doLargeIntegerIntTruncate(LargeInteger, int) */ && (state & 0b111011) != 0  /* is-not doIntTruncate(int, int) && doInt(int, int) && doIntLargeIntegerTruncate(int, LargeInteger) && doLargeIntegerIntTruncate(LargeInteger, int) && doLargeIntegerTruncate(LargeInteger, LargeInteger) */) {
            return executeInt_int7(frameValue, state);
        } else {
            return executeInt_generic8(frameValue, state);
        }
    }

    private int executeInt_int_int5(VirtualFrame frameValue, long state) throws UnexpectedResultException {
        int leftNodeValue_;
        try {
            leftNodeValue_ = super.leftNode.executeInt(frameValue);
        } catch (UnexpectedResultException ex) {
            Object rightNodeValue = super.rightNode.execute(frameValue);
            return JSTypesGen.expectInteger(executeAndSpecialize(ex.getResult(), rightNodeValue));
        }
        int rightNodeValue_;
        try {
            rightNodeValue_ = super.rightNode.executeInt(frameValue);
        } catch (UnexpectedResultException ex) {
            return JSTypesGen.expectInteger(executeAndSpecialize(leftNodeValue_, ex.getResult()));
        }
        if ((state & 0b1) != 0 /* is-active doIntTruncate(int, int) */) {
            assert (truncate);
            return JSAddNode.doIntTruncate(leftNodeValue_, rightNodeValue_);
        }
        if ((state & 0b10) != 0 /* is-active doInt(int, int) */) {
            assert (!(truncate));
            try {
                return JSAddNode.doInt(leftNodeValue_, rightNodeValue_);
            } catch (ArithmeticException ex) {
                // implicit transferToInterpreterAndInvalidate()
                Lock lock = getLock();
                lock.lock();
                try {
                    this.exclude_ = this.exclude_ | 0b10 /* add-excluded doInt(int, int) */;
                    this.state_ = this.state_ & 0xfffffffffffffffdL /* remove-active doInt(int, int) */;
                } finally {
                    lock.unlock();
                }
                return JSTypesGen.expectInteger(executeAndSpecialize(leftNodeValue_, rightNodeValue_));
            }
        }
        CompilerDirectives.transferToInterpreterAndInvalidate();
        return JSTypesGen.expectInteger(executeAndSpecialize(leftNodeValue_, rightNodeValue_));
    }

    private int executeInt_int6(VirtualFrame frameValue, long state) throws UnexpectedResultException {
        int leftNodeValue_;
        try {
            leftNodeValue_ = super.leftNode.executeInt(frameValue);
        } catch (UnexpectedResultException ex) {
            Object rightNodeValue = super.rightNode.execute(frameValue);
            return JSTypesGen.expectInteger(executeAndSpecialize(ex.getResult(), rightNodeValue));
        }
        Object rightNodeValue_ = super.rightNode.execute(frameValue);
        assert (state & 0b1000) != 0 /* is-active doIntLargeIntegerTruncate(int, LargeInteger) */;
        if (rightNodeValue_ instanceof LargeInteger) {
            LargeInteger rightNodeValue__ = (LargeInteger) rightNodeValue_;
            assert (truncate);
            return JSAddNode.doIntLargeIntegerTruncate(leftNodeValue_, rightNodeValue__);
        }
        CompilerDirectives.transferToInterpreterAndInvalidate();
        return JSTypesGen.expectInteger(executeAndSpecialize(leftNodeValue_, rightNodeValue_));
    }

    private int executeInt_int7(VirtualFrame frameValue, long state) throws UnexpectedResultException {
        Object leftNodeValue_ = super.leftNode.execute(frameValue);
        int rightNodeValue_;
        try {
            rightNodeValue_ = super.rightNode.executeInt(frameValue);
        } catch (UnexpectedResultException ex) {
            return JSTypesGen.expectInteger(executeAndSpecialize(leftNodeValue_, ex.getResult()));
        }
        assert (state & 0b10000) != 0 /* is-active doLargeIntegerIntTruncate(LargeInteger, int) */;
        if (leftNodeValue_ instanceof LargeInteger) {
            LargeInteger leftNodeValue__ = (LargeInteger) leftNodeValue_;
            assert (truncate);
            return JSAddNode.doLargeIntegerIntTruncate(leftNodeValue__, rightNodeValue_);
        }
        CompilerDirectives.transferToInterpreterAndInvalidate();
        return JSTypesGen.expectInteger(executeAndSpecialize(leftNodeValue_, rightNodeValue_));
    }

    private int executeInt_generic8(VirtualFrame frameValue, long state) throws UnexpectedResultException {
        Object leftNodeValue_ = super.leftNode.execute(frameValue);
        Object rightNodeValue_ = super.rightNode.execute(frameValue);
        if ((state & 0b1011) != 0 /* is-active doIntTruncate(int, int) || doInt(int, int) || doIntLargeIntegerTruncate(int, LargeInteger) */ && leftNodeValue_ instanceof Integer) {
            int leftNodeValue__ = (int) leftNodeValue_;
            if ((state & 0b11) != 0 /* is-active doIntTruncate(int, int) || doInt(int, int) */ && rightNodeValue_ instanceof Integer) {
                int rightNodeValue__ = (int) rightNodeValue_;
                if ((state & 0b1) != 0 /* is-active doIntTruncate(int, int) */) {
                    assert (truncate);
                    return JSAddNode.doIntTruncate(leftNodeValue__, rightNodeValue__);
                }
                if ((state & 0b10) != 0 /* is-active doInt(int, int) */) {
                    assert (!(truncate));
                    try {
                        return JSAddNode.doInt(leftNodeValue__, rightNodeValue__);
                    } catch (ArithmeticException ex) {
                        // implicit transferToInterpreterAndInvalidate()
                        Lock lock = getLock();
                        lock.lock();
                        try {
                            this.exclude_ = this.exclude_ | 0b10 /* add-excluded doInt(int, int) */;
                            this.state_ = this.state_ & 0xfffffffffffffffdL /* remove-active doInt(int, int) */;
                        } finally {
                            lock.unlock();
                        }
                        return JSTypesGen.expectInteger(executeAndSpecialize(leftNodeValue__, rightNodeValue__));
                    }
                }
            }
            if ((state & 0b1000) != 0 /* is-active doIntLargeIntegerTruncate(int, LargeInteger) */ && rightNodeValue_ instanceof LargeInteger) {
                LargeInteger rightNodeValue__ = (LargeInteger) rightNodeValue_;
                assert (truncate);
                return JSAddNode.doIntLargeIntegerTruncate(leftNodeValue__, rightNodeValue__);
            }
        }
        if ((state & 0b110000) != 0 /* is-active doLargeIntegerIntTruncate(LargeInteger, int) || doLargeIntegerTruncate(LargeInteger, LargeInteger) */ && leftNodeValue_ instanceof LargeInteger) {
            LargeInteger leftNodeValue__ = (LargeInteger) leftNodeValue_;
            if ((state & 0b10000) != 0 /* is-active doLargeIntegerIntTruncate(LargeInteger, int) */ && rightNodeValue_ instanceof Integer) {
                int rightNodeValue__ = (int) rightNodeValue_;
                assert (truncate);
                return JSAddNode.doLargeIntegerIntTruncate(leftNodeValue__, rightNodeValue__);
            }
            if ((state & 0b100000) != 0 /* is-active doLargeIntegerTruncate(LargeInteger, LargeInteger) */ && rightNodeValue_ instanceof LargeInteger) {
                LargeInteger rightNodeValue__ = (LargeInteger) rightNodeValue_;
                assert (truncate);
                return JSAddNode.doLargeIntegerTruncate(leftNodeValue__, rightNodeValue__);
            }
        }
        CompilerDirectives.transferToInterpreterAndInvalidate();
        return JSTypesGen.expectInteger(executeAndSpecialize(leftNodeValue_, rightNodeValue_));
    }

    @Override
    public void executeVoid(VirtualFrame frameValue) {
        long state = state_;
        try {
            if ((state & 0x1ffc4L) == 0 /* only-active doIntTruncate(int, int) && doInt(int, int) && doIntLargeIntegerTruncate(int, LargeInteger) && doLargeIntegerIntTruncate(LargeInteger, int) && doLargeIntegerTruncate(LargeInteger, LargeInteger) */ && (state & 0x1ffffL) != 0  /* is-not doIntTruncate(int, int) && doInt(int, int) && doIntOverflow(int, int) && doIntLargeIntegerTruncate(int, LargeInteger) && doLargeIntegerIntTruncate(LargeInteger, int) && doLargeIntegerTruncate(LargeInteger, LargeInteger) && doIntLargeInteger(int, LargeInteger) && doLargeIntegerInt(LargeInteger, int) && doLargeInteger(LargeInteger, LargeInteger) && doDouble(double, double) && doBigInt(BigInt, BigInt) && doString(CharSequence, CharSequence, JSConcatStringsNode) && doStringInt(CharSequence, int) && doIntString(int, CharSequence) && doStringNumber(CharSequence, Object, JSConcatStringsNode, JSDoubleToStringNode) && doNumberString(Object, CharSequence, JSConcatStringsNode, JSDoubleToStringNode) && doPrimitiveConversion(Object, Object, JSToPrimitiveNode, JSToPrimitiveNode, JSToNumericNode, JSToNumericNode, JSToStringNode, JSToStringNode, ConditionProfile, ConditionProfile, JSAddNode, BranchProfile) */) {
                executeInt(frameValue);
                return;
            } else if ((state & 0x1fdffL) == 0 /* only-active doDouble(double, double) */ && (state & 0x1ffffL) != 0  /* is-not doIntTruncate(int, int) && doInt(int, int) && doIntOverflow(int, int) && doIntLargeIntegerTruncate(int, LargeInteger) && doLargeIntegerIntTruncate(LargeInteger, int) && doLargeIntegerTruncate(LargeInteger, LargeInteger) && doIntLargeInteger(int, LargeInteger) && doLargeIntegerInt(LargeInteger, int) && doLargeInteger(LargeInteger, LargeInteger) && doDouble(double, double) && doBigInt(BigInt, BigInt) && doString(CharSequence, CharSequence, JSConcatStringsNode) && doStringInt(CharSequence, int) && doIntString(int, CharSequence) && doStringNumber(CharSequence, Object, JSConcatStringsNode, JSDoubleToStringNode) && doNumberString(Object, CharSequence, JSConcatStringsNode, JSDoubleToStringNode) && doPrimitiveConversion(Object, Object, JSToPrimitiveNode, JSToPrimitiveNode, JSToNumericNode, JSToNumericNode, JSToStringNode, JSToStringNode, ConditionProfile, ConditionProfile, JSAddNode, BranchProfile) */) {
                executeDouble(frameValue);
                return;
            }
            execute(frameValue);
            return;
        } catch (UnexpectedResultException ex) {
            return;
        }
    }

    private Object executeAndSpecialize(Object leftNodeValue, Object rightNodeValue) {
        Lock lock = getLock();
        boolean hasLock = true;
        lock.lock();
        long state = state_;
        int exclude = exclude_;
        long oldState = (state & 0x1ffffL);
        int oldExclude = exclude;
        try {
            if (leftNodeValue instanceof Integer) {
                int leftNodeValue_ = (int) leftNodeValue;
                if (rightNodeValue instanceof Integer) {
                    int rightNodeValue_ = (int) rightNodeValue;
                    if (((exclude & 0b1)) == 0 /* is-not-excluded doIntTruncate(int, int) */) {
                        if ((truncate)) {
                            this.state_ = state = state | 0b1 /* add-active doIntTruncate(int, int) */;
                            lock.unlock();
                            hasLock = false;
                            return JSAddNode.doIntTruncate(leftNodeValue_, rightNodeValue_);
                        }
                    }
                    if (((exclude & 0b10)) == 0 /* is-not-excluded doInt(int, int) */) {
                        if ((!(truncate))) {
                            this.state_ = state = state | 0b10 /* add-active doInt(int, int) */;
                            try {
                                lock.unlock();
                                hasLock = false;
                                return JSAddNode.doInt(leftNodeValue_, rightNodeValue_);
                            } catch (ArithmeticException ex) {
                                // implicit transferToInterpreterAndInvalidate()
                                lock.lock();
                                try {
                                    this.exclude_ = this.exclude_ | 0b10 /* add-excluded doInt(int, int) */;
                                    this.state_ = this.state_ & 0xfffffffffffffffdL /* remove-active doInt(int, int) */;
                                } finally {
                                    lock.unlock();
                                }
                                return executeAndSpecialize(leftNodeValue_, rightNodeValue_);
                            }
                        }
                    }
                    if (((exclude & 0b100)) == 0 /* is-not-excluded doIntOverflow(int, int) */) {
                        if ((!(truncate))) {
                            this.state_ = state = state | 0b100 /* add-active doIntOverflow(int, int) */;
                            try {
                                lock.unlock();
                                hasLock = false;
                                return JSAddNode.doIntOverflow(leftNodeValue_, rightNodeValue_);
                            } catch (ArithmeticException ex) {
                                // implicit transferToInterpreterAndInvalidate()
                                lock.lock();
                                try {
                                    this.exclude_ = this.exclude_ | 0b100 /* add-excluded doIntOverflow(int, int) */;
                                    this.state_ = this.state_ & 0xfffffffffffffffbL /* remove-active doIntOverflow(int, int) */;
                                } finally {
                                    lock.unlock();
                                }
                                return executeAndSpecialize(leftNodeValue_, rightNodeValue_);
                            }
                        }
                    }
                }
                if (((exclude & 0b1000)) == 0 /* is-not-excluded doIntLargeIntegerTruncate(int, LargeInteger) */ && rightNodeValue instanceof LargeInteger) {
                    LargeInteger rightNodeValue_ = (LargeInteger) rightNodeValue;
                    if ((truncate)) {
                        this.state_ = state = state | 0b1000 /* add-active doIntLargeIntegerTruncate(int, LargeInteger) */;
                        lock.unlock();
                        hasLock = false;
                        return JSAddNode.doIntLargeIntegerTruncate(leftNodeValue_, rightNodeValue_);
                    }
                }
            }
            if (leftNodeValue instanceof LargeInteger) {
                LargeInteger leftNodeValue_ = (LargeInteger) leftNodeValue;
                if (((exclude & 0b10000)) == 0 /* is-not-excluded doLargeIntegerIntTruncate(LargeInteger, int) */ && rightNodeValue instanceof Integer) {
                    int rightNodeValue_ = (int) rightNodeValue;
                    if ((truncate)) {
                        this.state_ = state = state | 0b10000 /* add-active doLargeIntegerIntTruncate(LargeInteger, int) */;
                        lock.unlock();
                        hasLock = false;
                        return JSAddNode.doLargeIntegerIntTruncate(leftNodeValue_, rightNodeValue_);
                    }
                }
                if (((exclude & 0b100000)) == 0 /* is-not-excluded doLargeIntegerTruncate(LargeInteger, LargeInteger) */ && rightNodeValue instanceof LargeInteger) {
                    LargeInteger rightNodeValue_ = (LargeInteger) rightNodeValue;
                    if ((truncate)) {
                        this.state_ = state = state | 0b100000 /* add-active doLargeIntegerTruncate(LargeInteger, LargeInteger) */;
                        lock.unlock();
                        hasLock = false;
                        return JSAddNode.doLargeIntegerTruncate(leftNodeValue_, rightNodeValue_);
                    }
                }
            }
            if (((exclude & 0b1000000)) == 0 /* is-not-excluded doIntLargeInteger(int, LargeInteger) */ && leftNodeValue instanceof Integer) {
                int leftNodeValue_ = (int) leftNodeValue;
                if (rightNodeValue instanceof LargeInteger) {
                    LargeInteger rightNodeValue_ = (LargeInteger) rightNodeValue;
                    if ((!(truncate))) {
                        this.state_ = state = state | 0b1000000 /* add-active doIntLargeInteger(int, LargeInteger) */;
                        try {
                            lock.unlock();
                            hasLock = false;
                            return JSAddNode.doIntLargeInteger(leftNodeValue_, rightNodeValue_);
                        } catch (ArithmeticException ex) {
                            // implicit transferToInterpreterAndInvalidate()
                            lock.lock();
                            try {
                                this.exclude_ = this.exclude_ | 0b1000000 /* add-excluded doIntLargeInteger(int, LargeInteger) */;
                                this.state_ = this.state_ & 0xffffffffffffffbfL /* remove-active doIntLargeInteger(int, LargeInteger) */;
                            } finally {
                                lock.unlock();
                            }
                            return executeAndSpecialize(leftNodeValue_, rightNodeValue_);
                        }
                    }
                }
            }
            if (leftNodeValue instanceof LargeInteger) {
                LargeInteger leftNodeValue_ = (LargeInteger) leftNodeValue;
                if (((exclude & 0b10000000)) == 0 /* is-not-excluded doLargeIntegerInt(LargeInteger, int) */ && rightNodeValue instanceof Integer) {
                    int rightNodeValue_ = (int) rightNodeValue;
                    if ((!(truncate))) {
                        this.state_ = state = state | 0b10000000 /* add-active doLargeIntegerInt(LargeInteger, int) */;
                        try {
                            lock.unlock();
                            hasLock = false;
                            return JSAddNode.doLargeIntegerInt(leftNodeValue_, rightNodeValue_);
                        } catch (ArithmeticException ex) {
                            // implicit transferToInterpreterAndInvalidate()
                            lock.lock();
                            try {
                                this.exclude_ = this.exclude_ | 0b10000000 /* add-excluded doLargeIntegerInt(LargeInteger, int) */;
                                this.state_ = this.state_ & 0xffffffffffffff7fL /* remove-active doLargeIntegerInt(LargeInteger, int) */;
                            } finally {
                                lock.unlock();
                            }
                            return executeAndSpecialize(leftNodeValue_, rightNodeValue_);
                        }
                    }
                }
                if (((exclude & 0b100000000)) == 0 /* is-not-excluded doLargeInteger(LargeInteger, LargeInteger) */ && rightNodeValue instanceof LargeInteger) {
                    LargeInteger rightNodeValue_ = (LargeInteger) rightNodeValue;
                    if ((!(truncate))) {
                        this.state_ = state = state | 0b100000000 /* add-active doLargeInteger(LargeInteger, LargeInteger) */;
                        try {
                            lock.unlock();
                            hasLock = false;
                            return JSAddNode.doLargeInteger(leftNodeValue_, rightNodeValue_);
                        } catch (ArithmeticException ex) {
                            // implicit transferToInterpreterAndInvalidate()
                            lock.lock();
                            try {
                                this.exclude_ = this.exclude_ | 0b100000000 /* add-excluded doLargeInteger(LargeInteger, LargeInteger) */;
                                this.state_ = this.state_ & 0xfffffffffffffeffL /* remove-active doLargeInteger(LargeInteger, LargeInteger) */;
                            } finally {
                                lock.unlock();
                            }
                            return executeAndSpecialize(leftNodeValue_, rightNodeValue_);
                        }
                    }
                }
            }
            if (((exclude & 0b1000000000)) == 0 /* is-not-excluded doDouble(double, double) */) {
                int doubleCast0;
                if ((doubleCast0 = JSTypesGen.specializeImplicitDouble(leftNodeValue)) != 0) {
                    double leftNodeValue_ = JSTypesGen.asImplicitDouble(doubleCast0, leftNodeValue);
                    int doubleCast1;
                    if ((doubleCast1 = JSTypesGen.specializeImplicitDouble(rightNodeValue)) != 0) {
                        double rightNodeValue_ = JSTypesGen.asImplicitDouble(doubleCast1, rightNodeValue);
                        state = (state | ((long) doubleCast0 << 17) /* set-implicit-active 0:double */);
                        state = (state | ((long) doubleCast1 << 21) /* set-implicit-active 1:double */);
                        this.state_ = state = state | 0b1000000000 /* add-active doDouble(double, double) */;
                        lock.unlock();
                        hasLock = false;
                        return JSAddNode.doDouble(leftNodeValue_, rightNodeValue_);
                    }
                }
            }
            if (((exclude & 0b10000000000)) == 0 /* is-not-excluded doBigInt(BigInt, BigInt) */ && leftNodeValue instanceof BigInt) {
                BigInt leftNodeValue_ = (BigInt) leftNodeValue;
                if (rightNodeValue instanceof BigInt) {
                    BigInt rightNodeValue_ = (BigInt) rightNodeValue;
                    this.state_ = state = state | 0b10000000000 /* add-active doBigInt(BigInt, BigInt) */;
                    lock.unlock();
                    hasLock = false;
                    return doBigInt(leftNodeValue_, rightNodeValue_);
                }
            }
            {
                int charSequenceCast0;
                if ((charSequenceCast0 = JSTypesGen.specializeImplicitCharSequence(leftNodeValue)) != 0) {
                    CharSequence leftNodeValue_ = JSTypesGen.asImplicitCharSequence(charSequenceCast0, leftNodeValue);
                    if (((exclude & 0b100000000000)) == 0 /* is-not-excluded doString(CharSequence, CharSequence, JSConcatStringsNode) */) {
                        int charSequenceCast1;
                        if ((charSequenceCast1 = JSTypesGen.specializeImplicitCharSequence(rightNodeValue)) != 0) {
                            CharSequence rightNodeValue_ = JSTypesGen.asImplicitCharSequence(charSequenceCast1, rightNodeValue);
                            if (this.concatStringsNode == null) {
                                this.concatStringsNode = super.insert((JSConcatStringsNode.create()));
                            }
                            state = (state | ((long) charSequenceCast0 << 25) /* set-implicit-active 0:CharSequence */);
                            state = (state | ((long) charSequenceCast1 << 29) /* set-implicit-active 1:CharSequence */);
                            this.state_ = state = state | 0b100000000000 /* add-active doString(CharSequence, CharSequence, JSConcatStringsNode) */;
                            lock.unlock();
                            hasLock = false;
                            return doString(leftNodeValue_, rightNodeValue_, this.concatStringsNode);
                        }
                    }
                    if (((exclude & 0b1000000000000)) == 0 /* is-not-excluded doStringInt(CharSequence, int) */ && rightNodeValue instanceof Integer) {
                        int rightNodeValue_ = (int) rightNodeValue;
                        state = (state | ((long) charSequenceCast0 << 25) /* set-implicit-active 0:CharSequence */);
                        this.state_ = state = state | 0b1000000000000 /* add-active doStringInt(CharSequence, int) */;
                        lock.unlock();
                        hasLock = false;
                        return doStringInt(leftNodeValue_, rightNodeValue_);
                    }
                }
            }
            if (((exclude & 0b10000000000000)) == 0 /* is-not-excluded doIntString(int, CharSequence) */ && leftNodeValue instanceof Integer) {
                int leftNodeValue_ = (int) leftNodeValue;
                int charSequenceCast1;
                if ((charSequenceCast1 = JSTypesGen.specializeImplicitCharSequence(rightNodeValue)) != 0) {
                    CharSequence rightNodeValue_ = JSTypesGen.asImplicitCharSequence(charSequenceCast1, rightNodeValue);
                    state = (state | ((long) charSequenceCast1 << 29) /* set-implicit-active 1:CharSequence */);
                    this.state_ = state = state | 0b10000000000000 /* add-active doIntString(int, CharSequence) */;
                    lock.unlock();
                    hasLock = false;
                    return doIntString(leftNodeValue_, rightNodeValue_);
                }
            }
            if (((exclude & 0b100000000000000)) == 0 /* is-not-excluded doStringNumber(CharSequence, Object, JSConcatStringsNode, JSDoubleToStringNode) */) {
                int charSequenceCast0;
                if ((charSequenceCast0 = JSTypesGen.specializeImplicitCharSequence(leftNodeValue)) != 0) {
                    CharSequence leftNodeValue_ = JSTypesGen.asImplicitCharSequence(charSequenceCast0, leftNodeValue);
                    if ((JSGuards.isNumber(rightNodeValue))) {
                        if (this.concatStringsNode == null) {
                            this.concatStringsNode = super.insert((JSConcatStringsNode.create()));
                        }
                        if (this.doubleToStringNode == null) {
                            this.doubleToStringNode = super.insert((JSDoubleToStringNode.create()));
                        }
                        state = (state | ((long) charSequenceCast0 << 25) /* set-implicit-active 0:CharSequence */);
                        this.state_ = state = state | 0b100000000000000 /* add-active doStringNumber(CharSequence, Object, JSConcatStringsNode, JSDoubleToStringNode) */;
                        lock.unlock();
                        hasLock = false;
                        return doStringNumber(leftNodeValue_, rightNodeValue, this.concatStringsNode, this.doubleToStringNode);
                    }
                }
            }
            if (((exclude & 0b1000000000000000)) == 0 /* is-not-excluded doNumberString(Object, CharSequence, JSConcatStringsNode, JSDoubleToStringNode) */) {
                int charSequenceCast1;
                if ((charSequenceCast1 = JSTypesGen.specializeImplicitCharSequence(rightNodeValue)) != 0) {
                    CharSequence rightNodeValue_ = JSTypesGen.asImplicitCharSequence(charSequenceCast1, rightNodeValue);
                    if ((JSGuards.isNumber(leftNodeValue))) {
                        if (this.concatStringsNode == null) {
                            this.concatStringsNode = super.insert((JSConcatStringsNode.create()));
                        }
                        if (this.doubleToStringNode == null) {
                            this.doubleToStringNode = super.insert((JSDoubleToStringNode.create()));
                        }
                        state = (state | ((long) charSequenceCast1 << 29) /* set-implicit-active 1:CharSequence */);
                        this.state_ = state = state | 0b1000000000000000 /* add-active doNumberString(Object, CharSequence, JSConcatStringsNode, JSDoubleToStringNode) */;
                        lock.unlock();
                        hasLock = false;
                        return doNumberString(leftNodeValue, rightNodeValue_, this.concatStringsNode, this.doubleToStringNode);
                    }
                }
            }
            PrimitiveConversionData s17_ = super.insert(new PrimitiveConversionData());
            s17_.toPrimitiveA_ = s17_.insertAccessor((JSToPrimitiveNode.createHintNone()));
            s17_.toPrimitiveB_ = s17_.insertAccessor((JSToPrimitiveNode.createHintNone()));
            s17_.toNumericA_ = s17_.insertAccessor((JSToNumericNode.create()));
            s17_.toNumericB_ = s17_.insertAccessor((JSToNumericNode.create()));
            s17_.toStringA_ = s17_.insertAccessor((JSToStringNode.create()));
            s17_.toStringB_ = s17_.insertAccessor((JSToStringNode.create()));
            s17_.profileA_ = (ConditionProfile.createBinaryProfile());
            s17_.profileB_ = (ConditionProfile.createBinaryProfile());
            s17_.add_ = s17_.insertAccessor((copyRecursive()));
            s17_.mixedNumericTypes_ = (BranchProfile.create());
            this.primitiveConversion_cache = s17_;
            this.exclude_ = exclude = exclude | 0b1111111111111111 /* add-excluded doIntTruncate(int, int), doInt(int, int), doIntOverflow(int, int), doIntLargeIntegerTruncate(int, LargeInteger), doLargeIntegerIntTruncate(LargeInteger, int), doLargeIntegerTruncate(LargeInteger, LargeInteger), doIntLargeInteger(int, LargeInteger), doLargeIntegerInt(LargeInteger, int), doLargeInteger(LargeInteger, LargeInteger), doDouble(double, double), doBigInt(BigInt, BigInt), doString(CharSequence, CharSequence, JSConcatStringsNode), doStringInt(CharSequence, int), doIntString(int, CharSequence), doStringNumber(CharSequence, Object, JSConcatStringsNode, JSDoubleToStringNode), doNumberString(Object, CharSequence, JSConcatStringsNode, JSDoubleToStringNode) */;
            state = state & 0xffffffffffff0000L /* remove-active doIntTruncate(int, int), doInt(int, int), doIntOverflow(int, int), doIntLargeIntegerTruncate(int, LargeInteger), doLargeIntegerIntTruncate(LargeInteger, int), doLargeIntegerTruncate(LargeInteger, LargeInteger), doIntLargeInteger(int, LargeInteger), doLargeIntegerInt(LargeInteger, int), doLargeInteger(LargeInteger, LargeInteger), doDouble(double, double), doBigInt(BigInt, BigInt), doString(CharSequence, CharSequence, JSConcatStringsNode), doStringInt(CharSequence, int), doIntString(int, CharSequence), doStringNumber(CharSequence, Object, JSConcatStringsNode, JSDoubleToStringNode), doNumberString(Object, CharSequence, JSConcatStringsNode, JSDoubleToStringNode) */;
            this.state_ = state = state | 0x10000L /* add-active doPrimitiveConversion(Object, Object, JSToPrimitiveNode, JSToPrimitiveNode, JSToNumericNode, JSToNumericNode, JSToStringNode, JSToStringNode, ConditionProfile, ConditionProfile, JSAddNode, BranchProfile) */;
            lock.unlock();
            hasLock = false;
            return doPrimitiveConversion(leftNodeValue, rightNodeValue, s17_.toPrimitiveA_, s17_.toPrimitiveB_, s17_.toNumericA_, s17_.toNumericB_, s17_.toStringA_, s17_.toStringB_, s17_.profileA_, s17_.profileB_, s17_.add_, s17_.mixedNumericTypes_);
        } finally {
            if (oldState != 0 || oldExclude != 0) {
                checkForPolymorphicSpecialize(oldState, oldExclude);
            }
            if (hasLock) {
                lock.unlock();
            }
        }
    }

    private void checkForPolymorphicSpecialize(long oldState, int oldExclude) {
        long newState = (this.state_ & 0x1ffffL);
        int newExclude = this.exclude_;
        if ((oldState ^ newState) != 0 || (oldExclude ^ newExclude) != 0) {
            this.reportPolymorphicSpecialize();
        }
    }

    @Override
    public NodeCost getCost() {
        long state = state_;
        if ((state & 0x1ffffL) == 0b0) {
            return NodeCost.UNINITIALIZED;
        } else if (((state & 0x1ffffL) & ((state & 0x1ffffL) - 1)) == 0 /* is-single-active  */) {
            return NodeCost.MONOMORPHIC;
        }
        return NodeCost.POLYMORPHIC;
    }

    @Override
    public Introspection getIntrospectionData() {
        Object[] data = new Object[18];
        Object[] s;
        data[0] = 0;
        long state = state_;
        int exclude = exclude_;
        s = new Object[3];
        s[0] = "doIntTruncate";
        if ((state & 0b1) != 0 /* is-active doIntTruncate(int, int) */) {
            s[1] = (byte)0b01 /* active */;
        } else if ((exclude & 0b1) != 0 /* is-excluded doIntTruncate(int, int) */) {
            s[1] = (byte)0b10 /* excluded */;
        } else {
            s[1] = (byte)0b00 /* inactive */;
        }
        data[1] = s;
        s = new Object[3];
        s[0] = "doInt";
        if ((state & 0b10) != 0 /* is-active doInt(int, int) */) {
            s[1] = (byte)0b01 /* active */;
        } else if ((exclude & 0b10) != 0 /* is-excluded doInt(int, int) */) {
            s[1] = (byte)0b10 /* excluded */;
        } else {
            s[1] = (byte)0b00 /* inactive */;
        }
        data[2] = s;
        s = new Object[3];
        s[0] = "doIntOverflow";
        if ((state & 0b100) != 0 /* is-active doIntOverflow(int, int) */) {
            s[1] = (byte)0b01 /* active */;
        } else if ((exclude & 0b100) != 0 /* is-excluded doIntOverflow(int, int) */) {
            s[1] = (byte)0b10 /* excluded */;
        } else {
            s[1] = (byte)0b00 /* inactive */;
        }
        data[3] = s;
        s = new Object[3];
        s[0] = "doIntLargeIntegerTruncate";
        if ((state & 0b1000) != 0 /* is-active doIntLargeIntegerTruncate(int, LargeInteger) */) {
            s[1] = (byte)0b01 /* active */;
        } else if ((exclude & 0b1000) != 0 /* is-excluded doIntLargeIntegerTruncate(int, LargeInteger) */) {
            s[1] = (byte)0b10 /* excluded */;
        } else {
            s[1] = (byte)0b00 /* inactive */;
        }
        data[4] = s;
        s = new Object[3];
        s[0] = "doLargeIntegerIntTruncate";
        if ((state & 0b10000) != 0 /* is-active doLargeIntegerIntTruncate(LargeInteger, int) */) {
            s[1] = (byte)0b01 /* active */;
        } else if ((exclude & 0b10000) != 0 /* is-excluded doLargeIntegerIntTruncate(LargeInteger, int) */) {
            s[1] = (byte)0b10 /* excluded */;
        } else {
            s[1] = (byte)0b00 /* inactive */;
        }
        data[5] = s;
        s = new Object[3];
        s[0] = "doLargeIntegerTruncate";
        if ((state & 0b100000) != 0 /* is-active doLargeIntegerTruncate(LargeInteger, LargeInteger) */) {
            s[1] = (byte)0b01 /* active */;
        } else if ((exclude & 0b100000) != 0 /* is-excluded doLargeIntegerTruncate(LargeInteger, LargeInteger) */) {
            s[1] = (byte)0b10 /* excluded */;
        } else {
            s[1] = (byte)0b00 /* inactive */;
        }
        data[6] = s;
        s = new Object[3];
        s[0] = "doIntLargeInteger";
        if ((state & 0b1000000) != 0 /* is-active doIntLargeInteger(int, LargeInteger) */) {
            s[1] = (byte)0b01 /* active */;
        } else if ((exclude & 0b1000000) != 0 /* is-excluded doIntLargeInteger(int, LargeInteger) */) {
            s[1] = (byte)0b10 /* excluded */;
        } else {
            s[1] = (byte)0b00 /* inactive */;
        }
        data[7] = s;
        s = new Object[3];
        s[0] = "doLargeIntegerInt";
        if ((state & 0b10000000) != 0 /* is-active doLargeIntegerInt(LargeInteger, int) */) {
            s[1] = (byte)0b01 /* active */;
        } else if ((exclude & 0b10000000) != 0 /* is-excluded doLargeIntegerInt(LargeInteger, int) */) {
            s[1] = (byte)0b10 /* excluded */;
        } else {
            s[1] = (byte)0b00 /* inactive */;
        }
        data[8] = s;
        s = new Object[3];
        s[0] = "doLargeInteger";
        if ((state & 0b100000000) != 0 /* is-active doLargeInteger(LargeInteger, LargeInteger) */) {
            s[1] = (byte)0b01 /* active */;
        } else if ((exclude & 0b100000000) != 0 /* is-excluded doLargeInteger(LargeInteger, LargeInteger) */) {
            s[1] = (byte)0b10 /* excluded */;
        } else {
            s[1] = (byte)0b00 /* inactive */;
        }
        data[9] = s;
        s = new Object[3];
        s[0] = "doDouble";
        if ((state & 0b1000000000) != 0 /* is-active doDouble(double, double) */) {
            s[1] = (byte)0b01 /* active */;
        } else if ((exclude & 0b1000000000) != 0 /* is-excluded doDouble(double, double) */) {
            s[1] = (byte)0b10 /* excluded */;
        } else {
            s[1] = (byte)0b00 /* inactive */;
        }
        data[10] = s;
        s = new Object[3];
        s[0] = "doBigInt";
        if ((state & 0b10000000000) != 0 /* is-active doBigInt(BigInt, BigInt) */) {
            s[1] = (byte)0b01 /* active */;
        } else if ((exclude & 0b10000000000) != 0 /* is-excluded doBigInt(BigInt, BigInt) */) {
            s[1] = (byte)0b10 /* excluded */;
        } else {
            s[1] = (byte)0b00 /* inactive */;
        }
        data[11] = s;
        s = new Object[3];
        s[0] = "doString";
        if ((state & 0b100000000000) != 0 /* is-active doString(CharSequence, CharSequence, JSConcatStringsNode) */) {
            s[1] = (byte)0b01 /* active */;
            ArrayList<Object> cached = new ArrayList<>();
            cached.add(Arrays.asList(this.concatStringsNode));
            s[2] = cached;
        } else if ((exclude & 0b100000000000) != 0 /* is-excluded doString(CharSequence, CharSequence, JSConcatStringsNode) */) {
            s[1] = (byte)0b10 /* excluded */;
        } else {
            s[1] = (byte)0b00 /* inactive */;
        }
        data[12] = s;
        s = new Object[3];
        s[0] = "doStringInt";
        if ((state & 0b1000000000000) != 0 /* is-active doStringInt(CharSequence, int) */) {
            s[1] = (byte)0b01 /* active */;
        } else if ((exclude & 0b1000000000000) != 0 /* is-excluded doStringInt(CharSequence, int) */) {
            s[1] = (byte)0b10 /* excluded */;
        } else {
            s[1] = (byte)0b00 /* inactive */;
        }
        data[13] = s;
        s = new Object[3];
        s[0] = "doIntString";
        if ((state & 0b10000000000000) != 0 /* is-active doIntString(int, CharSequence) */) {
            s[1] = (byte)0b01 /* active */;
        } else if ((exclude & 0b10000000000000) != 0 /* is-excluded doIntString(int, CharSequence) */) {
            s[1] = (byte)0b10 /* excluded */;
        } else {
            s[1] = (byte)0b00 /* inactive */;
        }
        data[14] = s;
        s = new Object[3];
        s[0] = "doStringNumber";
        if ((state & 0b100000000000000) != 0 /* is-active doStringNumber(CharSequence, Object, JSConcatStringsNode, JSDoubleToStringNode) */) {
            s[1] = (byte)0b01 /* active */;
            ArrayList<Object> cached = new ArrayList<>();
            cached.add(Arrays.asList(this.concatStringsNode, this.doubleToStringNode));
            s[2] = cached;
        } else if ((exclude & 0b100000000000000) != 0 /* is-excluded doStringNumber(CharSequence, Object, JSConcatStringsNode, JSDoubleToStringNode) */) {
            s[1] = (byte)0b10 /* excluded */;
        } else {
            s[1] = (byte)0b00 /* inactive */;
        }
        data[15] = s;
        s = new Object[3];
        s[0] = "doNumberString";
        if ((state & 0b1000000000000000) != 0 /* is-active doNumberString(Object, CharSequence, JSConcatStringsNode, JSDoubleToStringNode) */) {
            s[1] = (byte)0b01 /* active */;
            ArrayList<Object> cached = new ArrayList<>();
            cached.add(Arrays.asList(this.concatStringsNode, this.doubleToStringNode));
            s[2] = cached;
        } else if ((exclude & 0b1000000000000000) != 0 /* is-excluded doNumberString(Object, CharSequence, JSConcatStringsNode, JSDoubleToStringNode) */) {
            s[1] = (byte)0b10 /* excluded */;
        } else {
            s[1] = (byte)0b00 /* inactive */;
        }
        data[16] = s;
        s = new Object[3];
        s[0] = "doPrimitiveConversion";
        if ((state & 0x10000L) != 0 /* is-active doPrimitiveConversion(Object, Object, JSToPrimitiveNode, JSToPrimitiveNode, JSToNumericNode, JSToNumericNode, JSToStringNode, JSToStringNode, ConditionProfile, ConditionProfile, JSAddNode, BranchProfile) */) {
            s[1] = (byte)0b01 /* active */;
            ArrayList<Object> cached = new ArrayList<>();
            PrimitiveConversionData s17_ = this.primitiveConversion_cache;
            if (s17_ != null) {
                cached.add(Arrays.asList(s17_.toPrimitiveA_, s17_.toPrimitiveB_, s17_.toNumericA_, s17_.toNumericB_, s17_.toStringA_, s17_.toStringB_, s17_.profileA_, s17_.profileB_, s17_.add_, s17_.mixedNumericTypes_));
            }
            s[2] = cached;
        } else {
            s[1] = (byte)0b00 /* inactive */;
        }
        data[17] = s;
        return Provider.create(data);
    }

    public static JSAddNode create(boolean truncate, JavaScriptNode left, JavaScriptNode right) {
        return new JSAddNodeGen(truncate, left, right);
    }

    @GeneratedBy(JSAddNode.class)
    private static final class PrimitiveConversionData extends Node {

        @Child JSToPrimitiveNode toPrimitiveA_;
        @Child JSToPrimitiveNode toPrimitiveB_;
        @Child JSToNumericNode toNumericA_;
        @Child JSToNumericNode toNumericB_;
        @Child JSToStringNode toStringA_;
        @Child JSToStringNode toStringB_;
        @CompilationFinal ConditionProfile profileA_;
        @CompilationFinal ConditionProfile profileB_;
        @Child JSAddNode add_;
        @CompilationFinal BranchProfile mixedNumericTypes_;

        PrimitiveConversionData() {
        }

        @Override
        public NodeCost getCost() {
            return NodeCost.NONE;
        }

        <T extends Node> T insertAccessor(T node) {
            return super.insert(node);
        }

    }
}
