// CheckStyle: start generated
package com.oracle.truffle.js.nodes.binary;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.CompilerDirectives.CompilationFinal;
import com.oracle.truffle.api.dsl.GeneratedBy;
import com.oracle.truffle.api.dsl.Introspection;
import com.oracle.truffle.api.dsl.UnsupportedSpecializationException;
import com.oracle.truffle.api.dsl.Introspection.Provider;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.nodes.ExplodeLoop;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.nodes.NodeCost;
import com.oracle.truffle.api.object.DynamicObject;
import com.oracle.truffle.api.object.Shape;
import com.oracle.truffle.api.profiles.BranchProfile;
import com.oracle.truffle.api.profiles.ConditionProfile;
import com.oracle.truffle.js.nodes.JSGuards;
import com.oracle.truffle.js.nodes.JSTypes;
import com.oracle.truffle.js.nodes.JavaScriptNode;
import com.oracle.truffle.js.nodes.access.GetMethodNode;
import com.oracle.truffle.js.nodes.access.GetPrototypeNode;
import com.oracle.truffle.js.nodes.access.IsJSObjectNode;
import com.oracle.truffle.js.nodes.binary.InstanceofNode;
import com.oracle.truffle.js.nodes.cast.JSToBooleanNode;
import com.oracle.truffle.js.nodes.function.JSFunctionCallNode;
import com.oracle.truffle.js.runtime.JSContext;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.concurrent.locks.Lock;

@GeneratedBy(InstanceofNode.class)
public final class InstanceofNodeGen extends InstanceofNode implements Provider {

    @CompilationFinal private int state_;
    @Child private GenericData generic_cache;

    private InstanceofNodeGen(JSContext context, JavaScriptNode left, JavaScriptNode right) {
        super(context, left, right);
    }

    @Override
    public boolean executeBoolean(Object leftNodeValue, Object rightNodeValue) {
        int state = state_;
        if (state != 0 /* is-active doGeneric(Object, DynamicObject, IsJSObjectNode, GetMethodNode, JSToBooleanNode, JSFunctionCallNode, ConditionProfile, BranchProfile, BranchProfile) || instanceofJavaClass(Object, Object) || instanceofJavaClassUnwrap(Object, Object) || doRHSNotAnObject(Object, Object) */) {
            if ((state & 0b1) != 0 /* is-active doGeneric(Object, DynamicObject, IsJSObjectNode, GetMethodNode, JSToBooleanNode, JSFunctionCallNode, ConditionProfile, BranchProfile, BranchProfile) */ && JSTypes.isDynamicObject(rightNodeValue)) {
                DynamicObject rightNodeValue_ = (DynamicObject) rightNodeValue;
                GenericData s1_ = this.generic_cache;
                if (s1_ != null) {
                    return doGeneric(leftNodeValue, rightNodeValue_, s1_.isObjectNode_, s1_.getMethodHasInstanceNode_, s1_.toBooleanNode_, s1_.callHasInstanceNode_, s1_.hasInstanceProfile_, s1_.errorBranch_, s1_.proxyBranch_);
                }
            }
            if ((state & 0b1110) != 0 /* is-active instanceofJavaClass(Object, Object) || instanceofJavaClassUnwrap(Object, Object) || doRHSNotAnObject(Object, Object) */) {
                if ((state & 0b10) != 0 /* is-active instanceofJavaClass(Object, Object) */) {
                    if ((!(isJavaObject(leftNodeValue))) && (isJavaInteropClass(rightNodeValue))) {
                        return instanceofJavaClass(leftNodeValue, rightNodeValue);
                    }
                }
                if ((state & 0b100) != 0 /* is-active instanceofJavaClassUnwrap(Object, Object) */) {
                    if ((isJavaObject(leftNodeValue)) && (isJavaInteropClass(rightNodeValue))) {
                        return instanceofJavaClassUnwrap(leftNodeValue, rightNodeValue);
                    }
                }
                if ((state & 0b1000) != 0 /* is-active doRHSNotAnObject(Object, Object) */) {
                    if ((!(JSGuards.isDynamicObject(rightNodeValue)))) {
                        return doRHSNotAnObject(leftNodeValue, rightNodeValue);
                    }
                }
            }
        }
        CompilerDirectives.transferToInterpreterAndInvalidate();
        return executeAndSpecialize(leftNodeValue, rightNodeValue);
    }

    @Override
    public Object execute(VirtualFrame frameValue) {
        int state = state_;
        Object leftNodeValue_ = super.leftNode.execute(frameValue);
        Object rightNodeValue_ = super.rightNode.execute(frameValue);
        if (state != 0 /* is-active doGeneric(Object, DynamicObject, IsJSObjectNode, GetMethodNode, JSToBooleanNode, JSFunctionCallNode, ConditionProfile, BranchProfile, BranchProfile) || instanceofJavaClass(Object, Object) || instanceofJavaClassUnwrap(Object, Object) || doRHSNotAnObject(Object, Object) */) {
            if ((state & 0b1) != 0 /* is-active doGeneric(Object, DynamicObject, IsJSObjectNode, GetMethodNode, JSToBooleanNode, JSFunctionCallNode, ConditionProfile, BranchProfile, BranchProfile) */ && JSTypes.isDynamicObject(rightNodeValue_)) {
                DynamicObject rightNodeValue__ = (DynamicObject) rightNodeValue_;
                GenericData s1_ = this.generic_cache;
                if (s1_ != null) {
                    return doGeneric(leftNodeValue_, rightNodeValue__, s1_.isObjectNode_, s1_.getMethodHasInstanceNode_, s1_.toBooleanNode_, s1_.callHasInstanceNode_, s1_.hasInstanceProfile_, s1_.errorBranch_, s1_.proxyBranch_);
                }
            }
            if ((state & 0b1110) != 0 /* is-active instanceofJavaClass(Object, Object) || instanceofJavaClassUnwrap(Object, Object) || doRHSNotAnObject(Object, Object) */) {
                if ((state & 0b10) != 0 /* is-active instanceofJavaClass(Object, Object) */) {
                    if ((!(isJavaObject(leftNodeValue_))) && (isJavaInteropClass(rightNodeValue_))) {
                        return instanceofJavaClass(leftNodeValue_, rightNodeValue_);
                    }
                }
                if ((state & 0b100) != 0 /* is-active instanceofJavaClassUnwrap(Object, Object) */) {
                    if ((isJavaObject(leftNodeValue_)) && (isJavaInteropClass(rightNodeValue_))) {
                        return instanceofJavaClassUnwrap(leftNodeValue_, rightNodeValue_);
                    }
                }
                if ((state & 0b1000) != 0 /* is-active doRHSNotAnObject(Object, Object) */) {
                    if ((!(JSGuards.isDynamicObject(rightNodeValue_)))) {
                        return doRHSNotAnObject(leftNodeValue_, rightNodeValue_);
                    }
                }
            }
        }
        CompilerDirectives.transferToInterpreterAndInvalidate();
        return executeAndSpecialize(leftNodeValue_, rightNodeValue_);
    }

    @Override
    public boolean executeBoolean(VirtualFrame frameValue) {
        int state = state_;
        Object leftNodeValue_ = super.leftNode.execute(frameValue);
        Object rightNodeValue_ = super.rightNode.execute(frameValue);
        if (state != 0 /* is-active doGeneric(Object, DynamicObject, IsJSObjectNode, GetMethodNode, JSToBooleanNode, JSFunctionCallNode, ConditionProfile, BranchProfile, BranchProfile) || instanceofJavaClass(Object, Object) || instanceofJavaClassUnwrap(Object, Object) || doRHSNotAnObject(Object, Object) */) {
            if ((state & 0b1) != 0 /* is-active doGeneric(Object, DynamicObject, IsJSObjectNode, GetMethodNode, JSToBooleanNode, JSFunctionCallNode, ConditionProfile, BranchProfile, BranchProfile) */ && JSTypes.isDynamicObject(rightNodeValue_)) {
                DynamicObject rightNodeValue__ = (DynamicObject) rightNodeValue_;
                GenericData s1_ = this.generic_cache;
                if (s1_ != null) {
                    return doGeneric(leftNodeValue_, rightNodeValue__, s1_.isObjectNode_, s1_.getMethodHasInstanceNode_, s1_.toBooleanNode_, s1_.callHasInstanceNode_, s1_.hasInstanceProfile_, s1_.errorBranch_, s1_.proxyBranch_);
                }
            }
            if ((state & 0b1110) != 0 /* is-active instanceofJavaClass(Object, Object) || instanceofJavaClassUnwrap(Object, Object) || doRHSNotAnObject(Object, Object) */) {
                if ((state & 0b10) != 0 /* is-active instanceofJavaClass(Object, Object) */) {
                    if ((!(isJavaObject(leftNodeValue_))) && (isJavaInteropClass(rightNodeValue_))) {
                        return instanceofJavaClass(leftNodeValue_, rightNodeValue_);
                    }
                }
                if ((state & 0b100) != 0 /* is-active instanceofJavaClassUnwrap(Object, Object) */) {
                    if ((isJavaObject(leftNodeValue_)) && (isJavaInteropClass(rightNodeValue_))) {
                        return instanceofJavaClassUnwrap(leftNodeValue_, rightNodeValue_);
                    }
                }
                if ((state & 0b1000) != 0 /* is-active doRHSNotAnObject(Object, Object) */) {
                    if ((!(JSGuards.isDynamicObject(rightNodeValue_)))) {
                        return doRHSNotAnObject(leftNodeValue_, rightNodeValue_);
                    }
                }
            }
        }
        CompilerDirectives.transferToInterpreterAndInvalidate();
        return executeAndSpecialize(leftNodeValue_, rightNodeValue_);
    }

    @Override
    public void executeVoid(VirtualFrame frameValue) {
        executeBoolean(frameValue);
        return;
    }

    private boolean executeAndSpecialize(Object leftNodeValue, Object rightNodeValue) {
        Lock lock = getLock();
        boolean hasLock = true;
        lock.lock();
        int state = state_;
        try {
            if (JSTypes.isDynamicObject(rightNodeValue)) {
                DynamicObject rightNodeValue_ = (DynamicObject) rightNodeValue;
                GenericData s1_ = super.insert(new GenericData());
                s1_.isObjectNode_ = s1_.insertAccessor((IsJSObjectNode.create()));
                s1_.getMethodHasInstanceNode_ = s1_.insertAccessor((createGetMethodHasInstance()));
                s1_.toBooleanNode_ = s1_.insertAccessor((JSToBooleanNode.create()));
                s1_.callHasInstanceNode_ = s1_.insertAccessor((JSFunctionCallNode.createCall()));
                s1_.hasInstanceProfile_ = (ConditionProfile.createBinaryProfile());
                s1_.errorBranch_ = (BranchProfile.create());
                s1_.proxyBranch_ = (BranchProfile.create());
                this.generic_cache = s1_;
                this.state_ = state = state | 0b1 /* add-active doGeneric(Object, DynamicObject, IsJSObjectNode, GetMethodNode, JSToBooleanNode, JSFunctionCallNode, ConditionProfile, BranchProfile, BranchProfile) */;
                lock.unlock();
                hasLock = false;
                return doGeneric(leftNodeValue, rightNodeValue_, s1_.isObjectNode_, s1_.getMethodHasInstanceNode_, s1_.toBooleanNode_, s1_.callHasInstanceNode_, s1_.hasInstanceProfile_, s1_.errorBranch_, s1_.proxyBranch_);
            }
            if ((!(isJavaObject(leftNodeValue))) && (isJavaInteropClass(rightNodeValue))) {
                this.state_ = state = state | 0b10 /* add-active instanceofJavaClass(Object, Object) */;
                lock.unlock();
                hasLock = false;
                return instanceofJavaClass(leftNodeValue, rightNodeValue);
            }
            if ((isJavaObject(leftNodeValue)) && (isJavaInteropClass(rightNodeValue))) {
                this.state_ = state = state | 0b100 /* add-active instanceofJavaClassUnwrap(Object, Object) */;
                lock.unlock();
                hasLock = false;
                return instanceofJavaClassUnwrap(leftNodeValue, rightNodeValue);
            }
            if ((!(JSGuards.isDynamicObject(rightNodeValue)))) {
                this.state_ = state = state | 0b1000 /* add-active doRHSNotAnObject(Object, Object) */;
                lock.unlock();
                hasLock = false;
                return doRHSNotAnObject(leftNodeValue, rightNodeValue);
            }
            throw new UnsupportedSpecializationException(this, new Node[] {super.leftNode, super.rightNode}, leftNodeValue, rightNodeValue);
        } finally {
            if (hasLock) {
                lock.unlock();
            }
        }
    }

    @Override
    public NodeCost getCost() {
        int state = state_;
        if (state == 0b0) {
            return NodeCost.UNINITIALIZED;
        } else if ((state & (state - 1)) == 0 /* is-single-active  */) {
            return NodeCost.MONOMORPHIC;
        }
        return NodeCost.POLYMORPHIC;
    }

    @Override
    public Introspection getIntrospectionData() {
        Object[] data = new Object[5];
        Object[] s;
        data[0] = 0;
        int state = state_;
        s = new Object[3];
        s[0] = "doGeneric";
        if ((state & 0b1) != 0 /* is-active doGeneric(Object, DynamicObject, IsJSObjectNode, GetMethodNode, JSToBooleanNode, JSFunctionCallNode, ConditionProfile, BranchProfile, BranchProfile) */) {
            s[1] = (byte)0b01 /* active */;
            ArrayList<Object> cached = new ArrayList<>();
            GenericData s1_ = this.generic_cache;
            if (s1_ != null) {
                cached.add(Arrays.asList(s1_.isObjectNode_, s1_.getMethodHasInstanceNode_, s1_.toBooleanNode_, s1_.callHasInstanceNode_, s1_.hasInstanceProfile_, s1_.errorBranch_, s1_.proxyBranch_));
            }
            s[2] = cached;
        } else {
            s[1] = (byte)0b00 /* inactive */;
        }
        data[1] = s;
        s = new Object[3];
        s[0] = "instanceofJavaClass";
        if ((state & 0b10) != 0 /* is-active instanceofJavaClass(Object, Object) */) {
            s[1] = (byte)0b01 /* active */;
        } else {
            s[1] = (byte)0b00 /* inactive */;
        }
        data[2] = s;
        s = new Object[3];
        s[0] = "instanceofJavaClassUnwrap";
        if ((state & 0b100) != 0 /* is-active instanceofJavaClassUnwrap(Object, Object) */) {
            s[1] = (byte)0b01 /* active */;
        } else {
            s[1] = (byte)0b00 /* inactive */;
        }
        data[3] = s;
        s = new Object[3];
        s[0] = "doRHSNotAnObject";
        if ((state & 0b1000) != 0 /* is-active doRHSNotAnObject(Object, Object) */) {
            s[1] = (byte)0b01 /* active */;
        } else {
            s[1] = (byte)0b00 /* inactive */;
        }
        data[4] = s;
        return Provider.create(data);
    }

    public static InstanceofNode create(JSContext context, JavaScriptNode left, JavaScriptNode right) {
        return new InstanceofNodeGen(context, left, right);
    }

    @GeneratedBy(InstanceofNode.class)
    private static final class GenericData extends Node {

        @Child IsJSObjectNode isObjectNode_;
        @Child GetMethodNode getMethodHasInstanceNode_;
        @Child JSToBooleanNode toBooleanNode_;
        @Child JSFunctionCallNode callHasInstanceNode_;
        @CompilationFinal ConditionProfile hasInstanceProfile_;
        @CompilationFinal BranchProfile errorBranch_;
        @CompilationFinal BranchProfile proxyBranch_;

        GenericData() {
        }

        @Override
        public NodeCost getCost() {
            return NodeCost.NONE;
        }

        <T extends Node> T insertAccessor(T node) {
            return super.insert(node);
        }

    }
    @GeneratedBy(OrdinaryHasInstanceNode.class)
    public static final class OrdinaryHasInstanceNodeGen extends OrdinaryHasInstanceNode implements Provider {

        @CompilationFinal private int state_;
        @Child private InstanceofNode isBound_instanceofNode_;
        @Child private JSObjectData jSObject_cache;
        @Child private JSObjectProxyData jSObjectProxy_cache;

        private OrdinaryHasInstanceNodeGen(JSContext context) {
            super(context);
        }

        @Override
        public boolean executeBoolean(Object arg0Value, Object arg1Value) {
            int state = state_;
            if ((state & 0b1111) != 0 /* is-active doNotCallable(Object, Object) || doIsBound(Object, DynamicObject, InstanceofNode) || doNotAnObject(Object, DynamicObject) || doNotAnObjectProxy(Object, DynamicObject) */) {
                if ((state & 0b1) != 0 /* is-active doNotCallable(Object, Object) */) {
                    if ((!(JSGuards.isCallable(arg1Value)))) {
                        return doNotCallable(arg0Value, arg1Value);
                    }
                }
                if ((state & 0b1110) != 0 /* is-active doIsBound(Object, DynamicObject, InstanceofNode) || doNotAnObject(Object, DynamicObject) || doNotAnObjectProxy(Object, DynamicObject) */ && JSTypes.isDynamicObject(arg1Value)) {
                    DynamicObject arg1Value_ = (DynamicObject) arg1Value;
                    if ((state & 0b10) != 0 /* is-active doIsBound(Object, DynamicObject, InstanceofNode) */) {
                        if ((JSGuards.isJSFunction(arg1Value_)) && (isBoundFunction(arg1Value_))) {
                            return doIsBound(arg0Value, arg1Value_, this.isBound_instanceofNode_);
                        }
                    }
                    if ((state & 0b100) != 0 /* is-active doNotAnObject(Object, DynamicObject) */) {
                        if ((!(JSGuards.isJSObject(arg0Value))) && (JSGuards.isJSFunction(arg1Value_)) && (!(isBoundFunction(arg1Value_)))) {
                            return doNotAnObject(arg0Value, arg1Value_);
                        }
                    }
                    if ((state & 0b1000) != 0 /* is-active doNotAnObjectProxy(Object, DynamicObject) */) {
                        if ((!(JSGuards.isJSObject(arg0Value))) && (JSGuards.isJSProxy(arg1Value_)) && (JSGuards.isCallableProxy(arg1Value_))) {
                            return doNotAnObjectProxy(arg0Value, arg1Value_);
                        }
                    }
                }
            }
            if ((state & 0b110000) != 0 /* is-active doJSObject(DynamicObject, DynamicObject, GetPrototypeNode, GetPrototypeNode, GetPrototypeNode, BranchProfile, BranchProfile, BranchProfile, BranchProfile, BranchProfile, BranchProfile) || doJSObjectProxy(DynamicObject, DynamicObject, GetPrototypeNode, GetPrototypeNode, GetPrototypeNode, BranchProfile, BranchProfile, BranchProfile, BranchProfile, BranchProfile, BranchProfile) */ && JSTypes.isDynamicObject(arg0Value)) {
                DynamicObject arg0Value_ = (DynamicObject) arg0Value;
                if (JSTypes.isDynamicObject(arg1Value)) {
                    DynamicObject arg1Value_ = (DynamicObject) arg1Value;
                    if ((state & 0b10000) != 0 /* is-active doJSObject(DynamicObject, DynamicObject, GetPrototypeNode, GetPrototypeNode, GetPrototypeNode, BranchProfile, BranchProfile, BranchProfile, BranchProfile, BranchProfile, BranchProfile) */) {
                        JSObjectData s5_ = this.jSObject_cache;
                        if (s5_ != null) {
                            if ((isObjectLocal(arg0Value_)) && (JSGuards.isJSFunction(arg1Value_)) && (!(isBoundFunction(arg1Value_)))) {
                                return doJSObject(arg0Value_, arg1Value_, s5_.getPrototype1Node_, s5_.getPrototype2Node_, s5_.getPrototype3Node_, s5_.firstTrue_, s5_.firstFalse_, s5_.need2Hops_, s5_.need3Hops_, s5_.errorBranch_, s5_.invalidPrototypeBranch_);
                            }
                        }
                    }
                    if ((state & 0b100000) != 0 /* is-active doJSObjectProxy(DynamicObject, DynamicObject, GetPrototypeNode, GetPrototypeNode, GetPrototypeNode, BranchProfile, BranchProfile, BranchProfile, BranchProfile, BranchProfile, BranchProfile) */) {
                        JSObjectProxyData s6_ = this.jSObjectProxy_cache;
                        if (s6_ != null) {
                            if ((isObjectLocal(arg0Value_)) && (JSGuards.isJSProxy(arg1Value_)) && (JSGuards.isCallableProxy(arg1Value_))) {
                                return doJSObjectProxy(arg0Value_, arg1Value_, s6_.getPrototype1Node_, s6_.getPrototype2Node_, s6_.getPrototype3Node_, s6_.firstTrue_, s6_.firstFalse_, s6_.need2Hops_, s6_.need3Hops_, s6_.errorBranch_, s6_.invalidPrototypeBranch_);
                            }
                        }
                    }
                }
            }
            CompilerDirectives.transferToInterpreterAndInvalidate();
            return executeAndSpecialize(arg0Value, arg1Value);
        }

        private boolean executeAndSpecialize(Object arg0Value, Object arg1Value) {
            Lock lock = getLock();
            boolean hasLock = true;
            lock.lock();
            int state = state_;
            try {
                if ((!(JSGuards.isCallable(arg1Value)))) {
                    this.state_ = state = state | 0b1 /* add-active doNotCallable(Object, Object) */;
                    lock.unlock();
                    hasLock = false;
                    return doNotCallable(arg0Value, arg1Value);
                }
                if (JSTypes.isDynamicObject(arg1Value)) {
                    DynamicObject arg1Value_ = (DynamicObject) arg1Value;
                    if ((JSGuards.isJSFunction(arg1Value_)) && (isBoundFunction(arg1Value_))) {
                        this.isBound_instanceofNode_ = super.insert((InstanceofNode.create(context)));
                        this.state_ = state = state | 0b10 /* add-active doIsBound(Object, DynamicObject, InstanceofNode) */;
                        lock.unlock();
                        hasLock = false;
                        return doIsBound(arg0Value, arg1Value_, this.isBound_instanceofNode_);
                    }
                    if ((!(JSGuards.isJSObject(arg0Value))) && (JSGuards.isJSFunction(arg1Value_)) && (!(isBoundFunction(arg1Value_)))) {
                        this.state_ = state = state | 0b100 /* add-active doNotAnObject(Object, DynamicObject) */;
                        lock.unlock();
                        hasLock = false;
                        return doNotAnObject(arg0Value, arg1Value_);
                    }
                    if ((!(JSGuards.isJSObject(arg0Value))) && (JSGuards.isJSProxy(arg1Value_)) && (JSGuards.isCallableProxy(arg1Value_))) {
                        this.state_ = state = state | 0b1000 /* add-active doNotAnObjectProxy(Object, DynamicObject) */;
                        lock.unlock();
                        hasLock = false;
                        return doNotAnObjectProxy(arg0Value, arg1Value_);
                    }
                }
                if (JSTypes.isDynamicObject(arg0Value)) {
                    DynamicObject arg0Value_ = (DynamicObject) arg0Value;
                    if (JSTypes.isDynamicObject(arg1Value)) {
                        DynamicObject arg1Value_ = (DynamicObject) arg1Value;
                        if ((isObjectLocal(arg0Value_)) && (JSGuards.isJSFunction(arg1Value_)) && (!(isBoundFunction(arg1Value_)))) {
                            JSObjectData s5_ = super.insert(new JSObjectData());
                            s5_.getPrototype1Node_ = s5_.insertAccessor((GetPrototypeNode.create()));
                            s5_.getPrototype2Node_ = s5_.insertAccessor((GetPrototypeNode.create()));
                            s5_.getPrototype3Node_ = s5_.insertAccessor((GetPrototypeNode.create()));
                            s5_.firstTrue_ = (BranchProfile.create());
                            s5_.firstFalse_ = (BranchProfile.create());
                            s5_.need2Hops_ = (BranchProfile.create());
                            s5_.need3Hops_ = (BranchProfile.create());
                            s5_.errorBranch_ = (BranchProfile.create());
                            s5_.invalidPrototypeBranch_ = (BranchProfile.create());
                            this.jSObject_cache = s5_;
                            this.state_ = state = state | 0b10000 /* add-active doJSObject(DynamicObject, DynamicObject, GetPrototypeNode, GetPrototypeNode, GetPrototypeNode, BranchProfile, BranchProfile, BranchProfile, BranchProfile, BranchProfile, BranchProfile) */;
                            lock.unlock();
                            hasLock = false;
                            return doJSObject(arg0Value_, arg1Value_, s5_.getPrototype1Node_, s5_.getPrototype2Node_, s5_.getPrototype3Node_, s5_.firstTrue_, s5_.firstFalse_, s5_.need2Hops_, s5_.need3Hops_, s5_.errorBranch_, s5_.invalidPrototypeBranch_);
                        }
                        if ((isObjectLocal(arg0Value_)) && (JSGuards.isJSProxy(arg1Value_)) && (JSGuards.isCallableProxy(arg1Value_))) {
                            JSObjectProxyData s6_ = super.insert(new JSObjectProxyData());
                            s6_.getPrototype1Node_ = s6_.insertAccessor((GetPrototypeNode.create()));
                            s6_.getPrototype2Node_ = s6_.insertAccessor((GetPrototypeNode.create()));
                            s6_.getPrototype3Node_ = s6_.insertAccessor((GetPrototypeNode.create()));
                            s6_.firstTrue_ = (BranchProfile.create());
                            s6_.firstFalse_ = (BranchProfile.create());
                            s6_.need2Hops_ = (BranchProfile.create());
                            s6_.need3Hops_ = (BranchProfile.create());
                            s6_.errorBranch_ = (BranchProfile.create());
                            s6_.invalidPrototypeBranch_ = (BranchProfile.create());
                            this.jSObjectProxy_cache = s6_;
                            this.state_ = state = state | 0b100000 /* add-active doJSObjectProxy(DynamicObject, DynamicObject, GetPrototypeNode, GetPrototypeNode, GetPrototypeNode, BranchProfile, BranchProfile, BranchProfile, BranchProfile, BranchProfile, BranchProfile) */;
                            lock.unlock();
                            hasLock = false;
                            return doJSObjectProxy(arg0Value_, arg1Value_, s6_.getPrototype1Node_, s6_.getPrototype2Node_, s6_.getPrototype3Node_, s6_.firstTrue_, s6_.firstFalse_, s6_.need2Hops_, s6_.need3Hops_, s6_.errorBranch_, s6_.invalidPrototypeBranch_);
                        }
                    }
                }
                throw new UnsupportedSpecializationException(this, new Node[] {null, null}, arg0Value, arg1Value);
            } finally {
                if (hasLock) {
                    lock.unlock();
                }
            }
        }

        @Override
        public NodeCost getCost() {
            int state = state_;
            if (state == 0b0) {
                return NodeCost.UNINITIALIZED;
            } else if ((state & (state - 1)) == 0 /* is-single-active  */) {
                return NodeCost.MONOMORPHIC;
            }
            return NodeCost.POLYMORPHIC;
        }

        @Override
        public Introspection getIntrospectionData() {
            Object[] data = new Object[7];
            Object[] s;
            data[0] = 0;
            int state = state_;
            s = new Object[3];
            s[0] = "doNotCallable";
            if ((state & 0b1) != 0 /* is-active doNotCallable(Object, Object) */) {
                s[1] = (byte)0b01 /* active */;
            } else {
                s[1] = (byte)0b00 /* inactive */;
            }
            data[1] = s;
            s = new Object[3];
            s[0] = "doIsBound";
            if ((state & 0b10) != 0 /* is-active doIsBound(Object, DynamicObject, InstanceofNode) */) {
                s[1] = (byte)0b01 /* active */;
                ArrayList<Object> cached = new ArrayList<>();
                cached.add(Arrays.asList(this.isBound_instanceofNode_));
                s[2] = cached;
            } else {
                s[1] = (byte)0b00 /* inactive */;
            }
            data[2] = s;
            s = new Object[3];
            s[0] = "doNotAnObject";
            if ((state & 0b100) != 0 /* is-active doNotAnObject(Object, DynamicObject) */) {
                s[1] = (byte)0b01 /* active */;
            } else {
                s[1] = (byte)0b00 /* inactive */;
            }
            data[3] = s;
            s = new Object[3];
            s[0] = "doNotAnObjectProxy";
            if ((state & 0b1000) != 0 /* is-active doNotAnObjectProxy(Object, DynamicObject) */) {
                s[1] = (byte)0b01 /* active */;
            } else {
                s[1] = (byte)0b00 /* inactive */;
            }
            data[4] = s;
            s = new Object[3];
            s[0] = "doJSObject";
            if ((state & 0b10000) != 0 /* is-active doJSObject(DynamicObject, DynamicObject, GetPrototypeNode, GetPrototypeNode, GetPrototypeNode, BranchProfile, BranchProfile, BranchProfile, BranchProfile, BranchProfile, BranchProfile) */) {
                s[1] = (byte)0b01 /* active */;
                ArrayList<Object> cached = new ArrayList<>();
                JSObjectData s5_ = this.jSObject_cache;
                if (s5_ != null) {
                    cached.add(Arrays.asList(s5_.getPrototype1Node_, s5_.getPrototype2Node_, s5_.getPrototype3Node_, s5_.firstTrue_, s5_.firstFalse_, s5_.need2Hops_, s5_.need3Hops_, s5_.errorBranch_, s5_.invalidPrototypeBranch_));
                }
                s[2] = cached;
            } else {
                s[1] = (byte)0b00 /* inactive */;
            }
            data[5] = s;
            s = new Object[3];
            s[0] = "doJSObjectProxy";
            if ((state & 0b100000) != 0 /* is-active doJSObjectProxy(DynamicObject, DynamicObject, GetPrototypeNode, GetPrototypeNode, GetPrototypeNode, BranchProfile, BranchProfile, BranchProfile, BranchProfile, BranchProfile, BranchProfile) */) {
                s[1] = (byte)0b01 /* active */;
                ArrayList<Object> cached = new ArrayList<>();
                JSObjectProxyData s6_ = this.jSObjectProxy_cache;
                if (s6_ != null) {
                    cached.add(Arrays.asList(s6_.getPrototype1Node_, s6_.getPrototype2Node_, s6_.getPrototype3Node_, s6_.firstTrue_, s6_.firstFalse_, s6_.need2Hops_, s6_.need3Hops_, s6_.errorBranch_, s6_.invalidPrototypeBranch_));
                }
                s[2] = cached;
            } else {
                s[1] = (byte)0b00 /* inactive */;
            }
            data[6] = s;
            return Provider.create(data);
        }

        public static OrdinaryHasInstanceNode create(JSContext context) {
            return new OrdinaryHasInstanceNodeGen(context);
        }

        @GeneratedBy(OrdinaryHasInstanceNode.class)
        private static final class JSObjectData extends Node {

            @Child GetPrototypeNode getPrototype1Node_;
            @Child GetPrototypeNode getPrototype2Node_;
            @Child GetPrototypeNode getPrototype3Node_;
            @CompilationFinal BranchProfile firstTrue_;
            @CompilationFinal BranchProfile firstFalse_;
            @CompilationFinal BranchProfile need2Hops_;
            @CompilationFinal BranchProfile need3Hops_;
            @CompilationFinal BranchProfile errorBranch_;
            @CompilationFinal BranchProfile invalidPrototypeBranch_;

            JSObjectData() {
            }

            @Override
            public NodeCost getCost() {
                return NodeCost.NONE;
            }

            <T extends Node> T insertAccessor(T node) {
                return super.insert(node);
            }

        }
        @GeneratedBy(OrdinaryHasInstanceNode.class)
        private static final class JSObjectProxyData extends Node {

            @Child GetPrototypeNode getPrototype1Node_;
            @Child GetPrototypeNode getPrototype2Node_;
            @Child GetPrototypeNode getPrototype3Node_;
            @CompilationFinal BranchProfile firstTrue_;
            @CompilationFinal BranchProfile firstFalse_;
            @CompilationFinal BranchProfile need2Hops_;
            @CompilationFinal BranchProfile need3Hops_;
            @CompilationFinal BranchProfile errorBranch_;
            @CompilationFinal BranchProfile invalidPrototypeBranch_;

            JSObjectProxyData() {
            }

            @Override
            public NodeCost getCost() {
                return NodeCost.NONE;
            }

            <T extends Node> T insertAccessor(T node) {
                return super.insert(node);
            }

        }
    }
    @GeneratedBy(IsBoundFunctionCacheNode.class)
    public static final class IsBoundFunctionCacheNodeGen extends IsBoundFunctionCacheNode implements Provider {

        @CompilationFinal private int state_;
        @CompilationFinal private int exclude_;
        @CompilationFinal private DynamicObject cachedInstance_cachedFunction_;
        @CompilationFinal private boolean cachedInstance_cachedIsBound_;
        @CompilationFinal private CachedShapeData cachedShape_cache;

        private IsBoundFunctionCacheNodeGen(boolean multiContext) {
            super(multiContext);
        }

        @ExplodeLoop
        @Override
        public boolean executeBoolean(DynamicObject arg0Value) {
            int state = state_;
            if (state != 0 /* is-active doCachedInstance(DynamicObject, DynamicObject, boolean) || doCachedShape(DynamicObject, Shape, boolean) || isBoundFunction(DynamicObject) */) {
                if ((state & 0b1) != 0 /* is-active doCachedInstance(DynamicObject, DynamicObject, boolean) */) {
                    assert (!(multiContext));
                    if ((arg0Value == this.cachedInstance_cachedFunction_)) {
                        return IsBoundFunctionCacheNode.doCachedInstance(arg0Value, this.cachedInstance_cachedFunction_, this.cachedInstance_cachedIsBound_);
                    }
                }
                if ((state & 0b10) != 0 /* is-active doCachedShape(DynamicObject, Shape, boolean) */) {
                    CachedShapeData s2_ = this.cachedShape_cache;
                    while (s2_ != null) {
                        if ((s2_.cachedShape_.check(arg0Value))) {
                            return IsBoundFunctionCacheNode.doCachedShape(arg0Value, s2_.cachedShape_, s2_.cachedIsBound_);
                        }
                        s2_ = s2_.next_;
                    }
                }
                if ((state & 0b100) != 0 /* is-active isBoundFunction(DynamicObject) */) {
                    return IsBoundFunctionCacheNode.isBoundFunction(arg0Value);
                }
            }
            CompilerDirectives.transferToInterpreterAndInvalidate();
            return executeAndSpecialize(arg0Value);
        }

        private boolean executeAndSpecialize(DynamicObject arg0Value) {
            Lock lock = getLock();
            boolean hasLock = true;
            lock.lock();
            int state = state_;
            int exclude = exclude_;
            try {
                if (((exclude & 0b1)) == 0 /* is-not-excluded doCachedInstance(DynamicObject, DynamicObject, boolean) */) {
                    boolean CachedInstance_duplicateFound_ = false;
                    if ((state & 0b1) != 0 /* is-active doCachedInstance(DynamicObject, DynamicObject, boolean) */) {
                        assert (!(multiContext));
                        if ((arg0Value == this.cachedInstance_cachedFunction_)) {
                            CachedInstance_duplicateFound_ = true;
                        }
                    }
                    if (!CachedInstance_duplicateFound_) {
                        if ((!(multiContext))) {
                            // assert (arg0Value == this.cachedInstance_cachedFunction_);
                            if (((state & 0b1)) == 0 /* is-not-active doCachedInstance(DynamicObject, DynamicObject, boolean) */) {
                                this.cachedInstance_cachedFunction_ = (arg0Value);
                                this.cachedInstance_cachedIsBound_ = (IsBoundFunctionCacheNode.isBoundFunction(arg0Value));
                                this.state_ = state = state | 0b1 /* add-active doCachedInstance(DynamicObject, DynamicObject, boolean) */;
                                CachedInstance_duplicateFound_ = true;
                            }
                        }
                    }
                    if (CachedInstance_duplicateFound_) {
                        lock.unlock();
                        hasLock = false;
                        return IsBoundFunctionCacheNode.doCachedInstance(arg0Value, this.cachedInstance_cachedFunction_, this.cachedInstance_cachedIsBound_);
                    }
                }
                if (((exclude & 0b10)) == 0 /* is-not-excluded doCachedShape(DynamicObject, Shape, boolean) */) {
                    int count2_ = 0;
                    CachedShapeData s2_ = this.cachedShape_cache;
                    if ((state & 0b10) != 0 /* is-active doCachedShape(DynamicObject, Shape, boolean) */) {
                        while (s2_ != null) {
                            if ((s2_.cachedShape_.check(arg0Value))) {
                                break;
                            }
                            s2_ = s2_.next_;
                            count2_++;
                        }
                    }
                    if (s2_ == null) {
                        {
                            Shape cachedShape__ = (arg0Value.getShape());
                            if ((cachedShape__.check(arg0Value)) && count2_ < (3)) {
                                s2_ = new CachedShapeData(cachedShape_cache);
                                s2_.cachedShape_ = cachedShape__;
                                s2_.cachedIsBound_ = (IsBoundFunctionCacheNode.isBoundFunction(arg0Value));
                                this.cachedShape_cache = s2_;
                                this.exclude_ = exclude = exclude | 0b1 /* add-excluded doCachedInstance(DynamicObject, DynamicObject, boolean) */;
                                state = state & 0xfffffffe /* remove-active doCachedInstance(DynamicObject, DynamicObject, boolean) */;
                                this.state_ = state = state | 0b10 /* add-active doCachedShape(DynamicObject, Shape, boolean) */;
                            }
                        }
                    }
                    if (s2_ != null) {
                        lock.unlock();
                        hasLock = false;
                        return IsBoundFunctionCacheNode.doCachedShape(arg0Value, s2_.cachedShape_, s2_.cachedIsBound_);
                    }
                }
                this.exclude_ = exclude = exclude | 0b11 /* add-excluded doCachedInstance(DynamicObject, DynamicObject, boolean), doCachedShape(DynamicObject, Shape, boolean) */;
                this.cachedShape_cache = null;
                state = state & 0xfffffffc /* remove-active doCachedInstance(DynamicObject, DynamicObject, boolean), doCachedShape(DynamicObject, Shape, boolean) */;
                this.state_ = state = state | 0b100 /* add-active isBoundFunction(DynamicObject) */;
                lock.unlock();
                hasLock = false;
                return IsBoundFunctionCacheNode.isBoundFunction(arg0Value);
            } finally {
                if (hasLock) {
                    lock.unlock();
                }
            }
        }

        @Override
        public NodeCost getCost() {
            int state = state_;
            if (state == 0b0) {
                return NodeCost.UNINITIALIZED;
            } else if ((state & (state - 1)) == 0 /* is-single-active  */) {
                CachedShapeData s2_ = this.cachedShape_cache;
                if ((s2_ == null || s2_.next_ == null)) {
                    return NodeCost.MONOMORPHIC;
                }
            }
            return NodeCost.POLYMORPHIC;
        }

        @Override
        public Introspection getIntrospectionData() {
            Object[] data = new Object[4];
            Object[] s;
            data[0] = 0;
            int state = state_;
            int exclude = exclude_;
            s = new Object[3];
            s[0] = "doCachedInstance";
            if ((state & 0b1) != 0 /* is-active doCachedInstance(DynamicObject, DynamicObject, boolean) */) {
                s[1] = (byte)0b01 /* active */;
                ArrayList<Object> cached = new ArrayList<>();
                cached.add(Arrays.asList(this.cachedInstance_cachedFunction_, this.cachedInstance_cachedIsBound_));
                s[2] = cached;
            } else if ((exclude & 0b1) != 0 /* is-excluded doCachedInstance(DynamicObject, DynamicObject, boolean) */) {
                s[1] = (byte)0b10 /* excluded */;
            } else {
                s[1] = (byte)0b00 /* inactive */;
            }
            data[1] = s;
            s = new Object[3];
            s[0] = "doCachedShape";
            if ((state & 0b10) != 0 /* is-active doCachedShape(DynamicObject, Shape, boolean) */) {
                s[1] = (byte)0b01 /* active */;
                ArrayList<Object> cached = new ArrayList<>();
                CachedShapeData s2_ = this.cachedShape_cache;
                while (s2_ != null) {
                    cached.add(Arrays.asList(s2_.cachedShape_, s2_.cachedIsBound_));
                    s2_ = s2_.next_;
                }
                s[2] = cached;
            } else if ((exclude & 0b10) != 0 /* is-excluded doCachedShape(DynamicObject, Shape, boolean) */) {
                s[1] = (byte)0b10 /* excluded */;
            } else {
                s[1] = (byte)0b00 /* inactive */;
            }
            data[2] = s;
            s = new Object[3];
            s[0] = "isBoundFunction";
            if ((state & 0b100) != 0 /* is-active isBoundFunction(DynamicObject) */) {
                s[1] = (byte)0b01 /* active */;
            } else {
                s[1] = (byte)0b00 /* inactive */;
            }
            data[3] = s;
            return Provider.create(data);
        }

        public static IsBoundFunctionCacheNode create(boolean multiContext) {
            return new IsBoundFunctionCacheNodeGen(multiContext);
        }

        @GeneratedBy(IsBoundFunctionCacheNode.class)
        private static final class CachedShapeData {

            @CompilationFinal CachedShapeData next_;
            @CompilationFinal Shape cachedShape_;
            @CompilationFinal boolean cachedIsBound_;

            CachedShapeData(CachedShapeData next_) {
                this.next_ = next_;
            }

        }
    }
}
