// CheckStyle: start generated
package com.oracle.truffle.js.nodes.access;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.CompilerDirectives.CompilationFinal;
import com.oracle.truffle.api.dsl.GeneratedBy;
import com.oracle.truffle.api.dsl.Introspection;
import com.oracle.truffle.api.dsl.Introspection.Provider;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.nodes.NodeCost;
import com.oracle.truffle.api.object.DynamicObject;
import com.oracle.truffle.api.object.HiddenKey;
import com.oracle.truffle.js.nodes.JSGuards;
import com.oracle.truffle.js.nodes.JSTypes;
import com.oracle.truffle.js.nodes.JavaScriptNode;
import com.oracle.truffle.js.nodes.access.HasHiddenKeyCacheNode;
import com.oracle.truffle.js.nodes.access.PrivateFieldSetNode;
import com.oracle.truffle.js.nodes.access.PropertySetNode;
import com.oracle.truffle.js.runtime.JSContext;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.concurrent.locks.Lock;

@GeneratedBy(PrivateFieldSetNode.class)
@SuppressWarnings("unused")
public final class PrivateFieldSetNodeGen extends PrivateFieldSetNode implements Provider {

    @CompilationFinal private int state_;
    @CompilationFinal private int exclude_;
    @Child private CachedKeyData cachedKey_cache;

    private PrivateFieldSetNodeGen(JavaScriptNode targetNode, JavaScriptNode keyNode, JavaScriptNode valueNode, JSContext context) {
        super(targetNode, keyNode, valueNode, context);
    }

    @Override
    public Object execute(Object targetNodeValue, Object keyNodeValue, Object valueNodeValue) {
        int state = state_;
        if (state != 0 /* is-active doCachedKey(DynamicObject, HiddenKey, Object, HiddenKey, HasHiddenKeyCacheNode, PropertySetNode) || doUncachedKey(DynamicObject, HiddenKey, Object) || doFallback(Object, Object, Object) */) {
            if ((state & 0b11) != 0 /* is-active doCachedKey(DynamicObject, HiddenKey, Object, HiddenKey, HasHiddenKeyCacheNode, PropertySetNode) || doUncachedKey(DynamicObject, HiddenKey, Object) */ && JSTypes.isDynamicObject(targetNodeValue)) {
                DynamicObject targetNodeValue_ = (DynamicObject) targetNodeValue;
                if (keyNodeValue instanceof HiddenKey) {
                    HiddenKey keyNodeValue_ = (HiddenKey) keyNodeValue;
                    if ((state & 0b1) != 0 /* is-active doCachedKey(DynamicObject, HiddenKey, Object, HiddenKey, HasHiddenKeyCacheNode, PropertySetNode) */) {
                        CachedKeyData s1_ = this.cachedKey_cache;
                        if (s1_ != null) {
                            if ((keyNodeValue_ == s1_.cachedKey_) && (JSGuards.isJSObject(targetNodeValue_))) {
                                return doCachedKey(targetNodeValue_, keyNodeValue_, valueNodeValue, s1_.cachedKey_, s1_.hasNode_, s1_.setNode_);
                            }
                        }
                    }
                    if ((state & 0b10) != 0 /* is-active doUncachedKey(DynamicObject, HiddenKey, Object) */) {
                        if ((JSGuards.isJSObject(targetNodeValue_))) {
                            return doUncachedKey(targetNodeValue_, keyNodeValue_, valueNodeValue);
                        }
                    }
                }
            }
            if ((state & 0b100) != 0 /* is-active doFallback(Object, Object, Object) */) {
                if (fallbackGuard_(targetNodeValue, keyNodeValue, valueNodeValue)) {
                    return doFallback(targetNodeValue, keyNodeValue, valueNodeValue);
                }
            }
        }
        CompilerDirectives.transferToInterpreterAndInvalidate();
        return executeAndSpecialize(targetNodeValue, keyNodeValue, valueNodeValue);
    }

    @Override
    public Object executeWithTarget(VirtualFrame frameValue, Object targetNodeValue) {
        int state = state_;
        Object keyNodeValue_ = super.keyNode.execute(frameValue);
        Object valueNodeValue_ = super.valueNode.execute(frameValue);
        if (state != 0 /* is-active doCachedKey(DynamicObject, HiddenKey, Object, HiddenKey, HasHiddenKeyCacheNode, PropertySetNode) || doUncachedKey(DynamicObject, HiddenKey, Object) || doFallback(Object, Object, Object) */) {
            if ((state & 0b11) != 0 /* is-active doCachedKey(DynamicObject, HiddenKey, Object, HiddenKey, HasHiddenKeyCacheNode, PropertySetNode) || doUncachedKey(DynamicObject, HiddenKey, Object) */ && JSTypes.isDynamicObject(targetNodeValue)) {
                DynamicObject targetNodeValue_ = (DynamicObject) targetNodeValue;
                if (keyNodeValue_ instanceof HiddenKey) {
                    HiddenKey keyNodeValue__ = (HiddenKey) keyNodeValue_;
                    if ((state & 0b1) != 0 /* is-active doCachedKey(DynamicObject, HiddenKey, Object, HiddenKey, HasHiddenKeyCacheNode, PropertySetNode) */) {
                        CachedKeyData s1_ = this.cachedKey_cache;
                        if (s1_ != null) {
                            if ((keyNodeValue__ == s1_.cachedKey_) && (JSGuards.isJSObject(targetNodeValue_))) {
                                return doCachedKey(targetNodeValue_, keyNodeValue__, valueNodeValue_, s1_.cachedKey_, s1_.hasNode_, s1_.setNode_);
                            }
                        }
                    }
                    if ((state & 0b10) != 0 /* is-active doUncachedKey(DynamicObject, HiddenKey, Object) */) {
                        if ((JSGuards.isJSObject(targetNodeValue_))) {
                            return doUncachedKey(targetNodeValue_, keyNodeValue__, valueNodeValue_);
                        }
                    }
                }
            }
            if ((state & 0b100) != 0 /* is-active doFallback(Object, Object, Object) */) {
                if (fallbackGuard_(targetNodeValue, keyNodeValue_, valueNodeValue_)) {
                    return doFallback(targetNodeValue, keyNodeValue_, valueNodeValue_);
                }
            }
        }
        CompilerDirectives.transferToInterpreterAndInvalidate();
        return executeAndSpecialize(targetNodeValue, keyNodeValue_, valueNodeValue_);
    }

    @Override
    public Object execute(VirtualFrame frameValue) {
        int state = state_;
        Object targetNodeValue_ = super.targetNode.execute(frameValue);
        Object keyNodeValue_ = super.keyNode.execute(frameValue);
        Object valueNodeValue_ = super.valueNode.execute(frameValue);
        if (state != 0 /* is-active doCachedKey(DynamicObject, HiddenKey, Object, HiddenKey, HasHiddenKeyCacheNode, PropertySetNode) || doUncachedKey(DynamicObject, HiddenKey, Object) || doFallback(Object, Object, Object) */) {
            if ((state & 0b11) != 0 /* is-active doCachedKey(DynamicObject, HiddenKey, Object, HiddenKey, HasHiddenKeyCacheNode, PropertySetNode) || doUncachedKey(DynamicObject, HiddenKey, Object) */ && JSTypes.isDynamicObject(targetNodeValue_)) {
                DynamicObject targetNodeValue__ = (DynamicObject) targetNodeValue_;
                if (keyNodeValue_ instanceof HiddenKey) {
                    HiddenKey keyNodeValue__ = (HiddenKey) keyNodeValue_;
                    if ((state & 0b1) != 0 /* is-active doCachedKey(DynamicObject, HiddenKey, Object, HiddenKey, HasHiddenKeyCacheNode, PropertySetNode) */) {
                        CachedKeyData s1_ = this.cachedKey_cache;
                        if (s1_ != null) {
                            if ((keyNodeValue__ == s1_.cachedKey_) && (JSGuards.isJSObject(targetNodeValue__))) {
                                return doCachedKey(targetNodeValue__, keyNodeValue__, valueNodeValue_, s1_.cachedKey_, s1_.hasNode_, s1_.setNode_);
                            }
                        }
                    }
                    if ((state & 0b10) != 0 /* is-active doUncachedKey(DynamicObject, HiddenKey, Object) */) {
                        if ((JSGuards.isJSObject(targetNodeValue__))) {
                            return doUncachedKey(targetNodeValue__, keyNodeValue__, valueNodeValue_);
                        }
                    }
                }
            }
            if ((state & 0b100) != 0 /* is-active doFallback(Object, Object, Object) */) {
                if (fallbackGuard_(targetNodeValue_, keyNodeValue_, valueNodeValue_)) {
                    return doFallback(targetNodeValue_, keyNodeValue_, valueNodeValue_);
                }
            }
        }
        CompilerDirectives.transferToInterpreterAndInvalidate();
        return executeAndSpecialize(targetNodeValue_, keyNodeValue_, valueNodeValue_);
    }

    @Override
    public void executeVoid(VirtualFrame frameValue) {
        execute(frameValue);
        return;
    }

    private Object executeAndSpecialize(Object targetNodeValue, Object keyNodeValue, Object valueNodeValue) {
        Lock lock = getLock();
        boolean hasLock = true;
        lock.lock();
        int state = state_;
        int exclude = exclude_;
        try {
            if (JSTypes.isDynamicObject(targetNodeValue)) {
                DynamicObject targetNodeValue_ = (DynamicObject) targetNodeValue;
                if (keyNodeValue instanceof HiddenKey) {
                    HiddenKey keyNodeValue_ = (HiddenKey) keyNodeValue;
                    if ((exclude) == 0 /* is-not-excluded doCachedKey(DynamicObject, HiddenKey, Object, HiddenKey, HasHiddenKeyCacheNode, PropertySetNode) */) {
                        CachedKeyData s1_ = this.cachedKey_cache;
                        boolean CachedKey_duplicateFound_ = false;
                        if ((state & 0b1) != 0 /* is-active doCachedKey(DynamicObject, HiddenKey, Object, HiddenKey, HasHiddenKeyCacheNode, PropertySetNode) */) {
                            if ((keyNodeValue_ == s1_.cachedKey_) && (JSGuards.isJSObject(targetNodeValue_))) {
                                CachedKey_duplicateFound_ = true;
                            }
                        }
                        if (!CachedKey_duplicateFound_) {
                            if ((JSGuards.isJSObject(targetNodeValue_)) && ((state & 0b1)) == 0 /* is-not-active doCachedKey(DynamicObject, HiddenKey, Object, HiddenKey, HasHiddenKeyCacheNode, PropertySetNode) */) {
                                // assert (keyNodeValue_ == s1_.cachedKey_);
                                s1_ = super.insert(new CachedKeyData());
                                s1_.cachedKey_ = (keyNodeValue_);
                                s1_.hasNode_ = s1_.insertAccessor((HasHiddenKeyCacheNode.create(keyNodeValue_)));
                                s1_.setNode_ = s1_.insertAccessor((PropertySetNode.createSetHidden(keyNodeValue_, context)));
                                this.cachedKey_cache = s1_;
                                this.state_ = state = state | 0b1 /* add-active doCachedKey(DynamicObject, HiddenKey, Object, HiddenKey, HasHiddenKeyCacheNode, PropertySetNode) */;
                                CachedKey_duplicateFound_ = true;
                            }
                        }
                        if (CachedKey_duplicateFound_) {
                            lock.unlock();
                            hasLock = false;
                            return doCachedKey(targetNodeValue_, keyNodeValue_, valueNodeValue, s1_.cachedKey_, s1_.hasNode_, s1_.setNode_);
                        }
                    }
                    if ((JSGuards.isJSObject(targetNodeValue_))) {
                        this.exclude_ = exclude = exclude | 0b1 /* add-excluded doCachedKey(DynamicObject, HiddenKey, Object, HiddenKey, HasHiddenKeyCacheNode, PropertySetNode) */;
                        this.cachedKey_cache = null;
                        state = state & 0xfffffffe /* remove-active doCachedKey(DynamicObject, HiddenKey, Object, HiddenKey, HasHiddenKeyCacheNode, PropertySetNode) */;
                        this.state_ = state = state | 0b10 /* add-active doUncachedKey(DynamicObject, HiddenKey, Object) */;
                        lock.unlock();
                        hasLock = false;
                        return doUncachedKey(targetNodeValue_, keyNodeValue_, valueNodeValue);
                    }
                }
            }
            this.state_ = state = state | 0b100 /* add-active doFallback(Object, Object, Object) */;
            lock.unlock();
            hasLock = false;
            return doFallback(targetNodeValue, keyNodeValue, valueNodeValue);
        } finally {
            if (hasLock) {
                lock.unlock();
            }
        }
    }

    @Override
    public NodeCost getCost() {
        int state = state_;
        if (state == 0b0) {
            return NodeCost.UNINITIALIZED;
        } else if ((state & (state - 1)) == 0 /* is-single-active  */) {
            return NodeCost.MONOMORPHIC;
        }
        return NodeCost.POLYMORPHIC;
    }

    @Override
    public Introspection getIntrospectionData() {
        Object[] data = new Object[4];
        Object[] s;
        data[0] = 0;
        int state = state_;
        int exclude = exclude_;
        s = new Object[3];
        s[0] = "doCachedKey";
        if ((state & 0b1) != 0 /* is-active doCachedKey(DynamicObject, HiddenKey, Object, HiddenKey, HasHiddenKeyCacheNode, PropertySetNode) */) {
            s[1] = (byte)0b01 /* active */;
            ArrayList<Object> cached = new ArrayList<>();
            CachedKeyData s1_ = this.cachedKey_cache;
            if (s1_ != null) {
                cached.add(Arrays.asList(s1_.cachedKey_, s1_.hasNode_, s1_.setNode_));
            }
            s[2] = cached;
        } else if (exclude != 0 /* is-excluded doCachedKey(DynamicObject, HiddenKey, Object, HiddenKey, HasHiddenKeyCacheNode, PropertySetNode) */) {
            s[1] = (byte)0b10 /* excluded */;
        } else {
            s[1] = (byte)0b00 /* inactive */;
        }
        data[1] = s;
        s = new Object[3];
        s[0] = "doUncachedKey";
        if ((state & 0b10) != 0 /* is-active doUncachedKey(DynamicObject, HiddenKey, Object) */) {
            s[1] = (byte)0b01 /* active */;
        } else {
            s[1] = (byte)0b00 /* inactive */;
        }
        data[2] = s;
        s = new Object[3];
        s[0] = "doFallback";
        if ((state & 0b100) != 0 /* is-active doFallback(Object, Object, Object) */) {
            s[1] = (byte)0b01 /* active */;
        } else {
            s[1] = (byte)0b00 /* inactive */;
        }
        data[3] = s;
        return Provider.create(data);
    }

    private static boolean fallbackGuard_(Object targetNodeValue, Object keyNodeValue, Object valueNodeValue) {
        if (JSTypes.isDynamicObject(targetNodeValue) && keyNodeValue instanceof HiddenKey) {
            DynamicObject targetNodeValue_ = (DynamicObject) targetNodeValue;
            if ((JSGuards.isJSObject(targetNodeValue_))) {
                return false;
            }
        }
        return true;
    }

    public static PrivateFieldSetNode create(JavaScriptNode targetNode, JavaScriptNode keyNode, JavaScriptNode valueNode, JSContext context) {
        return new PrivateFieldSetNodeGen(targetNode, keyNode, valueNode, context);
    }

    @GeneratedBy(PrivateFieldSetNode.class)
    private static final class CachedKeyData extends Node {

        @CompilationFinal HiddenKey cachedKey_;
        @Child HasHiddenKeyCacheNode hasNode_;
        @Child PropertySetNode setNode_;

        CachedKeyData() {
        }

        @Override
        public NodeCost getCost() {
            return NodeCost.NONE;
        }

        <T extends Node> T insertAccessor(T node) {
            return super.insert(node);
        }

    }
}
