// CheckStyle: start generated
package com.oracle.truffle.js.nodes.access;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.CompilerDirectives.CompilationFinal;
import com.oracle.truffle.api.dsl.GeneratedBy;
import com.oracle.truffle.api.dsl.Introspection;
import com.oracle.truffle.api.dsl.Introspection.Provider;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.nodes.NodeCost;
import com.oracle.truffle.api.object.DynamicObject;
import com.oracle.truffle.api.object.HiddenKey;
import com.oracle.truffle.js.nodes.JSGuards;
import com.oracle.truffle.js.nodes.JSTypes;
import com.oracle.truffle.js.nodes.JavaScriptNode;
import com.oracle.truffle.js.nodes.access.HasHiddenKeyCacheNode;
import com.oracle.truffle.js.nodes.access.PrivateFieldGetNode;
import com.oracle.truffle.js.nodes.access.PropertyGetNode;
import com.oracle.truffle.js.runtime.JSContext;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.concurrent.locks.Lock;

@GeneratedBy(PrivateFieldGetNode.class)
public final class PrivateFieldGetNodeGen extends PrivateFieldGetNode implements Provider {

    @CompilationFinal private int state_;
    @CompilationFinal private int exclude_;
    @Child private CachedKeyData cachedKey_cache;

    private PrivateFieldGetNodeGen(JavaScriptNode targetNode, JavaScriptNode keyNode, JSContext context) {
        super(targetNode, keyNode, context);
    }

    @Override
    public Object executeWithTarget(VirtualFrame frameValue, Object targetNodeValue) {
        int state = state_;
        Object keyNodeValue_ = super.keyNode.execute(frameValue);
        if ((state & 0b11) != 0 /* is-active doCachedKey(DynamicObject, HiddenKey, HiddenKey, HasHiddenKeyCacheNode, PropertyGetNode) || doUncachedKey(DynamicObject, HiddenKey) */ && JSTypes.isDynamicObject(targetNodeValue)) {
            DynamicObject targetNodeValue_ = (DynamicObject) targetNodeValue;
            if (keyNodeValue_ instanceof HiddenKey) {
                HiddenKey keyNodeValue__ = (HiddenKey) keyNodeValue_;
                if ((state & 0b1) != 0 /* is-active doCachedKey(DynamicObject, HiddenKey, HiddenKey, HasHiddenKeyCacheNode, PropertyGetNode) */) {
                    CachedKeyData s1_ = this.cachedKey_cache;
                    if (s1_ != null) {
                        if ((keyNodeValue__ == s1_.cachedKey_) && (JSGuards.isJSObject(targetNodeValue_))) {
                            return doCachedKey(targetNodeValue_, keyNodeValue__, s1_.cachedKey_, s1_.hasNode_, s1_.getNode_);
                        }
                    }
                }
                if ((state & 0b10) != 0 /* is-active doUncachedKey(DynamicObject, HiddenKey) */) {
                    if ((JSGuards.isJSObject(targetNodeValue_))) {
                        return doUncachedKey(targetNodeValue_, keyNodeValue__);
                    }
                }
            }
        }
        if ((state & 0b100) != 0 /* is-active doFallback(Object, Object) */) {
            if (fallbackGuard_(targetNodeValue, keyNodeValue_)) {
                return doFallback(targetNodeValue, keyNodeValue_);
            }
        }
        CompilerDirectives.transferToInterpreterAndInvalidate();
        return executeAndSpecialize(targetNodeValue, keyNodeValue_);
    }

    @Override
    public Object execute(VirtualFrame frameValue) {
        int state = state_;
        Object targetNodeValue_ = super.targetNode.execute(frameValue);
        Object keyNodeValue_ = super.keyNode.execute(frameValue);
        if ((state & 0b11) != 0 /* is-active doCachedKey(DynamicObject, HiddenKey, HiddenKey, HasHiddenKeyCacheNode, PropertyGetNode) || doUncachedKey(DynamicObject, HiddenKey) */ && JSTypes.isDynamicObject(targetNodeValue_)) {
            DynamicObject targetNodeValue__ = (DynamicObject) targetNodeValue_;
            if (keyNodeValue_ instanceof HiddenKey) {
                HiddenKey keyNodeValue__ = (HiddenKey) keyNodeValue_;
                if ((state & 0b1) != 0 /* is-active doCachedKey(DynamicObject, HiddenKey, HiddenKey, HasHiddenKeyCacheNode, PropertyGetNode) */) {
                    CachedKeyData s1_ = this.cachedKey_cache;
                    if (s1_ != null) {
                        if ((keyNodeValue__ == s1_.cachedKey_) && (JSGuards.isJSObject(targetNodeValue__))) {
                            return doCachedKey(targetNodeValue__, keyNodeValue__, s1_.cachedKey_, s1_.hasNode_, s1_.getNode_);
                        }
                    }
                }
                if ((state & 0b10) != 0 /* is-active doUncachedKey(DynamicObject, HiddenKey) */) {
                    if ((JSGuards.isJSObject(targetNodeValue__))) {
                        return doUncachedKey(targetNodeValue__, keyNodeValue__);
                    }
                }
            }
        }
        if ((state & 0b100) != 0 /* is-active doFallback(Object, Object) */) {
            if (fallbackGuard_(targetNodeValue_, keyNodeValue_)) {
                return doFallback(targetNodeValue_, keyNodeValue_);
            }
        }
        CompilerDirectives.transferToInterpreterAndInvalidate();
        return executeAndSpecialize(targetNodeValue_, keyNodeValue_);
    }

    @Override
    public void executeVoid(VirtualFrame frameValue) {
        execute(frameValue);
        return;
    }

    private Object executeAndSpecialize(Object targetNodeValue, Object keyNodeValue) {
        Lock lock = getLock();
        boolean hasLock = true;
        lock.lock();
        int state = state_;
        int exclude = exclude_;
        try {
            if (JSTypes.isDynamicObject(targetNodeValue)) {
                DynamicObject targetNodeValue_ = (DynamicObject) targetNodeValue;
                if (keyNodeValue instanceof HiddenKey) {
                    HiddenKey keyNodeValue_ = (HiddenKey) keyNodeValue;
                    if ((exclude) == 0 /* is-not-excluded doCachedKey(DynamicObject, HiddenKey, HiddenKey, HasHiddenKeyCacheNode, PropertyGetNode) */) {
                        CachedKeyData s1_ = this.cachedKey_cache;
                        boolean CachedKey_duplicateFound_ = false;
                        if ((state & 0b1) != 0 /* is-active doCachedKey(DynamicObject, HiddenKey, HiddenKey, HasHiddenKeyCacheNode, PropertyGetNode) */) {
                            if ((keyNodeValue_ == s1_.cachedKey_) && (JSGuards.isJSObject(targetNodeValue_))) {
                                CachedKey_duplicateFound_ = true;
                            }
                        }
                        if (!CachedKey_duplicateFound_) {
                            if ((JSGuards.isJSObject(targetNodeValue_)) && ((state & 0b1)) == 0 /* is-not-active doCachedKey(DynamicObject, HiddenKey, HiddenKey, HasHiddenKeyCacheNode, PropertyGetNode) */) {
                                // assert (keyNodeValue_ == s1_.cachedKey_);
                                s1_ = super.insert(new CachedKeyData());
                                s1_.cachedKey_ = (keyNodeValue_);
                                s1_.hasNode_ = s1_.insertAccessor((HasHiddenKeyCacheNode.create(keyNodeValue_)));
                                s1_.getNode_ = s1_.insertAccessor((PropertyGetNode.createGetHidden(keyNodeValue_, context)));
                                this.cachedKey_cache = s1_;
                                this.state_ = state = state | 0b1 /* add-active doCachedKey(DynamicObject, HiddenKey, HiddenKey, HasHiddenKeyCacheNode, PropertyGetNode) */;
                                CachedKey_duplicateFound_ = true;
                            }
                        }
                        if (CachedKey_duplicateFound_) {
                            lock.unlock();
                            hasLock = false;
                            return doCachedKey(targetNodeValue_, keyNodeValue_, s1_.cachedKey_, s1_.hasNode_, s1_.getNode_);
                        }
                    }
                    if ((JSGuards.isJSObject(targetNodeValue_))) {
                        this.exclude_ = exclude = exclude | 0b1 /* add-excluded doCachedKey(DynamicObject, HiddenKey, HiddenKey, HasHiddenKeyCacheNode, PropertyGetNode) */;
                        this.cachedKey_cache = null;
                        state = state & 0xfffffffe /* remove-active doCachedKey(DynamicObject, HiddenKey, HiddenKey, HasHiddenKeyCacheNode, PropertyGetNode) */;
                        this.state_ = state = state | 0b10 /* add-active doUncachedKey(DynamicObject, HiddenKey) */;
                        lock.unlock();
                        hasLock = false;
                        return doUncachedKey(targetNodeValue_, keyNodeValue_);
                    }
                }
            }
            this.state_ = state = state | 0b100 /* add-active doFallback(Object, Object) */;
            lock.unlock();
            hasLock = false;
            return doFallback(targetNodeValue, keyNodeValue);
        } finally {
            if (hasLock) {
                lock.unlock();
            }
        }
    }

    @Override
    public NodeCost getCost() {
        int state = state_;
        if (state == 0b0) {
            return NodeCost.UNINITIALIZED;
        } else if ((state & (state - 1)) == 0 /* is-single-active  */) {
            return NodeCost.MONOMORPHIC;
        }
        return NodeCost.POLYMORPHIC;
    }

    @Override
    public Introspection getIntrospectionData() {
        Object[] data = new Object[4];
        Object[] s;
        data[0] = 0;
        int state = state_;
        int exclude = exclude_;
        s = new Object[3];
        s[0] = "doCachedKey";
        if ((state & 0b1) != 0 /* is-active doCachedKey(DynamicObject, HiddenKey, HiddenKey, HasHiddenKeyCacheNode, PropertyGetNode) */) {
            s[1] = (byte)0b01 /* active */;
            ArrayList<Object> cached = new ArrayList<>();
            CachedKeyData s1_ = this.cachedKey_cache;
            if (s1_ != null) {
                cached.add(Arrays.asList(s1_.cachedKey_, s1_.hasNode_, s1_.getNode_));
            }
            s[2] = cached;
        } else if (exclude != 0 /* is-excluded doCachedKey(DynamicObject, HiddenKey, HiddenKey, HasHiddenKeyCacheNode, PropertyGetNode) */) {
            s[1] = (byte)0b10 /* excluded */;
        } else {
            s[1] = (byte)0b00 /* inactive */;
        }
        data[1] = s;
        s = new Object[3];
        s[0] = "doUncachedKey";
        if ((state & 0b10) != 0 /* is-active doUncachedKey(DynamicObject, HiddenKey) */) {
            s[1] = (byte)0b01 /* active */;
        } else {
            s[1] = (byte)0b00 /* inactive */;
        }
        data[2] = s;
        s = new Object[3];
        s[0] = "doFallback";
        if ((state & 0b100) != 0 /* is-active doFallback(Object, Object) */) {
            s[1] = (byte)0b01 /* active */;
        } else {
            s[1] = (byte)0b00 /* inactive */;
        }
        data[3] = s;
        return Provider.create(data);
    }

    private static boolean fallbackGuard_(Object targetNodeValue, Object keyNodeValue) {
        if (JSTypes.isDynamicObject(targetNodeValue) && keyNodeValue instanceof HiddenKey) {
            DynamicObject targetNodeValue_ = (DynamicObject) targetNodeValue;
            if ((JSGuards.isJSObject(targetNodeValue_))) {
                return false;
            }
        }
        return true;
    }

    public static PrivateFieldGetNode create(JavaScriptNode targetNode, JavaScriptNode keyNode, JSContext context) {
        return new PrivateFieldGetNodeGen(targetNode, keyNode, context);
    }

    @GeneratedBy(PrivateFieldGetNode.class)
    private static final class CachedKeyData extends Node {

        @CompilationFinal HiddenKey cachedKey_;
        @Child HasHiddenKeyCacheNode hasNode_;
        @Child PropertyGetNode getNode_;

        CachedKeyData() {
        }

        @Override
        public NodeCost getCost() {
            return NodeCost.NONE;
        }

        <T extends Node> T insertAccessor(T node) {
            return super.insert(node);
        }

    }
}
