// CheckStyle: start generated
package com.oracle.truffle.js.nodes.access;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.CompilerDirectives.CompilationFinal;
import com.oracle.truffle.api.dsl.GeneratedBy;
import com.oracle.truffle.api.dsl.Introspection;
import com.oracle.truffle.api.dsl.Introspection.Provider;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.nodes.NodeCost;
import com.oracle.truffle.api.object.DynamicObject;
import com.oracle.truffle.api.object.HiddenKey;
import com.oracle.truffle.js.nodes.JSGuards;
import com.oracle.truffle.js.nodes.JSTypes;
import com.oracle.truffle.js.nodes.access.HasHiddenKeyCacheNode;
import com.oracle.truffle.js.nodes.access.PrivateFieldAddNode;
import com.oracle.truffle.js.nodes.access.PropertySetNode;
import com.oracle.truffle.js.runtime.JSContext;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.concurrent.locks.Lock;

@GeneratedBy(PrivateFieldAddNode.class)
@SuppressWarnings("unused")
public final class PrivateFieldAddNodeGen extends PrivateFieldAddNode implements Provider {

    @CompilationFinal private int state_;
    @CompilationFinal private int exclude_;
    @Child private CachedKeyData cachedKey_cache;

    private PrivateFieldAddNodeGen(JSContext context) {
        super(context);
    }

    @Override
    public void execute(Object arg0Value, Object arg1Value, Object arg2Value) {
        int state = state_;
        if (state != 0 /* is-active doCachedKey(DynamicObject, HiddenKey, Object, HiddenKey, HasHiddenKeyCacheNode, PropertySetNode) || doUncachedKey(DynamicObject, HiddenKey, Object) || doFallback(Object, Object, Object) */) {
            if ((state & 0b11) != 0 /* is-active doCachedKey(DynamicObject, HiddenKey, Object, HiddenKey, HasHiddenKeyCacheNode, PropertySetNode) || doUncachedKey(DynamicObject, HiddenKey, Object) */ && JSTypes.isDynamicObject(arg0Value)) {
                DynamicObject arg0Value_ = (DynamicObject) arg0Value;
                if (arg1Value instanceof HiddenKey) {
                    HiddenKey arg1Value_ = (HiddenKey) arg1Value;
                    if ((state & 0b1) != 0 /* is-active doCachedKey(DynamicObject, HiddenKey, Object, HiddenKey, HasHiddenKeyCacheNode, PropertySetNode) */) {
                        CachedKeyData s1_ = this.cachedKey_cache;
                        if (s1_ != null) {
                            if ((arg1Value_ == s1_.cachedKey_) && (JSGuards.isJSObject(arg0Value_))) {
                                doCachedKey(arg0Value_, arg1Value_, arg2Value, s1_.cachedKey_, s1_.hasNode_, s1_.setNode_);
                                return;
                            }
                        }
                    }
                    if ((state & 0b10) != 0 /* is-active doUncachedKey(DynamicObject, HiddenKey, Object) */) {
                        if ((JSGuards.isJSObject(arg0Value_))) {
                            doUncachedKey(arg0Value_, arg1Value_, arg2Value);
                            return;
                        }
                    }
                }
            }
            if ((state & 0b100) != 0 /* is-active doFallback(Object, Object, Object) */) {
                if (fallbackGuard_(arg0Value, arg1Value, arg2Value)) {
                    doFallback(arg0Value, arg1Value, arg2Value);
                    return;
                }
            }
        }
        CompilerDirectives.transferToInterpreterAndInvalidate();
        executeAndSpecialize(arg0Value, arg1Value, arg2Value);
        return;
    }

    private void executeAndSpecialize(Object arg0Value, Object arg1Value, Object arg2Value) {
        Lock lock = getLock();
        boolean hasLock = true;
        lock.lock();
        int state = state_;
        int exclude = exclude_;
        try {
            if (JSTypes.isDynamicObject(arg0Value)) {
                DynamicObject arg0Value_ = (DynamicObject) arg0Value;
                if (arg1Value instanceof HiddenKey) {
                    HiddenKey arg1Value_ = (HiddenKey) arg1Value;
                    if ((exclude) == 0 /* is-not-excluded doCachedKey(DynamicObject, HiddenKey, Object, HiddenKey, HasHiddenKeyCacheNode, PropertySetNode) */) {
                        CachedKeyData s1_ = this.cachedKey_cache;
                        boolean CachedKey_duplicateFound_ = false;
                        if ((state & 0b1) != 0 /* is-active doCachedKey(DynamicObject, HiddenKey, Object, HiddenKey, HasHiddenKeyCacheNode, PropertySetNode) */) {
                            if ((arg1Value_ == s1_.cachedKey_) && (JSGuards.isJSObject(arg0Value_))) {
                                CachedKey_duplicateFound_ = true;
                            }
                        }
                        if (!CachedKey_duplicateFound_) {
                            if ((JSGuards.isJSObject(arg0Value_)) && ((state & 0b1)) == 0 /* is-not-active doCachedKey(DynamicObject, HiddenKey, Object, HiddenKey, HasHiddenKeyCacheNode, PropertySetNode) */) {
                                // assert (arg1Value_ == s1_.cachedKey_);
                                s1_ = super.insert(new CachedKeyData());
                                s1_.cachedKey_ = (arg1Value_);
                                s1_.hasNode_ = s1_.insertAccessor((HasHiddenKeyCacheNode.create(arg1Value_)));
                                s1_.setNode_ = s1_.insertAccessor((PropertySetNode.createSetHidden(arg1Value_, context)));
                                this.cachedKey_cache = s1_;
                                this.state_ = state = state | 0b1 /* add-active doCachedKey(DynamicObject, HiddenKey, Object, HiddenKey, HasHiddenKeyCacheNode, PropertySetNode) */;
                                CachedKey_duplicateFound_ = true;
                            }
                        }
                        if (CachedKey_duplicateFound_) {
                            lock.unlock();
                            hasLock = false;
                            doCachedKey(arg0Value_, arg1Value_, arg2Value, s1_.cachedKey_, s1_.hasNode_, s1_.setNode_);
                            return;
                        }
                    }
                    if ((JSGuards.isJSObject(arg0Value_))) {
                        this.exclude_ = exclude = exclude | 0b1 /* add-excluded doCachedKey(DynamicObject, HiddenKey, Object, HiddenKey, HasHiddenKeyCacheNode, PropertySetNode) */;
                        this.cachedKey_cache = null;
                        state = state & 0xfffffffe /* remove-active doCachedKey(DynamicObject, HiddenKey, Object, HiddenKey, HasHiddenKeyCacheNode, PropertySetNode) */;
                        this.state_ = state = state | 0b10 /* add-active doUncachedKey(DynamicObject, HiddenKey, Object) */;
                        lock.unlock();
                        hasLock = false;
                        doUncachedKey(arg0Value_, arg1Value_, arg2Value);
                        return;
                    }
                }
            }
            this.state_ = state = state | 0b100 /* add-active doFallback(Object, Object, Object) */;
            lock.unlock();
            hasLock = false;
            doFallback(arg0Value, arg1Value, arg2Value);
            return;
        } finally {
            if (hasLock) {
                lock.unlock();
            }
        }
    }

    @Override
    public NodeCost getCost() {
        int state = state_;
        if (state == 0b0) {
            return NodeCost.UNINITIALIZED;
        } else if ((state & (state - 1)) == 0 /* is-single-active  */) {
            return NodeCost.MONOMORPHIC;
        }
        return NodeCost.POLYMORPHIC;
    }

    @Override
    public Introspection getIntrospectionData() {
        Object[] data = new Object[4];
        Object[] s;
        data[0] = 0;
        int state = state_;
        int exclude = exclude_;
        s = new Object[3];
        s[0] = "doCachedKey";
        if ((state & 0b1) != 0 /* is-active doCachedKey(DynamicObject, HiddenKey, Object, HiddenKey, HasHiddenKeyCacheNode, PropertySetNode) */) {
            s[1] = (byte)0b01 /* active */;
            ArrayList<Object> cached = new ArrayList<>();
            CachedKeyData s1_ = this.cachedKey_cache;
            if (s1_ != null) {
                cached.add(Arrays.asList(s1_.cachedKey_, s1_.hasNode_, s1_.setNode_));
            }
            s[2] = cached;
        } else if (exclude != 0 /* is-excluded doCachedKey(DynamicObject, HiddenKey, Object, HiddenKey, HasHiddenKeyCacheNode, PropertySetNode) */) {
            s[1] = (byte)0b10 /* excluded */;
        } else {
            s[1] = (byte)0b00 /* inactive */;
        }
        data[1] = s;
        s = new Object[3];
        s[0] = "doUncachedKey";
        if ((state & 0b10) != 0 /* is-active doUncachedKey(DynamicObject, HiddenKey, Object) */) {
            s[1] = (byte)0b01 /* active */;
        } else {
            s[1] = (byte)0b00 /* inactive */;
        }
        data[2] = s;
        s = new Object[3];
        s[0] = "doFallback";
        if ((state & 0b100) != 0 /* is-active doFallback(Object, Object, Object) */) {
            s[1] = (byte)0b01 /* active */;
        } else {
            s[1] = (byte)0b00 /* inactive */;
        }
        data[3] = s;
        return Provider.create(data);
    }

    private static boolean fallbackGuard_(Object arg0Value, Object arg1Value, Object arg2Value) {
        if (JSTypes.isDynamicObject(arg0Value) && arg1Value instanceof HiddenKey) {
            DynamicObject arg0Value_ = (DynamicObject) arg0Value;
            if ((JSGuards.isJSObject(arg0Value_))) {
                return false;
            }
        }
        return true;
    }

    public static PrivateFieldAddNode create(JSContext context) {
        return new PrivateFieldAddNodeGen(context);
    }

    @GeneratedBy(PrivateFieldAddNode.class)
    private static final class CachedKeyData extends Node {

        @CompilationFinal HiddenKey cachedKey_;
        @Child HasHiddenKeyCacheNode hasNode_;
        @Child PropertySetNode setNode_;

        CachedKeyData() {
        }

        @Override
        public NodeCost getCost() {
            return NodeCost.NONE;
        }

        <T extends Node> T insertAccessor(T node) {
            return super.insert(node);
        }

    }
}
