// CheckStyle: start generated
package com.oracle.truffle.js.nodes.access;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.CompilerDirectives.CompilationFinal;
import com.oracle.truffle.api.dsl.GeneratedBy;
import com.oracle.truffle.api.dsl.Introspection;
import com.oracle.truffle.api.dsl.Introspection.Provider;
import com.oracle.truffle.api.nodes.ExplodeLoop;
import com.oracle.truffle.api.nodes.NodeCost;
import com.oracle.truffle.api.object.DynamicObject;
import com.oracle.truffle.api.object.Shape;
import com.oracle.truffle.api.profiles.ConditionProfile;
import com.oracle.truffle.js.nodes.JSGuards;
import com.oracle.truffle.js.nodes.JSTypes;
import com.oracle.truffle.js.nodes.access.IsJSObjectNode;
import com.oracle.truffle.js.runtime.builtins.JSClass;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.concurrent.locks.Lock;

@GeneratedBy(IsJSObjectNode.class)
public final class IsJSObjectNodeGen extends IsJSObjectNode implements Provider {

    @CompilationFinal private int state_;
    @CompilationFinal private int exclude_;
    @CompilationFinal private IsObjectShapeData isObjectShape_cache;
    @CompilationFinal private IsObjectJSClassData isObjectJSClass_cache;
    @CompilationFinal private ConditionProfile isObject_resultProfile_;

    private IsJSObjectNodeGen(boolean includeNullUndefined) {
        super(includeNullUndefined);
    }

    @ExplodeLoop
    @Override
    public boolean executeBoolean(Object arg0Value) {
        int state = state_;
        if ((state & 0b11) != 0 /* is-active isObjectShape(DynamicObject, Shape, boolean) || isObjectJSClass(DynamicObject, JSClass, boolean) */ && JSTypes.isDynamicObject(arg0Value)) {
            DynamicObject arg0Value_ = (DynamicObject) arg0Value;
            if ((state & 0b1) != 0 /* is-active isObjectShape(DynamicObject, Shape, boolean) */) {
                IsObjectShapeData s1_ = this.isObjectShape_cache;
                while (s1_ != null) {
                    if ((s1_.cachedShape_.check(arg0Value_))) {
                        return IsJSObjectNode.isObjectShape(arg0Value_, s1_.cachedShape_, s1_.cachedResult_);
                    }
                    s1_ = s1_.next_;
                }
            }
            if ((state & 0b10) != 0 /* is-active isObjectJSClass(DynamicObject, JSClass, boolean) */) {
                IsObjectJSClassData s2_ = this.isObjectJSClass_cache;
                while (s2_ != null) {
                    assert (s2_.cachedClass_ != null);
                    if ((s2_.cachedClass_.isInstance(arg0Value_))) {
                        return IsJSObjectNode.isObjectJSClass(arg0Value_, s2_.cachedClass_, s2_.cachedResult_);
                    }
                    s2_ = s2_.next_;
                }
            }
        }
        if ((state & 0b100) != 0 /* is-active isObject(Object, ConditionProfile) */) {
            return IsJSObjectNode.isObject(arg0Value, this.isObject_resultProfile_);
        }
        CompilerDirectives.transferToInterpreterAndInvalidate();
        return executeAndSpecialize(arg0Value);
    }

    private boolean executeAndSpecialize(Object arg0Value) {
        Lock lock = getLock();
        boolean hasLock = true;
        lock.lock();
        int state = state_;
        int exclude = exclude_;
        try {
            if (JSTypes.isDynamicObject(arg0Value)) {
                DynamicObject arg0Value_ = (DynamicObject) arg0Value;
                if (((exclude & 0b1)) == 0 /* is-not-excluded isObjectShape(DynamicObject, Shape, boolean) */) {
                    int count1_ = 0;
                    IsObjectShapeData s1_ = this.isObjectShape_cache;
                    if ((state & 0b1) != 0 /* is-active isObjectShape(DynamicObject, Shape, boolean) */) {
                        while (s1_ != null) {
                            if ((s1_.cachedShape_.check(arg0Value_))) {
                                break;
                            }
                            s1_ = s1_.next_;
                            count1_++;
                        }
                    }
                    if (s1_ == null) {
                        {
                            Shape cachedShape__ = (arg0Value_.getShape());
                            if ((cachedShape__.check(arg0Value_)) && count1_ < (IsJSObjectNode.MAX_SHAPE_COUNT)) {
                                s1_ = new IsObjectShapeData(isObjectShape_cache);
                                s1_.cachedShape_ = cachedShape__;
                                s1_.cachedResult_ = (guardIsJSObject(arg0Value_));
                                this.isObjectShape_cache = s1_;
                                this.state_ = state = state | 0b1 /* add-active isObjectShape(DynamicObject, Shape, boolean) */;
                            }
                        }
                    }
                    if (s1_ != null) {
                        lock.unlock();
                        hasLock = false;
                        return IsJSObjectNode.isObjectShape(arg0Value_, s1_.cachedShape_, s1_.cachedResult_);
                    }
                }
                if (((exclude & 0b10)) == 0 /* is-not-excluded isObjectJSClass(DynamicObject, JSClass, boolean) */) {
                    int count2_ = 0;
                    IsObjectJSClassData s2_ = this.isObjectJSClass_cache;
                    if ((state & 0b10) != 0 /* is-active isObjectJSClass(DynamicObject, JSClass, boolean) */) {
                        while (s2_ != null) {
                            assert (s2_.cachedClass_ != null);
                            if ((s2_.cachedClass_.isInstance(arg0Value_))) {
                                break;
                            }
                            s2_ = s2_.next_;
                            count2_++;
                        }
                    }
                    if (s2_ == null) {
                        {
                            JSClass cachedClass__ = (JSGuards.getJSClassChecked(arg0Value_));
                            if ((cachedClass__ != null) && (cachedClass__.isInstance(arg0Value_)) && count2_ < (IsJSObjectNode.MAX_JSCLASS_COUNT)) {
                                s2_ = new IsObjectJSClassData(isObjectJSClass_cache);
                                s2_.cachedClass_ = cachedClass__;
                                s2_.cachedResult_ = (guardIsJSObject(arg0Value_));
                                this.isObjectJSClass_cache = s2_;
                                this.exclude_ = exclude = exclude | 0b1 /* add-excluded isObjectShape(DynamicObject, Shape, boolean) */;
                                this.isObjectShape_cache = null;
                                state = state & 0xfffffffe /* remove-active isObjectShape(DynamicObject, Shape, boolean) */;
                                this.state_ = state = state | 0b10 /* add-active isObjectJSClass(DynamicObject, JSClass, boolean) */;
                            }
                        }
                    }
                    if (s2_ != null) {
                        lock.unlock();
                        hasLock = false;
                        return IsJSObjectNode.isObjectJSClass(arg0Value_, s2_.cachedClass_, s2_.cachedResult_);
                    }
                }
            }
            this.isObject_resultProfile_ = (ConditionProfile.createBinaryProfile());
            this.exclude_ = exclude = exclude | 0b11 /* add-excluded isObjectShape(DynamicObject, Shape, boolean), isObjectJSClass(DynamicObject, JSClass, boolean) */;
            this.isObjectShape_cache = null;
            this.isObjectJSClass_cache = null;
            state = state & 0xfffffffc /* remove-active isObjectShape(DynamicObject, Shape, boolean), isObjectJSClass(DynamicObject, JSClass, boolean) */;
            this.state_ = state = state | 0b100 /* add-active isObject(Object, ConditionProfile) */;
            lock.unlock();
            hasLock = false;
            return IsJSObjectNode.isObject(arg0Value, this.isObject_resultProfile_);
        } finally {
            if (hasLock) {
                lock.unlock();
            }
        }
    }

    @Override
    public NodeCost getCost() {
        int state = state_;
        if (state == 0b0) {
            return NodeCost.UNINITIALIZED;
        } else if ((state & (state - 1)) == 0 /* is-single-active  */) {
            IsObjectShapeData s1_ = this.isObjectShape_cache;
            IsObjectJSClassData s2_ = this.isObjectJSClass_cache;
            if ((s1_ == null || s1_.next_ == null) && (s2_ == null || s2_.next_ == null)) {
                return NodeCost.MONOMORPHIC;
            }
        }
        return NodeCost.POLYMORPHIC;
    }

    @Override
    public Introspection getIntrospectionData() {
        Object[] data = new Object[4];
        Object[] s;
        data[0] = 0;
        int state = state_;
        int exclude = exclude_;
        s = new Object[3];
        s[0] = "isObjectShape";
        if ((state & 0b1) != 0 /* is-active isObjectShape(DynamicObject, Shape, boolean) */) {
            s[1] = (byte)0b01 /* active */;
            ArrayList<Object> cached = new ArrayList<>();
            IsObjectShapeData s1_ = this.isObjectShape_cache;
            while (s1_ != null) {
                cached.add(Arrays.asList(s1_.cachedShape_, s1_.cachedResult_));
                s1_ = s1_.next_;
            }
            s[2] = cached;
        } else if ((exclude & 0b1) != 0 /* is-excluded isObjectShape(DynamicObject, Shape, boolean) */) {
            s[1] = (byte)0b10 /* excluded */;
        } else {
            s[1] = (byte)0b00 /* inactive */;
        }
        data[1] = s;
        s = new Object[3];
        s[0] = "isObjectJSClass";
        if ((state & 0b10) != 0 /* is-active isObjectJSClass(DynamicObject, JSClass, boolean) */) {
            s[1] = (byte)0b01 /* active */;
            ArrayList<Object> cached = new ArrayList<>();
            IsObjectJSClassData s2_ = this.isObjectJSClass_cache;
            while (s2_ != null) {
                cached.add(Arrays.asList(s2_.cachedClass_, s2_.cachedResult_));
                s2_ = s2_.next_;
            }
            s[2] = cached;
        } else if ((exclude & 0b10) != 0 /* is-excluded isObjectJSClass(DynamicObject, JSClass, boolean) */) {
            s[1] = (byte)0b10 /* excluded */;
        } else {
            s[1] = (byte)0b00 /* inactive */;
        }
        data[2] = s;
        s = new Object[3];
        s[0] = "isObject";
        if ((state & 0b100) != 0 /* is-active isObject(Object, ConditionProfile) */) {
            s[1] = (byte)0b01 /* active */;
            ArrayList<Object> cached = new ArrayList<>();
            cached.add(Arrays.asList(this.isObject_resultProfile_));
            s[2] = cached;
        } else {
            s[1] = (byte)0b00 /* inactive */;
        }
        data[3] = s;
        return Provider.create(data);
    }

    public static IsJSObjectNode create(boolean includeNullUndefined) {
        return new IsJSObjectNodeGen(includeNullUndefined);
    }

    @GeneratedBy(IsJSObjectNode.class)
    private static final class IsObjectShapeData {

        @CompilationFinal IsObjectShapeData next_;
        @CompilationFinal Shape cachedShape_;
        @CompilationFinal boolean cachedResult_;

        IsObjectShapeData(IsObjectShapeData next_) {
            this.next_ = next_;
        }

    }
    @GeneratedBy(IsJSObjectNode.class)
    private static final class IsObjectJSClassData {

        @CompilationFinal IsObjectJSClassData next_;
        @CompilationFinal JSClass cachedClass_;
        @CompilationFinal boolean cachedResult_;

        IsObjectJSClassData(IsObjectJSClassData next_) {
            this.next_ = next_;
        }

    }
}
