// CheckStyle: start generated
package com.oracle.truffle.js.nodes.access;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.CompilerDirectives.CompilationFinal;
import com.oracle.truffle.api.dsl.GeneratedBy;
import com.oracle.truffle.api.dsl.Introspection;
import com.oracle.truffle.api.dsl.Introspection.Provider;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.nodes.NodeCost;
import com.oracle.truffle.js.nodes.JavaScriptNode;
import com.oracle.truffle.js.nodes.access.InitializeInstanceFieldsNode;
import com.oracle.truffle.js.runtime.JSContext;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.concurrent.locks.Lock;

@GeneratedBy(InitializeInstanceFieldsNode.class)
@SuppressWarnings("unused")
public final class InitializeInstanceFieldsNodeGen extends InitializeInstanceFieldsNode implements Provider {

    @CompilationFinal private int state_;
    @Child private ObjectData object_cache;

    private InitializeInstanceFieldsNodeGen(JSContext context, JavaScriptNode targetNode, JavaScriptNode sourceNode) {
        super(context, targetNode, sourceNode);
    }

    @Override
    public Object executeEvaluated(Object targetNodeValue, Object[][] sourceNodeValue) {
        int state = state_;
        if (state != 0 /* is-active doObject(Object, Object[][], DefineFieldNode[]) || doOther(Object, Object) */) {
            if ((state & 0b1) != 0 /* is-active doObject(Object, Object[][], DefineFieldNode[]) */) {
                ObjectData s1_ = this.object_cache;
                if (s1_ != null) {
                    return InitializeInstanceFieldsNode.doObject(targetNodeValue, sourceNodeValue, s1_.fieldNodes_);
                }
            }
            if ((state & 0b10) != 0 /* is-active doOther(Object, Object) */) {
                if (fallbackGuard_(state, targetNodeValue, sourceNodeValue)) {
                    return InitializeInstanceFieldsNode.doOther(targetNodeValue, sourceNodeValue);
                }
            }
        }
        CompilerDirectives.transferToInterpreterAndInvalidate();
        return executeAndSpecialize(targetNodeValue, sourceNodeValue);
    }

    @Override
    public Object execute(VirtualFrame frameValue) {
        int state = state_;
        Object targetNodeValue_ = super.targetNode.execute(frameValue);
        Object sourceNodeValue_ = super.sourceNode.execute(frameValue);
        if (state != 0 /* is-active doObject(Object, Object[][], DefineFieldNode[]) || doOther(Object, Object) */) {
            if ((state & 0b1) != 0 /* is-active doObject(Object, Object[][], DefineFieldNode[]) */ && sourceNodeValue_ instanceof Object[][]) {
                Object[][] sourceNodeValue__ = (Object[][]) sourceNodeValue_;
                ObjectData s1_ = this.object_cache;
                if (s1_ != null) {
                    return InitializeInstanceFieldsNode.doObject(targetNodeValue_, sourceNodeValue__, s1_.fieldNodes_);
                }
            }
            if ((state & 0b10) != 0 /* is-active doOther(Object, Object) */) {
                if (fallbackGuard_(state, targetNodeValue_, sourceNodeValue_)) {
                    return InitializeInstanceFieldsNode.doOther(targetNodeValue_, sourceNodeValue_);
                }
            }
        }
        CompilerDirectives.transferToInterpreterAndInvalidate();
        return executeAndSpecialize(targetNodeValue_, sourceNodeValue_);
    }

    @Override
    public void executeVoid(VirtualFrame frameValue) {
        execute(frameValue);
        return;
    }

    private Object executeAndSpecialize(Object targetNodeValue, Object sourceNodeValue) {
        Lock lock = getLock();
        boolean hasLock = true;
        lock.lock();
        int state = state_;
        try {
            if (sourceNodeValue instanceof Object[][]) {
                Object[][] sourceNodeValue_ = (Object[][]) sourceNodeValue;
                ObjectData s1_ = super.insert(new ObjectData());
                s1_.fieldNodes_ = s1_.insertAccessor((InitializeInstanceFieldsNode.createFieldNodes(sourceNodeValue_, context)));
                this.object_cache = s1_;
                this.state_ = state = state | 0b1 /* add-active doObject(Object, Object[][], DefineFieldNode[]) */;
                lock.unlock();
                hasLock = false;
                return InitializeInstanceFieldsNode.doObject(targetNodeValue, sourceNodeValue_, s1_.fieldNodes_);
            }
            this.state_ = state = state | 0b10 /* add-active doOther(Object, Object) */;
            lock.unlock();
            hasLock = false;
            return InitializeInstanceFieldsNode.doOther(targetNodeValue, sourceNodeValue);
        } finally {
            if (hasLock) {
                lock.unlock();
            }
        }
    }

    @Override
    public NodeCost getCost() {
        int state = state_;
        if (state == 0b0) {
            return NodeCost.UNINITIALIZED;
        } else if ((state & (state - 1)) == 0 /* is-single-active  */) {
            return NodeCost.MONOMORPHIC;
        }
        return NodeCost.POLYMORPHIC;
    }

    @Override
    public Introspection getIntrospectionData() {
        Object[] data = new Object[3];
        Object[] s;
        data[0] = 0;
        int state = state_;
        s = new Object[3];
        s[0] = "doObject";
        if ((state & 0b1) != 0 /* is-active doObject(Object, Object[][], DefineFieldNode[]) */) {
            s[1] = (byte)0b01 /* active */;
            ArrayList<Object> cached = new ArrayList<>();
            ObjectData s1_ = this.object_cache;
            if (s1_ != null) {
                cached.add(Arrays.asList(s1_.fieldNodes_));
            }
            s[2] = cached;
        } else {
            s[1] = (byte)0b00 /* inactive */;
        }
        data[1] = s;
        s = new Object[3];
        s[0] = "doOther";
        if ((state & 0b10) != 0 /* is-active doOther(Object, Object) */) {
            s[1] = (byte)0b01 /* active */;
        } else {
            s[1] = (byte)0b00 /* inactive */;
        }
        data[2] = s;
        return Provider.create(data);
    }

    private static boolean fallbackGuard_(int state, Object targetNodeValue, Object sourceNodeValue) {
        if (((state & 0b1)) == 0 /* is-not-active doObject(Object, Object[][], DefineFieldNode[]) */ && sourceNodeValue instanceof Object[][]) {
            return false;
        }
        return true;
    }

    public static InitializeInstanceFieldsNode create(JSContext context, JavaScriptNode targetNode, JavaScriptNode sourceNode) {
        return new InitializeInstanceFieldsNodeGen(context, targetNode, sourceNode);
    }

    @GeneratedBy(InitializeInstanceFieldsNode.class)
    private static final class ObjectData extends Node {

        @Children DefineFieldNode[] fieldNodes_;

        ObjectData() {
        }

        @Override
        public NodeCost getCost() {
            return NodeCost.NONE;
        }

        <T extends Node> T[] insertAccessor(T[] node) {
            return super.insert(node);
        }

    }
}
