// CheckStyle: start generated
package com.oracle.truffle.js.nodes.access;

import com.oracle.truffle.api.Assumption;
import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.CompilerDirectives.CompilationFinal;
import com.oracle.truffle.api.dsl.GeneratedBy;
import com.oracle.truffle.api.dsl.Introspection;
import com.oracle.truffle.api.dsl.Introspection.Provider;
import com.oracle.truffle.api.nodes.ExplodeLoop;
import com.oracle.truffle.api.nodes.NodeCost;
import com.oracle.truffle.api.object.DynamicObject;
import com.oracle.truffle.api.object.Property;
import com.oracle.truffle.api.object.Shape;
import com.oracle.truffle.js.nodes.access.InitErrorObjectNode;
import com.oracle.truffle.js.nodes.access.InitErrorObjectNode.DefineStackPropertyNode;
import com.oracle.truffle.js.runtime.builtins.JSError;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.concurrent.locks.Lock;

@GeneratedBy(InitErrorObjectNode.class)
public final class InitErrorObjectNodeFactory {

    @GeneratedBy(DefineStackPropertyNode.class)
    static final class DefineStackPropertyNodeGen extends DefineStackPropertyNode implements Provider {

        @CompilationFinal private int state_;
        @CompilationFinal private int exclude_;
        @CompilationFinal private CachedData cached_cache;

        private DefineStackPropertyNodeGen() {
        }

        @ExplodeLoop
        @Override
        void execute(DynamicObject arg0Value) {
            int state = state_;
            if (state != 0 /* is-active doCached(DynamicObject, Shape, Shape, Property) || doUncached(DynamicObject) */) {
                if ((state & 0b1) != 0 /* is-active doCached(DynamicObject, Shape, Shape, Property) */) {
                    CachedData s1_ = this.cached_cache;
                    while (s1_ != null) {
                        if (!Assumption.isValidAssumption(s1_.assumption0_) || !Assumption.isValidAssumption(s1_.assumption1_)) {
                            CompilerDirectives.transferToInterpreterAndInvalidate();
                            removeCached_(s1_);
                            executeAndSpecialize(arg0Value);
                            return;
                        }
                        assert (s1_.shapeAfter_ != null);
                        if ((arg0Value.getShape() == s1_.cachedShape_)) {
                            doCached(arg0Value, s1_.cachedShape_, s1_.shapeAfter_, s1_.cachedProperty_);
                            return;
                        }
                        s1_ = s1_.next_;
                    }
                }
                if ((state & 0b10) != 0 /* is-active doUncached(DynamicObject) */) {
                    doUncached(arg0Value);
                    return;
                }
            }
            CompilerDirectives.transferToInterpreterAndInvalidate();
            executeAndSpecialize(arg0Value);
            return;
        }

        private void executeAndSpecialize(DynamicObject arg0Value) {
            Lock lock = getLock();
            boolean hasLock = true;
            lock.lock();
            int state = state_;
            int exclude = exclude_;
            try {
                if ((exclude) == 0 /* is-not-excluded doCached(DynamicObject, Shape, Shape, Property) */) {
                    int count1_ = 0;
                    CachedData s1_ = this.cached_cache;
                    if ((state & 0b1) != 0 /* is-active doCached(DynamicObject, Shape, Shape, Property) */) {
                        while (s1_ != null) {
                            assert (s1_.shapeAfter_ != null);
                            if ((arg0Value.getShape() == s1_.cachedShape_) && (s1_.assumption0_ == null || Assumption.isValidAssumption(s1_.assumption0_)) && (s1_.assumption1_ == null || Assumption.isValidAssumption(s1_.assumption1_))) {
                                break;
                            }
                            s1_ = s1_.next_;
                            count1_++;
                        }
                    }
                    if (s1_ == null) {
                        {
                            Shape cachedShape__ = (arg0Value.getShape());
                            Shape shapeAfter__ = (DefineStackPropertyNode.addStackProperty(cachedShape__));
                            if ((shapeAfter__ != null) && (arg0Value.getShape() == cachedShape__)) {
                                Assumption assumption0 = (cachedShape__.getValidAssumption());
                                if (Assumption.isValidAssumption(assumption0)) {
                                    Assumption assumption1 = (shapeAfter__.getValidAssumption());
                                    if (Assumption.isValidAssumption(assumption1)) {
                                        if (count1_ < (3)) {
                                            s1_ = new CachedData(cached_cache);
                                            s1_.cachedShape_ = cachedShape__;
                                            s1_.shapeAfter_ = shapeAfter__;
                                            s1_.cachedProperty_ = (shapeAfter__.getProperty(JSError.STACK_NAME));
                                            s1_.assumption0_ = assumption0;
                                            s1_.assumption1_ = assumption1;
                                            this.cached_cache = s1_;
                                            this.state_ = state = state | 0b1 /* add-active doCached(DynamicObject, Shape, Shape, Property) */;
                                        }
                                    }
                                }
                            }
                        }
                    }
                    if (s1_ != null) {
                        lock.unlock();
                        hasLock = false;
                        doCached(arg0Value, s1_.cachedShape_, s1_.shapeAfter_, s1_.cachedProperty_);
                        return;
                    }
                }
                this.exclude_ = exclude = exclude | 0b1 /* add-excluded doCached(DynamicObject, Shape, Shape, Property) */;
                this.cached_cache = null;
                state = state & 0xfffffffe /* remove-active doCached(DynamicObject, Shape, Shape, Property) */;
                this.state_ = state = state | 0b10 /* add-active doUncached(DynamicObject) */;
                lock.unlock();
                hasLock = false;
                doUncached(arg0Value);
                return;
            } finally {
                if (hasLock) {
                    lock.unlock();
                }
            }
        }

        @Override
        public NodeCost getCost() {
            int state = state_;
            if (state == 0b0) {
                return NodeCost.UNINITIALIZED;
            } else if ((state & (state - 1)) == 0 /* is-single-active  */) {
                CachedData s1_ = this.cached_cache;
                if ((s1_ == null || s1_.next_ == null)) {
                    return NodeCost.MONOMORPHIC;
                }
            }
            return NodeCost.POLYMORPHIC;
        }

        void removeCached_(Object s1_) {
            Lock lock = getLock();
            lock.lock();
            try {
                CachedData prev = null;
                CachedData cur = this.cached_cache;
                while (cur != null) {
                    if (cur == s1_) {
                        if (prev == null) {
                            this.cached_cache = cur.next_;
                        } else {
                            prev.next_ = cur.next_;
                        }
                        break;
                    }
                    prev = cur;
                    cur = cur.next_;
                }
                if (this.cached_cache == null) {
                    this.state_ = this.state_ & 0xfffffffe /* remove-active doCached(DynamicObject, Shape, Shape, Property) */;
                }
            } finally {
                lock.unlock();
            }
        }

        @Override
        public Introspection getIntrospectionData() {
            Object[] data = new Object[3];
            Object[] s;
            data[0] = 0;
            int state = state_;
            int exclude = exclude_;
            s = new Object[3];
            s[0] = "doCached";
            if ((state & 0b1) != 0 /* is-active doCached(DynamicObject, Shape, Shape, Property) */) {
                s[1] = (byte)0b01 /* active */;
                ArrayList<Object> cached = new ArrayList<>();
                CachedData s1_ = this.cached_cache;
                while (s1_ != null) {
                    cached.add(Arrays.asList(s1_.cachedShape_, s1_.shapeAfter_, s1_.cachedProperty_));
                    s1_ = s1_.next_;
                }
                s[2] = cached;
            } else if (exclude != 0 /* is-excluded doCached(DynamicObject, Shape, Shape, Property) */) {
                s[1] = (byte)0b10 /* excluded */;
            } else {
                s[1] = (byte)0b00 /* inactive */;
            }
            data[1] = s;
            s = new Object[3];
            s[0] = "doUncached";
            if ((state & 0b10) != 0 /* is-active doUncached(DynamicObject) */) {
                s[1] = (byte)0b01 /* active */;
            } else {
                s[1] = (byte)0b00 /* inactive */;
            }
            data[2] = s;
            return Provider.create(data);
        }

        public static DefineStackPropertyNode create() {
            return new DefineStackPropertyNodeGen();
        }

        @GeneratedBy(DefineStackPropertyNode.class)
        private static final class CachedData {

            @CompilationFinal CachedData next_;
            @CompilationFinal Shape cachedShape_;
            @CompilationFinal Shape shapeAfter_;
            @CompilationFinal Property cachedProperty_;
            @CompilationFinal Assumption assumption0_;
            @CompilationFinal Assumption assumption1_;

            CachedData(CachedData next_) {
                this.next_ = next_;
            }

        }
    }
}
