// CheckStyle: start generated
package com.oracle.truffle.js.builtins.math;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.CompilerDirectives.CompilationFinal;
import com.oracle.truffle.api.dsl.GeneratedBy;
import com.oracle.truffle.api.dsl.Introspection;
import com.oracle.truffle.api.dsl.UnsupportedSpecializationException;
import com.oracle.truffle.api.dsl.Introspection.Provider;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.nodes.NodeCost;
import com.oracle.truffle.api.nodes.UnexpectedResultException;
import com.oracle.truffle.api.profiles.ConditionProfile;
import com.oracle.truffle.js.builtins.math.MinNode;
import com.oracle.truffle.js.nodes.JSTypesGen;
import com.oracle.truffle.js.nodes.JavaScriptNode;
import com.oracle.truffle.js.nodes.cast.JSToNumberNode;
import com.oracle.truffle.js.nodes.function.JSBuiltin;
import com.oracle.truffle.js.runtime.JSContext;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.concurrent.locks.Lock;

@GeneratedBy(MinNode.class)
public final class MinNodeGen extends MinNode implements Provider {

    @Child private JavaScriptNode arguments0_;
    @CompilationFinal private int state_;
    @CompilationFinal private ConditionProfile min2ParamInt_minProfile_;
    @Child private Min2ParamData min2Param_cache;

    private MinNodeGen(JSContext context, JSBuiltin builtin, JavaScriptNode[] arguments) {
        super(context, builtin);
        this.arguments0_ = arguments != null && 0 < arguments.length ? arguments[0] : null;
    }

    @Override
    public JavaScriptNode[] getArguments() {
        return new JavaScriptNode[] {this.arguments0_};
    }

    @Override
    public Object execute(VirtualFrame frameValue) {
        int state = state_;
        Object arguments0Value_ = this.arguments0_.execute(frameValue);
        if (state != 0 /* is-active min0Param(Object[]) || min1Param(Object[]) || min2ParamInt(Object[], ConditionProfile) || min2Param(Object[], ConditionProfile, ConditionProfile, JSToNumberNode, JSToNumberNode) || min(Object[]) */ && arguments0Value_ instanceof Object[]) {
            Object[] arguments0Value__ = (Object[]) arguments0Value_;
            if ((state & 0b1) != 0 /* is-active min0Param(Object[]) */) {
                if ((arguments0Value__.length == 0)) {
                    return MinNode.min0Param(arguments0Value__);
                }
            }
            if ((state & 0b10) != 0 /* is-active min1Param(Object[]) */) {
                if ((arguments0Value__.length == 1)) {
                    return min1Param(arguments0Value__);
                }
            }
            if ((state & 0b100) != 0 /* is-active min2ParamInt(Object[], ConditionProfile) */) {
                if ((arguments0Value__.length == 2) && (MinNode.caseIntInt(arguments0Value__))) {
                    return MinNode.min2ParamInt(arguments0Value__, this.min2ParamInt_minProfile_);
                }
            }
            if ((state & 0b1000) != 0 /* is-active min2Param(Object[], ConditionProfile, ConditionProfile, JSToNumberNode, JSToNumberNode) */) {
                Min2ParamData s4_ = this.min2Param_cache;
                if (s4_ != null) {
                    if ((arguments0Value__.length == 2) && (!(MinNode.caseIntInt(arguments0Value__)))) {
                        return min2Param(arguments0Value__, s4_.isIntBranch_, s4_.minProfile_, s4_.toNumber1Node_, s4_.toNumber2Node_);
                    }
                }
            }
            if ((state & 0b10000) != 0 /* is-active min(Object[]) */) {
                if ((arguments0Value__.length >= 3)) {
                    return min(arguments0Value__);
                }
            }
        }
        CompilerDirectives.transferToInterpreterAndInvalidate();
        return executeAndSpecialize(arguments0Value_);
    }

    @Override
    public double executeDouble(VirtualFrame frameValue) throws UnexpectedResultException {
        int state = state_;
        if ((state & 0b1000) != 0 /* is-active min2Param(Object[], ConditionProfile, ConditionProfile, JSToNumberNode, JSToNumberNode) */) {
            return JSTypesGen.expectDouble(execute(frameValue));
        }
        Object arguments0Value_ = this.arguments0_.execute(frameValue);
        if ((state & 0b10011) != 0 /* is-active min0Param(Object[]) || min1Param(Object[]) || min(Object[]) */ && arguments0Value_ instanceof Object[]) {
            Object[] arguments0Value__ = (Object[]) arguments0Value_;
            if ((state & 0b1) != 0 /* is-active min0Param(Object[]) */) {
                if ((arguments0Value__.length == 0)) {
                    return MinNode.min0Param(arguments0Value__);
                }
            }
            if ((state & 0b10) != 0 /* is-active min1Param(Object[]) */) {
                if ((arguments0Value__.length == 1)) {
                    return min1Param(arguments0Value__);
                }
            }
            if ((state & 0b10000) != 0 /* is-active min(Object[]) */) {
                if ((arguments0Value__.length >= 3)) {
                    return min(arguments0Value__);
                }
            }
        }
        CompilerDirectives.transferToInterpreterAndInvalidate();
        return JSTypesGen.expectDouble(executeAndSpecialize(arguments0Value_));
    }

    @Override
    public int executeInt(VirtualFrame frameValue) throws UnexpectedResultException {
        int state = state_;
        if ((state & 0b1000) != 0 /* is-active min2Param(Object[], ConditionProfile, ConditionProfile, JSToNumberNode, JSToNumberNode) */) {
            return JSTypesGen.expectInteger(execute(frameValue));
        }
        Object arguments0Value_ = this.arguments0_.execute(frameValue);
        if ((state & 0b100) != 0 /* is-active min2ParamInt(Object[], ConditionProfile) */ && arguments0Value_ instanceof Object[]) {
            Object[] arguments0Value__ = (Object[]) arguments0Value_;
            if ((arguments0Value__.length == 2) && (MinNode.caseIntInt(arguments0Value__))) {
                return MinNode.min2ParamInt(arguments0Value__, this.min2ParamInt_minProfile_);
            }
        }
        CompilerDirectives.transferToInterpreterAndInvalidate();
        return JSTypesGen.expectInteger(executeAndSpecialize(arguments0Value_));
    }

    @Override
    public void executeVoid(VirtualFrame frameValue) {
        int state = state_;
        try {
            if ((state & 0b11011) == 0 /* only-active min2ParamInt(Object[], ConditionProfile) */ && state != 0  /* is-not min0Param(Object[]) && min1Param(Object[]) && min2ParamInt(Object[], ConditionProfile) && min2Param(Object[], ConditionProfile, ConditionProfile, JSToNumberNode, JSToNumberNode) && min(Object[]) */) {
                executeInt(frameValue);
                return;
            } else if ((state & 0b1100) == 0 /* only-active min0Param(Object[]) && min1Param(Object[]) && min(Object[]) */ && state != 0  /* is-not min0Param(Object[]) && min1Param(Object[]) && min2ParamInt(Object[], ConditionProfile) && min2Param(Object[], ConditionProfile, ConditionProfile, JSToNumberNode, JSToNumberNode) && min(Object[]) */) {
                executeDouble(frameValue);
                return;
            }
            execute(frameValue);
            return;
        } catch (UnexpectedResultException ex) {
            return;
        }
    }

    private Object executeAndSpecialize(Object arguments0Value) {
        Lock lock = getLock();
        boolean hasLock = true;
        lock.lock();
        int state = state_;
        try {
            if (arguments0Value instanceof Object[]) {
                Object[] arguments0Value_ = (Object[]) arguments0Value;
                if ((arguments0Value_.length == 0)) {
                    this.state_ = state = state | 0b1 /* add-active min0Param(Object[]) */;
                    lock.unlock();
                    hasLock = false;
                    return MinNode.min0Param(arguments0Value_);
                }
                if ((arguments0Value_.length == 1)) {
                    this.state_ = state = state | 0b10 /* add-active min1Param(Object[]) */;
                    lock.unlock();
                    hasLock = false;
                    return min1Param(arguments0Value_);
                }
                if ((arguments0Value_.length == 2) && (MinNode.caseIntInt(arguments0Value_))) {
                    this.min2ParamInt_minProfile_ = (ConditionProfile.createBinaryProfile());
                    this.state_ = state = state | 0b100 /* add-active min2ParamInt(Object[], ConditionProfile) */;
                    lock.unlock();
                    hasLock = false;
                    return MinNode.min2ParamInt(arguments0Value_, this.min2ParamInt_minProfile_);
                }
                if ((arguments0Value_.length == 2) && (!(MinNode.caseIntInt(arguments0Value_)))) {
                    Min2ParamData s4_ = super.insert(new Min2ParamData());
                    s4_.isIntBranch_ = (ConditionProfile.createBinaryProfile());
                    s4_.minProfile_ = (ConditionProfile.createBinaryProfile());
                    s4_.toNumber1Node_ = s4_.insertAccessor((JSToNumberNode.create()));
                    s4_.toNumber2Node_ = s4_.insertAccessor((JSToNumberNode.create()));
                    this.min2Param_cache = s4_;
                    this.state_ = state = state | 0b1000 /* add-active min2Param(Object[], ConditionProfile, ConditionProfile, JSToNumberNode, JSToNumberNode) */;
                    lock.unlock();
                    hasLock = false;
                    return min2Param(arguments0Value_, s4_.isIntBranch_, s4_.minProfile_, s4_.toNumber1Node_, s4_.toNumber2Node_);
                }
                if ((arguments0Value_.length >= 3)) {
                    this.state_ = state = state | 0b10000 /* add-active min(Object[]) */;
                    lock.unlock();
                    hasLock = false;
                    return min(arguments0Value_);
                }
            }
            throw new UnsupportedSpecializationException(this, new Node[] {this.arguments0_}, arguments0Value);
        } finally {
            if (hasLock) {
                lock.unlock();
            }
        }
    }

    @Override
    public NodeCost getCost() {
        int state = state_;
        if (state == 0b0) {
            return NodeCost.UNINITIALIZED;
        } else if ((state & (state - 1)) == 0 /* is-single-active  */) {
            return NodeCost.MONOMORPHIC;
        }
        return NodeCost.POLYMORPHIC;
    }

    @Override
    public Introspection getIntrospectionData() {
        Object[] data = new Object[6];
        Object[] s;
        data[0] = 0;
        int state = state_;
        s = new Object[3];
        s[0] = "min0Param";
        if ((state & 0b1) != 0 /* is-active min0Param(Object[]) */) {
            s[1] = (byte)0b01 /* active */;
        } else {
            s[1] = (byte)0b00 /* inactive */;
        }
        data[1] = s;
        s = new Object[3];
        s[0] = "min1Param";
        if ((state & 0b10) != 0 /* is-active min1Param(Object[]) */) {
            s[1] = (byte)0b01 /* active */;
        } else {
            s[1] = (byte)0b00 /* inactive */;
        }
        data[2] = s;
        s = new Object[3];
        s[0] = "min2ParamInt";
        if ((state & 0b100) != 0 /* is-active min2ParamInt(Object[], ConditionProfile) */) {
            s[1] = (byte)0b01 /* active */;
            ArrayList<Object> cached = new ArrayList<>();
            cached.add(Arrays.asList(this.min2ParamInt_minProfile_));
            s[2] = cached;
        } else {
            s[1] = (byte)0b00 /* inactive */;
        }
        data[3] = s;
        s = new Object[3];
        s[0] = "min2Param";
        if ((state & 0b1000) != 0 /* is-active min2Param(Object[], ConditionProfile, ConditionProfile, JSToNumberNode, JSToNumberNode) */) {
            s[1] = (byte)0b01 /* active */;
            ArrayList<Object> cached = new ArrayList<>();
            Min2ParamData s4_ = this.min2Param_cache;
            if (s4_ != null) {
                cached.add(Arrays.asList(s4_.isIntBranch_, s4_.minProfile_, s4_.toNumber1Node_, s4_.toNumber2Node_));
            }
            s[2] = cached;
        } else {
            s[1] = (byte)0b00 /* inactive */;
        }
        data[4] = s;
        s = new Object[3];
        s[0] = "min";
        if ((state & 0b10000) != 0 /* is-active min(Object[]) */) {
            s[1] = (byte)0b01 /* active */;
        } else {
            s[1] = (byte)0b00 /* inactive */;
        }
        data[5] = s;
        return Provider.create(data);
    }

    public static MinNode create(JSContext context, JSBuiltin builtin, JavaScriptNode[] arguments) {
        return new MinNodeGen(context, builtin, arguments);
    }

    @GeneratedBy(MinNode.class)
    private static final class Min2ParamData extends Node {

        @CompilationFinal ConditionProfile isIntBranch_;
        @CompilationFinal ConditionProfile minProfile_;
        @Child JSToNumberNode toNumber1Node_;
        @Child JSToNumberNode toNumber2Node_;

        Min2ParamData() {
        }

        @Override
        public NodeCost getCost() {
            return NodeCost.NONE;
        }

        <T extends Node> T insertAccessor(T node) {
            return super.insert(node);
        }

    }
}
