// CheckStyle: start generated
package com.oracle.truffle.js.builtins;

import com.oracle.truffle.api.Assumption;
import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.CompilerDirectives.CompilationFinal;
import com.oracle.truffle.api.dsl.GeneratedBy;
import com.oracle.truffle.api.dsl.Introspection;
import com.oracle.truffle.api.dsl.Introspection.Provider;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.nodes.NodeCost;
import com.oracle.truffle.js.builtins.RegExpBuiltins;
import com.oracle.truffle.js.builtins.RegExpBuiltins.GetStaticRegExpResultNode;
import com.oracle.truffle.js.builtins.RegExpBuiltins.JSRegExpStaticResultGetGroupNode;
import com.oracle.truffle.js.builtins.RegExpBuiltins.JSRegExpStaticResultInputNode;
import com.oracle.truffle.js.builtins.RegExpBuiltins.JSRegExpStaticResultLastParenNode;
import com.oracle.truffle.js.builtins.RegExpBuiltins.JSRegExpStaticResultLeftContextNode;
import com.oracle.truffle.js.builtins.RegExpBuiltins.JSRegExpStaticResultMultilineNode;
import com.oracle.truffle.js.builtins.RegExpBuiltins.JSRegExpStaticResultRightContextNode;
import com.oracle.truffle.js.nodes.JavaScriptNode;
import com.oracle.truffle.js.nodes.function.JSBuiltin;
import com.oracle.truffle.js.runtime.JSContext;
import com.oracle.truffle.js.runtime.util.TRegexUtil.TRegexResultAccessor;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.concurrent.locks.Lock;

@GeneratedBy(RegExpBuiltins.class)
@SuppressWarnings("unused")
public final class RegExpBuiltinsFactory {

    @GeneratedBy(GetStaticRegExpResultNode.class)
    static final class GetStaticRegExpResultNodeGen extends GetStaticRegExpResultNode {

        private GetStaticRegExpResultNodeGen(JSContext context) {
            super(context);
        }

        @Override
        Object execute() {
            return get();
        }

        @Override
        public NodeCost getCost() {
            return NodeCost.MONOMORPHIC;
        }

        public static GetStaticRegExpResultNode create(JSContext context) {
            return new GetStaticRegExpResultNodeGen(context);
        }

    }
    @GeneratedBy(JSRegExpStaticResultInputNode.class)
    static final class JSRegExpStaticResultInputNodeGen extends JSRegExpStaticResultInputNode implements Provider {

        private JSRegExpStaticResultInputNodeGen(JSContext context, JSBuiltin builtin, JavaScriptNode[] arguments) {
            super(context, builtin);
        }

        @Override
        public JavaScriptNode[] getArguments() {
            return new JavaScriptNode[] {};
        }

        @Override
        public Object execute(VirtualFrame frameValue) {
            return getInputProp();
        }

        @Override
        public void executeVoid(VirtualFrame frameValue) {
            execute(frameValue);
            return;
        }

        @Override
        public NodeCost getCost() {
            return NodeCost.MONOMORPHIC;
        }

        @Override
        public Introspection getIntrospectionData() {
            Object[] data = new Object[2];
            Object[] s;
            data[0] = 0;
            s = new Object[3];
            s[0] = "getInputProp";
            s[1] = (byte)0b01 /* active */;
            data[1] = s;
            return Provider.create(data);
        }

        public static JSRegExpStaticResultInputNode create(JSContext context, JSBuiltin builtin, JavaScriptNode[] arguments) {
            return new JSRegExpStaticResultInputNodeGen(context, builtin, arguments);
        }

    }
    @GeneratedBy(JSRegExpStaticResultMultilineNode.class)
    static final class JSRegExpStaticResultMultilineNodeGen extends JSRegExpStaticResultMultilineNode implements Provider {

        @CompilationFinal private int state_;
        @CompilationFinal private Assumption getMultilineLazy_assumption0_;
        @Child private GetStaticRegExpResultNode getMultilineEager_getResultNode_;
        @Child private TRegexResultAccessor getMultilineEager_resultAccessor_;

        private JSRegExpStaticResultMultilineNodeGen(JSContext context, JSBuiltin builtin, JavaScriptNode[] arguments) {
            super(context, builtin);
        }

        @Override
        public JavaScriptNode[] getArguments() {
            return new JavaScriptNode[] {};
        }

        @Override
        public Object execute(VirtualFrame frameValue) {
            int state = state_;
            if ((state & 0b1) != 0 /* is-active getMultilineLazyNashorn() */) {
                assert (getContext().isOptionNashornCompatibilityMode());
                return getMultilineLazyNashorn();
            }
            if ((state & 0b10) != 0 /* is-active getMultilineLazy() */) {
                if (!Assumption.isValidAssumption(this.getMultilineLazy_assumption0_)) {
                    CompilerDirectives.transferToInterpreterAndInvalidate();
                    removeGetMultilineLazy_();
                    return executeAndSpecialize();
                }
                assert (!(getContext().isOptionNashornCompatibilityMode()));
                return getMultilineLazy();
            }
            if ((state & 0b100) != 0 /* is-active getMultilineEager(GetStaticRegExpResultNode, TRegexResultAccessor) */) {
                return getMultilineEager(this.getMultilineEager_getResultNode_, this.getMultilineEager_resultAccessor_);
            }
            CompilerDirectives.transferToInterpreterAndInvalidate();
            return executeAndSpecialize();
        }

        @Override
        public boolean executeBoolean(VirtualFrame frameValue) {
            int state = state_;
            if ((state & 0b1) != 0 /* is-active getMultilineLazyNashorn() */) {
                assert (getContext().isOptionNashornCompatibilityMode());
                return getMultilineLazyNashorn();
            }
            if ((state & 0b10) != 0 /* is-active getMultilineLazy() */) {
                if (!Assumption.isValidAssumption(this.getMultilineLazy_assumption0_)) {
                    CompilerDirectives.transferToInterpreterAndInvalidate();
                    removeGetMultilineLazy_();
                    return executeAndSpecialize();
                }
                assert (!(getContext().isOptionNashornCompatibilityMode()));
                return getMultilineLazy();
            }
            if ((state & 0b100) != 0 /* is-active getMultilineEager(GetStaticRegExpResultNode, TRegexResultAccessor) */) {
                return getMultilineEager(this.getMultilineEager_getResultNode_, this.getMultilineEager_resultAccessor_);
            }
            CompilerDirectives.transferToInterpreterAndInvalidate();
            return executeAndSpecialize();
        }

        @Override
        public void executeVoid(VirtualFrame frameValue) {
            executeBoolean(frameValue);
            return;
        }

        private boolean executeAndSpecialize() {
            Lock lock = getLock();
            boolean hasLock = true;
            lock.lock();
            int state = state_;
            try {
                if ((getContext().isOptionNashornCompatibilityMode())) {
                    this.state_ = state = state | 0b1 /* add-active getMultilineLazyNashorn() */;
                    lock.unlock();
                    hasLock = false;
                    return getMultilineLazyNashorn();
                }
                if ((!(getContext().isOptionNashornCompatibilityMode()))) {
                    Assumption getMultilineLazy_assumption0 = (getStaticResultUnusedAssumption());
                    if (Assumption.isValidAssumption(getMultilineLazy_assumption0)) {
                        this.getMultilineLazy_assumption0_ = getMultilineLazy_assumption0;
                        this.state_ = state = state | 0b10 /* add-active getMultilineLazy() */;
                        lock.unlock();
                        hasLock = false;
                        return getMultilineLazy();
                    }
                }
                this.getMultilineEager_getResultNode_ = super.insert((createGetResultNode()));
                this.getMultilineEager_resultAccessor_ = super.insert((TRegexResultAccessor.create()));
                this.state_ = state = state | 0b100 /* add-active getMultilineEager(GetStaticRegExpResultNode, TRegexResultAccessor) */;
                lock.unlock();
                hasLock = false;
                return getMultilineEager(this.getMultilineEager_getResultNode_, this.getMultilineEager_resultAccessor_);
            } finally {
                if (hasLock) {
                    lock.unlock();
                }
            }
        }

        @Override
        public NodeCost getCost() {
            int state = state_;
            if (state == 0b0) {
                return NodeCost.UNINITIALIZED;
            } else if ((state & (state - 1)) == 0 /* is-single-active  */) {
                return NodeCost.MONOMORPHIC;
            }
            return NodeCost.POLYMORPHIC;
        }

        void removeGetMultilineLazy_() {
            Lock lock = getLock();
            lock.lock();
            try {
                this.state_ = this.state_ & 0xfffffffd /* remove-active getMultilineLazy() */;
            } finally {
                lock.unlock();
            }
        }

        @Override
        public Introspection getIntrospectionData() {
            Object[] data = new Object[4];
            Object[] s;
            data[0] = 0;
            int state = state_;
            s = new Object[3];
            s[0] = "getMultilineLazyNashorn";
            if ((state & 0b1) != 0 /* is-active getMultilineLazyNashorn() */) {
                s[1] = (byte)0b01 /* active */;
            } else {
                s[1] = (byte)0b00 /* inactive */;
            }
            data[1] = s;
            s = new Object[3];
            s[0] = "getMultilineLazy";
            if ((state & 0b10) != 0 /* is-active getMultilineLazy() */) {
                s[1] = (byte)0b01 /* active */;
            } else {
                s[1] = (byte)0b00 /* inactive */;
            }
            data[2] = s;
            s = new Object[3];
            s[0] = "getMultilineEager";
            if ((state & 0b100) != 0 /* is-active getMultilineEager(GetStaticRegExpResultNode, TRegexResultAccessor) */) {
                s[1] = (byte)0b01 /* active */;
                ArrayList<Object> cached = new ArrayList<>();
                cached.add(Arrays.asList(this.getMultilineEager_getResultNode_, this.getMultilineEager_resultAccessor_));
                s[2] = cached;
            } else {
                s[1] = (byte)0b00 /* inactive */;
            }
            data[3] = s;
            return Provider.create(data);
        }

        public static JSRegExpStaticResultMultilineNode create(JSContext context, JSBuiltin builtin, JavaScriptNode[] arguments) {
            return new JSRegExpStaticResultMultilineNodeGen(context, builtin, arguments);
        }

    }
    @GeneratedBy(JSRegExpStaticResultGetGroupNode.class)
    static final class JSRegExpStaticResultGetGroupNodeGen extends JSRegExpStaticResultGetGroupNode implements Provider {

        private JSRegExpStaticResultGetGroupNodeGen(JSContext context, JSBuiltin builtin, int groupNumber, JavaScriptNode[] arguments) {
            super(context, builtin, groupNumber);
        }

        @Override
        public JavaScriptNode[] getArguments() {
            return new JavaScriptNode[] {};
        }

        @Override
        public Object execute(VirtualFrame frameValue) {
            return getGroup();
        }

        @Override
        public void executeVoid(VirtualFrame frameValue) {
            execute(frameValue);
            return;
        }

        @Override
        public NodeCost getCost() {
            return NodeCost.MONOMORPHIC;
        }

        @Override
        public Introspection getIntrospectionData() {
            Object[] data = new Object[2];
            Object[] s;
            data[0] = 0;
            s = new Object[3];
            s[0] = "getGroup";
            s[1] = (byte)0b01 /* active */;
            data[1] = s;
            return Provider.create(data);
        }

        public static JSRegExpStaticResultGetGroupNode create(JSContext context, JSBuiltin builtin, int groupNumber, JavaScriptNode[] arguments) {
            return new JSRegExpStaticResultGetGroupNodeGen(context, builtin, groupNumber, arguments);
        }

    }
    @GeneratedBy(JSRegExpStaticResultLastParenNode.class)
    static final class JSRegExpStaticResultLastParenNodeGen extends JSRegExpStaticResultLastParenNode implements Provider {

        private JSRegExpStaticResultLastParenNodeGen(JSContext context, JSBuiltin builtin, JavaScriptNode[] arguments) {
            super(context, builtin);
        }

        @Override
        public JavaScriptNode[] getArguments() {
            return new JavaScriptNode[] {};
        }

        @Override
        public Object execute(VirtualFrame frameValue) {
            return lastParen();
        }

        @Override
        public void executeVoid(VirtualFrame frameValue) {
            execute(frameValue);
            return;
        }

        @Override
        public NodeCost getCost() {
            return NodeCost.MONOMORPHIC;
        }

        @Override
        public Introspection getIntrospectionData() {
            Object[] data = new Object[2];
            Object[] s;
            data[0] = 0;
            s = new Object[3];
            s[0] = "lastParen";
            s[1] = (byte)0b01 /* active */;
            data[1] = s;
            return Provider.create(data);
        }

        public static JSRegExpStaticResultLastParenNode create(JSContext context, JSBuiltin builtin, JavaScriptNode[] arguments) {
            return new JSRegExpStaticResultLastParenNodeGen(context, builtin, arguments);
        }

    }
    @GeneratedBy(JSRegExpStaticResultLeftContextNode.class)
    static final class JSRegExpStaticResultLeftContextNodeGen extends JSRegExpStaticResultLeftContextNode implements Provider {

        private JSRegExpStaticResultLeftContextNodeGen(JSContext context, JSBuiltin builtin, JavaScriptNode[] arguments) {
            super(context, builtin);
        }

        @Override
        public JavaScriptNode[] getArguments() {
            return new JavaScriptNode[] {};
        }

        @Override
        public Object execute(VirtualFrame frameValue) {
            return leftContext();
        }

        @Override
        public void executeVoid(VirtualFrame frameValue) {
            execute(frameValue);
            return;
        }

        @Override
        public NodeCost getCost() {
            return NodeCost.MONOMORPHIC;
        }

        @Override
        public Introspection getIntrospectionData() {
            Object[] data = new Object[2];
            Object[] s;
            data[0] = 0;
            s = new Object[3];
            s[0] = "leftContext";
            s[1] = (byte)0b01 /* active */;
            data[1] = s;
            return Provider.create(data);
        }

        public static JSRegExpStaticResultLeftContextNode create(JSContext context, JSBuiltin builtin, JavaScriptNode[] arguments) {
            return new JSRegExpStaticResultLeftContextNodeGen(context, builtin, arguments);
        }

    }
    @GeneratedBy(JSRegExpStaticResultRightContextNode.class)
    static final class JSRegExpStaticResultRightContextNodeGen extends JSRegExpStaticResultRightContextNode implements Provider {

        private JSRegExpStaticResultRightContextNodeGen(JSContext context, JSBuiltin builtin, JavaScriptNode[] arguments) {
            super(context, builtin);
        }

        @Override
        public JavaScriptNode[] getArguments() {
            return new JavaScriptNode[] {};
        }

        @Override
        public Object execute(VirtualFrame frameValue) {
            return rightContext();
        }

        @Override
        public void executeVoid(VirtualFrame frameValue) {
            execute(frameValue);
            return;
        }

        @Override
        public NodeCost getCost() {
            return NodeCost.MONOMORPHIC;
        }

        @Override
        public Introspection getIntrospectionData() {
            Object[] data = new Object[2];
            Object[] s;
            data[0] = 0;
            s = new Object[3];
            s[0] = "rightContext";
            s[1] = (byte)0b01 /* active */;
            data[1] = s;
            return Provider.create(data);
        }

        public static JSRegExpStaticResultRightContextNode create(JSContext context, JSBuiltin builtin, JavaScriptNode[] arguments) {
            return new JSRegExpStaticResultRightContextNodeGen(context, builtin, arguments);
        }

    }
}
