// CheckStyle: start generated
package com.oracle.truffle.js.builtins;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.CompilerDirectives.CompilationFinal;
import com.oracle.truffle.api.CompilerDirectives.TruffleBoundary;
import com.oracle.truffle.api.dsl.GeneratedBy;
import com.oracle.truffle.api.dsl.Introspection;
import com.oracle.truffle.api.dsl.UnsupportedSpecializationException;
import com.oracle.truffle.api.dsl.Introspection.Provider;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.interop.InteropLibrary;
import com.oracle.truffle.api.library.LibraryFactory;
import com.oracle.truffle.api.nodes.ExplodeLoop;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.nodes.NodeCost;
import com.oracle.truffle.api.nodes.NodeUtil;
import com.oracle.truffle.api.nodes.UnexpectedResultException;
import com.oracle.truffle.api.object.DynamicObject;
import com.oracle.truffle.api.profiles.BranchProfile;
import com.oracle.truffle.api.profiles.ConditionProfile;
import com.oracle.truffle.js.builtins.ObjectFunctionBuiltins;
import com.oracle.truffle.js.builtins.ObjectFunctionBuiltins.AssignPropertiesNode;
import com.oracle.truffle.js.builtins.ObjectFunctionBuiltins.ObjectAssignNode;
import com.oracle.truffle.js.builtins.ObjectFunctionBuiltins.ObjectCreateNode;
import com.oracle.truffle.js.builtins.ObjectFunctionBuiltins.ObjectDefinePropertiesNode;
import com.oracle.truffle.js.builtins.ObjectFunctionBuiltins.ObjectDefinePropertyNode;
import com.oracle.truffle.js.builtins.ObjectFunctionBuiltins.ObjectFromEntriesNode;
import com.oracle.truffle.js.builtins.ObjectFunctionBuiltins.ObjectGetOwnPropertyDescriptorNode;
import com.oracle.truffle.js.builtins.ObjectFunctionBuiltins.ObjectGetOwnPropertyDescriptorsNode;
import com.oracle.truffle.js.builtins.ObjectFunctionBuiltins.ObjectGetOwnPropertyNamesOrSymbolsNode;
import com.oracle.truffle.js.builtins.ObjectFunctionBuiltins.ObjectGetPrototypeOfNode;
import com.oracle.truffle.js.builtins.ObjectFunctionBuiltins.ObjectIsExtensibleNode;
import com.oracle.truffle.js.builtins.ObjectFunctionBuiltins.ObjectIsNode;
import com.oracle.truffle.js.builtins.ObjectFunctionBuiltins.ObjectKeysNode;
import com.oracle.truffle.js.builtins.ObjectFunctionBuiltins.ObjectPreventExtensionsNode;
import com.oracle.truffle.js.builtins.ObjectFunctionBuiltins.ObjectSetIntegrityLevelNode;
import com.oracle.truffle.js.builtins.ObjectFunctionBuiltins.ObjectSetPrototypeOfNode;
import com.oracle.truffle.js.builtins.ObjectFunctionBuiltins.ObjectTestIntegrityLevelNode;
import com.oracle.truffle.js.builtins.ObjectFunctionBuiltins.ObjectValuesOrEntriesNode;
import com.oracle.truffle.js.builtins.helper.ListGetNode;
import com.oracle.truffle.js.builtins.helper.ListSizeNode;
import com.oracle.truffle.js.nodes.JSGuards;
import com.oracle.truffle.js.nodes.JSTypes;
import com.oracle.truffle.js.nodes.JSTypesGen;
import com.oracle.truffle.js.nodes.JavaScriptNode;
import com.oracle.truffle.js.nodes.access.GetPrototypeNode;
import com.oracle.truffle.js.nodes.access.IsExtensibleNode;
import com.oracle.truffle.js.nodes.access.JSGetOwnPropertyNode;
import com.oracle.truffle.js.nodes.access.ReadElementNode;
import com.oracle.truffle.js.nodes.access.WriteElementNode;
import com.oracle.truffle.js.nodes.binary.JSIdenticalNode;
import com.oracle.truffle.js.nodes.cast.JSToObjectNode;
import com.oracle.truffle.js.nodes.function.JSBuiltin;
import com.oracle.truffle.js.nodes.interop.JSForeignToJSTypeNode;
import com.oracle.truffle.js.runtime.BigInt;
import com.oracle.truffle.js.runtime.JSContext;
import com.oracle.truffle.js.runtime.LargeInteger;
import com.oracle.truffle.js.runtime.Symbol;
import com.oracle.truffle.js.runtime.objects.JSLazyString;
import com.oracle.truffle.js.runtime.util.JSClassProfile;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.concurrent.locks.Lock;

@GeneratedBy(ObjectFunctionBuiltins.class)
@SuppressWarnings("unused")
public final class ObjectFunctionBuiltinsFactory {

    private static final LibraryFactory<InteropLibrary> INTEROP_LIBRARY_ = LibraryFactory.resolve(InteropLibrary.class);

    @GeneratedBy(ObjectGetPrototypeOfNode.class)
    public static final class ObjectGetPrototypeOfNodeGen extends ObjectGetPrototypeOfNode implements Provider {

        @Child private JavaScriptNode arguments0_;
        @CompilationFinal private int state_;
        @Child private GetPrototypeNode getPrototypeOf1_getPrototypeNode_;

        private ObjectGetPrototypeOfNodeGen(JSContext context, JSBuiltin builtin, JavaScriptNode[] arguments) {
            super(context, builtin);
            this.arguments0_ = arguments != null && 0 < arguments.length ? arguments[0] : null;
        }

        @Override
        public JavaScriptNode[] getArguments() {
            return new JavaScriptNode[] {this.arguments0_};
        }

        @Override
        public Object execute(VirtualFrame frameValue) {
            int state = state_;
            Object arguments0Value_ = this.arguments0_.execute(frameValue);
            if ((state & 0b1) != 0 /* is-active getPrototypeOf(Object) */) {
                if ((!(JSGuards.isJSObject(arguments0Value_)))) {
                    return getPrototypeOf(arguments0Value_);
                }
            }
            if ((state & 0b10) != 0 /* is-active getPrototypeOf(DynamicObject, GetPrototypeNode) */ && JSTypes.isDynamicObject(arguments0Value_)) {
                DynamicObject arguments0Value__ = (DynamicObject) arguments0Value_;
                if ((JSGuards.isJSObject(arguments0Value__))) {
                    return getPrototypeOf(arguments0Value__, this.getPrototypeOf1_getPrototypeNode_);
                }
            }
            CompilerDirectives.transferToInterpreterAndInvalidate();
            return executeAndSpecialize(arguments0Value_);
        }

        @Override
        public void executeVoid(VirtualFrame frameValue) {
            execute(frameValue);
            return;
        }

        private DynamicObject executeAndSpecialize(Object arguments0Value) {
            Lock lock = getLock();
            boolean hasLock = true;
            lock.lock();
            int state = state_;
            try {
                if ((!(JSGuards.isJSObject(arguments0Value)))) {
                    this.state_ = state = state | 0b1 /* add-active getPrototypeOf(Object) */;
                    lock.unlock();
                    hasLock = false;
                    return getPrototypeOf(arguments0Value);
                }
                if (JSTypes.isDynamicObject(arguments0Value)) {
                    DynamicObject arguments0Value_ = (DynamicObject) arguments0Value;
                    if ((JSGuards.isJSObject(arguments0Value_))) {
                        this.getPrototypeOf1_getPrototypeNode_ = super.insert((GetPrototypeNode.create()));
                        this.state_ = state = state | 0b10 /* add-active getPrototypeOf(DynamicObject, GetPrototypeNode) */;
                        lock.unlock();
                        hasLock = false;
                        return getPrototypeOf(arguments0Value_, this.getPrototypeOf1_getPrototypeNode_);
                    }
                }
                throw new UnsupportedSpecializationException(this, new Node[] {this.arguments0_}, arguments0Value);
            } finally {
                if (hasLock) {
                    lock.unlock();
                }
            }
        }

        @Override
        public NodeCost getCost() {
            int state = state_;
            if (state == 0b0) {
                return NodeCost.UNINITIALIZED;
            } else if ((state & (state - 1)) == 0 /* is-single-active  */) {
                return NodeCost.MONOMORPHIC;
            }
            return NodeCost.POLYMORPHIC;
        }

        @Override
        public Introspection getIntrospectionData() {
            Object[] data = new Object[3];
            Object[] s;
            data[0] = 0;
            int state = state_;
            s = new Object[3];
            s[0] = "getPrototypeOf";
            if ((state & 0b1) != 0 /* is-active getPrototypeOf(Object) */) {
                s[1] = (byte)0b01 /* active */;
            } else {
                s[1] = (byte)0b00 /* inactive */;
            }
            data[1] = s;
            s = new Object[3];
            s[0] = "getPrototypeOf";
            if ((state & 0b10) != 0 /* is-active getPrototypeOf(DynamicObject, GetPrototypeNode) */) {
                s[1] = (byte)0b01 /* active */;
                ArrayList<Object> cached = new ArrayList<>();
                cached.add(Arrays.asList(this.getPrototypeOf1_getPrototypeNode_));
                s[2] = cached;
            } else {
                s[1] = (byte)0b00 /* inactive */;
            }
            data[2] = s;
            return Provider.create(data);
        }

        public static ObjectGetPrototypeOfNode create(JSContext context, JSBuiltin builtin, JavaScriptNode[] arguments) {
            return new ObjectGetPrototypeOfNodeGen(context, builtin, arguments);
        }

    }
    @GeneratedBy(ObjectGetOwnPropertyDescriptorNode.class)
    public static final class ObjectGetOwnPropertyDescriptorNodeGen extends ObjectGetOwnPropertyDescriptorNode implements Provider {

        @Child private JavaScriptNode arguments0_;
        @Child private JavaScriptNode arguments1_;
        @CompilationFinal private int state_;
        @CompilationFinal private int exclude_;
        @Child private GetForeignObject0Data getForeignObject0_cache;
        @Child private JSForeignToJSTypeNode getForeignObject1_toJSType_;

        private ObjectGetOwnPropertyDescriptorNodeGen(JSContext context, JSBuiltin builtin, JavaScriptNode[] arguments) {
            super(context, builtin);
            this.arguments0_ = arguments != null && 0 < arguments.length ? arguments[0] : null;
            this.arguments1_ = arguments != null && 1 < arguments.length ? arguments[1] : null;
        }

        @Override
        public JavaScriptNode[] getArguments() {
            return new JavaScriptNode[] {this.arguments0_, this.arguments1_};
        }

        @ExplodeLoop
        @Override
        public Object execute(VirtualFrame frameValue) {
            int state = state_;
            Object arguments0Value_ = this.arguments0_.execute(frameValue);
            Object arguments1Value_ = this.arguments1_.execute(frameValue);
            if (state != 0 /* is-active getJSObject(DynamicObject, Object) || getForeignObject(Object, Object, InteropLibrary, JSForeignToJSTypeNode) || getForeignObject(Object, Object, InteropLibrary, JSForeignToJSTypeNode) || getDefault(Object, Object) */) {
                if ((state & 0b1) != 0 /* is-active getJSObject(DynamicObject, Object) */ && JSTypes.isDynamicObject(arguments0Value_)) {
                    DynamicObject arguments0Value__ = (DynamicObject) arguments0Value_;
                    if ((JSGuards.isJSObject(arguments0Value__))) {
                        return getJSObject(arguments0Value__, arguments1Value_);
                    }
                }
                if ((state & 0b1110) != 0 /* is-active getForeignObject(Object, Object, InteropLibrary, JSForeignToJSTypeNode) || getForeignObject(Object, Object, InteropLibrary, JSForeignToJSTypeNode) || getDefault(Object, Object) */) {
                    if ((state & 0b10) != 0 /* is-active getForeignObject(Object, Object, InteropLibrary, JSForeignToJSTypeNode) */) {
                        GetForeignObject0Data s2_ = this.getForeignObject0_cache;
                        while (s2_ != null) {
                            if ((s2_.interop_.accepts(arguments0Value_)) && (JSGuards.isForeignObject(arguments0Value_))) {
                                return getForeignObject(arguments0Value_, arguments1Value_, s2_.interop_, s2_.toJSType_);
                            }
                            s2_ = s2_.next_;
                        }
                    }
                    if ((state & 0b100) != 0 /* is-active getForeignObject(Object, Object, InteropLibrary, JSForeignToJSTypeNode) */) {
                        if ((JSGuards.isForeignObject(arguments0Value_))) {
                            return this.getForeignObject1Boundary(state, arguments0Value_, arguments1Value_);
                        }
                    }
                    if ((state & 0b1000) != 0 /* is-active getDefault(Object, Object) */) {
                        if ((!(JSGuards.isJSObject(arguments0Value_))) && (!(JSGuards.isForeignObject(arguments0Value_)))) {
                            return getDefault(arguments0Value_, arguments1Value_);
                        }
                    }
                }
            }
            CompilerDirectives.transferToInterpreterAndInvalidate();
            return executeAndSpecialize(arguments0Value_, arguments1Value_);
        }

        @TruffleBoundary
        private Object getForeignObject1Boundary(int state, Object arguments0Value_, Object arguments1Value_) {
            Node prev_ = NodeUtil.pushEncapsulatingNode(this);
            try {
                return getForeignObject(arguments0Value_, arguments1Value_, (INTEROP_LIBRARY_.getUncached(arguments0Value_)), this.getForeignObject1_toJSType_);
            } finally {
                NodeUtil.popEncapsulatingNode(prev_);
            }
        }

        @Override
        public void executeVoid(VirtualFrame frameValue) {
            execute(frameValue);
            return;
        }

        private DynamicObject executeAndSpecialize(Object arguments0Value, Object arguments1Value) {
            Lock lock = getLock();
            boolean hasLock = true;
            lock.lock();
            int state = state_;
            int exclude = exclude_;
            try {
                if (JSTypes.isDynamicObject(arguments0Value)) {
                    DynamicObject arguments0Value_ = (DynamicObject) arguments0Value;
                    if ((JSGuards.isJSObject(arguments0Value_))) {
                        this.state_ = state = state | 0b1 /* add-active getJSObject(DynamicObject, Object) */;
                        lock.unlock();
                        hasLock = false;
                        return getJSObject(arguments0Value_, arguments1Value);
                    }
                }
                if ((exclude) == 0 /* is-not-excluded getForeignObject(Object, Object, InteropLibrary, JSForeignToJSTypeNode) */) {
                    int count2_ = 0;
                    GetForeignObject0Data s2_ = this.getForeignObject0_cache;
                    if ((state & 0b10) != 0 /* is-active getForeignObject(Object, Object, InteropLibrary, JSForeignToJSTypeNode) */) {
                        while (s2_ != null) {
                            if ((s2_.interop_.accepts(arguments0Value)) && (JSGuards.isForeignObject(arguments0Value))) {
                                break;
                            }
                            s2_ = s2_.next_;
                            count2_++;
                        }
                    }
                    if (s2_ == null) {
                        if ((JSGuards.isForeignObject(arguments0Value)) && count2_ < (3)) {
                            // assert (s2_.interop_.accepts(arguments0Value));
                            s2_ = super.insert(new GetForeignObject0Data(getForeignObject0_cache));
                            s2_.interop_ = s2_.insertAccessor((INTEROP_LIBRARY_.create(arguments0Value)));
                            s2_.toJSType_ = s2_.insertAccessor((JSForeignToJSTypeNode.create()));
                            this.getForeignObject0_cache = s2_;
                            this.state_ = state = state | 0b10 /* add-active getForeignObject(Object, Object, InteropLibrary, JSForeignToJSTypeNode) */;
                        }
                    }
                    if (s2_ != null) {
                        lock.unlock();
                        hasLock = false;
                        return getForeignObject(arguments0Value, arguments1Value, s2_.interop_, s2_.toJSType_);
                    }
                }
                {
                    Node prev_ = NodeUtil.pushEncapsulatingNode(this);
                    try {
                        if ((JSGuards.isForeignObject(arguments0Value))) {
                            this.getForeignObject1_toJSType_ = super.insert((JSForeignToJSTypeNode.create()));
                            this.exclude_ = exclude = exclude | 0b1 /* add-excluded getForeignObject(Object, Object, InteropLibrary, JSForeignToJSTypeNode) */;
                            this.getForeignObject0_cache = null;
                            state = state & 0xfffffffd /* remove-active getForeignObject(Object, Object, InteropLibrary, JSForeignToJSTypeNode) */;
                            this.state_ = state = state | 0b100 /* add-active getForeignObject(Object, Object, InteropLibrary, JSForeignToJSTypeNode) */;
                            lock.unlock();
                            hasLock = false;
                            return getForeignObject(arguments0Value, arguments1Value, (INTEROP_LIBRARY_.getUncached(arguments0Value)), this.getForeignObject1_toJSType_);
                        }
                    } finally {
                        NodeUtil.popEncapsulatingNode(prev_);
                    }
                }
                if ((!(JSGuards.isJSObject(arguments0Value))) && (!(JSGuards.isForeignObject(arguments0Value)))) {
                    this.state_ = state = state | 0b1000 /* add-active getDefault(Object, Object) */;
                    lock.unlock();
                    hasLock = false;
                    return getDefault(arguments0Value, arguments1Value);
                }
                throw new UnsupportedSpecializationException(this, new Node[] {this.arguments0_, this.arguments1_}, arguments0Value, arguments1Value);
            } finally {
                if (hasLock) {
                    lock.unlock();
                }
            }
        }

        @Override
        public NodeCost getCost() {
            int state = state_;
            if (state == 0b0) {
                return NodeCost.UNINITIALIZED;
            } else if ((state & (state - 1)) == 0 /* is-single-active  */) {
                GetForeignObject0Data s2_ = this.getForeignObject0_cache;
                if ((s2_ == null || s2_.next_ == null)) {
                    return NodeCost.MONOMORPHIC;
                }
            }
            return NodeCost.POLYMORPHIC;
        }

        @Override
        public Introspection getIntrospectionData() {
            Object[] data = new Object[5];
            Object[] s;
            data[0] = 0;
            int state = state_;
            int exclude = exclude_;
            s = new Object[3];
            s[0] = "getJSObject";
            if ((state & 0b1) != 0 /* is-active getJSObject(DynamicObject, Object) */) {
                s[1] = (byte)0b01 /* active */;
            } else {
                s[1] = (byte)0b00 /* inactive */;
            }
            data[1] = s;
            s = new Object[3];
            s[0] = "getForeignObject";
            if ((state & 0b10) != 0 /* is-active getForeignObject(Object, Object, InteropLibrary, JSForeignToJSTypeNode) */) {
                s[1] = (byte)0b01 /* active */;
                ArrayList<Object> cached = new ArrayList<>();
                GetForeignObject0Data s2_ = this.getForeignObject0_cache;
                while (s2_ != null) {
                    cached.add(Arrays.asList(s2_.interop_, s2_.toJSType_));
                    s2_ = s2_.next_;
                }
                s[2] = cached;
            } else if (exclude != 0 /* is-excluded getForeignObject(Object, Object, InteropLibrary, JSForeignToJSTypeNode) */) {
                s[1] = (byte)0b10 /* excluded */;
            } else {
                s[1] = (byte)0b00 /* inactive */;
            }
            data[2] = s;
            s = new Object[3];
            s[0] = "getForeignObject";
            if ((state & 0b100) != 0 /* is-active getForeignObject(Object, Object, InteropLibrary, JSForeignToJSTypeNode) */) {
                s[1] = (byte)0b01 /* active */;
                ArrayList<Object> cached = new ArrayList<>();
                cached.add(Arrays.asList(INTEROP_LIBRARY_.getUncached(), this.getForeignObject1_toJSType_));
                s[2] = cached;
            } else {
                s[1] = (byte)0b00 /* inactive */;
            }
            data[3] = s;
            s = new Object[3];
            s[0] = "getDefault";
            if ((state & 0b1000) != 0 /* is-active getDefault(Object, Object) */) {
                s[1] = (byte)0b01 /* active */;
            } else {
                s[1] = (byte)0b00 /* inactive */;
            }
            data[4] = s;
            return Provider.create(data);
        }

        public static ObjectGetOwnPropertyDescriptorNode create(JSContext context, JSBuiltin builtin, JavaScriptNode[] arguments) {
            return new ObjectGetOwnPropertyDescriptorNodeGen(context, builtin, arguments);
        }

        @GeneratedBy(ObjectGetOwnPropertyDescriptorNode.class)
        private static final class GetForeignObject0Data extends Node {

            @Child GetForeignObject0Data next_;
            @Child InteropLibrary interop_;
            @Child JSForeignToJSTypeNode toJSType_;

            GetForeignObject0Data(GetForeignObject0Data next_) {
                this.next_ = next_;
            }

            @Override
            public NodeCost getCost() {
                return NodeCost.NONE;
            }

            <T extends Node> T insertAccessor(T node) {
                return super.insert(node);
            }

        }
    }
    @GeneratedBy(ObjectGetOwnPropertyDescriptorsNode.class)
    public static final class ObjectGetOwnPropertyDescriptorsNodeGen extends ObjectGetOwnPropertyDescriptorsNode implements Provider {

        @Child private JavaScriptNode arguments0_;
        @CompilationFinal private int state_;
        @CompilationFinal private int exclude_;
        @Child private GetJSObjectData getJSObject_cache;
        @Child private GetForeignObject0Data getForeignObject0_cache;
        @Child private InteropLibrary getForeignObject1_members_;
        @Child private JSForeignToJSTypeNode getForeignObject1_toJSType_;
        @Child private ObjectGetOwnPropertyDescriptorsNode getDefault_recursive_;

        private ObjectGetOwnPropertyDescriptorsNodeGen(JSContext context, JSBuiltin builtin, JavaScriptNode[] arguments) {
            super(context, builtin);
            this.arguments0_ = arguments != null && 0 < arguments.length ? arguments[0] : null;
        }

        @Override
        public JavaScriptNode[] getArguments() {
            return new JavaScriptNode[] {this.arguments0_};
        }

        @ExplodeLoop
        @Override
        protected DynamicObject executeEvaluated(Object arguments0Value) {
            int state = state_;
            if ((state & 0b1) != 0 /* is-active getJSObject(DynamicObject, JSGetOwnPropertyNode, ListSizeNode, ListGetNode, JSClassProfile) */ && JSTypes.isDynamicObject(arguments0Value)) {
                DynamicObject arguments0Value_ = (DynamicObject) arguments0Value;
                GetJSObjectData s1_ = this.getJSObject_cache;
                if (s1_ != null) {
                    if ((JSGuards.isJSObject(arguments0Value_))) {
                        return getJSObject(arguments0Value_, s1_.getOwnPropertyNode_, s1_.listSize_, s1_.listGet_, s1_.classProfile_);
                    }
                }
            }
            if ((state & 0b1110) != 0 /* is-active getForeignObject(Object, InteropLibrary, InteropLibrary, JSForeignToJSTypeNode) || getForeignObject(Object, InteropLibrary, InteropLibrary, JSForeignToJSTypeNode) || getDefault(Object, ObjectGetOwnPropertyDescriptorsNode) */) {
                if ((state & 0b10) != 0 /* is-active getForeignObject(Object, InteropLibrary, InteropLibrary, JSForeignToJSTypeNode) */) {
                    GetForeignObject0Data s2_ = this.getForeignObject0_cache;
                    while (s2_ != null) {
                        if ((s2_.interop_.accepts(arguments0Value)) && (JSGuards.isForeignObject(arguments0Value))) {
                            return getForeignObject(arguments0Value, s2_.interop_, s2_.members_, s2_.toJSType_);
                        }
                        s2_ = s2_.next_;
                    }
                }
                if ((state & 0b100) != 0 /* is-active getForeignObject(Object, InteropLibrary, InteropLibrary, JSForeignToJSTypeNode) */) {
                    if ((JSGuards.isForeignObject(arguments0Value))) {
                        return this.getForeignObject1Boundary(state, arguments0Value);
                    }
                }
                if ((state & 0b1000) != 0 /* is-active getDefault(Object, ObjectGetOwnPropertyDescriptorsNode) */) {
                    if ((!(JSGuards.isJSObject(arguments0Value))) && (!(JSGuards.isForeignObject(arguments0Value)))) {
                        return getDefault(arguments0Value, this.getDefault_recursive_);
                    }
                }
            }
            CompilerDirectives.transferToInterpreterAndInvalidate();
            return executeAndSpecialize(arguments0Value);
        }

        @TruffleBoundary
        private DynamicObject getForeignObject1Boundary(int state, Object arguments0Value) {
            Node prev_ = NodeUtil.pushEncapsulatingNode(this);
            try {
                return getForeignObject(arguments0Value, (INTEROP_LIBRARY_.getUncached(arguments0Value)), this.getForeignObject1_members_, this.getForeignObject1_toJSType_);
            } finally {
                NodeUtil.popEncapsulatingNode(prev_);
            }
        }

        @ExplodeLoop
        @Override
        public Object execute(VirtualFrame frameValue) {
            int state = state_;
            Object arguments0Value_ = this.arguments0_.execute(frameValue);
            if ((state & 0b1) != 0 /* is-active getJSObject(DynamicObject, JSGetOwnPropertyNode, ListSizeNode, ListGetNode, JSClassProfile) */ && JSTypes.isDynamicObject(arguments0Value_)) {
                DynamicObject arguments0Value__ = (DynamicObject) arguments0Value_;
                GetJSObjectData s1_ = this.getJSObject_cache;
                if (s1_ != null) {
                    if ((JSGuards.isJSObject(arguments0Value__))) {
                        return getJSObject(arguments0Value__, s1_.getOwnPropertyNode_, s1_.listSize_, s1_.listGet_, s1_.classProfile_);
                    }
                }
            }
            if ((state & 0b1110) != 0 /* is-active getForeignObject(Object, InteropLibrary, InteropLibrary, JSForeignToJSTypeNode) || getForeignObject(Object, InteropLibrary, InteropLibrary, JSForeignToJSTypeNode) || getDefault(Object, ObjectGetOwnPropertyDescriptorsNode) */) {
                if ((state & 0b10) != 0 /* is-active getForeignObject(Object, InteropLibrary, InteropLibrary, JSForeignToJSTypeNode) */) {
                    GetForeignObject0Data s2_ = this.getForeignObject0_cache;
                    while (s2_ != null) {
                        if ((s2_.interop_.accepts(arguments0Value_)) && (JSGuards.isForeignObject(arguments0Value_))) {
                            return getForeignObject(arguments0Value_, s2_.interop_, s2_.members_, s2_.toJSType_);
                        }
                        s2_ = s2_.next_;
                    }
                }
                if ((state & 0b100) != 0 /* is-active getForeignObject(Object, InteropLibrary, InteropLibrary, JSForeignToJSTypeNode) */) {
                    if ((JSGuards.isForeignObject(arguments0Value_))) {
                        return this.getForeignObject1Boundary0(state, arguments0Value_);
                    }
                }
                if ((state & 0b1000) != 0 /* is-active getDefault(Object, ObjectGetOwnPropertyDescriptorsNode) */) {
                    if ((!(JSGuards.isJSObject(arguments0Value_))) && (!(JSGuards.isForeignObject(arguments0Value_)))) {
                        return getDefault(arguments0Value_, this.getDefault_recursive_);
                    }
                }
            }
            CompilerDirectives.transferToInterpreterAndInvalidate();
            return executeAndSpecialize(arguments0Value_);
        }

        @TruffleBoundary
        private Object getForeignObject1Boundary0(int state, Object arguments0Value_) {
            Node prev_ = NodeUtil.pushEncapsulatingNode(this);
            try {
                return getForeignObject(arguments0Value_, (INTEROP_LIBRARY_.getUncached(arguments0Value_)), this.getForeignObject1_members_, this.getForeignObject1_toJSType_);
            } finally {
                NodeUtil.popEncapsulatingNode(prev_);
            }
        }

        @Override
        public void executeVoid(VirtualFrame frameValue) {
            execute(frameValue);
            return;
        }

        private DynamicObject executeAndSpecialize(Object arguments0Value) {
            Lock lock = getLock();
            boolean hasLock = true;
            lock.lock();
            int state = state_;
            int exclude = exclude_;
            try {
                if (JSTypes.isDynamicObject(arguments0Value)) {
                    DynamicObject arguments0Value_ = (DynamicObject) arguments0Value;
                    if ((JSGuards.isJSObject(arguments0Value_))) {
                        GetJSObjectData s1_ = super.insert(new GetJSObjectData());
                        s1_.getOwnPropertyNode_ = s1_.insertAccessor((JSGetOwnPropertyNode.create()));
                        s1_.listSize_ = s1_.insertAccessor((ListSizeNode.create()));
                        s1_.listGet_ = s1_.insertAccessor((ListGetNode.create()));
                        s1_.classProfile_ = (JSClassProfile.create());
                        this.getJSObject_cache = s1_;
                        this.state_ = state = state | 0b1 /* add-active getJSObject(DynamicObject, JSGetOwnPropertyNode, ListSizeNode, ListGetNode, JSClassProfile) */;
                        lock.unlock();
                        hasLock = false;
                        return getJSObject(arguments0Value_, s1_.getOwnPropertyNode_, s1_.listSize_, s1_.listGet_, s1_.classProfile_);
                    }
                }
                if ((exclude) == 0 /* is-not-excluded getForeignObject(Object, InteropLibrary, InteropLibrary, JSForeignToJSTypeNode) */) {
                    int count2_ = 0;
                    GetForeignObject0Data s2_ = this.getForeignObject0_cache;
                    if ((state & 0b10) != 0 /* is-active getForeignObject(Object, InteropLibrary, InteropLibrary, JSForeignToJSTypeNode) */) {
                        while (s2_ != null) {
                            if ((s2_.interop_.accepts(arguments0Value)) && (JSGuards.isForeignObject(arguments0Value))) {
                                break;
                            }
                            s2_ = s2_.next_;
                            count2_++;
                        }
                    }
                    if (s2_ == null) {
                        if ((JSGuards.isForeignObject(arguments0Value)) && count2_ < (3)) {
                            // assert (s2_.interop_.accepts(arguments0Value));
                            s2_ = super.insert(new GetForeignObject0Data(getForeignObject0_cache));
                            s2_.interop_ = s2_.insertAccessor((INTEROP_LIBRARY_.create(arguments0Value)));
                            s2_.members_ = s2_.insertAccessor((INTEROP_LIBRARY_.createDispatched(3)));
                            s2_.toJSType_ = s2_.insertAccessor((JSForeignToJSTypeNode.create()));
                            this.getForeignObject0_cache = s2_;
                            this.state_ = state = state | 0b10 /* add-active getForeignObject(Object, InteropLibrary, InteropLibrary, JSForeignToJSTypeNode) */;
                        }
                    }
                    if (s2_ != null) {
                        lock.unlock();
                        hasLock = false;
                        return getForeignObject(arguments0Value, s2_.interop_, s2_.members_, s2_.toJSType_);
                    }
                }
                {
                    Node prev_ = NodeUtil.pushEncapsulatingNode(this);
                    try {
                        if ((JSGuards.isForeignObject(arguments0Value))) {
                            this.getForeignObject1_members_ = super.insert((INTEROP_LIBRARY_.createDispatched(3)));
                            this.getForeignObject1_toJSType_ = super.insert((JSForeignToJSTypeNode.create()));
                            this.exclude_ = exclude = exclude | 0b1 /* add-excluded getForeignObject(Object, InteropLibrary, InteropLibrary, JSForeignToJSTypeNode) */;
                            this.getForeignObject0_cache = null;
                            state = state & 0xfffffffd /* remove-active getForeignObject(Object, InteropLibrary, InteropLibrary, JSForeignToJSTypeNode) */;
                            this.state_ = state = state | 0b100 /* add-active getForeignObject(Object, InteropLibrary, InteropLibrary, JSForeignToJSTypeNode) */;
                            lock.unlock();
                            hasLock = false;
                            return getForeignObject(arguments0Value, (INTEROP_LIBRARY_.getUncached(arguments0Value)), this.getForeignObject1_members_, this.getForeignObject1_toJSType_);
                        }
                    } finally {
                        NodeUtil.popEncapsulatingNode(prev_);
                    }
                }
                if ((!(JSGuards.isJSObject(arguments0Value))) && (!(JSGuards.isForeignObject(arguments0Value)))) {
                    this.getDefault_recursive_ = super.insert((createRecursive()));
                    this.state_ = state = state | 0b1000 /* add-active getDefault(Object, ObjectGetOwnPropertyDescriptorsNode) */;
                    lock.unlock();
                    hasLock = false;
                    return getDefault(arguments0Value, this.getDefault_recursive_);
                }
                throw new UnsupportedSpecializationException(this, new Node[] {this.arguments0_}, arguments0Value);
            } finally {
                if (hasLock) {
                    lock.unlock();
                }
            }
        }

        @Override
        public NodeCost getCost() {
            int state = state_;
            if (state == 0b0) {
                return NodeCost.UNINITIALIZED;
            } else if ((state & (state - 1)) == 0 /* is-single-active  */) {
                GetForeignObject0Data s2_ = this.getForeignObject0_cache;
                if ((s2_ == null || s2_.next_ == null)) {
                    return NodeCost.MONOMORPHIC;
                }
            }
            return NodeCost.POLYMORPHIC;
        }

        @Override
        public Introspection getIntrospectionData() {
            Object[] data = new Object[5];
            Object[] s;
            data[0] = 0;
            int state = state_;
            int exclude = exclude_;
            s = new Object[3];
            s[0] = "getJSObject";
            if ((state & 0b1) != 0 /* is-active getJSObject(DynamicObject, JSGetOwnPropertyNode, ListSizeNode, ListGetNode, JSClassProfile) */) {
                s[1] = (byte)0b01 /* active */;
                ArrayList<Object> cached = new ArrayList<>();
                GetJSObjectData s1_ = this.getJSObject_cache;
                if (s1_ != null) {
                    cached.add(Arrays.asList(s1_.getOwnPropertyNode_, s1_.listSize_, s1_.listGet_, s1_.classProfile_));
                }
                s[2] = cached;
            } else {
                s[1] = (byte)0b00 /* inactive */;
            }
            data[1] = s;
            s = new Object[3];
            s[0] = "getForeignObject";
            if ((state & 0b10) != 0 /* is-active getForeignObject(Object, InteropLibrary, InteropLibrary, JSForeignToJSTypeNode) */) {
                s[1] = (byte)0b01 /* active */;
                ArrayList<Object> cached = new ArrayList<>();
                GetForeignObject0Data s2_ = this.getForeignObject0_cache;
                while (s2_ != null) {
                    cached.add(Arrays.asList(s2_.interop_, s2_.members_, s2_.toJSType_));
                    s2_ = s2_.next_;
                }
                s[2] = cached;
            } else if (exclude != 0 /* is-excluded getForeignObject(Object, InteropLibrary, InteropLibrary, JSForeignToJSTypeNode) */) {
                s[1] = (byte)0b10 /* excluded */;
            } else {
                s[1] = (byte)0b00 /* inactive */;
            }
            data[2] = s;
            s = new Object[3];
            s[0] = "getForeignObject";
            if ((state & 0b100) != 0 /* is-active getForeignObject(Object, InteropLibrary, InteropLibrary, JSForeignToJSTypeNode) */) {
                s[1] = (byte)0b01 /* active */;
                ArrayList<Object> cached = new ArrayList<>();
                cached.add(Arrays.asList(INTEROP_LIBRARY_.getUncached(), this.getForeignObject1_members_, this.getForeignObject1_toJSType_));
                s[2] = cached;
            } else {
                s[1] = (byte)0b00 /* inactive */;
            }
            data[3] = s;
            s = new Object[3];
            s[0] = "getDefault";
            if ((state & 0b1000) != 0 /* is-active getDefault(Object, ObjectGetOwnPropertyDescriptorsNode) */) {
                s[1] = (byte)0b01 /* active */;
                ArrayList<Object> cached = new ArrayList<>();
                cached.add(Arrays.asList(this.getDefault_recursive_));
                s[2] = cached;
            } else {
                s[1] = (byte)0b00 /* inactive */;
            }
            data[4] = s;
            return Provider.create(data);
        }

        public static ObjectGetOwnPropertyDescriptorsNode create(JSContext context, JSBuiltin builtin, JavaScriptNode[] arguments) {
            return new ObjectGetOwnPropertyDescriptorsNodeGen(context, builtin, arguments);
        }

        @GeneratedBy(ObjectGetOwnPropertyDescriptorsNode.class)
        private static final class GetJSObjectData extends Node {

            @Child JSGetOwnPropertyNode getOwnPropertyNode_;
            @Child ListSizeNode listSize_;
            @Child ListGetNode listGet_;
            @CompilationFinal JSClassProfile classProfile_;

            GetJSObjectData() {
            }

            @Override
            public NodeCost getCost() {
                return NodeCost.NONE;
            }

            <T extends Node> T insertAccessor(T node) {
                return super.insert(node);
            }

        }
        @GeneratedBy(ObjectGetOwnPropertyDescriptorsNode.class)
        private static final class GetForeignObject0Data extends Node {

            @Child GetForeignObject0Data next_;
            @Child InteropLibrary interop_;
            @Child InteropLibrary members_;
            @Child JSForeignToJSTypeNode toJSType_;

            GetForeignObject0Data(GetForeignObject0Data next_) {
                this.next_ = next_;
            }

            @Override
            public NodeCost getCost() {
                return NodeCost.NONE;
            }

            <T extends Node> T insertAccessor(T node) {
                return super.insert(node);
            }

        }
    }
    @GeneratedBy(ObjectGetOwnPropertyNamesOrSymbolsNode.class)
    public static final class ObjectGetOwnPropertyNamesOrSymbolsNodeGen extends ObjectGetOwnPropertyNamesOrSymbolsNode implements Provider {

        @Child private JavaScriptNode arguments0_;
        @CompilationFinal private int state_;
        @CompilationFinal private int exclude_;
        @CompilationFinal private JSClassProfile jsclassProfile;
        @Child private GetForeignObjectNames0Data getForeignObjectNames0_cache;
        @Child private InteropLibrary getForeignObjectNames1_members_;

        private ObjectGetOwnPropertyNamesOrSymbolsNodeGen(JSContext context, JSBuiltin builtin, boolean symbols, JavaScriptNode[] arguments) {
            super(context, builtin, symbols);
            this.arguments0_ = arguments != null && 0 < arguments.length ? arguments[0] : null;
        }

        @Override
        public JavaScriptNode[] getArguments() {
            return new JavaScriptNode[] {this.arguments0_};
        }

        @ExplodeLoop
        @Override
        public Object execute(VirtualFrame frameValue) {
            int state = state_;
            Object arguments0Value_ = this.arguments0_.execute(frameValue);
            if ((state & 0b1) != 0 /* is-active getJSObject(DynamicObject, JSClassProfile) */ && JSTypes.isDynamicObject(arguments0Value_)) {
                DynamicObject arguments0Value__ = (DynamicObject) arguments0Value_;
                if ((JSGuards.isJSObject(arguments0Value__))) {
                    return getJSObject(arguments0Value__, this.jsclassProfile);
                }
            }
            if ((state & 0b11110) != 0 /* is-active getDefault(Object, JSClassProfile) || getForeignObjectSymbols(Object) || getForeignObjectNames(Object, InteropLibrary, InteropLibrary) || getForeignObjectNames(Object, InteropLibrary, InteropLibrary) */) {
                if ((state & 0b10) != 0 /* is-active getDefault(Object, JSClassProfile) */) {
                    if ((!(JSGuards.isJSObject(arguments0Value_))) && (!(JSGuards.isForeignObject(arguments0Value_)))) {
                        return getDefault(arguments0Value_, this.jsclassProfile);
                    }
                }
                if ((state & 0b100) != 0 /* is-active getForeignObjectSymbols(Object) */) {
                    if ((JSGuards.isForeignObject(arguments0Value_))) {
                        assert (symbols);
                        return getForeignObjectSymbols(arguments0Value_);
                    }
                }
                if ((state & 0b1000) != 0 /* is-active getForeignObjectNames(Object, InteropLibrary, InteropLibrary) */) {
                    GetForeignObjectNames0Data s4_ = this.getForeignObjectNames0_cache;
                    while (s4_ != null) {
                        if ((s4_.interop_.accepts(arguments0Value_)) && (JSGuards.isForeignObject(arguments0Value_))) {
                            assert (!(symbols));
                            return getForeignObjectNames(arguments0Value_, s4_.interop_, s4_.members_);
                        }
                        s4_ = s4_.next_;
                    }
                }
                if ((state & 0b10000) != 0 /* is-active getForeignObjectNames(Object, InteropLibrary, InteropLibrary) */) {
                    if ((JSGuards.isForeignObject(arguments0Value_))) {
                        assert (!(symbols));
                        return this.getForeignObjectNames1Boundary(state, arguments0Value_);
                    }
                }
            }
            CompilerDirectives.transferToInterpreterAndInvalidate();
            return executeAndSpecialize(arguments0Value_);
        }

        @TruffleBoundary
        private Object getForeignObjectNames1Boundary(int state, Object arguments0Value_) {
            Node prev_ = NodeUtil.pushEncapsulatingNode(this);
            try {
                return getForeignObjectNames(arguments0Value_, (INTEROP_LIBRARY_.getUncached(arguments0Value_)), this.getForeignObjectNames1_members_);
            } finally {
                NodeUtil.popEncapsulatingNode(prev_);
            }
        }

        @Override
        public void executeVoid(VirtualFrame frameValue) {
            execute(frameValue);
            return;
        }

        private DynamicObject executeAndSpecialize(Object arguments0Value) {
            Lock lock = getLock();
            boolean hasLock = true;
            lock.lock();
            int state = state_;
            int exclude = exclude_;
            try {
                if (JSTypes.isDynamicObject(arguments0Value)) {
                    DynamicObject arguments0Value_ = (DynamicObject) arguments0Value;
                    if ((JSGuards.isJSObject(arguments0Value_))) {
                        if (this.jsclassProfile == null) {
                            this.jsclassProfile = (JSClassProfile.create());
                        }
                        this.state_ = state = state | 0b1 /* add-active getJSObject(DynamicObject, JSClassProfile) */;
                        lock.unlock();
                        hasLock = false;
                        return getJSObject(arguments0Value_, this.jsclassProfile);
                    }
                }
                if ((!(JSGuards.isJSObject(arguments0Value))) && (!(JSGuards.isForeignObject(arguments0Value)))) {
                    if (this.jsclassProfile == null) {
                        this.jsclassProfile = (JSClassProfile.create());
                    }
                    this.state_ = state = state | 0b10 /* add-active getDefault(Object, JSClassProfile) */;
                    lock.unlock();
                    hasLock = false;
                    return getDefault(arguments0Value, this.jsclassProfile);
                }
                if ((JSGuards.isForeignObject(arguments0Value)) && (symbols)) {
                    this.state_ = state = state | 0b100 /* add-active getForeignObjectSymbols(Object) */;
                    lock.unlock();
                    hasLock = false;
                    return getForeignObjectSymbols(arguments0Value);
                }
                if ((exclude) == 0 /* is-not-excluded getForeignObjectNames(Object, InteropLibrary, InteropLibrary) */) {
                    int count4_ = 0;
                    GetForeignObjectNames0Data s4_ = this.getForeignObjectNames0_cache;
                    if ((state & 0b1000) != 0 /* is-active getForeignObjectNames(Object, InteropLibrary, InteropLibrary) */) {
                        while (s4_ != null) {
                            if ((s4_.interop_.accepts(arguments0Value)) && (JSGuards.isForeignObject(arguments0Value))) {
                                assert (!(symbols));
                                break;
                            }
                            s4_ = s4_.next_;
                            count4_++;
                        }
                    }
                    if (s4_ == null) {
                        if ((JSGuards.isForeignObject(arguments0Value)) && (!(symbols)) && count4_ < (3)) {
                            // assert (s4_.interop_.accepts(arguments0Value));
                            s4_ = super.insert(new GetForeignObjectNames0Data(getForeignObjectNames0_cache));
                            s4_.interop_ = s4_.insertAccessor((INTEROP_LIBRARY_.create(arguments0Value)));
                            s4_.members_ = s4_.insertAccessor((INTEROP_LIBRARY_.createDispatched(3)));
                            this.getForeignObjectNames0_cache = s4_;
                            this.state_ = state = state | 0b1000 /* add-active getForeignObjectNames(Object, InteropLibrary, InteropLibrary) */;
                        }
                    }
                    if (s4_ != null) {
                        lock.unlock();
                        hasLock = false;
                        return getForeignObjectNames(arguments0Value, s4_.interop_, s4_.members_);
                    }
                }
                {
                    Node prev_ = NodeUtil.pushEncapsulatingNode(this);
                    try {
                        if ((JSGuards.isForeignObject(arguments0Value)) && (!(symbols))) {
                            this.getForeignObjectNames1_members_ = super.insert((INTEROP_LIBRARY_.createDispatched(3)));
                            this.exclude_ = exclude = exclude | 0b1 /* add-excluded getForeignObjectNames(Object, InteropLibrary, InteropLibrary) */;
                            this.getForeignObjectNames0_cache = null;
                            state = state & 0xfffffff7 /* remove-active getForeignObjectNames(Object, InteropLibrary, InteropLibrary) */;
                            this.state_ = state = state | 0b10000 /* add-active getForeignObjectNames(Object, InteropLibrary, InteropLibrary) */;
                            lock.unlock();
                            hasLock = false;
                            return getForeignObjectNames(arguments0Value, (INTEROP_LIBRARY_.getUncached(arguments0Value)), this.getForeignObjectNames1_members_);
                        }
                    } finally {
                        NodeUtil.popEncapsulatingNode(prev_);
                    }
                }
                throw new UnsupportedSpecializationException(this, new Node[] {this.arguments0_}, arguments0Value);
            } finally {
                if (hasLock) {
                    lock.unlock();
                }
            }
        }

        @Override
        public NodeCost getCost() {
            int state = state_;
            if (state == 0b0) {
                return NodeCost.UNINITIALIZED;
            } else if ((state & (state - 1)) == 0 /* is-single-active  */) {
                GetForeignObjectNames0Data s4_ = this.getForeignObjectNames0_cache;
                if ((s4_ == null || s4_.next_ == null)) {
                    return NodeCost.MONOMORPHIC;
                }
            }
            return NodeCost.POLYMORPHIC;
        }

        @Override
        public Introspection getIntrospectionData() {
            Object[] data = new Object[6];
            Object[] s;
            data[0] = 0;
            int state = state_;
            int exclude = exclude_;
            s = new Object[3];
            s[0] = "getJSObject";
            if ((state & 0b1) != 0 /* is-active getJSObject(DynamicObject, JSClassProfile) */) {
                s[1] = (byte)0b01 /* active */;
                ArrayList<Object> cached = new ArrayList<>();
                cached.add(Arrays.asList(this.jsclassProfile));
                s[2] = cached;
            } else {
                s[1] = (byte)0b00 /* inactive */;
            }
            data[1] = s;
            s = new Object[3];
            s[0] = "getDefault";
            if ((state & 0b10) != 0 /* is-active getDefault(Object, JSClassProfile) */) {
                s[1] = (byte)0b01 /* active */;
                ArrayList<Object> cached = new ArrayList<>();
                cached.add(Arrays.asList(this.jsclassProfile));
                s[2] = cached;
            } else {
                s[1] = (byte)0b00 /* inactive */;
            }
            data[2] = s;
            s = new Object[3];
            s[0] = "getForeignObjectSymbols";
            if ((state & 0b100) != 0 /* is-active getForeignObjectSymbols(Object) */) {
                s[1] = (byte)0b01 /* active */;
            } else {
                s[1] = (byte)0b00 /* inactive */;
            }
            data[3] = s;
            s = new Object[3];
            s[0] = "getForeignObjectNames";
            if ((state & 0b1000) != 0 /* is-active getForeignObjectNames(Object, InteropLibrary, InteropLibrary) */) {
                s[1] = (byte)0b01 /* active */;
                ArrayList<Object> cached = new ArrayList<>();
                GetForeignObjectNames0Data s4_ = this.getForeignObjectNames0_cache;
                while (s4_ != null) {
                    cached.add(Arrays.asList(s4_.interop_, s4_.members_));
                    s4_ = s4_.next_;
                }
                s[2] = cached;
            } else if (exclude != 0 /* is-excluded getForeignObjectNames(Object, InteropLibrary, InteropLibrary) */) {
                s[1] = (byte)0b10 /* excluded */;
            } else {
                s[1] = (byte)0b00 /* inactive */;
            }
            data[4] = s;
            s = new Object[3];
            s[0] = "getForeignObjectNames";
            if ((state & 0b10000) != 0 /* is-active getForeignObjectNames(Object, InteropLibrary, InteropLibrary) */) {
                s[1] = (byte)0b01 /* active */;
                ArrayList<Object> cached = new ArrayList<>();
                cached.add(Arrays.asList(INTEROP_LIBRARY_.getUncached(), this.getForeignObjectNames1_members_));
                s[2] = cached;
            } else {
                s[1] = (byte)0b00 /* inactive */;
            }
            data[5] = s;
            return Provider.create(data);
        }

        public static ObjectGetOwnPropertyNamesOrSymbolsNode create(JSContext context, JSBuiltin builtin, boolean symbols, JavaScriptNode[] arguments) {
            return new ObjectGetOwnPropertyNamesOrSymbolsNodeGen(context, builtin, symbols, arguments);
        }

        @GeneratedBy(ObjectGetOwnPropertyNamesOrSymbolsNode.class)
        private static final class GetForeignObjectNames0Data extends Node {

            @Child GetForeignObjectNames0Data next_;
            @Child InteropLibrary interop_;
            @Child InteropLibrary members_;

            GetForeignObjectNames0Data(GetForeignObjectNames0Data next_) {
                this.next_ = next_;
            }

            @Override
            public NodeCost getCost() {
                return NodeCost.NONE;
            }

            <T extends Node> T insertAccessor(T node) {
                return super.insert(node);
            }

        }
    }
    @GeneratedBy(ObjectCreateNode.class)
    public static final class ObjectCreateNodeGen extends ObjectCreateNode implements Provider {

        @Child private JavaScriptNode arguments0_;
        @Child private JavaScriptNode arguments1_;
        @CompilationFinal private int state_;

        private ObjectCreateNodeGen(JSContext context, JSBuiltin builtin, JavaScriptNode[] arguments) {
            super(context, builtin);
            this.arguments0_ = arguments != null && 0 < arguments.length ? arguments[0] : null;
            this.arguments1_ = arguments != null && 1 < arguments.length ? arguments[1] : null;
        }

        @Override
        public JavaScriptNode[] getArguments() {
            return new JavaScriptNode[] {this.arguments0_, this.arguments1_};
        }

        @Override
        public Object execute(VirtualFrame frameValue) {
            int state = state_;
            Object arguments0Value_ = this.arguments0_.execute(frameValue);
            Object arguments1Value_ = this.arguments1_.execute(frameValue);
            if ((state & 0b11) != 0 /* is-active createPrototypeNull(Object, Object) || createInvalidPrototype(Object, Object) */) {
                if ((state & 0b1) != 0 /* is-active createPrototypeNull(Object, Object) */) {
                    if ((JSGuards.isJSNull(arguments0Value_))) {
                        return createPrototypeNull(arguments0Value_, arguments1Value_);
                    }
                }
                if ((state & 0b10) != 0 /* is-active createInvalidPrototype(Object, Object) */) {
                    if ((!(JSGuards.isJSNull(arguments0Value_))) && (!(JSGuards.isJSObject(arguments0Value_)))) {
                        return createInvalidPrototype(arguments0Value_, arguments1Value_);
                    }
                }
            }
            if ((state & 0b11100) != 0 /* is-active create(VirtualFrame, DynamicObject, DynamicObject) || create(VirtualFrame, DynamicObject, Object) || createNull(DynamicObject, Object) */ && JSTypes.isDynamicObject(arguments0Value_)) {
                DynamicObject arguments0Value__ = (DynamicObject) arguments0Value_;
                if ((state & 0b100) != 0 /* is-active create(VirtualFrame, DynamicObject, DynamicObject) */ && JSTypes.isDynamicObject(arguments1Value_)) {
                    DynamicObject arguments1Value__ = (DynamicObject) arguments1Value_;
                    if ((JSGuards.isJSObject(arguments0Value__)) && (JSGuards.isJSObject(arguments1Value__))) {
                        return create(frameValue, arguments0Value__, arguments1Value__);
                    }
                }
                if ((state & 0b11000) != 0 /* is-active create(VirtualFrame, DynamicObject, Object) || createNull(DynamicObject, Object) */) {
                    if ((state & 0b1000) != 0 /* is-active create(VirtualFrame, DynamicObject, Object) */) {
                        if ((JSGuards.isJSObject(arguments0Value__)) && (!(JSGuards.isJSNull(arguments1Value_)))) {
                            return create(frameValue, arguments0Value__, arguments1Value_);
                        }
                    }
                    if ((state & 0b10000) != 0 /* is-active createNull(DynamicObject, Object) */) {
                        if ((JSGuards.isJSObject(arguments0Value__)) && (JSGuards.isJSNull(arguments1Value_))) {
                            return createNull(arguments0Value__, arguments1Value_);
                        }
                    }
                }
            }
            CompilerDirectives.transferToInterpreterAndInvalidate();
            return executeAndSpecialize(frameValue, arguments0Value_, arguments1Value_);
        }

        @Override
        public void executeVoid(VirtualFrame frameValue) {
            execute(frameValue);
            return;
        }

        private DynamicObject executeAndSpecialize(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
            int state = state_;
            if ((JSGuards.isJSNull(arguments0Value))) {
                this.state_ = state = state | 0b1 /* add-active createPrototypeNull(Object, Object) */;
                return createPrototypeNull(arguments0Value, arguments1Value);
            }
            if ((!(JSGuards.isJSNull(arguments0Value))) && (!(JSGuards.isJSObject(arguments0Value)))) {
                this.state_ = state = state | 0b10 /* add-active createInvalidPrototype(Object, Object) */;
                return createInvalidPrototype(arguments0Value, arguments1Value);
            }
            if (JSTypes.isDynamicObject(arguments0Value)) {
                DynamicObject arguments0Value_ = (DynamicObject) arguments0Value;
                if (JSTypes.isDynamicObject(arguments1Value)) {
                    DynamicObject arguments1Value_ = (DynamicObject) arguments1Value;
                    if ((JSGuards.isJSObject(arguments0Value_)) && (JSGuards.isJSObject(arguments1Value_))) {
                        this.state_ = state = state | 0b100 /* add-active create(VirtualFrame, DynamicObject, DynamicObject) */;
                        return create(frameValue, arguments0Value_, arguments1Value_);
                    }
                }
                if ((JSGuards.isJSObject(arguments0Value_)) && (!(JSGuards.isJSNull(arguments1Value)))) {
                    this.state_ = state = state | 0b1000 /* add-active create(VirtualFrame, DynamicObject, Object) */;
                    return create(frameValue, arguments0Value_, arguments1Value);
                }
                if ((JSGuards.isJSObject(arguments0Value_)) && (JSGuards.isJSNull(arguments1Value))) {
                    this.state_ = state = state | 0b10000 /* add-active createNull(DynamicObject, Object) */;
                    return createNull(arguments0Value_, arguments1Value);
                }
            }
            throw new UnsupportedSpecializationException(this, new Node[] {this.arguments0_, this.arguments1_}, arguments0Value, arguments1Value);
        }

        @Override
        public NodeCost getCost() {
            int state = state_;
            if (state == 0b0) {
                return NodeCost.UNINITIALIZED;
            } else if ((state & (state - 1)) == 0 /* is-single-active  */) {
                return NodeCost.MONOMORPHIC;
            }
            return NodeCost.POLYMORPHIC;
        }

        @Override
        public Introspection getIntrospectionData() {
            Object[] data = new Object[6];
            Object[] s;
            data[0] = 0;
            int state = state_;
            s = new Object[3];
            s[0] = "createPrototypeNull";
            if ((state & 0b1) != 0 /* is-active createPrototypeNull(Object, Object) */) {
                s[1] = (byte)0b01 /* active */;
            } else {
                s[1] = (byte)0b00 /* inactive */;
            }
            data[1] = s;
            s = new Object[3];
            s[0] = "createInvalidPrototype";
            if ((state & 0b10) != 0 /* is-active createInvalidPrototype(Object, Object) */) {
                s[1] = (byte)0b01 /* active */;
            } else {
                s[1] = (byte)0b00 /* inactive */;
            }
            data[2] = s;
            s = new Object[3];
            s[0] = "create";
            if ((state & 0b100) != 0 /* is-active create(VirtualFrame, DynamicObject, DynamicObject) */) {
                s[1] = (byte)0b01 /* active */;
            } else {
                s[1] = (byte)0b00 /* inactive */;
            }
            data[3] = s;
            s = new Object[3];
            s[0] = "create";
            if ((state & 0b1000) != 0 /* is-active create(VirtualFrame, DynamicObject, Object) */) {
                s[1] = (byte)0b01 /* active */;
            } else {
                s[1] = (byte)0b00 /* inactive */;
            }
            data[4] = s;
            s = new Object[3];
            s[0] = "createNull";
            if ((state & 0b10000) != 0 /* is-active createNull(DynamicObject, Object) */) {
                s[1] = (byte)0b01 /* active */;
            } else {
                s[1] = (byte)0b00 /* inactive */;
            }
            data[5] = s;
            return Provider.create(data);
        }

        public static ObjectCreateNode create(JSContext context, JSBuiltin builtin, JavaScriptNode[] arguments) {
            return new ObjectCreateNodeGen(context, builtin, arguments);
        }

    }
    @GeneratedBy(ObjectDefinePropertyNode.class)
    public static final class ObjectDefinePropertyNodeGen extends ObjectDefinePropertyNode implements Provider {

        @Child private JavaScriptNode arguments0_;
        @Child private JavaScriptNode arguments1_;
        @Child private JavaScriptNode arguments2_;

        private ObjectDefinePropertyNodeGen(JSContext context, JSBuiltin builtin, JavaScriptNode[] arguments) {
            super(context, builtin);
            this.arguments0_ = arguments != null && 0 < arguments.length ? arguments[0] : null;
            this.arguments1_ = arguments != null && 1 < arguments.length ? arguments[1] : null;
            this.arguments2_ = arguments != null && 2 < arguments.length ? arguments[2] : null;
        }

        @Override
        public JavaScriptNode[] getArguments() {
            return new JavaScriptNode[] {this.arguments0_, this.arguments1_, this.arguments2_};
        }

        @Override
        public Object execute(VirtualFrame frameValue) {
            Object arguments0Value_ = this.arguments0_.execute(frameValue);
            Object arguments1Value_ = this.arguments1_.execute(frameValue);
            Object arguments2Value_ = this.arguments2_.execute(frameValue);
            return defineProperty(arguments0Value_, arguments1Value_, arguments2Value_);
        }

        @Override
        public void executeVoid(VirtualFrame frameValue) {
            execute(frameValue);
            return;
        }

        @Override
        public NodeCost getCost() {
            return NodeCost.MONOMORPHIC;
        }

        @Override
        public Introspection getIntrospectionData() {
            Object[] data = new Object[2];
            Object[] s;
            data[0] = 0;
            s = new Object[3];
            s[0] = "defineProperty";
            s[1] = (byte)0b01 /* active */;
            data[1] = s;
            return Provider.create(data);
        }

        public static ObjectDefinePropertyNode create(JSContext context, JSBuiltin builtin, JavaScriptNode[] arguments) {
            return new ObjectDefinePropertyNodeGen(context, builtin, arguments);
        }

    }
    @GeneratedBy(ObjectDefinePropertiesNode.class)
    public static final class ObjectDefinePropertiesNodeGen extends ObjectDefinePropertiesNode implements Provider {

        @Child private JavaScriptNode arguments0_;
        @Child private JavaScriptNode arguments1_;

        private ObjectDefinePropertiesNodeGen(JSContext context, JSBuiltin builtin, JavaScriptNode[] arguments) {
            super(context, builtin);
            this.arguments0_ = arguments != null && 0 < arguments.length ? arguments[0] : null;
            this.arguments1_ = arguments != null && 1 < arguments.length ? arguments[1] : null;
        }

        @Override
        public JavaScriptNode[] getArguments() {
            return new JavaScriptNode[] {this.arguments0_, this.arguments1_};
        }

        @Override
        public Object execute(VirtualFrame frameValue) {
            Object arguments0Value_ = this.arguments0_.execute(frameValue);
            Object arguments1Value_ = this.arguments1_.execute(frameValue);
            return defineProperties(arguments0Value_, arguments1Value_);
        }

        @Override
        public void executeVoid(VirtualFrame frameValue) {
            execute(frameValue);
            return;
        }

        @Override
        public NodeCost getCost() {
            return NodeCost.MONOMORPHIC;
        }

        @Override
        public Introspection getIntrospectionData() {
            Object[] data = new Object[2];
            Object[] s;
            data[0] = 0;
            s = new Object[3];
            s[0] = "defineProperties";
            s[1] = (byte)0b01 /* active */;
            data[1] = s;
            return Provider.create(data);
        }

        public static ObjectDefinePropertiesNode create(JSContext context, JSBuiltin builtin, JavaScriptNode[] arguments) {
            return new ObjectDefinePropertiesNodeGen(context, builtin, arguments);
        }

    }
    @GeneratedBy(ObjectIsExtensibleNode.class)
    public static final class ObjectIsExtensibleNodeGen extends ObjectIsExtensibleNode implements Provider {

        @Child private JavaScriptNode arguments0_;
        @CompilationFinal private int state_;
        @Child private IsExtensibleNode isExtensible0_isExtensibleNode_;

        private ObjectIsExtensibleNodeGen(JSContext context, JSBuiltin builtin, JavaScriptNode[] arguments) {
            super(context, builtin);
            this.arguments0_ = arguments != null && 0 < arguments.length ? arguments[0] : null;
        }

        @Override
        public JavaScriptNode[] getArguments() {
            return new JavaScriptNode[] {this.arguments0_};
        }

        @Override
        public Object execute(VirtualFrame frameValue) {
            int state = state_;
            Object arguments0Value_ = this.arguments0_.execute(frameValue);
            if ((state & 0b1) != 0 /* is-active isExtensible(DynamicObject, IsExtensibleNode) */ && JSTypes.isDynamicObject(arguments0Value_)) {
                DynamicObject arguments0Value__ = (DynamicObject) arguments0Value_;
                if ((JSGuards.isJSObject(arguments0Value__))) {
                    return isExtensible(arguments0Value__, this.isExtensible0_isExtensibleNode_);
                }
            }
            if ((state & 0b10) != 0 /* is-active isExtensible(Object) */) {
                if ((!(JSGuards.isJSObject(arguments0Value_)))) {
                    return isExtensible(arguments0Value_);
                }
            }
            CompilerDirectives.transferToInterpreterAndInvalidate();
            return executeAndSpecialize(arguments0Value_);
        }

        @Override
        public boolean executeBoolean(VirtualFrame frameValue) {
            int state = state_;
            Object arguments0Value_ = this.arguments0_.execute(frameValue);
            if ((state & 0b1) != 0 /* is-active isExtensible(DynamicObject, IsExtensibleNode) */ && JSTypes.isDynamicObject(arguments0Value_)) {
                DynamicObject arguments0Value__ = (DynamicObject) arguments0Value_;
                if ((JSGuards.isJSObject(arguments0Value__))) {
                    return isExtensible(arguments0Value__, this.isExtensible0_isExtensibleNode_);
                }
            }
            if ((state & 0b10) != 0 /* is-active isExtensible(Object) */) {
                if ((!(JSGuards.isJSObject(arguments0Value_)))) {
                    return isExtensible(arguments0Value_);
                }
            }
            CompilerDirectives.transferToInterpreterAndInvalidate();
            return executeAndSpecialize(arguments0Value_);
        }

        @Override
        public void executeVoid(VirtualFrame frameValue) {
            executeBoolean(frameValue);
            return;
        }

        private boolean executeAndSpecialize(Object arguments0Value) {
            Lock lock = getLock();
            boolean hasLock = true;
            lock.lock();
            int state = state_;
            try {
                if (JSTypes.isDynamicObject(arguments0Value)) {
                    DynamicObject arguments0Value_ = (DynamicObject) arguments0Value;
                    if ((JSGuards.isJSObject(arguments0Value_))) {
                        this.isExtensible0_isExtensibleNode_ = super.insert((IsExtensibleNode.create()));
                        this.state_ = state = state | 0b1 /* add-active isExtensible(DynamicObject, IsExtensibleNode) */;
                        lock.unlock();
                        hasLock = false;
                        return isExtensible(arguments0Value_, this.isExtensible0_isExtensibleNode_);
                    }
                }
                if ((!(JSGuards.isJSObject(arguments0Value)))) {
                    this.state_ = state = state | 0b10 /* add-active isExtensible(Object) */;
                    lock.unlock();
                    hasLock = false;
                    return isExtensible(arguments0Value);
                }
                throw new UnsupportedSpecializationException(this, new Node[] {this.arguments0_}, arguments0Value);
            } finally {
                if (hasLock) {
                    lock.unlock();
                }
            }
        }

        @Override
        public NodeCost getCost() {
            int state = state_;
            if (state == 0b0) {
                return NodeCost.UNINITIALIZED;
            } else if ((state & (state - 1)) == 0 /* is-single-active  */) {
                return NodeCost.MONOMORPHIC;
            }
            return NodeCost.POLYMORPHIC;
        }

        @Override
        public Introspection getIntrospectionData() {
            Object[] data = new Object[3];
            Object[] s;
            data[0] = 0;
            int state = state_;
            s = new Object[3];
            s[0] = "isExtensible";
            if ((state & 0b1) != 0 /* is-active isExtensible(DynamicObject, IsExtensibleNode) */) {
                s[1] = (byte)0b01 /* active */;
                ArrayList<Object> cached = new ArrayList<>();
                cached.add(Arrays.asList(this.isExtensible0_isExtensibleNode_));
                s[2] = cached;
            } else {
                s[1] = (byte)0b00 /* inactive */;
            }
            data[1] = s;
            s = new Object[3];
            s[0] = "isExtensible";
            if ((state & 0b10) != 0 /* is-active isExtensible(Object) */) {
                s[1] = (byte)0b01 /* active */;
            } else {
                s[1] = (byte)0b00 /* inactive */;
            }
            data[2] = s;
            return Provider.create(data);
        }

        public static ObjectIsExtensibleNode create(JSContext context, JSBuiltin builtin, JavaScriptNode[] arguments) {
            return new ObjectIsExtensibleNodeGen(context, builtin, arguments);
        }

    }
    @GeneratedBy(ObjectPreventExtensionsNode.class)
    public static final class ObjectPreventExtensionsNodeGen extends ObjectPreventExtensionsNode implements Provider {

        @Child private JavaScriptNode arguments0_;
        @CompilationFinal private int state_;

        private ObjectPreventExtensionsNodeGen(JSContext context, JSBuiltin builtin, JavaScriptNode[] arguments) {
            super(context, builtin);
            this.arguments0_ = arguments != null && 0 < arguments.length ? arguments[0] : null;
        }

        @Override
        public JavaScriptNode[] getArguments() {
            return new JavaScriptNode[] {this.arguments0_};
        }

        @Override
        public Object execute(VirtualFrame frameValue) {
            int state = state_;
            Object arguments0Value_ = this.arguments0_.execute(frameValue);
            if ((state & 0b1) != 0 /* is-active preventExtensions(DynamicObject) */ && JSTypes.isDynamicObject(arguments0Value_)) {
                DynamicObject arguments0Value__ = (DynamicObject) arguments0Value_;
                if ((JSGuards.isJSObject(arguments0Value__))) {
                    return preventExtensions(arguments0Value__);
                }
            }
            if ((state & 0b10) != 0 /* is-active preventExtensions(Object) */) {
                if ((!(JSGuards.isJSObject(arguments0Value_)))) {
                    return preventExtensions(arguments0Value_);
                }
            }
            CompilerDirectives.transferToInterpreterAndInvalidate();
            return executeAndSpecialize(arguments0Value_);
        }

        @Override
        public void executeVoid(VirtualFrame frameValue) {
            execute(frameValue);
            return;
        }

        private Object executeAndSpecialize(Object arguments0Value) {
            int state = state_;
            if (JSTypes.isDynamicObject(arguments0Value)) {
                DynamicObject arguments0Value_ = (DynamicObject) arguments0Value;
                if ((JSGuards.isJSObject(arguments0Value_))) {
                    this.state_ = state = state | 0b1 /* add-active preventExtensions(DynamicObject) */;
                    return preventExtensions(arguments0Value_);
                }
            }
            if ((!(JSGuards.isJSObject(arguments0Value)))) {
                this.state_ = state = state | 0b10 /* add-active preventExtensions(Object) */;
                return preventExtensions(arguments0Value);
            }
            throw new UnsupportedSpecializationException(this, new Node[] {this.arguments0_}, arguments0Value);
        }

        @Override
        public NodeCost getCost() {
            int state = state_;
            if (state == 0b0) {
                return NodeCost.UNINITIALIZED;
            } else if ((state & (state - 1)) == 0 /* is-single-active  */) {
                return NodeCost.MONOMORPHIC;
            }
            return NodeCost.POLYMORPHIC;
        }

        @Override
        public Introspection getIntrospectionData() {
            Object[] data = new Object[3];
            Object[] s;
            data[0] = 0;
            int state = state_;
            s = new Object[3];
            s[0] = "preventExtensions";
            if ((state & 0b1) != 0 /* is-active preventExtensions(DynamicObject) */) {
                s[1] = (byte)0b01 /* active */;
            } else {
                s[1] = (byte)0b00 /* inactive */;
            }
            data[1] = s;
            s = new Object[3];
            s[0] = "preventExtensions";
            if ((state & 0b10) != 0 /* is-active preventExtensions(Object) */) {
                s[1] = (byte)0b01 /* active */;
            } else {
                s[1] = (byte)0b00 /* inactive */;
            }
            data[2] = s;
            return Provider.create(data);
        }

        public static ObjectPreventExtensionsNode create(JSContext context, JSBuiltin builtin, JavaScriptNode[] arguments) {
            return new ObjectPreventExtensionsNodeGen(context, builtin, arguments);
        }

    }
    @GeneratedBy(ObjectTestIntegrityLevelNode.class)
    public static final class ObjectTestIntegrityLevelNodeGen extends ObjectTestIntegrityLevelNode implements Provider {

        @Child private JavaScriptNode arguments0_;

        private ObjectTestIntegrityLevelNodeGen(JSContext context, JSBuiltin builtin, boolean frozen, JavaScriptNode[] arguments) {
            super(context, builtin, frozen);
            this.arguments0_ = arguments != null && 0 < arguments.length ? arguments[0] : null;
        }

        @Override
        public JavaScriptNode[] getArguments() {
            return new JavaScriptNode[] {this.arguments0_};
        }

        @Override
        public Object execute(VirtualFrame frameValue) {
            Object arguments0Value_ = this.arguments0_.execute(frameValue);
            return testIntegrityLevel(arguments0Value_);
        }

        @Override
        public boolean executeBoolean(VirtualFrame frameValue) {
            Object arguments0Value_ = this.arguments0_.execute(frameValue);
            return testIntegrityLevel(arguments0Value_);
        }

        @Override
        public void executeVoid(VirtualFrame frameValue) {
            executeBoolean(frameValue);
            return;
        }

        @Override
        public NodeCost getCost() {
            return NodeCost.MONOMORPHIC;
        }

        @Override
        public Introspection getIntrospectionData() {
            Object[] data = new Object[2];
            Object[] s;
            data[0] = 0;
            s = new Object[3];
            s[0] = "testIntegrityLevel";
            s[1] = (byte)0b01 /* active */;
            data[1] = s;
            return Provider.create(data);
        }

        public static ObjectTestIntegrityLevelNode create(JSContext context, JSBuiltin builtin, boolean frozen, JavaScriptNode[] arguments) {
            return new ObjectTestIntegrityLevelNodeGen(context, builtin, frozen, arguments);
        }

    }
    @GeneratedBy(ObjectSetIntegrityLevelNode.class)
    public static final class ObjectSetIntegrityLevelNodeGen extends ObjectSetIntegrityLevelNode implements Provider {

        @Child private JavaScriptNode arguments0_;

        private ObjectSetIntegrityLevelNodeGen(JSContext context, JSBuiltin builtin, boolean freeze, JavaScriptNode[] arguments) {
            super(context, builtin, freeze);
            this.arguments0_ = arguments != null && 0 < arguments.length ? arguments[0] : null;
        }

        @Override
        public JavaScriptNode[] getArguments() {
            return new JavaScriptNode[] {this.arguments0_};
        }

        @Override
        public Object execute(VirtualFrame frameValue) {
            Object arguments0Value_ = this.arguments0_.execute(frameValue);
            return setIntegrityLevel(arguments0Value_);
        }

        @Override
        public void executeVoid(VirtualFrame frameValue) {
            execute(frameValue);
            return;
        }

        @Override
        public NodeCost getCost() {
            return NodeCost.MONOMORPHIC;
        }

        @Override
        public Introspection getIntrospectionData() {
            Object[] data = new Object[2];
            Object[] s;
            data[0] = 0;
            s = new Object[3];
            s[0] = "setIntegrityLevel";
            s[1] = (byte)0b01 /* active */;
            data[1] = s;
            return Provider.create(data);
        }

        public static ObjectSetIntegrityLevelNode create(JSContext context, JSBuiltin builtin, boolean freeze, JavaScriptNode[] arguments) {
            return new ObjectSetIntegrityLevelNodeGen(context, builtin, freeze, arguments);
        }

    }
    @GeneratedBy(ObjectKeysNode.class)
    public static final class ObjectKeysNodeGen extends ObjectKeysNode implements Provider {

        @Child private JavaScriptNode arguments0_;
        @CompilationFinal private int state_;
        @CompilationFinal private int exclude_;
        @Child private Keys5Data keys5_cache;
        @Child private InteropLibrary keys6_members_;
        @CompilationFinal private BranchProfile keys6_growProfile_;

        private ObjectKeysNodeGen(JSContext context, JSBuiltin builtin, JavaScriptNode[] arguments) {
            super(context, builtin);
            this.arguments0_ = arguments != null && 0 < arguments.length ? arguments[0] : null;
        }

        @Override
        public JavaScriptNode[] getArguments() {
            return new JavaScriptNode[] {this.arguments0_};
        }

        @ExplodeLoop
        @Override
        public Object execute(VirtualFrame frameValue) {
            int state = state_;
            Object arguments0Value_ = this.arguments0_.execute(frameValue);
            if ((state & 0b1) != 0 /* is-active keysDynamicObject(DynamicObject) */ && JSTypes.isDynamicObject(arguments0Value_)) {
                DynamicObject arguments0Value__ = (DynamicObject) arguments0Value_;
                if ((JSGuards.isJSType(arguments0Value__))) {
                    return keysDynamicObject(arguments0Value__);
                }
            }
            if ((state & 0b10) != 0 /* is-active keys(Symbol) */ && arguments0Value_ instanceof Symbol) {
                Symbol arguments0Value__ = (Symbol) arguments0Value_;
                return keys(arguments0Value__);
            }
            if ((state & 0b100) != 0 /* is-active keys(JSLazyString) */ && arguments0Value_ instanceof JSLazyString) {
                JSLazyString arguments0Value__ = (JSLazyString) arguments0Value_;
                return keys(arguments0Value__);
            }
            if ((state & 0b1000) != 0 /* is-active keys(LargeInteger) */ && arguments0Value_ instanceof LargeInteger) {
                LargeInteger arguments0Value__ = (LargeInteger) arguments0Value_;
                return keys(arguments0Value__);
            }
            if ((state & 0b10000) != 0 /* is-active keys(BigInt) */ && arguments0Value_ instanceof BigInt) {
                BigInt arguments0Value__ = (BigInt) arguments0Value_;
                return keys(arguments0Value__);
            }
            if ((state & 0b11100000) != 0 /* is-active keys(Object) || keys(Object, InteropLibrary, InteropLibrary, BranchProfile) || keys(Object, InteropLibrary, InteropLibrary, BranchProfile) */) {
                if ((state & 0b100000) != 0 /* is-active keys(Object) */) {
                    if ((!(JSGuards.isTruffleObject(arguments0Value_)))) {
                        return keys(arguments0Value_);
                    }
                }
                if ((state & 0b1000000) != 0 /* is-active keys(Object, InteropLibrary, InteropLibrary, BranchProfile) */) {
                    Keys5Data s7_ = this.keys5_cache;
                    while (s7_ != null) {
                        if ((s7_.interop_.accepts(arguments0Value_)) && (JSGuards.isForeignObject(arguments0Value_))) {
                            return keys(arguments0Value_, s7_.interop_, s7_.members_, s7_.growProfile_);
                        }
                        s7_ = s7_.next_;
                    }
                }
                if ((state & 0b10000000) != 0 /* is-active keys(Object, InteropLibrary, InteropLibrary, BranchProfile) */) {
                    if ((JSGuards.isForeignObject(arguments0Value_))) {
                        return this.keys6Boundary(state, arguments0Value_);
                    }
                }
            }
            CompilerDirectives.transferToInterpreterAndInvalidate();
            return executeAndSpecialize(arguments0Value_);
        }

        @TruffleBoundary
        private Object keys6Boundary(int state, Object arguments0Value_) {
            Node prev_ = NodeUtil.pushEncapsulatingNode(this);
            try {
                return keys(arguments0Value_, (INTEROP_LIBRARY_.getUncached(arguments0Value_)), this.keys6_members_, this.keys6_growProfile_);
            } finally {
                NodeUtil.popEncapsulatingNode(prev_);
            }
        }

        @Override
        public void executeVoid(VirtualFrame frameValue) {
            execute(frameValue);
            return;
        }

        private DynamicObject executeAndSpecialize(Object arguments0Value) {
            Lock lock = getLock();
            boolean hasLock = true;
            lock.lock();
            int state = state_;
            int exclude = exclude_;
            try {
                if (JSTypes.isDynamicObject(arguments0Value)) {
                    DynamicObject arguments0Value_ = (DynamicObject) arguments0Value;
                    if ((JSGuards.isJSType(arguments0Value_))) {
                        this.state_ = state = state | 0b1 /* add-active keysDynamicObject(DynamicObject) */;
                        lock.unlock();
                        hasLock = false;
                        return keysDynamicObject(arguments0Value_);
                    }
                }
                if (arguments0Value instanceof Symbol) {
                    Symbol arguments0Value_ = (Symbol) arguments0Value;
                    this.state_ = state = state | 0b10 /* add-active keys(Symbol) */;
                    lock.unlock();
                    hasLock = false;
                    return keys(arguments0Value_);
                }
                if (arguments0Value instanceof JSLazyString) {
                    JSLazyString arguments0Value_ = (JSLazyString) arguments0Value;
                    this.state_ = state = state | 0b100 /* add-active keys(JSLazyString) */;
                    lock.unlock();
                    hasLock = false;
                    return keys(arguments0Value_);
                }
                if (arguments0Value instanceof LargeInteger) {
                    LargeInteger arguments0Value_ = (LargeInteger) arguments0Value;
                    this.state_ = state = state | 0b1000 /* add-active keys(LargeInteger) */;
                    lock.unlock();
                    hasLock = false;
                    return keys(arguments0Value_);
                }
                if (arguments0Value instanceof BigInt) {
                    BigInt arguments0Value_ = (BigInt) arguments0Value;
                    this.state_ = state = state | 0b10000 /* add-active keys(BigInt) */;
                    lock.unlock();
                    hasLock = false;
                    return keys(arguments0Value_);
                }
                if ((!(JSGuards.isTruffleObject(arguments0Value)))) {
                    this.state_ = state = state | 0b100000 /* add-active keys(Object) */;
                    lock.unlock();
                    hasLock = false;
                    return keys(arguments0Value);
                }
                if ((exclude) == 0 /* is-not-excluded keys(Object, InteropLibrary, InteropLibrary, BranchProfile) */) {
                    int count7_ = 0;
                    Keys5Data s7_ = this.keys5_cache;
                    if ((state & 0b1000000) != 0 /* is-active keys(Object, InteropLibrary, InteropLibrary, BranchProfile) */) {
                        while (s7_ != null) {
                            if ((s7_.interop_.accepts(arguments0Value)) && (JSGuards.isForeignObject(arguments0Value))) {
                                break;
                            }
                            s7_ = s7_.next_;
                            count7_++;
                        }
                    }
                    if (s7_ == null) {
                        if ((JSGuards.isForeignObject(arguments0Value)) && count7_ < (3)) {
                            // assert (s7_.interop_.accepts(arguments0Value));
                            s7_ = super.insert(new Keys5Data(keys5_cache));
                            s7_.interop_ = s7_.insertAccessor((INTEROP_LIBRARY_.create(arguments0Value)));
                            s7_.members_ = s7_.insertAccessor((INTEROP_LIBRARY_.createDispatched(3)));
                            s7_.growProfile_ = (BranchProfile.create());
                            this.keys5_cache = s7_;
                            this.state_ = state = state | 0b1000000 /* add-active keys(Object, InteropLibrary, InteropLibrary, BranchProfile) */;
                        }
                    }
                    if (s7_ != null) {
                        lock.unlock();
                        hasLock = false;
                        return keys(arguments0Value, s7_.interop_, s7_.members_, s7_.growProfile_);
                    }
                }
                {
                    Node prev_ = NodeUtil.pushEncapsulatingNode(this);
                    try {
                        if ((JSGuards.isForeignObject(arguments0Value))) {
                            this.keys6_members_ = super.insert((INTEROP_LIBRARY_.createDispatched(3)));
                            this.keys6_growProfile_ = (BranchProfile.create());
                            this.exclude_ = exclude = exclude | 0b1 /* add-excluded keys(Object, InteropLibrary, InteropLibrary, BranchProfile) */;
                            this.keys5_cache = null;
                            state = state & 0xffffffbf /* remove-active keys(Object, InteropLibrary, InteropLibrary, BranchProfile) */;
                            this.state_ = state = state | 0b10000000 /* add-active keys(Object, InteropLibrary, InteropLibrary, BranchProfile) */;
                            lock.unlock();
                            hasLock = false;
                            return keys(arguments0Value, (INTEROP_LIBRARY_.getUncached(arguments0Value)), this.keys6_members_, this.keys6_growProfile_);
                        }
                    } finally {
                        NodeUtil.popEncapsulatingNode(prev_);
                    }
                }
                throw new UnsupportedSpecializationException(this, new Node[] {this.arguments0_}, arguments0Value);
            } finally {
                if (hasLock) {
                    lock.unlock();
                }
            }
        }

        @Override
        public NodeCost getCost() {
            int state = state_;
            if (state == 0b0) {
                return NodeCost.UNINITIALIZED;
            } else if ((state & (state - 1)) == 0 /* is-single-active  */) {
                Keys5Data s7_ = this.keys5_cache;
                if ((s7_ == null || s7_.next_ == null)) {
                    return NodeCost.MONOMORPHIC;
                }
            }
            return NodeCost.POLYMORPHIC;
        }

        @Override
        public Introspection getIntrospectionData() {
            Object[] data = new Object[9];
            Object[] s;
            data[0] = 0;
            int state = state_;
            int exclude = exclude_;
            s = new Object[3];
            s[0] = "keysDynamicObject";
            if ((state & 0b1) != 0 /* is-active keysDynamicObject(DynamicObject) */) {
                s[1] = (byte)0b01 /* active */;
            } else {
                s[1] = (byte)0b00 /* inactive */;
            }
            data[1] = s;
            s = new Object[3];
            s[0] = "keys";
            if ((state & 0b10) != 0 /* is-active keys(Symbol) */) {
                s[1] = (byte)0b01 /* active */;
            } else {
                s[1] = (byte)0b00 /* inactive */;
            }
            data[2] = s;
            s = new Object[3];
            s[0] = "keys";
            if ((state & 0b100) != 0 /* is-active keys(JSLazyString) */) {
                s[1] = (byte)0b01 /* active */;
            } else {
                s[1] = (byte)0b00 /* inactive */;
            }
            data[3] = s;
            s = new Object[3];
            s[0] = "keys";
            if ((state & 0b1000) != 0 /* is-active keys(LargeInteger) */) {
                s[1] = (byte)0b01 /* active */;
            } else {
                s[1] = (byte)0b00 /* inactive */;
            }
            data[4] = s;
            s = new Object[3];
            s[0] = "keys";
            if ((state & 0b10000) != 0 /* is-active keys(BigInt) */) {
                s[1] = (byte)0b01 /* active */;
            } else {
                s[1] = (byte)0b00 /* inactive */;
            }
            data[5] = s;
            s = new Object[3];
            s[0] = "keys";
            if ((state & 0b100000) != 0 /* is-active keys(Object) */) {
                s[1] = (byte)0b01 /* active */;
            } else {
                s[1] = (byte)0b00 /* inactive */;
            }
            data[6] = s;
            s = new Object[3];
            s[0] = "keys";
            if ((state & 0b1000000) != 0 /* is-active keys(Object, InteropLibrary, InteropLibrary, BranchProfile) */) {
                s[1] = (byte)0b01 /* active */;
                ArrayList<Object> cached = new ArrayList<>();
                Keys5Data s7_ = this.keys5_cache;
                while (s7_ != null) {
                    cached.add(Arrays.asList(s7_.interop_, s7_.members_, s7_.growProfile_));
                    s7_ = s7_.next_;
                }
                s[2] = cached;
            } else if (exclude != 0 /* is-excluded keys(Object, InteropLibrary, InteropLibrary, BranchProfile) */) {
                s[1] = (byte)0b10 /* excluded */;
            } else {
                s[1] = (byte)0b00 /* inactive */;
            }
            data[7] = s;
            s = new Object[3];
            s[0] = "keys";
            if ((state & 0b10000000) != 0 /* is-active keys(Object, InteropLibrary, InteropLibrary, BranchProfile) */) {
                s[1] = (byte)0b01 /* active */;
                ArrayList<Object> cached = new ArrayList<>();
                cached.add(Arrays.asList(INTEROP_LIBRARY_.getUncached(), this.keys6_members_, this.keys6_growProfile_));
                s[2] = cached;
            } else {
                s[1] = (byte)0b00 /* inactive */;
            }
            data[8] = s;
            return Provider.create(data);
        }

        public static ObjectKeysNode create(JSContext context, JSBuiltin builtin, JavaScriptNode[] arguments) {
            return new ObjectKeysNodeGen(context, builtin, arguments);
        }

        @GeneratedBy(ObjectKeysNode.class)
        private static final class Keys5Data extends Node {

            @Child Keys5Data next_;
            @Child InteropLibrary interop_;
            @Child InteropLibrary members_;
            @CompilationFinal BranchProfile growProfile_;

            Keys5Data(Keys5Data next_) {
                this.next_ = next_;
            }

            @Override
            public NodeCost getCost() {
                return NodeCost.NONE;
            }

            <T extends Node> T insertAccessor(T node) {
                return super.insert(node);
            }

        }
    }
    @GeneratedBy(ObjectSetPrototypeOfNode.class)
    public static final class ObjectSetPrototypeOfNodeGen extends ObjectSetPrototypeOfNode implements Provider {

        @Child private JavaScriptNode arguments0_;
        @Child private JavaScriptNode arguments1_;
        @CompilationFinal private int state_;

        private ObjectSetPrototypeOfNodeGen(JSContext context, JSBuiltin builtin, JavaScriptNode[] arguments) {
            super(context, builtin);
            this.arguments0_ = arguments != null && 0 < arguments.length ? arguments[0] : null;
            this.arguments1_ = arguments != null && 1 < arguments.length ? arguments[1] : null;
        }

        @Override
        public JavaScriptNode[] getArguments() {
            return new JavaScriptNode[] {this.arguments0_, this.arguments1_};
        }

        @Override
        public Object execute(VirtualFrame frameValue) {
            int state = state_;
            Object arguments0Value_ = this.arguments0_.execute(frameValue);
            Object arguments1Value_ = this.arguments1_.execute(frameValue);
            if (state != 0 /* is-active setPrototypeOf(Object, DynamicObject) || setPrototypeOfNull(Object, DynamicObject) || setPrototypeOfInvalidNewProto(Object, Object) */) {
                if ((state & 0b11) != 0 /* is-active setPrototypeOf(Object, DynamicObject) || setPrototypeOfNull(Object, DynamicObject) */ && JSTypes.isDynamicObject(arguments1Value_)) {
                    DynamicObject arguments1Value__ = (DynamicObject) arguments1Value_;
                    if ((state & 0b1) != 0 /* is-active setPrototypeOf(Object, DynamicObject) */) {
                        if ((JSGuards.isJSObject(arguments1Value__))) {
                            return setPrototypeOf(arguments0Value_, arguments1Value__);
                        }
                    }
                    if ((state & 0b10) != 0 /* is-active setPrototypeOfNull(Object, DynamicObject) */) {
                        if ((JSGuards.isJSNull(arguments1Value__))) {
                            return setPrototypeOfNull(arguments0Value_, arguments1Value__);
                        }
                    }
                }
                if ((state & 0b100) != 0 /* is-active setPrototypeOfInvalidNewProto(Object, Object) */) {
                    if ((!(JSGuards.isJSObject(arguments1Value_))) && (!(JSGuards.isJSNull(arguments1Value_)))) {
                        return setPrototypeOfInvalidNewProto(arguments0Value_, arguments1Value_);
                    }
                }
            }
            CompilerDirectives.transferToInterpreterAndInvalidate();
            return executeAndSpecialize(arguments0Value_, arguments1Value_);
        }

        @Override
        public void executeVoid(VirtualFrame frameValue) {
            execute(frameValue);
            return;
        }

        private Object executeAndSpecialize(Object arguments0Value, Object arguments1Value) {
            int state = state_;
            if (JSTypes.isDynamicObject(arguments1Value)) {
                DynamicObject arguments1Value_ = (DynamicObject) arguments1Value;
                if ((JSGuards.isJSObject(arguments1Value_))) {
                    this.state_ = state = state | 0b1 /* add-active setPrototypeOf(Object, DynamicObject) */;
                    return setPrototypeOf(arguments0Value, arguments1Value_);
                }
                if ((JSGuards.isJSNull(arguments1Value_))) {
                    this.state_ = state = state | 0b10 /* add-active setPrototypeOfNull(Object, DynamicObject) */;
                    return setPrototypeOfNull(arguments0Value, arguments1Value_);
                }
            }
            if ((!(JSGuards.isJSObject(arguments1Value))) && (!(JSGuards.isJSNull(arguments1Value)))) {
                this.state_ = state = state | 0b100 /* add-active setPrototypeOfInvalidNewProto(Object, Object) */;
                return setPrototypeOfInvalidNewProto(arguments0Value, arguments1Value);
            }
            throw new UnsupportedSpecializationException(this, new Node[] {this.arguments0_, this.arguments1_}, arguments0Value, arguments1Value);
        }

        @Override
        public NodeCost getCost() {
            int state = state_;
            if (state == 0b0) {
                return NodeCost.UNINITIALIZED;
            } else if ((state & (state - 1)) == 0 /* is-single-active  */) {
                return NodeCost.MONOMORPHIC;
            }
            return NodeCost.POLYMORPHIC;
        }

        @Override
        public Introspection getIntrospectionData() {
            Object[] data = new Object[4];
            Object[] s;
            data[0] = 0;
            int state = state_;
            s = new Object[3];
            s[0] = "setPrototypeOf";
            if ((state & 0b1) != 0 /* is-active setPrototypeOf(Object, DynamicObject) */) {
                s[1] = (byte)0b01 /* active */;
            } else {
                s[1] = (byte)0b00 /* inactive */;
            }
            data[1] = s;
            s = new Object[3];
            s[0] = "setPrototypeOfNull";
            if ((state & 0b10) != 0 /* is-active setPrototypeOfNull(Object, DynamicObject) */) {
                s[1] = (byte)0b01 /* active */;
            } else {
                s[1] = (byte)0b00 /* inactive */;
            }
            data[2] = s;
            s = new Object[3];
            s[0] = "setPrototypeOfInvalidNewProto";
            if ((state & 0b100) != 0 /* is-active setPrototypeOfInvalidNewProto(Object, Object) */) {
                s[1] = (byte)0b01 /* active */;
            } else {
                s[1] = (byte)0b00 /* inactive */;
            }
            data[3] = s;
            return Provider.create(data);
        }

        public static ObjectSetPrototypeOfNode create(JSContext context, JSBuiltin builtin, JavaScriptNode[] arguments) {
            return new ObjectSetPrototypeOfNodeGen(context, builtin, arguments);
        }

    }
    @GeneratedBy(ObjectIsNode.class)
    public static final class ObjectIsNodeGen extends ObjectIsNode implements Provider {

        @Child private JavaScriptNode arguments0_;
        @Child private JavaScriptNode arguments1_;
        @CompilationFinal private int state_;
        @Child private JSIdenticalNode isNumberNumber_doIdenticalNode_;
        @Child private JSIdenticalNode isObject_doIdenticalNode_;

        private ObjectIsNodeGen(JSContext context, JSBuiltin builtin, JavaScriptNode[] arguments) {
            super(context, builtin);
            this.arguments0_ = arguments != null && 0 < arguments.length ? arguments[0] : null;
            this.arguments1_ = arguments != null && 1 < arguments.length ? arguments[1] : null;
        }

        @Override
        public JavaScriptNode[] getArguments() {
            return new JavaScriptNode[] {this.arguments0_, this.arguments1_};
        }

        @Override
        public Object execute(VirtualFrame frameValue) {
            int state = state_;
            if ((state & 0b1110) == 0 /* only-active isInt(int, int) */ && (state & 0b1111) != 0  /* is-not isInt(int, int) && isDouble(double, double) && isNumberNumber(Number, Number, JSIdenticalNode) && isObject(Object, Object, JSIdenticalNode) */) {
                return execute_int_int0(frameValue, state);
            } else if ((state & 0b1101) == 0 /* only-active isDouble(double, double) */ && (state & 0b1111) != 0  /* is-not isInt(int, int) && isDouble(double, double) && isNumberNumber(Number, Number, JSIdenticalNode) && isObject(Object, Object, JSIdenticalNode) */) {
                return execute_double_double1(frameValue, state);
            } else {
                return execute_generic2(frameValue, state);
            }
        }

        private Object execute_int_int0(VirtualFrame frameValue, int state) {
            int arguments0Value_;
            try {
                arguments0Value_ = this.arguments0_.executeInt(frameValue);
            } catch (UnexpectedResultException ex) {
                Object arguments1Value = this.arguments1_.execute(frameValue);
                return executeAndSpecialize(ex.getResult(), arguments1Value);
            }
            int arguments1Value_;
            try {
                arguments1Value_ = this.arguments1_.executeInt(frameValue);
            } catch (UnexpectedResultException ex) {
                return executeAndSpecialize(arguments0Value_, ex.getResult());
            }
            assert (state & 0b1) != 0 /* is-active isInt(int, int) */;
            return isInt(arguments0Value_, arguments1Value_);
        }

        private Object execute_double_double1(VirtualFrame frameValue, int state) {
            int arguments0Value_int = 0;
            long arguments0Value_long = 0L;
            double arguments0Value_;
            try {
                if ((state & 0b11100000) == 0 /* only-active 0:double */ && (state & 0b1111) != 0  /* is-not isInt(int, int) && isDouble(double, double) && isNumberNumber(Number, Number, JSIdenticalNode) && isObject(Object, Object, JSIdenticalNode) */) {
                    arguments0Value_long = this.arguments0_.executeLong(frameValue);
                    arguments0Value_ = JSTypes.longToDouble(arguments0Value_long);
                } else if ((state & 0b11010000) == 0 /* only-active 0:double */ && (state & 0b1111) != 0  /* is-not isInt(int, int) && isDouble(double, double) && isNumberNumber(Number, Number, JSIdenticalNode) && isObject(Object, Object, JSIdenticalNode) */) {
                    arguments0Value_int = this.arguments0_.executeInt(frameValue);
                    arguments0Value_ = JSTypes.intToDouble(arguments0Value_int);
                } else if ((state & 0b10110000) == 0 /* only-active 0:double */ && (state & 0b1111) != 0  /* is-not isInt(int, int) && isDouble(double, double) && isNumberNumber(Number, Number, JSIdenticalNode) && isObject(Object, Object, JSIdenticalNode) */) {
                    arguments0Value_ = this.arguments0_.executeDouble(frameValue);
                } else {
                    Object arguments0Value__ = this.arguments0_.execute(frameValue);
                    arguments0Value_ = JSTypesGen.expectImplicitDouble((state & 0b11110000) >>> 4 /* extract-implicit-active 0:double */, arguments0Value__);
                }
            } catch (UnexpectedResultException ex) {
                Object arguments1Value = this.arguments1_.execute(frameValue);
                return executeAndSpecialize(ex.getResult(), arguments1Value);
            }
            int arguments1Value_int = 0;
            long arguments1Value_long = 0L;
            double arguments1Value_;
            try {
                if ((state & 0b111000000000) == 0 /* only-active 1:double */ && (state & 0b1111) != 0  /* is-not isInt(int, int) && isDouble(double, double) && isNumberNumber(Number, Number, JSIdenticalNode) && isObject(Object, Object, JSIdenticalNode) */) {
                    arguments1Value_long = this.arguments1_.executeLong(frameValue);
                    arguments1Value_ = JSTypes.longToDouble(arguments1Value_long);
                } else if ((state & 0b110100000000) == 0 /* only-active 1:double */ && (state & 0b1111) != 0  /* is-not isInt(int, int) && isDouble(double, double) && isNumberNumber(Number, Number, JSIdenticalNode) && isObject(Object, Object, JSIdenticalNode) */) {
                    arguments1Value_int = this.arguments1_.executeInt(frameValue);
                    arguments1Value_ = JSTypes.intToDouble(arguments1Value_int);
                } else if ((state & 0b101100000000) == 0 /* only-active 1:double */ && (state & 0b1111) != 0  /* is-not isInt(int, int) && isDouble(double, double) && isNumberNumber(Number, Number, JSIdenticalNode) && isObject(Object, Object, JSIdenticalNode) */) {
                    arguments1Value_ = this.arguments1_.executeDouble(frameValue);
                } else {
                    Object arguments1Value__ = this.arguments1_.execute(frameValue);
                    arguments1Value_ = JSTypesGen.expectImplicitDouble((state & 0b111100000000) >>> 8 /* extract-implicit-active 1:double */, arguments1Value__);
                }
            } catch (UnexpectedResultException ex) {
                return executeAndSpecialize(((state & 0b11100000) == 0 /* only-active 0:double */ && (state & 0b1111) != 0  /* is-not isInt(int, int) && isDouble(double, double) && isNumberNumber(Number, Number, JSIdenticalNode) && isObject(Object, Object, JSIdenticalNode) */ ? (Object) arguments0Value_long : ((state & 0b11010000) == 0 /* only-active 0:double */ && (state & 0b1111) != 0  /* is-not isInt(int, int) && isDouble(double, double) && isNumberNumber(Number, Number, JSIdenticalNode) && isObject(Object, Object, JSIdenticalNode) */ ? (Object) arguments0Value_int : (Object) arguments0Value_)), ex.getResult());
            }
            assert (state & 0b10) != 0 /* is-active isDouble(double, double) */;
            return isDouble(arguments0Value_, arguments1Value_);
        }

        private Object execute_generic2(VirtualFrame frameValue, int state) {
            Object arguments0Value_ = this.arguments0_.execute(frameValue);
            Object arguments1Value_ = this.arguments1_.execute(frameValue);
            if ((state & 0b1) != 0 /* is-active isInt(int, int) */ && arguments0Value_ instanceof Integer) {
                int arguments0Value__ = (int) arguments0Value_;
                if (arguments1Value_ instanceof Integer) {
                    int arguments1Value__ = (int) arguments1Value_;
                    return isInt(arguments0Value__, arguments1Value__);
                }
            }
            if ((state & 0b10) != 0 /* is-active isDouble(double, double) */ && JSTypesGen.isImplicitDouble((state & 0b11110000) >>> 4 /* extract-implicit-active 0:double */, arguments0Value_)) {
                double arguments0Value__ = JSTypesGen.asImplicitDouble((state & 0b11110000) >>> 4 /* extract-implicit-active 0:double */, arguments0Value_);
                if (JSTypesGen.isImplicitDouble((state & 0b111100000000) >>> 8 /* extract-implicit-active 1:double */, arguments1Value_)) {
                    double arguments1Value__ = JSTypesGen.asImplicitDouble((state & 0b111100000000) >>> 8 /* extract-implicit-active 1:double */, arguments1Value_);
                    return isDouble(arguments0Value__, arguments1Value__);
                }
            }
            if ((state & 0b100) != 0 /* is-active isNumberNumber(Number, Number, JSIdenticalNode) */ && arguments0Value_ instanceof Number) {
                Number arguments0Value__ = (Number) arguments0Value_;
                if (arguments1Value_ instanceof Number) {
                    Number arguments1Value__ = (Number) arguments1Value_;
                    if ((isNumberNumber(arguments0Value__, arguments1Value__))) {
                        return isNumberNumber(arguments0Value__, arguments1Value__, this.isNumberNumber_doIdenticalNode_);
                    }
                }
            }
            if ((state & 0b1000) != 0 /* is-active isObject(Object, Object, JSIdenticalNode) */) {
                if ((!(isNumberNumber(arguments0Value_, arguments1Value_)))) {
                    return isObject(arguments0Value_, arguments1Value_, this.isObject_doIdenticalNode_);
                }
            }
            CompilerDirectives.transferToInterpreterAndInvalidate();
            return executeAndSpecialize(arguments0Value_, arguments1Value_);
        }

        @Override
        public boolean executeBoolean(VirtualFrame frameValue) {
            int state = state_;
            if ((state & 0b1110) == 0 /* only-active isInt(int, int) */ && (state & 0b1111) != 0  /* is-not isInt(int, int) && isDouble(double, double) && isNumberNumber(Number, Number, JSIdenticalNode) && isObject(Object, Object, JSIdenticalNode) */) {
                return executeBoolean_int_int3(frameValue, state);
            } else if ((state & 0b1101) == 0 /* only-active isDouble(double, double) */ && (state & 0b1111) != 0  /* is-not isInt(int, int) && isDouble(double, double) && isNumberNumber(Number, Number, JSIdenticalNode) && isObject(Object, Object, JSIdenticalNode) */) {
                return executeBoolean_double_double4(frameValue, state);
            } else {
                return executeBoolean_generic5(frameValue, state);
            }
        }

        private boolean executeBoolean_int_int3(VirtualFrame frameValue, int state) {
            int arguments0Value_;
            try {
                arguments0Value_ = this.arguments0_.executeInt(frameValue);
            } catch (UnexpectedResultException ex) {
                Object arguments1Value = this.arguments1_.execute(frameValue);
                return executeAndSpecialize(ex.getResult(), arguments1Value);
            }
            int arguments1Value_;
            try {
                arguments1Value_ = this.arguments1_.executeInt(frameValue);
            } catch (UnexpectedResultException ex) {
                return executeAndSpecialize(arguments0Value_, ex.getResult());
            }
            assert (state & 0b1) != 0 /* is-active isInt(int, int) */;
            return isInt(arguments0Value_, arguments1Value_);
        }

        private boolean executeBoolean_double_double4(VirtualFrame frameValue, int state) {
            int arguments0Value_int = 0;
            long arguments0Value_long = 0L;
            double arguments0Value_;
            try {
                if ((state & 0b11100000) == 0 /* only-active 0:double */ && (state & 0b1111) != 0  /* is-not isInt(int, int) && isDouble(double, double) && isNumberNumber(Number, Number, JSIdenticalNode) && isObject(Object, Object, JSIdenticalNode) */) {
                    arguments0Value_long = this.arguments0_.executeLong(frameValue);
                    arguments0Value_ = JSTypes.longToDouble(arguments0Value_long);
                } else if ((state & 0b11010000) == 0 /* only-active 0:double */ && (state & 0b1111) != 0  /* is-not isInt(int, int) && isDouble(double, double) && isNumberNumber(Number, Number, JSIdenticalNode) && isObject(Object, Object, JSIdenticalNode) */) {
                    arguments0Value_int = this.arguments0_.executeInt(frameValue);
                    arguments0Value_ = JSTypes.intToDouble(arguments0Value_int);
                } else if ((state & 0b10110000) == 0 /* only-active 0:double */ && (state & 0b1111) != 0  /* is-not isInt(int, int) && isDouble(double, double) && isNumberNumber(Number, Number, JSIdenticalNode) && isObject(Object, Object, JSIdenticalNode) */) {
                    arguments0Value_ = this.arguments0_.executeDouble(frameValue);
                } else {
                    Object arguments0Value__ = this.arguments0_.execute(frameValue);
                    arguments0Value_ = JSTypesGen.expectImplicitDouble((state & 0b11110000) >>> 4 /* extract-implicit-active 0:double */, arguments0Value__);
                }
            } catch (UnexpectedResultException ex) {
                Object arguments1Value = this.arguments1_.execute(frameValue);
                return executeAndSpecialize(ex.getResult(), arguments1Value);
            }
            int arguments1Value_int = 0;
            long arguments1Value_long = 0L;
            double arguments1Value_;
            try {
                if ((state & 0b111000000000) == 0 /* only-active 1:double */ && (state & 0b1111) != 0  /* is-not isInt(int, int) && isDouble(double, double) && isNumberNumber(Number, Number, JSIdenticalNode) && isObject(Object, Object, JSIdenticalNode) */) {
                    arguments1Value_long = this.arguments1_.executeLong(frameValue);
                    arguments1Value_ = JSTypes.longToDouble(arguments1Value_long);
                } else if ((state & 0b110100000000) == 0 /* only-active 1:double */ && (state & 0b1111) != 0  /* is-not isInt(int, int) && isDouble(double, double) && isNumberNumber(Number, Number, JSIdenticalNode) && isObject(Object, Object, JSIdenticalNode) */) {
                    arguments1Value_int = this.arguments1_.executeInt(frameValue);
                    arguments1Value_ = JSTypes.intToDouble(arguments1Value_int);
                } else if ((state & 0b101100000000) == 0 /* only-active 1:double */ && (state & 0b1111) != 0  /* is-not isInt(int, int) && isDouble(double, double) && isNumberNumber(Number, Number, JSIdenticalNode) && isObject(Object, Object, JSIdenticalNode) */) {
                    arguments1Value_ = this.arguments1_.executeDouble(frameValue);
                } else {
                    Object arguments1Value__ = this.arguments1_.execute(frameValue);
                    arguments1Value_ = JSTypesGen.expectImplicitDouble((state & 0b111100000000) >>> 8 /* extract-implicit-active 1:double */, arguments1Value__);
                }
            } catch (UnexpectedResultException ex) {
                return executeAndSpecialize(((state & 0b11100000) == 0 /* only-active 0:double */ && (state & 0b1111) != 0  /* is-not isInt(int, int) && isDouble(double, double) && isNumberNumber(Number, Number, JSIdenticalNode) && isObject(Object, Object, JSIdenticalNode) */ ? (Object) arguments0Value_long : ((state & 0b11010000) == 0 /* only-active 0:double */ && (state & 0b1111) != 0  /* is-not isInt(int, int) && isDouble(double, double) && isNumberNumber(Number, Number, JSIdenticalNode) && isObject(Object, Object, JSIdenticalNode) */ ? (Object) arguments0Value_int : (Object) arguments0Value_)), ex.getResult());
            }
            assert (state & 0b10) != 0 /* is-active isDouble(double, double) */;
            return isDouble(arguments0Value_, arguments1Value_);
        }

        private boolean executeBoolean_generic5(VirtualFrame frameValue, int state) {
            Object arguments0Value_ = this.arguments0_.execute(frameValue);
            Object arguments1Value_ = this.arguments1_.execute(frameValue);
            if ((state & 0b1) != 0 /* is-active isInt(int, int) */ && arguments0Value_ instanceof Integer) {
                int arguments0Value__ = (int) arguments0Value_;
                if (arguments1Value_ instanceof Integer) {
                    int arguments1Value__ = (int) arguments1Value_;
                    return isInt(arguments0Value__, arguments1Value__);
                }
            }
            if ((state & 0b10) != 0 /* is-active isDouble(double, double) */ && JSTypesGen.isImplicitDouble((state & 0b11110000) >>> 4 /* extract-implicit-active 0:double */, arguments0Value_)) {
                double arguments0Value__ = JSTypesGen.asImplicitDouble((state & 0b11110000) >>> 4 /* extract-implicit-active 0:double */, arguments0Value_);
                if (JSTypesGen.isImplicitDouble((state & 0b111100000000) >>> 8 /* extract-implicit-active 1:double */, arguments1Value_)) {
                    double arguments1Value__ = JSTypesGen.asImplicitDouble((state & 0b111100000000) >>> 8 /* extract-implicit-active 1:double */, arguments1Value_);
                    return isDouble(arguments0Value__, arguments1Value__);
                }
            }
            if ((state & 0b100) != 0 /* is-active isNumberNumber(Number, Number, JSIdenticalNode) */ && arguments0Value_ instanceof Number) {
                Number arguments0Value__ = (Number) arguments0Value_;
                if (arguments1Value_ instanceof Number) {
                    Number arguments1Value__ = (Number) arguments1Value_;
                    if ((isNumberNumber(arguments0Value__, arguments1Value__))) {
                        return isNumberNumber(arguments0Value__, arguments1Value__, this.isNumberNumber_doIdenticalNode_);
                    }
                }
            }
            if ((state & 0b1000) != 0 /* is-active isObject(Object, Object, JSIdenticalNode) */) {
                if ((!(isNumberNumber(arguments0Value_, arguments1Value_)))) {
                    return isObject(arguments0Value_, arguments1Value_, this.isObject_doIdenticalNode_);
                }
            }
            CompilerDirectives.transferToInterpreterAndInvalidate();
            return executeAndSpecialize(arguments0Value_, arguments1Value_);
        }

        @Override
        public void executeVoid(VirtualFrame frameValue) {
            executeBoolean(frameValue);
            return;
        }

        private boolean executeAndSpecialize(Object arguments0Value, Object arguments1Value) {
            Lock lock = getLock();
            boolean hasLock = true;
            lock.lock();
            int state = state_;
            try {
                if (arguments0Value instanceof Integer) {
                    int arguments0Value_ = (int) arguments0Value;
                    if (arguments1Value instanceof Integer) {
                        int arguments1Value_ = (int) arguments1Value;
                        this.state_ = state = state | 0b1 /* add-active isInt(int, int) */;
                        lock.unlock();
                        hasLock = false;
                        return isInt(arguments0Value_, arguments1Value_);
                    }
                }
                {
                    int doubleCast0;
                    if ((doubleCast0 = JSTypesGen.specializeImplicitDouble(arguments0Value)) != 0) {
                        double arguments0Value_ = JSTypesGen.asImplicitDouble(doubleCast0, arguments0Value);
                        int doubleCast1;
                        if ((doubleCast1 = JSTypesGen.specializeImplicitDouble(arguments1Value)) != 0) {
                            double arguments1Value_ = JSTypesGen.asImplicitDouble(doubleCast1, arguments1Value);
                            state = (state | (doubleCast0 << 4) /* set-implicit-active 0:double */);
                            state = (state | (doubleCast1 << 8) /* set-implicit-active 1:double */);
                            this.state_ = state = state | 0b10 /* add-active isDouble(double, double) */;
                            lock.unlock();
                            hasLock = false;
                            return isDouble(arguments0Value_, arguments1Value_);
                        }
                    }
                }
                if (arguments0Value instanceof Number) {
                    Number arguments0Value_ = (Number) arguments0Value;
                    if (arguments1Value instanceof Number) {
                        Number arguments1Value_ = (Number) arguments1Value;
                        if ((isNumberNumber(arguments0Value_, arguments1Value_))) {
                            this.isNumberNumber_doIdenticalNode_ = super.insert((JSIdenticalNode.createSameValue()));
                            this.state_ = state = state | 0b100 /* add-active isNumberNumber(Number, Number, JSIdenticalNode) */;
                            lock.unlock();
                            hasLock = false;
                            return isNumberNumber(arguments0Value_, arguments1Value_, this.isNumberNumber_doIdenticalNode_);
                        }
                    }
                }
                if ((!(isNumberNumber(arguments0Value, arguments1Value)))) {
                    this.isObject_doIdenticalNode_ = super.insert((JSIdenticalNode.createSameValue()));
                    this.state_ = state = state | 0b1000 /* add-active isObject(Object, Object, JSIdenticalNode) */;
                    lock.unlock();
                    hasLock = false;
                    return isObject(arguments0Value, arguments1Value, this.isObject_doIdenticalNode_);
                }
                throw new UnsupportedSpecializationException(this, new Node[] {this.arguments0_, this.arguments1_}, arguments0Value, arguments1Value);
            } finally {
                if (hasLock) {
                    lock.unlock();
                }
            }
        }

        @Override
        public NodeCost getCost() {
            int state = state_;
            if ((state & 0b1111) == 0b0) {
                return NodeCost.UNINITIALIZED;
            } else if (((state & 0b1111) & ((state & 0b1111) - 1)) == 0 /* is-single-active  */) {
                return NodeCost.MONOMORPHIC;
            }
            return NodeCost.POLYMORPHIC;
        }

        @Override
        public Introspection getIntrospectionData() {
            Object[] data = new Object[5];
            Object[] s;
            data[0] = 0;
            int state = state_;
            s = new Object[3];
            s[0] = "isInt";
            if ((state & 0b1) != 0 /* is-active isInt(int, int) */) {
                s[1] = (byte)0b01 /* active */;
            } else {
                s[1] = (byte)0b00 /* inactive */;
            }
            data[1] = s;
            s = new Object[3];
            s[0] = "isDouble";
            if ((state & 0b10) != 0 /* is-active isDouble(double, double) */) {
                s[1] = (byte)0b01 /* active */;
            } else {
                s[1] = (byte)0b00 /* inactive */;
            }
            data[2] = s;
            s = new Object[3];
            s[0] = "isNumberNumber";
            if ((state & 0b100) != 0 /* is-active isNumberNumber(Number, Number, JSIdenticalNode) */) {
                s[1] = (byte)0b01 /* active */;
                ArrayList<Object> cached = new ArrayList<>();
                cached.add(Arrays.asList(this.isNumberNumber_doIdenticalNode_));
                s[2] = cached;
            } else {
                s[1] = (byte)0b00 /* inactive */;
            }
            data[3] = s;
            s = new Object[3];
            s[0] = "isObject";
            if ((state & 0b1000) != 0 /* is-active isObject(Object, Object, JSIdenticalNode) */) {
                s[1] = (byte)0b01 /* active */;
                ArrayList<Object> cached = new ArrayList<>();
                cached.add(Arrays.asList(this.isObject_doIdenticalNode_));
                s[2] = cached;
            } else {
                s[1] = (byte)0b00 /* inactive */;
            }
            data[4] = s;
            return Provider.create(data);
        }

        public static ObjectIsNode create(JSContext context, JSBuiltin builtin, JavaScriptNode[] arguments) {
            return new ObjectIsNodeGen(context, builtin, arguments);
        }

    }
    @GeneratedBy(ObjectAssignNode.class)
    public static final class ObjectAssignNodeGen extends ObjectAssignNode implements Provider {

        @Child private JavaScriptNode arguments0_;
        @Child private JavaScriptNode arguments1_;
        @CompilationFinal private int state_;
        @Child private AssignData assign_cache;

        private ObjectAssignNodeGen(JSContext context, JSBuiltin builtin, JavaScriptNode[] arguments) {
            super(context, builtin);
            this.arguments0_ = arguments != null && 0 < arguments.length ? arguments[0] : null;
            this.arguments1_ = arguments != null && 1 < arguments.length ? arguments[1] : null;
        }

        @Override
        public JavaScriptNode[] getArguments() {
            return new JavaScriptNode[] {this.arguments0_, this.arguments1_};
        }

        @Override
        public Object execute(VirtualFrame frameValue) {
            int state = state_;
            Object arguments0Value_ = this.arguments0_.execute(frameValue);
            Object arguments1Value_ = this.arguments1_.execute(frameValue);
            if (state != 0 /* is-active assign(Object, Object[], JSToObjectNode, WriteElementNode, AssignPropertiesNode) */ && arguments1Value_ instanceof Object[]) {
                Object[] arguments1Value__ = (Object[]) arguments1Value_;
                AssignData s1_ = this.assign_cache;
                if (s1_ != null) {
                    return assign(arguments0Value_, arguments1Value__, s1_.toObjectNode_, s1_.write_, s1_.assignProperties_);
                }
            }
            CompilerDirectives.transferToInterpreterAndInvalidate();
            return executeAndSpecialize(arguments0Value_, arguments1Value_);
        }

        @Override
        public void executeVoid(VirtualFrame frameValue) {
            execute(frameValue);
            return;
        }

        private Object executeAndSpecialize(Object arguments0Value, Object arguments1Value) {
            Lock lock = getLock();
            boolean hasLock = true;
            lock.lock();
            int state = state_;
            try {
                if (arguments1Value instanceof Object[]) {
                    Object[] arguments1Value_ = (Object[]) arguments1Value;
                    AssignData s1_ = super.insert(new AssignData());
                    s1_.toObjectNode_ = s1_.insertAccessor((JSToObjectNode.createToObject(getContext())));
                    s1_.write_ = s1_.insertAccessor((WriteElementNode.create(getContext(), ObjectAssignNode.STRICT)));
                    s1_.assignProperties_ = s1_.insertAccessor((AssignPropertiesNodeGen.create(getContext())));
                    this.assign_cache = s1_;
                    this.state_ = state = state | 0b1 /* add-active assign(Object, Object[], JSToObjectNode, WriteElementNode, AssignPropertiesNode) */;
                    lock.unlock();
                    hasLock = false;
                    return assign(arguments0Value, arguments1Value_, s1_.toObjectNode_, s1_.write_, s1_.assignProperties_);
                }
                throw new UnsupportedSpecializationException(this, new Node[] {this.arguments0_, this.arguments1_}, arguments0Value, arguments1Value);
            } finally {
                if (hasLock) {
                    lock.unlock();
                }
            }
        }

        @Override
        public NodeCost getCost() {
            int state = state_;
            if (state == 0b0) {
                return NodeCost.UNINITIALIZED;
            } else {
                return NodeCost.MONOMORPHIC;
            }
        }

        @Override
        public Introspection getIntrospectionData() {
            Object[] data = new Object[2];
            Object[] s;
            data[0] = 0;
            int state = state_;
            s = new Object[3];
            s[0] = "assign";
            if (state != 0 /* is-active assign(Object, Object[], JSToObjectNode, WriteElementNode, AssignPropertiesNode) */) {
                s[1] = (byte)0b01 /* active */;
                ArrayList<Object> cached = new ArrayList<>();
                AssignData s1_ = this.assign_cache;
                if (s1_ != null) {
                    cached.add(Arrays.asList(s1_.toObjectNode_, s1_.write_, s1_.assignProperties_));
                }
                s[2] = cached;
            } else {
                s[1] = (byte)0b00 /* inactive */;
            }
            data[1] = s;
            return Provider.create(data);
        }

        public static ObjectAssignNode create(JSContext context, JSBuiltin builtin, JavaScriptNode[] arguments) {
            return new ObjectAssignNodeGen(context, builtin, arguments);
        }

        @GeneratedBy(ObjectAssignNode.class)
        private static final class AssignData extends Node {

            @Child JSToObjectNode toObjectNode_;
            @Child WriteElementNode write_;
            @Child AssignPropertiesNode assignProperties_;

            AssignData() {
            }

            @Override
            public NodeCost getCost() {
                return NodeCost.NONE;
            }

            <T extends Node> T insertAccessor(T node) {
                return super.insert(node);
            }

        }
    }
    @GeneratedBy(AssignPropertiesNode.class)
    static final class AssignPropertiesNodeGen extends AssignPropertiesNode implements Provider {

        @CompilationFinal private int state_;
        @CompilationFinal private int exclude_;
        @Child private CopyPropertiesFromJSObjectData copyPropertiesFromJSObject_cache;
        @Child private Object0Data object0_cache;
        @Child private InteropLibrary object1_keysInterop_;
        @Child private InteropLibrary object1_stringInterop_;

        private AssignPropertiesNodeGen(JSContext context) {
            super(context);
        }

        @ExplodeLoop
        @Override
        void executeVoid(Object arg0Value, Object arg1Value, WriteElementNode arg2Value) {
            int state = state_;
            if (state != 0 /* is-active copyPropertiesFromJSObject(Object, DynamicObject, WriteElementNode, ReadElementNode, JSGetOwnPropertyNode, ListSizeNode, ListGetNode, JSClassProfile) || doObject(Object, Object, WriteElementNode, InteropLibrary, InteropLibrary, InteropLibrary) || doObject(Object, Object, WriteElementNode, InteropLibrary, InteropLibrary, InteropLibrary) */) {
                if ((state & 0b1) != 0 /* is-active copyPropertiesFromJSObject(Object, DynamicObject, WriteElementNode, ReadElementNode, JSGetOwnPropertyNode, ListSizeNode, ListGetNode, JSClassProfile) */ && JSTypes.isDynamicObject(arg1Value)) {
                    DynamicObject arg1Value_ = (DynamicObject) arg1Value;
                    CopyPropertiesFromJSObjectData s1_ = this.copyPropertiesFromJSObject_cache;
                    if (s1_ != null) {
                        if ((JSGuards.isJSObject(arg1Value_))) {
                            AssignPropertiesNode.copyPropertiesFromJSObject(arg0Value, arg1Value_, arg2Value, s1_.read_, s1_.getOwnProperty_, s1_.listSize_, s1_.listGet_, s1_.classProfile_);
                            return;
                        }
                    }
                }
                if ((state & 0b110) != 0 /* is-active doObject(Object, Object, WriteElementNode, InteropLibrary, InteropLibrary, InteropLibrary) || doObject(Object, Object, WriteElementNode, InteropLibrary, InteropLibrary, InteropLibrary) */) {
                    if ((state & 0b10) != 0 /* is-active doObject(Object, Object, WriteElementNode, InteropLibrary, InteropLibrary, InteropLibrary) */) {
                        Object0Data s2_ = this.object0_cache;
                        while (s2_ != null) {
                            if ((s2_.fromInterop_.accepts(arg1Value)) && (!(JSGuards.isJSObject(arg1Value)))) {
                                doObject(arg0Value, arg1Value, arg2Value, s2_.fromInterop_, s2_.keysInterop_, s2_.stringInterop_);
                                return;
                            }
                            s2_ = s2_.next_;
                        }
                    }
                    if ((state & 0b100) != 0 /* is-active doObject(Object, Object, WriteElementNode, InteropLibrary, InteropLibrary, InteropLibrary) */) {
                        if ((!(JSGuards.isJSObject(arg1Value)))) {
                            this.object1Boundary(state, arg0Value, arg1Value, arg2Value);
                            return;
                        }
                    }
                }
            }
            CompilerDirectives.transferToInterpreterAndInvalidate();
            executeAndSpecialize(arg0Value, arg1Value, arg2Value);
            return;
        }

        @TruffleBoundary
        private void object1Boundary(int state, Object arg0Value, Object arg1Value, WriteElementNode arg2Value) {
            Node prev_ = NodeUtil.pushEncapsulatingNode(this);
            try {
                doObject(arg0Value, arg1Value, arg2Value, (INTEROP_LIBRARY_.getUncached(arg1Value)), this.object1_keysInterop_, this.object1_stringInterop_);
                return;
            } finally {
                NodeUtil.popEncapsulatingNode(prev_);
            }
        }

        private void executeAndSpecialize(Object arg0Value, Object arg1Value, WriteElementNode arg2Value) {
            Lock lock = getLock();
            boolean hasLock = true;
            lock.lock();
            int state = state_;
            int exclude = exclude_;
            try {
                if (JSTypes.isDynamicObject(arg1Value)) {
                    DynamicObject arg1Value_ = (DynamicObject) arg1Value;
                    if ((JSGuards.isJSObject(arg1Value_))) {
                        CopyPropertiesFromJSObjectData s1_ = super.insert(new CopyPropertiesFromJSObjectData());
                        s1_.read_ = s1_.insertAccessor((ReadElementNode.create(context)));
                        s1_.getOwnProperty_ = s1_.insertAccessor((JSGetOwnPropertyNode.create(false)));
                        s1_.listSize_ = s1_.insertAccessor((ListSizeNode.create()));
                        s1_.listGet_ = s1_.insertAccessor((ListGetNode.create()));
                        s1_.classProfile_ = (JSClassProfile.create());
                        this.copyPropertiesFromJSObject_cache = s1_;
                        this.state_ = state = state | 0b1 /* add-active copyPropertiesFromJSObject(Object, DynamicObject, WriteElementNode, ReadElementNode, JSGetOwnPropertyNode, ListSizeNode, ListGetNode, JSClassProfile) */;
                        lock.unlock();
                        hasLock = false;
                        AssignPropertiesNode.copyPropertiesFromJSObject(arg0Value, arg1Value_, arg2Value, s1_.read_, s1_.getOwnProperty_, s1_.listSize_, s1_.listGet_, s1_.classProfile_);
                        return;
                    }
                }
                if ((exclude) == 0 /* is-not-excluded doObject(Object, Object, WriteElementNode, InteropLibrary, InteropLibrary, InteropLibrary) */) {
                    int count2_ = 0;
                    Object0Data s2_ = this.object0_cache;
                    if ((state & 0b10) != 0 /* is-active doObject(Object, Object, WriteElementNode, InteropLibrary, InteropLibrary, InteropLibrary) */) {
                        while (s2_ != null) {
                            if ((s2_.fromInterop_.accepts(arg1Value)) && (!(JSGuards.isJSObject(arg1Value)))) {
                                break;
                            }
                            s2_ = s2_.next_;
                            count2_++;
                        }
                    }
                    if (s2_ == null) {
                        if ((!(JSGuards.isJSObject(arg1Value))) && count2_ < (3)) {
                            // assert (s2_.fromInterop_.accepts(arg1Value));
                            s2_ = super.insert(new Object0Data(object0_cache));
                            s2_.fromInterop_ = s2_.insertAccessor((INTEROP_LIBRARY_.create(arg1Value)));
                            s2_.keysInterop_ = s2_.insertAccessor((INTEROP_LIBRARY_.createDispatched(3)));
                            s2_.stringInterop_ = s2_.insertAccessor((INTEROP_LIBRARY_.createDispatched(3)));
                            this.object0_cache = s2_;
                            this.state_ = state = state | 0b10 /* add-active doObject(Object, Object, WriteElementNode, InteropLibrary, InteropLibrary, InteropLibrary) */;
                        }
                    }
                    if (s2_ != null) {
                        lock.unlock();
                        hasLock = false;
                        doObject(arg0Value, arg1Value, arg2Value, s2_.fromInterop_, s2_.keysInterop_, s2_.stringInterop_);
                        return;
                    }
                }
                {
                    Node prev_ = NodeUtil.pushEncapsulatingNode(this);
                    try {
                        if ((!(JSGuards.isJSObject(arg1Value)))) {
                            this.object1_keysInterop_ = super.insert((INTEROP_LIBRARY_.createDispatched(3)));
                            this.object1_stringInterop_ = super.insert((INTEROP_LIBRARY_.createDispatched(3)));
                            this.exclude_ = exclude = exclude | 0b1 /* add-excluded doObject(Object, Object, WriteElementNode, InteropLibrary, InteropLibrary, InteropLibrary) */;
                            this.object0_cache = null;
                            state = state & 0xfffffffd /* remove-active doObject(Object, Object, WriteElementNode, InteropLibrary, InteropLibrary, InteropLibrary) */;
                            this.state_ = state = state | 0b100 /* add-active doObject(Object, Object, WriteElementNode, InteropLibrary, InteropLibrary, InteropLibrary) */;
                            lock.unlock();
                            hasLock = false;
                            doObject(arg0Value, arg1Value, arg2Value, (INTEROP_LIBRARY_.getUncached(arg1Value)), this.object1_keysInterop_, this.object1_stringInterop_);
                            return;
                        }
                    } finally {
                        NodeUtil.popEncapsulatingNode(prev_);
                    }
                }
                throw new UnsupportedSpecializationException(this, new Node[] {null, null, null}, arg0Value, arg1Value, arg2Value);
            } finally {
                if (hasLock) {
                    lock.unlock();
                }
            }
        }

        @Override
        public NodeCost getCost() {
            int state = state_;
            if (state == 0b0) {
                return NodeCost.UNINITIALIZED;
            } else if ((state & (state - 1)) == 0 /* is-single-active  */) {
                Object0Data s2_ = this.object0_cache;
                if ((s2_ == null || s2_.next_ == null)) {
                    return NodeCost.MONOMORPHIC;
                }
            }
            return NodeCost.POLYMORPHIC;
        }

        @Override
        public Introspection getIntrospectionData() {
            Object[] data = new Object[4];
            Object[] s;
            data[0] = 0;
            int state = state_;
            int exclude = exclude_;
            s = new Object[3];
            s[0] = "copyPropertiesFromJSObject";
            if ((state & 0b1) != 0 /* is-active copyPropertiesFromJSObject(Object, DynamicObject, WriteElementNode, ReadElementNode, JSGetOwnPropertyNode, ListSizeNode, ListGetNode, JSClassProfile) */) {
                s[1] = (byte)0b01 /* active */;
                ArrayList<Object> cached = new ArrayList<>();
                CopyPropertiesFromJSObjectData s1_ = this.copyPropertiesFromJSObject_cache;
                if (s1_ != null) {
                    cached.add(Arrays.asList(s1_.read_, s1_.getOwnProperty_, s1_.listSize_, s1_.listGet_, s1_.classProfile_));
                }
                s[2] = cached;
            } else {
                s[1] = (byte)0b00 /* inactive */;
            }
            data[1] = s;
            s = new Object[3];
            s[0] = "doObject";
            if ((state & 0b10) != 0 /* is-active doObject(Object, Object, WriteElementNode, InteropLibrary, InteropLibrary, InteropLibrary) */) {
                s[1] = (byte)0b01 /* active */;
                ArrayList<Object> cached = new ArrayList<>();
                Object0Data s2_ = this.object0_cache;
                while (s2_ != null) {
                    cached.add(Arrays.asList(s2_.fromInterop_, s2_.keysInterop_, s2_.stringInterop_));
                    s2_ = s2_.next_;
                }
                s[2] = cached;
            } else if (exclude != 0 /* is-excluded doObject(Object, Object, WriteElementNode, InteropLibrary, InteropLibrary, InteropLibrary) */) {
                s[1] = (byte)0b10 /* excluded */;
            } else {
                s[1] = (byte)0b00 /* inactive */;
            }
            data[2] = s;
            s = new Object[3];
            s[0] = "doObject";
            if ((state & 0b100) != 0 /* is-active doObject(Object, Object, WriteElementNode, InteropLibrary, InteropLibrary, InteropLibrary) */) {
                s[1] = (byte)0b01 /* active */;
                ArrayList<Object> cached = new ArrayList<>();
                cached.add(Arrays.asList(INTEROP_LIBRARY_.getUncached(), this.object1_keysInterop_, this.object1_stringInterop_));
                s[2] = cached;
            } else {
                s[1] = (byte)0b00 /* inactive */;
            }
            data[3] = s;
            return Provider.create(data);
        }

        public static AssignPropertiesNode create(JSContext context) {
            return new AssignPropertiesNodeGen(context);
        }

        @GeneratedBy(AssignPropertiesNode.class)
        private static final class CopyPropertiesFromJSObjectData extends Node {

            @Child ReadElementNode read_;
            @Child JSGetOwnPropertyNode getOwnProperty_;
            @Child ListSizeNode listSize_;
            @Child ListGetNode listGet_;
            @CompilationFinal JSClassProfile classProfile_;

            CopyPropertiesFromJSObjectData() {
            }

            @Override
            public NodeCost getCost() {
                return NodeCost.NONE;
            }

            <T extends Node> T insertAccessor(T node) {
                return super.insert(node);
            }

        }
        @GeneratedBy(AssignPropertiesNode.class)
        private static final class Object0Data extends Node {

            @Child Object0Data next_;
            @Child InteropLibrary fromInterop_;
            @Child InteropLibrary keysInterop_;
            @Child InteropLibrary stringInterop_;

            Object0Data(Object0Data next_) {
                this.next_ = next_;
            }

            @Override
            public NodeCost getCost() {
                return NodeCost.NONE;
            }

            <T extends Node> T insertAccessor(T node) {
                return super.insert(node);
            }

        }
    }
    @GeneratedBy(ObjectValuesOrEntriesNode.class)
    public static final class ObjectValuesOrEntriesNodeGen extends ObjectValuesOrEntriesNode implements Provider {

        @Child private JavaScriptNode arguments0_;
        @CompilationFinal private int state_;
        @CompilationFinal private int exclude_;
        @CompilationFinal private ConditionProfile valuesOrEntriesJSObject_lengthZero_;
        @Child private EnumerableOwnPropertyNamesForeign0Data enumerableOwnPropertyNamesForeign0_cache;
        @Child private EnumerableOwnPropertyNamesForeign1Data enumerableOwnPropertyNamesForeign1_cache;
        @Child private ObjectValuesOrEntriesNode valuesOrEntriesGeneric_recursive_;

        private ObjectValuesOrEntriesNodeGen(JSContext context, JSBuiltin builtin, boolean entries, JavaScriptNode[] arguments) {
            super(context, builtin, entries);
            this.arguments0_ = arguments != null && 0 < arguments.length ? arguments[0] : null;
        }

        @Override
        public JavaScriptNode[] getArguments() {
            return new JavaScriptNode[] {this.arguments0_};
        }

        @ExplodeLoop
        @Override
        protected DynamicObject executeEvaluated(Object arguments0Value) {
            int state = state_;
            if ((state & 0b1) != 0 /* is-active valuesOrEntriesJSObject(DynamicObject, ConditionProfile) */ && JSTypes.isDynamicObject(arguments0Value)) {
                DynamicObject arguments0Value_ = (DynamicObject) arguments0Value;
                if ((JSGuards.isJSObject(arguments0Value_))) {
                    return valuesOrEntriesJSObject(arguments0Value_, this.valuesOrEntriesJSObject_lengthZero_);
                }
            }
            if ((state & 0b1110) != 0 /* is-active enumerableOwnPropertyNamesForeign(Object, InteropLibrary, InteropLibrary, JSForeignToJSTypeNode, BranchProfile) || enumerableOwnPropertyNamesForeign(Object, InteropLibrary, InteropLibrary, JSForeignToJSTypeNode, BranchProfile) || valuesOrEntriesGeneric(Object, ObjectValuesOrEntriesNode) */) {
                if ((state & 0b10) != 0 /* is-active enumerableOwnPropertyNamesForeign(Object, InteropLibrary, InteropLibrary, JSForeignToJSTypeNode, BranchProfile) */) {
                    EnumerableOwnPropertyNamesForeign0Data s2_ = this.enumerableOwnPropertyNamesForeign0_cache;
                    while (s2_ != null) {
                        if ((s2_.interop_.accepts(arguments0Value)) && (JSGuards.isForeignObject(arguments0Value))) {
                            return enumerableOwnPropertyNamesForeign(arguments0Value, s2_.interop_, s2_.members_, s2_.importValue_, s2_.growProfile_);
                        }
                        s2_ = s2_.next_;
                    }
                }
                if ((state & 0b100) != 0 /* is-active enumerableOwnPropertyNamesForeign(Object, InteropLibrary, InteropLibrary, JSForeignToJSTypeNode, BranchProfile) */) {
                    EnumerableOwnPropertyNamesForeign1Data s3_ = this.enumerableOwnPropertyNamesForeign1_cache;
                    if (s3_ != null) {
                        if ((JSGuards.isForeignObject(arguments0Value))) {
                            return this.enumerableOwnPropertyNamesForeign1Boundary(state, s3_, arguments0Value);
                        }
                    }
                }
                if ((state & 0b1000) != 0 /* is-active valuesOrEntriesGeneric(Object, ObjectValuesOrEntriesNode) */) {
                    if ((!(JSGuards.isJSObject(arguments0Value))) && (!(JSGuards.isForeignObject(arguments0Value)))) {
                        return valuesOrEntriesGeneric(arguments0Value, this.valuesOrEntriesGeneric_recursive_);
                    }
                }
            }
            CompilerDirectives.transferToInterpreterAndInvalidate();
            return executeAndSpecialize(arguments0Value);
        }

        @TruffleBoundary
        private DynamicObject enumerableOwnPropertyNamesForeign1Boundary(int state, EnumerableOwnPropertyNamesForeign1Data s3_, Object arguments0Value) {
            Node prev_ = NodeUtil.pushEncapsulatingNode(this);
            try {
                return enumerableOwnPropertyNamesForeign(arguments0Value, (INTEROP_LIBRARY_.getUncached(arguments0Value)), s3_.members_, s3_.importValue_, s3_.growProfile_);
            } finally {
                NodeUtil.popEncapsulatingNode(prev_);
            }
        }

        @ExplodeLoop
        @Override
        public Object execute(VirtualFrame frameValue) {
            int state = state_;
            Object arguments0Value_ = this.arguments0_.execute(frameValue);
            if ((state & 0b1) != 0 /* is-active valuesOrEntriesJSObject(DynamicObject, ConditionProfile) */ && JSTypes.isDynamicObject(arguments0Value_)) {
                DynamicObject arguments0Value__ = (DynamicObject) arguments0Value_;
                if ((JSGuards.isJSObject(arguments0Value__))) {
                    return valuesOrEntriesJSObject(arguments0Value__, this.valuesOrEntriesJSObject_lengthZero_);
                }
            }
            if ((state & 0b1110) != 0 /* is-active enumerableOwnPropertyNamesForeign(Object, InteropLibrary, InteropLibrary, JSForeignToJSTypeNode, BranchProfile) || enumerableOwnPropertyNamesForeign(Object, InteropLibrary, InteropLibrary, JSForeignToJSTypeNode, BranchProfile) || valuesOrEntriesGeneric(Object, ObjectValuesOrEntriesNode) */) {
                if ((state & 0b10) != 0 /* is-active enumerableOwnPropertyNamesForeign(Object, InteropLibrary, InteropLibrary, JSForeignToJSTypeNode, BranchProfile) */) {
                    EnumerableOwnPropertyNamesForeign0Data s2_ = this.enumerableOwnPropertyNamesForeign0_cache;
                    while (s2_ != null) {
                        if ((s2_.interop_.accepts(arguments0Value_)) && (JSGuards.isForeignObject(arguments0Value_))) {
                            return enumerableOwnPropertyNamesForeign(arguments0Value_, s2_.interop_, s2_.members_, s2_.importValue_, s2_.growProfile_);
                        }
                        s2_ = s2_.next_;
                    }
                }
                if ((state & 0b100) != 0 /* is-active enumerableOwnPropertyNamesForeign(Object, InteropLibrary, InteropLibrary, JSForeignToJSTypeNode, BranchProfile) */) {
                    EnumerableOwnPropertyNamesForeign1Data s3_ = this.enumerableOwnPropertyNamesForeign1_cache;
                    if (s3_ != null) {
                        if ((JSGuards.isForeignObject(arguments0Value_))) {
                            return this.enumerableOwnPropertyNamesForeign1Boundary0(state, s3_, arguments0Value_);
                        }
                    }
                }
                if ((state & 0b1000) != 0 /* is-active valuesOrEntriesGeneric(Object, ObjectValuesOrEntriesNode) */) {
                    if ((!(JSGuards.isJSObject(arguments0Value_))) && (!(JSGuards.isForeignObject(arguments0Value_)))) {
                        return valuesOrEntriesGeneric(arguments0Value_, this.valuesOrEntriesGeneric_recursive_);
                    }
                }
            }
            CompilerDirectives.transferToInterpreterAndInvalidate();
            return executeAndSpecialize(arguments0Value_);
        }

        @TruffleBoundary
        private Object enumerableOwnPropertyNamesForeign1Boundary0(int state, EnumerableOwnPropertyNamesForeign1Data s3_, Object arguments0Value_) {
            Node prev_ = NodeUtil.pushEncapsulatingNode(this);
            try {
                return enumerableOwnPropertyNamesForeign(arguments0Value_, (INTEROP_LIBRARY_.getUncached(arguments0Value_)), s3_.members_, s3_.importValue_, s3_.growProfile_);
            } finally {
                NodeUtil.popEncapsulatingNode(prev_);
            }
        }

        @Override
        public void executeVoid(VirtualFrame frameValue) {
            execute(frameValue);
            return;
        }

        private DynamicObject executeAndSpecialize(Object arguments0Value) {
            Lock lock = getLock();
            boolean hasLock = true;
            lock.lock();
            int state = state_;
            int exclude = exclude_;
            try {
                if (JSTypes.isDynamicObject(arguments0Value)) {
                    DynamicObject arguments0Value_ = (DynamicObject) arguments0Value;
                    if ((JSGuards.isJSObject(arguments0Value_))) {
                        this.valuesOrEntriesJSObject_lengthZero_ = (ConditionProfile.createBinaryProfile());
                        this.state_ = state = state | 0b1 /* add-active valuesOrEntriesJSObject(DynamicObject, ConditionProfile) */;
                        lock.unlock();
                        hasLock = false;
                        return valuesOrEntriesJSObject(arguments0Value_, this.valuesOrEntriesJSObject_lengthZero_);
                    }
                }
                if ((exclude) == 0 /* is-not-excluded enumerableOwnPropertyNamesForeign(Object, InteropLibrary, InteropLibrary, JSForeignToJSTypeNode, BranchProfile) */) {
                    int count2_ = 0;
                    EnumerableOwnPropertyNamesForeign0Data s2_ = this.enumerableOwnPropertyNamesForeign0_cache;
                    if ((state & 0b10) != 0 /* is-active enumerableOwnPropertyNamesForeign(Object, InteropLibrary, InteropLibrary, JSForeignToJSTypeNode, BranchProfile) */) {
                        while (s2_ != null) {
                            if ((s2_.interop_.accepts(arguments0Value)) && (JSGuards.isForeignObject(arguments0Value))) {
                                break;
                            }
                            s2_ = s2_.next_;
                            count2_++;
                        }
                    }
                    if (s2_ == null) {
                        if ((JSGuards.isForeignObject(arguments0Value)) && count2_ < (3)) {
                            // assert (s2_.interop_.accepts(arguments0Value));
                            s2_ = super.insert(new EnumerableOwnPropertyNamesForeign0Data(enumerableOwnPropertyNamesForeign0_cache));
                            s2_.interop_ = s2_.insertAccessor((INTEROP_LIBRARY_.create(arguments0Value)));
                            s2_.members_ = s2_.insertAccessor((INTEROP_LIBRARY_.createDispatched(3)));
                            s2_.importValue_ = s2_.insertAccessor((JSForeignToJSTypeNode.create()));
                            s2_.growProfile_ = (BranchProfile.create());
                            this.enumerableOwnPropertyNamesForeign0_cache = s2_;
                            this.state_ = state = state | 0b10 /* add-active enumerableOwnPropertyNamesForeign(Object, InteropLibrary, InteropLibrary, JSForeignToJSTypeNode, BranchProfile) */;
                        }
                    }
                    if (s2_ != null) {
                        lock.unlock();
                        hasLock = false;
                        return enumerableOwnPropertyNamesForeign(arguments0Value, s2_.interop_, s2_.members_, s2_.importValue_, s2_.growProfile_);
                    }
                }
                {
                    Node prev_ = NodeUtil.pushEncapsulatingNode(this);
                    try {
                        if ((JSGuards.isForeignObject(arguments0Value))) {
                            EnumerableOwnPropertyNamesForeign1Data s3_ = super.insert(new EnumerableOwnPropertyNamesForeign1Data());
                            s3_.members_ = s3_.insertAccessor((INTEROP_LIBRARY_.createDispatched(3)));
                            s3_.importValue_ = s3_.insertAccessor((JSForeignToJSTypeNode.create()));
                            s3_.growProfile_ = (BranchProfile.create());
                            this.enumerableOwnPropertyNamesForeign1_cache = s3_;
                            this.exclude_ = exclude = exclude | 0b1 /* add-excluded enumerableOwnPropertyNamesForeign(Object, InteropLibrary, InteropLibrary, JSForeignToJSTypeNode, BranchProfile) */;
                            this.enumerableOwnPropertyNamesForeign0_cache = null;
                            state = state & 0xfffffffd /* remove-active enumerableOwnPropertyNamesForeign(Object, InteropLibrary, InteropLibrary, JSForeignToJSTypeNode, BranchProfile) */;
                            this.state_ = state = state | 0b100 /* add-active enumerableOwnPropertyNamesForeign(Object, InteropLibrary, InteropLibrary, JSForeignToJSTypeNode, BranchProfile) */;
                            lock.unlock();
                            hasLock = false;
                            return enumerableOwnPropertyNamesForeign(arguments0Value, (INTEROP_LIBRARY_.getUncached(arguments0Value)), s3_.members_, s3_.importValue_, s3_.growProfile_);
                        }
                    } finally {
                        NodeUtil.popEncapsulatingNode(prev_);
                    }
                }
                if ((!(JSGuards.isJSObject(arguments0Value))) && (!(JSGuards.isForeignObject(arguments0Value)))) {
                    this.valuesOrEntriesGeneric_recursive_ = super.insert((createRecursive()));
                    this.state_ = state = state | 0b1000 /* add-active valuesOrEntriesGeneric(Object, ObjectValuesOrEntriesNode) */;
                    lock.unlock();
                    hasLock = false;
                    return valuesOrEntriesGeneric(arguments0Value, this.valuesOrEntriesGeneric_recursive_);
                }
                throw new UnsupportedSpecializationException(this, new Node[] {this.arguments0_}, arguments0Value);
            } finally {
                if (hasLock) {
                    lock.unlock();
                }
            }
        }

        @Override
        public NodeCost getCost() {
            int state = state_;
            if (state == 0b0) {
                return NodeCost.UNINITIALIZED;
            } else if ((state & (state - 1)) == 0 /* is-single-active  */) {
                EnumerableOwnPropertyNamesForeign0Data s2_ = this.enumerableOwnPropertyNamesForeign0_cache;
                if ((s2_ == null || s2_.next_ == null)) {
                    return NodeCost.MONOMORPHIC;
                }
            }
            return NodeCost.POLYMORPHIC;
        }

        @Override
        public Introspection getIntrospectionData() {
            Object[] data = new Object[5];
            Object[] s;
            data[0] = 0;
            int state = state_;
            int exclude = exclude_;
            s = new Object[3];
            s[0] = "valuesOrEntriesJSObject";
            if ((state & 0b1) != 0 /* is-active valuesOrEntriesJSObject(DynamicObject, ConditionProfile) */) {
                s[1] = (byte)0b01 /* active */;
                ArrayList<Object> cached = new ArrayList<>();
                cached.add(Arrays.asList(this.valuesOrEntriesJSObject_lengthZero_));
                s[2] = cached;
            } else {
                s[1] = (byte)0b00 /* inactive */;
            }
            data[1] = s;
            s = new Object[3];
            s[0] = "enumerableOwnPropertyNamesForeign";
            if ((state & 0b10) != 0 /* is-active enumerableOwnPropertyNamesForeign(Object, InteropLibrary, InteropLibrary, JSForeignToJSTypeNode, BranchProfile) */) {
                s[1] = (byte)0b01 /* active */;
                ArrayList<Object> cached = new ArrayList<>();
                EnumerableOwnPropertyNamesForeign0Data s2_ = this.enumerableOwnPropertyNamesForeign0_cache;
                while (s2_ != null) {
                    cached.add(Arrays.asList(s2_.interop_, s2_.members_, s2_.importValue_, s2_.growProfile_));
                    s2_ = s2_.next_;
                }
                s[2] = cached;
            } else if (exclude != 0 /* is-excluded enumerableOwnPropertyNamesForeign(Object, InteropLibrary, InteropLibrary, JSForeignToJSTypeNode, BranchProfile) */) {
                s[1] = (byte)0b10 /* excluded */;
            } else {
                s[1] = (byte)0b00 /* inactive */;
            }
            data[2] = s;
            s = new Object[3];
            s[0] = "enumerableOwnPropertyNamesForeign";
            if ((state & 0b100) != 0 /* is-active enumerableOwnPropertyNamesForeign(Object, InteropLibrary, InteropLibrary, JSForeignToJSTypeNode, BranchProfile) */) {
                s[1] = (byte)0b01 /* active */;
                ArrayList<Object> cached = new ArrayList<>();
                EnumerableOwnPropertyNamesForeign1Data s3_ = this.enumerableOwnPropertyNamesForeign1_cache;
                if (s3_ != null) {
                    cached.add(Arrays.asList(INTEROP_LIBRARY_.getUncached(), s3_.members_, s3_.importValue_, s3_.growProfile_));
                }
                s[2] = cached;
            } else {
                s[1] = (byte)0b00 /* inactive */;
            }
            data[3] = s;
            s = new Object[3];
            s[0] = "valuesOrEntriesGeneric";
            if ((state & 0b1000) != 0 /* is-active valuesOrEntriesGeneric(Object, ObjectValuesOrEntriesNode) */) {
                s[1] = (byte)0b01 /* active */;
                ArrayList<Object> cached = new ArrayList<>();
                cached.add(Arrays.asList(this.valuesOrEntriesGeneric_recursive_));
                s[2] = cached;
            } else {
                s[1] = (byte)0b00 /* inactive */;
            }
            data[4] = s;
            return Provider.create(data);
        }

        public static ObjectValuesOrEntriesNode create(JSContext context, JSBuiltin builtin, boolean entries, JavaScriptNode[] arguments) {
            return new ObjectValuesOrEntriesNodeGen(context, builtin, entries, arguments);
        }

        @GeneratedBy(ObjectValuesOrEntriesNode.class)
        private static final class EnumerableOwnPropertyNamesForeign0Data extends Node {

            @Child EnumerableOwnPropertyNamesForeign0Data next_;
            @Child InteropLibrary interop_;
            @Child InteropLibrary members_;
            @Child JSForeignToJSTypeNode importValue_;
            @CompilationFinal BranchProfile growProfile_;

            EnumerableOwnPropertyNamesForeign0Data(EnumerableOwnPropertyNamesForeign0Data next_) {
                this.next_ = next_;
            }

            @Override
            public NodeCost getCost() {
                return NodeCost.NONE;
            }

            <T extends Node> T insertAccessor(T node) {
                return super.insert(node);
            }

        }
        @GeneratedBy(ObjectValuesOrEntriesNode.class)
        private static final class EnumerableOwnPropertyNamesForeign1Data extends Node {

            @Child InteropLibrary members_;
            @Child JSForeignToJSTypeNode importValue_;
            @CompilationFinal BranchProfile growProfile_;

            EnumerableOwnPropertyNamesForeign1Data() {
            }

            @Override
            public NodeCost getCost() {
                return NodeCost.NONE;
            }

            <T extends Node> T insertAccessor(T node) {
                return super.insert(node);
            }

        }
    }
    @GeneratedBy(ObjectFromEntriesNode.class)
    public static final class ObjectFromEntriesNodeGen extends ObjectFromEntriesNode implements Provider {

        @Child private JavaScriptNode arguments0_;

        private ObjectFromEntriesNodeGen(JSContext context, JSBuiltin builtin, JavaScriptNode[] arguments) {
            super(context, builtin);
            this.arguments0_ = arguments != null && 0 < arguments.length ? arguments[0] : null;
        }

        @Override
        public JavaScriptNode[] getArguments() {
            return new JavaScriptNode[] {this.arguments0_};
        }

        @Override
        public Object execute(VirtualFrame frameValue) {
            Object arguments0Value_ = this.arguments0_.execute(frameValue);
            return entries(arguments0Value_);
        }

        @Override
        public void executeVoid(VirtualFrame frameValue) {
            execute(frameValue);
            return;
        }

        @Override
        public NodeCost getCost() {
            return NodeCost.MONOMORPHIC;
        }

        @Override
        public Introspection getIntrospectionData() {
            Object[] data = new Object[2];
            Object[] s;
            data[0] = 0;
            s = new Object[3];
            s[0] = "entries";
            s[1] = (byte)0b01 /* active */;
            data[1] = s;
            return Provider.create(data);
        }

        public static ObjectFromEntriesNode create(JSContext context, JSBuiltin builtin, JavaScriptNode[] arguments) {
            return new ObjectFromEntriesNodeGen(context, builtin, arguments);
        }

    }
}
