// CheckStyle: start generated
package com.oracle.truffle.js.builtins;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.CompilerDirectives.CompilationFinal;
import com.oracle.truffle.api.CompilerDirectives.TruffleBoundary;
import com.oracle.truffle.api.dsl.GeneratedBy;
import com.oracle.truffle.api.dsl.Introspection;
import com.oracle.truffle.api.dsl.UnsupportedSpecializationException;
import com.oracle.truffle.api.dsl.Introspection.Provider;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.interop.InteropLibrary;
import com.oracle.truffle.api.interop.TruffleObject;
import com.oracle.truffle.api.library.LibraryFactory;
import com.oracle.truffle.api.nodes.ExplodeLoop;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.nodes.NodeCost;
import com.oracle.truffle.api.nodes.NodeUtil;
import com.oracle.truffle.api.nodes.UnexpectedResultException;
import com.oracle.truffle.api.object.DynamicObject;
import com.oracle.truffle.api.profiles.BranchProfile;
import com.oracle.truffle.api.profiles.ConditionProfile;
import com.oracle.truffle.js.builtins.GlobalBuiltins;
import com.oracle.truffle.js.builtins.GlobalBuiltins.GlobalNashornExtensionParseToJSONNode;
import com.oracle.truffle.js.builtins.GlobalBuiltins.GlobalScriptingEXECNode;
import com.oracle.truffle.js.builtins.GlobalBuiltins.GlobalSyntaxCheckForScriptEngineNode;
import com.oracle.truffle.js.builtins.GlobalBuiltins.JSGlobalDecodeURINode;
import com.oracle.truffle.js.builtins.GlobalBuiltins.JSGlobalEncodeURINode;
import com.oracle.truffle.js.builtins.GlobalBuiltins.JSGlobalExitNode;
import com.oracle.truffle.js.builtins.GlobalBuiltins.JSGlobalImportScriptEngineGlobalBindingsNode;
import com.oracle.truffle.js.builtins.GlobalBuiltins.JSGlobalIndirectEvalNode;
import com.oracle.truffle.js.builtins.GlobalBuiltins.JSGlobalIsFiniteNode;
import com.oracle.truffle.js.builtins.GlobalBuiltins.JSGlobalIsNaNNode;
import com.oracle.truffle.js.builtins.GlobalBuiltins.JSGlobalLoadNode;
import com.oracle.truffle.js.builtins.GlobalBuiltins.JSGlobalLoadWithNewGlobalNode;
import com.oracle.truffle.js.builtins.GlobalBuiltins.JSGlobalParseFloatNode;
import com.oracle.truffle.js.builtins.GlobalBuiltins.JSGlobalParseIntNode;
import com.oracle.truffle.js.builtins.GlobalBuiltins.JSGlobalPrintNode;
import com.oracle.truffle.js.builtins.GlobalBuiltins.JSGlobalReadBufferNode;
import com.oracle.truffle.js.builtins.GlobalBuiltins.JSGlobalReadFullyNode;
import com.oracle.truffle.js.builtins.GlobalBuiltins.JSGlobalReadLineNode;
import com.oracle.truffle.js.builtins.GlobalBuiltins.JSGlobalUnEscapeNode;
import com.oracle.truffle.js.nodes.JSGuards;
import com.oracle.truffle.js.nodes.JSTypes;
import com.oracle.truffle.js.nodes.JSTypesGen;
import com.oracle.truffle.js.nodes.JavaScriptNode;
import com.oracle.truffle.js.nodes.cast.JSToDoubleNode;
import com.oracle.truffle.js.nodes.cast.JSToNumberNode;
import com.oracle.truffle.js.nodes.cast.JSToStringNode;
import com.oracle.truffle.js.nodes.cast.JSTrimWhitespaceNode;
import com.oracle.truffle.js.nodes.function.JSBuiltin;
import com.oracle.truffle.js.runtime.BigInt;
import com.oracle.truffle.js.runtime.JSContext;
import com.oracle.truffle.js.runtime.LargeInteger;
import com.oracle.truffle.js.runtime.Symbol;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.concurrent.locks.Lock;

@GeneratedBy(GlobalBuiltins.class)
@SuppressWarnings("unused")
public final class GlobalBuiltinsFactory {

    private static final LibraryFactory<InteropLibrary> INTEROP_LIBRARY_ = LibraryFactory.resolve(InteropLibrary.class);

    @GeneratedBy(GlobalNashornExtensionParseToJSONNode.class)
    public static final class GlobalNashornExtensionParseToJSONNodeGen extends GlobalNashornExtensionParseToJSONNode implements Provider {

        @Child private JavaScriptNode arguments0_;
        @Child private JavaScriptNode arguments1_;
        @Child private JavaScriptNode arguments2_;

        private GlobalNashornExtensionParseToJSONNodeGen(JSContext context, JSBuiltin builtin, JavaScriptNode[] arguments) {
            super(context, builtin);
            this.arguments0_ = arguments != null && 0 < arguments.length ? arguments[0] : null;
            this.arguments1_ = arguments != null && 1 < arguments.length ? arguments[1] : null;
            this.arguments2_ = arguments != null && 2 < arguments.length ? arguments[2] : null;
        }

        @Override
        public JavaScriptNode[] getArguments() {
            return new JavaScriptNode[] {this.arguments0_, this.arguments1_, this.arguments2_};
        }

        @Override
        public Object execute(VirtualFrame frameValue) {
            Object arguments0Value_ = this.arguments0_.execute(frameValue);
            Object arguments1Value_ = this.arguments1_.execute(frameValue);
            Object arguments2Value_ = this.arguments2_.execute(frameValue);
            return parseToJSON(arguments0Value_, arguments1Value_, arguments2Value_);
        }

        @Override
        public void executeVoid(VirtualFrame frameValue) {
            execute(frameValue);
            return;
        }

        @Override
        public NodeCost getCost() {
            return NodeCost.MONOMORPHIC;
        }

        @Override
        public Introspection getIntrospectionData() {
            Object[] data = new Object[2];
            Object[] s;
            data[0] = 0;
            s = new Object[3];
            s[0] = "parseToJSON";
            s[1] = (byte)0b01 /* active */;
            data[1] = s;
            return Provider.create(data);
        }

        public static GlobalNashornExtensionParseToJSONNode create(JSContext context, JSBuiltin builtin, JavaScriptNode[] arguments) {
            return new GlobalNashornExtensionParseToJSONNodeGen(context, builtin, arguments);
        }

    }
    @GeneratedBy(GlobalScriptingEXECNode.class)
    public static final class GlobalScriptingEXECNodeGen extends GlobalScriptingEXECNode implements Provider {

        @Child private JavaScriptNode arguments0_;
        @Child private JavaScriptNode arguments1_;

        private GlobalScriptingEXECNodeGen(JSContext context, JSBuiltin builtin, JavaScriptNode[] arguments) {
            super(context, builtin);
            this.arguments0_ = arguments != null && 0 < arguments.length ? arguments[0] : null;
            this.arguments1_ = arguments != null && 1 < arguments.length ? arguments[1] : null;
        }

        @Override
        public JavaScriptNode[] getArguments() {
            return new JavaScriptNode[] {this.arguments0_, this.arguments1_};
        }

        @Override
        public Object execute(VirtualFrame frameValue) {
            Object arguments0Value_ = this.arguments0_.execute(frameValue);
            Object arguments1Value_ = this.arguments1_.execute(frameValue);
            return exec(arguments0Value_, arguments1Value_);
        }

        @Override
        public void executeVoid(VirtualFrame frameValue) {
            execute(frameValue);
            return;
        }

        @Override
        public NodeCost getCost() {
            return NodeCost.MONOMORPHIC;
        }

        @Override
        public Introspection getIntrospectionData() {
            Object[] data = new Object[2];
            Object[] s;
            data[0] = 0;
            s = new Object[3];
            s[0] = "exec";
            s[1] = (byte)0b01 /* active */;
            data[1] = s;
            return Provider.create(data);
        }

        public static GlobalScriptingEXECNode create(JSContext context, JSBuiltin builtin, JavaScriptNode[] arguments) {
            return new GlobalScriptingEXECNodeGen(context, builtin, arguments);
        }

    }
    @GeneratedBy(JSGlobalIsNaNNode.class)
    public static final class JSGlobalIsNaNNodeGen extends JSGlobalIsNaNNode implements Provider {

        @Child private JavaScriptNode arguments0_;
        @CompilationFinal private int state_;
        @Child private JSToDoubleNode isNaN2_toDoubleNode_;

        private JSGlobalIsNaNNodeGen(JSContext context, JSBuiltin builtin, JavaScriptNode[] arguments) {
            super(context, builtin);
            this.arguments0_ = arguments != null && 0 < arguments.length ? arguments[0] : null;
        }

        @Override
        public JavaScriptNode[] getArguments() {
            return new JavaScriptNode[] {this.arguments0_};
        }

        @Override
        public Object execute(VirtualFrame frameValue) {
            int state = state_;
            if ((state & 0b1110) == 0 /* only-active isNaN(int) */ && (state & 0b1111) != 0  /* is-not isNaN(int) && isNaN(double) && isNaN(Object, JSToDoubleNode) && isNaN(Object) */) {
                return execute_int0(frameValue, state);
            } else if ((state & 0b1101) == 0 /* only-active isNaN(double) */ && (state & 0b1111) != 0  /* is-not isNaN(int) && isNaN(double) && isNaN(Object, JSToDoubleNode) && isNaN(Object) */) {
                return execute_double1(frameValue, state);
            } else {
                return execute_generic2(frameValue, state);
            }
        }

        private Object execute_int0(VirtualFrame frameValue, int state) {
            int arguments0Value_;
            try {
                arguments0Value_ = this.arguments0_.executeInt(frameValue);
            } catch (UnexpectedResultException ex) {
                return executeAndSpecialize(ex.getResult());
            }
            assert (state & 0b1) != 0 /* is-active isNaN(int) */;
            return JSGlobalIsNaNNode.isNaN(arguments0Value_);
        }

        private Object execute_double1(VirtualFrame frameValue, int state) {
            int arguments0Value_int = 0;
            long arguments0Value_long = 0L;
            double arguments0Value_;
            try {
                if ((state & 0b11100000) == 0 /* only-active 0:double */ && (state & 0b1111) != 0  /* is-not isNaN(int) && isNaN(double) && isNaN(Object, JSToDoubleNode) && isNaN(Object) */) {
                    arguments0Value_long = this.arguments0_.executeLong(frameValue);
                    arguments0Value_ = JSTypes.longToDouble(arguments0Value_long);
                } else if ((state & 0b11010000) == 0 /* only-active 0:double */ && (state & 0b1111) != 0  /* is-not isNaN(int) && isNaN(double) && isNaN(Object, JSToDoubleNode) && isNaN(Object) */) {
                    arguments0Value_int = this.arguments0_.executeInt(frameValue);
                    arguments0Value_ = JSTypes.intToDouble(arguments0Value_int);
                } else if ((state & 0b10110000) == 0 /* only-active 0:double */ && (state & 0b1111) != 0  /* is-not isNaN(int) && isNaN(double) && isNaN(Object, JSToDoubleNode) && isNaN(Object) */) {
                    arguments0Value_ = this.arguments0_.executeDouble(frameValue);
                } else {
                    Object arguments0Value__ = this.arguments0_.execute(frameValue);
                    arguments0Value_ = JSTypesGen.expectImplicitDouble((state & 0b11110000) >>> 4 /* extract-implicit-active 0:double */, arguments0Value__);
                }
            } catch (UnexpectedResultException ex) {
                return executeAndSpecialize(ex.getResult());
            }
            assert (state & 0b10) != 0 /* is-active isNaN(double) */;
            return JSGlobalIsNaNNode.isNaN(arguments0Value_);
        }

        private Object execute_generic2(VirtualFrame frameValue, int state) {
            Object arguments0Value_ = this.arguments0_.execute(frameValue);
            if ((state & 0b1) != 0 /* is-active isNaN(int) */ && arguments0Value_ instanceof Integer) {
                int arguments0Value__ = (int) arguments0Value_;
                return JSGlobalIsNaNNode.isNaN(arguments0Value__);
            }
            if ((state & 0b10) != 0 /* is-active isNaN(double) */ && JSTypesGen.isImplicitDouble((state & 0b11110000) >>> 4 /* extract-implicit-active 0:double */, arguments0Value_)) {
                double arguments0Value__ = JSTypesGen.asImplicitDouble((state & 0b11110000) >>> 4 /* extract-implicit-active 0:double */, arguments0Value_);
                return JSGlobalIsNaNNode.isNaN(arguments0Value__);
            }
            if ((state & 0b1100) != 0 /* is-active isNaN(Object, JSToDoubleNode) || isNaN(Object) */) {
                if ((state & 0b100) != 0 /* is-active isNaN(Object, JSToDoubleNode) */) {
                    if ((!(JSGuards.isUndefined(arguments0Value_)))) {
                        return JSGlobalIsNaNNode.isNaN(arguments0Value_, this.isNaN2_toDoubleNode_);
                    }
                }
                if ((state & 0b1000) != 0 /* is-active isNaN(Object) */) {
                    if ((JSGuards.isUndefined(arguments0Value_))) {
                        return JSGlobalIsNaNNode.isNaN(arguments0Value_);
                    }
                }
            }
            CompilerDirectives.transferToInterpreterAndInvalidate();
            return executeAndSpecialize(arguments0Value_);
        }

        @Override
        public boolean executeBoolean(VirtualFrame frameValue) {
            int state = state_;
            if ((state & 0b1110) == 0 /* only-active isNaN(int) */ && (state & 0b1111) != 0  /* is-not isNaN(int) && isNaN(double) && isNaN(Object, JSToDoubleNode) && isNaN(Object) */) {
                return executeBoolean_int3(frameValue, state);
            } else if ((state & 0b1101) == 0 /* only-active isNaN(double) */ && (state & 0b1111) != 0  /* is-not isNaN(int) && isNaN(double) && isNaN(Object, JSToDoubleNode) && isNaN(Object) */) {
                return executeBoolean_double4(frameValue, state);
            } else {
                return executeBoolean_generic5(frameValue, state);
            }
        }

        private boolean executeBoolean_int3(VirtualFrame frameValue, int state) {
            int arguments0Value_;
            try {
                arguments0Value_ = this.arguments0_.executeInt(frameValue);
            } catch (UnexpectedResultException ex) {
                return executeAndSpecialize(ex.getResult());
            }
            assert (state & 0b1) != 0 /* is-active isNaN(int) */;
            return JSGlobalIsNaNNode.isNaN(arguments0Value_);
        }

        private boolean executeBoolean_double4(VirtualFrame frameValue, int state) {
            int arguments0Value_int = 0;
            long arguments0Value_long = 0L;
            double arguments0Value_;
            try {
                if ((state & 0b11100000) == 0 /* only-active 0:double */ && (state & 0b1111) != 0  /* is-not isNaN(int) && isNaN(double) && isNaN(Object, JSToDoubleNode) && isNaN(Object) */) {
                    arguments0Value_long = this.arguments0_.executeLong(frameValue);
                    arguments0Value_ = JSTypes.longToDouble(arguments0Value_long);
                } else if ((state & 0b11010000) == 0 /* only-active 0:double */ && (state & 0b1111) != 0  /* is-not isNaN(int) && isNaN(double) && isNaN(Object, JSToDoubleNode) && isNaN(Object) */) {
                    arguments0Value_int = this.arguments0_.executeInt(frameValue);
                    arguments0Value_ = JSTypes.intToDouble(arguments0Value_int);
                } else if ((state & 0b10110000) == 0 /* only-active 0:double */ && (state & 0b1111) != 0  /* is-not isNaN(int) && isNaN(double) && isNaN(Object, JSToDoubleNode) && isNaN(Object) */) {
                    arguments0Value_ = this.arguments0_.executeDouble(frameValue);
                } else {
                    Object arguments0Value__ = this.arguments0_.execute(frameValue);
                    arguments0Value_ = JSTypesGen.expectImplicitDouble((state & 0b11110000) >>> 4 /* extract-implicit-active 0:double */, arguments0Value__);
                }
            } catch (UnexpectedResultException ex) {
                return executeAndSpecialize(ex.getResult());
            }
            assert (state & 0b10) != 0 /* is-active isNaN(double) */;
            return JSGlobalIsNaNNode.isNaN(arguments0Value_);
        }

        private boolean executeBoolean_generic5(VirtualFrame frameValue, int state) {
            Object arguments0Value_ = this.arguments0_.execute(frameValue);
            if ((state & 0b1) != 0 /* is-active isNaN(int) */ && arguments0Value_ instanceof Integer) {
                int arguments0Value__ = (int) arguments0Value_;
                return JSGlobalIsNaNNode.isNaN(arguments0Value__);
            }
            if ((state & 0b10) != 0 /* is-active isNaN(double) */ && JSTypesGen.isImplicitDouble((state & 0b11110000) >>> 4 /* extract-implicit-active 0:double */, arguments0Value_)) {
                double arguments0Value__ = JSTypesGen.asImplicitDouble((state & 0b11110000) >>> 4 /* extract-implicit-active 0:double */, arguments0Value_);
                return JSGlobalIsNaNNode.isNaN(arguments0Value__);
            }
            if ((state & 0b1100) != 0 /* is-active isNaN(Object, JSToDoubleNode) || isNaN(Object) */) {
                if ((state & 0b100) != 0 /* is-active isNaN(Object, JSToDoubleNode) */) {
                    if ((!(JSGuards.isUndefined(arguments0Value_)))) {
                        return JSGlobalIsNaNNode.isNaN(arguments0Value_, this.isNaN2_toDoubleNode_);
                    }
                }
                if ((state & 0b1000) != 0 /* is-active isNaN(Object) */) {
                    if ((JSGuards.isUndefined(arguments0Value_))) {
                        return JSGlobalIsNaNNode.isNaN(arguments0Value_);
                    }
                }
            }
            CompilerDirectives.transferToInterpreterAndInvalidate();
            return executeAndSpecialize(arguments0Value_);
        }

        @Override
        public void executeVoid(VirtualFrame frameValue) {
            executeBoolean(frameValue);
            return;
        }

        private boolean executeAndSpecialize(Object arguments0Value) {
            Lock lock = getLock();
            boolean hasLock = true;
            lock.lock();
            int state = state_;
            try {
                if (arguments0Value instanceof Integer) {
                    int arguments0Value_ = (int) arguments0Value;
                    this.state_ = state = state | 0b1 /* add-active isNaN(int) */;
                    lock.unlock();
                    hasLock = false;
                    return JSGlobalIsNaNNode.isNaN(arguments0Value_);
                }
                {
                    int doubleCast0;
                    if ((doubleCast0 = JSTypesGen.specializeImplicitDouble(arguments0Value)) != 0) {
                        double arguments0Value_ = JSTypesGen.asImplicitDouble(doubleCast0, arguments0Value);
                        state = (state | (doubleCast0 << 4) /* set-implicit-active 0:double */);
                        this.state_ = state = state | 0b10 /* add-active isNaN(double) */;
                        lock.unlock();
                        hasLock = false;
                        return JSGlobalIsNaNNode.isNaN(arguments0Value_);
                    }
                }
                if ((!(JSGuards.isUndefined(arguments0Value)))) {
                    this.isNaN2_toDoubleNode_ = super.insert((JSToDoubleNode.create()));
                    this.state_ = state = state | 0b100 /* add-active isNaN(Object, JSToDoubleNode) */;
                    lock.unlock();
                    hasLock = false;
                    return JSGlobalIsNaNNode.isNaN(arguments0Value, this.isNaN2_toDoubleNode_);
                }
                if ((JSGuards.isUndefined(arguments0Value))) {
                    this.state_ = state = state | 0b1000 /* add-active isNaN(Object) */;
                    lock.unlock();
                    hasLock = false;
                    return JSGlobalIsNaNNode.isNaN(arguments0Value);
                }
                throw new UnsupportedSpecializationException(this, new Node[] {this.arguments0_}, arguments0Value);
            } finally {
                if (hasLock) {
                    lock.unlock();
                }
            }
        }

        @Override
        public NodeCost getCost() {
            int state = state_;
            if ((state & 0b1111) == 0b0) {
                return NodeCost.UNINITIALIZED;
            } else if (((state & 0b1111) & ((state & 0b1111) - 1)) == 0 /* is-single-active  */) {
                return NodeCost.MONOMORPHIC;
            }
            return NodeCost.POLYMORPHIC;
        }

        @Override
        public Introspection getIntrospectionData() {
            Object[] data = new Object[5];
            Object[] s;
            data[0] = 0;
            int state = state_;
            s = new Object[3];
            s[0] = "isNaN";
            if ((state & 0b1) != 0 /* is-active isNaN(int) */) {
                s[1] = (byte)0b01 /* active */;
            } else {
                s[1] = (byte)0b00 /* inactive */;
            }
            data[1] = s;
            s = new Object[3];
            s[0] = "isNaN";
            if ((state & 0b10) != 0 /* is-active isNaN(double) */) {
                s[1] = (byte)0b01 /* active */;
            } else {
                s[1] = (byte)0b00 /* inactive */;
            }
            data[2] = s;
            s = new Object[3];
            s[0] = "isNaN";
            if ((state & 0b100) != 0 /* is-active isNaN(Object, JSToDoubleNode) */) {
                s[1] = (byte)0b01 /* active */;
                ArrayList<Object> cached = new ArrayList<>();
                cached.add(Arrays.asList(this.isNaN2_toDoubleNode_));
                s[2] = cached;
            } else {
                s[1] = (byte)0b00 /* inactive */;
            }
            data[3] = s;
            s = new Object[3];
            s[0] = "isNaN";
            if ((state & 0b1000) != 0 /* is-active isNaN(Object) */) {
                s[1] = (byte)0b01 /* active */;
            } else {
                s[1] = (byte)0b00 /* inactive */;
            }
            data[4] = s;
            return Provider.create(data);
        }

        public static JSGlobalIsNaNNode create(JSContext context, JSBuiltin builtin, JavaScriptNode[] arguments) {
            return new JSGlobalIsNaNNodeGen(context, builtin, arguments);
        }

    }
    @GeneratedBy(JSGlobalIsFiniteNode.class)
    public static final class JSGlobalIsFiniteNodeGen extends JSGlobalIsFiniteNode implements Provider {

        @Child private JavaScriptNode arguments0_;
        @CompilationFinal private int state_;
        @Child private JSToDoubleNode isFinite2_toDoubleNode_;

        private JSGlobalIsFiniteNodeGen(JSContext context, JSBuiltin builtin, JavaScriptNode[] arguments) {
            super(context, builtin);
            this.arguments0_ = arguments != null && 0 < arguments.length ? arguments[0] : null;
        }

        @Override
        public JavaScriptNode[] getArguments() {
            return new JavaScriptNode[] {this.arguments0_};
        }

        @Override
        public Object execute(VirtualFrame frameValue) {
            int state = state_;
            if ((state & 0b1110) == 0 /* only-active isFinite(int) */ && (state & 0b1111) != 0  /* is-not isFinite(int) && isFinite(double) && isFinite(Object, JSToDoubleNode) && isFinite(Object) */) {
                return execute_int0(frameValue, state);
            } else if ((state & 0b1101) == 0 /* only-active isFinite(double) */ && (state & 0b1111) != 0  /* is-not isFinite(int) && isFinite(double) && isFinite(Object, JSToDoubleNode) && isFinite(Object) */) {
                return execute_double1(frameValue, state);
            } else {
                return execute_generic2(frameValue, state);
            }
        }

        private Object execute_int0(VirtualFrame frameValue, int state) {
            int arguments0Value_;
            try {
                arguments0Value_ = this.arguments0_.executeInt(frameValue);
            } catch (UnexpectedResultException ex) {
                return executeAndSpecialize(ex.getResult());
            }
            assert (state & 0b1) != 0 /* is-active isFinite(int) */;
            return JSGlobalIsFiniteNode.isFinite(arguments0Value_);
        }

        private Object execute_double1(VirtualFrame frameValue, int state) {
            int arguments0Value_int = 0;
            long arguments0Value_long = 0L;
            double arguments0Value_;
            try {
                if ((state & 0b11100000) == 0 /* only-active 0:double */ && (state & 0b1111) != 0  /* is-not isFinite(int) && isFinite(double) && isFinite(Object, JSToDoubleNode) && isFinite(Object) */) {
                    arguments0Value_long = this.arguments0_.executeLong(frameValue);
                    arguments0Value_ = JSTypes.longToDouble(arguments0Value_long);
                } else if ((state & 0b11010000) == 0 /* only-active 0:double */ && (state & 0b1111) != 0  /* is-not isFinite(int) && isFinite(double) && isFinite(Object, JSToDoubleNode) && isFinite(Object) */) {
                    arguments0Value_int = this.arguments0_.executeInt(frameValue);
                    arguments0Value_ = JSTypes.intToDouble(arguments0Value_int);
                } else if ((state & 0b10110000) == 0 /* only-active 0:double */ && (state & 0b1111) != 0  /* is-not isFinite(int) && isFinite(double) && isFinite(Object, JSToDoubleNode) && isFinite(Object) */) {
                    arguments0Value_ = this.arguments0_.executeDouble(frameValue);
                } else {
                    Object arguments0Value__ = this.arguments0_.execute(frameValue);
                    arguments0Value_ = JSTypesGen.expectImplicitDouble((state & 0b11110000) >>> 4 /* extract-implicit-active 0:double */, arguments0Value__);
                }
            } catch (UnexpectedResultException ex) {
                return executeAndSpecialize(ex.getResult());
            }
            assert (state & 0b10) != 0 /* is-active isFinite(double) */;
            return JSGlobalIsFiniteNode.isFinite(arguments0Value_);
        }

        private Object execute_generic2(VirtualFrame frameValue, int state) {
            Object arguments0Value_ = this.arguments0_.execute(frameValue);
            if ((state & 0b1) != 0 /* is-active isFinite(int) */ && arguments0Value_ instanceof Integer) {
                int arguments0Value__ = (int) arguments0Value_;
                return JSGlobalIsFiniteNode.isFinite(arguments0Value__);
            }
            if ((state & 0b10) != 0 /* is-active isFinite(double) */ && JSTypesGen.isImplicitDouble((state & 0b11110000) >>> 4 /* extract-implicit-active 0:double */, arguments0Value_)) {
                double arguments0Value__ = JSTypesGen.asImplicitDouble((state & 0b11110000) >>> 4 /* extract-implicit-active 0:double */, arguments0Value_);
                return JSGlobalIsFiniteNode.isFinite(arguments0Value__);
            }
            if ((state & 0b1100) != 0 /* is-active isFinite(Object, JSToDoubleNode) || isFinite(Object) */) {
                if ((state & 0b100) != 0 /* is-active isFinite(Object, JSToDoubleNode) */) {
                    if ((!(JSGuards.isUndefined(arguments0Value_)))) {
                        return JSGlobalIsFiniteNode.isFinite(arguments0Value_, this.isFinite2_toDoubleNode_);
                    }
                }
                if ((state & 0b1000) != 0 /* is-active isFinite(Object) */) {
                    if ((JSGuards.isUndefined(arguments0Value_))) {
                        return JSGlobalIsFiniteNode.isFinite(arguments0Value_);
                    }
                }
            }
            CompilerDirectives.transferToInterpreterAndInvalidate();
            return executeAndSpecialize(arguments0Value_);
        }

        @Override
        public boolean executeBoolean(VirtualFrame frameValue) {
            int state = state_;
            if ((state & 0b1110) == 0 /* only-active isFinite(int) */ && (state & 0b1111) != 0  /* is-not isFinite(int) && isFinite(double) && isFinite(Object, JSToDoubleNode) && isFinite(Object) */) {
                return executeBoolean_int3(frameValue, state);
            } else if ((state & 0b1101) == 0 /* only-active isFinite(double) */ && (state & 0b1111) != 0  /* is-not isFinite(int) && isFinite(double) && isFinite(Object, JSToDoubleNode) && isFinite(Object) */) {
                return executeBoolean_double4(frameValue, state);
            } else {
                return executeBoolean_generic5(frameValue, state);
            }
        }

        private boolean executeBoolean_int3(VirtualFrame frameValue, int state) {
            int arguments0Value_;
            try {
                arguments0Value_ = this.arguments0_.executeInt(frameValue);
            } catch (UnexpectedResultException ex) {
                return executeAndSpecialize(ex.getResult());
            }
            assert (state & 0b1) != 0 /* is-active isFinite(int) */;
            return JSGlobalIsFiniteNode.isFinite(arguments0Value_);
        }

        private boolean executeBoolean_double4(VirtualFrame frameValue, int state) {
            int arguments0Value_int = 0;
            long arguments0Value_long = 0L;
            double arguments0Value_;
            try {
                if ((state & 0b11100000) == 0 /* only-active 0:double */ && (state & 0b1111) != 0  /* is-not isFinite(int) && isFinite(double) && isFinite(Object, JSToDoubleNode) && isFinite(Object) */) {
                    arguments0Value_long = this.arguments0_.executeLong(frameValue);
                    arguments0Value_ = JSTypes.longToDouble(arguments0Value_long);
                } else if ((state & 0b11010000) == 0 /* only-active 0:double */ && (state & 0b1111) != 0  /* is-not isFinite(int) && isFinite(double) && isFinite(Object, JSToDoubleNode) && isFinite(Object) */) {
                    arguments0Value_int = this.arguments0_.executeInt(frameValue);
                    arguments0Value_ = JSTypes.intToDouble(arguments0Value_int);
                } else if ((state & 0b10110000) == 0 /* only-active 0:double */ && (state & 0b1111) != 0  /* is-not isFinite(int) && isFinite(double) && isFinite(Object, JSToDoubleNode) && isFinite(Object) */) {
                    arguments0Value_ = this.arguments0_.executeDouble(frameValue);
                } else {
                    Object arguments0Value__ = this.arguments0_.execute(frameValue);
                    arguments0Value_ = JSTypesGen.expectImplicitDouble((state & 0b11110000) >>> 4 /* extract-implicit-active 0:double */, arguments0Value__);
                }
            } catch (UnexpectedResultException ex) {
                return executeAndSpecialize(ex.getResult());
            }
            assert (state & 0b10) != 0 /* is-active isFinite(double) */;
            return JSGlobalIsFiniteNode.isFinite(arguments0Value_);
        }

        private boolean executeBoolean_generic5(VirtualFrame frameValue, int state) {
            Object arguments0Value_ = this.arguments0_.execute(frameValue);
            if ((state & 0b1) != 0 /* is-active isFinite(int) */ && arguments0Value_ instanceof Integer) {
                int arguments0Value__ = (int) arguments0Value_;
                return JSGlobalIsFiniteNode.isFinite(arguments0Value__);
            }
            if ((state & 0b10) != 0 /* is-active isFinite(double) */ && JSTypesGen.isImplicitDouble((state & 0b11110000) >>> 4 /* extract-implicit-active 0:double */, arguments0Value_)) {
                double arguments0Value__ = JSTypesGen.asImplicitDouble((state & 0b11110000) >>> 4 /* extract-implicit-active 0:double */, arguments0Value_);
                return JSGlobalIsFiniteNode.isFinite(arguments0Value__);
            }
            if ((state & 0b1100) != 0 /* is-active isFinite(Object, JSToDoubleNode) || isFinite(Object) */) {
                if ((state & 0b100) != 0 /* is-active isFinite(Object, JSToDoubleNode) */) {
                    if ((!(JSGuards.isUndefined(arguments0Value_)))) {
                        return JSGlobalIsFiniteNode.isFinite(arguments0Value_, this.isFinite2_toDoubleNode_);
                    }
                }
                if ((state & 0b1000) != 0 /* is-active isFinite(Object) */) {
                    if ((JSGuards.isUndefined(arguments0Value_))) {
                        return JSGlobalIsFiniteNode.isFinite(arguments0Value_);
                    }
                }
            }
            CompilerDirectives.transferToInterpreterAndInvalidate();
            return executeAndSpecialize(arguments0Value_);
        }

        @Override
        public void executeVoid(VirtualFrame frameValue) {
            executeBoolean(frameValue);
            return;
        }

        private boolean executeAndSpecialize(Object arguments0Value) {
            Lock lock = getLock();
            boolean hasLock = true;
            lock.lock();
            int state = state_;
            try {
                if (arguments0Value instanceof Integer) {
                    int arguments0Value_ = (int) arguments0Value;
                    this.state_ = state = state | 0b1 /* add-active isFinite(int) */;
                    lock.unlock();
                    hasLock = false;
                    return JSGlobalIsFiniteNode.isFinite(arguments0Value_);
                }
                {
                    int doubleCast0;
                    if ((doubleCast0 = JSTypesGen.specializeImplicitDouble(arguments0Value)) != 0) {
                        double arguments0Value_ = JSTypesGen.asImplicitDouble(doubleCast0, arguments0Value);
                        state = (state | (doubleCast0 << 4) /* set-implicit-active 0:double */);
                        this.state_ = state = state | 0b10 /* add-active isFinite(double) */;
                        lock.unlock();
                        hasLock = false;
                        return JSGlobalIsFiniteNode.isFinite(arguments0Value_);
                    }
                }
                if ((!(JSGuards.isUndefined(arguments0Value)))) {
                    this.isFinite2_toDoubleNode_ = super.insert((JSToDoubleNode.create()));
                    this.state_ = state = state | 0b100 /* add-active isFinite(Object, JSToDoubleNode) */;
                    lock.unlock();
                    hasLock = false;
                    return JSGlobalIsFiniteNode.isFinite(arguments0Value, this.isFinite2_toDoubleNode_);
                }
                if ((JSGuards.isUndefined(arguments0Value))) {
                    this.state_ = state = state | 0b1000 /* add-active isFinite(Object) */;
                    lock.unlock();
                    hasLock = false;
                    return JSGlobalIsFiniteNode.isFinite(arguments0Value);
                }
                throw new UnsupportedSpecializationException(this, new Node[] {this.arguments0_}, arguments0Value);
            } finally {
                if (hasLock) {
                    lock.unlock();
                }
            }
        }

        @Override
        public NodeCost getCost() {
            int state = state_;
            if ((state & 0b1111) == 0b0) {
                return NodeCost.UNINITIALIZED;
            } else if (((state & 0b1111) & ((state & 0b1111) - 1)) == 0 /* is-single-active  */) {
                return NodeCost.MONOMORPHIC;
            }
            return NodeCost.POLYMORPHIC;
        }

        @Override
        public Introspection getIntrospectionData() {
            Object[] data = new Object[5];
            Object[] s;
            data[0] = 0;
            int state = state_;
            s = new Object[3];
            s[0] = "isFinite";
            if ((state & 0b1) != 0 /* is-active isFinite(int) */) {
                s[1] = (byte)0b01 /* active */;
            } else {
                s[1] = (byte)0b00 /* inactive */;
            }
            data[1] = s;
            s = new Object[3];
            s[0] = "isFinite";
            if ((state & 0b10) != 0 /* is-active isFinite(double) */) {
                s[1] = (byte)0b01 /* active */;
            } else {
                s[1] = (byte)0b00 /* inactive */;
            }
            data[2] = s;
            s = new Object[3];
            s[0] = "isFinite";
            if ((state & 0b100) != 0 /* is-active isFinite(Object, JSToDoubleNode) */) {
                s[1] = (byte)0b01 /* active */;
                ArrayList<Object> cached = new ArrayList<>();
                cached.add(Arrays.asList(this.isFinite2_toDoubleNode_));
                s[2] = cached;
            } else {
                s[1] = (byte)0b00 /* inactive */;
            }
            data[3] = s;
            s = new Object[3];
            s[0] = "isFinite";
            if ((state & 0b1000) != 0 /* is-active isFinite(Object) */) {
                s[1] = (byte)0b01 /* active */;
            } else {
                s[1] = (byte)0b00 /* inactive */;
            }
            data[4] = s;
            return Provider.create(data);
        }

        public static JSGlobalIsFiniteNode create(JSContext context, JSBuiltin builtin, JavaScriptNode[] arguments) {
            return new JSGlobalIsFiniteNodeGen(context, builtin, arguments);
        }

    }
    @GeneratedBy(JSGlobalParseFloatNode.class)
    public static final class JSGlobalParseFloatNodeGen extends JSGlobalParseFloatNode implements Provider {

        @Child private JavaScriptNode arguments0_;
        @CompilationFinal private int state_;
        @CompilationFinal private ConditionProfile parseFloat1_negativeZero_;

        private JSGlobalParseFloatNodeGen(JSContext context, JSBuiltin builtin, JavaScriptNode[] arguments) {
            super(context, builtin);
            this.arguments0_ = arguments != null && 0 < arguments.length ? arguments[0] : null;
        }

        @Override
        public JavaScriptNode[] getArguments() {
            return new JavaScriptNode[] {this.arguments0_};
        }

        @Override
        public Object execute(VirtualFrame frameValue) {
            int state = state_;
            if ((state & 0b1111110) == 0 /* only-active parseFloat(int) */ && (state & 0b1111111) != 0  /* is-not parseFloat(int) && parseFloat(double, ConditionProfile) && parseFloat(boolean) && parseFloatUndefined(Object) && parseFloatNull(Object) && parseFloat(String) && parseFloat(TruffleObject) */) {
                return execute_int0(frameValue, state);
            } else if ((state & 0b1111101) == 0 /* only-active parseFloat(double, ConditionProfile) */ && (state & 0b1111111) != 0  /* is-not parseFloat(int) && parseFloat(double, ConditionProfile) && parseFloat(boolean) && parseFloatUndefined(Object) && parseFloatNull(Object) && parseFloat(String) && parseFloat(TruffleObject) */) {
                return execute_double1(frameValue, state);
            } else if ((state & 0b1111011) == 0 /* only-active parseFloat(boolean) */ && (state & 0b1111111) != 0  /* is-not parseFloat(int) && parseFloat(double, ConditionProfile) && parseFloat(boolean) && parseFloatUndefined(Object) && parseFloatNull(Object) && parseFloat(String) && parseFloat(TruffleObject) */) {
                return execute_boolean2(frameValue, state);
            } else {
                return execute_generic3(frameValue, state);
            }
        }

        private Object execute_int0(VirtualFrame frameValue, int state) {
            int arguments0Value_;
            try {
                arguments0Value_ = this.arguments0_.executeInt(frameValue);
            } catch (UnexpectedResultException ex) {
                return executeAndSpecialize(ex.getResult());
            }
            assert (state & 0b1) != 0 /* is-active parseFloat(int) */;
            return parseFloat(arguments0Value_);
        }

        private Object execute_double1(VirtualFrame frameValue, int state) {
            int arguments0Value_int = 0;
            long arguments0Value_long = 0L;
            double arguments0Value_;
            try {
                if ((state & 0b11100000000) == 0 /* only-active 0:double */ && (state & 0b1111111) != 0  /* is-not parseFloat(int) && parseFloat(double, ConditionProfile) && parseFloat(boolean) && parseFloatUndefined(Object) && parseFloatNull(Object) && parseFloat(String) && parseFloat(TruffleObject) */) {
                    arguments0Value_long = this.arguments0_.executeLong(frameValue);
                    arguments0Value_ = JSTypes.longToDouble(arguments0Value_long);
                } else if ((state & 0b11010000000) == 0 /* only-active 0:double */ && (state & 0b1111111) != 0  /* is-not parseFloat(int) && parseFloat(double, ConditionProfile) && parseFloat(boolean) && parseFloatUndefined(Object) && parseFloatNull(Object) && parseFloat(String) && parseFloat(TruffleObject) */) {
                    arguments0Value_int = this.arguments0_.executeInt(frameValue);
                    arguments0Value_ = JSTypes.intToDouble(arguments0Value_int);
                } else if ((state & 0b10110000000) == 0 /* only-active 0:double */ && (state & 0b1111111) != 0  /* is-not parseFloat(int) && parseFloat(double, ConditionProfile) && parseFloat(boolean) && parseFloatUndefined(Object) && parseFloatNull(Object) && parseFloat(String) && parseFloat(TruffleObject) */) {
                    arguments0Value_ = this.arguments0_.executeDouble(frameValue);
                } else {
                    Object arguments0Value__ = this.arguments0_.execute(frameValue);
                    arguments0Value_ = JSTypesGen.expectImplicitDouble((state & 0b11110000000) >>> 7 /* extract-implicit-active 0:double */, arguments0Value__);
                }
            } catch (UnexpectedResultException ex) {
                return executeAndSpecialize(ex.getResult());
            }
            assert (state & 0b10) != 0 /* is-active parseFloat(double, ConditionProfile) */;
            return parseFloat(arguments0Value_, this.parseFloat1_negativeZero_);
        }

        private Object execute_boolean2(VirtualFrame frameValue, int state) {
            boolean arguments0Value_;
            try {
                arguments0Value_ = this.arguments0_.executeBoolean(frameValue);
            } catch (UnexpectedResultException ex) {
                return executeAndSpecialize(ex.getResult());
            }
            assert (state & 0b100) != 0 /* is-active parseFloat(boolean) */;
            return parseFloat(arguments0Value_);
        }

        private Object execute_generic3(VirtualFrame frameValue, int state) {
            Object arguments0Value_ = this.arguments0_.execute(frameValue);
            if ((state & 0b1) != 0 /* is-active parseFloat(int) */ && arguments0Value_ instanceof Integer) {
                int arguments0Value__ = (int) arguments0Value_;
                return parseFloat(arguments0Value__);
            }
            if ((state & 0b10) != 0 /* is-active parseFloat(double, ConditionProfile) */ && JSTypesGen.isImplicitDouble((state & 0b11110000000) >>> 7 /* extract-implicit-active 0:double */, arguments0Value_)) {
                double arguments0Value__ = JSTypesGen.asImplicitDouble((state & 0b11110000000) >>> 7 /* extract-implicit-active 0:double */, arguments0Value_);
                return parseFloat(arguments0Value__, this.parseFloat1_negativeZero_);
            }
            if ((state & 0b100) != 0 /* is-active parseFloat(boolean) */ && arguments0Value_ instanceof Boolean) {
                boolean arguments0Value__ = (boolean) arguments0Value_;
                return parseFloat(arguments0Value__);
            }
            if ((state & 0b11000) != 0 /* is-active parseFloatUndefined(Object) || parseFloatNull(Object) */) {
                if ((state & 0b1000) != 0 /* is-active parseFloatUndefined(Object) */) {
                    if ((JSGuards.isUndefined(arguments0Value_))) {
                        return parseFloatUndefined(arguments0Value_);
                    }
                }
                if ((state & 0b10000) != 0 /* is-active parseFloatNull(Object) */) {
                    if ((JSGuards.isJSNull(arguments0Value_))) {
                        return parseFloatNull(arguments0Value_);
                    }
                }
            }
            if ((state & 0b100000) != 0 /* is-active parseFloat(String) */ && JSTypesGen.isImplicitString((state & 0b111100000000000) >>> 11 /* extract-implicit-active 0:String */, arguments0Value_)) {
                String arguments0Value__ = JSTypesGen.asImplicitString((state & 0b111100000000000) >>> 11 /* extract-implicit-active 0:String */, arguments0Value_);
                return parseFloat(arguments0Value__);
            }
            if ((state & 0b1000000) != 0 /* is-active parseFloat(TruffleObject) */ && arguments0Value_ instanceof TruffleObject) {
                TruffleObject arguments0Value__ = (TruffleObject) arguments0Value_;
                if ((!(JSGuards.isJSNull(arguments0Value__))) && (!(JSGuards.isUndefined(arguments0Value__)))) {
                    return parseFloat(arguments0Value__);
                }
            }
            CompilerDirectives.transferToInterpreterAndInvalidate();
            return executeAndSpecialize(arguments0Value_);
        }

        @Override
        public double executeDouble(VirtualFrame frameValue) throws UnexpectedResultException {
            int state = state_;
            if ((state & 0b1111100) == 0 /* only-active parseFloat(double, ConditionProfile) */ && (state & 0b1111110) != 0  /* is-not parseFloat(double, ConditionProfile) && parseFloat(boolean) && parseFloatUndefined(Object) && parseFloatNull(Object) && parseFloat(String) && parseFloat(TruffleObject) */) {
                return executeDouble_double4(frameValue, state);
            } else if ((state & 0b1111010) == 0 /* only-active parseFloat(boolean) */ && (state & 0b1111110) != 0  /* is-not parseFloat(double, ConditionProfile) && parseFloat(boolean) && parseFloatUndefined(Object) && parseFloatNull(Object) && parseFloat(String) && parseFloat(TruffleObject) */) {
                return executeDouble_boolean5(frameValue, state);
            } else {
                return executeDouble_generic6(frameValue, state);
            }
        }

        private double executeDouble_double4(VirtualFrame frameValue, int state) throws UnexpectedResultException {
            int arguments0Value_int = 0;
            long arguments0Value_long = 0L;
            double arguments0Value_;
            try {
                if ((state & 0b11100000000) == 0 /* only-active 0:double */ && (state & 0b1111111) != 0  /* is-not parseFloat(int) && parseFloat(double, ConditionProfile) && parseFloat(boolean) && parseFloatUndefined(Object) && parseFloatNull(Object) && parseFloat(String) && parseFloat(TruffleObject) */) {
                    arguments0Value_long = this.arguments0_.executeLong(frameValue);
                    arguments0Value_ = JSTypes.longToDouble(arguments0Value_long);
                } else if ((state & 0b11010000000) == 0 /* only-active 0:double */ && (state & 0b1111111) != 0  /* is-not parseFloat(int) && parseFloat(double, ConditionProfile) && parseFloat(boolean) && parseFloatUndefined(Object) && parseFloatNull(Object) && parseFloat(String) && parseFloat(TruffleObject) */) {
                    arguments0Value_int = this.arguments0_.executeInt(frameValue);
                    arguments0Value_ = JSTypes.intToDouble(arguments0Value_int);
                } else if ((state & 0b10110000000) == 0 /* only-active 0:double */ && (state & 0b1111111) != 0  /* is-not parseFloat(int) && parseFloat(double, ConditionProfile) && parseFloat(boolean) && parseFloatUndefined(Object) && parseFloatNull(Object) && parseFloat(String) && parseFloat(TruffleObject) */) {
                    arguments0Value_ = this.arguments0_.executeDouble(frameValue);
                } else {
                    Object arguments0Value__ = this.arguments0_.execute(frameValue);
                    arguments0Value_ = JSTypesGen.expectImplicitDouble((state & 0b11110000000) >>> 7 /* extract-implicit-active 0:double */, arguments0Value__);
                }
            } catch (UnexpectedResultException ex) {
                return JSTypesGen.expectDouble(executeAndSpecialize(ex.getResult()));
            }
            assert (state & 0b10) != 0 /* is-active parseFloat(double, ConditionProfile) */;
            return parseFloat(arguments0Value_, this.parseFloat1_negativeZero_);
        }

        private double executeDouble_boolean5(VirtualFrame frameValue, int state) throws UnexpectedResultException {
            boolean arguments0Value_;
            try {
                arguments0Value_ = this.arguments0_.executeBoolean(frameValue);
            } catch (UnexpectedResultException ex) {
                return JSTypesGen.expectDouble(executeAndSpecialize(ex.getResult()));
            }
            assert (state & 0b100) != 0 /* is-active parseFloat(boolean) */;
            return parseFloat(arguments0Value_);
        }

        private double executeDouble_generic6(VirtualFrame frameValue, int state) throws UnexpectedResultException {
            Object arguments0Value_ = this.arguments0_.execute(frameValue);
            if ((state & 0b10) != 0 /* is-active parseFloat(double, ConditionProfile) */ && JSTypesGen.isImplicitDouble((state & 0b11110000000) >>> 7 /* extract-implicit-active 0:double */, arguments0Value_)) {
                double arguments0Value__ = JSTypesGen.asImplicitDouble((state & 0b11110000000) >>> 7 /* extract-implicit-active 0:double */, arguments0Value_);
                return parseFloat(arguments0Value__, this.parseFloat1_negativeZero_);
            }
            if ((state & 0b100) != 0 /* is-active parseFloat(boolean) */ && arguments0Value_ instanceof Boolean) {
                boolean arguments0Value__ = (boolean) arguments0Value_;
                return parseFloat(arguments0Value__);
            }
            if ((state & 0b11000) != 0 /* is-active parseFloatUndefined(Object) || parseFloatNull(Object) */) {
                if ((state & 0b1000) != 0 /* is-active parseFloatUndefined(Object) */) {
                    if ((JSGuards.isUndefined(arguments0Value_))) {
                        return parseFloatUndefined(arguments0Value_);
                    }
                }
                if ((state & 0b10000) != 0 /* is-active parseFloatNull(Object) */) {
                    if ((JSGuards.isJSNull(arguments0Value_))) {
                        return parseFloatNull(arguments0Value_);
                    }
                }
            }
            if ((state & 0b100000) != 0 /* is-active parseFloat(String) */ && JSTypesGen.isImplicitString((state & 0b111100000000000) >>> 11 /* extract-implicit-active 0:String */, arguments0Value_)) {
                String arguments0Value__ = JSTypesGen.asImplicitString((state & 0b111100000000000) >>> 11 /* extract-implicit-active 0:String */, arguments0Value_);
                return parseFloat(arguments0Value__);
            }
            if ((state & 0b1000000) != 0 /* is-active parseFloat(TruffleObject) */ && arguments0Value_ instanceof TruffleObject) {
                TruffleObject arguments0Value__ = (TruffleObject) arguments0Value_;
                if ((!(JSGuards.isJSNull(arguments0Value__))) && (!(JSGuards.isUndefined(arguments0Value__)))) {
                    return parseFloat(arguments0Value__);
                }
            }
            CompilerDirectives.transferToInterpreterAndInvalidate();
            return JSTypesGen.expectDouble(executeAndSpecialize(arguments0Value_));
        }

        @Override
        public int executeInt(VirtualFrame frameValue) throws UnexpectedResultException {
            int state = state_;
            int arguments0Value_;
            try {
                arguments0Value_ = this.arguments0_.executeInt(frameValue);
            } catch (UnexpectedResultException ex) {
                return JSTypesGen.expectInteger(executeAndSpecialize(ex.getResult()));
            }
            if ((state & 0b1) != 0 /* is-active parseFloat(int) */) {
                return parseFloat(arguments0Value_);
            }
            CompilerDirectives.transferToInterpreterAndInvalidate();
            return JSTypesGen.expectInteger(executeAndSpecialize(arguments0Value_));
        }

        @Override
        public void executeVoid(VirtualFrame frameValue) {
            int state = state_;
            try {
                if ((state & 0b1111110) == 0 /* only-active parseFloat(int) */ && (state & 0b1111111) != 0  /* is-not parseFloat(int) && parseFloat(double, ConditionProfile) && parseFloat(boolean) && parseFloatUndefined(Object) && parseFloatNull(Object) && parseFloat(String) && parseFloat(TruffleObject) */) {
                    executeInt(frameValue);
                    return;
                } else if ((state & 0b1) == 0 /* only-active parseFloat(double, ConditionProfile) && parseFloat(boolean) && parseFloatUndefined(Object) && parseFloatNull(Object) && parseFloat(String) && parseFloat(TruffleObject) */ && (state & 0b1111111) != 0  /* is-not parseFloat(int) && parseFloat(double, ConditionProfile) && parseFloat(boolean) && parseFloatUndefined(Object) && parseFloatNull(Object) && parseFloat(String) && parseFloat(TruffleObject) */) {
                    executeDouble(frameValue);
                    return;
                }
                execute(frameValue);
                return;
            } catch (UnexpectedResultException ex) {
                return;
            }
        }

        private Object executeAndSpecialize(Object arguments0Value) {
            Lock lock = getLock();
            boolean hasLock = true;
            lock.lock();
            int state = state_;
            try {
                if (arguments0Value instanceof Integer) {
                    int arguments0Value_ = (int) arguments0Value;
                    this.state_ = state = state | 0b1 /* add-active parseFloat(int) */;
                    lock.unlock();
                    hasLock = false;
                    return parseFloat(arguments0Value_);
                }
                {
                    int doubleCast0;
                    if ((doubleCast0 = JSTypesGen.specializeImplicitDouble(arguments0Value)) != 0) {
                        double arguments0Value_ = JSTypesGen.asImplicitDouble(doubleCast0, arguments0Value);
                        this.parseFloat1_negativeZero_ = (ConditionProfile.createBinaryProfile());
                        state = (state | (doubleCast0 << 7) /* set-implicit-active 0:double */);
                        this.state_ = state = state | 0b10 /* add-active parseFloat(double, ConditionProfile) */;
                        lock.unlock();
                        hasLock = false;
                        return parseFloat(arguments0Value_, this.parseFloat1_negativeZero_);
                    }
                }
                if (arguments0Value instanceof Boolean) {
                    boolean arguments0Value_ = (boolean) arguments0Value;
                    this.state_ = state = state | 0b100 /* add-active parseFloat(boolean) */;
                    lock.unlock();
                    hasLock = false;
                    return parseFloat(arguments0Value_);
                }
                if ((JSGuards.isUndefined(arguments0Value))) {
                    this.state_ = state = state | 0b1000 /* add-active parseFloatUndefined(Object) */;
                    lock.unlock();
                    hasLock = false;
                    return parseFloatUndefined(arguments0Value);
                }
                if ((JSGuards.isJSNull(arguments0Value))) {
                    this.state_ = state = state | 0b10000 /* add-active parseFloatNull(Object) */;
                    lock.unlock();
                    hasLock = false;
                    return parseFloatNull(arguments0Value);
                }
                {
                    int stringCast0;
                    if ((stringCast0 = JSTypesGen.specializeImplicitString(arguments0Value)) != 0) {
                        String arguments0Value_ = JSTypesGen.asImplicitString(stringCast0, arguments0Value);
                        state = (state | (stringCast0 << 11) /* set-implicit-active 0:String */);
                        this.state_ = state = state | 0b100000 /* add-active parseFloat(String) */;
                        lock.unlock();
                        hasLock = false;
                        return parseFloat(arguments0Value_);
                    }
                }
                if (arguments0Value instanceof TruffleObject) {
                    TruffleObject arguments0Value_ = (TruffleObject) arguments0Value;
                    if ((!(JSGuards.isJSNull(arguments0Value_))) && (!(JSGuards.isUndefined(arguments0Value_)))) {
                        this.state_ = state = state | 0b1000000 /* add-active parseFloat(TruffleObject) */;
                        lock.unlock();
                        hasLock = false;
                        return parseFloat(arguments0Value_);
                    }
                }
                throw new UnsupportedSpecializationException(this, new Node[] {this.arguments0_}, arguments0Value);
            } finally {
                if (hasLock) {
                    lock.unlock();
                }
            }
        }

        @Override
        public NodeCost getCost() {
            int state = state_;
            if ((state & 0b1111111) == 0b0) {
                return NodeCost.UNINITIALIZED;
            } else if (((state & 0b1111111) & ((state & 0b1111111) - 1)) == 0 /* is-single-active  */) {
                return NodeCost.MONOMORPHIC;
            }
            return NodeCost.POLYMORPHIC;
        }

        @Override
        public Introspection getIntrospectionData() {
            Object[] data = new Object[8];
            Object[] s;
            data[0] = 0;
            int state = state_;
            s = new Object[3];
            s[0] = "parseFloat";
            if ((state & 0b1) != 0 /* is-active parseFloat(int) */) {
                s[1] = (byte)0b01 /* active */;
            } else {
                s[1] = (byte)0b00 /* inactive */;
            }
            data[1] = s;
            s = new Object[3];
            s[0] = "parseFloat";
            if ((state & 0b10) != 0 /* is-active parseFloat(double, ConditionProfile) */) {
                s[1] = (byte)0b01 /* active */;
                ArrayList<Object> cached = new ArrayList<>();
                cached.add(Arrays.asList(this.parseFloat1_negativeZero_));
                s[2] = cached;
            } else {
                s[1] = (byte)0b00 /* inactive */;
            }
            data[2] = s;
            s = new Object[3];
            s[0] = "parseFloat";
            if ((state & 0b100) != 0 /* is-active parseFloat(boolean) */) {
                s[1] = (byte)0b01 /* active */;
            } else {
                s[1] = (byte)0b00 /* inactive */;
            }
            data[3] = s;
            s = new Object[3];
            s[0] = "parseFloatUndefined";
            if ((state & 0b1000) != 0 /* is-active parseFloatUndefined(Object) */) {
                s[1] = (byte)0b01 /* active */;
            } else {
                s[1] = (byte)0b00 /* inactive */;
            }
            data[4] = s;
            s = new Object[3];
            s[0] = "parseFloatNull";
            if ((state & 0b10000) != 0 /* is-active parseFloatNull(Object) */) {
                s[1] = (byte)0b01 /* active */;
            } else {
                s[1] = (byte)0b00 /* inactive */;
            }
            data[5] = s;
            s = new Object[3];
            s[0] = "parseFloat";
            if ((state & 0b100000) != 0 /* is-active parseFloat(String) */) {
                s[1] = (byte)0b01 /* active */;
            } else {
                s[1] = (byte)0b00 /* inactive */;
            }
            data[6] = s;
            s = new Object[3];
            s[0] = "parseFloat";
            if ((state & 0b1000000) != 0 /* is-active parseFloat(TruffleObject) */) {
                s[1] = (byte)0b01 /* active */;
            } else {
                s[1] = (byte)0b00 /* inactive */;
            }
            data[7] = s;
            return Provider.create(data);
        }

        public static JSGlobalParseFloatNode create(JSContext context, JSBuiltin builtin, JavaScriptNode[] arguments) {
            return new JSGlobalParseFloatNodeGen(context, builtin, arguments);
        }

    }
    @GeneratedBy(JSGlobalParseIntNode.class)
    public static final class JSGlobalParseIntNodeGen extends JSGlobalParseIntNode implements Provider {

        @Child private JavaScriptNode arguments0_;
        @Child private JavaScriptNode arguments1_;
        @CompilationFinal private int state_;
        @CompilationFinal private BranchProfile parseInt0_needsRadixConversion_;
        @CompilationFinal private BranchProfile parseInt1_needsRadixConversion_;
        @Child private ParseIntGenericData parseIntGeneric_cache;

        private JSGlobalParseIntNodeGen(JSContext context, JSBuiltin builtin, JavaScriptNode[] arguments) {
            super(context, builtin);
            this.arguments0_ = arguments != null && 0 < arguments.length ? arguments[0] : null;
            this.arguments1_ = arguments != null && 1 < arguments.length ? arguments[1] : null;
        }

        @Override
        public JavaScriptNode[] getArguments() {
            return new JavaScriptNode[] {this.arguments0_, this.arguments1_};
        }

        @Override
        public Object execute(VirtualFrame frameValue) {
            int state = state_;
            if ((state & 0b111100) == 0 /* only-active parseIntNoRadix(int, Object) && parseInt(int, Object, BranchProfile) */ && (state & 0b111111) != 0  /* is-not parseIntNoRadix(int, Object) && parseInt(int, Object, BranchProfile) && parseIntDoubleToInt(double, Object) && parseIntNoRadix(double, Object) && parseInt(double, Object, BranchProfile) && parseIntGeneric(Object, Object, JSToStringNode, JSTrimWhitespaceNode, BranchProfile, BranchProfile, BranchProfile) */) {
                return execute_int0(frameValue, state);
            } else if ((state & 0b100011) == 0 /* only-active parseIntDoubleToInt(double, Object) && parseIntNoRadix(double, Object) && parseInt(double, Object, BranchProfile) */ && (state & 0b111111) != 0  /* is-not parseIntNoRadix(int, Object) && parseInt(int, Object, BranchProfile) && parseIntDoubleToInt(double, Object) && parseIntNoRadix(double, Object) && parseInt(double, Object, BranchProfile) && parseIntGeneric(Object, Object, JSToStringNode, JSTrimWhitespaceNode, BranchProfile, BranchProfile, BranchProfile) */) {
                return execute_double1(frameValue, state);
            } else {
                return execute_generic2(frameValue, state);
            }
        }

        private Object execute_int0(VirtualFrame frameValue, int state) {
            int arguments0Value_;
            try {
                arguments0Value_ = this.arguments0_.executeInt(frameValue);
            } catch (UnexpectedResultException ex) {
                Object arguments1Value = this.arguments1_.execute(frameValue);
                return executeAndSpecialize(ex.getResult(), arguments1Value);
            }
            Object arguments1Value_ = this.arguments1_.execute(frameValue);
            if ((state & 0b11) != 0 /* is-active parseIntNoRadix(int, Object) || parseInt(int, Object, BranchProfile) */) {
                if ((state & 0b1) != 0 /* is-active parseIntNoRadix(int, Object) */) {
                    if ((JSGuards.isUndefined(arguments1Value_))) {
                        return parseIntNoRadix(arguments0Value_, arguments1Value_);
                    }
                }
                if ((state & 0b10) != 0 /* is-active parseInt(int, Object, BranchProfile) */) {
                    if ((!(JSGuards.isUndefined(arguments1Value_)))) {
                        return parseInt(arguments0Value_, arguments1Value_, this.parseInt0_needsRadixConversion_);
                    }
                }
            }
            CompilerDirectives.transferToInterpreterAndInvalidate();
            return executeAndSpecialize(arguments0Value_, arguments1Value_);
        }

        private Object execute_double1(VirtualFrame frameValue, int state) {
            int arguments0Value_int = 0;
            long arguments0Value_long = 0L;
            double arguments0Value_;
            try {
                if ((state & 0b1110000000) == 0 /* only-active 0:double */ && (state & 0b111111) != 0  /* is-not parseIntNoRadix(int, Object) && parseInt(int, Object, BranchProfile) && parseIntDoubleToInt(double, Object) && parseIntNoRadix(double, Object) && parseInt(double, Object, BranchProfile) && parseIntGeneric(Object, Object, JSToStringNode, JSTrimWhitespaceNode, BranchProfile, BranchProfile, BranchProfile) */) {
                    arguments0Value_long = this.arguments0_.executeLong(frameValue);
                    arguments0Value_ = JSTypes.longToDouble(arguments0Value_long);
                } else if ((state & 0b1101000000) == 0 /* only-active 0:double */ && (state & 0b111111) != 0  /* is-not parseIntNoRadix(int, Object) && parseInt(int, Object, BranchProfile) && parseIntDoubleToInt(double, Object) && parseIntNoRadix(double, Object) && parseInt(double, Object, BranchProfile) && parseIntGeneric(Object, Object, JSToStringNode, JSTrimWhitespaceNode, BranchProfile, BranchProfile, BranchProfile) */) {
                    arguments0Value_int = this.arguments0_.executeInt(frameValue);
                    arguments0Value_ = JSTypes.intToDouble(arguments0Value_int);
                } else if ((state & 0b1011000000) == 0 /* only-active 0:double */ && (state & 0b111111) != 0  /* is-not parseIntNoRadix(int, Object) && parseInt(int, Object, BranchProfile) && parseIntDoubleToInt(double, Object) && parseIntNoRadix(double, Object) && parseInt(double, Object, BranchProfile) && parseIntGeneric(Object, Object, JSToStringNode, JSTrimWhitespaceNode, BranchProfile, BranchProfile, BranchProfile) */) {
                    arguments0Value_ = this.arguments0_.executeDouble(frameValue);
                } else {
                    Object arguments0Value__ = this.arguments0_.execute(frameValue);
                    arguments0Value_ = JSTypesGen.expectImplicitDouble((state & 0b1111000000) >>> 6 /* extract-implicit-active 0:double */, arguments0Value__);
                }
            } catch (UnexpectedResultException ex) {
                Object arguments1Value = this.arguments1_.execute(frameValue);
                return executeAndSpecialize(ex.getResult(), arguments1Value);
            }
            Object arguments1Value_ = this.arguments1_.execute(frameValue);
            if ((state & 0b11100) != 0 /* is-active parseIntDoubleToInt(double, Object) || parseIntNoRadix(double, Object) || parseInt(double, Object, BranchProfile) */) {
                if ((state & 0b100) != 0 /* is-active parseIntDoubleToInt(double, Object) */) {
                    if ((JSGlobalParseIntNode.hasRegularToStringInInt32Range(arguments0Value_)) && (JSGuards.isUndefined(arguments1Value_))) {
                        return parseIntDoubleToInt(arguments0Value_, arguments1Value_);
                    }
                }
                if ((state & 0b1000) != 0 /* is-active parseIntNoRadix(double, Object) */) {
                    if ((JSGlobalParseIntNode.hasRegularToString(arguments0Value_)) && (JSGuards.isUndefined(arguments1Value_))) {
                        return parseIntNoRadix(arguments0Value_, arguments1Value_);
                    }
                }
                if ((state & 0b10000) != 0 /* is-active parseInt(double, Object, BranchProfile) */) {
                    if ((JSGlobalParseIntNode.hasRegularToString(arguments0Value_))) {
                        return parseInt(arguments0Value_, arguments1Value_, this.parseInt1_needsRadixConversion_);
                    }
                }
            }
            CompilerDirectives.transferToInterpreterAndInvalidate();
            return executeAndSpecialize(((state & 0b1110000000) == 0 /* only-active 0:double */ && (state & 0b111111) != 0  /* is-not parseIntNoRadix(int, Object) && parseInt(int, Object, BranchProfile) && parseIntDoubleToInt(double, Object) && parseIntNoRadix(double, Object) && parseInt(double, Object, BranchProfile) && parseIntGeneric(Object, Object, JSToStringNode, JSTrimWhitespaceNode, BranchProfile, BranchProfile, BranchProfile) */ ? (Object) arguments0Value_long : ((state & 0b1101000000) == 0 /* only-active 0:double */ && (state & 0b111111) != 0  /* is-not parseIntNoRadix(int, Object) && parseInt(int, Object, BranchProfile) && parseIntDoubleToInt(double, Object) && parseIntNoRadix(double, Object) && parseInt(double, Object, BranchProfile) && parseIntGeneric(Object, Object, JSToStringNode, JSTrimWhitespaceNode, BranchProfile, BranchProfile, BranchProfile) */ ? (Object) arguments0Value_int : (Object) arguments0Value_)), arguments1Value_);
        }

        private Object execute_generic2(VirtualFrame frameValue, int state) {
            Object arguments0Value_ = this.arguments0_.execute(frameValue);
            Object arguments1Value_ = this.arguments1_.execute(frameValue);
            if ((state & 0b111111) != 0 /* is-active parseIntNoRadix(int, Object) || parseInt(int, Object, BranchProfile) || parseIntDoubleToInt(double, Object) || parseIntNoRadix(double, Object) || parseInt(double, Object, BranchProfile) || parseIntGeneric(Object, Object, JSToStringNode, JSTrimWhitespaceNode, BranchProfile, BranchProfile, BranchProfile) */) {
                if ((state & 0b11) != 0 /* is-active parseIntNoRadix(int, Object) || parseInt(int, Object, BranchProfile) */ && arguments0Value_ instanceof Integer) {
                    int arguments0Value__ = (int) arguments0Value_;
                    if ((state & 0b1) != 0 /* is-active parseIntNoRadix(int, Object) */) {
                        if ((JSGuards.isUndefined(arguments1Value_))) {
                            return parseIntNoRadix(arguments0Value__, arguments1Value_);
                        }
                    }
                    if ((state & 0b10) != 0 /* is-active parseInt(int, Object, BranchProfile) */) {
                        if ((!(JSGuards.isUndefined(arguments1Value_)))) {
                            return parseInt(arguments0Value__, arguments1Value_, this.parseInt0_needsRadixConversion_);
                        }
                    }
                }
                if ((state & 0b11100) != 0 /* is-active parseIntDoubleToInt(double, Object) || parseIntNoRadix(double, Object) || parseInt(double, Object, BranchProfile) */ && JSTypesGen.isImplicitDouble((state & 0b1111000000) >>> 6 /* extract-implicit-active 0:double */, arguments0Value_)) {
                    double arguments0Value__ = JSTypesGen.asImplicitDouble((state & 0b1111000000) >>> 6 /* extract-implicit-active 0:double */, arguments0Value_);
                    if ((state & 0b100) != 0 /* is-active parseIntDoubleToInt(double, Object) */) {
                        if ((JSGlobalParseIntNode.hasRegularToStringInInt32Range(arguments0Value__)) && (JSGuards.isUndefined(arguments1Value_))) {
                            return parseIntDoubleToInt(arguments0Value__, arguments1Value_);
                        }
                    }
                    if ((state & 0b1000) != 0 /* is-active parseIntNoRadix(double, Object) */) {
                        if ((JSGlobalParseIntNode.hasRegularToString(arguments0Value__)) && (JSGuards.isUndefined(arguments1Value_))) {
                            return parseIntNoRadix(arguments0Value__, arguments1Value_);
                        }
                    }
                    if ((state & 0b10000) != 0 /* is-active parseInt(double, Object, BranchProfile) */) {
                        if ((JSGlobalParseIntNode.hasRegularToString(arguments0Value__))) {
                            return parseInt(arguments0Value__, arguments1Value_, this.parseInt1_needsRadixConversion_);
                        }
                    }
                }
                if ((state & 0b100000) != 0 /* is-active parseIntGeneric(Object, Object, JSToStringNode, JSTrimWhitespaceNode, BranchProfile, BranchProfile, BranchProfile) */) {
                    ParseIntGenericData s6_ = this.parseIntGeneric_cache;
                    if (s6_ != null) {
                        return parseIntGeneric(arguments0Value_, arguments1Value_, s6_.toStringNode_, s6_.trimWhitespaceNode_, s6_.needsRadix16_, s6_.needsDontFitLong_, s6_.needsTrimming_);
                    }
                }
            }
            CompilerDirectives.transferToInterpreterAndInvalidate();
            return executeAndSpecialize(arguments0Value_, arguments1Value_);
        }

        @Override
        public double executeDouble(VirtualFrame frameValue) throws UnexpectedResultException {
            int state = state_;
            if ((state & 0b100010) != 0 /* is-active parseInt(int, Object, BranchProfile) || parseIntGeneric(Object, Object, JSToStringNode, JSTrimWhitespaceNode, BranchProfile, BranchProfile, BranchProfile) */) {
                return JSTypesGen.expectDouble(execute(frameValue));
            }
            int arguments0Value_int = 0;
            long arguments0Value_long = 0L;
            double arguments0Value_;
            try {
                if ((state & 0b1110000000) == 0 /* only-active 0:double */ && (state & 0b111111) != 0  /* is-not parseIntNoRadix(int, Object) && parseInt(int, Object, BranchProfile) && parseIntDoubleToInt(double, Object) && parseIntNoRadix(double, Object) && parseInt(double, Object, BranchProfile) && parseIntGeneric(Object, Object, JSToStringNode, JSTrimWhitespaceNode, BranchProfile, BranchProfile, BranchProfile) */) {
                    arguments0Value_long = this.arguments0_.executeLong(frameValue);
                    arguments0Value_ = JSTypes.longToDouble(arguments0Value_long);
                } else if ((state & 0b1101000000) == 0 /* only-active 0:double */ && (state & 0b111111) != 0  /* is-not parseIntNoRadix(int, Object) && parseInt(int, Object, BranchProfile) && parseIntDoubleToInt(double, Object) && parseIntNoRadix(double, Object) && parseInt(double, Object, BranchProfile) && parseIntGeneric(Object, Object, JSToStringNode, JSTrimWhitespaceNode, BranchProfile, BranchProfile, BranchProfile) */) {
                    arguments0Value_int = this.arguments0_.executeInt(frameValue);
                    arguments0Value_ = JSTypes.intToDouble(arguments0Value_int);
                } else if ((state & 0b1011000000) == 0 /* only-active 0:double */ && (state & 0b111111) != 0  /* is-not parseIntNoRadix(int, Object) && parseInt(int, Object, BranchProfile) && parseIntDoubleToInt(double, Object) && parseIntNoRadix(double, Object) && parseInt(double, Object, BranchProfile) && parseIntGeneric(Object, Object, JSToStringNode, JSTrimWhitespaceNode, BranchProfile, BranchProfile, BranchProfile) */) {
                    arguments0Value_ = this.arguments0_.executeDouble(frameValue);
                } else {
                    Object arguments0Value__ = this.arguments0_.execute(frameValue);
                    arguments0Value_ = JSTypesGen.expectImplicitDouble((state & 0b1111000000) >>> 6 /* extract-implicit-active 0:double */, arguments0Value__);
                }
            } catch (UnexpectedResultException ex) {
                Object arguments1Value = this.arguments1_.execute(frameValue);
                return JSTypesGen.expectDouble(executeAndSpecialize(ex.getResult(), arguments1Value));
            }
            Object arguments1Value_ = this.arguments1_.execute(frameValue);
            if ((state & 0b11000) != 0 /* is-active parseIntNoRadix(double, Object) || parseInt(double, Object, BranchProfile) */) {
                if ((state & 0b1000) != 0 /* is-active parseIntNoRadix(double, Object) */) {
                    if ((JSGlobalParseIntNode.hasRegularToString(arguments0Value_)) && (JSGuards.isUndefined(arguments1Value_))) {
                        return parseIntNoRadix(arguments0Value_, arguments1Value_);
                    }
                }
                if ((state & 0b10000) != 0 /* is-active parseInt(double, Object, BranchProfile) */) {
                    if ((JSGlobalParseIntNode.hasRegularToString(arguments0Value_))) {
                        return parseInt(arguments0Value_, arguments1Value_, this.parseInt1_needsRadixConversion_);
                    }
                }
            }
            CompilerDirectives.transferToInterpreterAndInvalidate();
            return JSTypesGen.expectDouble(executeAndSpecialize(((state & 0b1110000000) == 0 /* only-active 0:double */ && (state & 0b111111) != 0  /* is-not parseIntNoRadix(int, Object) && parseInt(int, Object, BranchProfile) && parseIntDoubleToInt(double, Object) && parseIntNoRadix(double, Object) && parseInt(double, Object, BranchProfile) && parseIntGeneric(Object, Object, JSToStringNode, JSTrimWhitespaceNode, BranchProfile, BranchProfile, BranchProfile) */ ? (Object) arguments0Value_long : ((state & 0b1101000000) == 0 /* only-active 0:double */ && (state & 0b111111) != 0  /* is-not parseIntNoRadix(int, Object) && parseInt(int, Object, BranchProfile) && parseIntDoubleToInt(double, Object) && parseIntNoRadix(double, Object) && parseInt(double, Object, BranchProfile) && parseIntGeneric(Object, Object, JSToStringNode, JSTrimWhitespaceNode, BranchProfile, BranchProfile, BranchProfile) */ ? (Object) arguments0Value_int : (Object) arguments0Value_)), arguments1Value_));
        }

        @Override
        public int executeInt(VirtualFrame frameValue) throws UnexpectedResultException {
            int state = state_;
            if ((state & 0b100010) != 0 /* is-active parseInt(int, Object, BranchProfile) || parseIntGeneric(Object, Object, JSToStringNode, JSTrimWhitespaceNode, BranchProfile, BranchProfile, BranchProfile) */) {
                return JSTypesGen.expectInteger(execute(frameValue));
            }
            if ((state & 0b100) == 0 /* only-active parseIntNoRadix(int, Object) */ && (state & 0b101) != 0  /* is-not parseIntNoRadix(int, Object) && parseIntDoubleToInt(double, Object) */) {
                return executeInt_int3(frameValue, state);
            } else if ((state & 0b1) == 0 /* only-active parseIntDoubleToInt(double, Object) */ && (state & 0b101) != 0  /* is-not parseIntNoRadix(int, Object) && parseIntDoubleToInt(double, Object) */) {
                return executeInt_double4(frameValue, state);
            } else {
                return executeInt_generic5(frameValue, state);
            }
        }

        private int executeInt_int3(VirtualFrame frameValue, int state) throws UnexpectedResultException {
            int arguments0Value_;
            try {
                arguments0Value_ = this.arguments0_.executeInt(frameValue);
            } catch (UnexpectedResultException ex) {
                Object arguments1Value = this.arguments1_.execute(frameValue);
                return JSTypesGen.expectInteger(executeAndSpecialize(ex.getResult(), arguments1Value));
            }
            Object arguments1Value_ = this.arguments1_.execute(frameValue);
            assert (state & 0b1) != 0 /* is-active parseIntNoRadix(int, Object) */;
            if ((JSGuards.isUndefined(arguments1Value_))) {
                return parseIntNoRadix(arguments0Value_, arguments1Value_);
            }
            CompilerDirectives.transferToInterpreterAndInvalidate();
            return JSTypesGen.expectInteger(executeAndSpecialize(arguments0Value_, arguments1Value_));
        }

        private int executeInt_double4(VirtualFrame frameValue, int state) throws UnexpectedResultException {
            int arguments0Value_int = 0;
            long arguments0Value_long = 0L;
            double arguments0Value_;
            try {
                if ((state & 0b1110000000) == 0 /* only-active 0:double */ && (state & 0b111111) != 0  /* is-not parseIntNoRadix(int, Object) && parseInt(int, Object, BranchProfile) && parseIntDoubleToInt(double, Object) && parseIntNoRadix(double, Object) && parseInt(double, Object, BranchProfile) && parseIntGeneric(Object, Object, JSToStringNode, JSTrimWhitespaceNode, BranchProfile, BranchProfile, BranchProfile) */) {
                    arguments0Value_long = this.arguments0_.executeLong(frameValue);
                    arguments0Value_ = JSTypes.longToDouble(arguments0Value_long);
                } else if ((state & 0b1101000000) == 0 /* only-active 0:double */ && (state & 0b111111) != 0  /* is-not parseIntNoRadix(int, Object) && parseInt(int, Object, BranchProfile) && parseIntDoubleToInt(double, Object) && parseIntNoRadix(double, Object) && parseInt(double, Object, BranchProfile) && parseIntGeneric(Object, Object, JSToStringNode, JSTrimWhitespaceNode, BranchProfile, BranchProfile, BranchProfile) */) {
                    arguments0Value_int = this.arguments0_.executeInt(frameValue);
                    arguments0Value_ = JSTypes.intToDouble(arguments0Value_int);
                } else if ((state & 0b1011000000) == 0 /* only-active 0:double */ && (state & 0b111111) != 0  /* is-not parseIntNoRadix(int, Object) && parseInt(int, Object, BranchProfile) && parseIntDoubleToInt(double, Object) && parseIntNoRadix(double, Object) && parseInt(double, Object, BranchProfile) && parseIntGeneric(Object, Object, JSToStringNode, JSTrimWhitespaceNode, BranchProfile, BranchProfile, BranchProfile) */) {
                    arguments0Value_ = this.arguments0_.executeDouble(frameValue);
                } else {
                    Object arguments0Value__ = this.arguments0_.execute(frameValue);
                    arguments0Value_ = JSTypesGen.expectImplicitDouble((state & 0b1111000000) >>> 6 /* extract-implicit-active 0:double */, arguments0Value__);
                }
            } catch (UnexpectedResultException ex) {
                Object arguments1Value = this.arguments1_.execute(frameValue);
                return JSTypesGen.expectInteger(executeAndSpecialize(ex.getResult(), arguments1Value));
            }
            Object arguments1Value_ = this.arguments1_.execute(frameValue);
            assert (state & 0b100) != 0 /* is-active parseIntDoubleToInt(double, Object) */;
            if ((JSGlobalParseIntNode.hasRegularToStringInInt32Range(arguments0Value_)) && (JSGuards.isUndefined(arguments1Value_))) {
                return parseIntDoubleToInt(arguments0Value_, arguments1Value_);
            }
            CompilerDirectives.transferToInterpreterAndInvalidate();
            return JSTypesGen.expectInteger(executeAndSpecialize(((state & 0b1110000000) == 0 /* only-active 0:double */ && (state & 0b111111) != 0  /* is-not parseIntNoRadix(int, Object) && parseInt(int, Object, BranchProfile) && parseIntDoubleToInt(double, Object) && parseIntNoRadix(double, Object) && parseInt(double, Object, BranchProfile) && parseIntGeneric(Object, Object, JSToStringNode, JSTrimWhitespaceNode, BranchProfile, BranchProfile, BranchProfile) */ ? (Object) arguments0Value_long : ((state & 0b1101000000) == 0 /* only-active 0:double */ && (state & 0b111111) != 0  /* is-not parseIntNoRadix(int, Object) && parseInt(int, Object, BranchProfile) && parseIntDoubleToInt(double, Object) && parseIntNoRadix(double, Object) && parseInt(double, Object, BranchProfile) && parseIntGeneric(Object, Object, JSToStringNode, JSTrimWhitespaceNode, BranchProfile, BranchProfile, BranchProfile) */ ? (Object) arguments0Value_int : (Object) arguments0Value_)), arguments1Value_));
        }

        private int executeInt_generic5(VirtualFrame frameValue, int state) throws UnexpectedResultException {
            Object arguments0Value_ = this.arguments0_.execute(frameValue);
            Object arguments1Value_ = this.arguments1_.execute(frameValue);
            if ((state & 0b101) != 0 /* is-active parseIntNoRadix(int, Object) || parseIntDoubleToInt(double, Object) */) {
                if ((state & 0b1) != 0 /* is-active parseIntNoRadix(int, Object) */ && arguments0Value_ instanceof Integer) {
                    int arguments0Value__ = (int) arguments0Value_;
                    if ((JSGuards.isUndefined(arguments1Value_))) {
                        return parseIntNoRadix(arguments0Value__, arguments1Value_);
                    }
                }
                if ((state & 0b100) != 0 /* is-active parseIntDoubleToInt(double, Object) */ && JSTypesGen.isImplicitDouble((state & 0b1111000000) >>> 6 /* extract-implicit-active 0:double */, arguments0Value_)) {
                    double arguments0Value__ = JSTypesGen.asImplicitDouble((state & 0b1111000000) >>> 6 /* extract-implicit-active 0:double */, arguments0Value_);
                    if ((JSGlobalParseIntNode.hasRegularToStringInInt32Range(arguments0Value__)) && (JSGuards.isUndefined(arguments1Value_))) {
                        return parseIntDoubleToInt(arguments0Value__, arguments1Value_);
                    }
                }
            }
            CompilerDirectives.transferToInterpreterAndInvalidate();
            return JSTypesGen.expectInteger(executeAndSpecialize(arguments0Value_, arguments1Value_));
        }

        @Override
        public void executeVoid(VirtualFrame frameValue) {
            int state = state_;
            try {
                if ((state & 0b111010) == 0 /* only-active parseIntNoRadix(int, Object) && parseIntDoubleToInt(double, Object) */ && (state & 0b111111) != 0  /* is-not parseIntNoRadix(int, Object) && parseInt(int, Object, BranchProfile) && parseIntDoubleToInt(double, Object) && parseIntNoRadix(double, Object) && parseInt(double, Object, BranchProfile) && parseIntGeneric(Object, Object, JSToStringNode, JSTrimWhitespaceNode, BranchProfile, BranchProfile, BranchProfile) */) {
                    executeInt(frameValue);
                    return;
                } else if ((state & 0b100111) == 0 /* only-active parseIntNoRadix(double, Object) && parseInt(double, Object, BranchProfile) */ && (state & 0b111111) != 0  /* is-not parseIntNoRadix(int, Object) && parseInt(int, Object, BranchProfile) && parseIntDoubleToInt(double, Object) && parseIntNoRadix(double, Object) && parseInt(double, Object, BranchProfile) && parseIntGeneric(Object, Object, JSToStringNode, JSTrimWhitespaceNode, BranchProfile, BranchProfile, BranchProfile) */) {
                    executeDouble(frameValue);
                    return;
                }
                execute(frameValue);
                return;
            } catch (UnexpectedResultException ex) {
                return;
            }
        }

        private Object executeAndSpecialize(Object arguments0Value, Object arguments1Value) {
            Lock lock = getLock();
            boolean hasLock = true;
            lock.lock();
            int state = state_;
            try {
                if (arguments0Value instanceof Integer) {
                    int arguments0Value_ = (int) arguments0Value;
                    if ((JSGuards.isUndefined(arguments1Value))) {
                        this.state_ = state = state | 0b1 /* add-active parseIntNoRadix(int, Object) */;
                        lock.unlock();
                        hasLock = false;
                        return parseIntNoRadix(arguments0Value_, arguments1Value);
                    }
                    if ((!(JSGuards.isUndefined(arguments1Value)))) {
                        this.parseInt0_needsRadixConversion_ = (BranchProfile.create());
                        this.state_ = state = state | 0b10 /* add-active parseInt(int, Object, BranchProfile) */;
                        lock.unlock();
                        hasLock = false;
                        return parseInt(arguments0Value_, arguments1Value, this.parseInt0_needsRadixConversion_);
                    }
                }
                {
                    int doubleCast0;
                    if ((doubleCast0 = JSTypesGen.specializeImplicitDouble(arguments0Value)) != 0) {
                        double arguments0Value_ = JSTypesGen.asImplicitDouble(doubleCast0, arguments0Value);
                        if ((JSGlobalParseIntNode.hasRegularToStringInInt32Range(arguments0Value_)) && (JSGuards.isUndefined(arguments1Value))) {
                            state = (state | (doubleCast0 << 6) /* set-implicit-active 0:double */);
                            this.state_ = state = state | 0b100 /* add-active parseIntDoubleToInt(double, Object) */;
                            lock.unlock();
                            hasLock = false;
                            return parseIntDoubleToInt(arguments0Value_, arguments1Value);
                        }
                        if ((JSGlobalParseIntNode.hasRegularToString(arguments0Value_)) && (JSGuards.isUndefined(arguments1Value))) {
                            state = (state | (doubleCast0 << 6) /* set-implicit-active 0:double */);
                            this.state_ = state = state | 0b1000 /* add-active parseIntNoRadix(double, Object) */;
                            lock.unlock();
                            hasLock = false;
                            return parseIntNoRadix(arguments0Value_, arguments1Value);
                        }
                        if ((JSGlobalParseIntNode.hasRegularToString(arguments0Value_))) {
                            this.parseInt1_needsRadixConversion_ = (BranchProfile.create());
                            state = (state | (doubleCast0 << 6) /* set-implicit-active 0:double */);
                            this.state_ = state = state | 0b10000 /* add-active parseInt(double, Object, BranchProfile) */;
                            lock.unlock();
                            hasLock = false;
                            return parseInt(arguments0Value_, arguments1Value, this.parseInt1_needsRadixConversion_);
                        }
                    }
                }
                ParseIntGenericData s6_ = super.insert(new ParseIntGenericData());
                s6_.toStringNode_ = s6_.insertAccessor((JSToStringNode.create()));
                s6_.trimWhitespaceNode_ = s6_.insertAccessor((JSTrimWhitespaceNode.create()));
                s6_.needsRadix16_ = (BranchProfile.create());
                s6_.needsDontFitLong_ = (BranchProfile.create());
                s6_.needsTrimming_ = (BranchProfile.create());
                this.parseIntGeneric_cache = s6_;
                this.state_ = state = state | 0b100000 /* add-active parseIntGeneric(Object, Object, JSToStringNode, JSTrimWhitespaceNode, BranchProfile, BranchProfile, BranchProfile) */;
                lock.unlock();
                hasLock = false;
                return parseIntGeneric(arguments0Value, arguments1Value, s6_.toStringNode_, s6_.trimWhitespaceNode_, s6_.needsRadix16_, s6_.needsDontFitLong_, s6_.needsTrimming_);
            } finally {
                if (hasLock) {
                    lock.unlock();
                }
            }
        }

        @Override
        public NodeCost getCost() {
            int state = state_;
            if ((state & 0b111111) == 0b0) {
                return NodeCost.UNINITIALIZED;
            } else if (((state & 0b111111) & ((state & 0b111111) - 1)) == 0 /* is-single-active  */) {
                return NodeCost.MONOMORPHIC;
            }
            return NodeCost.POLYMORPHIC;
        }

        @Override
        public Introspection getIntrospectionData() {
            Object[] data = new Object[7];
            Object[] s;
            data[0] = 0;
            int state = state_;
            s = new Object[3];
            s[0] = "parseIntNoRadix";
            if ((state & 0b1) != 0 /* is-active parseIntNoRadix(int, Object) */) {
                s[1] = (byte)0b01 /* active */;
            } else {
                s[1] = (byte)0b00 /* inactive */;
            }
            data[1] = s;
            s = new Object[3];
            s[0] = "parseInt";
            if ((state & 0b10) != 0 /* is-active parseInt(int, Object, BranchProfile) */) {
                s[1] = (byte)0b01 /* active */;
                ArrayList<Object> cached = new ArrayList<>();
                cached.add(Arrays.asList(this.parseInt0_needsRadixConversion_));
                s[2] = cached;
            } else {
                s[1] = (byte)0b00 /* inactive */;
            }
            data[2] = s;
            s = new Object[3];
            s[0] = "parseIntDoubleToInt";
            if ((state & 0b100) != 0 /* is-active parseIntDoubleToInt(double, Object) */) {
                s[1] = (byte)0b01 /* active */;
            } else {
                s[1] = (byte)0b00 /* inactive */;
            }
            data[3] = s;
            s = new Object[3];
            s[0] = "parseIntNoRadix";
            if ((state & 0b1000) != 0 /* is-active parseIntNoRadix(double, Object) */) {
                s[1] = (byte)0b01 /* active */;
            } else {
                s[1] = (byte)0b00 /* inactive */;
            }
            data[4] = s;
            s = new Object[3];
            s[0] = "parseInt";
            if ((state & 0b10000) != 0 /* is-active parseInt(double, Object, BranchProfile) */) {
                s[1] = (byte)0b01 /* active */;
                ArrayList<Object> cached = new ArrayList<>();
                cached.add(Arrays.asList(this.parseInt1_needsRadixConversion_));
                s[2] = cached;
            } else {
                s[1] = (byte)0b00 /* inactive */;
            }
            data[5] = s;
            s = new Object[3];
            s[0] = "parseIntGeneric";
            if ((state & 0b100000) != 0 /* is-active parseIntGeneric(Object, Object, JSToStringNode, JSTrimWhitespaceNode, BranchProfile, BranchProfile, BranchProfile) */) {
                s[1] = (byte)0b01 /* active */;
                ArrayList<Object> cached = new ArrayList<>();
                ParseIntGenericData s6_ = this.parseIntGeneric_cache;
                if (s6_ != null) {
                    cached.add(Arrays.asList(s6_.toStringNode_, s6_.trimWhitespaceNode_, s6_.needsRadix16_, s6_.needsDontFitLong_, s6_.needsTrimming_));
                }
                s[2] = cached;
            } else {
                s[1] = (byte)0b00 /* inactive */;
            }
            data[6] = s;
            return Provider.create(data);
        }

        public static JSGlobalParseIntNode create(JSContext context, JSBuiltin builtin, JavaScriptNode[] arguments) {
            return new JSGlobalParseIntNodeGen(context, builtin, arguments);
        }

        @GeneratedBy(JSGlobalParseIntNode.class)
        private static final class ParseIntGenericData extends Node {

            @Child JSToStringNode toStringNode_;
            @Child JSTrimWhitespaceNode trimWhitespaceNode_;
            @CompilationFinal BranchProfile needsRadix16_;
            @CompilationFinal BranchProfile needsDontFitLong_;
            @CompilationFinal BranchProfile needsTrimming_;

            ParseIntGenericData() {
            }

            @Override
            public NodeCost getCost() {
                return NodeCost.NONE;
            }

            <T extends Node> T insertAccessor(T node) {
                return super.insert(node);
            }

        }
    }
    @GeneratedBy(JSGlobalEncodeURINode.class)
    public static final class JSGlobalEncodeURINodeGen extends JSGlobalEncodeURINode implements Provider {

        @Child private JavaScriptNode arguments0_;

        private JSGlobalEncodeURINodeGen(JSContext context, JSBuiltin builtin, boolean isSpecial, JavaScriptNode[] arguments) {
            super(context, builtin, isSpecial);
            this.arguments0_ = arguments != null && 0 < arguments.length ? arguments[0] : null;
        }

        @Override
        public JavaScriptNode[] getArguments() {
            return new JavaScriptNode[] {this.arguments0_};
        }

        @Override
        public Object execute(VirtualFrame frameValue) {
            Object arguments0Value_ = this.arguments0_.execute(frameValue);
            return encodeURI(arguments0Value_);
        }

        @Override
        public void executeVoid(VirtualFrame frameValue) {
            execute(frameValue);
            return;
        }

        @Override
        public NodeCost getCost() {
            return NodeCost.MONOMORPHIC;
        }

        @Override
        public Introspection getIntrospectionData() {
            Object[] data = new Object[2];
            Object[] s;
            data[0] = 0;
            s = new Object[3];
            s[0] = "encodeURI";
            s[1] = (byte)0b01 /* active */;
            data[1] = s;
            return Provider.create(data);
        }

        public static JSGlobalEncodeURINode create(JSContext context, JSBuiltin builtin, boolean isSpecial, JavaScriptNode[] arguments) {
            return new JSGlobalEncodeURINodeGen(context, builtin, isSpecial, arguments);
        }

    }
    @GeneratedBy(JSGlobalDecodeURINode.class)
    public static final class JSGlobalDecodeURINodeGen extends JSGlobalDecodeURINode implements Provider {

        @Child private JavaScriptNode arguments0_;

        private JSGlobalDecodeURINodeGen(JSContext context, JSBuiltin builtin, boolean isSpecial, JavaScriptNode[] arguments) {
            super(context, builtin, isSpecial);
            this.arguments0_ = arguments != null && 0 < arguments.length ? arguments[0] : null;
        }

        @Override
        public JavaScriptNode[] getArguments() {
            return new JavaScriptNode[] {this.arguments0_};
        }

        @Override
        public Object execute(VirtualFrame frameValue) {
            Object arguments0Value_ = this.arguments0_.execute(frameValue);
            return decodeURI(arguments0Value_);
        }

        @Override
        public void executeVoid(VirtualFrame frameValue) {
            execute(frameValue);
            return;
        }

        @Override
        public NodeCost getCost() {
            return NodeCost.MONOMORPHIC;
        }

        @Override
        public Introspection getIntrospectionData() {
            Object[] data = new Object[2];
            Object[] s;
            data[0] = 0;
            s = new Object[3];
            s[0] = "decodeURI";
            s[1] = (byte)0b01 /* active */;
            data[1] = s;
            return Provider.create(data);
        }

        public static JSGlobalDecodeURINode create(JSContext context, JSBuiltin builtin, boolean isSpecial, JavaScriptNode[] arguments) {
            return new JSGlobalDecodeURINodeGen(context, builtin, isSpecial, arguments);
        }

    }
    @GeneratedBy(JSGlobalIndirectEvalNode.class)
    public static final class JSGlobalIndirectEvalNodeGen extends JSGlobalIndirectEvalNode implements Provider {

        @Child private JavaScriptNode arguments0_;
        @CompilationFinal private int state_;
        @CompilationFinal private int exclude_;
        @Child private IndirectEvalForeignObject0Data indirectEvalForeignObject0_cache;

        private JSGlobalIndirectEvalNodeGen(JSContext context, JSBuiltin builtin, JavaScriptNode[] arguments) {
            super(context, builtin);
            this.arguments0_ = arguments != null && 0 < arguments.length ? arguments[0] : null;
        }

        @Override
        public JavaScriptNode[] getArguments() {
            return new JavaScriptNode[] {this.arguments0_};
        }

        @Override
        public Object execute(VirtualFrame frameValue) {
            int state = state_;
            if ((state & 0b11111110111) == 0 /* only-active indirectEvalInt(int) */ && (state & 0b11111111111) != 0  /* is-not indirectEvalString(String) && indirectEvalForeignObject(Object, InteropLibrary) && indirectEvalForeignObject(Object, InteropLibrary) && indirectEvalInt(int) && indirectEvalLargeInteger(LargeInteger) && indirectEvalLong(long) && indirectEvalDouble(double) && indirectEvalBoolean(boolean) && indirectEvalSymbol(Symbol) && indirectEvalBigInt(BigInt) && indirectEvalJSType(DynamicObject) */) {
                return execute_int0(frameValue, state);
            } else if ((state & 0b11111011111) == 0 /* only-active indirectEvalLong(long) */ && (state & 0b11111111111) != 0  /* is-not indirectEvalString(String) && indirectEvalForeignObject(Object, InteropLibrary) && indirectEvalForeignObject(Object, InteropLibrary) && indirectEvalInt(int) && indirectEvalLargeInteger(LargeInteger) && indirectEvalLong(long) && indirectEvalDouble(double) && indirectEvalBoolean(boolean) && indirectEvalSymbol(Symbol) && indirectEvalBigInt(BigInt) && indirectEvalJSType(DynamicObject) */) {
                return execute_long1(frameValue, state);
            } else if ((state & 0b11110111111) == 0 /* only-active indirectEvalDouble(double) */ && (state & 0b11111111111) != 0  /* is-not indirectEvalString(String) && indirectEvalForeignObject(Object, InteropLibrary) && indirectEvalForeignObject(Object, InteropLibrary) && indirectEvalInt(int) && indirectEvalLargeInteger(LargeInteger) && indirectEvalLong(long) && indirectEvalDouble(double) && indirectEvalBoolean(boolean) && indirectEvalSymbol(Symbol) && indirectEvalBigInt(BigInt) && indirectEvalJSType(DynamicObject) */) {
                return execute_double2(frameValue, state);
            } else if ((state & 0b11101111111) == 0 /* only-active indirectEvalBoolean(boolean) */ && (state & 0b11111111111) != 0  /* is-not indirectEvalString(String) && indirectEvalForeignObject(Object, InteropLibrary) && indirectEvalForeignObject(Object, InteropLibrary) && indirectEvalInt(int) && indirectEvalLargeInteger(LargeInteger) && indirectEvalLong(long) && indirectEvalDouble(double) && indirectEvalBoolean(boolean) && indirectEvalSymbol(Symbol) && indirectEvalBigInt(BigInt) && indirectEvalJSType(DynamicObject) */) {
                return execute_boolean3(frameValue, state);
            } else {
                return execute_generic4(frameValue, state);
            }
        }

        private Object execute_int0(VirtualFrame frameValue, int state) {
            int arguments0Value_;
            try {
                arguments0Value_ = this.arguments0_.executeInt(frameValue);
            } catch (UnexpectedResultException ex) {
                return executeAndSpecialize(ex.getResult());
            }
            assert (state & 0b1000) != 0 /* is-active indirectEvalInt(int) */;
            return indirectEvalInt(arguments0Value_);
        }

        private Object execute_long1(VirtualFrame frameValue, int state) {
            long arguments0Value_;
            try {
                arguments0Value_ = this.arguments0_.executeLong(frameValue);
            } catch (UnexpectedResultException ex) {
                return executeAndSpecialize(ex.getResult());
            }
            assert (state & 0b100000) != 0 /* is-active indirectEvalLong(long) */;
            return indirectEvalLong(arguments0Value_);
        }

        private Object execute_double2(VirtualFrame frameValue, int state) {
            int arguments0Value_int = 0;
            long arguments0Value_long = 0L;
            double arguments0Value_;
            try {
                if ((state & 0x70000) == 0 /* only-active 0:double */ && (state & 0b11111111111) != 0  /* is-not indirectEvalString(String) && indirectEvalForeignObject(Object, InteropLibrary) && indirectEvalForeignObject(Object, InteropLibrary) && indirectEvalInt(int) && indirectEvalLargeInteger(LargeInteger) && indirectEvalLong(long) && indirectEvalDouble(double) && indirectEvalBoolean(boolean) && indirectEvalSymbol(Symbol) && indirectEvalBigInt(BigInt) && indirectEvalJSType(DynamicObject) */) {
                    arguments0Value_long = this.arguments0_.executeLong(frameValue);
                    arguments0Value_ = JSTypes.longToDouble(arguments0Value_long);
                } else if ((state & 0x68000) == 0 /* only-active 0:double */ && (state & 0b11111111111) != 0  /* is-not indirectEvalString(String) && indirectEvalForeignObject(Object, InteropLibrary) && indirectEvalForeignObject(Object, InteropLibrary) && indirectEvalInt(int) && indirectEvalLargeInteger(LargeInteger) && indirectEvalLong(long) && indirectEvalDouble(double) && indirectEvalBoolean(boolean) && indirectEvalSymbol(Symbol) && indirectEvalBigInt(BigInt) && indirectEvalJSType(DynamicObject) */) {
                    arguments0Value_int = this.arguments0_.executeInt(frameValue);
                    arguments0Value_ = JSTypes.intToDouble(arguments0Value_int);
                } else if ((state & 0x58000) == 0 /* only-active 0:double */ && (state & 0b11111111111) != 0  /* is-not indirectEvalString(String) && indirectEvalForeignObject(Object, InteropLibrary) && indirectEvalForeignObject(Object, InteropLibrary) && indirectEvalInt(int) && indirectEvalLargeInteger(LargeInteger) && indirectEvalLong(long) && indirectEvalDouble(double) && indirectEvalBoolean(boolean) && indirectEvalSymbol(Symbol) && indirectEvalBigInt(BigInt) && indirectEvalJSType(DynamicObject) */) {
                    arguments0Value_ = this.arguments0_.executeDouble(frameValue);
                } else {
                    Object arguments0Value__ = this.arguments0_.execute(frameValue);
                    arguments0Value_ = JSTypesGen.expectImplicitDouble((state & 0x78000) >>> 15 /* extract-implicit-active 0:double */, arguments0Value__);
                }
            } catch (UnexpectedResultException ex) {
                return executeAndSpecialize(ex.getResult());
            }
            assert (state & 0b1000000) != 0 /* is-active indirectEvalDouble(double) */;
            return indirectEvalDouble(arguments0Value_);
        }

        private Object execute_boolean3(VirtualFrame frameValue, int state) {
            boolean arguments0Value_;
            try {
                arguments0Value_ = this.arguments0_.executeBoolean(frameValue);
            } catch (UnexpectedResultException ex) {
                return executeAndSpecialize(ex.getResult());
            }
            assert (state & 0b10000000) != 0 /* is-active indirectEvalBoolean(boolean) */;
            return indirectEvalBoolean(arguments0Value_);
        }

        @TruffleBoundary
        private Object indirectEvalForeignObject1Boundary(int state, Object arguments0Value_) {
            Node prev_ = NodeUtil.pushEncapsulatingNode(this);
            try {
                return indirectEvalForeignObject(arguments0Value_, (INTEROP_LIBRARY_.getUncached(arguments0Value_)));
            } finally {
                NodeUtil.popEncapsulatingNode(prev_);
            }
        }

        @ExplodeLoop
        private Object execute_generic4(VirtualFrame frameValue, int state) {
            Object arguments0Value_ = this.arguments0_.execute(frameValue);
            if ((state & 0b1) != 0 /* is-active indirectEvalString(String) */ && JSTypesGen.isImplicitString((state & 0b111100000000000) >>> 11 /* extract-implicit-active 0:String */, arguments0Value_)) {
                String arguments0Value__ = JSTypesGen.asImplicitString((state & 0b111100000000000) >>> 11 /* extract-implicit-active 0:String */, arguments0Value_);
                return indirectEvalString(arguments0Value__);
            }
            if ((state & 0b110) != 0 /* is-active indirectEvalForeignObject(Object, InteropLibrary) || indirectEvalForeignObject(Object, InteropLibrary) */) {
                if ((state & 0b10) != 0 /* is-active indirectEvalForeignObject(Object, InteropLibrary) */) {
                    IndirectEvalForeignObject0Data s2_ = this.indirectEvalForeignObject0_cache;
                    while (s2_ != null) {
                        if ((s2_.interop_.accepts(arguments0Value_)) && (JSGuards.isForeignObject(arguments0Value_))) {
                            return indirectEvalForeignObject(arguments0Value_, s2_.interop_);
                        }
                        s2_ = s2_.next_;
                    }
                }
                if ((state & 0b100) != 0 /* is-active indirectEvalForeignObject(Object, InteropLibrary) */) {
                    if ((JSGuards.isForeignObject(arguments0Value_))) {
                        return this.indirectEvalForeignObject1Boundary(state, arguments0Value_);
                    }
                }
            }
            if ((state & 0b1000) != 0 /* is-active indirectEvalInt(int) */ && arguments0Value_ instanceof Integer) {
                int arguments0Value__ = (int) arguments0Value_;
                return indirectEvalInt(arguments0Value__);
            }
            if ((state & 0b10000) != 0 /* is-active indirectEvalLargeInteger(LargeInteger) */ && arguments0Value_ instanceof LargeInteger) {
                LargeInteger arguments0Value__ = (LargeInteger) arguments0Value_;
                return indirectEvalLargeInteger(arguments0Value__);
            }
            if ((state & 0b100000) != 0 /* is-active indirectEvalLong(long) */ && arguments0Value_ instanceof Long) {
                long arguments0Value__ = (long) arguments0Value_;
                return indirectEvalLong(arguments0Value__);
            }
            if ((state & 0b1000000) != 0 /* is-active indirectEvalDouble(double) */ && JSTypesGen.isImplicitDouble((state & 0x78000) >>> 15 /* extract-implicit-active 0:double */, arguments0Value_)) {
                double arguments0Value__ = JSTypesGen.asImplicitDouble((state & 0x78000) >>> 15 /* extract-implicit-active 0:double */, arguments0Value_);
                return indirectEvalDouble(arguments0Value__);
            }
            if ((state & 0b10000000) != 0 /* is-active indirectEvalBoolean(boolean) */ && arguments0Value_ instanceof Boolean) {
                boolean arguments0Value__ = (boolean) arguments0Value_;
                return indirectEvalBoolean(arguments0Value__);
            }
            if ((state & 0b100000000) != 0 /* is-active indirectEvalSymbol(Symbol) */ && arguments0Value_ instanceof Symbol) {
                Symbol arguments0Value__ = (Symbol) arguments0Value_;
                return indirectEvalSymbol(arguments0Value__);
            }
            if ((state & 0b1000000000) != 0 /* is-active indirectEvalBigInt(BigInt) */ && arguments0Value_ instanceof BigInt) {
                BigInt arguments0Value__ = (BigInt) arguments0Value_;
                return indirectEvalBigInt(arguments0Value__);
            }
            if ((state & 0b10000000000) != 0 /* is-active indirectEvalJSType(DynamicObject) */ && JSTypes.isDynamicObject(arguments0Value_)) {
                DynamicObject arguments0Value__ = (DynamicObject) arguments0Value_;
                if ((JSGuards.isJSType(arguments0Value__))) {
                    return indirectEvalJSType(arguments0Value__);
                }
            }
            CompilerDirectives.transferToInterpreterAndInvalidate();
            return executeAndSpecialize(arguments0Value_);
        }

        @Override
        public boolean executeBoolean(VirtualFrame frameValue) throws UnexpectedResultException {
            int state = state_;
            if ((state & 0b111) != 0 /* is-active indirectEvalString(String) || indirectEvalForeignObject(Object, InteropLibrary) || indirectEvalForeignObject(Object, InteropLibrary) */) {
                return JSTypesGen.expectBoolean(execute(frameValue));
            }
            boolean arguments0Value_;
            try {
                arguments0Value_ = this.arguments0_.executeBoolean(frameValue);
            } catch (UnexpectedResultException ex) {
                return JSTypesGen.expectBoolean(executeAndSpecialize(ex.getResult()));
            }
            if ((state & 0b10000000) != 0 /* is-active indirectEvalBoolean(boolean) */) {
                return indirectEvalBoolean(arguments0Value_);
            }
            CompilerDirectives.transferToInterpreterAndInvalidate();
            return JSTypesGen.expectBoolean(executeAndSpecialize(arguments0Value_));
        }

        @Override
        public double executeDouble(VirtualFrame frameValue) throws UnexpectedResultException {
            int state = state_;
            if ((state & 0b111) != 0 /* is-active indirectEvalString(String) || indirectEvalForeignObject(Object, InteropLibrary) || indirectEvalForeignObject(Object, InteropLibrary) */) {
                return JSTypesGen.expectDouble(execute(frameValue));
            }
            int arguments0Value_int = 0;
            long arguments0Value_long = 0L;
            double arguments0Value_;
            try {
                if ((state & 0x70000) == 0 /* only-active 0:double */ && (state & 0b11111111111) != 0  /* is-not indirectEvalString(String) && indirectEvalForeignObject(Object, InteropLibrary) && indirectEvalForeignObject(Object, InteropLibrary) && indirectEvalInt(int) && indirectEvalLargeInteger(LargeInteger) && indirectEvalLong(long) && indirectEvalDouble(double) && indirectEvalBoolean(boolean) && indirectEvalSymbol(Symbol) && indirectEvalBigInt(BigInt) && indirectEvalJSType(DynamicObject) */) {
                    arguments0Value_long = this.arguments0_.executeLong(frameValue);
                    arguments0Value_ = JSTypes.longToDouble(arguments0Value_long);
                } else if ((state & 0x68000) == 0 /* only-active 0:double */ && (state & 0b11111111111) != 0  /* is-not indirectEvalString(String) && indirectEvalForeignObject(Object, InteropLibrary) && indirectEvalForeignObject(Object, InteropLibrary) && indirectEvalInt(int) && indirectEvalLargeInteger(LargeInteger) && indirectEvalLong(long) && indirectEvalDouble(double) && indirectEvalBoolean(boolean) && indirectEvalSymbol(Symbol) && indirectEvalBigInt(BigInt) && indirectEvalJSType(DynamicObject) */) {
                    arguments0Value_int = this.arguments0_.executeInt(frameValue);
                    arguments0Value_ = JSTypes.intToDouble(arguments0Value_int);
                } else if ((state & 0x58000) == 0 /* only-active 0:double */ && (state & 0b11111111111) != 0  /* is-not indirectEvalString(String) && indirectEvalForeignObject(Object, InteropLibrary) && indirectEvalForeignObject(Object, InteropLibrary) && indirectEvalInt(int) && indirectEvalLargeInteger(LargeInteger) && indirectEvalLong(long) && indirectEvalDouble(double) && indirectEvalBoolean(boolean) && indirectEvalSymbol(Symbol) && indirectEvalBigInt(BigInt) && indirectEvalJSType(DynamicObject) */) {
                    arguments0Value_ = this.arguments0_.executeDouble(frameValue);
                } else {
                    Object arguments0Value__ = this.arguments0_.execute(frameValue);
                    arguments0Value_ = JSTypesGen.expectImplicitDouble((state & 0x78000) >>> 15 /* extract-implicit-active 0:double */, arguments0Value__);
                }
            } catch (UnexpectedResultException ex) {
                return JSTypesGen.expectDouble(executeAndSpecialize(ex.getResult()));
            }
            if ((state & 0b1000000) != 0 /* is-active indirectEvalDouble(double) */) {
                return indirectEvalDouble(arguments0Value_);
            }
            CompilerDirectives.transferToInterpreterAndInvalidate();
            return JSTypesGen.expectDouble(executeAndSpecialize(((state & 0x70000) == 0 /* only-active 0:double */ && (state & 0b11111111111) != 0  /* is-not indirectEvalString(String) && indirectEvalForeignObject(Object, InteropLibrary) && indirectEvalForeignObject(Object, InteropLibrary) && indirectEvalInt(int) && indirectEvalLargeInteger(LargeInteger) && indirectEvalLong(long) && indirectEvalDouble(double) && indirectEvalBoolean(boolean) && indirectEvalSymbol(Symbol) && indirectEvalBigInt(BigInt) && indirectEvalJSType(DynamicObject) */ ? (Object) arguments0Value_long : ((state & 0x68000) == 0 /* only-active 0:double */ && (state & 0b11111111111) != 0  /* is-not indirectEvalString(String) && indirectEvalForeignObject(Object, InteropLibrary) && indirectEvalForeignObject(Object, InteropLibrary) && indirectEvalInt(int) && indirectEvalLargeInteger(LargeInteger) && indirectEvalLong(long) && indirectEvalDouble(double) && indirectEvalBoolean(boolean) && indirectEvalSymbol(Symbol) && indirectEvalBigInt(BigInt) && indirectEvalJSType(DynamicObject) */ ? (Object) arguments0Value_int : (Object) arguments0Value_))));
        }

        @Override
        public int executeInt(VirtualFrame frameValue) throws UnexpectedResultException {
            int state = state_;
            if ((state & 0b111) != 0 /* is-active indirectEvalString(String) || indirectEvalForeignObject(Object, InteropLibrary) || indirectEvalForeignObject(Object, InteropLibrary) */) {
                return JSTypesGen.expectInteger(execute(frameValue));
            }
            int arguments0Value_;
            try {
                arguments0Value_ = this.arguments0_.executeInt(frameValue);
            } catch (UnexpectedResultException ex) {
                return JSTypesGen.expectInteger(executeAndSpecialize(ex.getResult()));
            }
            if ((state & 0b1000) != 0 /* is-active indirectEvalInt(int) */) {
                return indirectEvalInt(arguments0Value_);
            }
            CompilerDirectives.transferToInterpreterAndInvalidate();
            return JSTypesGen.expectInteger(executeAndSpecialize(arguments0Value_));
        }

        @Override
        public long executeLong(VirtualFrame frameValue) throws UnexpectedResultException {
            int state = state_;
            if ((state & 0b111) != 0 /* is-active indirectEvalString(String) || indirectEvalForeignObject(Object, InteropLibrary) || indirectEvalForeignObject(Object, InteropLibrary) */) {
                return JSTypesGen.expectLong(execute(frameValue));
            }
            long arguments0Value_;
            try {
                arguments0Value_ = this.arguments0_.executeLong(frameValue);
            } catch (UnexpectedResultException ex) {
                return JSTypesGen.expectLong(executeAndSpecialize(ex.getResult()));
            }
            if ((state & 0b100000) != 0 /* is-active indirectEvalLong(long) */) {
                return indirectEvalLong(arguments0Value_);
            }
            CompilerDirectives.transferToInterpreterAndInvalidate();
            return JSTypesGen.expectLong(executeAndSpecialize(arguments0Value_));
        }

        @Override
        public void executeVoid(VirtualFrame frameValue) {
            int state = state_;
            try {
                if ((state & 0b11111011111) == 0 /* only-active indirectEvalLong(long) */ && (state & 0b11111111111) != 0  /* is-not indirectEvalString(String) && indirectEvalForeignObject(Object, InteropLibrary) && indirectEvalForeignObject(Object, InteropLibrary) && indirectEvalInt(int) && indirectEvalLargeInteger(LargeInteger) && indirectEvalLong(long) && indirectEvalDouble(double) && indirectEvalBoolean(boolean) && indirectEvalSymbol(Symbol) && indirectEvalBigInt(BigInt) && indirectEvalJSType(DynamicObject) */) {
                    executeLong(frameValue);
                    return;
                } else if ((state & 0b11111110111) == 0 /* only-active indirectEvalInt(int) */ && (state & 0b11111111111) != 0  /* is-not indirectEvalString(String) && indirectEvalForeignObject(Object, InteropLibrary) && indirectEvalForeignObject(Object, InteropLibrary) && indirectEvalInt(int) && indirectEvalLargeInteger(LargeInteger) && indirectEvalLong(long) && indirectEvalDouble(double) && indirectEvalBoolean(boolean) && indirectEvalSymbol(Symbol) && indirectEvalBigInt(BigInt) && indirectEvalJSType(DynamicObject) */) {
                    executeInt(frameValue);
                    return;
                } else if ((state & 0b11110111111) == 0 /* only-active indirectEvalDouble(double) */ && (state & 0b11111111111) != 0  /* is-not indirectEvalString(String) && indirectEvalForeignObject(Object, InteropLibrary) && indirectEvalForeignObject(Object, InteropLibrary) && indirectEvalInt(int) && indirectEvalLargeInteger(LargeInteger) && indirectEvalLong(long) && indirectEvalDouble(double) && indirectEvalBoolean(boolean) && indirectEvalSymbol(Symbol) && indirectEvalBigInt(BigInt) && indirectEvalJSType(DynamicObject) */) {
                    executeDouble(frameValue);
                    return;
                } else if ((state & 0b11101111111) == 0 /* only-active indirectEvalBoolean(boolean) */ && (state & 0b11111111111) != 0  /* is-not indirectEvalString(String) && indirectEvalForeignObject(Object, InteropLibrary) && indirectEvalForeignObject(Object, InteropLibrary) && indirectEvalInt(int) && indirectEvalLargeInteger(LargeInteger) && indirectEvalLong(long) && indirectEvalDouble(double) && indirectEvalBoolean(boolean) && indirectEvalSymbol(Symbol) && indirectEvalBigInt(BigInt) && indirectEvalJSType(DynamicObject) */) {
                    executeBoolean(frameValue);
                    return;
                }
                execute(frameValue);
                return;
            } catch (UnexpectedResultException ex) {
                return;
            }
        }

        private Object executeAndSpecialize(Object arguments0Value) {
            Lock lock = getLock();
            boolean hasLock = true;
            lock.lock();
            int state = state_;
            int exclude = exclude_;
            try {
                {
                    int stringCast0;
                    if ((stringCast0 = JSTypesGen.specializeImplicitString(arguments0Value)) != 0) {
                        String arguments0Value_ = JSTypesGen.asImplicitString(stringCast0, arguments0Value);
                        state = (state | (stringCast0 << 11) /* set-implicit-active 0:String */);
                        this.state_ = state = state | 0b1 /* add-active indirectEvalString(String) */;
                        lock.unlock();
                        hasLock = false;
                        return indirectEvalString(arguments0Value_);
                    }
                }
                if ((exclude) == 0 /* is-not-excluded indirectEvalForeignObject(Object, InteropLibrary) */) {
                    int count2_ = 0;
                    IndirectEvalForeignObject0Data s2_ = this.indirectEvalForeignObject0_cache;
                    if ((state & 0b10) != 0 /* is-active indirectEvalForeignObject(Object, InteropLibrary) */) {
                        while (s2_ != null) {
                            if ((s2_.interop_.accepts(arguments0Value)) && (JSGuards.isForeignObject(arguments0Value))) {
                                break;
                            }
                            s2_ = s2_.next_;
                            count2_++;
                        }
                    }
                    if (s2_ == null) {
                        if ((JSGuards.isForeignObject(arguments0Value)) && count2_ < (3)) {
                            // assert (s2_.interop_.accepts(arguments0Value));
                            s2_ = super.insert(new IndirectEvalForeignObject0Data(indirectEvalForeignObject0_cache));
                            s2_.interop_ = s2_.insertAccessor((INTEROP_LIBRARY_.create(arguments0Value)));
                            this.indirectEvalForeignObject0_cache = s2_;
                            this.state_ = state = state | 0b10 /* add-active indirectEvalForeignObject(Object, InteropLibrary) */;
                        }
                    }
                    if (s2_ != null) {
                        lock.unlock();
                        hasLock = false;
                        return indirectEvalForeignObject(arguments0Value, s2_.interop_);
                    }
                }
                {
                    Node prev_ = NodeUtil.pushEncapsulatingNode(this);
                    try {
                        if ((JSGuards.isForeignObject(arguments0Value))) {
                            this.exclude_ = exclude = exclude | 0b1 /* add-excluded indirectEvalForeignObject(Object, InteropLibrary) */;
                            this.indirectEvalForeignObject0_cache = null;
                            state = state & 0xfffffffd /* remove-active indirectEvalForeignObject(Object, InteropLibrary) */;
                            this.state_ = state = state | 0b100 /* add-active indirectEvalForeignObject(Object, InteropLibrary) */;
                            lock.unlock();
                            hasLock = false;
                            return indirectEvalForeignObject(arguments0Value, (INTEROP_LIBRARY_.getUncached(arguments0Value)));
                        }
                    } finally {
                        NodeUtil.popEncapsulatingNode(prev_);
                    }
                }
                if (arguments0Value instanceof Integer) {
                    int arguments0Value_ = (int) arguments0Value;
                    this.state_ = state = state | 0b1000 /* add-active indirectEvalInt(int) */;
                    lock.unlock();
                    hasLock = false;
                    return indirectEvalInt(arguments0Value_);
                }
                if (arguments0Value instanceof LargeInteger) {
                    LargeInteger arguments0Value_ = (LargeInteger) arguments0Value;
                    this.state_ = state = state | 0b10000 /* add-active indirectEvalLargeInteger(LargeInteger) */;
                    lock.unlock();
                    hasLock = false;
                    return indirectEvalLargeInteger(arguments0Value_);
                }
                if (arguments0Value instanceof Long) {
                    long arguments0Value_ = (long) arguments0Value;
                    this.state_ = state = state | 0b100000 /* add-active indirectEvalLong(long) */;
                    lock.unlock();
                    hasLock = false;
                    return indirectEvalLong(arguments0Value_);
                }
                {
                    int doubleCast0;
                    if ((doubleCast0 = JSTypesGen.specializeImplicitDouble(arguments0Value)) != 0) {
                        double arguments0Value_ = JSTypesGen.asImplicitDouble(doubleCast0, arguments0Value);
                        state = (state | (doubleCast0 << 15) /* set-implicit-active 0:double */);
                        this.state_ = state = state | 0b1000000 /* add-active indirectEvalDouble(double) */;
                        lock.unlock();
                        hasLock = false;
                        return indirectEvalDouble(arguments0Value_);
                    }
                }
                if (arguments0Value instanceof Boolean) {
                    boolean arguments0Value_ = (boolean) arguments0Value;
                    this.state_ = state = state | 0b10000000 /* add-active indirectEvalBoolean(boolean) */;
                    lock.unlock();
                    hasLock = false;
                    return indirectEvalBoolean(arguments0Value_);
                }
                if (arguments0Value instanceof Symbol) {
                    Symbol arguments0Value_ = (Symbol) arguments0Value;
                    this.state_ = state = state | 0b100000000 /* add-active indirectEvalSymbol(Symbol) */;
                    lock.unlock();
                    hasLock = false;
                    return indirectEvalSymbol(arguments0Value_);
                }
                if (arguments0Value instanceof BigInt) {
                    BigInt arguments0Value_ = (BigInt) arguments0Value;
                    this.state_ = state = state | 0b1000000000 /* add-active indirectEvalBigInt(BigInt) */;
                    lock.unlock();
                    hasLock = false;
                    return indirectEvalBigInt(arguments0Value_);
                }
                if (JSTypes.isDynamicObject(arguments0Value)) {
                    DynamicObject arguments0Value_ = (DynamicObject) arguments0Value;
                    if ((JSGuards.isJSType(arguments0Value_))) {
                        this.state_ = state = state | 0b10000000000 /* add-active indirectEvalJSType(DynamicObject) */;
                        lock.unlock();
                        hasLock = false;
                        return indirectEvalJSType(arguments0Value_);
                    }
                }
                throw new UnsupportedSpecializationException(this, new Node[] {this.arguments0_}, arguments0Value);
            } finally {
                if (hasLock) {
                    lock.unlock();
                }
            }
        }

        @Override
        public NodeCost getCost() {
            int state = state_;
            if ((state & 0b11111111111) == 0b0) {
                return NodeCost.UNINITIALIZED;
            } else if (((state & 0b11111111111) & ((state & 0b11111111111) - 1)) == 0 /* is-single-active  */) {
                IndirectEvalForeignObject0Data s2_ = this.indirectEvalForeignObject0_cache;
                if ((s2_ == null || s2_.next_ == null)) {
                    return NodeCost.MONOMORPHIC;
                }
            }
            return NodeCost.POLYMORPHIC;
        }

        @Override
        public Introspection getIntrospectionData() {
            Object[] data = new Object[12];
            Object[] s;
            data[0] = 0;
            int state = state_;
            int exclude = exclude_;
            s = new Object[3];
            s[0] = "indirectEvalString";
            if ((state & 0b1) != 0 /* is-active indirectEvalString(String) */) {
                s[1] = (byte)0b01 /* active */;
            } else {
                s[1] = (byte)0b00 /* inactive */;
            }
            data[1] = s;
            s = new Object[3];
            s[0] = "indirectEvalForeignObject";
            if ((state & 0b10) != 0 /* is-active indirectEvalForeignObject(Object, InteropLibrary) */) {
                s[1] = (byte)0b01 /* active */;
                ArrayList<Object> cached = new ArrayList<>();
                IndirectEvalForeignObject0Data s2_ = this.indirectEvalForeignObject0_cache;
                while (s2_ != null) {
                    cached.add(Arrays.asList(s2_.interop_));
                    s2_ = s2_.next_;
                }
                s[2] = cached;
            } else if (exclude != 0 /* is-excluded indirectEvalForeignObject(Object, InteropLibrary) */) {
                s[1] = (byte)0b10 /* excluded */;
            } else {
                s[1] = (byte)0b00 /* inactive */;
            }
            data[2] = s;
            s = new Object[3];
            s[0] = "indirectEvalForeignObject";
            if ((state & 0b100) != 0 /* is-active indirectEvalForeignObject(Object, InteropLibrary) */) {
                s[1] = (byte)0b01 /* active */;
                ArrayList<Object> cached = new ArrayList<>();
                cached.add(Arrays.asList(INTEROP_LIBRARY_.getUncached()));
                s[2] = cached;
            } else {
                s[1] = (byte)0b00 /* inactive */;
            }
            data[3] = s;
            s = new Object[3];
            s[0] = "indirectEvalInt";
            if ((state & 0b1000) != 0 /* is-active indirectEvalInt(int) */) {
                s[1] = (byte)0b01 /* active */;
            } else {
                s[1] = (byte)0b00 /* inactive */;
            }
            data[4] = s;
            s = new Object[3];
            s[0] = "indirectEvalLargeInteger";
            if ((state & 0b10000) != 0 /* is-active indirectEvalLargeInteger(LargeInteger) */) {
                s[1] = (byte)0b01 /* active */;
            } else {
                s[1] = (byte)0b00 /* inactive */;
            }
            data[5] = s;
            s = new Object[3];
            s[0] = "indirectEvalLong";
            if ((state & 0b100000) != 0 /* is-active indirectEvalLong(long) */) {
                s[1] = (byte)0b01 /* active */;
            } else {
                s[1] = (byte)0b00 /* inactive */;
            }
            data[6] = s;
            s = new Object[3];
            s[0] = "indirectEvalDouble";
            if ((state & 0b1000000) != 0 /* is-active indirectEvalDouble(double) */) {
                s[1] = (byte)0b01 /* active */;
            } else {
                s[1] = (byte)0b00 /* inactive */;
            }
            data[7] = s;
            s = new Object[3];
            s[0] = "indirectEvalBoolean";
            if ((state & 0b10000000) != 0 /* is-active indirectEvalBoolean(boolean) */) {
                s[1] = (byte)0b01 /* active */;
            } else {
                s[1] = (byte)0b00 /* inactive */;
            }
            data[8] = s;
            s = new Object[3];
            s[0] = "indirectEvalSymbol";
            if ((state & 0b100000000) != 0 /* is-active indirectEvalSymbol(Symbol) */) {
                s[1] = (byte)0b01 /* active */;
            } else {
                s[1] = (byte)0b00 /* inactive */;
            }
            data[9] = s;
            s = new Object[3];
            s[0] = "indirectEvalBigInt";
            if ((state & 0b1000000000) != 0 /* is-active indirectEvalBigInt(BigInt) */) {
                s[1] = (byte)0b01 /* active */;
            } else {
                s[1] = (byte)0b00 /* inactive */;
            }
            data[10] = s;
            s = new Object[3];
            s[0] = "indirectEvalJSType";
            if ((state & 0b10000000000) != 0 /* is-active indirectEvalJSType(DynamicObject) */) {
                s[1] = (byte)0b01 /* active */;
            } else {
                s[1] = (byte)0b00 /* inactive */;
            }
            data[11] = s;
            return Provider.create(data);
        }

        public static JSGlobalIndirectEvalNode create(JSContext context, JSBuiltin builtin, JavaScriptNode[] arguments) {
            return new JSGlobalIndirectEvalNodeGen(context, builtin, arguments);
        }

        @GeneratedBy(JSGlobalIndirectEvalNode.class)
        private static final class IndirectEvalForeignObject0Data extends Node {

            @Child IndirectEvalForeignObject0Data next_;
            @Child InteropLibrary interop_;

            IndirectEvalForeignObject0Data(IndirectEvalForeignObject0Data next_) {
                this.next_ = next_;
            }

            @Override
            public NodeCost getCost() {
                return NodeCost.NONE;
            }

            <T extends Node> T insertAccessor(T node) {
                return super.insert(node);
            }

        }
    }
    @GeneratedBy(JSGlobalUnEscapeNode.class)
    public static final class JSGlobalUnEscapeNodeGen extends JSGlobalUnEscapeNode implements Provider {

        @Child private JavaScriptNode arguments0_;

        private JSGlobalUnEscapeNodeGen(JSContext context, JSBuiltin builtin, boolean unescape, JavaScriptNode[] arguments) {
            super(context, builtin, unescape);
            this.arguments0_ = arguments != null && 0 < arguments.length ? arguments[0] : null;
        }

        @Override
        public JavaScriptNode[] getArguments() {
            return new JavaScriptNode[] {this.arguments0_};
        }

        @Override
        public Object execute(VirtualFrame frameValue) {
            Object arguments0Value_ = this.arguments0_.execute(frameValue);
            return escape(arguments0Value_);
        }

        @Override
        public void executeVoid(VirtualFrame frameValue) {
            execute(frameValue);
            return;
        }

        @Override
        public NodeCost getCost() {
            return NodeCost.MONOMORPHIC;
        }

        @Override
        public Introspection getIntrospectionData() {
            Object[] data = new Object[2];
            Object[] s;
            data[0] = 0;
            s = new Object[3];
            s[0] = "escape";
            s[1] = (byte)0b01 /* active */;
            data[1] = s;
            return Provider.create(data);
        }

        public static JSGlobalUnEscapeNode create(JSContext context, JSBuiltin builtin, boolean unescape, JavaScriptNode[] arguments) {
            return new JSGlobalUnEscapeNodeGen(context, builtin, unescape, arguments);
        }

    }
    @GeneratedBy(JSGlobalPrintNode.class)
    public static final class JSGlobalPrintNodeGen extends JSGlobalPrintNode implements Provider {

        @Child private JavaScriptNode arguments0_;
        @CompilationFinal private int state_;

        private JSGlobalPrintNodeGen(JSContext context, JSBuiltin builtin, boolean useErr, JavaScriptNode[] arguments) {
            super(context, builtin, useErr);
            this.arguments0_ = arguments != null && 0 < arguments.length ? arguments[0] : null;
        }

        @Override
        public JavaScriptNode[] getArguments() {
            return new JavaScriptNode[] {this.arguments0_};
        }

        @Override
        public Object executeObjectArray(Object[] arguments0Value) {
            int state = state_;
            if (state != 0 /* is-active print(Object[]) */) {
                return print(arguments0Value);
            }
            CompilerDirectives.transferToInterpreterAndInvalidate();
            return executeAndSpecialize(arguments0Value);
        }

        @Override
        public Object execute(VirtualFrame frameValue) {
            int state = state_;
            Object arguments0Value_ = this.arguments0_.execute(frameValue);
            if (state != 0 /* is-active print(Object[]) */ && arguments0Value_ instanceof Object[]) {
                Object[] arguments0Value__ = (Object[]) arguments0Value_;
                return print(arguments0Value__);
            }
            CompilerDirectives.transferToInterpreterAndInvalidate();
            return executeAndSpecialize(arguments0Value_);
        }

        @Override
        public void executeVoid(VirtualFrame frameValue) {
            execute(frameValue);
            return;
        }

        private Object executeAndSpecialize(Object arguments0Value) {
            int state = state_;
            if (arguments0Value instanceof Object[]) {
                Object[] arguments0Value_ = (Object[]) arguments0Value;
                this.state_ = state = state | 0b1 /* add-active print(Object[]) */;
                return print(arguments0Value_);
            }
            throw new UnsupportedSpecializationException(this, new Node[] {this.arguments0_}, arguments0Value);
        }

        @Override
        public NodeCost getCost() {
            int state = state_;
            if (state == 0b0) {
                return NodeCost.UNINITIALIZED;
            } else {
                return NodeCost.MONOMORPHIC;
            }
        }

        @Override
        public Introspection getIntrospectionData() {
            Object[] data = new Object[2];
            Object[] s;
            data[0] = 0;
            int state = state_;
            s = new Object[3];
            s[0] = "print";
            if (state != 0 /* is-active print(Object[]) */) {
                s[1] = (byte)0b01 /* active */;
            } else {
                s[1] = (byte)0b00 /* inactive */;
            }
            data[1] = s;
            return Provider.create(data);
        }

        public static JSGlobalPrintNode create(JSContext context, JSBuiltin builtin, boolean useErr, JavaScriptNode[] arguments) {
            return new JSGlobalPrintNodeGen(context, builtin, useErr, arguments);
        }

    }
    @GeneratedBy(JSGlobalLoadNode.class)
    public static final class JSGlobalLoadNodeGen extends JSGlobalLoadNode implements Provider {

        @Child private JavaScriptNode arguments0_;
        @Child private JavaScriptNode arguments1_;
        @CompilationFinal private int state_;
        @Child private InteropLibrary loadTruffleObject_interop_;
        @Child private JSToStringNode loadScriptObj_sourceToStringNode_;

        private JSGlobalLoadNodeGen(JSContext context, JSBuiltin builtin, JavaScriptNode[] arguments) {
            super(context, builtin);
            this.arguments0_ = arguments != null && 0 < arguments.length ? arguments[0] : null;
            this.arguments1_ = arguments != null && 1 < arguments.length ? arguments[1] : null;
        }

        @Override
        public JavaScriptNode[] getArguments() {
            return new JavaScriptNode[] {this.arguments0_, this.arguments1_};
        }

        @Override
        public Object execute(VirtualFrame frameValue) {
            int state = state_;
            Object arguments0Value_ = this.arguments0_.execute(frameValue);
            Object arguments1Value_ = this.arguments1_.execute(frameValue);
            if ((state & 0b1111) != 0 /* is-active loadString(String, Object[]) || loadTruffleObject(Object, Object[], InteropLibrary) || loadScriptObj(DynamicObject, Object[], JSToStringNode) || loadConvertToString(Object, Object[]) */ && arguments1Value_ instanceof Object[]) {
                Object[] arguments1Value__ = (Object[]) arguments1Value_;
                if ((state & 0b1) != 0 /* is-active loadString(String, Object[]) */ && JSTypesGen.isImplicitString((state & 0b11110000) >>> 4 /* extract-implicit-active 0:String */, arguments0Value_)) {
                    String arguments0Value__ = JSTypesGen.asImplicitString((state & 0b11110000) >>> 4 /* extract-implicit-active 0:String */, arguments0Value_);
                    return loadString(arguments0Value__, arguments1Value__);
                }
                if ((state & 0b10) != 0 /* is-active loadTruffleObject(Object, Object[], InteropLibrary) */) {
                    if ((JSGuards.isForeignObject(arguments0Value_))) {
                        return loadTruffleObject(arguments0Value_, arguments1Value__, this.loadTruffleObject_interop_);
                    }
                }
                if ((state & 0b100) != 0 /* is-active loadScriptObj(DynamicObject, Object[], JSToStringNode) */ && JSTypes.isDynamicObject(arguments0Value_)) {
                    DynamicObject arguments0Value__ = (DynamicObject) arguments0Value_;
                    if ((JSGuards.isJSObject(arguments0Value__))) {
                        return loadScriptObj(arguments0Value__, arguments1Value__, this.loadScriptObj_sourceToStringNode_);
                    }
                }
                if ((state & 0b1000) != 0 /* is-active loadConvertToString(Object, Object[]) */) {
                    if ((!(JSGuards.isString(arguments0Value_))) && (!(JSGuards.isForeignObject(arguments0Value_))) && (!(JSGuards.isJSObject(arguments0Value_)))) {
                        return loadConvertToString(arguments0Value_, arguments1Value__);
                    }
                }
            }
            CompilerDirectives.transferToInterpreterAndInvalidate();
            return executeAndSpecialize(arguments0Value_, arguments1Value_);
        }

        @Override
        public void executeVoid(VirtualFrame frameValue) {
            execute(frameValue);
            return;
        }

        private Object executeAndSpecialize(Object arguments0Value, Object arguments1Value) {
            Lock lock = getLock();
            boolean hasLock = true;
            lock.lock();
            int state = state_;
            try {
                if (arguments1Value instanceof Object[]) {
                    Object[] arguments1Value_ = (Object[]) arguments1Value;
                    {
                        int stringCast0;
                        if ((stringCast0 = JSTypesGen.specializeImplicitString(arguments0Value)) != 0) {
                            String arguments0Value_ = JSTypesGen.asImplicitString(stringCast0, arguments0Value);
                            state = (state | (stringCast0 << 4) /* set-implicit-active 0:String */);
                            this.state_ = state = state | 0b1 /* add-active loadString(String, Object[]) */;
                            lock.unlock();
                            hasLock = false;
                            return loadString(arguments0Value_, arguments1Value_);
                        }
                    }
                    if ((JSGuards.isForeignObject(arguments0Value))) {
                        this.loadTruffleObject_interop_ = super.insert((INTEROP_LIBRARY_.createDispatched(3)));
                        this.state_ = state = state | 0b10 /* add-active loadTruffleObject(Object, Object[], InteropLibrary) */;
                        lock.unlock();
                        hasLock = false;
                        return loadTruffleObject(arguments0Value, arguments1Value_, this.loadTruffleObject_interop_);
                    }
                    if (JSTypes.isDynamicObject(arguments0Value)) {
                        DynamicObject arguments0Value_ = (DynamicObject) arguments0Value;
                        if ((JSGuards.isJSObject(arguments0Value_))) {
                            this.loadScriptObj_sourceToStringNode_ = super.insert((JSToStringNode.create()));
                            this.state_ = state = state | 0b100 /* add-active loadScriptObj(DynamicObject, Object[], JSToStringNode) */;
                            lock.unlock();
                            hasLock = false;
                            return loadScriptObj(arguments0Value_, arguments1Value_, this.loadScriptObj_sourceToStringNode_);
                        }
                    }
                    if ((!(JSGuards.isString(arguments0Value))) && (!(JSGuards.isForeignObject(arguments0Value))) && (!(JSGuards.isJSObject(arguments0Value)))) {
                        this.state_ = state = state | 0b1000 /* add-active loadConvertToString(Object, Object[]) */;
                        lock.unlock();
                        hasLock = false;
                        return loadConvertToString(arguments0Value, arguments1Value_);
                    }
                }
                throw new UnsupportedSpecializationException(this, new Node[] {this.arguments0_, this.arguments1_}, arguments0Value, arguments1Value);
            } finally {
                if (hasLock) {
                    lock.unlock();
                }
            }
        }

        @Override
        public NodeCost getCost() {
            int state = state_;
            if ((state & 0b1111) == 0b0) {
                return NodeCost.UNINITIALIZED;
            } else if (((state & 0b1111) & ((state & 0b1111) - 1)) == 0 /* is-single-active  */) {
                return NodeCost.MONOMORPHIC;
            }
            return NodeCost.POLYMORPHIC;
        }

        @Override
        public Introspection getIntrospectionData() {
            Object[] data = new Object[5];
            Object[] s;
            data[0] = 0;
            int state = state_;
            s = new Object[3];
            s[0] = "loadString";
            if ((state & 0b1) != 0 /* is-active loadString(String, Object[]) */) {
                s[1] = (byte)0b01 /* active */;
            } else {
                s[1] = (byte)0b00 /* inactive */;
            }
            data[1] = s;
            s = new Object[3];
            s[0] = "loadTruffleObject";
            if ((state & 0b10) != 0 /* is-active loadTruffleObject(Object, Object[], InteropLibrary) */) {
                s[1] = (byte)0b01 /* active */;
                ArrayList<Object> cached = new ArrayList<>();
                cached.add(Arrays.asList(this.loadTruffleObject_interop_));
                s[2] = cached;
            } else {
                s[1] = (byte)0b00 /* inactive */;
            }
            data[2] = s;
            s = new Object[3];
            s[0] = "loadScriptObj";
            if ((state & 0b100) != 0 /* is-active loadScriptObj(DynamicObject, Object[], JSToStringNode) */) {
                s[1] = (byte)0b01 /* active */;
                ArrayList<Object> cached = new ArrayList<>();
                cached.add(Arrays.asList(this.loadScriptObj_sourceToStringNode_));
                s[2] = cached;
            } else {
                s[1] = (byte)0b00 /* inactive */;
            }
            data[3] = s;
            s = new Object[3];
            s[0] = "loadConvertToString";
            if ((state & 0b1000) != 0 /* is-active loadConvertToString(Object, Object[]) */) {
                s[1] = (byte)0b01 /* active */;
            } else {
                s[1] = (byte)0b00 /* inactive */;
            }
            data[4] = s;
            return Provider.create(data);
        }

        public static JSGlobalLoadNode create(JSContext context, JSBuiltin builtin, JavaScriptNode[] arguments) {
            return new JSGlobalLoadNodeGen(context, builtin, arguments);
        }

    }
    @GeneratedBy(JSGlobalLoadWithNewGlobalNode.class)
    public static final class JSGlobalLoadWithNewGlobalNodeGen extends JSGlobalLoadWithNewGlobalNode implements Provider {

        @Child private JavaScriptNode arguments0_;
        @Child private JavaScriptNode arguments1_;
        @CompilationFinal private int state_;
        @Child private InteropLibrary loadTruffleObject_interop_;
        @Child private JSToStringNode loadScriptObj_sourceToStringNode_;

        private JSGlobalLoadWithNewGlobalNodeGen(JSContext context, JSBuiltin builtin, JavaScriptNode[] arguments) {
            super(context, builtin);
            this.arguments0_ = arguments != null && 0 < arguments.length ? arguments[0] : null;
            this.arguments1_ = arguments != null && 1 < arguments.length ? arguments[1] : null;
        }

        @Override
        public JavaScriptNode[] getArguments() {
            return new JavaScriptNode[] {this.arguments0_, this.arguments1_};
        }

        @Override
        public Object execute(VirtualFrame frameValue) {
            int state = state_;
            Object arguments0Value_ = this.arguments0_.execute(frameValue);
            Object arguments1Value_ = this.arguments1_.execute(frameValue);
            if ((state & 0b1111) != 0 /* is-active loadString(String, Object[]) || loadTruffleObject(Object, Object[], InteropLibrary) || loadScriptObj(DynamicObject, Object[], JSToStringNode) || loadConvertToString(Object, Object[]) */ && arguments1Value_ instanceof Object[]) {
                Object[] arguments1Value__ = (Object[]) arguments1Value_;
                if ((state & 0b1) != 0 /* is-active loadString(String, Object[]) */ && JSTypesGen.isImplicitString((state & 0b11110000) >>> 4 /* extract-implicit-active 0:String */, arguments0Value_)) {
                    String arguments0Value__ = JSTypesGen.asImplicitString((state & 0b11110000) >>> 4 /* extract-implicit-active 0:String */, arguments0Value_);
                    return loadString(arguments0Value__, arguments1Value__);
                }
                if ((state & 0b10) != 0 /* is-active loadTruffleObject(Object, Object[], InteropLibrary) */) {
                    if ((JSGuards.isForeignObject(arguments0Value_))) {
                        return loadTruffleObject(arguments0Value_, arguments1Value__, this.loadTruffleObject_interop_);
                    }
                }
                if ((state & 0b100) != 0 /* is-active loadScriptObj(DynamicObject, Object[], JSToStringNode) */ && JSTypes.isDynamicObject(arguments0Value_)) {
                    DynamicObject arguments0Value__ = (DynamicObject) arguments0Value_;
                    if ((JSGuards.isJSObject(arguments0Value__))) {
                        return loadScriptObj(arguments0Value__, arguments1Value__, this.loadScriptObj_sourceToStringNode_);
                    }
                }
                if ((state & 0b1000) != 0 /* is-active loadConvertToString(Object, Object[]) */) {
                    if ((!(JSGuards.isString(arguments0Value_))) && (!(JSGuards.isForeignObject(arguments0Value_))) && (!(JSGuards.isJSObject(arguments0Value_)))) {
                        return loadConvertToString(arguments0Value_, arguments1Value__);
                    }
                }
            }
            CompilerDirectives.transferToInterpreterAndInvalidate();
            return executeAndSpecialize(arguments0Value_, arguments1Value_);
        }

        @Override
        public void executeVoid(VirtualFrame frameValue) {
            execute(frameValue);
            return;
        }

        private Object executeAndSpecialize(Object arguments0Value, Object arguments1Value) {
            Lock lock = getLock();
            boolean hasLock = true;
            lock.lock();
            int state = state_;
            try {
                if (arguments1Value instanceof Object[]) {
                    Object[] arguments1Value_ = (Object[]) arguments1Value;
                    {
                        int stringCast0;
                        if ((stringCast0 = JSTypesGen.specializeImplicitString(arguments0Value)) != 0) {
                            String arguments0Value_ = JSTypesGen.asImplicitString(stringCast0, arguments0Value);
                            state = (state | (stringCast0 << 4) /* set-implicit-active 0:String */);
                            this.state_ = state = state | 0b1 /* add-active loadString(String, Object[]) */;
                            lock.unlock();
                            hasLock = false;
                            return loadString(arguments0Value_, arguments1Value_);
                        }
                    }
                    if ((JSGuards.isForeignObject(arguments0Value))) {
                        this.loadTruffleObject_interop_ = super.insert((INTEROP_LIBRARY_.createDispatched(3)));
                        this.state_ = state = state | 0b10 /* add-active loadTruffleObject(Object, Object[], InteropLibrary) */;
                        lock.unlock();
                        hasLock = false;
                        return loadTruffleObject(arguments0Value, arguments1Value_, this.loadTruffleObject_interop_);
                    }
                    if (JSTypes.isDynamicObject(arguments0Value)) {
                        DynamicObject arguments0Value_ = (DynamicObject) arguments0Value;
                        if ((JSGuards.isJSObject(arguments0Value_))) {
                            this.loadScriptObj_sourceToStringNode_ = super.insert((JSToStringNode.create()));
                            this.state_ = state = state | 0b100 /* add-active loadScriptObj(DynamicObject, Object[], JSToStringNode) */;
                            lock.unlock();
                            hasLock = false;
                            return loadScriptObj(arguments0Value_, arguments1Value_, this.loadScriptObj_sourceToStringNode_);
                        }
                    }
                    if ((!(JSGuards.isString(arguments0Value))) && (!(JSGuards.isForeignObject(arguments0Value))) && (!(JSGuards.isJSObject(arguments0Value)))) {
                        this.state_ = state = state | 0b1000 /* add-active loadConvertToString(Object, Object[]) */;
                        lock.unlock();
                        hasLock = false;
                        return loadConvertToString(arguments0Value, arguments1Value_);
                    }
                }
                throw new UnsupportedSpecializationException(this, new Node[] {this.arguments0_, this.arguments1_}, arguments0Value, arguments1Value);
            } finally {
                if (hasLock) {
                    lock.unlock();
                }
            }
        }

        @Override
        public NodeCost getCost() {
            int state = state_;
            if ((state & 0b1111) == 0b0) {
                return NodeCost.UNINITIALIZED;
            } else if (((state & 0b1111) & ((state & 0b1111) - 1)) == 0 /* is-single-active  */) {
                return NodeCost.MONOMORPHIC;
            }
            return NodeCost.POLYMORPHIC;
        }

        @Override
        public Introspection getIntrospectionData() {
            Object[] data = new Object[5];
            Object[] s;
            data[0] = 0;
            int state = state_;
            s = new Object[3];
            s[0] = "loadString";
            if ((state & 0b1) != 0 /* is-active loadString(String, Object[]) */) {
                s[1] = (byte)0b01 /* active */;
            } else {
                s[1] = (byte)0b00 /* inactive */;
            }
            data[1] = s;
            s = new Object[3];
            s[0] = "loadTruffleObject";
            if ((state & 0b10) != 0 /* is-active loadTruffleObject(Object, Object[], InteropLibrary) */) {
                s[1] = (byte)0b01 /* active */;
                ArrayList<Object> cached = new ArrayList<>();
                cached.add(Arrays.asList(this.loadTruffleObject_interop_));
                s[2] = cached;
            } else {
                s[1] = (byte)0b00 /* inactive */;
            }
            data[2] = s;
            s = new Object[3];
            s[0] = "loadScriptObj";
            if ((state & 0b100) != 0 /* is-active loadScriptObj(DynamicObject, Object[], JSToStringNode) */) {
                s[1] = (byte)0b01 /* active */;
                ArrayList<Object> cached = new ArrayList<>();
                cached.add(Arrays.asList(this.loadScriptObj_sourceToStringNode_));
                s[2] = cached;
            } else {
                s[1] = (byte)0b00 /* inactive */;
            }
            data[3] = s;
            s = new Object[3];
            s[0] = "loadConvertToString";
            if ((state & 0b1000) != 0 /* is-active loadConvertToString(Object, Object[]) */) {
                s[1] = (byte)0b01 /* active */;
            } else {
                s[1] = (byte)0b00 /* inactive */;
            }
            data[4] = s;
            return Provider.create(data);
        }

        public static JSGlobalLoadWithNewGlobalNode create(JSContext context, JSBuiltin builtin, JavaScriptNode[] arguments) {
            return new JSGlobalLoadWithNewGlobalNodeGen(context, builtin, arguments);
        }

    }
    @GeneratedBy(JSGlobalExitNode.class)
    public static final class JSGlobalExitNodeGen extends JSGlobalExitNode implements Provider {

        @Child private JavaScriptNode arguments0_;
        @CompilationFinal private int state_;
        @Child private JSToNumberNode toNumberNode_;

        private JSGlobalExitNodeGen(JSContext context, JSBuiltin builtin, JavaScriptNode[] arguments) {
            super(context, builtin);
            this.arguments0_ = arguments != null && 0 < arguments.length ? arguments[0] : null;
        }

        @Override
        public JavaScriptNode[] getArguments() {
            return new JavaScriptNode[] {this.arguments0_};
        }

        @Override
        public Object execute(VirtualFrame frameValue) {
            int state = state_;
            Object arguments0Value_ = this.arguments0_.execute(frameValue);
            if (state != 0 /* is-active exit(Object[], JSToNumberNode) */ && arguments0Value_ instanceof Object[]) {
                Object[] arguments0Value__ = (Object[]) arguments0Value_;
                return exit(arguments0Value__, this.toNumberNode_);
            }
            CompilerDirectives.transferToInterpreterAndInvalidate();
            return executeAndSpecialize(arguments0Value_);
        }

        @Override
        public void executeVoid(VirtualFrame frameValue) {
            execute(frameValue);
            return;
        }

        private Object executeAndSpecialize(Object arguments0Value) {
            Lock lock = getLock();
            boolean hasLock = true;
            lock.lock();
            int state = state_;
            try {
                if (arguments0Value instanceof Object[]) {
                    Object[] arguments0Value_ = (Object[]) arguments0Value;
                    this.toNumberNode_ = super.insert((JSToNumberNode.create()));
                    this.state_ = state = state | 0b1 /* add-active exit(Object[], JSToNumberNode) */;
                    lock.unlock();
                    hasLock = false;
                    return exit(arguments0Value_, this.toNumberNode_);
                }
                throw new UnsupportedSpecializationException(this, new Node[] {this.arguments0_}, arguments0Value);
            } finally {
                if (hasLock) {
                    lock.unlock();
                }
            }
        }

        @Override
        public NodeCost getCost() {
            int state = state_;
            if (state == 0b0) {
                return NodeCost.UNINITIALIZED;
            } else {
                return NodeCost.MONOMORPHIC;
            }
        }

        @Override
        public Introspection getIntrospectionData() {
            Object[] data = new Object[2];
            Object[] s;
            data[0] = 0;
            int state = state_;
            s = new Object[3];
            s[0] = "exit";
            if (state != 0 /* is-active exit(Object[], JSToNumberNode) */) {
                s[1] = (byte)0b01 /* active */;
                ArrayList<Object> cached = new ArrayList<>();
                cached.add(Arrays.asList(this.toNumberNode_));
                s[2] = cached;
            } else {
                s[1] = (byte)0b00 /* inactive */;
            }
            data[1] = s;
            return Provider.create(data);
        }

        public static JSGlobalExitNode create(JSContext context, JSBuiltin builtin, JavaScriptNode[] arguments) {
            return new JSGlobalExitNodeGen(context, builtin, arguments);
        }

    }
    @GeneratedBy(JSGlobalReadLineNode.class)
    public static final class JSGlobalReadLineNodeGen extends JSGlobalReadLineNode implements Provider {

        @Child private JavaScriptNode arguments0_;

        private JSGlobalReadLineNodeGen(JSContext context, JSBuiltin builtin, JavaScriptNode[] arguments) {
            super(context, builtin);
            this.arguments0_ = arguments != null && 0 < arguments.length ? arguments[0] : null;
        }

        @Override
        public JavaScriptNode[] getArguments() {
            return new JavaScriptNode[] {this.arguments0_};
        }

        @Override
        public Object execute(VirtualFrame frameValue) {
            Object arguments0Value_ = this.arguments0_.execute(frameValue);
            return readLine(arguments0Value_);
        }

        @Override
        public void executeVoid(VirtualFrame frameValue) {
            execute(frameValue);
            return;
        }

        @Override
        public NodeCost getCost() {
            return NodeCost.MONOMORPHIC;
        }

        @Override
        public Introspection getIntrospectionData() {
            Object[] data = new Object[2];
            Object[] s;
            data[0] = 0;
            s = new Object[3];
            s[0] = "readLine";
            s[1] = (byte)0b01 /* active */;
            data[1] = s;
            return Provider.create(data);
        }

        public static JSGlobalReadLineNode create(JSContext context, JSBuiltin builtin, JavaScriptNode[] arguments) {
            return new JSGlobalReadLineNodeGen(context, builtin, arguments);
        }

    }
    @GeneratedBy(JSGlobalReadFullyNode.class)
    public static final class JSGlobalReadFullyNodeGen extends JSGlobalReadFullyNode implements Provider {

        @Child private JavaScriptNode arguments0_;

        private JSGlobalReadFullyNodeGen(JSContext context, JSBuiltin builtin, JavaScriptNode[] arguments) {
            super(context, builtin);
            this.arguments0_ = arguments != null && 0 < arguments.length ? arguments[0] : null;
        }

        @Override
        public JavaScriptNode[] getArguments() {
            return new JavaScriptNode[] {this.arguments0_};
        }

        @Override
        public Object execute(VirtualFrame frameValue) {
            Object arguments0Value_ = this.arguments0_.execute(frameValue);
            return read(arguments0Value_);
        }

        @Override
        public void executeVoid(VirtualFrame frameValue) {
            execute(frameValue);
            return;
        }

        @Override
        public NodeCost getCost() {
            return NodeCost.MONOMORPHIC;
        }

        @Override
        public Introspection getIntrospectionData() {
            Object[] data = new Object[2];
            Object[] s;
            data[0] = 0;
            s = new Object[3];
            s[0] = "read";
            s[1] = (byte)0b01 /* active */;
            data[1] = s;
            return Provider.create(data);
        }

        public static JSGlobalReadFullyNode create(JSContext context, JSBuiltin builtin, JavaScriptNode[] arguments) {
            return new JSGlobalReadFullyNodeGen(context, builtin, arguments);
        }

    }
    @GeneratedBy(JSGlobalReadBufferNode.class)
    public static final class JSGlobalReadBufferNodeGen extends JSGlobalReadBufferNode implements Provider {

        @Child private JavaScriptNode arguments0_;

        private JSGlobalReadBufferNodeGen(JSContext context, JSBuiltin builtin, JavaScriptNode[] arguments) {
            super(context, builtin);
            this.arguments0_ = arguments != null && 0 < arguments.length ? arguments[0] : null;
        }

        @Override
        public JavaScriptNode[] getArguments() {
            return new JavaScriptNode[] {this.arguments0_};
        }

        @Override
        public Object execute(VirtualFrame frameValue) {
            Object arguments0Value_ = this.arguments0_.execute(frameValue);
            return readbuffer(arguments0Value_);
        }

        @Override
        public void executeVoid(VirtualFrame frameValue) {
            execute(frameValue);
            return;
        }

        @Override
        public NodeCost getCost() {
            return NodeCost.MONOMORPHIC;
        }

        @Override
        public Introspection getIntrospectionData() {
            Object[] data = new Object[2];
            Object[] s;
            data[0] = 0;
            s = new Object[3];
            s[0] = "readbuffer";
            s[1] = (byte)0b01 /* active */;
            data[1] = s;
            return Provider.create(data);
        }

        public static JSGlobalReadBufferNode create(JSContext context, JSBuiltin builtin, JavaScriptNode[] arguments) {
            return new JSGlobalReadBufferNodeGen(context, builtin, arguments);
        }

    }
    @GeneratedBy(JSGlobalImportScriptEngineGlobalBindingsNode.class)
    static final class JSGlobalImportScriptEngineGlobalBindingsNodeGen extends JSGlobalImportScriptEngineGlobalBindingsNode implements Provider {

        @Child private JavaScriptNode arguments0_;

        private JSGlobalImportScriptEngineGlobalBindingsNodeGen(JSContext context, JSBuiltin builtin, JavaScriptNode[] arguments) {
            super(context, builtin);
            this.arguments0_ = arguments != null && 0 < arguments.length ? arguments[0] : null;
        }

        @Override
        public JavaScriptNode[] getArguments() {
            return new JavaScriptNode[] {this.arguments0_};
        }

        @Override
        public Object execute(VirtualFrame frameValue) {
            Object arguments0Value_ = this.arguments0_.execute(frameValue);
            return importGlobalContext(arguments0Value_);
        }

        @Override
        public void executeVoid(VirtualFrame frameValue) {
            execute(frameValue);
            return;
        }

        @Override
        public NodeCost getCost() {
            return NodeCost.MONOMORPHIC;
        }

        @Override
        public Introspection getIntrospectionData() {
            Object[] data = new Object[2];
            Object[] s;
            data[0] = 0;
            s = new Object[3];
            s[0] = "importGlobalContext";
            s[1] = (byte)0b01 /* active */;
            data[1] = s;
            return Provider.create(data);
        }

        public static JSGlobalImportScriptEngineGlobalBindingsNode create(JSContext context, JSBuiltin builtin, JavaScriptNode[] arguments) {
            return new JSGlobalImportScriptEngineGlobalBindingsNodeGen(context, builtin, arguments);
        }

    }
    @GeneratedBy(GlobalSyntaxCheckForScriptEngineNode.class)
    public static final class GlobalSyntaxCheckForScriptEngineNodeGen extends GlobalSyntaxCheckForScriptEngineNode implements Provider {

        @Child private JavaScriptNode arguments0_;

        private GlobalSyntaxCheckForScriptEngineNodeGen(JSContext context, JSBuiltin builtin, JavaScriptNode[] arguments) {
            super(context, builtin);
            this.arguments0_ = arguments != null && 0 < arguments.length ? arguments[0] : null;
        }

        @Override
        public JavaScriptNode[] getArguments() {
            return new JavaScriptNode[] {this.arguments0_};
        }

        @Override
        public Object execute(VirtualFrame frameValue) {
            Object arguments0Value_ = this.arguments0_.execute(frameValue);
            return checkSyntax(arguments0Value_);
        }

        @Override
        public boolean executeBoolean(VirtualFrame frameValue) {
            Object arguments0Value_ = this.arguments0_.execute(frameValue);
            return checkSyntax(arguments0Value_);
        }

        @Override
        public void executeVoid(VirtualFrame frameValue) {
            executeBoolean(frameValue);
            return;
        }

        @Override
        public NodeCost getCost() {
            return NodeCost.MONOMORPHIC;
        }

        @Override
        public Introspection getIntrospectionData() {
            Object[] data = new Object[2];
            Object[] s;
            data[0] = 0;
            s = new Object[3];
            s[0] = "checkSyntax";
            s[1] = (byte)0b01 /* active */;
            data[1] = s;
            return Provider.create(data);
        }

        public static GlobalSyntaxCheckForScriptEngineNode create(JSContext context, JSBuiltin builtin, JavaScriptNode[] arguments) {
            return new GlobalSyntaxCheckForScriptEngineNodeGen(context, builtin, arguments);
        }

    }
}
