/*
 * Decompiled with CFR 0.152.
 */
package org.flywaydb.core.internal.util;

import com.google.gson.Gson;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.HashMap;
import org.flywaydb.core.api.configuration.Configuration;
import org.flywaydb.core.internal.database.DatabaseTypeRegister;

public class FingerprintUtils {
    public static String getFingerprint(Configuration config) throws Exception {
        HashMap<String, String> filteredConfig = new HashMap<String, String>();
        if (config.getLicenseKey() != null) {
            filteredConfig.put("flyway.licenseKey", config.getLicenseKey());
        } else {
            filteredConfig.put("flyway.url", DatabaseTypeRegister.redactJdbcUrl(config.getUrl()));
            filteredConfig.put("flyway.user", config.getUser());
        }
        return FingerprintUtils.SHA512String(new Gson().toJson(filteredConfig));
    }

    private static String SHA512String(String input) throws NoSuchAlgorithmException {
        MessageDigest md = MessageDigest.getInstance("SHA-512");
        byte[] data = md.digest(input.getBytes());
        StringBuilder sb = new StringBuilder();
        for (byte b : data) {
            sb.append(Integer.toString((b & 0xFF) + 256, 16).substring(1));
        }
        return sb.toString();
    }

    private FingerprintUtils() {
    }
}

