/*
 * Decompiled with CFR 0.152.
 */
package org.flywaydb.core.extensibility;

import java.nio.charset.StandardCharsets;
import java.security.GeneralSecurityException;
import java.security.Key;
import java.security.KeyFactory;
import java.security.PublicKey;
import java.security.spec.X509EncodedKeySpec;
import java.time.temporal.ChronoUnit;
import java.util.Arrays;
import java.util.Date;
import javax.crypto.Cipher;
import org.flywaydb.core.api.FlywayException;
import org.flywaydb.core.api.logging.Log;
import org.flywaydb.core.api.logging.LogFactory;
import org.flywaydb.core.extensibility.FlywayInvalidLicenseKeyException;
import org.flywaydb.core.extensibility.FlywayMissingLicenseKeyException;
import org.flywaydb.core.extensibility.FlywayRedgateLicenseKeyException;
import org.flywaydb.core.extensibility.LicenseType;
import org.flywaydb.core.internal.license.Edition;
import org.flywaydb.core.internal.license.VersionPrinter;
import org.flywaydb.core.internal.util.DateUtils;
import org.flywaydb.core.internal.util.StringUtils;

public class LicenseInfo {
    private static final Log LOG = LogFactory.getLog(LicenseInfo.class);
    private final LicenseType licenseType;
    private final String licensedTo;
    private final Date validUntil;
    private final boolean trial;
    private boolean expired = false;
    private static final String DECRYPTION_KEY = "30820122300d06092a864886f70d01010105000382010f003082010a02820101009fbebb4eb38e68c758ff04f2ca68f6c37660eb5b821aabbfac7c221c54debec144edacc9f95005f8070f0ee20fc54c8e913ae859e2a96864ebe7d153a092e12379cfae26ba615f778db674452d0466c4259faadce1772b3e4b71f4a63c8c6856e093e9e279c9f0834b986606e223c691cfddba18e5cfc54d0f50f1c44eeafefaad2e805edd67946d69902a0fe1d119e7814a5add199ba95ffa9e2318240040219a96ba1f3a55a96359d2c590b3050f77f5b9950d04f3e77aa891578e0800fb16e4d122bcdd3f422cb846f982a5177b803d3fbfd45b4c61d6182ca429b85c77bed678fd345bcbae01c51aef2ecf0bd1c3f85aeebe60380933501cf0b98eca97670203010001";

    private LicenseInfo(LicenseType licenseType, Date validUntil, String licensedTo, boolean trial) {
        this.licenseType = licenseType;
        this.validUntil = validUntil;
        this.licensedTo = licensedTo;
        this.trial = trial;
    }

    public static LicenseInfo create(String licenseKey) {
        LicenseInfo.validateLicenseKey(licenseKey);
        LicenseInfo licenseInfo = LicenseInfo.extractLicenseInfo(licenseKey);
        LicenseType licenseType = licenseInfo.getLicenseType();
        if (licenseInfo.getValidUntil().before(new Date())) {
            licenseInfo.expired = true;
        }
        VersionPrinter.EDITION = licenseType.getEdition();
        return licenseInfo;
    }

    public static LicenseInfo extractLicenseInfo(String licenseKey) {
        byte[] decrypted = LicenseInfo.rsaDecrypt(LicenseInfo.fromHex(licenseKey.substring(4)), LicenseInfo.rsaPublicKey(LicenseInfo.fromHex(DECRYPTION_KEY)));
        int year = 2000 + decrypted[1];
        byte month = decrypted[2];
        byte day = decrypted[3];
        LicenseType licenseType = LicenseType.fromCode(decrypted[0]);
        Date validUntil = DateUtils.toDate(year, month, day);
        String licensedTo = new String(Arrays.copyOfRange(decrypted, 4, decrypted.length), StandardCharsets.UTF_8);
        return new LicenseInfo(licenseType, validUntil, licensedTo, LicenseInfo.hasTrialBit(licenseType.getCode()) || licenseType.getCode() == 0);
    }

    private static boolean hasTrialBit(byte input) {
        return (input & 0xFF) >> 7 == 1;
    }

    public void print() {
        LOG.info("Licensed to " + this.getLicensedTo() + " until " + DateUtils.toDateString(this.getValidUntil()));
        if (Edition.PRO.equals((Object)this.licenseType.getEdition())) {
            LOG.info("Your Flyway license is upgraded to Flyway Teams.");
        }
        if (this.isTrial()) {
            LOG.warn("You are using a limited Flyway trial license, valid until " + this.getValidUntil() + ".  In " + this.getRemainingDaysString() + " you must either upgrade to a full " + (Object)((Object)VersionPrinter.EDITION) + " license or downgrade to " + (Object)((Object)Edition.COMMUNITY) + ".");
        }
        LOG.info("");
    }

    private static void validateLicenseKey(String licenseKey) {
        if (!StringUtils.hasLength(licenseKey)) {
            throw new FlywayMissingLicenseKeyException();
        }
        if (licenseKey.matches("[0-9]{3}-[0-9]{3}-[0-9]{6}-[A-Z0-9]{4}")) {
            throw new FlywayRedgateLicenseKeyException();
        }
        if (!licenseKey.matches("FL01[A-F0-9]{512}")) {
            throw new FlywayInvalidLicenseKeyException();
        }
    }

    public long getRemainingDays() {
        return ChronoUnit.DAYS.between(new Date().toInstant(), this.validUntil.toInstant());
    }

    public String getRemainingDaysString() {
        long daysRemaining = this.getRemainingDays();
        return daysRemaining + (daysRemaining == 1L ? " day" : " days");
    }

    private static PublicKey rsaPublicKey(byte[] publicKey) {
        try {
            return KeyFactory.getInstance("RSA").generatePublic(new X509EncodedKeySpec(publicKey));
        }
        catch (GeneralSecurityException e) {
            throw new FlywayException("Unable to load the license decryption key", e);
        }
    }

    private static byte[] rsaDecrypt(byte[] encrypted, Key key) {
        try {
            Cipher rsa = Cipher.getInstance("RSA/ECB/Pkcs1Padding");
            rsa.init(2, key);
            return rsa.doFinal(encrypted);
        }
        catch (GeneralSecurityException e) {
            throw new FlywayInvalidLicenseKeyException("Unable to decrypt license", e);
        }
    }

    public static byte[] fromHex(String hex) {
        byte[] binary = new byte[hex.length() / 2];
        for (int i = 0; i < binary.length; ++i) {
            binary[i] = (byte)Integer.parseInt(hex.substring(2 * i, 2 * i + 2), 16);
        }
        return binary;
    }

    public LicenseType getLicenseType() {
        return this.licenseType;
    }

    public String getLicensedTo() {
        return this.licensedTo;
    }

    public Date getValidUntil() {
        return this.validUntil;
    }

    public boolean isTrial() {
        return this.trial;
    }

    public boolean isExpired() {
        return this.expired;
    }
}

