/*
 * Decompiled with CFR 0.152.
 */
package org.firebirdsql.jdbc.metadata;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import org.firebirdsql.gds.ng.fields.RowDescriptor;
import org.firebirdsql.gds.ng.fields.RowValue;
import org.firebirdsql.jdbc.DbMetadataMediator;
import org.firebirdsql.jdbc.metadata.AbstractMetadataMethod;
import org.firebirdsql.jdbc.metadata.Clause;
import org.firebirdsql.jdbc.metadata.NameHelper;
import org.firebirdsql.jdbc.metadata.RowValueBuilder;
import org.firebirdsql.jdbc.metadata.TypeMetadata;
import org.firebirdsql.util.FirebirdSupportInfo;

public abstract class GetFunctionColumns
extends AbstractMetadataMethod {
    private static final String FUNCTION_COLUMNS = "FUNCTION_COLUMNS";
    private static final RowDescriptor ROW_DESCRIPTOR = DbMetadataMediator.newRowDescriptorBuilder(17).at(0).simple(449, 63, "FUNCTION_CAT", "FUNCTION_COLUMNS").addField().at(1).simple(449, 63, "FUNCTION_SCHEM", "FUNCTION_COLUMNS").addField().at(2).simple(448, 63, "FUNCTION_NAME", "FUNCTION_COLUMNS").addField().at(3).simple(448, 63, "COLUMN_NAME", "FUNCTION_COLUMNS").addField().at(4).simple(500, 0, "COLUMN_TYPE", "FUNCTION_COLUMNS").addField().at(5).simple(496, 0, "DATA_TYPE", "FUNCTION_COLUMNS").addField().at(6).simple(448, 63, "TYPE_NAME", "FUNCTION_COLUMNS").addField().at(7).simple(497, 0, "PRECISION", "FUNCTION_COLUMNS").addField().at(8).simple(496, 0, "LENGTH", "FUNCTION_COLUMNS").addField().at(9).simple(501, 0, "SCALE", "FUNCTION_COLUMNS").addField().at(10).simple(500, 0, "RADIX", "FUNCTION_COLUMNS").addField().at(11).simple(500, 0, "NULLABLE", "FUNCTION_COLUMNS").addField().at(12).simple(449, Integer.MAX_VALUE, "REMARKS", "FUNCTION_COLUMNS").addField().at(13).simple(497, 0, "CHAR_OCTET_LENGTH", "FUNCTION_COLUMNS").addField().at(14).simple(496, 0, "ORDINAL_POSITION", "FUNCTION_COLUMNS").addField().at(15).simple(448, 3, "IS_NULLABLE", "FUNCTION_COLUMNS").addField().at(16).simple(448, 131, "SPECIFIC_NAME", "FUNCTION_COLUMNS").addField().toRowDescriptor();

    private GetFunctionColumns(DbMetadataMediator mediator) {
        super(ROW_DESCRIPTOR, mediator);
    }

    public final ResultSet getFunctionColumns(String catalog, String functionNamePattern, String columnNamePattern) throws SQLException {
        if ("".equals(functionNamePattern) || "".equals(columnNamePattern)) {
            return this.createEmpty();
        }
        DbMetadataMediator.MetadataQuery metadataQuery = this.createGetFunctionColumnsQuery(catalog, functionNamePattern, columnNamePattern);
        return this.createMetaDataResultSet(metadataQuery);
    }

    @Override
    final RowValue createMetadataRow(ResultSet rs, RowValueBuilder valueBuilder) throws SQLException {
        TypeMetadata typeMetadata = TypeMetadata.builder(this.mediator.getFirebirdSupportInfo()).fromCurrentRow(rs).build();
        String catalog = rs.getString("FUNCTION_CAT");
        String functionName = rs.getString("FUNCTION_NAME");
        int ordinalPosition = rs.getInt("ORDINAL_POSITION");
        boolean nullable = rs.getBoolean("IS_NULLABLE");
        return valueBuilder.at(0).setString(catalog).at(1).set(null).at(2).setString(functionName).at(3).setString(rs.getString("COLUMN_NAME")).at(4).setShort(ordinalPosition == 0 ? 4 : 1).at(5).setInt(typeMetadata.getJdbcType()).at(6).setString(typeMetadata.getSqlTypeName()).at(7).setInt(typeMetadata.getColumnSize()).at(8).setInt(typeMetadata.getLength()).at(9).setShort(typeMetadata.getScale()).at(10).setShort(typeMetadata.getRadix()).at(11).setShort(nullable ? 1 : 0).at(12).set(null).at(13).setInt(typeMetadata.getCharOctetLength()).at(14).setInt(ordinalPosition).at(15).setString(nullable ? "YES" : "NO").at(16).setString(NameHelper.toSpecificName(catalog, functionName)).toRowValue(false);
    }

    abstract DbMetadataMediator.MetadataQuery createGetFunctionColumnsQuery(String var1, String var2, String var3);

    public static GetFunctionColumns create(DbMetadataMediator mediator) {
        FirebirdSupportInfo firebirdSupportInfo = mediator.getFirebirdSupportInfo();
        if (firebirdSupportInfo.isVersionEqualOrAbove(3)) {
            if (mediator.isUseCatalogAsPackage()) {
                return FB3CatalogAsPackage.createInstance(mediator);
            }
            return FB3.createInstance(mediator);
        }
        return FB2_5.createInstance(mediator);
    }

    private static final class FB3CatalogAsPackage
    extends GetFunctionColumns {
        private static final String GET_FUNCTION_COLUMNS_FRAGMENT_3_W_PKG = "select\n  coalesce(trim(trailing from FUN.RDB$PACKAGE_NAME), '') as FUNCTION_CAT,\n  trim(trailing from FUN.RDB$FUNCTION_NAME) as FUNCTION_NAME,\n  -- legacy UDF and return value have no parameter name: derive one\n  coalesce(FUNA.RDB$ARGUMENT_NAME, 'PARAM_' || FUNA.RDB$ARGUMENT_POSITION) as COLUMN_NAME,\n  coalesce(FUNA.RDB$FIELD_TYPE, F.RDB$FIELD_TYPE) as FIELD_TYPE,\n  coalesce(FUNA.RDB$FIELD_SUB_TYPE, F.RDB$FIELD_SUB_TYPE) as FIELD_SUB_TYPE,\n  coalesce(FUNA.RDB$FIELD_PRECISION, F.RDB$FIELD_PRECISION) as FIELD_PRECISION,\n  coalesce(FUNA.RDB$FIELD_SCALE, F.RDB$FIELD_SCALE) as FIELD_SCALE,\n  coalesce(FUNA.RDB$FIELD_LENGTH, F.RDB$FIELD_LENGTH) as FIELD_LENGTH,\n  coalesce(FUNA.RDB$CHARACTER_LENGTH, F.RDB$CHARACTER_LENGTH) as CHAR_LEN,\n  coalesce(FUNA.RDB$CHARACTER_SET_ID, F.RDB$CHARACTER_SET_ID) as CHARSET_ID,\n  case\n    when FUN.RDB$RETURN_ARGUMENT = FUNA.RDB$ARGUMENT_POSITION then 0\n    else FUNA.RDB$ARGUMENT_POSITION\n  end as ORDINAL_POSITION,\n  case \n    when coalesce(FUNA.RDB$NULL_FLAG, F.RDB$NULL_FLAG) = 1 then false\n    when FUNA.RDB$MECHANISM = 0 then false\n    when FUNA.RDB$MECHANISM = 1 then false\n    else true\n  end as IS_NULLABLE\nfrom RDB$FUNCTIONS FUN\ninner join RDB$FUNCTION_ARGUMENTS FUNA\n  on FUNA.RDB$FUNCTION_NAME = FUN.RDB$FUNCTION_NAME \n    and FUNA.RDB$PACKAGE_NAME is not distinct from FUN.RDB$PACKAGE_NAME\nleft join RDB$FIELDS F\n  on F.RDB$FIELD_NAME = FUNA.RDB$FIELD_SOURCE";
        private static final String GET_FUNCTION_COLUMNS_ORDER_BY_3_W_PKG = "\norder by FUN.RDB$PACKAGE_NAME nulls first, FUN.RDB$FUNCTION_NAME,\n  case\n    when FUN.RDB$RETURN_ARGUMENT = FUNA.RDB$ARGUMENT_POSITION then -1\n    else FUNA.RDB$ARGUMENT_POSITION\n  end";

        private FB3CatalogAsPackage(DbMetadataMediator mediator) {
            super(mediator);
        }

        private static GetFunctionColumns createInstance(DbMetadataMediator mediator) {
            return new FB3CatalogAsPackage(mediator);
        }

        @Override
        DbMetadataMediator.MetadataQuery createGetFunctionColumnsQuery(String catalog, String functionNamePattern, String columnNamePattern) {
            ArrayList<Clause> clauses = new ArrayList<Clause>(3);
            if (catalog != null) {
                if (catalog.isEmpty()) {
                    clauses.add(Clause.isNullClause("FUN.RDB$PACKAGE_NAME"));
                } else {
                    clauses.add(Clause.equalsClause("FUN.RDB$PACKAGE_NAME", catalog));
                }
            }
            clauses.add(new Clause("FUN.RDB$FUNCTION_NAME", functionNamePattern));
            clauses.add(new Clause("coalesce(FUNA.RDB$ARGUMENT_NAME, 'PARAM_' || FUNA.RDB$ARGUMENT_POSITION)", columnNamePattern));
            String sql = GET_FUNCTION_COLUMNS_FRAGMENT_3_W_PKG + (String)(Clause.anyCondition(clauses) ? "\nwhere " + Clause.conjunction(clauses) : "") + GET_FUNCTION_COLUMNS_ORDER_BY_3_W_PKG;
            return new DbMetadataMediator.MetadataQuery(sql, Clause.parameters(clauses));
        }
    }

    private static final class FB3
    extends GetFunctionColumns {
        private static final String GET_FUNCTION_COLUMNS_FRAGMENT_3 = "select\n  null as FUNCTION_CAT,\n  trim(trailing from FUN.RDB$FUNCTION_NAME) as FUNCTION_NAME,\n  -- legacy UDF and return value have no parameter name: derive one\n  coalesce(FUNA.RDB$ARGUMENT_NAME, 'PARAM_' || FUNA.RDB$ARGUMENT_POSITION) as COLUMN_NAME,\n  coalesce(FUNA.RDB$FIELD_TYPE, F.RDB$FIELD_TYPE) as FIELD_TYPE,\n  coalesce(FUNA.RDB$FIELD_SUB_TYPE, F.RDB$FIELD_SUB_TYPE) as FIELD_SUB_TYPE,\n  coalesce(FUNA.RDB$FIELD_PRECISION, F.RDB$FIELD_PRECISION) as FIELD_PRECISION,\n  coalesce(FUNA.RDB$FIELD_SCALE, F.RDB$FIELD_SCALE) as FIELD_SCALE,\n  coalesce(FUNA.RDB$FIELD_LENGTH, F.RDB$FIELD_LENGTH) as FIELD_LENGTH,\n  coalesce(FUNA.RDB$CHARACTER_LENGTH, F.RDB$CHARACTER_LENGTH) as CHAR_LEN,\n  coalesce(FUNA.RDB$CHARACTER_SET_ID, F.RDB$CHARACTER_SET_ID) as CHARSET_ID,\n  case\n    when FUN.RDB$RETURN_ARGUMENT = FUNA.RDB$ARGUMENT_POSITION then 0\n    else FUNA.RDB$ARGUMENT_POSITION\n  end as ORDINAL_POSITION,\n  case \n    when coalesce(FUNA.RDB$NULL_FLAG, F.RDB$NULL_FLAG) = 1 then false\n    when FUNA.RDB$MECHANISM = 0 then false\n    when FUNA.RDB$MECHANISM = 1 then false\n    else true\n  end as IS_NULLABLE\nfrom RDB$FUNCTIONS FUN\ninner join RDB$FUNCTION_ARGUMENTS FUNA\n  on FUNA.RDB$FUNCTION_NAME = FUN.RDB$FUNCTION_NAME \n    and FUNA.RDB$PACKAGE_NAME is not distinct from FUN.RDB$PACKAGE_NAME\nleft join RDB$FIELDS F\n  on F.RDB$FIELD_NAME = FUNA.RDB$FIELD_SOURCE\nwhere FUN.RDB$PACKAGE_NAME is null";
        private static final String GET_FUNCTION_COLUMNS_ORDER_BY_3 = "\norder by FUN.RDB$PACKAGE_NAME, FUN.RDB$FUNCTION_NAME,\n  case\n    when FUN.RDB$RETURN_ARGUMENT = FUNA.RDB$ARGUMENT_POSITION then -1\n    else FUNA.RDB$ARGUMENT_POSITION\n  end";

        private FB3(DbMetadataMediator mediator) {
            super(mediator);
        }

        private static GetFunctionColumns createInstance(DbMetadataMediator mediator) {
            return new FB3(mediator);
        }

        @Override
        DbMetadataMediator.MetadataQuery createGetFunctionColumnsQuery(String catalog, String functionNamePattern, String columnNamePattern) {
            Clause functionNameClause = new Clause("FUN.RDB$FUNCTION_NAME", functionNamePattern);
            Clause columnNameClause = new Clause("coalesce(FUNA.RDB$ARGUMENT_NAME, 'PARAM_' || FUNA.RDB$ARGUMENT_POSITION)", columnNamePattern);
            String query = GET_FUNCTION_COLUMNS_FRAGMENT_3 + functionNameClause.getCondition("\nand ", "") + columnNameClause.getCondition("\nand ", "") + GET_FUNCTION_COLUMNS_ORDER_BY_3;
            return new DbMetadataMediator.MetadataQuery(query, Clause.parameters(functionNameClause, columnNameClause));
        }
    }

    private static final class FB2_5
    extends GetFunctionColumns {
        private static final String GET_FUNCTION_COLUMNS_FRAGMENT_2_5 = "select\n  null as FUNCTION_CAT,\n  FUN.RDB$FUNCTION_NAME as FUNCTION_NAME,\n  'PARAM_' || FUNA.RDB$ARGUMENT_POSITION as COLUMN_NAME,\n  FUNA.RDB$FIELD_TYPE as FIELD_TYPE,\n  FUNA.RDB$FIELD_SUB_TYPE as FIELD_SUB_TYPE,\n  FUNA.RDB$FIELD_PRECISION as FIELD_PRECISION,\n  FUNA.RDB$FIELD_SCALE as FIELD_SCALE,\n  FUNA.RDB$FIELD_LENGTH as FIELD_LENGTH,\n  FUNA.RDB$CHARACTER_LENGTH as CHAR_LEN,\n  FUNA.RDB$CHARACTER_SET_ID as CHARSET_ID,\n  case\n    when FUN.RDB$RETURN_ARGUMENT = FUNA.RDB$ARGUMENT_POSITION then 0\n    else FUNA.RDB$ARGUMENT_POSITION\n  end as ORDINAL_POSITION,\n  case FUNA.RDB$MECHANISM\n    when 0 then 'F'\n    when 1 then 'F'\n    else 'T'\n  end as IS_NULLABLE\nfrom RDB$FUNCTIONS FUN\ninner join RDB$FUNCTION_ARGUMENTS FUNA\n  on FUNA.RDB$FUNCTION_NAME = FUN.RDB$FUNCTION_NAME";
        private static final String GET_FUNCTION_COLUMNS_ORDER_BY_2_5 = "\norder by FUN.RDB$FUNCTION_NAME,\n  case\n    when FUN.RDB$RETURN_ARGUMENT = FUNA.RDB$ARGUMENT_POSITION then -1\n    else FUNA.RDB$ARGUMENT_POSITION\n  end";

        private FB2_5(DbMetadataMediator mediator) {
            super(mediator);
        }

        private static GetFunctionColumns createInstance(DbMetadataMediator mediator) {
            return new FB2_5(mediator);
        }

        @Override
        DbMetadataMediator.MetadataQuery createGetFunctionColumnsQuery(String catalog, String functionNamePattern, String columnNamePattern) {
            Clause functionNameClause = new Clause("FUN.RDB$FUNCTION_NAME", functionNamePattern);
            Clause columnNameClause = new Clause("'PARAM_' || FUNA.RDB$ARGUMENT_POSITION", columnNamePattern);
            String query = GET_FUNCTION_COLUMNS_FRAGMENT_2_5 + (String)(Clause.anyCondition(functionNameClause, columnNameClause) ? "\nwhere " + functionNameClause.getCondition(columnNameClause.hasCondition()) + columnNameClause.getCondition(false) : "") + GET_FUNCTION_COLUMNS_ORDER_BY_2_5;
            return new DbMetadataMediator.MetadataQuery(query, Clause.parameters(functionNameClause, columnNameClause));
        }
    }
}

