/*
 * Decompiled with CFR 0.152.
 */
package org.firebirdsql.jdbc.field;

import java.sql.SQLException;
import java.time.LocalDate;
import java.time.LocalDateTime;
import org.firebirdsql.gds.ng.fields.FieldDescriptor;
import org.firebirdsql.jaybird.util.FbDatetimeConversion;
import org.firebirdsql.jdbc.field.AbstractWithoutTimeZoneField;
import org.firebirdsql.jdbc.field.FieldDataProvider;
import org.jspecify.annotations.NullMarked;

final class FBDateField
extends AbstractWithoutTimeZoneField {
    @NullMarked
    FBDateField(FieldDescriptor fieldDescriptor, FieldDataProvider dataProvider, int requiredType) throws SQLException {
        super(fieldDescriptor, dataProvider, requiredType);
    }

    @Override
    public Object getObject() throws SQLException {
        return this.getDate();
    }

    @Override
    LocalDate getLocalDate() throws SQLException {
        return this.getDatatypeCoder().decodeLocalDate(this.getFieldData());
    }

    @Override
    LocalDateTime getLocalDateTime() throws SQLException {
        LocalDate localDate = this.getLocalDate();
        return localDate != null ? localDate.atStartOfDay() : null;
    }

    @Override
    public String getString() throws SQLException {
        return FbDatetimeConversion.formatSqlDate(this.getLocalDate());
    }

    @Override
    public void setString(String value) throws SQLException {
        this.setLocalDate(this.fromString(value, FbDatetimeConversion::parseSqlDate));
    }

    @Override
    void setLocalDateTime(LocalDateTime value) throws SQLException {
        this.setLocalDate(value != null ? value.toLocalDate() : null);
    }

    @Override
    void setLocalDate(LocalDate value) throws SQLException {
        this.setFieldData(this.getDatatypeCoder().encodeLocalDate(value));
    }
}

