/*
 * Decompiled with CFR 0.152.
 */
package org.firebirdsql.jdbc;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.firebirdsql.gds.impl.GDSHelper;
import org.firebirdsql.gds.ng.fields.FieldDescriptor;
import org.firebirdsql.gds.ng.fields.RowDescriptor;
import org.firebirdsql.jaybird.util.StringUtils;
import org.firebirdsql.jdbc.AbstractFieldMetaData;
import org.firebirdsql.jdbc.FBConnection;
import org.firebirdsql.jdbc.FBDatabaseMetaData;
import org.firebirdsql.jdbc.FirebirdResultSetMetaData;
import org.firebirdsql.jdbc.field.JdbcTypeConverter;

public class FBResultSetMetaData
extends AbstractFieldMetaData
implements FirebirdResultSetMetaData {
    private final ColumnStrategy columnStrategy;
    private static final int FIELD_INFO_RELATION_NAME = 1;
    private static final int FIELD_INFO_FIELD_NAME = 2;
    private static final int FIELD_INFO_FIELD_PRECISION = 3;
    private static final int FIELD_INFO_FIELD_AUTO_INC = 4;
    private static final String GET_FIELD_INFO_25 = "select\n  RF.RDB$RELATION_NAME as RELATION_NAME,\n  RF.RDB$FIELD_NAME as FIELD_NAME,\n  F.RDB$FIELD_PRECISION as FIELD_PRECISION,\n  'F' as FIELD_AUTO_INC\nfrom RDB$RELATION_FIELDS RF inner join RDB$FIELDS F\n  on RF.RDB$FIELD_SOURCE = F.RDB$FIELD_NAME\nwhere RF.RDB$FIELD_NAME = ? and RF.RDB$RELATION_NAME = ?";
    private static final String GET_FIELD_INFO_30 = "select\n  RF.RDB$RELATION_NAME as RELATION_NAME,\n  RF.RDB$FIELD_NAME as FIELD_NAME,\n  F.RDB$FIELD_PRECISION as FIELD_PRECISION,\n  RF.RDB$IDENTITY_TYPE is not null as FIELD_AUTO_INC\nfrom RDB$RELATION_FIELDS RF inner join RDB$FIELDS F\n  on RF.RDB$FIELD_SOURCE = F.RDB$FIELD_NAME\nwhere RF.RDB$FIELD_NAME = ? and RF.RDB$RELATION_NAME = ?";
    private static final int MAX_FIELD_INFO_UNIONS = 70;

    protected FBResultSetMetaData(RowDescriptor rowDescriptor, FBConnection connection) throws SQLException {
        super(rowDescriptor, connection);
        this.columnStrategy = FBResultSetMetaData.isColumnLabelForName(connection) ? ColumnStrategy.COLUMN_LABEL_FOR_NAME : ColumnStrategy.DEFAULT;
    }

    private static boolean isColumnLabelForName(FBConnection connection) throws SQLException {
        if (connection == null) {
            return false;
        }
        GDSHelper gdsHelper = connection.getGDSHelper();
        return gdsHelper != null && gdsHelper.getConnectionProperties().isColumnLabelForName();
    }

    @Override
    public int getColumnCount() throws SQLException {
        return this.getFieldCount();
    }

    @Override
    public boolean isAutoIncrement(int column) throws SQLException {
        return switch (this.getColumnType(column)) {
            case -5, 4, 5 -> {
                AbstractFieldMetaData.ExtendedFieldInfo extFieldInfo = this.getExtFieldInfo(column);
                if (extFieldInfo != null && extFieldInfo.autoIncrement()) {
                    yield true;
                }
                yield false;
            }
            default -> false;
        };
    }

    @Override
    public boolean isCaseSensitive(int column) throws SQLException {
        return true;
    }

    @Override
    public boolean isSearchable(int column) throws SQLException {
        int sqlType = this.getFieldDescriptor(column).getType() & 0xFFFFFFFE;
        return sqlType != 540 && sqlType != 520;
    }

    @Override
    public boolean isCurrency(int column) throws SQLException {
        return false;
    }

    @Override
    public int isNullable(int column) throws SQLException {
        return (this.getFieldDescriptor(column).getType() & 1) == 1 ? 1 : 0;
    }

    @Override
    public boolean isSigned(int column) throws SQLException {
        return this.isSignedInternal(column);
    }

    @Override
    public int getColumnDisplaySize(int column) throws SQLException {
        int precision = this.getPrecision(column);
        return switch (this.getColumnType(column)) {
            case 2, 3 -> precision + 2;
            case 6 -> 13;
            case 8 -> 22;
            case -5, 4, 5 -> precision + 1;
            case -6001 -> {
                if (precision == 16) {
                    yield 23;
                }
                yield 42;
            }
            case 16 -> 5;
            default -> precision;
        };
    }

    @Override
    public String getColumnLabel(int column) throws SQLException {
        return this.columnStrategy.getColumnLabel(this.getFieldDescriptor(column));
    }

    @Override
    public String getColumnName(int column) throws SQLException {
        return this.columnStrategy.getColumnName(this.getFieldDescriptor(column));
    }

    @Override
    public String getSchemaName(int column) throws SQLException {
        return "";
    }

    @Override
    public int getPrecision(int column) throws SQLException {
        return this.getPrecisionInternal(column);
    }

    @Override
    public int getScale(int column) throws SQLException {
        return this.getScaleInternal(column);
    }

    @Override
    public String getTableName(int column) throws SQLException {
        String result = this.getFieldDescriptor(column).getOriginalTableName();
        if (result == null) {
            result = "";
        }
        return result;
    }

    @Override
    public String getTableAlias(int column) throws SQLException {
        String result = this.getFieldDescriptor(column).getTableAlias();
        if (result == null) {
            result = this.getTableName(column);
        }
        return result;
    }

    @Override
    public String getCatalogName(int column) throws SQLException {
        return "";
    }

    @Override
    public int getColumnType(int column) throws SQLException {
        return this.getFieldType(column);
    }

    @Override
    public String getColumnTypeName(int column) throws SQLException {
        return this.getFieldTypeName(column);
    }

    @Override
    public boolean isReadOnly(int column) throws SQLException {
        return this.getFieldDescriptor(column).isDbKey();
    }

    @Override
    public boolean isWritable(int column) throws SQLException {
        return !this.getFieldDescriptor(column).isDbKey();
    }

    @Override
    public boolean isDefinitelyWritable(int column) throws SQLException {
        return this.isWritable(column);
    }

    @Override
    public String getColumnClassName(int column) throws SQLException {
        return this.getFieldClassName(column);
    }

    @Override
    protected Map<AbstractFieldMetaData.FieldKey, AbstractFieldMetaData.ExtendedFieldInfo> getExtendedFieldInfo(FBConnection connection) throws SQLException {
        String getFieldInfoQuery;
        if (connection == null || !connection.isExtendedMetadata()) {
            return Collections.emptyMap();
        }
        int fieldCount = this.getFieldCount();
        int currentColumn = 1;
        HashMap<AbstractFieldMetaData.FieldKey, AbstractFieldMetaData.ExtendedFieldInfo> result = new HashMap<AbstractFieldMetaData.FieldKey, AbstractFieldMetaData.ExtendedFieldInfo>();
        FBDatabaseMetaData metaData = (FBDatabaseMetaData)connection.getMetaData();
        ArrayList<String> params = new ArrayList<String>();
        StringBuilder sb = new StringBuilder();
        boolean fb3OrHigher = metaData.getDatabaseMajorVersion() >= 3;
        String string = getFieldInfoQuery = fb3OrHigher ? GET_FIELD_INFO_30 : GET_FIELD_INFO_25;
        while (currentColumn <= fieldCount) {
            params.clear();
            sb.setLength(0);
            int unionCount = 0;
            while (currentColumn <= fieldCount && unionCount < 70) {
                FieldDescriptor fieldDescriptor = this.getFieldDescriptor(currentColumn);
                if (FBResultSetMetaData.needsExtendedFieldInfo(fieldDescriptor, fb3OrHigher)) {
                    String relationName = fieldDescriptor.getOriginalTableName();
                    String fieldName = fieldDescriptor.getOriginalName();
                    if (!StringUtils.isNullOrEmpty(relationName) && !StringUtils.isNullOrEmpty(fieldName)) {
                        if (unionCount != 0) {
                            sb.append("\nunion all\n");
                        }
                        sb.append(getFieldInfoQuery);
                        params.add(fieldName);
                        params.add(relationName);
                        ++unionCount;
                    }
                }
                ++currentColumn;
            }
            if (sb.isEmpty()) continue;
            ResultSet rs = metaData.doQuery(sb.toString(), params, true);
            try {
                while (rs.next()) {
                    AbstractFieldMetaData.ExtendedFieldInfo fieldInfo = FBResultSetMetaData.extractExtendedFieldInfo(rs);
                    result.put(fieldInfo.fieldKey(), fieldInfo);
                }
            }
            finally {
                if (rs == null) continue;
                rs.close();
            }
        }
        return result;
    }

    private static AbstractFieldMetaData.ExtendedFieldInfo extractExtendedFieldInfo(ResultSet rs) throws SQLException {
        return new AbstractFieldMetaData.ExtendedFieldInfo(rs.getString(1), rs.getString(2), rs.getInt(3), rs.getBoolean(4));
    }

    private static boolean needsExtendedFieldInfo(FieldDescriptor fieldDescriptor, boolean fb3OrHigher) {
        return switch (JdbcTypeConverter.toJdbcType(fieldDescriptor)) {
            case 2, 3 -> true;
            case -5, 4, 5 -> fb3OrHigher;
            default -> false;
        };
    }

    /*
     * Uses 'sealed' constructs - enablewith --sealed true
     */
    private static enum ColumnStrategy {
        DEFAULT{

            @Override
            String getColumnName(FieldDescriptor fieldDescriptor) {
                return fieldDescriptor.getOriginalName() != null ? fieldDescriptor.getOriginalName() : this.getColumnLabel(fieldDescriptor);
            }
        }
        ,
        COLUMN_LABEL_FOR_NAME{

            @Override
            String getColumnName(FieldDescriptor fieldDescriptor) {
                return this.getColumnLabel(fieldDescriptor);
            }
        };


        abstract String getColumnName(FieldDescriptor var1);

        String getColumnLabel(FieldDescriptor fieldDescriptor) {
            if (fieldDescriptor.getFieldName() != null) {
                return fieldDescriptor.getFieldName();
            }
            if (fieldDescriptor.getOriginalName() != null) {
                return fieldDescriptor.getOriginalName();
            }
            return "";
        }
    }
}

