/*
 * Decompiled with CFR 0.152.
 */
package org.firebirdsql.jdbc;

import java.sql.DriverPropertyInfo;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import org.firebirdsql.jaybird.props.def.ConnectionProperty;
import org.firebirdsql.jaybird.props.internal.ConnectionPropertyRegistry;

final class FBDriverPropertyManager {
    private FBDriverPropertyManager() {
    }

    static Map<String, String> normalize(Map<String, String> props) throws SQLException {
        HashMap<String, String> result = new HashMap<String, String>(props.size());
        ConnectionPropertyRegistry propertyRegistry = ConnectionPropertyRegistry.getInstance();
        for (Map.Entry<String, String> entry : props.entrySet()) {
            boolean hasDuplicate;
            String propName = entry.getKey();
            ConnectionProperty property = propertyRegistry.getByName(propName);
            String primaryName = property != null ? property.name() : propName;
            boolean bl = hasDuplicate = property != null && result.containsKey(primaryName);
            if (hasDuplicate) {
                throw new SQLException("Specified properties contain multiple references to a property: primary name %s, current name: %s".formatted(primaryName, propName), "HY000");
            }
            String propValue = entry.getValue();
            result.put(primaryName, propValue);
        }
        return result;
    }

    static DriverPropertyInfo[] getDriverPropertyInfo(Properties props) {
        ConnectionPropertyRegistry propertyRegistry = ConnectionPropertyRegistry.getInstance();
        ArrayList<DriverPropertyInfo> result = new ArrayList<DriverPropertyInfo>(props.size());
        for (String propName : props.stringPropertyNames()) {
            String propValue = props.getProperty(propName);
            ConnectionProperty propInfo = propertyRegistry.getByName(propName);
            DriverPropertyInfo driverPropInfo = new DriverPropertyInfo(propName, propValue != null ? propValue.toString() : "");
            if (propInfo != null && !propInfo.choices().isEmpty()) {
                driverPropInfo.choices = propInfo.choices().toArray(new String[0]);
            }
            result.add(driverPropInfo);
        }
        return result.toArray(new DriverPropertyInfo[0]);
    }
}

