/*
 * Decompiled with CFR 0.152.
 */
package org.firebirdsql.jaybird.parser;

import org.firebirdsql.jaybird.parser.AbstractToken;
import org.firebirdsql.jaybird.parser.LiteralToken;

final class StringLiteralToken
extends AbstractToken
implements LiteralToken {
    private static final int STRING_LITERAL_MIN_SIZE = 2;
    private static final int Q_LITERAL_MIN_SIZE = 5;
    private static final int X_LITERAL_MIN_SIZE = 3;

    StringLiteralToken(int pos, CharSequence src, int start, int end) {
        super(pos, src, start, end);
    }

    public StringLiteralToken(int pos, CharSequence tokenText) {
        super(pos, tokenText);
    }

    public String value() {
        int textLength = this.length();
        if (textLength < 2) {
            throw StringLiteralToken.literalTooShort(this.text());
        }
        char firstChar = this.charAt(0);
        return switch (firstChar) {
            case '\'' -> {
                this.checkEndsInQuote();
                String value = this.subSequence(1, textLength - 1).toString();
                if (value.indexOf(39) == -1) {
                    yield value;
                }
                yield value.replace("''", "'");
            }
            case 'Q', 'q' -> {
                if (textLength < 5) {
                    throw StringLiteralToken.literalTooShort(this.text());
                }
                this.checkEndsInQuote();
                yield this.subSequence(3, textLength - 2).toString();
            }
            case 'X', 'x' -> {
                if (textLength < 3) {
                    throw StringLiteralToken.literalTooShort(this.text());
                }
                this.checkEndsInQuote();
                yield this.subSequence(2, textLength - 1).toString();
            }
            default -> throw new IllegalStateException(String.format("String literal starts with unexpected character '%s', full text: %s", Character.valueOf(firstChar), this.text()));
        };
    }

    private static IllegalStateException literalTooShort(String text) {
        return new IllegalStateException("String literal too short, full text: " + text);
    }

    private void checkEndsInQuote() {
        char lastChar = this.charAt(this.length() - 1);
        if (lastChar != '\'') {
            throw new IllegalStateException(String.format("String literal ends with unexpected character '%s', expected: ''', full text: %s", Character.valueOf(lastChar), this.text()));
        }
    }
}

