/*
 * Decompiled with CFR 0.152.
 */
package org.firebirdsql.gds.ng.wire.version13;

import java.io.IOException;
import java.sql.SQLException;
import java.util.Objects;
import java.util.Optional;
import org.firebirdsql.encodings.Encoding;
import org.firebirdsql.gds.impl.wire.XdrInputStream;
import org.firebirdsql.gds.impl.wire.XdrOutputStream;
import org.firebirdsql.gds.ng.FbExceptionBuilder;
import org.firebirdsql.gds.ng.WarningMessageCallback;
import org.firebirdsql.gds.ng.WireCrypt;
import org.firebirdsql.gds.ng.dbcrypt.DbCryptCallback;
import org.firebirdsql.gds.ng.dbcrypt.DbCryptData;
import org.firebirdsql.gds.ng.wire.FbWireAttachment;
import org.firebirdsql.gds.ng.wire.FbWireOperations;
import org.firebirdsql.gds.ng.wire.GenericResponse;
import org.firebirdsql.gds.ng.wire.WireConnection;
import org.firebirdsql.gds.ng.wire.auth.ClientAuthBlock;
import org.firebirdsql.gds.ng.wire.crypt.CryptConnectionInfo;
import org.firebirdsql.gds.ng.wire.crypt.CryptSessionConfig;
import org.firebirdsql.gds.ng.wire.crypt.EncryptionIdentifier;
import org.firebirdsql.gds.ng.wire.crypt.EncryptionInitInfo;
import org.firebirdsql.gds.ng.wire.crypt.EncryptionPlugin;
import org.firebirdsql.gds.ng.wire.crypt.EncryptionPluginRegistry;
import org.firebirdsql.gds.ng.wire.crypt.EncryptionPluginSpi;
import org.firebirdsql.gds.ng.wire.crypt.KnownServerKey;
import org.firebirdsql.gds.ng.wire.version11.V11WireOperations;
import org.firebirdsql.jaybird.util.ExceptionHelper;
import org.firebirdsql.jaybird.util.SQLExceptionChainBuilder;

public class V13WireOperations
extends V11WireOperations {
    private static final System.Logger log = System.getLogger(V13WireOperations.class.getName());

    public V13WireOperations(WireConnection<?, ?> connection, WarningMessageCallback defaultWarningMessageCallback) {
        super(connection, defaultWarningMessageCallback);
    }

    @Override
    public void authReceiveResponse(FbWireAttachment.AcceptPacket acceptPacket, DbCryptCallback dbCryptCallback, FbWireOperations.ProcessAttachCallback processAttachCallback) throws SQLException, IOException {
        assert (acceptPacket == null || acceptPacket.operation == 98) : "Unexpected operation in AcceptPacket";
        XdrInputStream xdrIn = this.getXdrIn();
        XdrOutputStream xdrOut = this.getXdrOut();
        ClientAuthBlock clientAuthBlock = this.getClientAuthBlock();
        Encoding encoding = this.getEncoding();
        block7: while (true) {
            String pluginName;
            byte[] data;
            if (acceptPacket != null) {
                data = acceptPacket.p_acpt_data;
                pluginName = acceptPacket.p_acpt_plugin;
                this.addServerKeys(acceptPacket.p_acpt_keys);
                acceptPacket = null;
            } else {
                int operation = this.readNextOperation();
                switch (operation) {
                    case 90: {
                        xdrIn.skipNBytes(4L);
                        throw FbExceptionBuilder.toNonTransientConnectionException(337248272);
                    }
                    case 92: {
                        data = xdrIn.readBuffer();
                        pluginName = xdrIn.readString(encoding);
                        xdrIn.skipBuffer();
                        this.addServerKeys(xdrIn.readBuffer());
                        break;
                    }
                    case 97: {
                        log.log(System.Logger.Level.TRACE, "Handling db crypt callback using plugin {0}", dbCryptCallback.getDbCryptCallbackName());
                        this.handleCryptKeyCallback(dbCryptCallback);
                        continue block7;
                    }
                    case 98: {
                        xdrIn.skipNBytes(12L);
                        data = xdrIn.readBuffer();
                        pluginName = xdrIn.readString(encoding);
                        xdrIn.skipNBytes(4L);
                        this.addServerKeys(xdrIn.readBuffer());
                        break;
                    }
                    case 9: {
                        GenericResponse response = (GenericResponse)this.readOperationResponse(operation, null);
                        boolean wasAuthComplete = clientAuthBlock.isAuthComplete();
                        clientAuthBlock.setAuthComplete(true);
                        processAttachCallback.processAttachResponse(response);
                        this.addServerKeys(response.data());
                        WireCrypt wireCrypt = this.getAttachProperties().getWireCryptAsEnum();
                        if (!wasAuthComplete && wireCrypt != WireCrypt.DISABLED) {
                            this.tryKnownServerKeys();
                        }
                        return;
                    }
                    default: {
                        throw new SQLException(String.format("Unsupported operation code: %d", operation));
                    }
                }
            }
            if (pluginName != null && !pluginName.isEmpty() && Objects.equals(pluginName, clientAuthBlock.getCurrentPluginName())) {
                pluginName = null;
            }
            if (pluginName != null && !pluginName.isEmpty() && !clientAuthBlock.switchPlugin(pluginName) || !clientAuthBlock.hasPlugin()) break;
            clientAuthBlock.setServerData(data);
            log.log(System.Logger.Level.TRACE, "receiveResponse: authenticate({0})", clientAuthBlock.getCurrentPluginName());
            clientAuthBlock.authenticate();
            xdrOut.writeInt(92);
            xdrOut.writeBuffer(clientAuthBlock.getClientData());
            xdrOut.writeString(clientAuthBlock.getCurrentPluginName(), encoding);
            if (clientAuthBlock.isFirstTime()) {
                xdrOut.writeString(clientAuthBlock.getPluginNames(), encoding);
                clientAuthBlock.setFirstTime(false);
            } else {
                xdrOut.writeBuffer(null);
            }
            xdrOut.writeBuffer(null);
            xdrOut.flush();
        }
        throw FbExceptionBuilder.toException(335544472);
    }

    private CryptSessionConfig getCryptSessionConfig(EncryptionIdentifier encryptionIdentifier, byte[] specificData) throws SQLException {
        ClientAuthBlock clientAuthBlock = this.getClientAuthBlock();
        if (!clientAuthBlock.supportsEncryption() || !encryptionIdentifier.isTypeSymmetric()) {
            throw FbExceptionBuilder.forNonTransientException(337248280).messageParameter((Object)encryptionIdentifier).toSQLException();
        }
        return CryptSessionConfig.symmetric(encryptionIdentifier, clientAuthBlock.getSessionKey(), specificData);
    }

    private void tryKnownServerKeys() throws IOException, SQLException {
        SQLExceptionChainBuilder chainBuilder = new SQLExceptionChainBuilder();
        EncryptionIdentifier selectedEncryption = null;
        for (KnownServerKey.PluginSpecificData pluginSpecificData : this.getPluginSpecificData()) {
            Optional<EncryptionIdentifier> selectedEncryptionOpt = this.tryKnownServerKey(pluginSpecificData, chainBuilder);
            if (!selectedEncryptionOpt.isPresent()) continue;
            selectedEncryption = selectedEncryptionOpt.get();
            break;
        }
        if (selectedEncryption == null) {
            this.throwIfWireCryptRequired(chainBuilder.getException());
        }
        V13WireOperations.logWireCryptPluginFailures(chainBuilder, selectedEncryption);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private Optional<EncryptionIdentifier> tryKnownServerKey(KnownServerKey.PluginSpecificData pluginSpecificData, SQLExceptionChainBuilder chainBuilder) throws IOException {
        EncryptionIdentifier encryptionIdentifier = pluginSpecificData.encryptionIdentifier();
        EncryptionPluginSpi encryptionPluginSpi = EncryptionPluginRegistry.getEncryptionPluginSpi(encryptionIdentifier);
        if (encryptionPluginSpi == null) {
            log.log(System.Logger.Level.TRACE, "No wire encryption plugin available for {0}", encryptionIdentifier);
            return Optional.empty();
        }
        record ConnectionInfoImpl(int protocolVersion) implements CryptConnectionInfo
        {
        }
        if (!encryptionPluginSpi.isSupported(new ConnectionInfoImpl(this.getConnection().getProtocolVersion()))) {
            log.log(System.Logger.Level.TRACE, "Wire encryption plugin {0} skipped, not supported", encryptionIdentifier);
            return Optional.empty();
        }
        try (CryptSessionConfig cryptSessionConfig = this.getCryptSessionConfig(encryptionIdentifier, pluginSpecificData.specificData());){
            EncryptionPlugin encryptionPlugin = encryptionPluginSpi.createEncryptionPlugin(cryptSessionConfig);
            EncryptionInitInfo encryptionInitInfo = encryptionPlugin.initializeEncryption();
            if (encryptionInitInfo.isSuccess()) {
                this.enableEncryption(encryptionInitInfo);
                this.clearServerKeys();
                if (chainBuilder.hasException() && log.isLoggable(System.Logger.Level.WARNING)) {
                    log.log(System.Logger.Level.WARNING, "Wire encryption established with {0}, but some plugins failed; see debug level for stacktraces\n{1}", encryptionIdentifier, ExceptionHelper.collectAllMessages(chainBuilder.getException()));
                } else {
                    log.log(System.Logger.Level.TRACE, "Wire encryption established with {0}", encryptionIdentifier);
                }
                Optional<EncryptionIdentifier> optional = Optional.of(encryptionIdentifier);
                return optional;
            }
            chainBuilder.append(encryptionInitInfo.getException());
            return Optional.empty();
        }
        catch (SQLException e) {
            chainBuilder.append(e);
        }
        return Optional.empty();
    }

    private void throwIfWireCryptRequired(SQLException encryptionException) throws SQLException {
        if (this.getAttachProperties().getWireCryptAsEnum() == WireCrypt.REQUIRED) {
            throw FbExceptionBuilder.forNonTransientException(335545064).cause(encryptionException).toSQLException();
        }
    }

    private static void logWireCryptPluginFailures(SQLExceptionChainBuilder chainBuilder, EncryptionIdentifier selectedEncryption) {
        if (chainBuilder.hasException() && log.isLoggable(System.Logger.Level.WARNING)) {
            if (selectedEncryption == null) {
                log.log(System.Logger.Level.WARNING, "No wire encryption established because of plugin failures; see debug level for stacktraces:\n{0}", ExceptionHelper.collectAllMessages(chainBuilder.getException()));
            }
            if (log.isLoggable(System.Logger.Level.DEBUG)) {
                SQLException current = chainBuilder.getException();
                do {
                    log.log(System.Logger.Level.DEBUG, "Encryption plugin failed", (Throwable)current);
                } while ((current = current.getNextException()) != null);
            }
        }
    }

    protected void enableEncryption(EncryptionInitInfo encryptionInitInfo) throws SQLException, IOException {
        XdrInputStream xdrIn = this.getXdrIn();
        XdrOutputStream xdrOut = this.getXdrOut();
        Encoding encoding = this.getEncoding();
        EncryptionIdentifier encryptionIdentifier = encryptionInitInfo.getEncryptionIdentifier();
        xdrOut.writeInt(96);
        xdrOut.writeString(encryptionIdentifier.pluginName(), encoding);
        xdrOut.writeString(encryptionIdentifier.type(), encoding);
        xdrOut.flush();
        xdrIn.setCipher(encryptionInitInfo.getDecryptionCipher());
        xdrOut.setCipher(encryptionInitInfo.getEncryptionCipher());
        this.readResponse(null);
    }

    @Override
    public final void handleCryptKeyCallback(DbCryptCallback dbCryptCallback) throws IOException, SQLException {
        DbCryptData clientPluginResponse;
        DbCryptData serverPluginData = this.readCryptKeyCallback();
        try {
            clientPluginResponse = dbCryptCallback.handleCallback(serverPluginData);
        }
        catch (Exception e) {
            log.log(System.Logger.Level.ERROR, "Error during database encryption callback, using default empty response", (Throwable)e);
            clientPluginResponse = DbCryptData.EMPTY_DATA;
        }
        this.writeCryptKeyCallback(clientPluginResponse);
    }

    protected DbCryptData readCryptKeyCallback() throws IOException, SQLException {
        XdrInputStream xdrIn = this.getXdrIn();
        byte[] pluginData = xdrIn.readBuffer();
        try {
            return new DbCryptData(pluginData, Integer.MIN_VALUE);
        }
        catch (RuntimeException e) {
            throw FbExceptionBuilder.forNonTransientConnectionException(337248285).cause(e).toSQLException();
        }
    }

    protected void writeCryptKeyCallback(DbCryptData clientPluginResponse) throws SQLException, IOException {
        XdrOutputStream xdrOut = this.getXdrOut();
        xdrOut.writeInt(97);
        xdrOut.writeBuffer(clientPluginResponse.getPluginData());
        xdrOut.flush();
    }
}

