/*
 * Decompiled with CFR 0.152.
 */
package org.firebirdsql.gds.ng.wire.version11;

import java.io.IOException;
import java.sql.SQLException;
import org.firebirdsql.gds.ng.FbExceptionBuilder;
import org.firebirdsql.gds.ng.LockCloseable;
import org.firebirdsql.gds.ng.wire.DeferredAction;
import org.firebirdsql.gds.ng.wire.ProtocolDescriptor;
import org.firebirdsql.gds.ng.wire.Response;
import org.firebirdsql.gds.ng.wire.WireDatabaseConnection;
import org.firebirdsql.gds.ng.wire.version10.V10Database;

public class V11Database
extends V10Database {
    protected V11Database(WireDatabaseConnection connection, ProtocolDescriptor descriptor) {
        super(connection, descriptor);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public void releaseObject(int operation, int objectId) throws SQLException {
        try (LockCloseable ignored = this.withLock();){
            this.checkAttached();
            this.doReleaseObjectPacket(operation, objectId);
            switch (operation) {
                case 38: 
                case 39: {
                    this.enqueueDeferredAction(new DeferredAction(){

                        @Override
                        public void processResponse(Response response) {
                            V11Database.this.processReleaseObjectResponse(response);
                        }

                        @Override
                        public boolean requiresSync() {
                            return true;
                        }
                    });
                    return;
                }
                default: {
                    throw new IllegalArgumentException("Unexpected operation in V11Databsase.releaseObject: %d".formatted(operation));
                }
            }
        }
        catch (IOException e) {
            throw FbExceptionBuilder.ioWriteError(e);
        }
    }
}

