/*
 * Decompiled with CFR 0.152.
 */
package org.firebirdsql.gds.ng;

import java.sql.SQLException;
import org.firebirdsql.gds.ng.FbExceptionBuilder;
import org.firebirdsql.gds.ng.FbTransaction;
import org.firebirdsql.gds.ng.TransactionState;

public final class TransactionHelper {
    private TransactionHelper() {
    }

    public static void checkTransactionActive(FbTransaction transaction) throws SQLException {
        TransactionHelper.checkTransactionActive(transaction, 337248333);
    }

    public static void checkTransactionActive(FbTransaction transaction, int fbErrorCode) throws SQLException {
        if (transaction == null || transaction.getState() != TransactionState.ACTIVE) {
            throw FbExceptionBuilder.toNonTransientException(fbErrorCode);
        }
    }

    public static boolean isTransactionEnding(FbTransaction transaction) {
        if (transaction == null) {
            return false;
        }
        return switch (transaction.getState()) {
            case TransactionState.COMMITTING, TransactionState.ROLLING_BACK, TransactionState.PREPARING -> true;
            default -> false;
        };
    }
}

