/*
 * Decompiled with CFR 0.152.
 */
package org.firebirdsql.gds.ng;

import java.io.InputStream;
import java.io.OutputStream;
import java.io.Reader;
import java.io.Writer;
import java.math.BigInteger;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.util.Arrays;
import java.util.Objects;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import org.firebirdsql.encodings.Encoding;
import org.firebirdsql.encodings.EncodingDefinition;
import org.firebirdsql.encodings.IEncodingFactory;
import org.firebirdsql.extern.decimal.Decimal128;
import org.firebirdsql.extern.decimal.Decimal64;
import org.firebirdsql.gds.JaybirdSystemProperties;
import org.firebirdsql.gds.ng.DatatypeCoder;
import org.firebirdsql.gds.ng.EncodingSpecificDatatypeCoder;
import org.firebirdsql.jaybird.util.FbDatetimeConversion;

public class DefaultDatatypeCoder
implements DatatypeCoder {
    private static final System.Logger logger = System.getLogger(DefaultDatatypeCoder.class.getName());
    private static final int DEFAULT_DATATYPE_CODER_CACHE_SIZE = 10;
    private static final int DATATYPE_CODER_CACHE_SIZE = Math.max(1, JaybirdSystemProperties.getDatatypeCoderCacheSize(10));
    private static final int LOG_CACHE_MAINTENANCE_WARNING = 10;
    private final IEncodingFactory encodingFactory;
    private final Encoding encoding;
    private final ConcurrentMap<EncodingDefinition, DatatypeCoder> encodingSpecificDatatypeCoders = new ConcurrentHashMap<EncodingDefinition, DatatypeCoder>(DATATYPE_CODER_CACHE_SIZE);
    private final Lock cacheMaintenanceLock = new ReentrantLock();
    private int cacheMaintenanceCount = 0;

    public static DefaultDatatypeCoder forEncodingFactory(IEncodingFactory encodingFactory) {
        return encodingFactory.getOrCreateDatatypeCoder(DefaultDatatypeCoder.class, DefaultDatatypeCoder::new);
    }

    public DefaultDatatypeCoder(IEncodingFactory encodingFactory) {
        this.encodingFactory = Objects.requireNonNull(encodingFactory, "encodingFactory");
        this.encoding = encodingFactory.getDefaultEncoding();
    }

    @Override
    public int sizeOfShort() {
        return 4;
    }

    @Override
    public byte[] encodeShort(short val) {
        byte[] buf = new byte[this.sizeOfShort()];
        this.encodeShort(val, buf, 0);
        return buf;
    }

    @Override
    public byte[] encodeShort(int val) {
        return this.encodeShort((short)val);
    }

    @Override
    public void encodeShort(int val, byte[] buf, int off) {
        this.encodeInt(val, buf, off);
    }

    @Override
    public short decodeShort(byte[] buf) {
        return buf != null ? this.decodeShort(buf, 0) : (short)0;
    }

    @Override
    public short decodeShort(byte[] buf, int off) {
        return (short)this.decodeInt(buf, off);
    }

    @Override
    public byte[] encodeInt(int val) {
        byte[] buf = new byte[4];
        this.encodeInt(val, buf, 0);
        return buf;
    }

    @Override
    public void encodeInt(int val, byte[] buf, int off) {
        buf[off] = (byte)(val >>> 24);
        buf[off + 1] = (byte)(val >>> 16);
        buf[off + 2] = (byte)(val >>> 8);
        buf[off + 3] = (byte)val;
    }

    @Override
    public int decodeInt(byte[] buf) {
        return buf != null ? this.decodeInt(buf, 0) : 0;
    }

    @Override
    public int decodeInt(byte[] buf, int off) {
        return (buf[off] << 24) + ((buf[off + 1] & 0xFF) << 16) + ((buf[off + 2] & 0xFF) << 8) + (buf[off + 3] & 0xFF);
    }

    @Override
    public byte[] encodeLong(long val) {
        byte[] buf = new byte[]{(byte)(val >>> 56), (byte)(val >>> 48), (byte)(val >>> 40), (byte)(val >>> 32), (byte)(val >>> 24), (byte)(val >>> 16), (byte)(val >>> 8), (byte)val};
        return buf;
    }

    @Override
    public long decodeLong(byte[] buf) {
        if (buf == null) {
            return 0L;
        }
        return ((long)buf[0] << 56) + (((long)buf[1] & 0xFFL) << 48) + (((long)buf[2] & 0xFFL) << 40) + (((long)buf[3] & 0xFFL) << 32) + (((long)buf[4] & 0xFFL) << 24) + (((long)buf[5] & 0xFFL) << 16) + (((long)buf[6] & 0xFFL) << 8) + ((long)buf[7] & 0xFFL);
    }

    @Override
    public byte[] encodeFloat(float val) {
        return this.encodeInt(Float.floatToIntBits(val));
    }

    @Override
    public float decodeFloat(byte[] buf) {
        return buf != null ? Float.intBitsToFloat(this.decodeInt(buf)) : 0.0f;
    }

    @Override
    public byte[] encodeDouble(double val) {
        return this.encodeLong(Double.doubleToLongBits(val));
    }

    @Override
    public double decodeDouble(byte[] buf) {
        return buf != null ? Double.longBitsToDouble(this.decodeLong(buf)) : 0.0;
    }

    @Override
    public final byte[] encodeString(String val) {
        return val != null ? this.encoding.encodeToCharset(val) : null;
    }

    @Override
    public final Writer createWriter(OutputStream out) {
        return this.encoding.createWriter(out);
    }

    @Override
    public final String decodeString(byte[] buf) {
        return buf != null ? this.encoding.decodeFromCharset(buf) : null;
    }

    @Override
    public final Reader createReader(InputStream in) {
        return this.encoding.createReader(in);
    }

    @Override
    public boolean decodeBoolean(byte[] buf) {
        return buf != null && buf[0] != 0;
    }

    @Override
    public byte[] encodeBoolean(boolean val) {
        return new byte[]{(byte)(val ? 1 : 0)};
    }

    @Override
    public LocalTime decodeLocalTime(byte[] buf) {
        return buf != null ? this.decodeLocalTime(buf, 0) : null;
    }

    @Override
    public LocalTime decodeLocalTime(byte[] buf, int off) {
        return FbDatetimeConversion.fromFbTimeUnits(this.decodeInt(buf, off));
    }

    @Override
    public byte[] encodeLocalTime(LocalTime val) {
        return val != null ? this.encodeInt(FbDatetimeConversion.toFbTimeUnits(val)) : null;
    }

    @Override
    public void encodeLocalTime(LocalTime val, byte[] buf, int off) {
        this.encodeInt(FbDatetimeConversion.toFbTimeUnits(val), buf, off);
    }

    @Override
    public LocalDate decodeLocalDate(byte[] buf) {
        return buf != null ? this.decodeLocalDate(buf, 0) : null;
    }

    @Override
    public LocalDate decodeLocalDate(byte[] buf, int off) {
        return FbDatetimeConversion.fromModifiedJulianDate(this.decodeInt(buf, off));
    }

    @Override
    public byte[] encodeLocalDate(LocalDate val) {
        return val != null ? this.encodeInt(FbDatetimeConversion.toModifiedJulianDate(val)) : null;
    }

    @Override
    public void encodeLocalDate(LocalDate val, byte[] buf, int off) {
        this.encodeInt(FbDatetimeConversion.toModifiedJulianDate(val), buf, off);
    }

    @Override
    public LocalDateTime decodeLocalDateTime(byte[] buf) {
        return buf != null ? this.decodeLocalDateTime(buf, 0) : null;
    }

    @Override
    public LocalDateTime decodeLocalDateTime(byte[] buf, int off) {
        return LocalDateTime.of(this.decodeLocalDate(buf, off), this.decodeLocalTime(buf, off + 4));
    }

    @Override
    public byte[] encodeLocalDateTime(LocalDateTime val) {
        if (val == null) {
            return null;
        }
        byte[] buf = new byte[8];
        this.encodeLocalDateTime(val, buf, 0);
        return buf;
    }

    @Override
    public void encodeLocalDateTime(LocalDateTime val, byte[] buf, int off) {
        this.encodeLocalDate(val.toLocalDate(), buf, off);
        this.encodeLocalTime(val.toLocalTime(), buf, off + 4);
    }

    protected byte[] networkOrder(byte[] buf) {
        return buf;
    }

    @Override
    public Decimal64 decodeDecimal64(byte[] buf) {
        return buf != null ? Decimal64.parseBytes(this.networkOrder(buf)) : null;
    }

    @Override
    public byte[] encodeDecimal64(Decimal64 val) {
        return val != null ? this.networkOrder(val.toBytes()) : null;
    }

    @Override
    public Decimal128 decodeDecimal128(byte[] buf) {
        return buf != null ? Decimal128.parseBytes(this.networkOrder(buf)) : null;
    }

    @Override
    public byte[] encodeDecimal128(Decimal128 val) {
        return val != null ? this.networkOrder(val.toBytes()) : null;
    }

    @Override
    public BigInteger decodeInt128(byte[] buf) {
        return buf != null ? new BigInteger(this.networkOrder(buf)) : null;
    }

    @Override
    public byte[] encodeInt128(BigInteger val) {
        if (val == null) {
            return null;
        }
        if (val.bitLength() > 127) {
            throw new IllegalArgumentException("Received BigInteger value requires more than 16 bytes storage");
        }
        byte[] minimumBytes = val.toByteArray();
        if (minimumBytes.length == 16) {
            return this.networkOrder(minimumBytes);
        }
        byte[] int128Bytes = new byte[16];
        int startOfMinimum = 16 - minimumBytes.length;
        if (val.signum() == -1) {
            Arrays.fill(int128Bytes, 0, startOfMinimum, (byte)-1);
        }
        System.arraycopy(minimumBytes, 0, int128Bytes, startOfMinimum, minimumBytes.length);
        return this.networkOrder(int128Bytes);
    }

    @Override
    public final IEncodingFactory getEncodingFactory() {
        return this.encodingFactory;
    }

    @Override
    public final EncodingDefinition getEncodingDefinition() {
        return this.encodingFactory.getDefaultEncodingDefinition();
    }

    @Override
    public final Encoding getEncoding() {
        return this.encoding;
    }

    @Override
    public final DatatypeCoder forEncodingDefinition(EncodingDefinition encodingDefinition) {
        if (this.getEncodingDefinition().equals(encodingDefinition)) {
            return this;
        }
        return this.getOrCreateForEncodingDefinition(encodingDefinition);
    }

    @Override
    public DatatypeCoder unwrap() {
        return this;
    }

    private DatatypeCoder getOrCreateForEncodingDefinition(EncodingDefinition encodingDefinition) {
        DatatypeCoder coder = (DatatypeCoder)this.encodingSpecificDatatypeCoders.get(encodingDefinition);
        if (coder != null) {
            return coder;
        }
        return this.createForEncodingDefinition(encodingDefinition);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private DatatypeCoder createForEncodingDefinition(EncodingDefinition encodingDefinition) {
        EncodingSpecificDatatypeCoder newCoder = new EncodingSpecificDatatypeCoder(this, encodingDefinition);
        DatatypeCoder coder = this.encodingSpecificDatatypeCoders.putIfAbsent(encodingDefinition, newCoder);
        if (coder != null) {
            return coder;
        }
        try {
            EncodingSpecificDatatypeCoder encodingSpecificDatatypeCoder = newCoder;
            return encodingSpecificDatatypeCoder;
        }
        finally {
            if (this.encodingSpecificDatatypeCoders.size() > DATATYPE_CODER_CACHE_SIZE) {
                this.performCacheMaintenance();
            }
        }
    }

    private void performCacheMaintenance() {
        if (this.cacheMaintenanceLock.tryLock()) {
            try {
                this.encodingSpecificDatatypeCoders.clear();
                ++this.cacheMaintenanceCount;
            }
            finally {
                this.cacheMaintenanceLock.unlock();
            }
            if (this.cacheMaintenanceCount % 10 == 1) {
                logger.log(System.Logger.Level.WARNING, "Cleared encoding specific datatype coder cache (current reset count: {0}). Consider setting system property org.firebirdsql.datatypeCoderCacheSize to a value higher than the current maximum size of {1}", this.cacheMaintenanceCount, DATATYPE_CODER_CACHE_SIZE);
            }
        }
    }

    @Override
    public final boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof DatatypeCoder)) {
            return false;
        }
        DatatypeCoder other = (DatatypeCoder)o;
        return this.getEncodingDefinition().equals(other.getEncodingDefinition()) && this.getClass() == other.unwrap().getClass();
    }

    @Override
    public final int hashCode() {
        return Objects.hash(this.getClass(), this.getEncodingDefinition());
    }
}

