/*
 * Decompiled with CFR 0.152.
 */
package org.firebirdsql.gds.impl.wire;

import java.io.BufferedOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Arrays;
import java.util.Objects;
import javax.crypto.Cipher;
import javax.crypto.CipherOutputStream;
import org.firebirdsql.encodings.Encoding;
import org.firebirdsql.gds.JaybirdSystemProperties;
import org.firebirdsql.gds.ParameterBuffer;
import org.firebirdsql.gds.impl.wire.EncryptedStreamSupport;
import org.firebirdsql.gds.impl.wire.FbDeflaterOutputStream;
import org.firebirdsql.gds.impl.wire.Xdrable;

public final class XdrOutputStream
extends BufferedOutputStream
implements EncryptedStreamSupport {
    private static final int BUF_SIZE;
    public static final int SPACE_BYTE = 32;
    public static final int NULL_BYTE = 0;
    private static final int TEXT_PAD_LENGTH;
    private static final byte[] TEXT_PAD;
    private static final int ZERO_PAD_LENGTH = 3;
    private static final byte[] ZERO_PADDING;
    private boolean compressed;
    private boolean encrypted;

    public XdrOutputStream(OutputStream out) {
        this(out, BUF_SIZE);
    }

    public XdrOutputStream(OutputStream out, int size) {
        super(out, Math.max(size, 8));
    }

    public void writeAlignment(int len) throws IOException {
        this.write(ZERO_PADDING, 0, 4 - len & 3);
    }

    public void writeZeroPadding(int len) throws IOException {
        byte[] padding = len <= 3 ? ZERO_PADDING : new byte[len];
        this.write(padding, 0, len);
    }

    public void writeSpacePadding(int len) throws IOException {
        byte[] padding = len <= TEXT_PAD_LENGTH ? TEXT_PAD : XdrOutputStream.createPadding(len, 32);
        this.write(padding, 0, len);
    }

    public void writePadding(int len, int padByte) throws IOException {
        if (padByte == 32) {
            this.writeSpacePadding(len);
        } else if (padByte == 0) {
            this.writeZeroPadding(len);
        } else {
            byte[] padding = XdrOutputStream.createPadding(len, (byte)padByte);
            this.write(padding, 0, len);
        }
    }

    private static byte[] createPadding(int len, int padByte) {
        byte[] padding = new byte[len];
        Arrays.fill(padding, (byte)padByte);
        return padding;
    }

    public void writeBuffer(byte[] buf) throws IOException {
        if (buf == null) {
            this.writeInt(0);
        } else {
            this.writeBuffer(buf, 0, buf.length);
        }
    }

    public void writeBuffer(byte[] buf, int off, int len) throws IOException {
        Objects.checkFromIndexSize(off, len, buf.length);
        this.writeInt(len);
        this.write(buf, off, len, 4 - len & 3);
    }

    public void writeString(String s, Encoding encoding) throws IOException {
        byte[] buffer = encoding != null ? encoding.encodeToCharset(s) : s.getBytes();
        this.writeBuffer(buffer);
    }

    public void writeTyped(int type, Xdrable item) throws IOException {
        int size;
        if (item == null) {
            this.writeInt(1);
            this.write(type);
            size = 1;
        } else {
            size = item.getLength() + 1;
            this.writeInt(size);
            this.write(type);
            item.write(this);
        }
        this.writeAlignment(size);
    }

    public void writeTyped(ParameterBuffer parameterBuffer) throws IOException {
        this.writeTyped(parameterBuffer.getType(), parameterBuffer.toXdrable());
    }

    public void writeLong(long v) throws IOException {
        if (this.buf.length - this.count < 8) {
            this.flushBuffer();
        }
        this.buf[this.count++] = (byte)(v >>> 56);
        this.buf[this.count++] = (byte)(v >>> 48);
        this.buf[this.count++] = (byte)(v >>> 40);
        this.buf[this.count++] = (byte)(v >>> 32);
        this.buf[this.count++] = (byte)(v >>> 24);
        this.buf[this.count++] = (byte)(v >>> 16);
        this.buf[this.count++] = (byte)(v >>> 8);
        this.buf[this.count++] = (byte)v;
    }

    public void writeInt(int v) throws IOException {
        if (this.buf.length - this.count < 4) {
            this.flushBuffer();
        }
        this.buf[this.count++] = (byte)(v >>> 24);
        this.buf[this.count++] = (byte)(v >>> 16);
        this.buf[this.count++] = (byte)(v >>> 8);
        this.buf[this.count++] = (byte)v;
    }

    public void write(byte[] b, int off, int len, int pad) throws IOException {
        this.write(b, off, len);
        this.writeSpacePadding(pad);
    }

    @Override
    public void write(byte[] b, int off, int len) throws IOException {
        super.write(b, off, len);
    }

    @Override
    public void close() throws IOException {
        try {
            super.close();
        }
        finally {
            this.buf = new byte[8];
        }
    }

    public void enableCompression() throws IOException {
        if (this.compressed) {
            throw new IOException("Output stream already compressed");
        }
        this.out = new FbDeflaterOutputStream(this.out);
        this.compressed = true;
    }

    @Override
    public void setCipher(Cipher cipher) throws IOException {
        if (this.encrypted) {
            throw new IOException("Output stream already encrypted");
        }
        this.flush();
        OutputStream currentStream = this.out;
        if (currentStream instanceof EncryptedStreamSupport) {
            EncryptedStreamSupport encryptedStreamSupport = (EncryptedStreamSupport)((Object)currentStream);
            encryptedStreamSupport.setCipher(cipher);
        } else {
            this.out = new CipherOutputStream(currentStream, cipher);
        }
        this.encrypted = true;
    }

    public void writeDirect(byte[] data) throws IOException {
        this.out.write(data);
        this.out.flush();
    }

    private void flushBuffer() throws IOException {
        if (this.count > 0) {
            this.out.write(this.buf, 0, this.count);
            this.count = 0;
        }
    }

    static {
        TEXT_PAD_LENGTH = BUF_SIZE = Math.max(1024, JaybirdSystemProperties.getWireOutputBufferSize(Short.MAX_VALUE));
        TEXT_PAD = XdrOutputStream.createPadding(BUF_SIZE, 32);
        ZERO_PADDING = new byte[3];
    }
}

