/*
 * Decompiled with CFR 0.152.
 */
package org.firebirdsql.gds.impl;

import java.sql.SQLException;
import java.util.Objects;
import java.util.TimeZone;
import java.util.function.Predicate;
import java.util.regex.Pattern;
import org.firebirdsql.gds.TransactionParameterBuffer;
import org.firebirdsql.gds.ng.BlobConfig;
import org.firebirdsql.gds.ng.FbBlob;
import org.firebirdsql.gds.ng.FbDatabase;
import org.firebirdsql.gds.ng.FbStatement;
import org.firebirdsql.gds.ng.FbTransaction;
import org.firebirdsql.gds.ng.IConnectionProperties;
import org.firebirdsql.gds.ng.LockCloseable;
import org.firebirdsql.gds.ng.TransactionState;

public final class GDSHelper {
    private static final Predicate<String> OFFSET_ZONE_NAME_PREDICATE = Pattern.compile("[+-]\\d{2}:\\d{2}").asMatchPredicate();
    private final FbDatabase database;
    private FbTransaction transaction;
    private TimeZone sessionTimeZone;

    public GDSHelper(FbDatabase database) {
        this.database = Objects.requireNonNull(database, "database");
    }

    public FbTransaction getCurrentTransaction() {
        try (LockCloseable ignored = this.withLock();){
            FbTransaction fbTransaction = this.transaction;
            return fbTransaction;
        }
    }

    public void setCurrentTransaction(FbTransaction transaction) {
        try (LockCloseable ignored = this.withLock();){
            this.transaction = transaction;
        }
    }

    public FbDatabase getCurrentDatabase() {
        return this.database;
    }

    public IConnectionProperties getConnectionProperties() {
        return this.database.getConnectionProperties();
    }

    public int getDialect() {
        return this.database.getConnectionDialect();
    }

    public FbStatement allocateStatement() throws SQLException {
        return this.database.createStatement(this.getCurrentTransaction());
    }

    public boolean inTransaction() {
        try (LockCloseable ignored = this.withLock();){
            boolean bl = this.transaction != null && this.transaction.getState() == TransactionState.ACTIVE;
            return bl;
        }
    }

    public void executeImmediate(String statement) throws SQLException {
        this.database.executeImmediate(statement, this.getCurrentTransaction());
    }

    public FbBlob openBlob(long blobId, BlobConfig blobConfig) throws SQLException {
        FbBlob blob = this.database.createBlobForInput(this.getCurrentTransaction(), blobConfig, blobId);
        blob.open();
        return blob;
    }

    public FbBlob createBlob(BlobConfig blobConfig) throws SQLException {
        FbBlob blob = this.database.createBlobForOutput(this.getCurrentTransaction(), blobConfig);
        blob.open();
        return blob;
    }

    @Deprecated(forRemoval=true, since="6")
    public FbTransaction startTransaction(TransactionParameterBuffer tpb) throws SQLException {
        FbTransaction newTx = this.database.startTransaction(tpb);
        this.setCurrentTransaction(newTx);
        return newTx;
    }

    public void detachDatabase() throws SQLException {
        this.database.close();
    }

    public void cancelOperation() throws SQLException {
        this.database.cancelOperation(3);
    }

    public String getDatabaseProductName() {
        return this.database.getServerVersion().getServerName();
    }

    public String getDatabaseProductVersion() {
        return this.database.getServerVersion().getFullVersion();
    }

    public int getDatabaseProductMajorVersion() {
        return this.database.getServerVersion().getMajorVersion();
    }

    public int getDatabaseProductMinorVersion() {
        return this.database.getServerVersion().getMinorVersion();
    }

    public int compareToVersion(int major, int minor) {
        int differenceMajor = this.getDatabaseProductMajorVersion() - major;
        if (differenceMajor == 0) {
            return this.getDatabaseProductMinorVersion() - minor;
        }
        return differenceMajor;
    }

    public int compareToVersion(int major) {
        return this.getDatabaseProductMajorVersion() - major;
    }

    public String getUserName() {
        return this.database.getConnectionProperties().getUser();
    }

    public TimeZone getSessionTimeZone() {
        if (this.sessionTimeZone == null) {
            return this.initSessionTimeZone();
        }
        return this.sessionTimeZone;
    }

    private TimeZone initSessionTimeZone() {
        String sessionTimeZoneName = this.database.getConnectionProperties().getSessionTimeZone();
        if (sessionTimeZoneName == null || "server".equalsIgnoreCase(sessionTimeZoneName)) {
            this.sessionTimeZone = TimeZone.getDefault();
            return this.sessionTimeZone;
        }
        TimeZone timeZone = GDSHelper.getTimeZone(sessionTimeZoneName);
        if ("GMT".equals(timeZone.getID()) && !"GMT".equalsIgnoreCase(sessionTimeZoneName)) {
            System.getLogger(this.getClass().getName()).log(System.Logger.Level.WARNING, "TimeZone fallback to GMT from {0}; possible cause: value of sessionTimeZone unknown in Java. Time and Timestamp values may yield unexpected values. Consider setting a different value for sessionTimeZone", sessionTimeZoneName);
        }
        this.sessionTimeZone = timeZone;
        return this.sessionTimeZone;
    }

    private static TimeZone getTimeZone(String timeZoneName) {
        if (OFFSET_ZONE_NAME_PREDICATE.test((String)timeZoneName)) {
            timeZoneName = "GMT" + (String)timeZoneName;
        }
        return TimeZone.getTimeZone((String)timeZoneName);
    }

    public LockCloseable withLock() {
        return this.database.withLock();
    }
}

