/*
 * Decompiled with CFR 0.152.
 */
package org.firebirdsql.gds;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.firebirdsql.gds.DefaultMessageTemplate;
import org.firebirdsql.gds.MessageLoader;
import org.firebirdsql.gds.MessageTemplate;
import org.firebirdsql.jaybird.util.CollectionUtils;
import org.jspecify.annotations.NullMarked;
import org.jspecify.annotations.Nullable;

@NullMarked
final class MessageLookup {
    private static final int ISC_MASK = 0x14000000;
    private static final int FAC_MASK = 0xFF0000;
    private static final int CODE_MASK = 65535;
    static final int JAYBIRD_FACILITY = 26;
    private static final int MAX_FACILITY = 26;
    static final int FACILITY_SIZE = 27;
    private static final MessageTemplate[] FACILITY_NOT_LOADED = new MessageTemplate[0];
    private final @Nullable MessageTemplate[][] messageTemplates = new MessageTemplate[27][];
    private final ReadWriteLock rwLock = new ReentrantReadWriteLock();
    private final Lock readLock = this.rwLock.readLock();
    private final Lock writeLock = this.rwLock.writeLock();

    MessageLookup() {
        Arrays.fill((Object[])this.messageTemplates, FACILITY_NOT_LOADED);
    }

    MessageTemplate getMessageTemplate(int errorCode) {
        if (MessageLookup.isInvalidErrorCode(errorCode)) {
            return DefaultMessageTemplate.notFound(errorCode);
        }
        try {
            @Nullable MessageTemplate[] facilityTemplates = this.getFacilityTemplates(MessageLookup.getFacility(errorCode));
            int code = MessageLookup.getCode(errorCode);
            MessageTemplate template = facilityTemplates[code];
            if (template == null) {
                template = facilityTemplates[code] = DefaultMessageTemplate.notFound(errorCode);
            }
            return template;
        }
        catch (ArrayIndexOutOfBoundsException e) {
            return DefaultMessageTemplate.notFound(errorCode);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private @Nullable MessageTemplate[] getFacilityTemplates(int facility) {
        if (facility < 0 || facility > 26) {
            return FACILITY_NOT_LOADED;
        }
        this.readLock.lock();
        try {
            @Nullable MessageTemplate[] facilityTemplates = this.messageTemplates[facility];
            if (facilityTemplates != FACILITY_NOT_LOADED) {
                MessageTemplate[] messageTemplateArray = facilityTemplates;
                return messageTemplateArray;
            }
        }
        finally {
            this.readLock.unlock();
        }
        return this.loadFacilityTemplates(facility);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private @Nullable MessageTemplate[] loadFacilityTemplates(int facility) {
        this.writeLock.lock();
        try {
            @Nullable MessageTemplate[] facilityTemplates = this.messageTemplates[facility];
            if (facilityTemplates != FACILITY_NOT_LOADED) {
                MessageTemplate[] messageTemplateArray = facilityTemplates;
                return messageTemplateArray;
            }
            ArrayList indexedByCode = new ArrayList();
            MessageLoader.loadMessageTemplates(facility).forEach(template -> {
                int errorCode = template.errorCode();
                if (MessageLookup.isInvalidErrorCode(errorCode) || MessageLookup.getFacility(errorCode) != facility) {
                    System.getLogger(MessageLookup.class.getName()).log(System.Logger.Level.DEBUG, "Invalid error code or error code with out-of-range facility: {}", errorCode);
                    return;
                }
                int code = MessageLookup.getCode(errorCode);
                CollectionUtils.growToSize(indexedByCode, code + 1);
                if (indexedByCode.set(code, template) != null) {
                    System.getLogger(MessageLookup.class.getName()).log(System.Logger.Level.DEBUG, "Duplicate error code: {}", errorCode);
                }
            });
            this.messageTemplates[facility] = (MessageTemplate[])indexedByCode.toArray(MessageTemplate[]::new);
            MessageTemplate[] messageTemplateArray = this.messageTemplates[facility];
            return messageTemplateArray;
        }
        finally {
            this.writeLock.unlock();
        }
    }

    private static boolean isInvalidErrorCode(int errorCode) {
        return (errorCode & 0x14000000) != 0x14000000;
    }

    static int getFacility(int errorCode) {
        return (errorCode & 0xFF0000) >> 16;
    }

    static int getCode(int errorCode) {
        return errorCode & 0xFFFF;
    }
}

