/*
 * Decompiled with CFR 0.152.
 */
package org.firebirdsql.encodings;

import java.nio.charset.Charset;
import java.nio.charset.IllegalCharsetNameException;
import java.nio.charset.UnsupportedCharsetException;
import java.util.Objects;
import org.firebirdsql.encodings.Encoding;
import org.firebirdsql.encodings.EncodingDefinition;
import org.firebirdsql.encodings.EncodingGeneric;

public final class DefaultEncodingDefinition
implements EncodingDefinition {
    private static final System.Logger logger = System.getLogger(DefaultEncodingDefinition.class.getName());
    private static final Encoding NOT_INITIALIZED = new EncodingGeneric(null);
    private final String charsetName;
    private final String firebirdEncodingName;
    private final int maxBytesPerChar;
    private final int firebirdCharacterSetId;
    private final boolean firebirdOnly;
    private Encoding encoding = NOT_INITIALIZED;
    private Charset charset;

    public DefaultEncodingDefinition(String firebirdEncodingName, Charset charset, int maxBytesPerChar, int firebirdCharacterSetId, boolean firebirdOnly) {
        this(firebirdEncodingName, charset != null ? charset.name() : null, maxBytesPerChar, firebirdCharacterSetId, firebirdOnly);
        this.charset = charset;
    }

    public DefaultEncodingDefinition(String firebirdEncodingName, String charsetName, int maxBytesPerChar, int firebirdCharacterSetId, boolean firebirdOnly) {
        this.firebirdEncodingName = Objects.requireNonNull(firebirdEncodingName, "firebirdEncodingName");
        this.charsetName = charsetName;
        if (charsetName == null) {
            this.encoding = null;
        }
        this.maxBytesPerChar = maxBytesPerChar;
        this.firebirdOnly = firebirdOnly;
        this.firebirdCharacterSetId = firebirdCharacterSetId;
    }

    @Override
    public int getMaxBytesPerChar() {
        return this.maxBytesPerChar;
    }

    @Override
    public String getJavaEncodingName() {
        return this.charsetName;
    }

    @Override
    public Charset getJavaCharset() {
        if (this.charset == null && this.encoding == NOT_INITIALIZED) {
            this.initCharset();
        }
        return this.charset;
    }

    @Override
    public String getFirebirdEncodingName() {
        return this.firebirdEncodingName;
    }

    @Override
    public int getFirebirdCharacterSetId() {
        return this.firebirdCharacterSetId;
    }

    @Override
    public boolean isFirebirdOnly() {
        return this.firebirdOnly;
    }

    @Override
    public boolean isInformationOnly() {
        return this.charsetName == null || this.getJavaCharset() == null;
    }

    @Override
    public Encoding getEncoding() {
        if (this.encoding == NOT_INITIALIZED) {
            this.initEncoding();
        }
        return this.encoding;
    }

    public String toString() {
        return "[firebirdEncodingName='" + this.getFirebirdEncodingName() + "',javaEncodingName='" + this.getJavaEncodingName() + "',maxBytesPerChar=" + this.getMaxBytesPerChar() + ",firebirdOnly=" + this.isFirebirdOnly() + ",firebirdCharacterSetId=" + this.getFirebirdCharacterSetId() + "]";
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        DefaultEncodingDefinition that = (DefaultEncodingDefinition)o;
        return this.maxBytesPerChar == that.maxBytesPerChar && this.firebirdCharacterSetId == that.firebirdCharacterSetId && this.firebirdOnly == that.firebirdOnly && Objects.equals(this.charsetName, that.charsetName) && this.firebirdEncodingName.equals(that.firebirdEncodingName);
    }

    public int hashCode() {
        int result = this.charsetName != null ? this.charsetName.hashCode() : 0;
        result = 31 * result + this.firebirdCharacterSetId;
        return result;
    }

    private void initCharset() {
        try {
            this.charset = Charset.forName(this.charsetName);
        }
        catch (IllegalCharsetNameException | UnsupportedCharsetException e) {
            this.encoding = null;
            logger.log(System.Logger.Level.WARNING, "charsetName=\"{0}\" specified for Firebird encoding \"{1}\" is an illegal or unsupported character set name, handling as information-only; see debug level for stacktrace", this.charsetName, this.firebirdEncodingName);
            logger.log(System.Logger.Level.DEBUG, "Exception for illegal or unsupported character set name", (Throwable)e);
        }
    }

    private void initEncoding() {
        this.encoding = this.isInformationOnly() ? null : new EncodingGeneric(this.getJavaCharset());
    }
}

