/*
 * Decompiled with CFR 0.152.
 */
package org.apache.metamodel.csv;

import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.io.RandomAccessFile;
import java.io.Writer;
import java.nio.ByteBuffer;
import java.nio.channels.FileChannel;
import java.nio.charset.Charset;
import org.apache.metamodel.AbstractUpdateCallback;
import org.apache.metamodel.DataContext;
import org.apache.metamodel.MetaModelException;
import org.apache.metamodel.MetaModelHelper;
import org.apache.metamodel.UpdateCallback;
import org.apache.metamodel.create.TableCreationBuilder;
import org.apache.metamodel.csv.CsvConfiguration;
import org.apache.metamodel.csv.CsvCreateTableBuilder;
import org.apache.metamodel.csv.CsvDataContext;
import org.apache.metamodel.csv.CsvDeleteBuilder;
import org.apache.metamodel.csv.CsvInsertBuilder;
import org.apache.metamodel.csv.CsvTable;
import org.apache.metamodel.csv.CsvTableDropBuilder;
import org.apache.metamodel.csv.CsvWriter;
import org.apache.metamodel.delete.RowDeletionBuilder;
import org.apache.metamodel.drop.TableDropBuilder;
import org.apache.metamodel.insert.RowInsertionBuilder;
import org.apache.metamodel.schema.Schema;
import org.apache.metamodel.schema.Table;
import org.apache.metamodel.update.RowUpdationBuilder;
import org.apache.metamodel.util.Action;
import org.apache.metamodel.util.EqualsBuilder;
import org.apache.metamodel.util.FileHelper;
import org.apache.metamodel.util.FileResource;
import org.apache.metamodel.util.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

final class CsvUpdateCallback
extends AbstractUpdateCallback
implements UpdateCallback {
    private static final Logger logger = LoggerFactory.getLogger(CsvUpdateCallback.class);
    private final CsvConfiguration _configuration;
    private final Resource _resource;
    private Writer _writer;

    public CsvUpdateCallback(CsvDataContext dataContext) {
        super((DataContext)dataContext);
        this._resource = dataContext.getResource();
        this._configuration = dataContext.getConfiguration();
    }

    public TableCreationBuilder createTable(Schema schema, String name) throws IllegalArgumentException, IllegalStateException {
        return new CsvCreateTableBuilder(this, MetaModelHelper.resolveUnderlyingSchema((Schema)schema), name);
    }

    public RowInsertionBuilder insertInto(Table table) throws IllegalArgumentException, IllegalStateException {
        this.validateTable(table);
        return new CsvInsertBuilder(this, table);
    }

    public CsvConfiguration getConfiguration() {
        return this._configuration;
    }

    public Resource getResource() {
        return this._resource;
    }

    private void validateTable(Table table) {
        if (!(table instanceof CsvTable)) {
            throw new IllegalArgumentException("Not a valid CSV table: " + table);
        }
    }

    protected synchronized void writeRow(String[] stringValues, boolean append) {
        CsvWriter csvWriter = new CsvWriter(this._configuration);
        String line = csvWriter.buildLine(stringValues);
        Writer writer = this.getWriter(append);
        try {
            writer.write(line);
        }
        catch (IOException e) {
            throw new MetaModelException("Failed to write line: " + line, (Exception)e);
        }
    }

    private Writer getWriter(boolean append) {
        if (this._writer == null || !append) {
            boolean needsLineBreak = CsvUpdateCallback.needsLineBreak(this._resource, this._configuration);
            OutputStream out = append ? this._resource.append() : this._resource.write();
            boolean insertBom = !append;
            Writer writer = FileHelper.getWriter((OutputStream)out, (String)this._configuration.getEncoding(), (boolean)insertBom);
            if (needsLineBreak) {
                try {
                    writer.write(10);
                }
                catch (IOException e) {
                    logger.debug("Failed to insert newline", (Throwable)e);
                }
            }
            this._writer = writer;
        }
        return this._writer;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected static boolean needsLineBreak(Resource resource, CsvConfiguration configuration) {
        if (!resource.isExists() || resource.getSize() == 0L) {
            return false;
        }
        if (resource instanceof FileResource) {
            File file = ((FileResource)resource).getFile();
            try {
                ByteBuffer encodedLineBreak = Charset.forName(configuration.getEncoding()).encode("\n");
                byte[] bytesInLineBreak = new byte[encodedLineBreak.capacity()];
                encodedLineBreak.get(bytesInLineBreak);
                byte[] bytesFromFile = new byte[bytesInLineBreak.length];
                try (RandomAccessFile randomAccessFile = new RandomAccessFile(file, "r");
                     FileChannel channel = randomAccessFile.getChannel();){
                    long length = randomAccessFile.length();
                    channel = channel.position(length - (long)bytesInLineBreak.length);
                    channel.read(ByteBuffer.wrap(bytesFromFile));
                }
                return !EqualsBuilder.equals((Object)bytesInLineBreak, (Object)bytesFromFile);
            }
            catch (Exception e) {
                logger.error("Error occurred while checking if file needs linebreak, omitting check", (Throwable)e);
            }
        }
        return false;
    }

    protected void close() {
        if (this._writer != null) {
            try {
                this._writer.flush();
            }
            catch (IOException e) {
                logger.warn("Failed to flush CSV writer", (Throwable)e);
            }
            try {
                this._writer.close();
            }
            catch (IOException e) {
                logger.error("Failed to close CSV writer", (Throwable)e);
            }
            finally {
                this._writer = null;
            }
        }
    }

    public RowUpdationBuilder update(Table table) throws IllegalArgumentException, IllegalStateException {
        this.close();
        return super.update(table);
    }

    public boolean isDropTableSupported() {
        return true;
    }

    public TableDropBuilder dropTable(Table table) {
        this.validateTable(table);
        return new CsvTableDropBuilder(this, table);
    }

    protected void dropTable() {
        this.close();
        if (this._resource instanceof FileResource) {
            File file = ((FileResource)this._resource).getFile();
            boolean success = file.delete();
            if (!success) {
                throw new MetaModelException("Could not delete (drop) file: " + file);
            }
        } else {
            this._resource.write((Action)new Action<OutputStream>(){

                public void run(OutputStream arg) throws Exception {
                }
            });
        }
    }

    public boolean isDeleteSupported() {
        return true;
    }

    public RowDeletionBuilder deleteFrom(Table table) {
        this.validateTable(table);
        return new CsvDeleteBuilder(this, table);
    }
}

