/*
 * Decompiled with CFR 0.152.
 */
package org.apache.metamodel.csv;

import java.io.File;
import java.io.InputStream;
import java.io.OutputStream;
import org.apache.metamodel.MetaModelException;
import org.apache.metamodel.UpdateCallback;
import org.apache.metamodel.UpdateScript;
import org.apache.metamodel.csv.CsvConfiguration;
import org.apache.metamodel.csv.CsvDataContext;
import org.apache.metamodel.csv.CsvUpdateCallback;
import org.apache.metamodel.data.DataSet;
import org.apache.metamodel.data.Row;
import org.apache.metamodel.delete.AbstractRowDeletionBuilder;
import org.apache.metamodel.schema.Table;
import org.apache.metamodel.util.Action;
import org.apache.metamodel.util.FileHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

final class CsvDeleteBuilder
extends AbstractRowDeletionBuilder {
    private static final Logger logger = LoggerFactory.getLogger(CsvDeleteBuilder.class);
    private final CsvUpdateCallback _updateCallback;

    public CsvDeleteBuilder(CsvUpdateCallback updateCallback, Table table) {
        super(table);
        this._updateCallback = updateCallback;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void execute() throws MetaModelException {
        File tempFile = FileHelper.createTempFile((String)"metamodel_deletion", (String)"csv");
        CsvConfiguration configuration = this._updateCallback.getConfiguration();
        final CsvDataContext copyDataContext = new CsvDataContext(tempFile, configuration);
        copyDataContext.executeUpdate(new UpdateScript(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void run(UpdateCallback callback) {
                Table originalTable = CsvDeleteBuilder.this.getTable();
                Table copyTable = callback.createTable(copyDataContext.getDefaultSchema(), originalTable.getName()).like(originalTable).execute();
                if (CsvDeleteBuilder.this.isTruncateTableOperation()) {
                    return;
                }
                try (DataSet dataSet = CsvDeleteBuilder.this._updateCallback.getDataContext().query().from(originalTable).select(originalTable.getColumns()).execute();){
                    while (dataSet.next()) {
                        Row row = dataSet.getRow();
                        if (CsvDeleteBuilder.this.deleteRow(row)) continue;
                        callback.insertInto(copyTable).like(row).execute();
                    }
                }
            }
        });
        final InputStream in = FileHelper.getInputStream((File)tempFile);
        try {
            this._updateCallback.getResource().write((Action)new Action<OutputStream>(){

                public void run(OutputStream out) throws Exception {
                    FileHelper.copy((InputStream)in, (OutputStream)out);
                }
            });
        }
        catch (Throwable throwable) {
            FileHelper.safeClose((Object[])new Object[]{in});
            throw throwable;
        }
        FileHelper.safeClose((Object[])new Object[]{in});
        boolean deleted = tempFile.delete();
        if (!deleted) {
            logger.warn("Could not delete temporary copy-file: {}", (Object)tempFile);
        }
    }
}

