/*
 * Decompiled with CFR 0.152.
 */
package org.apache.metamodel.csv;

import org.apache.metamodel.DataContext;
import org.apache.metamodel.csv.CsvConfiguration;
import org.apache.metamodel.csv.CsvDataContext;
import org.apache.metamodel.factory.AbstractDataContextFactory;
import org.apache.metamodel.factory.DataContextProperties;
import org.apache.metamodel.factory.ResourceFactoryRegistry;
import org.apache.metamodel.schema.naming.ColumnNamingStrategy;
import org.apache.metamodel.schema.naming.CustomColumnNamingStrategy;
import org.apache.metamodel.util.Resource;
import org.apache.metamodel.util.SimpleTableDef;

public class CsvDataContextFactory
extends AbstractDataContextFactory {
    protected String getType() {
        return "csv";
    }

    public DataContext create(DataContextProperties properties, ResourceFactoryRegistry resourceFactoryRegistry) {
        CustomColumnNamingStrategy columnNamingStrategy;
        assert (this.accepts(properties, resourceFactoryRegistry));
        Resource resource = resourceFactoryRegistry.createResource(properties.getResourceProperties());
        int columnNameLineNumber = this.getInt(properties.getColumnNameLineNumber(), 1);
        String encoding = this.getString(properties.getEncoding(), "UTF-8");
        char separatorChar = this.getChar(properties.getSeparatorChar(), ',');
        char quoteChar = this.getChar(properties.getQuoteChar(), '\"');
        char escapeChar = this.getChar(properties.getEscapeChar(), '\\');
        boolean failOnInconsistentRowLength = this.getBoolean(properties.isFailOnInconsistentRowLength(), false);
        boolean multilineValuesEnabled = this.getBoolean(properties.isMultilineValuesEnabled(), true);
        if (properties.getTableDefs() == null) {
            columnNamingStrategy = null;
        } else {
            SimpleTableDef firstTable = properties.getTableDefs()[0];
            String[] columnNames = firstTable.getColumnNames();
            columnNamingStrategy = new CustomColumnNamingStrategy(columnNames);
        }
        CsvConfiguration configuration = new CsvConfiguration(columnNameLineNumber, (ColumnNamingStrategy)columnNamingStrategy, encoding, separatorChar, quoteChar, escapeChar, failOnInconsistentRowLength, multilineValuesEnabled);
        return new CsvDataContext(resource, configuration);
    }
}

