/*
 * Decompiled with CFR 0.152.
 */
package org.apache.metamodel.util;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.UnsupportedEncodingException;
import java.io.Writer;
import java.nio.charset.Charset;

public class UnicodeWriter
extends Writer {
    public static final byte[] UTF8_BOM = new byte[]{-17, -69, -65};
    public static final byte[] UTF16LE_BOM = new byte[]{-1, -2};
    public static final byte[] UTF16BE_BOM = new byte[]{-2, -1};
    public static final byte[] UTF32LE_BOM = new byte[]{-1, -2, 0, 0};
    public static final byte[] UTF32BE_BOM = new byte[]{0, 0, -2, -1};
    private final OutputStreamWriter writer;

    public UnicodeWriter(String fileName, String encoding) throws UnsupportedEncodingException, IOException {
        this((OutputStream)new FileOutputStream(fileName), encoding);
    }

    public UnicodeWriter(File file, String encoding) throws UnsupportedEncodingException, IOException {
        this((OutputStream)new FileOutputStream(file), encoding);
    }

    public UnicodeWriter(OutputStream outputStream, String encoding) throws UnsupportedEncodingException, IOException {
        this(outputStream, Charset.forName(encoding));
    }

    public UnicodeWriter(OutputStream outputStream, Charset charset) throws UnsupportedEncodingException, IOException {
        this.writer = this.createWriter(outputStream, charset);
    }

    @Override
    public void close() throws IOException {
        this.writer.close();
    }

    @Override
    public void flush() throws IOException {
        this.writer.flush();
    }

    private OutputStreamWriter createWriter(OutputStream outputStream, Charset charset) throws UnsupportedEncodingException, IOException {
        OutputStreamWriter writer = new OutputStreamWriter(outputStream, charset);
        String encoding = charset.name().replaceAll("-", "").toUpperCase();
        if ("UTF8".equals(encoding)) {
            outputStream.write(UTF8_BOM, 0, UTF8_BOM.length);
        } else if ("UTF16LE".equals(encoding)) {
            outputStream.write(UTF16LE_BOM, 0, UTF16LE_BOM.length);
        } else if ("UTF16BE".equals(encoding)) {
            outputStream.write(UTF16BE_BOM, 0, UTF16BE_BOM.length);
        } else if ("UTF32LE".equals(encoding)) {
            outputStream.write(UTF32LE_BOM, 0, UTF32LE_BOM.length);
        } else if ("UTF32".equals(encoding) || "UTF32BE".equals(encoding)) {
            outputStream.write(UTF32BE_BOM, 0, UTF32BE_BOM.length);
        }
        return writer;
    }

    @Override
    public void write(char[] cbuf, int off, int len) throws IOException {
        this.writer.write(cbuf, off, len);
    }

    @Override
    public void write(int c) throws IOException {
        this.writer.write(c);
    }

    @Override
    public void write(String str, int off, int len) throws IOException {
        this.writer.write(str, off, len);
    }
}

