/*
 * Decompiled with CFR 0.152.
 */
package org.apache.metamodel.util;

import java.util.ArrayList;
import org.apache.metamodel.schema.ColumnType;
import org.apache.metamodel.schema.ColumnTypeImpl;
import org.apache.metamodel.util.SimpleTableDef;

public class SimpleTableDefParser {
    public static SimpleTableDef[] parseTableDefs(String tableDefinitionsText) {
        String[] tableDefinitionTexts;
        if (tableDefinitionsText == null) {
            return null;
        }
        tableDefinitionsText = tableDefinitionsText.replaceAll("\n", "").replaceAll("\t", "").replaceAll("\r", "").replaceAll("  ", " ");
        ArrayList<SimpleTableDef> tableDefs = new ArrayList<SimpleTableDef>();
        for (String tableDefinitionText : tableDefinitionTexts = tableDefinitionsText.split(";")) {
            SimpleTableDef tableDef = SimpleTableDefParser.parseTableDef(tableDefinitionText);
            if (tableDef == null) continue;
            tableDefs.add(tableDef);
        }
        if (tableDefs.isEmpty()) {
            return null;
        }
        return tableDefs.toArray(new SimpleTableDef[tableDefs.size()]);
    }

    protected static SimpleTableDef parseTableDef(String tableDefinitionText) {
        if (tableDefinitionText == null || tableDefinitionText.trim().isEmpty()) {
            return null;
        }
        int startColumnSection = tableDefinitionText.indexOf("(");
        if (startColumnSection == -1) {
            throw new IllegalArgumentException("Failed to parse table definition: " + tableDefinitionText + ". No start parenthesis found for column section.");
        }
        int endColumnSection = tableDefinitionText.indexOf(")", startColumnSection);
        if (endColumnSection == -1) {
            throw new IllegalArgumentException("Failed to parse table definition: " + tableDefinitionText + ". No end parenthesis found for column section.");
        }
        String tableName = tableDefinitionText.substring(0, startColumnSection).trim();
        if (tableName.isEmpty()) {
            throw new IllegalArgumentException("Failed to parse table definition: " + tableDefinitionText + ". No table name found.");
        }
        String columnSection = tableDefinitionText.substring(startColumnSection + 1, endColumnSection);
        String[] columnDefinitionTexts = columnSection.split(",");
        ArrayList<String> columnNames = new ArrayList<String>();
        ArrayList<ColumnType> columnTypes = new ArrayList<ColumnType>();
        for (String columnDefinition : columnDefinitionTexts) {
            if ((columnDefinition = columnDefinition.trim()).isEmpty()) continue;
            int separator = columnDefinition.lastIndexOf(" ");
            String columnName = columnDefinition.substring(0, separator).trim();
            String columnTypeString = columnDefinition.substring(separator).trim();
            ColumnType columnType = ColumnTypeImpl.valueOf(columnTypeString);
            columnNames.add(columnName);
            columnTypes.add(columnType);
        }
        return new SimpleTableDef(tableName, columnNames.toArray(new String[columnNames.size()]), columnTypes.toArray(new ColumnType[columnTypes.size()]));
    }
}

