/*
 * Decompiled with CFR 0.152.
 */
package org.apache.metamodel.util;

import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.Comparator;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class NumberComparator
implements Comparator<Object> {
    private static final Logger logger = LoggerFactory.getLogger(NumberComparator.class);
    private static final Comparator<Object> _instance = new NumberComparator();

    public static Comparator<Object> getComparator() {
        return _instance;
    }

    private NumberComparator() {
    }

    public static Comparable<Object> getComparable(Object o) {
        final Number n = NumberComparator.toNumber(o);
        return new Comparable<Object>(){

            public boolean equals(Object obj) {
                return _instance.equals(obj);
            }

            @Override
            public int compareTo(Object o) {
                return _instance.compare(n, o);
            }

            public String toString() {
                return "NumberComparable[number=" + n + "]";
            }
        };
    }

    @Override
    public int compare(Object o1, Object o2) {
        Number n1 = NumberComparator.toNumber(o1);
        Number n2 = NumberComparator.toNumber(o2);
        if (n1 == null && n2 == null) {
            return 0;
        }
        if (n1 == null) {
            return -1;
        }
        if (n2 == null) {
            return 1;
        }
        if (n1 instanceof BigInteger && n2 instanceof BigInteger) {
            return ((BigInteger)n1).compareTo((BigInteger)n2);
        }
        if (n1 instanceof BigDecimal && n2 instanceof BigDecimal) {
            return ((BigDecimal)n1).compareTo((BigDecimal)n2);
        }
        if (NumberComparator.isIntegerType(n1) && NumberComparator.isIntegerType(n2)) {
            return Long.valueOf(n1.longValue()).compareTo(n2.longValue());
        }
        return Double.valueOf(n1.doubleValue()).compareTo(n2.doubleValue());
    }

    public static boolean isIntegerType(Number n) {
        return n instanceof Byte || n instanceof Short || n instanceof Integer || n instanceof Long || n instanceof AtomicInteger || n instanceof AtomicLong;
    }

    public static Number toNumber(Object value) {
        if (value == null) {
            return null;
        }
        if (value instanceof Number) {
            return (Number)value;
        }
        if (value instanceof Boolean) {
            if (Boolean.TRUE.equals(value)) {
                return 1;
            }
            return 0;
        }
        String stringValue = value.toString().trim();
        if (stringValue.isEmpty()) {
            return null;
        }
        try {
            return Integer.parseInt(stringValue);
        }
        catch (NumberFormatException numberFormatException) {
            try {
                return Long.parseLong(stringValue);
            }
            catch (NumberFormatException numberFormatException2) {
                try {
                    return new BigInteger(stringValue);
                }
                catch (NumberFormatException numberFormatException3) {
                    try {
                        return Double.parseDouble(stringValue);
                    }
                    catch (NumberFormatException numberFormatException4) {
                        if ("true".equalsIgnoreCase(stringValue)) {
                            return 1;
                        }
                        if ("false".equalsIgnoreCase(stringValue)) {
                            return 0;
                        }
                        logger.warn("Could not convert '{}' to number, returning null", value);
                        return null;
                    }
                }
            }
        }
    }
}

