/*
 * Decompiled with CFR 0.152.
 */
package org.apache.metamodel.util;

import java.text.DateFormat;
import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.text.NumberFormat;
import java.text.ParseException;
import java.util.Date;
import java.util.regex.Pattern;
import org.apache.metamodel.query.QueryParameter;
import org.apache.metamodel.schema.ColumnType;
import org.apache.metamodel.util.BooleanComparator;
import org.apache.metamodel.util.CollectionUtils;
import org.apache.metamodel.util.DateUtils;
import org.apache.metamodel.util.NumberComparator;
import org.apache.metamodel.util.TimeComparator;

public final class FormatHelper {
    private static Pattern DATE_PATTERN = Pattern.compile("(?:(?:DATE *['(\"])|(?:['(\"]))?([^')\"]*)[')\"]?");
    private static Pattern TIME_PATTERN = Pattern.compile("(?:(?:TIME *['(\"])|(?:['(\"]))?([^')\"]*)[')\"]?");
    private static Pattern TIMESTAMP_PATTERN = Pattern.compile("(?:(?:TIMESTAMP *['(\"])|(?:['(\"]))?([^')\"]*)[')\"]?");

    public static NumberFormat getUiNumberFormat() {
        DecimalFormatSymbols symbols = new DecimalFormatSymbols();
        symbols.setDecimalSeparator('.');
        DecimalFormat format = new DecimalFormat("###.##", symbols);
        format.setGroupingUsed(false);
        format.setMaximumFractionDigits(Integer.MAX_VALUE);
        return format;
    }

    public static NumberFormat getSqlNumberFormat() {
        DecimalFormatSymbols symbols = new DecimalFormatSymbols();
        symbols.setDecimalSeparator('.');
        DecimalFormat format = new DecimalFormat("###.##", symbols);
        format.setGroupingUsed(false);
        format.setMaximumFractionDigits(100);
        return format;
    }

    public static String formatSqlBoolean(ColumnType columnType, boolean b) {
        if (columnType == ColumnType.BIT) {
            if (b) {
                return "1";
            }
            return "0";
        }
        if (b) {
            return "TRUE";
        }
        return "FALSE";
    }

    public static String formatSqlTime(ColumnType columnType, Date date) {
        return FormatHelper.formatSqlTime(columnType, date, true);
    }

    public static String formatSqlTime(ColumnType columnType, Date date, boolean typeCastDeclaration, String beforeDateLiteral, String afterDateLiteral) {
        String typePrefix;
        DateFormat format;
        if (columnType == null) {
            throw new IllegalArgumentException("Column type cannot be null");
        }
        if (columnType.isTimeBased()) {
            if (columnType == ColumnType.DATE) {
                format = DateUtils.createDateFormat("yyyy-MM-dd");
                typePrefix = "DATE";
            } else if (columnType == ColumnType.TIME) {
                format = DateUtils.createDateFormat("HH:mm:ss");
                typePrefix = "TIME";
            } else {
                format = DateUtils.createDateFormat("yyyy-MM-dd HH:mm:ss");
                typePrefix = "TIMESTAMP";
            }
        } else {
            throw new IllegalArgumentException("Cannot format time value of type: " + columnType);
        }
        if (typeCastDeclaration) {
            return typePrefix + " " + beforeDateLiteral + format.format(date) + afterDateLiteral;
        }
        return format.format(date);
    }

    public static String formatSqlTime(ColumnType columnType, Date date, boolean typeCastDeclaration) {
        return FormatHelper.formatSqlTime(columnType, date, typeCastDeclaration, "'", "'");
    }

    public static Date parseSqlTime(ColumnType columnType, String value) {
        String[] formats;
        if (columnType.isTimeBased()) {
            if (columnType == ColumnType.DATE) {
                value = DATE_PATTERN.matcher(value).replaceFirst("$1");
                formats = new String[]{"yyyy-MM-dd"};
            } else if (columnType == ColumnType.TIME) {
                value = TIME_PATTERN.matcher(value).replaceFirst("$1");
                formats = new String[]{"HH:mm:ss.SSS", "HH:mm:ss", "HH:mm"};
            } else {
                value = TIMESTAMP_PATTERN.matcher(value).replaceFirst("$1");
                formats = new String[]{"yyyy-MM-dd HH:mm:ss.SSS", "yyyy-MM-dd HH:mm:ss", "yyyy-MM-dd HH:mm", "yyyy-MM-dd"};
            }
        } else {
            throw new IllegalArgumentException("Cannot parse time value of type: " + columnType);
        }
        for (String format : formats) {
            try {
                DateFormat dateFormat = DateUtils.createDateFormat(format);
                return dateFormat.parse(value);
            }
            catch (ParseException parseException) {
            }
        }
        throw new IllegalArgumentException("String value '" + value + "' not parsable as a " + columnType);
    }

    public static String formatSqlValue(ColumnType columnType, Object value) {
        if (value == null) {
            return "NULL";
        }
        if (value instanceof QueryParameter) {
            return value.toString();
        }
        if (value.getClass().isArray()) {
            value = CollectionUtils.toList(value);
        }
        if (value instanceof Iterable) {
            StringBuilder sb = new StringBuilder();
            sb.append('(');
            for (Object item : (Iterable)value) {
                if (sb.length() > 1) {
                    sb.append(" , ");
                }
                sb.append(FormatHelper.formatSqlValue(columnType, item));
            }
            sb.append(')');
            return sb.toString();
        }
        if (FormatHelper.isNumber(columnType, value)) {
            NumberFormat numberFormat = FormatHelper.getSqlNumberFormat();
            Number n = NumberComparator.toNumber(value);
            if (n == null) {
                throw new IllegalStateException("Could not convert " + value + " to number");
            }
            String numberString = numberFormat.format(n);
            return numberString;
        }
        if (FormatHelper.isBoolean(columnType, value)) {
            Boolean b = BooleanComparator.toBoolean(value);
            if (b == null) {
                throw new IllegalStateException("Could not convert " + value + " to boolean");
            }
            String booleanString = FormatHelper.formatSqlBoolean(columnType, b);
            return booleanString;
        }
        if (FormatHelper.isTimeBased(columnType, value)) {
            Date date = TimeComparator.toDate(value);
            if (date == null) {
                throw new IllegalStateException("Could not convert " + value + " to date");
            }
            String timeString = FormatHelper.formatSqlTime(columnType, date);
            return timeString;
        }
        if (FormatHelper.isLiteral(columnType, value)) {
            return '\'' + value.toString() + '\'';
        }
        if (columnType == null) {
            throw new IllegalStateException("Value type not supported: " + value);
        }
        throw new IllegalStateException("Column type not supported: " + columnType);
    }

    private static boolean isTimeBased(ColumnType columnType, Object operand) {
        if (columnType == null) {
            return TimeComparator.isTimeBased(operand);
        }
        return columnType.isTimeBased();
    }

    private static boolean isBoolean(ColumnType columnType, Object operand) {
        if (columnType == null) {
            return operand instanceof Boolean;
        }
        return columnType.isBoolean();
    }

    private static boolean isNumber(ColumnType columnType, Object operand) {
        if (columnType == null) {
            return operand instanceof Number;
        }
        return columnType.isNumber();
    }

    private static boolean isLiteral(ColumnType columnType, Object operand) {
        if (columnType == null) {
            return operand instanceof String;
        }
        return columnType.isLiteral();
    }
}

