/*
 * Decompiled with CFR 0.152.
 */
package org.apache.metamodel.util;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.Flushable;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PushbackInputStream;
import java.io.Reader;
import java.io.Writer;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.nio.charset.Charset;
import org.apache.metamodel.util.Resource;
import org.apache.metamodel.util.UnicodeWriter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class FileHelper {
    private static final Logger logger = LoggerFactory.getLogger(FileHelper.class);
    public static final String UTF_8_ENCODING = "UTF-8";
    public static final String UTF_16_ENCODING = "UTF-16";
    public static final String US_ASCII_ENCODING = "US-ASCII";
    public static final String ISO_8859_1_ENCODING = "ISO_8859_1";
    public static final String DEFAULT_ENCODING = "UTF-8";
    public static final Charset UTF_8_CHARSET = Charset.forName("UTF-8");
    public static final Charset UTF_16_CHARSET = Charset.forName("UTF-16");
    public static final Charset US_ASCII_CHARSET = Charset.forName("US-ASCII");
    public static final Charset ISO_8859_1_CHARSET = Charset.forName("ISO_8859_1");
    public static final Charset DEFAULT_CHARSET = Charset.forName("UTF-8");

    private FileHelper() {
    }

    public static File createTempFile(String prefix, String suffix) {
        try {
            return File.createTempFile(prefix, suffix);
        }
        catch (IOException e) {
            logger.error("Could not create tempFile", (Throwable)e);
            File tempDir = FileHelper.getTempDir();
            return new File(tempDir, prefix + '.' + suffix);
        }
    }

    public static File getTempDir() {
        File result = null;
        String tmpDirPath = System.getProperty("java.io.tmpdir");
        if (tmpDirPath != null && !"".equals(tmpDirPath)) {
            result = new File(tmpDirPath);
        } else {
            logger.debug("Could not determine tmpdir by using environment variable.");
            try {
                File file = File.createTempFile("foo", "bar");
                result = file.getParentFile();
                if (!file.delete()) {
                    logger.warn("Could not delete temp file '{}'", (Object)file.getAbsolutePath());
                }
            }
            catch (IOException e) {
                logger.error("Could not create tempFile in order to find temporary dir", (Throwable)e);
                result = new File("metamodel.tmp.dir");
                if (!result.mkdir()) {
                    throw new IllegalStateException("Could not create directory for temporary files: " + result.getName());
                }
                result.deleteOnExit();
            }
        }
        if (logger.isInfoEnabled()) {
            logger.info("Using '{}' as tmpdir.", (Object)result.getAbsolutePath());
        }
        return result;
    }

    public static Writer getWriter(File file, Charset charset, boolean append) throws IllegalStateException {
        boolean insertBom = !append;
        return FileHelper.getWriter(file, charset, append, insertBom);
    }

    public static Writer getWriter(File file, String encoding, boolean append) throws IllegalStateException {
        boolean insertBom = !append;
        return FileHelper.getWriter(file, encoding, append, insertBom);
    }

    public static Writer getWriter(OutputStream outputStream, String encoding) throws IllegalStateException {
        return FileHelper.getWriter(outputStream, encoding, false);
    }

    public static Writer getWriter(OutputStream outputStream, Charset charset, boolean insertBom) throws IllegalStateException {
        if (!(outputStream instanceof BufferedOutputStream)) {
            outputStream = new BufferedOutputStream(outputStream);
        }
        try {
            if (insertBom) {
                UnicodeWriter writer = new UnicodeWriter(outputStream, charset);
                return writer;
            }
            OutputStreamWriter writer = new OutputStreamWriter(outputStream, charset);
            return writer;
        }
        catch (Exception e) {
            throw new IllegalStateException(e);
        }
    }

    public static Writer getWriter(OutputStream outputStream, String encoding, boolean insertBom) throws IllegalStateException {
        return FileHelper.getWriter(outputStream, Charset.forName(encoding), insertBom);
    }

    public static Writer getWriter(File file, Charset charset, boolean append, boolean insertBom) throws IllegalStateException {
        if (append && insertBom) {
            throw new IllegalArgumentException("Can not insert BOM into appending writer");
        }
        OutputStream outputStream = FileHelper.getOutputStream(file, append);
        return FileHelper.getWriter(outputStream, charset, insertBom);
    }

    public static Writer getWriter(File file, String encoding, boolean append, boolean insertBom) throws IllegalStateException {
        return FileHelper.getWriter(file, Charset.forName(encoding), append, insertBom);
    }

    public static Writer getWriter(File file, Charset charset) throws IllegalStateException {
        return FileHelper.getWriter(file, charset, false);
    }

    public static Writer getWriter(File file, String encoding) throws IllegalStateException {
        return FileHelper.getWriter(file, encoding, false);
    }

    public static Reader getReader(InputStream inputStream, String encoding) throws IllegalStateException {
        return FileHelper.getReader(inputStream, Charset.forName(encoding));
    }

    public static Reader getReader(InputStream inputStream, Charset charset) throws IllegalStateException {
        try {
            if (charset == null || charset.name().toLowerCase().indexOf("utf") != -1) {
                int unread;
                byte[] bom = new byte[4];
                PushbackInputStream pushbackInputStream = new PushbackInputStream(inputStream, bom.length);
                int n = pushbackInputStream.read(bom, 0, bom.length);
                if (bom[0] == -17 && bom[1] == -69 && bom[2] == -65) {
                    charset = UTF_8_CHARSET;
                    unread = n - 3;
                } else if (bom[0] == -2 && bom[1] == -1) {
                    charset = Charset.forName("UTF-16BE");
                    unread = n - 2;
                } else if (bom[0] == -1 && bom[1] == -2) {
                    charset = Charset.forName("UTF-16LE");
                    unread = n - 2;
                } else if (bom[0] == 0 && bom[1] == 0 && bom[2] == -2 && bom[3] == -1) {
                    charset = Charset.forName("UTF-32BE");
                    unread = n - 4;
                } else if (bom[0] == -1 && bom[1] == -2 && bom[2] == 0 && bom[3] == 0) {
                    charset = Charset.forName("UTF-32LE");
                    unread = n - 4;
                } else {
                    unread = n;
                }
                if (unread > 0) {
                    pushbackInputStream.unread(bom, n - unread, unread);
                } else if (unread < -1) {
                    pushbackInputStream.unread(bom, 0, 0);
                }
                inputStream = pushbackInputStream;
            }
            InputStreamReader inputStreamReader = charset == null ? new InputStreamReader(inputStream) : new InputStreamReader(inputStream, charset);
            return inputStreamReader;
        }
        catch (IOException e) {
            throw new IllegalStateException(e);
        }
    }

    public static Reader getReader(File file, Charset charset) throws IllegalStateException {
        BufferedInputStream inputStream;
        try {
            inputStream = new BufferedInputStream(new FileInputStream(file));
        }
        catch (IOException e) {
            throw new IllegalStateException(e);
        }
        return FileHelper.getReader((InputStream)inputStream, charset);
    }

    public static Reader getReader(File file, String encoding) throws IllegalStateException {
        BufferedInputStream inputStream;
        try {
            inputStream = new BufferedInputStream(new FileInputStream(file));
        }
        catch (IOException e) {
            throw new IllegalStateException(e);
        }
        return FileHelper.getReader((InputStream)inputStream, encoding);
    }

    public static String readInputStreamAsString(InputStream inputStream, Charset charset) throws IllegalStateException {
        Reader reader = FileHelper.getReader(inputStream, charset);
        return FileHelper.readAsString(reader);
    }

    public static String readInputStreamAsString(InputStream inputStream, String encoding) throws IllegalStateException {
        Reader reader = FileHelper.getReader(inputStream, encoding);
        return FileHelper.readAsString(reader);
    }

    public static String readFileAsString(File file, Charset charset) throws IllegalStateException {
        Reader br = FileHelper.getReader(file, charset);
        return FileHelper.readAsString(br);
    }

    public static String readFileAsString(File file, String encoding) throws IllegalStateException {
        Reader br = FileHelper.getReader(file, encoding);
        return FileHelper.readAsString(br);
    }

    public static String readAsString(Reader reader) throws IllegalStateException {
        String string;
        BufferedReader br = FileHelper.getBufferedReader(reader);
        try {
            StringBuilder sb = new StringBuilder();
            boolean firstLine = true;
            String line = br.readLine();
            while (line != null) {
                if (firstLine) {
                    firstLine = false;
                } else {
                    sb.append('\n');
                }
                sb.append(line);
                line = br.readLine();
            }
            string = sb.toString();
        }
        catch (Exception e) {
            try {
                throw new IllegalStateException(e);
            }
            catch (Throwable throwable) {
                FileHelper.safeClose(br, reader);
                throw throwable;
            }
        }
        FileHelper.safeClose(br, reader);
        return string;
    }

    public static void safeClose(Object ... objects) {
        boolean debugEnabled = logger.isDebugEnabled();
        if (objects == null || objects.length == 0) {
            logger.info("safeClose(...) was invoked with null or empty array: {}", objects);
            return;
        }
        for (Object obj : objects) {
            block13: {
                if (obj == null) continue;
                if (debugEnabled) {
                    logger.debug("Trying to safely close {}", obj);
                }
                if (obj instanceof Flushable) {
                    try {
                        ((Flushable)obj).flush();
                    }
                    catch (Exception e) {
                        if (!debugEnabled) break block13;
                        logger.debug("Flushing Flushable failed", (Throwable)e);
                    }
                }
            }
            if (obj instanceof AutoCloseable) {
                try {
                    ((AutoCloseable)obj).close();
                }
                catch (Exception e) {
                    if (!debugEnabled) continue;
                    logger.debug("Closing AutoCloseable failed", (Throwable)e);
                }
                continue;
            }
            logger.info("obj was not AutoCloseable, trying to find close() method via reflection.");
            try {
                Method method = obj.getClass().getMethod("close", new Class[0]);
                if (method == null) {
                    logger.info("obj did not have a close() method, ignoring");
                    continue;
                }
                method.setAccessible(true);
                method.invoke(obj, new Object[0]);
            }
            catch (InvocationTargetException e) {
                logger.warn("Invoking close() by reflection threw exception", (Throwable)e);
            }
            catch (Exception e) {
                logger.warn("Could not invoke close() by reflection", (Throwable)e);
            }
        }
    }

    public static BufferedWriter getBufferedWriter(File file, Charset charset) throws IllegalStateException {
        Writer writer = FileHelper.getWriter(file, charset);
        return new BufferedWriter(writer);
    }

    public static BufferedWriter getBufferedWriter(File file, String encoding) throws IllegalStateException {
        Writer writer = FileHelper.getWriter(file, encoding);
        return new BufferedWriter(writer);
    }

    public static BufferedReader getBufferedReader(File file, Charset charset) throws IllegalStateException {
        Reader reader = FileHelper.getReader(file, charset);
        return new BufferedReader(reader);
    }

    public static BufferedReader getBufferedReader(File file, String encoding) throws IllegalStateException {
        Reader reader = FileHelper.getReader(file, encoding);
        return new BufferedReader(reader);
    }

    public static BufferedReader getBufferedReader(InputStream inputStream, Charset charset) throws IllegalStateException {
        Reader reader = FileHelper.getReader(inputStream, charset);
        return new BufferedReader(reader);
    }

    public static BufferedReader getBufferedReader(InputStream inputStream, String encoding) throws IllegalStateException {
        Reader reader = FileHelper.getReader(inputStream, encoding);
        return new BufferedReader(reader);
    }

    public static Reader getReader(File file) throws IllegalStateException {
        return FileHelper.getReader(file, "UTF-8");
    }

    public static String readFileAsString(File file) throws IllegalStateException {
        return FileHelper.readFileAsString(file, "UTF-8");
    }

    public static BufferedWriter getBufferedWriter(File file) throws IllegalStateException {
        return FileHelper.getBufferedWriter(file, "UTF-8");
    }

    public static Writer getWriter(File file) throws IllegalStateException {
        return FileHelper.getWriter(file, "UTF-8");
    }

    public static void writeString(OutputStream outputStream, String string) throws IllegalStateException {
        try (Writer writer = FileHelper.getWriter(outputStream, "UTF-8");){
            writer.write(string);
        }
        catch (IOException e) {
            throw new IllegalStateException(e);
        }
    }

    public static void writeStringAsFile(File file, String string) throws IllegalStateException {
        FileHelper.writeStringAsFile(file, string, "UTF-8");
    }

    public static void writeStringAsFile(File file, String string, String encoding) throws IllegalStateException {
        FileHelper.writeStringAsFile(file, string, Charset.forName(encoding));
    }

    public static void writeStringAsFile(File file, String string, Charset charset) throws IllegalStateException {
        try (BufferedWriter bw = FileHelper.getBufferedWriter(file, charset);){
            bw.write(string);
        }
        catch (IOException e) {
            throw new IllegalStateException(e);
        }
    }

    public static BufferedReader getBufferedReader(File file) throws IllegalStateException {
        return FileHelper.getBufferedReader(file, "UTF-8");
    }

    public static void copy(Reader reader, Writer writer) throws IllegalStateException {
        BufferedReader bufferedReader = FileHelper.getBufferedReader(reader);
        try {
            boolean firstLine = true;
            String line = bufferedReader.readLine();
            while (line != null) {
                if (firstLine) {
                    firstLine = false;
                } else {
                    writer.write(10);
                }
                writer.write(line);
                line = bufferedReader.readLine();
            }
        }
        catch (IOException e) {
            throw new IllegalStateException(e);
        }
    }

    public static BufferedReader getBufferedReader(Reader reader) {
        if (reader instanceof BufferedReader) {
            return (BufferedReader)reader;
        }
        return new BufferedReader(reader);
    }

    public static void copy(InputStream fromStream, OutputStream toStream) throws IllegalStateException {
        try {
            byte[] buffer = new byte[32768];
            int read = fromStream.read(buffer);
            while (read != -1) {
                toStream.write(buffer, 0, read);
                read = fromStream.read(buffer);
            }
        }
        catch (IOException e) {
            throw new IllegalStateException(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void copy(Resource from, Resource to) throws IllegalStateException {
        assert (from.isExists());
        InputStream in = from.read();
        try {
            OutputStream out = to.write();
            try {
                FileHelper.copy(in, out);
            }
            catch (Throwable throwable) {
                FileHelper.safeClose(out);
                throw throwable;
            }
            FileHelper.safeClose(out);
        }
        catch (Throwable throwable) {
            FileHelper.safeClose(in);
            throw throwable;
        }
        FileHelper.safeClose(in);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void copy(File from, File to) throws IllegalStateException {
        assert (from.exists());
        InputStream in = FileHelper.getInputStream(from);
        try {
            OutputStream out = FileHelper.getOutputStream(to);
            try {
                FileHelper.copy(in, out);
            }
            catch (Throwable throwable) {
                FileHelper.safeClose(out);
                throw throwable;
            }
            FileHelper.safeClose(out);
        }
        catch (Throwable throwable) {
            FileHelper.safeClose(in);
            throw throwable;
        }
        FileHelper.safeClose(in);
    }

    public static OutputStream getOutputStream(File file) throws IllegalStateException {
        return FileHelper.getOutputStream(file, false);
    }

    public static OutputStream getOutputStream(File file, boolean append) {
        try {
            return new BufferedOutputStream(new FileOutputStream(file, append));
        }
        catch (FileNotFoundException e) {
            throw new IllegalStateException(e);
        }
    }

    public static InputStream getInputStream(File file) throws IllegalStateException {
        try {
            return new BufferedInputStream(new FileInputStream(file));
        }
        catch (FileNotFoundException e) {
            throw new IllegalStateException(e);
        }
    }

    public static byte[] readAsBytes(InputStream inputStream) {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        try {
            FileHelper.copy(inputStream, baos);
        }
        catch (Throwable throwable) {
            FileHelper.safeClose(inputStream);
            throw throwable;
        }
        FileHelper.safeClose(inputStream);
        return baos.toByteArray();
    }
}

