/*
 * Decompiled with CFR 0.152.
 */
package org.apache.metamodel.util;

import java.io.InputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.net.URL;
import org.apache.metamodel.util.AbstractResource;
import org.apache.metamodel.util.ResourceException;
import org.apache.metamodel.util.UrlResource;

public class ClasspathResource
extends AbstractResource
implements Serializable {
    private static final long serialVersionUID = 1L;
    private final String _resourcePath;

    public ClasspathResource(String resourcePath) {
        if (resourcePath == null) {
            throw new IllegalArgumentException("Classpath resource path cannot be null");
        }
        this._resourcePath = resourcePath;
    }

    @Override
    public String toString() {
        return "ClasspathResource[" + this._resourcePath + "]";
    }

    public String getResourcePath() {
        return this._resourcePath;
    }

    @Override
    public String getName() {
        String lastPart;
        int lastBackSlash;
        String name = this._resourcePath;
        int lastSlash = name.lastIndexOf(47);
        int lastIndex = Math.max(lastSlash, lastBackSlash = name.lastIndexOf(92));
        if (lastIndex != -1 && !"".equals(lastPart = name.substring(lastIndex + 1))) {
            return lastPart;
        }
        return name;
    }

    @Override
    public String getQualifiedPath() {
        return this._resourcePath;
    }

    protected ClassLoader getClassLoader() {
        return ClassLoader.getSystemClassLoader();
    }

    private UrlResource getUrlResourceDelegate() {
        ClassLoader classLoader = this.getClassLoader();
        URL url = classLoader.getResource(this._resourcePath);
        if (url == null && this._resourcePath.startsWith("/")) {
            url = classLoader.getResource(this._resourcePath.substring(1));
        }
        if (url == null) {
            return null;
        }
        return new UrlResource(url);
    }

    @Override
    public OutputStream append() throws ResourceException {
        return this.getUrlResourceDelegate().append();
    }

    @Override
    public OutputStream write() throws ResourceException {
        return this.getUrlResourceDelegate().write();
    }

    @Override
    public boolean isReadOnly() {
        return true;
    }

    @Override
    public boolean isExists() {
        UrlResource delegate = this.getUrlResourceDelegate();
        if (delegate == null) {
            return false;
        }
        return delegate.isExists();
    }

    @Override
    public long getSize() {
        UrlResource delegate = this.getUrlResourceDelegate();
        if (delegate == null) {
            return -1L;
        }
        return delegate.getSize();
    }

    @Override
    public long getLastModified() {
        UrlResource delegate = this.getUrlResourceDelegate();
        if (delegate == null) {
            return -1L;
        }
        return delegate.getLastModified();
    }

    @Override
    public InputStream read() throws ResourceException {
        return this.getUrlResourceDelegate().read();
    }
}

