/*
 * Decompiled with CFR 0.152.
 */
package org.apache.metamodel.schema.builder;

import org.apache.metamodel.convert.DocumentConverter;
import org.apache.metamodel.data.Document;
import org.apache.metamodel.data.DocumentSource;
import org.apache.metamodel.schema.Table;
import org.apache.metamodel.schema.builder.ColumnNameAsKeysRowConverter;
import org.apache.metamodel.schema.builder.DocumentSourceProvider;
import org.apache.metamodel.schema.builder.InferentialSchemaBuilder;
import org.apache.metamodel.util.Resource;
import org.apache.metamodel.util.ResourceUtils;

public class SingleTableInferentialSchemaBuilder
extends InferentialSchemaBuilder {
    private final String _tableName;

    public SingleTableInferentialSchemaBuilder(Resource resource) {
        this(ResourceUtils.getParentName(resource), resource.getName());
    }

    public SingleTableInferentialSchemaBuilder(String schemaName, String tableName) {
        super(schemaName);
        this._tableName = tableName;
    }

    @Override
    public void offerSources(DocumentSourceProvider documentSourceProvider) {
        DocumentSource documentSource = documentSourceProvider.getMixedDocumentSourceForSampling();
        this.getTableBuilder(this._tableName).offerSource(documentSource);
    }

    @Override
    protected String determineTable(Document document) {
        return this._tableName;
    }

    @Override
    public DocumentConverter getDocumentConverter(Table table) {
        return new ColumnNameAsKeysRowConverter();
    }
}

