/*
 * Decompiled with CFR 0.152.
 */
package org.apache.metamodel.schema.builder;

import java.util.TreeSet;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import org.apache.metamodel.data.Document;
import org.apache.metamodel.data.DocumentSource;
import org.apache.metamodel.schema.MutableSchema;
import org.apache.metamodel.schema.MutableTable;
import org.apache.metamodel.schema.builder.DocumentSourceProvider;
import org.apache.metamodel.schema.builder.InferentialTableBuilder;
import org.apache.metamodel.schema.builder.SchemaBuilder;

public abstract class InferentialSchemaBuilder
implements SchemaBuilder {
    private final ConcurrentMap<String, InferentialTableBuilder> _tableBuilders;
    private final String _schemaName;

    public InferentialSchemaBuilder(String schemaName) {
        this._schemaName = schemaName;
        this._tableBuilders = new ConcurrentHashMap<String, InferentialTableBuilder>();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void offerSources(DocumentSourceProvider documentSourceProvider) {
        try (DocumentSource documentSource = documentSourceProvider.getMixedDocumentSourceForSampling();){
            Document document;
            while ((document = documentSource.next()) != null) {
                String tableName = this.determineTable(document);
                this.addObservation(tableName, document);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void offerDocumentSource(DocumentSource documentSource) {
        try {
            Document document;
            while ((document = documentSource.next()) != null) {
                String tableName = this.determineTable(document);
                this.addObservation(tableName, document);
            }
        }
        finally {
            documentSource.close();
        }
    }

    @Override
    public String getSchemaName() {
        return this._schemaName;
    }

    protected abstract String determineTable(Document var1);

    public void addObservation(String table, Document document) {
        InferentialTableBuilder tableBuilder = this.getTableBuilder(table);
        tableBuilder.addObservation(document);
    }

    public InferentialTableBuilder getTableBuilder(String table) {
        InferentialTableBuilder existingTableBuilder;
        InferentialTableBuilder tableBuilder = (InferentialTableBuilder)this._tableBuilders.get(table);
        if (tableBuilder == null && (existingTableBuilder = this._tableBuilders.putIfAbsent(table, tableBuilder = new InferentialTableBuilder(table))) != null) {
            tableBuilder = existingTableBuilder;
        }
        return tableBuilder;
    }

    @Override
    public MutableSchema build() {
        MutableSchema schema = new MutableSchema(this._schemaName);
        TreeSet tableNames = new TreeSet(this._tableBuilders.keySet());
        for (String tableName : tableNames) {
            MutableTable table = this.buildTable(this.getTableBuilder(tableName));
            table.setSchema(schema);
            schema.addTable(table);
        }
        return schema;
    }

    protected MutableTable buildTable(InferentialTableBuilder tableBuilder) {
        return tableBuilder.buildTable();
    }
}

