/*
 * Decompiled with CFR 0.152.
 */
package org.apache.metamodel.schema;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.apache.metamodel.schema.AbstractRelationship;
import org.apache.metamodel.schema.Column;
import org.apache.metamodel.schema.MutableTable;
import org.apache.metamodel.schema.Relationship;
import org.apache.metamodel.schema.Table;
import org.apache.metamodel.util.LegacyDeserializationObjectInputStream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MutableRelationship
extends AbstractRelationship
implements Serializable,
Relationship {
    private static final long serialVersionUID = 238786848828528822L;
    private static final Logger logger = LoggerFactory.getLogger(MutableRelationship.class);
    private final List<Column> _primaryColumns;
    private final List<Column> _foreignColumns;

    public static Relationship createRelationship(List<Column> primaryColumns, List<Column> foreignColumns) {
        Table primaryTable = MutableRelationship.checkSameTable(primaryColumns);
        Table foreignTable = MutableRelationship.checkSameTable(foreignColumns);
        MutableRelationship relation = new MutableRelationship(primaryColumns, foreignColumns);
        if (primaryTable instanceof MutableTable) {
            try {
                ((MutableTable)primaryTable).addRelationship(relation);
            }
            catch (UnsupportedOperationException e) {
                logger.debug("primary table ({}) threw exception when adding relationship", (Object)primaryTable);
            }
            if (foreignTable != primaryTable && foreignTable instanceof MutableTable) {
                try {
                    ((MutableTable)foreignTable).addRelationship(relation);
                }
                catch (UnsupportedOperationException e) {
                    logger.debug("foreign table ({}) threw exception when adding relationship", (Object)foreignTable);
                }
            }
        }
        return relation;
    }

    public void remove() {
        Table foreignTable;
        Table primaryTable = this.getPrimaryTable();
        if (primaryTable instanceof MutableTable) {
            ((MutableTable)primaryTable).removeRelationship(this);
        }
        if ((foreignTable = this.getForeignTable()) instanceof MutableTable) {
            ((MutableTable)foreignTable).removeRelationship(this);
        }
    }

    public static Relationship createRelationship(Column primaryColumn, Column foreignColumn) {
        ArrayList<Column> pcols = new ArrayList<Column>();
        pcols.add(primaryColumn);
        ArrayList<Column> fcols = new ArrayList<Column>();
        fcols.add(foreignColumn);
        return MutableRelationship.createRelationship(pcols, fcols);
    }

    private MutableRelationship(List<Column> primaryColumns, List<Column> foreignColumns) {
        this._primaryColumns = primaryColumns;
        this._foreignColumns = foreignColumns;
    }

    @Override
    public List<Column> getPrimaryColumns() {
        return this._primaryColumns;
    }

    @Override
    public List<Column> getForeignColumns() {
        return this._foreignColumns;
    }

    private void readObject(ObjectInputStream stream) throws IOException, ClassNotFoundException {
        ObjectInputStream.GetField getFields = stream.readFields();
        List<Column> primaryColumns = getFields.get("_primaryColumns", null);
        List<Column> foreignColumns = getFields.get("_foreignColumns", null);
        if (primaryColumns instanceof Column[] && foreignColumns instanceof Column[]) {
            primaryColumns = Arrays.asList((Column[])primaryColumns);
            foreignColumns = Arrays.asList((Column[])foreignColumns);
        }
        LegacyDeserializationObjectInputStream.setField(MutableRelationship.class, this, "_primaryColumns", primaryColumns);
        LegacyDeserializationObjectInputStream.setField(MutableRelationship.class, this, "_foreignColumns", foreignColumns);
    }
}

