/*
 * Decompiled with CFR 0.152.
 */
package org.apache.metamodel.schema;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.apache.metamodel.schema.AbstractSchema;
import org.apache.metamodel.schema.ImmutableRelationship;
import org.apache.metamodel.schema.ImmutableTable;
import org.apache.metamodel.schema.Relationship;
import org.apache.metamodel.schema.Schema;
import org.apache.metamodel.schema.Table;

public final class ImmutableSchema
extends AbstractSchema
implements Serializable {
    private static final long serialVersionUID = 1L;
    private final List<ImmutableTable> tables = new ArrayList<ImmutableTable>();
    private String name;
    private String quote;

    private ImmutableSchema(String name, String quote) {
        this.name = name;
        this.quote = quote;
    }

    public ImmutableSchema(Schema schema) {
        this(schema.getName(), schema.getQuote());
        List<Table> origTables = schema.getTables();
        for (Table table : origTables) {
            this.tables.add(new ImmutableTable(table, this));
        }
        Collection<Relationship> origRelationships = schema.getRelationships();
        for (Relationship relationship : origRelationships) {
            ImmutableRelationship.create(relationship, this);
        }
    }

    @Override
    public List<Table> getTables() {
        return Collections.unmodifiableList(this.tables);
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public String getQuote() {
        return this.quote;
    }
}

