/*
 * Decompiled with CFR 0.152.
 */
package org.apache.metamodel.schema;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.Serializable;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.metamodel.schema.AbstractRelationship;
import org.apache.metamodel.schema.Column;
import org.apache.metamodel.schema.ImmutableSchema;
import org.apache.metamodel.schema.ImmutableTable;
import org.apache.metamodel.schema.Relationship;
import org.apache.metamodel.schema.Table;
import org.apache.metamodel.util.LegacyDeserializationObjectInputStream;

public final class ImmutableRelationship
extends AbstractRelationship
implements Serializable {
    private static final long serialVersionUID = 1L;
    private final List<Column> primaryColumns;
    private final List<Column> foreignColumns;

    public static void create(Relationship origRelationship, ImmutableSchema schema) {
        ImmutableTable primaryTable = ImmutableRelationship.getSimilarTable(origRelationship.getPrimaryTable(), schema);
        assert (primaryTable != null);
        List<Column> primaryColumns = ImmutableRelationship.getSimilarColumns(origRelationship.getPrimaryColumns(), primaryTable);
        ImmutableRelationship.checkSameTable(primaryColumns);
        ImmutableTable foreignTable = ImmutableRelationship.getSimilarTable(origRelationship.getForeignTable(), schema);
        assert (foreignTable != null);
        List<Column> foreignColumns = ImmutableRelationship.getSimilarColumns(origRelationship.getForeignColumns(), foreignTable);
        ImmutableRelationship.checkSameTable(foreignColumns);
        ImmutableRelationship relationship = new ImmutableRelationship(primaryColumns, foreignColumns);
        primaryTable.addRelationship(relationship);
        foreignTable.addRelationship(relationship);
    }

    private static List<Column> getSimilarColumns(List<Column> columns, Table table) {
        return columns.stream().map(col -> table.getColumnByName(col.getName())).collect(Collectors.toList());
    }

    private static ImmutableTable getSimilarTable(Table table, ImmutableSchema schema) {
        String name = table.getName();
        return (ImmutableTable)schema.getTableByName(name);
    }

    private ImmutableRelationship(List<Column> primaryColumns, List<Column> foreignColumns) {
        this.primaryColumns = primaryColumns;
        this.foreignColumns = foreignColumns;
    }

    @Override
    public List<Column> getPrimaryColumns() {
        return this.primaryColumns;
    }

    @Override
    public List<Column> getForeignColumns() {
        return this.foreignColumns;
    }

    private void readObject(ObjectInputStream stream) throws IOException, ClassNotFoundException {
        ObjectInputStream.GetField getFields = stream.readFields();
        List<Column> primaryColumns = getFields.get("primaryColumns", null);
        List<Column> foreignColumns = getFields.get("foreignColumns", null);
        if (primaryColumns instanceof Column[] && foreignColumns instanceof Column[]) {
            primaryColumns = Arrays.asList((Column[])primaryColumns);
            foreignColumns = Arrays.asList((Column[])foreignColumns);
        }
        LegacyDeserializationObjectInputStream.setField(ImmutableRelationship.class, this, "primaryColumns", primaryColumns);
        LegacyDeserializationObjectInputStream.setField(ImmutableRelationship.class, this, "foreignColumns", foreignColumns);
    }
}

