/*
 * Decompiled with CFR 0.152.
 */
package org.apache.metamodel.schema;

import java.io.Serializable;
import org.apache.metamodel.schema.AbstractColumn;
import org.apache.metamodel.schema.Column;
import org.apache.metamodel.schema.ColumnType;
import org.apache.metamodel.schema.ImmutableTable;
import org.apache.metamodel.schema.Table;

public final class ImmutableColumn
extends AbstractColumn
implements Serializable {
    private static final long serialVersionUID = 1L;
    private final int columnNumber;
    private final ColumnType type;
    private final Table table;
    private final Boolean nullable;
    private final String remarks;
    private final Integer columnSize;
    private final Integer decimalDigits;
    private final String nativeType;
    private final boolean indexed;
    private final boolean primaryKey;
    private final String name;
    private final String quote;

    public ImmutableColumn(String name, ColumnType type, Table table, int columnNumber, Integer columnSize, String nativeType, Boolean nullable, String remarks, boolean indexed, String quote, boolean primaryKey) {
        this(name, type, table, columnNumber, columnSize, null, nativeType, nullable, remarks, indexed, quote, primaryKey);
    }

    public ImmutableColumn(String name, ColumnType type, Table table, int columnNumber, Integer columnSize, Integer decimalDigits, String nativeType, Boolean nullable, String remarks, boolean indexed, String quote, boolean primaryKey) {
        this.name = name;
        this.type = type;
        this.table = table;
        this.columnNumber = columnNumber;
        this.columnSize = columnSize;
        this.decimalDigits = decimalDigits;
        this.nativeType = nativeType;
        this.nullable = nullable;
        this.remarks = remarks;
        this.indexed = indexed;
        this.quote = quote;
        this.primaryKey = primaryKey;
    }

    public ImmutableColumn(Column column, Table table) {
        this.name = column.getName();
        this.type = column.getType();
        this.table = table;
        this.columnNumber = column.getColumnNumber();
        this.columnSize = column.getColumnSize();
        this.decimalDigits = column.getDecimalDigits();
        this.nativeType = column.getNativeType();
        this.nullable = column.isNullable();
        this.remarks = column.getRemarks();
        this.indexed = column.isIndexed();
        this.quote = column.getQuote();
        this.primaryKey = column.isPrimaryKey();
    }

    protected ImmutableColumn(Column column, ImmutableTable table) {
        this(column.getName(), column.getType(), table, column.getColumnNumber(), column.getColumnSize(), column.getDecimalDigits(), column.getNativeType(), column.isNullable(), column.getRemarks(), column.isIndexed(), column.getQuote(), column.isPrimaryKey());
    }

    @Override
    public int getColumnNumber() {
        return this.columnNumber;
    }

    @Override
    public ColumnType getType() {
        return this.type;
    }

    @Override
    public Table getTable() {
        return this.table;
    }

    @Override
    public Boolean isNullable() {
        return this.nullable;
    }

    @Override
    public String getRemarks() {
        return this.remarks;
    }

    @Override
    public Integer getColumnSize() {
        return this.columnSize;
    }

    @Override
    public Integer getDecimalDigits() {
        return this.decimalDigits;
    }

    @Override
    public String getNativeType() {
        return this.nativeType;
    }

    @Override
    public boolean isIndexed() {
        return this.indexed;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public boolean isPrimaryKey() {
        return this.primaryKey;
    }

    @Override
    public String getQuote() {
        return this.quote;
    }
}

