/*
 * Decompiled with CFR 0.152.
 */
package org.apache.metamodel.schema;

import java.lang.reflect.Field;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.net.InetAddress;
import java.sql.Date;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import org.apache.metamodel.schema.ColumnType;
import org.apache.metamodel.schema.JdbcTypes;
import org.apache.metamodel.schema.SuperColumnType;
import org.apache.metamodel.util.NumberComparator;
import org.apache.metamodel.util.ObjectComparator;
import org.apache.metamodel.util.TimeComparator;
import org.apache.metamodel.util.ToStringComparator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ColumnTypeImpl
implements ColumnType {
    private static final long serialVersionUID = 1L;
    public static final Logger logger = LoggerFactory.getLogger(ColumnTypeImpl.class);
    private final String _name;
    private final SuperColumnType _superColumnType;
    private final Class<?> _javaType;
    private final boolean _largeObject;

    public ColumnTypeImpl(String name, SuperColumnType superColumnType) {
        this(name, superColumnType, null);
    }

    public ColumnTypeImpl(String name, SuperColumnType superColumnType, Class<?> javaType) {
        this(name, superColumnType, javaType, false);
    }

    public ColumnTypeImpl(String name, SuperColumnType superColumnType, Class<?> javaType, boolean largeObject) {
        if (name == null) {
            throw new IllegalArgumentException("Name cannot be null");
        }
        if (superColumnType == null) {
            throw new IllegalArgumentException("SuperColumnType cannot be null");
        }
        this._name = name;
        this._superColumnType = superColumnType;
        this._javaType = javaType == null ? superColumnType.getJavaEquivalentClass() : javaType;
        this._largeObject = largeObject;
    }

    @Override
    public String getName() {
        return this._name;
    }

    @Override
    public Comparator<Object> getComparator() {
        if (this.isTimeBased()) {
            return TimeComparator.getComparator();
        }
        if (this.isNumber()) {
            return NumberComparator.getComparator();
        }
        if (this.isLiteral()) {
            return ToStringComparator.getComparator();
        }
        return ObjectComparator.getComparator();
    }

    @Override
    public boolean isBoolean() {
        return this._superColumnType == SuperColumnType.BOOLEAN_TYPE;
    }

    @Override
    public boolean isBinary() {
        return this._superColumnType == SuperColumnType.BINARY_TYPE;
    }

    @Override
    public boolean isNumber() {
        return this._superColumnType == SuperColumnType.NUMBER_TYPE;
    }

    @Override
    public boolean isTimeBased() {
        return this._superColumnType == SuperColumnType.TIME_TYPE;
    }

    @Override
    public boolean isLiteral() {
        return this._superColumnType == SuperColumnType.LITERAL_TYPE;
    }

    @Override
    public boolean isLargeObject() {
        return this._largeObject;
    }

    @Override
    public Class<?> getJavaEquivalentClass() {
        return this._javaType;
    }

    @Override
    public SuperColumnType getSuperType() {
        return this._superColumnType;
    }

    @Override
    public int getJdbcType() throws IllegalStateException {
        String name = this.toString();
        try {
            Field[] fields = JdbcTypes.class.getFields();
            for (int i = 0; i < fields.length; ++i) {
                Field field = fields[i];
                String fieldName = field.getName();
                if (!fieldName.equals(name)) continue;
                int value = field.getInt(null);
                return value;
            }
            throw new IllegalStateException("No JdbcType found with field name: " + name);
        }
        catch (Exception e) {
            throw new IllegalStateException("Could not access fields in JdbcTypes", e);
        }
    }

    public String toString() {
        return this._name;
    }

    public static ColumnType convertColumnType(int jdbcType) {
        try {
            Field[] fields = JdbcTypes.class.getFields();
            for (int i = 0; i < fields.length; ++i) {
                Field field = fields[i];
                int value = field.getInt(null);
                if (value != jdbcType) continue;
                String fieldName = field.getName();
                return ColumnTypeImpl.valueOf(fieldName);
            }
        }
        catch (Exception e) {
            throw new IllegalStateException("Could not access fields in JdbcTypes", e);
        }
        return OTHER;
    }

    public static ColumnType convertColumnType(Class<?> cls) {
        if (cls == null) {
            throw new IllegalArgumentException("Class cannot be null");
        }
        ColumnType type = cls == String.class ? ColumnType.STRING : (cls == Boolean.class || cls == Boolean.TYPE ? ColumnType.BOOLEAN : (cls == Character.class || cls == Character.TYPE || cls == Character[].class || cls == char[].class ? ColumnType.CHAR : (cls == Byte.class || cls == Byte.TYPE ? ColumnType.TINYINT : (cls == Short.class || cls == Short.TYPE ? ColumnType.SMALLINT : (cls == Integer.class || cls == Integer.TYPE ? ColumnType.INTEGER : (cls == Long.class || cls == Long.TYPE || cls == BigInteger.class ? ColumnType.BIGINT : (cls == Float.class || cls == Float.TYPE ? ColumnType.FLOAT : (cls == Double.class || cls == Double.TYPE ? ColumnType.DOUBLE : (cls == BigDecimal.class ? ColumnType.DECIMAL : (Number.class.isAssignableFrom(cls) ? ColumnType.NUMBER : (Map.class.isAssignableFrom(cls) ? ColumnType.MAP : (List.class.isAssignableFrom(cls) ? ColumnType.LIST : (Set.class.isAssignableFrom(cls) ? ColumnType.SET : (cls == Date.class ? ColumnType.DATE : (cls == Timestamp.class ? ColumnType.TIMESTAMP : (cls == Time.class ? ColumnType.TIME : (java.util.Date.class.isAssignableFrom(cls) ? ColumnType.TIMESTAMP : (cls == UUID.class ? ColumnType.UUID : (cls == InetAddress.class ? ColumnType.INET : ColumnType.OTHER)))))))))))))))))));
        return type;
    }

    public static ColumnType valueOf(String fieldName) {
        try {
            Field columnTypeField = ColumnType.class.getField(fieldName);
            if (columnTypeField != null) {
                columnTypeField.setAccessible(true);
                Object columnType = columnTypeField.get(ColumnType.class);
                return (ColumnType)columnType;
            }
        }
        catch (Exception e) {
            logger.error("Failed to resolve JDBC type in ColumnType constants: " + fieldName, (Throwable)e);
        }
        return null;
    }
}

