/*
 * Decompiled with CFR 0.152.
 */
package org.apache.metamodel.schema;

import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.metamodel.schema.Relationship;
import org.apache.metamodel.schema.Schema;
import org.apache.metamodel.schema.Table;
import org.apache.metamodel.schema.TableType;
import org.apache.metamodel.util.EqualsBuilder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractSchema
implements Schema {
    private static final long serialVersionUID = 1L;
    private static final Logger logger = LoggerFactory.getLogger(AbstractSchema.class);

    @Override
    public final String getQuotedName() {
        String quote = this.getQuote();
        if (quote == null) {
            return this.getName();
        }
        return quote + this.getName() + quote;
    }

    @Override
    public Collection<Relationship> getRelationships() {
        return this.getTables().stream().flatMap(tab -> tab.getRelationships().stream()).collect(Collectors.toCollection(LinkedHashSet::new));
    }

    @Override
    public Table getTable(int index) throws IndexOutOfBoundsException {
        return this.getTables().get(index);
    }

    @Override
    public final String getQualifiedLabel() {
        return this.getName();
    }

    @Override
    public final int getTableCount(TableType type) {
        return this.getTables(type).size();
    }

    @Override
    public final int getRelationshipCount() {
        return this.getRelationships().size();
    }

    @Override
    public final int getTableCount() {
        return this.getTables().size();
    }

    @Override
    public final List<Table> getTables(TableType type) {
        return this.getTables().stream().filter(table -> table.getType().equals((Object)type)).collect(Collectors.toList());
    }

    @Override
    public final Table getTableByName(String tableName) {
        if (tableName == null) {
            return null;
        }
        ArrayList<Table> foundTables = new ArrayList<Table>(1);
        for (Table table : this.getTables()) {
            if (!tableName.equalsIgnoreCase(table.getName())) continue;
            foundTables.add(table);
        }
        int numTables = foundTables.size();
        if (logger.isDebugEnabled()) {
            logger.debug("Found {} tables(s) matching '{}': {}", new Object[]{numTables, tableName, foundTables});
        }
        if (numTables == 0) {
            return null;
        }
        if (numTables == 1) {
            return (Table)foundTables.get(0);
        }
        for (Table table : foundTables) {
            if (!tableName.equals(table.getName())) continue;
            return table;
        }
        return (Table)foundTables.get(0);
    }

    @Override
    public final List<String> getTableNames() {
        return this.getTables().stream().map(table -> table.getName()).collect(Collectors.toList());
    }

    public final String toString() {
        return "Schema[name=" + this.getName() + "]";
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (obj == this) {
            return true;
        }
        if (obj instanceof Schema) {
            Schema other = (Schema)obj;
            EqualsBuilder eb = new EqualsBuilder();
            eb.append(this.getName(), other.getName());
            eb.append(this.getQuote(), other.getQuote());
            if (eb.isEquals()) {
                try {
                    int tableCount1 = this.getTableCount();
                    int tableCount2 = other.getTableCount();
                    eb.append(tableCount1, tableCount2);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            return eb.isEquals();
        }
        return false;
    }

    public int hashCode() {
        String name = this.getName();
        if (name == null) {
            return -1;
        }
        return name.hashCode();
    }

    @Override
    public final int compareTo(Schema that) {
        if (this.getQualifiedLabel() == null) {
            return that.getQualifiedLabel() == null ? 0 : -1;
        }
        if (that.getQualifiedLabel() == null) {
            return 1;
        }
        int diff = this.getQualifiedLabel().compareTo(that.getQualifiedLabel());
        if (diff == 0) {
            diff = this.toString().compareTo(that.toString());
        }
        return diff;
    }
}

